// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package lnrpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// StateClient is the client API for State service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StateClient interface {
	// SubscribeState subscribes to the state of the wallet. The current wallet
	// state will always be delivered immediately.
	SubscribeState(ctx context.Context, in *SubscribeStateRequest, opts ...grpc.CallOption) (State_SubscribeStateClient, error)
	// GetState returns the current wallet state without streaming further
	// changes.
	GetState(ctx context.Context, in *GetStateRequest, opts ...grpc.CallOption) (*GetStateResponse, error)
}

type stateClient struct {
	cc grpc.ClientConnInterface
}

func NewStateClient(cc grpc.ClientConnInterface) StateClient {
	return &stateClient{cc}
}

func (c *stateClient) SubscribeState(ctx context.Context, in *SubscribeStateRequest, opts ...grpc.CallOption) (State_SubscribeStateClient, error) {
	stream, err := c.cc.NewStream(ctx, &State_ServiceDesc.Streams[0], "/lnrpc.State/SubscribeState", opts...)
	if err != nil {
		return nil, err
	}
	x := &stateSubscribeStateClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type State_SubscribeStateClient interface {
	Recv() (*SubscribeStateResponse, error)
	grpc.ClientStream
}

type stateSubscribeStateClient struct {
	grpc.ClientStream
}

func (x *stateSubscribeStateClient) Recv() (*SubscribeStateResponse, error) {
	m := new(SubscribeStateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *stateClient) GetState(ctx context.Context, in *GetStateRequest, opts ...grpc.CallOption) (*GetStateResponse, error) {
	out := new(GetStateResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.State/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StateServer is the server API for State service.
// All implementations must embed UnimplementedStateServer
// for forward compatibility
type StateServer interface {
	// SubscribeState subscribes to the state of the wallet. The current wallet
	// state will always be delivered immediately.
	SubscribeState(*SubscribeStateRequest, State_SubscribeStateServer) error
	// GetState returns the current wallet state without streaming further
	// changes.
	GetState(context.Context, *GetStateRequest) (*GetStateResponse, error)
	mustEmbedUnimplementedStateServer()
}

// UnimplementedStateServer must be embedded to have forward compatible implementations.
type UnimplementedStateServer struct {
}

func (UnimplementedStateServer) SubscribeState(*SubscribeStateRequest, State_SubscribeStateServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeState not implemented")
}
func (UnimplementedStateServer) GetState(context.Context, *GetStateRequest) (*GetStateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (UnimplementedStateServer) mustEmbedUnimplementedStateServer() {}

// UnsafeStateServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StateServer will
// result in compilation errors.
type UnsafeStateServer interface {
	mustEmbedUnimplementedStateServer()
}

func RegisterStateServer(s grpc.ServiceRegistrar, srv StateServer) {
	s.RegisterService(&State_ServiceDesc, srv)
}

func _State_SubscribeState_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SubscribeStateRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StateServer).SubscribeState(m, &stateSubscribeStateServer{stream})
}

type State_SubscribeStateServer interface {
	Send(*SubscribeStateResponse) error
	grpc.ServerStream
}

type stateSubscribeStateServer struct {
	grpc.ServerStream
}

func (x *stateSubscribeStateServer) Send(m *SubscribeStateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _State_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StateServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.State/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StateServer).GetState(ctx, req.(*GetStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// State_ServiceDesc is the grpc.ServiceDesc for State service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var State_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "lnrpc.State",
	HandlerType: (*StateServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetState",
			Handler:    _State_GetState_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SubscribeState",
			Handler:       _State_SubscribeState_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "stateservice.proto",
}
