// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v3.21.12
// source: signrpc/signer.proto

package signrpc

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SignMethod int32

const (
	// Specifies that a SegWit v0 (p2wkh, np2wkh, p2wsh) input script should be
	// signed.
	SignMethod_SIGN_METHOD_WITNESS_V0 SignMethod = 0
	// Specifies that a SegWit v1 (p2tr) input should be signed by using the
	// BIP0086 method (commit to internal key only).
	SignMethod_SIGN_METHOD_TAPROOT_KEY_SPEND_BIP0086 SignMethod = 1
	// Specifies that a SegWit v1 (p2tr) input should be signed by using a given
	// taproot hash to commit to in addition to the internal key.
	SignMethod_SIGN_METHOD_TAPROOT_KEY_SPEND SignMethod = 2
	// Specifies that a SegWit v1 (p2tr) input should be spent using the script
	// path and that a specific leaf script should be signed for.
	SignMethod_SIGN_METHOD_TAPROOT_SCRIPT_SPEND SignMethod = 3
)

// Enum value maps for SignMethod.
var (
	SignMethod_name = map[int32]string{
		0: "SIGN_METHOD_WITNESS_V0",
		1: "SIGN_METHOD_TAPROOT_KEY_SPEND_BIP0086",
		2: "SIGN_METHOD_TAPROOT_KEY_SPEND",
		3: "SIGN_METHOD_TAPROOT_SCRIPT_SPEND",
	}
	SignMethod_value = map[string]int32{
		"SIGN_METHOD_WITNESS_V0":                0,
		"SIGN_METHOD_TAPROOT_KEY_SPEND_BIP0086": 1,
		"SIGN_METHOD_TAPROOT_KEY_SPEND":         2,
		"SIGN_METHOD_TAPROOT_SCRIPT_SPEND":      3,
	}
)

func (x SignMethod) Enum() *SignMethod {
	p := new(SignMethod)
	*p = x
	return p
}

func (x SignMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SignMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_signrpc_signer_proto_enumTypes[0].Descriptor()
}

func (SignMethod) Type() protoreflect.EnumType {
	return &file_signrpc_signer_proto_enumTypes[0]
}

func (x SignMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SignMethod.Descriptor instead.
func (SignMethod) EnumDescriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{0}
}

type MuSig2Version int32

const (
	// The default value on the RPC is zero for enums so we need to represent an
	// invalid/undefined version by default to make sure clients upgrade their
	// software to set the version explicitly.
	MuSig2Version_MUSIG2_VERSION_UNDEFINED MuSig2Version = 0
	// The version of MuSig2 that lnd 0.15.x shipped with, which corresponds to the
	// version v0.4.0 of the MuSig2 BIP draft.
	MuSig2Version_MUSIG2_VERSION_V040 MuSig2Version = 1
	// The current version of MuSig2 which corresponds to the version v1.0.0rc2 of
	// the MuSig2 BIP draft.
	MuSig2Version_MUSIG2_VERSION_V100RC2 MuSig2Version = 2
)

// Enum value maps for MuSig2Version.
var (
	MuSig2Version_name = map[int32]string{
		0: "MUSIG2_VERSION_UNDEFINED",
		1: "MUSIG2_VERSION_V040",
		2: "MUSIG2_VERSION_V100RC2",
	}
	MuSig2Version_value = map[string]int32{
		"MUSIG2_VERSION_UNDEFINED": 0,
		"MUSIG2_VERSION_V040":      1,
		"MUSIG2_VERSION_V100RC2":   2,
	}
)

func (x MuSig2Version) Enum() *MuSig2Version {
	p := new(MuSig2Version)
	*p = x
	return p
}

func (x MuSig2Version) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MuSig2Version) Descriptor() protoreflect.EnumDescriptor {
	return file_signrpc_signer_proto_enumTypes[1].Descriptor()
}

func (MuSig2Version) Type() protoreflect.EnumType {
	return &file_signrpc_signer_proto_enumTypes[1]
}

func (x MuSig2Version) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MuSig2Version.Descriptor instead.
func (MuSig2Version) EnumDescriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{1}
}

type KeyLocator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The family of key being identified.
	KeyFamily int32 `protobuf:"varint,1,opt,name=key_family,json=keyFamily,proto3" json:"key_family,omitempty"`
	// The precise index of the key being identified.
	KeyIndex int32 `protobuf:"varint,2,opt,name=key_index,json=keyIndex,proto3" json:"key_index,omitempty"`
}

func (x *KeyLocator) Reset() {
	*x = KeyLocator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyLocator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyLocator) ProtoMessage() {}

func (x *KeyLocator) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyLocator.ProtoReflect.Descriptor instead.
func (*KeyLocator) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{0}
}

func (x *KeyLocator) GetKeyFamily() int32 {
	if x != nil {
		return x.KeyFamily
	}
	return 0
}

func (x *KeyLocator) GetKeyIndex() int32 {
	if x != nil {
		return x.KeyIndex
	}
	return 0
}

type KeyDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw bytes of the public key in the key pair being identified. Either
	// this or the KeyLocator must be specified.
	RawKeyBytes []byte `protobuf:"bytes,1,opt,name=raw_key_bytes,json=rawKeyBytes,proto3" json:"raw_key_bytes,omitempty"`
	// The key locator that identifies which private key to use for signing.
	// Either this or the raw bytes of the target public key must be specified.
	KeyLoc *KeyLocator `protobuf:"bytes,2,opt,name=key_loc,json=keyLoc,proto3" json:"key_loc,omitempty"`
}

func (x *KeyDescriptor) Reset() {
	*x = KeyDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyDescriptor) ProtoMessage() {}

func (x *KeyDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyDescriptor.ProtoReflect.Descriptor instead.
func (*KeyDescriptor) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{1}
}

func (x *KeyDescriptor) GetRawKeyBytes() []byte {
	if x != nil {
		return x.RawKeyBytes
	}
	return nil
}

func (x *KeyDescriptor) GetKeyLoc() *KeyLocator {
	if x != nil {
		return x.KeyLoc
	}
	return nil
}

type TxOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the output being spent.
	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	// The script of the output being spent.
	PkScript []byte `protobuf:"bytes,2,opt,name=pk_script,json=pkScript,proto3" json:"pk_script,omitempty"`
}

func (x *TxOut) Reset() {
	*x = TxOut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TxOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxOut) ProtoMessage() {}

func (x *TxOut) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxOut.ProtoReflect.Descriptor instead.
func (*TxOut) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{2}
}

func (x *TxOut) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *TxOut) GetPkScript() []byte {
	if x != nil {
		return x.PkScript
	}
	return nil
}

type SignDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A descriptor that precisely describes *which* key to use for signing. This
	// may provide the raw public key directly, or require the Signer to re-derive
	// the key according to the populated derivation path.
	//
	// Note that if the key descriptor was obtained through walletrpc.DeriveKey,
	// then the key locator MUST always be provided, since the derived keys are not
	// persisted unlike with DeriveNextKey.
	KeyDesc *KeyDescriptor `protobuf:"bytes,1,opt,name=key_desc,json=keyDesc,proto3" json:"key_desc,omitempty"`
	// A scalar value that will be added to the private key corresponding to the
	// above public key to obtain the private key to be used to sign this input.
	// This value is typically derived via the following computation:
	//
	// derivedKey = privkey + sha256(perCommitmentPoint || pubKey) mod N
	SingleTweak []byte `protobuf:"bytes,2,opt,name=single_tweak,json=singleTweak,proto3" json:"single_tweak,omitempty"`
	// A private key that will be used in combination with its corresponding
	// private key to derive the private key that is to be used to sign the target
	// input. Within the Lightning protocol, this value is typically the
	// commitment secret from a previously revoked commitment transaction. This
	// value is in combination with two hash values, and the original private key
	// to derive the private key to be used when signing.
	//
	// k = (privKey*sha256(pubKey || tweakPub) +
	// tweakPriv*sha256(tweakPub || pubKey)) mod N
	DoubleTweak []byte `protobuf:"bytes,3,opt,name=double_tweak,json=doubleTweak,proto3" json:"double_tweak,omitempty"`
	// The 32 byte input to the taproot tweak derivation that is used to derive
	// the output key from an internal key: outputKey = internalKey +
	// tagged_hash("tapTweak", internalKey || tapTweak).
	//
	// When doing a BIP 86 spend, this field can be an empty byte slice.
	//
	// When doing a normal key path spend, with the output key committing to an
	// actual script root, then this field should be: the tapscript root hash.
	TapTweak []byte `protobuf:"bytes,10,opt,name=tap_tweak,json=tapTweak,proto3" json:"tap_tweak,omitempty"`
	// The full script required to properly redeem the output. This field will
	// only be populated if a p2tr, p2wsh or a p2sh output is being signed. If a
	// taproot script path spend is being attempted, then this should be the raw
	// leaf script.
	WitnessScript []byte `protobuf:"bytes,4,opt,name=witness_script,json=witnessScript,proto3" json:"witness_script,omitempty"`
	// A description of the output being spent. The value and script MUST be
	// provided.
	Output *TxOut `protobuf:"bytes,5,opt,name=output,proto3" json:"output,omitempty"`
	// The target sighash type that should be used when generating the final
	// sighash, and signature.
	Sighash uint32 `protobuf:"varint,7,opt,name=sighash,proto3" json:"sighash,omitempty"`
	// The target input within the transaction that should be signed.
	InputIndex int32 `protobuf:"varint,8,opt,name=input_index,json=inputIndex,proto3" json:"input_index,omitempty"`
	// The sign method specifies how the input should be signed. Depending on the
	// method, either the tap_tweak, witness_script or both need to be specified.
	// Defaults to SegWit v0 signing to be backward compatible with older RPC
	// clients.
	SignMethod SignMethod `protobuf:"varint,9,opt,name=sign_method,json=signMethod,proto3,enum=signrpc.SignMethod" json:"sign_method,omitempty"`
}

func (x *SignDescriptor) Reset() {
	*x = SignDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignDescriptor) ProtoMessage() {}

func (x *SignDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignDescriptor.ProtoReflect.Descriptor instead.
func (*SignDescriptor) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{3}
}

func (x *SignDescriptor) GetKeyDesc() *KeyDescriptor {
	if x != nil {
		return x.KeyDesc
	}
	return nil
}

func (x *SignDescriptor) GetSingleTweak() []byte {
	if x != nil {
		return x.SingleTweak
	}
	return nil
}

func (x *SignDescriptor) GetDoubleTweak() []byte {
	if x != nil {
		return x.DoubleTweak
	}
	return nil
}

func (x *SignDescriptor) GetTapTweak() []byte {
	if x != nil {
		return x.TapTweak
	}
	return nil
}

func (x *SignDescriptor) GetWitnessScript() []byte {
	if x != nil {
		return x.WitnessScript
	}
	return nil
}

func (x *SignDescriptor) GetOutput() *TxOut {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *SignDescriptor) GetSighash() uint32 {
	if x != nil {
		return x.Sighash
	}
	return 0
}

func (x *SignDescriptor) GetInputIndex() int32 {
	if x != nil {
		return x.InputIndex
	}
	return 0
}

func (x *SignDescriptor) GetSignMethod() SignMethod {
	if x != nil {
		return x.SignMethod
	}
	return SignMethod_SIGN_METHOD_WITNESS_V0
}

type SignReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw bytes of the transaction to be signed.
	RawTxBytes []byte `protobuf:"bytes,1,opt,name=raw_tx_bytes,json=rawTxBytes,proto3" json:"raw_tx_bytes,omitempty"`
	// A set of sign descriptors, for each input to be signed.
	SignDescs []*SignDescriptor `protobuf:"bytes,2,rep,name=sign_descs,json=signDescs,proto3" json:"sign_descs,omitempty"`
	// The full list of UTXO information for each of the inputs being spent. This
	// is required when spending one or more taproot (SegWit v1) outputs.
	PrevOutputs []*TxOut `protobuf:"bytes,3,rep,name=prev_outputs,json=prevOutputs,proto3" json:"prev_outputs,omitempty"`
}

func (x *SignReq) Reset() {
	*x = SignReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignReq) ProtoMessage() {}

func (x *SignReq) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignReq.ProtoReflect.Descriptor instead.
func (*SignReq) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{4}
}

func (x *SignReq) GetRawTxBytes() []byte {
	if x != nil {
		return x.RawTxBytes
	}
	return nil
}

func (x *SignReq) GetSignDescs() []*SignDescriptor {
	if x != nil {
		return x.SignDescs
	}
	return nil
}

func (x *SignReq) GetPrevOutputs() []*TxOut {
	if x != nil {
		return x.PrevOutputs
	}
	return nil
}

type SignResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of signatures realized in a fixed 64-byte format ordered in ascending
	// input order.
	RawSigs [][]byte `protobuf:"bytes,1,rep,name=raw_sigs,json=rawSigs,proto3" json:"raw_sigs,omitempty"`
}

func (x *SignResp) Reset() {
	*x = SignResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignResp) ProtoMessage() {}

func (x *SignResp) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignResp.ProtoReflect.Descriptor instead.
func (*SignResp) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{5}
}

func (x *SignResp) GetRawSigs() [][]byte {
	if x != nil {
		return x.RawSigs
	}
	return nil
}

type InputScript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The serializes witness stack for the specified input.
	Witness [][]byte `protobuf:"bytes,1,rep,name=witness,proto3" json:"witness,omitempty"`
	// The optional sig script for the specified witness that will only be set if
	// the input specified is a nested p2sh witness program.
	SigScript []byte `protobuf:"bytes,2,opt,name=sig_script,json=sigScript,proto3" json:"sig_script,omitempty"`
}

func (x *InputScript) Reset() {
	*x = InputScript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputScript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputScript) ProtoMessage() {}

func (x *InputScript) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputScript.ProtoReflect.Descriptor instead.
func (*InputScript) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{6}
}

func (x *InputScript) GetWitness() [][]byte {
	if x != nil {
		return x.Witness
	}
	return nil
}

func (x *InputScript) GetSigScript() []byte {
	if x != nil {
		return x.SigScript
	}
	return nil
}

type InputScriptResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of fully valid input scripts requested.
	InputScripts []*InputScript `protobuf:"bytes,1,rep,name=input_scripts,json=inputScripts,proto3" json:"input_scripts,omitempty"`
}

func (x *InputScriptResp) Reset() {
	*x = InputScriptResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputScriptResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputScriptResp) ProtoMessage() {}

func (x *InputScriptResp) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputScriptResp.ProtoReflect.Descriptor instead.
func (*InputScriptResp) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{7}
}

func (x *InputScriptResp) GetInputScripts() []*InputScript {
	if x != nil {
		return x.InputScripts
	}
	return nil
}

type SignMessageReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message to be signed. When using REST, this field must be encoded as
	// base64.
	Msg []byte `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	// The key locator that identifies which key to use for signing.
	KeyLoc *KeyLocator `protobuf:"bytes,2,opt,name=key_loc,json=keyLoc,proto3" json:"key_loc,omitempty"`
	// Double-SHA256 hash instead of just the default single round.
	DoubleHash bool `protobuf:"varint,3,opt,name=double_hash,json=doubleHash,proto3" json:"double_hash,omitempty"`
	// Use the compact (pubkey recoverable) format instead of the raw lnwire
	// format. This option cannot be used with Schnorr signatures.
	CompactSig bool `protobuf:"varint,4,opt,name=compact_sig,json=compactSig,proto3" json:"compact_sig,omitempty"`
	// Use Schnorr signature. This option cannot be used with compact format.
	SchnorrSig bool `protobuf:"varint,5,opt,name=schnorr_sig,json=schnorrSig,proto3" json:"schnorr_sig,omitempty"`
	// The optional Taproot tweak bytes to apply to the private key before creating
	// a Schnorr signature. The private key is tweaked as described in BIP-341:
	// privKey + h_tapTweak(internalKey || tapTweak)
	SchnorrSigTapTweak []byte `protobuf:"bytes,6,opt,name=schnorr_sig_tap_tweak,json=schnorrSigTapTweak,proto3" json:"schnorr_sig_tap_tweak,omitempty"`
	// An optional tag that can be provided when taking a tagged hash of a
	// message. This option can only be used when schnorr_sig is true.
	Tag []byte `protobuf:"bytes,7,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *SignMessageReq) Reset() {
	*x = SignMessageReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignMessageReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignMessageReq) ProtoMessage() {}

func (x *SignMessageReq) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignMessageReq.ProtoReflect.Descriptor instead.
func (*SignMessageReq) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{8}
}

func (x *SignMessageReq) GetMsg() []byte {
	if x != nil {
		return x.Msg
	}
	return nil
}

func (x *SignMessageReq) GetKeyLoc() *KeyLocator {
	if x != nil {
		return x.KeyLoc
	}
	return nil
}

func (x *SignMessageReq) GetDoubleHash() bool {
	if x != nil {
		return x.DoubleHash
	}
	return false
}

func (x *SignMessageReq) GetCompactSig() bool {
	if x != nil {
		return x.CompactSig
	}
	return false
}

func (x *SignMessageReq) GetSchnorrSig() bool {
	if x != nil {
		return x.SchnorrSig
	}
	return false
}

func (x *SignMessageReq) GetSchnorrSigTapTweak() []byte {
	if x != nil {
		return x.SchnorrSigTapTweak
	}
	return nil
}

func (x *SignMessageReq) GetTag() []byte {
	if x != nil {
		return x.Tag
	}
	return nil
}

type SignMessageResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The signature for the given message in the fixed-size LN wire format.
	Signature []byte `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *SignMessageResp) Reset() {
	*x = SignMessageResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignMessageResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignMessageResp) ProtoMessage() {}

func (x *SignMessageResp) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignMessageResp.ProtoReflect.Descriptor instead.
func (*SignMessageResp) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{9}
}

func (x *SignMessageResp) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

type VerifyMessageReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The message over which the signature is to be verified. When using
	// REST, this field must be encoded as base64.
	Msg []byte `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	// The fixed-size LN wire encoded signature to be verified over the given
	// message. When using REST, this field must be encoded as base64.
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	// The public key the signature has to be valid for. When using REST, this
	// field must be encoded as base64. If the is_schnorr_sig option is true, then
	// the public key is expected to be in the 32-byte x-only serialization
	// according to BIP-340.
	Pubkey []byte `protobuf:"bytes,3,opt,name=pubkey,proto3" json:"pubkey,omitempty"`
	// Specifies if the signature is a Schnorr signature.
	IsSchnorrSig bool `protobuf:"varint,4,opt,name=is_schnorr_sig,json=isSchnorrSig,proto3" json:"is_schnorr_sig,omitempty"`
	// An optional tag that can be provided when taking a tagged hash of a
	// message. This option can only be used when is_schnorr_sig is true.
	Tag []byte `protobuf:"bytes,5,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *VerifyMessageReq) Reset() {
	*x = VerifyMessageReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMessageReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageReq) ProtoMessage() {}

func (x *VerifyMessageReq) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageReq.ProtoReflect.Descriptor instead.
func (*VerifyMessageReq) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{10}
}

func (x *VerifyMessageReq) GetMsg() []byte {
	if x != nil {
		return x.Msg
	}
	return nil
}

func (x *VerifyMessageReq) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *VerifyMessageReq) GetPubkey() []byte {
	if x != nil {
		return x.Pubkey
	}
	return nil
}

func (x *VerifyMessageReq) GetIsSchnorrSig() bool {
	if x != nil {
		return x.IsSchnorrSig
	}
	return false
}

func (x *VerifyMessageReq) GetTag() []byte {
	if x != nil {
		return x.Tag
	}
	return nil
}

type VerifyMessageResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the signature was valid over the given message.
	Valid bool `protobuf:"varint,1,opt,name=valid,proto3" json:"valid,omitempty"`
}

func (x *VerifyMessageResp) Reset() {
	*x = VerifyMessageResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMessageResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMessageResp) ProtoMessage() {}

func (x *VerifyMessageResp) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMessageResp.ProtoReflect.Descriptor instead.
func (*VerifyMessageResp) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{11}
}

func (x *VerifyMessageResp) GetValid() bool {
	if x != nil {
		return x.Valid
	}
	return false
}

type SharedKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ephemeral public key to use for the DH key derivation.
	EphemeralPubkey []byte `protobuf:"bytes,1,opt,name=ephemeral_pubkey,json=ephemeralPubkey,proto3" json:"ephemeral_pubkey,omitempty"`
	// Deprecated. The optional key locator of the local key that should be used.
	// If this parameter is not set then the node's identity private key will be
	// used.
	//
	// Deprecated: Marked as deprecated in signrpc/signer.proto.
	KeyLoc *KeyLocator `protobuf:"bytes,2,opt,name=key_loc,json=keyLoc,proto3" json:"key_loc,omitempty"`
	// A key descriptor describes the key used for performing ECDH. Either a key
	// locator or a raw public key is expected, if neither is supplied, defaults to
	// the node's identity private key.
	KeyDesc *KeyDescriptor `protobuf:"bytes,3,opt,name=key_desc,json=keyDesc,proto3" json:"key_desc,omitempty"`
}

func (x *SharedKeyRequest) Reset() {
	*x = SharedKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SharedKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharedKeyRequest) ProtoMessage() {}

func (x *SharedKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharedKeyRequest.ProtoReflect.Descriptor instead.
func (*SharedKeyRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{12}
}

func (x *SharedKeyRequest) GetEphemeralPubkey() []byte {
	if x != nil {
		return x.EphemeralPubkey
	}
	return nil
}

// Deprecated: Marked as deprecated in signrpc/signer.proto.
func (x *SharedKeyRequest) GetKeyLoc() *KeyLocator {
	if x != nil {
		return x.KeyLoc
	}
	return nil
}

func (x *SharedKeyRequest) GetKeyDesc() *KeyDescriptor {
	if x != nil {
		return x.KeyDesc
	}
	return nil
}

type SharedKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The shared public key, hashed with sha256.
	SharedKey []byte `protobuf:"bytes,1,opt,name=shared_key,json=sharedKey,proto3" json:"shared_key,omitempty"`
}

func (x *SharedKeyResponse) Reset() {
	*x = SharedKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SharedKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharedKeyResponse) ProtoMessage() {}

func (x *SharedKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharedKeyResponse.ProtoReflect.Descriptor instead.
func (*SharedKeyResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{13}
}

func (x *SharedKeyResponse) GetSharedKey() []byte {
	if x != nil {
		return x.SharedKey
	}
	return nil
}

type TweakDesc struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tweak is the 32-byte value that will modify the public key.
	Tweak []byte `protobuf:"bytes,1,opt,name=tweak,proto3" json:"tweak,omitempty"`
	// Specifies if the target key should be converted to an x-only public key
	// before tweaking. If true, then the public key will be mapped to an x-only
	// key before the tweaking operation is applied.
	IsXOnly bool `protobuf:"varint,2,opt,name=is_x_only,json=isXOnly,proto3" json:"is_x_only,omitempty"`
}

func (x *TweakDesc) Reset() {
	*x = TweakDesc{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TweakDesc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TweakDesc) ProtoMessage() {}

func (x *TweakDesc) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TweakDesc.ProtoReflect.Descriptor instead.
func (*TweakDesc) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{14}
}

func (x *TweakDesc) GetTweak() []byte {
	if x != nil {
		return x.Tweak
	}
	return nil
}

func (x *TweakDesc) GetIsXOnly() bool {
	if x != nil {
		return x.IsXOnly
	}
	return false
}

type TaprootTweakDesc struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The root hash of the tapscript tree if a script path is committed to. If
	// the MuSig2 key put on chain doesn't also commit to a script path (BIP-0086
	// key spend only), then this needs to be empty and the key_spend_only field
	// below must be set to true. This is required because gRPC cannot
	// differentiate between a zero-size byte slice and a nil byte slice (both
	// would be serialized the same way). So the extra boolean is required.
	ScriptRoot []byte `protobuf:"bytes,1,opt,name=script_root,json=scriptRoot,proto3" json:"script_root,omitempty"`
	// Indicates that the above script_root is expected to be empty because this
	// is a BIP-0086 key spend only commitment where only the internal key is
	// committed to instead of also including a script root hash.
	KeySpendOnly bool `protobuf:"varint,2,opt,name=key_spend_only,json=keySpendOnly,proto3" json:"key_spend_only,omitempty"`
}

func (x *TaprootTweakDesc) Reset() {
	*x = TaprootTweakDesc{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaprootTweakDesc) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaprootTweakDesc) ProtoMessage() {}

func (x *TaprootTweakDesc) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaprootTweakDesc.ProtoReflect.Descriptor instead.
func (*TaprootTweakDesc) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{15}
}

func (x *TaprootTweakDesc) GetScriptRoot() []byte {
	if x != nil {
		return x.ScriptRoot
	}
	return nil
}

func (x *TaprootTweakDesc) GetKeySpendOnly() bool {
	if x != nil {
		return x.KeySpendOnly
	}
	return false
}

type MuSig2CombineKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of all public keys (serialized in 32-byte x-only format for v0.4.0
	// and 33-byte compressed format for v1.0.0rc2!) participating in the signing
	// session. The list will always be sorted lexicographically internally. This
	// must include the local key which is described by the above key_loc.
	AllSignerPubkeys [][]byte `protobuf:"bytes,1,rep,name=all_signer_pubkeys,json=allSignerPubkeys,proto3" json:"all_signer_pubkeys,omitempty"`
	// A series of optional generic tweaks to be applied to the aggregated
	// public key.
	Tweaks []*TweakDesc `protobuf:"bytes,2,rep,name=tweaks,proto3" json:"tweaks,omitempty"`
	// An optional taproot specific tweak that must be specified if the MuSig2
	// combined key will be used as the main taproot key of a taproot output
	// on-chain.
	TaprootTweak *TaprootTweakDesc `protobuf:"bytes,3,opt,name=taproot_tweak,json=taprootTweak,proto3" json:"taproot_tweak,omitempty"`
	// The mandatory version of the MuSig2 BIP draft to use. This is necessary to
	// differentiate between the changes that were made to the BIP while this
	// experimental RPC was already released. Some of those changes affect how the
	// combined key and nonces are created.
	Version MuSig2Version `protobuf:"varint,4,opt,name=version,proto3,enum=signrpc.MuSig2Version" json:"version,omitempty"`
}

func (x *MuSig2CombineKeysRequest) Reset() {
	*x = MuSig2CombineKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2CombineKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2CombineKeysRequest) ProtoMessage() {}

func (x *MuSig2CombineKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2CombineKeysRequest.ProtoReflect.Descriptor instead.
func (*MuSig2CombineKeysRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{16}
}

func (x *MuSig2CombineKeysRequest) GetAllSignerPubkeys() [][]byte {
	if x != nil {
		return x.AllSignerPubkeys
	}
	return nil
}

func (x *MuSig2CombineKeysRequest) GetTweaks() []*TweakDesc {
	if x != nil {
		return x.Tweaks
	}
	return nil
}

func (x *MuSig2CombineKeysRequest) GetTaprootTweak() *TaprootTweakDesc {
	if x != nil {
		return x.TaprootTweak
	}
	return nil
}

func (x *MuSig2CombineKeysRequest) GetVersion() MuSig2Version {
	if x != nil {
		return x.Version
	}
	return MuSig2Version_MUSIG2_VERSION_UNDEFINED
}

type MuSig2CombineKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The combined public key (in the 32-byte x-only format) with all tweaks
	// applied to it. If a taproot tweak is specified, this corresponds to the
	// taproot key that can be put into the on-chain output.
	CombinedKey []byte `protobuf:"bytes,1,opt,name=combined_key,json=combinedKey,proto3" json:"combined_key,omitempty"`
	// The raw combined public key (in the 32-byte x-only format) before any tweaks
	// are applied to it. If a taproot tweak is specified, this corresponds to the
	// internal key that needs to be put into the witness if the script spend path
	// is used.
	TaprootInternalKey []byte `protobuf:"bytes,2,opt,name=taproot_internal_key,json=taprootInternalKey,proto3" json:"taproot_internal_key,omitempty"`
	// The version of the MuSig2 BIP that was used to combine the keys.
	Version MuSig2Version `protobuf:"varint,4,opt,name=version,proto3,enum=signrpc.MuSig2Version" json:"version,omitempty"`
}

func (x *MuSig2CombineKeysResponse) Reset() {
	*x = MuSig2CombineKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2CombineKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2CombineKeysResponse) ProtoMessage() {}

func (x *MuSig2CombineKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2CombineKeysResponse.ProtoReflect.Descriptor instead.
func (*MuSig2CombineKeysResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{17}
}

func (x *MuSig2CombineKeysResponse) GetCombinedKey() []byte {
	if x != nil {
		return x.CombinedKey
	}
	return nil
}

func (x *MuSig2CombineKeysResponse) GetTaprootInternalKey() []byte {
	if x != nil {
		return x.TaprootInternalKey
	}
	return nil
}

func (x *MuSig2CombineKeysResponse) GetVersion() MuSig2Version {
	if x != nil {
		return x.Version
	}
	return MuSig2Version_MUSIG2_VERSION_UNDEFINED
}

type MuSig2SessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key locator that identifies which key to use for signing.
	KeyLoc *KeyLocator `protobuf:"bytes,1,opt,name=key_loc,json=keyLoc,proto3" json:"key_loc,omitempty"`
	// A list of all public keys (serialized in 32-byte x-only format for v0.4.0
	// and 33-byte compressed format for v1.0.0rc2!) participating in the signing
	// session. The list will always be sorted lexicographically internally. This
	// must include the local key which is described by the above key_loc.
	AllSignerPubkeys [][]byte `protobuf:"bytes,2,rep,name=all_signer_pubkeys,json=allSignerPubkeys,proto3" json:"all_signer_pubkeys,omitempty"`
	// An optional list of all public nonces of other signing participants that
	// might already be known.
	OtherSignerPublicNonces [][]byte `protobuf:"bytes,3,rep,name=other_signer_public_nonces,json=otherSignerPublicNonces,proto3" json:"other_signer_public_nonces,omitempty"`
	// A series of optional generic tweaks to be applied to the aggregated
	// public key.
	Tweaks []*TweakDesc `protobuf:"bytes,4,rep,name=tweaks,proto3" json:"tweaks,omitempty"`
	// An optional taproot specific tweak that must be specified if the MuSig2
	// combined key will be used as the main taproot key of a taproot output
	// on-chain.
	TaprootTweak *TaprootTweakDesc `protobuf:"bytes,5,opt,name=taproot_tweak,json=taprootTweak,proto3" json:"taproot_tweak,omitempty"`
	// The mandatory version of the MuSig2 BIP draft to use. This is necessary to
	// differentiate between the changes that were made to the BIP while this
	// experimental RPC was already released. Some of those changes affect how the
	// combined key and nonces are created.
	Version MuSig2Version `protobuf:"varint,6,opt,name=version,proto3,enum=signrpc.MuSig2Version" json:"version,omitempty"`
	// A set of pre generated secret local nonces to use in the musig2 session.
	// This field is optional. This can be useful for protocols that need to send
	// nonces ahead of time before the set of signer keys are known. This value
	// MUST be 97 bytes and be the concatenation of two CSPRNG generated 32 byte
	// values and local public key used for signing as specified in the key_loc
	// field.
	PregeneratedLocalNonce []byte `protobuf:"bytes,7,opt,name=pregenerated_local_nonce,json=pregeneratedLocalNonce,proto3" json:"pregenerated_local_nonce,omitempty"`
}

func (x *MuSig2SessionRequest) Reset() {
	*x = MuSig2SessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2SessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2SessionRequest) ProtoMessage() {}

func (x *MuSig2SessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2SessionRequest.ProtoReflect.Descriptor instead.
func (*MuSig2SessionRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{18}
}

func (x *MuSig2SessionRequest) GetKeyLoc() *KeyLocator {
	if x != nil {
		return x.KeyLoc
	}
	return nil
}

func (x *MuSig2SessionRequest) GetAllSignerPubkeys() [][]byte {
	if x != nil {
		return x.AllSignerPubkeys
	}
	return nil
}

func (x *MuSig2SessionRequest) GetOtherSignerPublicNonces() [][]byte {
	if x != nil {
		return x.OtherSignerPublicNonces
	}
	return nil
}

func (x *MuSig2SessionRequest) GetTweaks() []*TweakDesc {
	if x != nil {
		return x.Tweaks
	}
	return nil
}

func (x *MuSig2SessionRequest) GetTaprootTweak() *TaprootTweakDesc {
	if x != nil {
		return x.TaprootTweak
	}
	return nil
}

func (x *MuSig2SessionRequest) GetVersion() MuSig2Version {
	if x != nil {
		return x.Version
	}
	return MuSig2Version_MUSIG2_VERSION_UNDEFINED
}

func (x *MuSig2SessionRequest) GetPregeneratedLocalNonce() []byte {
	if x != nil {
		return x.PregeneratedLocalNonce
	}
	return nil
}

type MuSig2SessionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID that represents this signing session. A session can be used
	// for producing a signature a single time. If the signing fails for any
	// reason, a new session with the same participants needs to be created.
	SessionId []byte `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// The combined public key (in the 32-byte x-only format) with all tweaks
	// applied to it. If a taproot tweak is specified, this corresponds to the
	// taproot key that can be put into the on-chain output.
	CombinedKey []byte `protobuf:"bytes,2,opt,name=combined_key,json=combinedKey,proto3" json:"combined_key,omitempty"`
	// The raw combined public key (in the 32-byte x-only format) before any tweaks
	// are applied to it. If a taproot tweak is specified, this corresponds to the
	// internal key that needs to be put into the witness if the script spend path
	// is used.
	TaprootInternalKey []byte `protobuf:"bytes,3,opt,name=taproot_internal_key,json=taprootInternalKey,proto3" json:"taproot_internal_key,omitempty"`
	// The two public nonces the local signer uses, combined into a single value
	// of 66 bytes. Can be split into the two 33-byte points to get the individual
	// nonces.
	LocalPublicNonces []byte `protobuf:"bytes,4,opt,name=local_public_nonces,json=localPublicNonces,proto3" json:"local_public_nonces,omitempty"`
	// Indicates whether all nonces required to start the signing process are known
	// now.
	HaveAllNonces bool `protobuf:"varint,5,opt,name=have_all_nonces,json=haveAllNonces,proto3" json:"have_all_nonces,omitempty"`
	// The version of the MuSig2 BIP that was used to create the session.
	Version MuSig2Version `protobuf:"varint,6,opt,name=version,proto3,enum=signrpc.MuSig2Version" json:"version,omitempty"`
}

func (x *MuSig2SessionResponse) Reset() {
	*x = MuSig2SessionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2SessionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2SessionResponse) ProtoMessage() {}

func (x *MuSig2SessionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2SessionResponse.ProtoReflect.Descriptor instead.
func (*MuSig2SessionResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{19}
}

func (x *MuSig2SessionResponse) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

func (x *MuSig2SessionResponse) GetCombinedKey() []byte {
	if x != nil {
		return x.CombinedKey
	}
	return nil
}

func (x *MuSig2SessionResponse) GetTaprootInternalKey() []byte {
	if x != nil {
		return x.TaprootInternalKey
	}
	return nil
}

func (x *MuSig2SessionResponse) GetLocalPublicNonces() []byte {
	if x != nil {
		return x.LocalPublicNonces
	}
	return nil
}

func (x *MuSig2SessionResponse) GetHaveAllNonces() bool {
	if x != nil {
		return x.HaveAllNonces
	}
	return false
}

func (x *MuSig2SessionResponse) GetVersion() MuSig2Version {
	if x != nil {
		return x.Version
	}
	return MuSig2Version_MUSIG2_VERSION_UNDEFINED
}

type MuSig2RegisterNoncesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID of the signing session those nonces should be registered with.
	SessionId []byte `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// A list of all public nonces of other signing participants that should be
	// registered.
	OtherSignerPublicNonces [][]byte `protobuf:"bytes,3,rep,name=other_signer_public_nonces,json=otherSignerPublicNonces,proto3" json:"other_signer_public_nonces,omitempty"`
}

func (x *MuSig2RegisterNoncesRequest) Reset() {
	*x = MuSig2RegisterNoncesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2RegisterNoncesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2RegisterNoncesRequest) ProtoMessage() {}

func (x *MuSig2RegisterNoncesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2RegisterNoncesRequest.ProtoReflect.Descriptor instead.
func (*MuSig2RegisterNoncesRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{20}
}

func (x *MuSig2RegisterNoncesRequest) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

func (x *MuSig2RegisterNoncesRequest) GetOtherSignerPublicNonces() [][]byte {
	if x != nil {
		return x.OtherSignerPublicNonces
	}
	return nil
}

type MuSig2RegisterNoncesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether all nonces required to start the signing process are known
	// now.
	HaveAllNonces bool `protobuf:"varint,1,opt,name=have_all_nonces,json=haveAllNonces,proto3" json:"have_all_nonces,omitempty"`
}

func (x *MuSig2RegisterNoncesResponse) Reset() {
	*x = MuSig2RegisterNoncesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2RegisterNoncesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2RegisterNoncesResponse) ProtoMessage() {}

func (x *MuSig2RegisterNoncesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2RegisterNoncesResponse.ProtoReflect.Descriptor instead.
func (*MuSig2RegisterNoncesResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{21}
}

func (x *MuSig2RegisterNoncesResponse) GetHaveAllNonces() bool {
	if x != nil {
		return x.HaveAllNonces
	}
	return false
}

type MuSig2SignRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID of the signing session to use for signing.
	SessionId []byte `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// The 32-byte SHA256 digest of the message to sign.
	MessageDigest []byte `protobuf:"bytes,2,opt,name=message_digest,json=messageDigest,proto3" json:"message_digest,omitempty"`
	// Cleanup indicates that after signing, the session state can be cleaned up,
	// since another participant is going to be responsible for combining the
	// partial signatures.
	Cleanup bool `protobuf:"varint,3,opt,name=cleanup,proto3" json:"cleanup,omitempty"`
}

func (x *MuSig2SignRequest) Reset() {
	*x = MuSig2SignRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2SignRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2SignRequest) ProtoMessage() {}

func (x *MuSig2SignRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2SignRequest.ProtoReflect.Descriptor instead.
func (*MuSig2SignRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{22}
}

func (x *MuSig2SignRequest) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

func (x *MuSig2SignRequest) GetMessageDigest() []byte {
	if x != nil {
		return x.MessageDigest
	}
	return nil
}

func (x *MuSig2SignRequest) GetCleanup() bool {
	if x != nil {
		return x.Cleanup
	}
	return false
}

type MuSig2SignResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partial signature created by the local signer.
	LocalPartialSignature []byte `protobuf:"bytes,1,opt,name=local_partial_signature,json=localPartialSignature,proto3" json:"local_partial_signature,omitempty"`
}

func (x *MuSig2SignResponse) Reset() {
	*x = MuSig2SignResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2SignResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2SignResponse) ProtoMessage() {}

func (x *MuSig2SignResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2SignResponse.ProtoReflect.Descriptor instead.
func (*MuSig2SignResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{23}
}

func (x *MuSig2SignResponse) GetLocalPartialSignature() []byte {
	if x != nil {
		return x.LocalPartialSignature
	}
	return nil
}

type MuSig2CombineSigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID of the signing session to combine the signatures for.
	SessionId []byte `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// The list of all other participants' partial signatures to add to the current
	// session.
	OtherPartialSignatures [][]byte `protobuf:"bytes,2,rep,name=other_partial_signatures,json=otherPartialSignatures,proto3" json:"other_partial_signatures,omitempty"`
}

func (x *MuSig2CombineSigRequest) Reset() {
	*x = MuSig2CombineSigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2CombineSigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2CombineSigRequest) ProtoMessage() {}

func (x *MuSig2CombineSigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2CombineSigRequest.ProtoReflect.Descriptor instead.
func (*MuSig2CombineSigRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{24}
}

func (x *MuSig2CombineSigRequest) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

func (x *MuSig2CombineSigRequest) GetOtherPartialSignatures() [][]byte {
	if x != nil {
		return x.OtherPartialSignatures
	}
	return nil
}

type MuSig2CombineSigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether all partial signatures required to create a final, full
	// signature are known yet. If this is true, then the final_signature field is
	// set, otherwise it is empty.
	HaveAllSignatures bool `protobuf:"varint,1,opt,name=have_all_signatures,json=haveAllSignatures,proto3" json:"have_all_signatures,omitempty"`
	// The final, full signature that is valid for the combined public key.
	FinalSignature []byte `protobuf:"bytes,2,opt,name=final_signature,json=finalSignature,proto3" json:"final_signature,omitempty"`
}

func (x *MuSig2CombineSigResponse) Reset() {
	*x = MuSig2CombineSigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2CombineSigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2CombineSigResponse) ProtoMessage() {}

func (x *MuSig2CombineSigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2CombineSigResponse.ProtoReflect.Descriptor instead.
func (*MuSig2CombineSigResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{25}
}

func (x *MuSig2CombineSigResponse) GetHaveAllSignatures() bool {
	if x != nil {
		return x.HaveAllSignatures
	}
	return false
}

func (x *MuSig2CombineSigResponse) GetFinalSignature() []byte {
	if x != nil {
		return x.FinalSignature
	}
	return nil
}

type MuSig2CleanupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID of the signing session that should be removed/cleaned up.
	SessionId []byte `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (x *MuSig2CleanupRequest) Reset() {
	*x = MuSig2CleanupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2CleanupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2CleanupRequest) ProtoMessage() {}

func (x *MuSig2CleanupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2CleanupRequest.ProtoReflect.Descriptor instead.
func (*MuSig2CleanupRequest) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{26}
}

func (x *MuSig2CleanupRequest) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

type MuSig2CleanupResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MuSig2CleanupResponse) Reset() {
	*x = MuSig2CleanupResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_signrpc_signer_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuSig2CleanupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuSig2CleanupResponse) ProtoMessage() {}

func (x *MuSig2CleanupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_signrpc_signer_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuSig2CleanupResponse.ProtoReflect.Descriptor instead.
func (*MuSig2CleanupResponse) Descriptor() ([]byte, []int) {
	return file_signrpc_signer_proto_rawDescGZIP(), []int{27}
}

var File_signrpc_signer_proto protoreflect.FileDescriptor

var file_signrpc_signer_proto_rawDesc = []byte{
	0x0a, 0x14, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x22,
	0x48, 0x0a, 0x0a, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a,
	0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x6b, 0x65, 0x79, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x6b, 0x65, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x61, 0x0a, 0x0d, 0x4b, 0x65, 0x79,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x22, 0x0a, 0x0d, 0x72, 0x61,
	0x77, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0b, 0x72, 0x61, 0x77, 0x4b, 0x65, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2c,
	0x0a, 0x07, 0x6b, 0x65, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x22, 0x3a, 0x0a, 0x05,
	0x54, 0x78, 0x4f, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x6b, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x70, 0x6b, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0xe6, 0x02, 0x0a, 0x0e, 0x53, 0x69, 0x67,
	0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x31, 0x0a, 0x08, 0x6b,
	0x65, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x44, 0x65, 0x73, 0x63, 0x12, 0x21,
	0x0a, 0x0c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x77, 0x65, 0x61,
	0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x77, 0x65, 0x61,
	0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x54,
	0x77, 0x65, 0x61, 0x6b, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x70, 0x5f, 0x74, 0x77, 0x65, 0x61,
	0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x74, 0x61, 0x70, 0x54, 0x77, 0x65, 0x61,
	0x6b, 0x12, 0x25, 0x0a, 0x0e, 0x77, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x77, 0x69, 0x74, 0x6e, 0x65,
	0x73, 0x73, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x26, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72,
	0x70, 0x63, 0x2e, 0x54, 0x78, 0x4f, 0x75, 0x74, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x69, 0x67, 0x68, 0x61, 0x73, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x73, 0x69, 0x67, 0x68, 0x61, 0x73, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x34, 0x0a, 0x0b, 0x73,
	0x69, 0x67, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x13, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x22, 0x96, 0x01, 0x0a, 0x07, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x20, 0x0a,
	0x0c, 0x72, 0x61, 0x77, 0x5f, 0x74, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72, 0x61, 0x77, 0x54, 0x78, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x36, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x73, 0x12, 0x31, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e,
	0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x78, 0x4f, 0x75, 0x74, 0x52, 0x0b, 0x70,
	0x72, 0x65, 0x76, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x22, 0x25, 0x0a, 0x08, 0x53, 0x69,
	0x67, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x61, 0x77, 0x5f, 0x73, 0x69,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x07, 0x72, 0x61, 0x77, 0x53, 0x69, 0x67,
	0x73, 0x22, 0x46, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x77, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0c, 0x52, 0x07, 0x77, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69,
	0x67, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09,
	0x73, 0x69, 0x67, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x4c, 0x0a, 0x0f, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x39, 0x0a, 0x0d,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x22, 0xf8, 0x01, 0x0a, 0x0e, 0x53, 0x69, 0x67, 0x6e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6d, 0x73, 0x67, 0x12, 0x2c, 0x0a, 0x07,
	0x6b, 0x65, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x53, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x63, 0x68, 0x6e, 0x6f, 0x72, 0x72, 0x5f, 0x73, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x6e, 0x6f, 0x72, 0x72, 0x53, 0x69, 0x67, 0x12, 0x31, 0x0a,
	0x15, 0x73, 0x63, 0x68, 0x6e, 0x6f, 0x72, 0x72, 0x5f, 0x73, 0x69, 0x67, 0x5f, 0x74, 0x61, 0x70,
	0x5f, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x73, 0x63,
	0x68, 0x6e, 0x6f, 0x72, 0x72, 0x53, 0x69, 0x67, 0x54, 0x61, 0x70, 0x54, 0x77, 0x65, 0x61, 0x6b,
	0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x74,
	0x61, 0x67, 0x22, 0x2f, 0x0a, 0x0f, 0x53, 0x69, 0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x22, 0x92, 0x01, 0x0a, 0x10, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6d, 0x73, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x75, 0x62, 0x6b,
	0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x70, 0x75, 0x62, 0x6b, 0x65, 0x79,
	0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x73, 0x63, 0x68, 0x6e, 0x6f, 0x72, 0x72, 0x5f, 0x73,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x53, 0x63, 0x68, 0x6e,
	0x6f, 0x72, 0x72, 0x53, 0x69, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0x29, 0x0a, 0x11, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x22, 0xa2, 0x01, 0x0a, 0x10, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x70, 0x68, 0x65,
	0x6d, 0x65, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x75, 0x62, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0f, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x50, 0x75, 0x62,
	0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b,
	0x65, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x6b,
	0x65, 0x79, 0x4c, 0x6f, 0x63, 0x12, 0x31, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70,
	0x63, 0x2e, 0x4b, 0x65, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52,
	0x07, 0x6b, 0x65, 0x79, 0x44, 0x65, 0x73, 0x63, 0x22, 0x32, 0x0a, 0x11, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x22, 0x3d, 0x0a, 0x09,
	0x54, 0x77, 0x65, 0x61, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x77, 0x65,
	0x61, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x12,
	0x1a, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x78, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x58, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x59, 0x0a, 0x10, 0x54,
	0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x54, 0x77, 0x65, 0x61, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x6f, 0x6f, 0x74,
	0x12, 0x24, 0x0a, 0x0e, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6b, 0x65, 0x79, 0x53, 0x70, 0x65,
	0x6e, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xe6, 0x01, 0x0a, 0x18, 0x4d, 0x75, 0x53, 0x69, 0x67,
	0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x72, 0x5f, 0x70, 0x75, 0x62, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52,
	0x10, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x50, 0x75, 0x62, 0x6b, 0x65, 0x79,
	0x73, 0x12, 0x2a, 0x0a, 0x06, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x77, 0x65, 0x61,
	0x6b, 0x44, 0x65, 0x73, 0x63, 0x52, 0x06, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x73, 0x12, 0x3e, 0x0a,
	0x0d, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x54,
	0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x54, 0x77, 0x65, 0x61, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x52,
	0x0c, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x54, 0x77, 0x65, 0x61, 0x6b, 0x12, 0x30, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16,
	0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xa2, 0x01, 0x0a, 0x19, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x4b, 0x65, 0x79,
	0x12, 0x30, 0x0a, 0x14, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4b,
	0x65, 0x79, 0x12, 0x30, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75,
	0x53, 0x69, 0x67, 0x32, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x03, 0x0a, 0x14, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a,
	0x07, 0x6b, 0x65, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x4c, 0x6f, 0x63, 0x12, 0x2c, 0x0a, 0x12, 0x61,
	0x6c, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6b, 0x65, 0x79,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e,
	0x65, 0x72, 0x50, 0x75, 0x62, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x6f, 0x74, 0x68,
	0x65, 0x72, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x17, 0x6f,
	0x74, 0x68, 0x65, 0x72, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x06, 0x74, 0x77, 0x65, 0x61, 0x6b, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63,
	0x2e, 0x54, 0x77, 0x65, 0x61, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x52, 0x06, 0x74, 0x77, 0x65, 0x61,
	0x6b, 0x73, 0x12, 0x3e, 0x0a, 0x0d, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x74, 0x77,
	0x65, 0x61, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x69, 0x67, 0x6e,
	0x72, 0x70, 0x63, 0x2e, 0x54, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x54, 0x77, 0x65, 0x61, 0x6b,
	0x44, 0x65, 0x73, 0x63, 0x52, 0x0c, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f, 0x74, 0x54, 0x77, 0x65,
	0x61, 0x6b, 0x12, 0x30, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75,
	0x53, 0x69, 0x67, 0x32, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x18, 0x70, 0x72, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x16, 0x70, 0x72, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x22, 0x95,
	0x02, 0x0a, 0x15, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x6f,
	0x74, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x13,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6e, 0x6f, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x68, 0x61, 0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61, 0x76, 0x65, 0x41, 0x6c, 0x6c, 0x4e, 0x6f,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e,
	0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0x0a, 0x1b, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x1a, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6e, 0x6f, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x17, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4e, 0x6f, 0x6e, 0x63, 0x65,
	0x73, 0x22, 0x46, 0x0a, 0x1c, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x26, 0x0a, 0x0f, 0x68, 0x61, 0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6e, 0x6f,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x61, 0x76, 0x65,
	0x41, 0x6c, 0x6c, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x73, 0x0a, 0x11, 0x4d, 0x75, 0x53,
	0x69, 0x67, 0x32, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a,
	0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x22, 0x4c,
	0x0a, 0x12, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x72, 0x0a, 0x17,
	0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x53, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x18, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x16, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x22, 0x73, 0x0a, 0x18, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x53, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x13,
	0x68, 0x61, 0x76, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x68, 0x61, 0x76, 0x65, 0x41,
	0x6c, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x35, 0x0a, 0x14, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43,
	0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x17, 0x0a, 0x15,
	0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0x9c, 0x01, 0x0a, 0x0a, 0x53, 0x69, 0x67, 0x6e, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x45, 0x54,
	0x48, 0x4f, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x56, 0x30, 0x10, 0x00,
	0x12, 0x29, 0x0a, 0x25, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f,
	0x54, 0x41, 0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x50, 0x45, 0x4e,
	0x44, 0x5f, 0x42, 0x49, 0x50, 0x30, 0x30, 0x38, 0x36, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x54, 0x41, 0x50, 0x52, 0x4f,
	0x4f, 0x54, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x24,
	0x0a, 0x20, 0x53, 0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x54, 0x41,
	0x50, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x5f, 0x53, 0x50, 0x45,
	0x4e, 0x44, 0x10, 0x03, 0x2a, 0x62, 0x0a, 0x0d, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x55, 0x53, 0x49, 0x47, 0x32, 0x5f,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x55, 0x53, 0x49, 0x47, 0x32, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x30, 0x34, 0x30, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16,
	0x4d, 0x55, 0x53, 0x49, 0x47, 0x32, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56,
	0x31, 0x30, 0x30, 0x52, 0x43, 0x32, 0x10, 0x02, 0x32, 0xdb, 0x06, 0x0a, 0x06, 0x53, 0x69, 0x67,
	0x6e, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x0d, 0x53, 0x69, 0x67, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x61, 0x77, 0x12, 0x10, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x11, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x40, 0x0a, 0x12, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12,
	0x10, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65,
	0x71, 0x1a, 0x18, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x53,
	0x69, 0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x2e, 0x73, 0x69, 0x67,
	0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x1a, 0x18, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x46, 0x0a,
	0x0d, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x19,
	0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x1a, 0x2e, 0x73, 0x69, 0x67, 0x6e,
	0x72, 0x70, 0x63, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x48, 0x0a, 0x0f, 0x44, 0x65, 0x72, 0x69, 0x76, 0x65, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x19, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5a, 0x0a, 0x11, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0x21, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d,
	0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x4b, 0x65, 0x79, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70,
	0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x4b,
	0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x13, 0x4d,
	0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53,
	0x69, 0x67, 0x32, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69,
	0x67, 0x32, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x63, 0x0a, 0x14, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x24, 0x2e, 0x73, 0x69, 0x67, 0x6e,
	0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32,
	0x53, 0x69, 0x67, 0x6e, 0x12, 0x1a, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d,
	0x75, 0x53, 0x69, 0x67, 0x32, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1b, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67,
	0x32, 0x53, 0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a,
	0x10, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x53, 0x69,
	0x67, 0x12, 0x20, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69,
	0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x53, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x75,
	0x53, 0x69, 0x67, 0x32, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x53, 0x69, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32,
	0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x12, 0x1d, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70,
	0x63, 0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63,
	0x2e, 0x4d, 0x75, 0x53, 0x69, 0x67, 0x32, 0x43, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x2f, 0x5a, 0x2d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x6e, 0x69, 0x6e, 0x67, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x6c, 0x6e, 0x64, 0x2f, 0x6c, 0x6e, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x69, 0x67, 0x6e, 0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_signrpc_signer_proto_rawDescOnce sync.Once
	file_signrpc_signer_proto_rawDescData = file_signrpc_signer_proto_rawDesc
)

func file_signrpc_signer_proto_rawDescGZIP() []byte {
	file_signrpc_signer_proto_rawDescOnce.Do(func() {
		file_signrpc_signer_proto_rawDescData = protoimpl.X.CompressGZIP(file_signrpc_signer_proto_rawDescData)
	})
	return file_signrpc_signer_proto_rawDescData
}

var file_signrpc_signer_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_signrpc_signer_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_signrpc_signer_proto_goTypes = []interface{}{
	(SignMethod)(0),                      // 0: signrpc.SignMethod
	(MuSig2Version)(0),                   // 1: signrpc.MuSig2Version
	(*KeyLocator)(nil),                   // 2: signrpc.KeyLocator
	(*KeyDescriptor)(nil),                // 3: signrpc.KeyDescriptor
	(*TxOut)(nil),                        // 4: signrpc.TxOut
	(*SignDescriptor)(nil),               // 5: signrpc.SignDescriptor
	(*SignReq)(nil),                      // 6: signrpc.SignReq
	(*SignResp)(nil),                     // 7: signrpc.SignResp
	(*InputScript)(nil),                  // 8: signrpc.InputScript
	(*InputScriptResp)(nil),              // 9: signrpc.InputScriptResp
	(*SignMessageReq)(nil),               // 10: signrpc.SignMessageReq
	(*SignMessageResp)(nil),              // 11: signrpc.SignMessageResp
	(*VerifyMessageReq)(nil),             // 12: signrpc.VerifyMessageReq
	(*VerifyMessageResp)(nil),            // 13: signrpc.VerifyMessageResp
	(*SharedKeyRequest)(nil),             // 14: signrpc.SharedKeyRequest
	(*SharedKeyResponse)(nil),            // 15: signrpc.SharedKeyResponse
	(*TweakDesc)(nil),                    // 16: signrpc.TweakDesc
	(*TaprootTweakDesc)(nil),             // 17: signrpc.TaprootTweakDesc
	(*MuSig2CombineKeysRequest)(nil),     // 18: signrpc.MuSig2CombineKeysRequest
	(*MuSig2CombineKeysResponse)(nil),    // 19: signrpc.MuSig2CombineKeysResponse
	(*MuSig2SessionRequest)(nil),         // 20: signrpc.MuSig2SessionRequest
	(*MuSig2SessionResponse)(nil),        // 21: signrpc.MuSig2SessionResponse
	(*MuSig2RegisterNoncesRequest)(nil),  // 22: signrpc.MuSig2RegisterNoncesRequest
	(*MuSig2RegisterNoncesResponse)(nil), // 23: signrpc.MuSig2RegisterNoncesResponse
	(*MuSig2SignRequest)(nil),            // 24: signrpc.MuSig2SignRequest
	(*MuSig2SignResponse)(nil),           // 25: signrpc.MuSig2SignResponse
	(*MuSig2CombineSigRequest)(nil),      // 26: signrpc.MuSig2CombineSigRequest
	(*MuSig2CombineSigResponse)(nil),     // 27: signrpc.MuSig2CombineSigResponse
	(*MuSig2CleanupRequest)(nil),         // 28: signrpc.MuSig2CleanupRequest
	(*MuSig2CleanupResponse)(nil),        // 29: signrpc.MuSig2CleanupResponse
}
var file_signrpc_signer_proto_depIdxs = []int32{
	2,  // 0: signrpc.KeyDescriptor.key_loc:type_name -> signrpc.KeyLocator
	3,  // 1: signrpc.SignDescriptor.key_desc:type_name -> signrpc.KeyDescriptor
	4,  // 2: signrpc.SignDescriptor.output:type_name -> signrpc.TxOut
	0,  // 3: signrpc.SignDescriptor.sign_method:type_name -> signrpc.SignMethod
	5,  // 4: signrpc.SignReq.sign_descs:type_name -> signrpc.SignDescriptor
	4,  // 5: signrpc.SignReq.prev_outputs:type_name -> signrpc.TxOut
	8,  // 6: signrpc.InputScriptResp.input_scripts:type_name -> signrpc.InputScript
	2,  // 7: signrpc.SignMessageReq.key_loc:type_name -> signrpc.KeyLocator
	2,  // 8: signrpc.SharedKeyRequest.key_loc:type_name -> signrpc.KeyLocator
	3,  // 9: signrpc.SharedKeyRequest.key_desc:type_name -> signrpc.KeyDescriptor
	16, // 10: signrpc.MuSig2CombineKeysRequest.tweaks:type_name -> signrpc.TweakDesc
	17, // 11: signrpc.MuSig2CombineKeysRequest.taproot_tweak:type_name -> signrpc.TaprootTweakDesc
	1,  // 12: signrpc.MuSig2CombineKeysRequest.version:type_name -> signrpc.MuSig2Version
	1,  // 13: signrpc.MuSig2CombineKeysResponse.version:type_name -> signrpc.MuSig2Version
	2,  // 14: signrpc.MuSig2SessionRequest.key_loc:type_name -> signrpc.KeyLocator
	16, // 15: signrpc.MuSig2SessionRequest.tweaks:type_name -> signrpc.TweakDesc
	17, // 16: signrpc.MuSig2SessionRequest.taproot_tweak:type_name -> signrpc.TaprootTweakDesc
	1,  // 17: signrpc.MuSig2SessionRequest.version:type_name -> signrpc.MuSig2Version
	1,  // 18: signrpc.MuSig2SessionResponse.version:type_name -> signrpc.MuSig2Version
	6,  // 19: signrpc.Signer.SignOutputRaw:input_type -> signrpc.SignReq
	6,  // 20: signrpc.Signer.ComputeInputScript:input_type -> signrpc.SignReq
	10, // 21: signrpc.Signer.SignMessage:input_type -> signrpc.SignMessageReq
	12, // 22: signrpc.Signer.VerifyMessage:input_type -> signrpc.VerifyMessageReq
	14, // 23: signrpc.Signer.DeriveSharedKey:input_type -> signrpc.SharedKeyRequest
	18, // 24: signrpc.Signer.MuSig2CombineKeys:input_type -> signrpc.MuSig2CombineKeysRequest
	20, // 25: signrpc.Signer.MuSig2CreateSession:input_type -> signrpc.MuSig2SessionRequest
	22, // 26: signrpc.Signer.MuSig2RegisterNonces:input_type -> signrpc.MuSig2RegisterNoncesRequest
	24, // 27: signrpc.Signer.MuSig2Sign:input_type -> signrpc.MuSig2SignRequest
	26, // 28: signrpc.Signer.MuSig2CombineSig:input_type -> signrpc.MuSig2CombineSigRequest
	28, // 29: signrpc.Signer.MuSig2Cleanup:input_type -> signrpc.MuSig2CleanupRequest
	7,  // 30: signrpc.Signer.SignOutputRaw:output_type -> signrpc.SignResp
	9,  // 31: signrpc.Signer.ComputeInputScript:output_type -> signrpc.InputScriptResp
	11, // 32: signrpc.Signer.SignMessage:output_type -> signrpc.SignMessageResp
	13, // 33: signrpc.Signer.VerifyMessage:output_type -> signrpc.VerifyMessageResp
	15, // 34: signrpc.Signer.DeriveSharedKey:output_type -> signrpc.SharedKeyResponse
	19, // 35: signrpc.Signer.MuSig2CombineKeys:output_type -> signrpc.MuSig2CombineKeysResponse
	21, // 36: signrpc.Signer.MuSig2CreateSession:output_type -> signrpc.MuSig2SessionResponse
	23, // 37: signrpc.Signer.MuSig2RegisterNonces:output_type -> signrpc.MuSig2RegisterNoncesResponse
	25, // 38: signrpc.Signer.MuSig2Sign:output_type -> signrpc.MuSig2SignResponse
	27, // 39: signrpc.Signer.MuSig2CombineSig:output_type -> signrpc.MuSig2CombineSigResponse
	29, // 40: signrpc.Signer.MuSig2Cleanup:output_type -> signrpc.MuSig2CleanupResponse
	30, // [30:41] is the sub-list for method output_type
	19, // [19:30] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_signrpc_signer_proto_init() }
func file_signrpc_signer_proto_init() {
	if File_signrpc_signer_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_signrpc_signer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyLocator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TxOut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputScript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputScriptResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignMessageReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignMessageResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMessageReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMessageResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SharedKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SharedKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TweakDesc); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaprootTweakDesc); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2CombineKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2CombineKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2SessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2SessionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2RegisterNoncesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2RegisterNoncesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2SignRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2SignResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2CombineSigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2CombineSigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2CleanupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_signrpc_signer_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuSig2CleanupResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_signrpc_signer_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_signrpc_signer_proto_goTypes,
		DependencyIndexes: file_signrpc_signer_proto_depIdxs,
		EnumInfos:         file_signrpc_signer_proto_enumTypes,
		MessageInfos:      file_signrpc_signer_proto_msgTypes,
	}.Build()
	File_signrpc_signer_proto = out.File
	file_signrpc_signer_proto_rawDesc = nil
	file_signrpc_signer_proto_goTypes = nil
	file_signrpc_signer_proto_depIdxs = nil
}
