// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package lnrpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// LightningClient is the client API for Lightning service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LightningClient interface {
	// lncli: `walletbalance`
	// WalletBalance returns total unspent outputs(confirmed and unconfirmed), all
	// confirmed unspent outputs and all unconfirmed unspent outputs under control
	// of the wallet.
	WalletBalance(ctx context.Context, in *WalletBalanceRequest, opts ...grpc.CallOption) (*WalletBalanceResponse, error)
	// lncli: `channelbalance`
	// ChannelBalance returns a report on the total funds across all open channels,
	// categorized in local/remote, pending local/remote and unsettled local/remote
	// balances.
	ChannelBalance(ctx context.Context, in *ChannelBalanceRequest, opts ...grpc.CallOption) (*ChannelBalanceResponse, error)
	// lncli: `listchaintxns`
	// GetTransactions returns a list describing all the known transactions
	// relevant to the wallet.
	GetTransactions(ctx context.Context, in *GetTransactionsRequest, opts ...grpc.CallOption) (*TransactionDetails, error)
	// lncli: `estimatefee`
	// EstimateFee asks the chain backend to estimate the fee rate and total fees
	// for a transaction that pays to multiple specified outputs.
	//
	// When using REST, the `AddrToAmount` map type can be set by appending
	// `&AddrToAmount[<address>]=<amount_to_send>` to the URL. Unfortunately this
	// map type doesn't appear in the REST API documentation because of a bug in
	// the grpc-gateway library.
	EstimateFee(ctx context.Context, in *EstimateFeeRequest, opts ...grpc.CallOption) (*EstimateFeeResponse, error)
	// lncli: `sendcoins`
	// SendCoins executes a request to send coins to a particular address. Unlike
	// SendMany, this RPC call only allows creating a single output at a time. If
	// neither target_conf, or sat_per_vbyte are set, then the internal wallet will
	// consult its fee model to determine a fee for the default confirmation
	// target.
	SendCoins(ctx context.Context, in *SendCoinsRequest, opts ...grpc.CallOption) (*SendCoinsResponse, error)
	// lncli: `listunspent`
	// Deprecated, use walletrpc.ListUnspent instead.
	//
	// ListUnspent returns a list of all utxos spendable by the wallet with a
	// number of confirmations between the specified minimum and maximum.
	ListUnspent(ctx context.Context, in *ListUnspentRequest, opts ...grpc.CallOption) (*ListUnspentResponse, error)
	// SubscribeTransactions creates a uni-directional stream from the server to
	// the client in which any newly discovered transactions relevant to the
	// wallet are sent over.
	SubscribeTransactions(ctx context.Context, in *GetTransactionsRequest, opts ...grpc.CallOption) (Lightning_SubscribeTransactionsClient, error)
	// lncli: `sendmany`
	// SendMany handles a request for a transaction that creates multiple specified
	// outputs in parallel. If neither target_conf, or sat_per_vbyte are set, then
	// the internal wallet will consult its fee model to determine a fee for the
	// default confirmation target.
	SendMany(ctx context.Context, in *SendManyRequest, opts ...grpc.CallOption) (*SendManyResponse, error)
	// lncli: `newaddress`
	// NewAddress creates a new address under control of the local wallet.
	NewAddress(ctx context.Context, in *NewAddressRequest, opts ...grpc.CallOption) (*NewAddressResponse, error)
	// lncli: `signmessage`
	// SignMessage signs a message with this node's private key. The returned
	// signature string is `zbase32` encoded and pubkey recoverable, meaning that
	// only the message digest and signature are needed for verification.
	SignMessage(ctx context.Context, in *SignMessageRequest, opts ...grpc.CallOption) (*SignMessageResponse, error)
	// lncli: `verifymessage`
	// VerifyMessage verifies a signature over a message and recovers the signer's
	// public key. The signature is only deemed valid if the recovered public key
	// corresponds to a node key in the public Lightning network. The signature
	// must be zbase32 encoded and signed by an active node in the resident node's
	// channel database. In addition to returning the validity of the signature,
	// VerifyMessage also returns the recovered pubkey from the signature.
	VerifyMessage(ctx context.Context, in *VerifyMessageRequest, opts ...grpc.CallOption) (*VerifyMessageResponse, error)
	// lncli: `connect`
	// ConnectPeer attempts to establish a connection to a remote peer. This is at
	// the networking level, and is used for communication between nodes. This is
	// distinct from establishing a channel with a peer.
	ConnectPeer(ctx context.Context, in *ConnectPeerRequest, opts ...grpc.CallOption) (*ConnectPeerResponse, error)
	// lncli: `disconnect`
	// DisconnectPeer attempts to disconnect one peer from another identified by a
	// given pubKey. In the case that we currently have a pending or active channel
	// with the target peer, then this action will be not be allowed.
	DisconnectPeer(ctx context.Context, in *DisconnectPeerRequest, opts ...grpc.CallOption) (*DisconnectPeerResponse, error)
	// lncli: `listpeers`
	// ListPeers returns a verbose listing of all currently active peers.
	ListPeers(ctx context.Context, in *ListPeersRequest, opts ...grpc.CallOption) (*ListPeersResponse, error)
	// SubscribePeerEvents creates a uni-directional stream from the server to
	// the client in which any events relevant to the state of peers are sent
	// over. Events include peers going online and offline.
	SubscribePeerEvents(ctx context.Context, in *PeerEventSubscription, opts ...grpc.CallOption) (Lightning_SubscribePeerEventsClient, error)
	// lncli: `getinfo`
	// GetInfo returns general information concerning the lightning node including
	// it's identity pubkey, alias, the chains it is connected to, and information
	// concerning the number of open+pending channels.
	GetInfo(ctx context.Context, in *GetInfoRequest, opts ...grpc.CallOption) (*GetInfoResponse, error)
	// lncli: 'getdebuginfo'
	// GetDebugInfo returns debug information concerning the state of the daemon
	// and its subsystems. This includes the full configuration and the latest log
	// entries from the log file.
	GetDebugInfo(ctx context.Context, in *GetDebugInfoRequest, opts ...grpc.CallOption) (*GetDebugInfoResponse, error)
	// * lncli: `getrecoveryinfo`
	// GetRecoveryInfo returns information concerning the recovery mode including
	// whether it's in a recovery mode, whether the recovery is finished, and the
	// progress made so far.
	GetRecoveryInfo(ctx context.Context, in *GetRecoveryInfoRequest, opts ...grpc.CallOption) (*GetRecoveryInfoResponse, error)
	// lncli: `pendingchannels`
	// PendingChannels returns a list of all the channels that are currently
	// considered "pending". A channel is pending if it has finished the funding
	// workflow and is waiting for confirmations for the funding txn, or is in the
	// process of closure, either initiated cooperatively or non-cooperatively.
	PendingChannels(ctx context.Context, in *PendingChannelsRequest, opts ...grpc.CallOption) (*PendingChannelsResponse, error)
	// lncli: `listchannels`
	// ListChannels returns a description of all the open channels that this node
	// is a participant in.
	ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error)
	// SubscribeChannelEvents creates a uni-directional stream from the server to
	// the client in which any updates relevant to the state of the channels are
	// sent over. Events include new active channels, inactive channels, and closed
	// channels.
	SubscribeChannelEvents(ctx context.Context, in *ChannelEventSubscription, opts ...grpc.CallOption) (Lightning_SubscribeChannelEventsClient, error)
	// lncli: `closedchannels`
	// ClosedChannels returns a description of all the closed channels that
	// this node was a participant in.
	ClosedChannels(ctx context.Context, in *ClosedChannelsRequest, opts ...grpc.CallOption) (*ClosedChannelsResponse, error)
	// OpenChannelSync is a synchronous version of the OpenChannel RPC call. This
	// call is meant to be consumed by clients to the REST proxy. As with all
	// other sync calls, all byte slices are intended to be populated as hex
	// encoded strings.
	OpenChannelSync(ctx context.Context, in *OpenChannelRequest, opts ...grpc.CallOption) (*ChannelPoint, error)
	// lncli: `openchannel`
	// OpenChannel attempts to open a singly funded channel specified in the
	// request to a remote peer. Users are able to specify a target number of
	// blocks that the funding transaction should be confirmed in, or a manual fee
	// rate to us for the funding transaction. If neither are specified, then a
	// lax block confirmation target is used. Each OpenStatusUpdate will return
	// the pending channel ID of the in-progress channel. Depending on the
	// arguments specified in the OpenChannelRequest, this pending channel ID can
	// then be used to manually progress the channel funding flow.
	OpenChannel(ctx context.Context, in *OpenChannelRequest, opts ...grpc.CallOption) (Lightning_OpenChannelClient, error)
	// lncli: `batchopenchannel`
	// BatchOpenChannel attempts to open multiple single-funded channels in a
	// single transaction in an atomic way. This means either all channel open
	// requests succeed at once or all attempts are aborted if any of them fail.
	// This is the safer variant of using PSBTs to manually fund a batch of
	// channels through the OpenChannel RPC.
	BatchOpenChannel(ctx context.Context, in *BatchOpenChannelRequest, opts ...grpc.CallOption) (*BatchOpenChannelResponse, error)
	// FundingStateStep is an advanced funding related call that allows the caller
	// to either execute some preparatory steps for a funding workflow, or
	// manually progress a funding workflow. The primary way a funding flow is
	// identified is via its pending channel ID. As an example, this method can be
	// used to specify that we're expecting a funding flow for a particular
	// pending channel ID, for which we need to use specific parameters.
	// Alternatively, this can be used to interactively drive PSBT signing for
	// funding for partially complete funding transactions.
	FundingStateStep(ctx context.Context, in *FundingTransitionMsg, opts ...grpc.CallOption) (*FundingStateStepResp, error)
	// ChannelAcceptor dispatches a bi-directional streaming RPC in which
	// OpenChannel requests are sent to the client and the client responds with
	// a boolean that tells LND whether or not to accept the channel. This allows
	// node operators to specify their own criteria for accepting inbound channels
	// through a single persistent connection.
	ChannelAcceptor(ctx context.Context, opts ...grpc.CallOption) (Lightning_ChannelAcceptorClient, error)
	// lncli: `closechannel`
	// CloseChannel attempts to close an active channel identified by its channel
	// outpoint (ChannelPoint). The actions of this method can additionally be
	// augmented to attempt a force close after a timeout period in the case of an
	// inactive peer. If a non-force close (cooperative closure) is requested,
	// then the user can specify either a target number of blocks until the
	// closure transaction is confirmed, or a manual fee rate. If neither are
	// specified, then a default lax, block confirmation target is used.
	CloseChannel(ctx context.Context, in *CloseChannelRequest, opts ...grpc.CallOption) (Lightning_CloseChannelClient, error)
	// lncli: `abandonchannel`
	// AbandonChannel removes all channel state from the database except for a
	// close summary. This method can be used to get rid of permanently unusable
	// channels due to bugs fixed in newer versions of lnd. This method can also be
	// used to remove externally funded channels where the funding transaction was
	// never broadcast. Only available for non-externally funded channels in dev
	// build.
	AbandonChannel(ctx context.Context, in *AbandonChannelRequest, opts ...grpc.CallOption) (*AbandonChannelResponse, error)
	// Deprecated: Do not use.
	// lncli: `sendpayment`
	// Deprecated, use routerrpc.SendPaymentV2. SendPayment dispatches a
	// bi-directional streaming RPC for sending payments through the Lightning
	// Network. A single RPC invocation creates a persistent bi-directional
	// stream allowing clients to rapidly send payments through the Lightning
	// Network with a single persistent connection.
	SendPayment(ctx context.Context, opts ...grpc.CallOption) (Lightning_SendPaymentClient, error)
	// SendPaymentSync is the synchronous non-streaming version of SendPayment.
	// This RPC is intended to be consumed by clients of the REST proxy.
	// Additionally, this RPC expects the destination's public key and the payment
	// hash (if any) to be encoded as hex strings.
	SendPaymentSync(ctx context.Context, in *SendRequest, opts ...grpc.CallOption) (*SendResponse, error)
	// Deprecated: Do not use.
	// lncli: `sendtoroute`
	// Deprecated, use routerrpc.SendToRouteV2. SendToRoute is a bi-directional
	// streaming RPC for sending payment through the Lightning Network. This
	// method differs from SendPayment in that it allows users to specify a full
	// route manually. This can be used for things like rebalancing, and atomic
	// swaps.
	SendToRoute(ctx context.Context, opts ...grpc.CallOption) (Lightning_SendToRouteClient, error)
	// SendToRouteSync is a synchronous version of SendToRoute. It Will block
	// until the payment either fails or succeeds.
	SendToRouteSync(ctx context.Context, in *SendToRouteRequest, opts ...grpc.CallOption) (*SendResponse, error)
	// lncli: `addinvoice`
	// AddInvoice attempts to add a new invoice to the invoice database. Any
	// duplicated invoices are rejected, therefore all invoices *must* have a
	// unique payment preimage.
	AddInvoice(ctx context.Context, in *Invoice, opts ...grpc.CallOption) (*AddInvoiceResponse, error)
	// lncli: `listinvoices`
	// ListInvoices returns a list of all the invoices currently stored within the
	// database. Any active debug invoices are ignored. It has full support for
	// paginated responses, allowing users to query for specific invoices through
	// their add_index. This can be done by using either the first_index_offset or
	// last_index_offset fields included in the response as the index_offset of the
	// next request. By default, the first 100 invoices created will be returned.
	// Backwards pagination is also supported through the Reversed flag.
	ListInvoices(ctx context.Context, in *ListInvoiceRequest, opts ...grpc.CallOption) (*ListInvoiceResponse, error)
	// lncli: `lookupinvoice`
	// LookupInvoice attempts to look up an invoice according to its payment hash.
	// The passed payment hash *must* be exactly 32 bytes, if not, an error is
	// returned.
	LookupInvoice(ctx context.Context, in *PaymentHash, opts ...grpc.CallOption) (*Invoice, error)
	// SubscribeInvoices returns a uni-directional stream (server -> client) for
	// notifying the client of newly added/settled invoices. The caller can
	// optionally specify the add_index and/or the settle_index. If the add_index
	// is specified, then we'll first start by sending add invoice events for all
	// invoices with an add_index greater than the specified value. If the
	// settle_index is specified, then next, we'll send out all settle events for
	// invoices with a settle_index greater than the specified value. One or both
	// of these fields can be set. If no fields are set, then we'll only send out
	// the latest add/settle events.
	SubscribeInvoices(ctx context.Context, in *InvoiceSubscription, opts ...grpc.CallOption) (Lightning_SubscribeInvoicesClient, error)
	// lncli: `decodepayreq`
	// DecodePayReq takes an encoded payment request string and attempts to decode
	// it, returning a full description of the conditions encoded within the
	// payment request.
	DecodePayReq(ctx context.Context, in *PayReqString, opts ...grpc.CallOption) (*PayReq, error)
	// lncli: `listpayments`
	// ListPayments returns a list of all outgoing payments.
	ListPayments(ctx context.Context, in *ListPaymentsRequest, opts ...grpc.CallOption) (*ListPaymentsResponse, error)
	// lncli: `deletepayments`
	// DeletePayment deletes an outgoing payment from DB. Note that it will not
	// attempt to delete an In-Flight payment, since that would be unsafe.
	DeletePayment(ctx context.Context, in *DeletePaymentRequest, opts ...grpc.CallOption) (*DeletePaymentResponse, error)
	// lncli: `deletepayments --all`
	// DeleteAllPayments deletes all outgoing payments from DB. Note that it will
	// not attempt to delete In-Flight payments, since that would be unsafe.
	DeleteAllPayments(ctx context.Context, in *DeleteAllPaymentsRequest, opts ...grpc.CallOption) (*DeleteAllPaymentsResponse, error)
	// lncli: `describegraph`
	// DescribeGraph returns a description of the latest graph state from the
	// point of view of the node. The graph information is partitioned into two
	// components: all the nodes/vertexes, and all the edges that connect the
	// vertexes themselves. As this is a directed graph, the edges also contain
	// the node directional specific routing policy which includes: the time lock
	// delta, fee information, etc.
	DescribeGraph(ctx context.Context, in *ChannelGraphRequest, opts ...grpc.CallOption) (*ChannelGraph, error)
	// lncli: `getnodemetrics`
	// GetNodeMetrics returns node metrics calculated from the graph. Currently
	// the only supported metric is betweenness centrality of individual nodes.
	GetNodeMetrics(ctx context.Context, in *NodeMetricsRequest, opts ...grpc.CallOption) (*NodeMetricsResponse, error)
	// lncli: `getchaninfo`
	// GetChanInfo returns the latest authenticated network announcement for the
	// given channel identified by its channel ID: an 8-byte integer which
	// uniquely identifies the location of transaction's funding output within the
	// blockchain.
	GetChanInfo(ctx context.Context, in *ChanInfoRequest, opts ...grpc.CallOption) (*ChannelEdge, error)
	// lncli: `getnodeinfo`
	// GetNodeInfo returns the latest advertised, aggregated, and authenticated
	// channel information for the specified node identified by its public key.
	GetNodeInfo(ctx context.Context, in *NodeInfoRequest, opts ...grpc.CallOption) (*NodeInfo, error)
	// lncli: `queryroutes`
	// QueryRoutes attempts to query the daemon's Channel Router for a possible
	// route to a target destination capable of carrying a specific amount of
	// satoshis. The returned route contains the full details required to craft and
	// send an HTLC, also including the necessary information that should be
	// present within the Sphinx packet encapsulated within the HTLC.
	//
	// When using REST, the `dest_custom_records` map type can be set by appending
	// `&dest_custom_records[<record_number>]=<record_data_base64_url_encoded>`
	// to the URL. Unfortunately this map type doesn't appear in the REST API
	// documentation because of a bug in the grpc-gateway library.
	QueryRoutes(ctx context.Context, in *QueryRoutesRequest, opts ...grpc.CallOption) (*QueryRoutesResponse, error)
	// lncli: `getnetworkinfo`
	// GetNetworkInfo returns some basic stats about the known channel graph from
	// the point of view of the node.
	GetNetworkInfo(ctx context.Context, in *NetworkInfoRequest, opts ...grpc.CallOption) (*NetworkInfo, error)
	// lncli: `stop`
	// StopDaemon will send a shutdown request to the interrupt handler, triggering
	// a graceful shutdown of the daemon.
	StopDaemon(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error)
	// SubscribeChannelGraph launches a streaming RPC that allows the caller to
	// receive notifications upon any changes to the channel graph topology from
	// the point of view of the responding node. Events notified include: new
	// nodes coming online, nodes updating their authenticated attributes, new
	// channels being advertised, updates in the routing policy for a directional
	// channel edge, and when channels are closed on-chain.
	SubscribeChannelGraph(ctx context.Context, in *GraphTopologySubscription, opts ...grpc.CallOption) (Lightning_SubscribeChannelGraphClient, error)
	// lncli: `debuglevel`
	// DebugLevel allows a caller to programmatically set the logging verbosity of
	// lnd. The logging can be targeted according to a coarse daemon-wide logging
	// level, or in a granular fashion to specify the logging for a target
	// sub-system.
	DebugLevel(ctx context.Context, in *DebugLevelRequest, opts ...grpc.CallOption) (*DebugLevelResponse, error)
	// lncli: `feereport`
	// FeeReport allows the caller to obtain a report detailing the current fee
	// schedule enforced by the node globally for each channel.
	FeeReport(ctx context.Context, in *FeeReportRequest, opts ...grpc.CallOption) (*FeeReportResponse, error)
	// lncli: `updatechanpolicy`
	// UpdateChannelPolicy allows the caller to update the fee schedule and
	// channel policies for all channels globally, or a particular channel.
	UpdateChannelPolicy(ctx context.Context, in *PolicyUpdateRequest, opts ...grpc.CallOption) (*PolicyUpdateResponse, error)
	// lncli: `fwdinghistory`
	// ForwardingHistory allows the caller to query the htlcswitch for a record of
	// all HTLCs forwarded within the target time range, and integer offset
	// within that time range, for a maximum number of events. If no maximum number
	// of events is specified, up to 100 events will be returned. If no time-range
	// is specified, then events will be returned in the order that they occured.
	//
	// A list of forwarding events are returned. The size of each forwarding event
	// is 40 bytes, and the max message size able to be returned in gRPC is 4 MiB.
	// As a result each message can only contain 50k entries. Each response has
	// the index offset of the last entry. The index offset can be provided to the
	// request to allow the caller to skip a series of records.
	ForwardingHistory(ctx context.Context, in *ForwardingHistoryRequest, opts ...grpc.CallOption) (*ForwardingHistoryResponse, error)
	// lncli: `exportchanbackup`
	// ExportChannelBackup attempts to return an encrypted static channel backup
	// for the target channel identified by it channel point. The backup is
	// encrypted with a key generated from the aezeed seed of the user. The
	// returned backup can either be restored using the RestoreChannelBackup
	// method once lnd is running, or via the InitWallet and UnlockWallet methods
	// from the WalletUnlocker service.
	ExportChannelBackup(ctx context.Context, in *ExportChannelBackupRequest, opts ...grpc.CallOption) (*ChannelBackup, error)
	// ExportAllChannelBackups returns static channel backups for all existing
	// channels known to lnd. A set of regular singular static channel backups for
	// each channel are returned. Additionally, a multi-channel backup is returned
	// as well, which contains a single encrypted blob containing the backups of
	// each channel.
	ExportAllChannelBackups(ctx context.Context, in *ChanBackupExportRequest, opts ...grpc.CallOption) (*ChanBackupSnapshot, error)
	// lncli: `verifychanbackup`
	// VerifyChanBackup allows a caller to verify the integrity of a channel backup
	// snapshot. This method will accept either a packed Single or a packed Multi.
	// Specifying both will result in an error.
	VerifyChanBackup(ctx context.Context, in *ChanBackupSnapshot, opts ...grpc.CallOption) (*VerifyChanBackupResponse, error)
	// lncli: `restorechanbackup`
	// RestoreChannelBackups accepts a set of singular channel backups, or a
	// single encrypted multi-chan backup and attempts to recover any funds
	// remaining within the channel. If we are able to unpack the backup, then the
	// new channel will be shown under listchannels, as well as pending channels.
	RestoreChannelBackups(ctx context.Context, in *RestoreChanBackupRequest, opts ...grpc.CallOption) (*RestoreBackupResponse, error)
	// SubscribeChannelBackups allows a client to sub-subscribe to the most up to
	// date information concerning the state of all channel backups. Each time a
	// new channel is added, we return the new set of channels, along with a
	// multi-chan backup containing the backup info for all channels. Each time a
	// channel is closed, we send a new update, which contains new new chan back
	// ups, but the updated set of encrypted multi-chan backups with the closed
	// channel(s) removed.
	SubscribeChannelBackups(ctx context.Context, in *ChannelBackupSubscription, opts ...grpc.CallOption) (Lightning_SubscribeChannelBackupsClient, error)
	// lncli: `bakemacaroon`
	// BakeMacaroon allows the creation of a new macaroon with custom read and
	// write permissions. No first-party caveats are added since this can be done
	// offline.
	BakeMacaroon(ctx context.Context, in *BakeMacaroonRequest, opts ...grpc.CallOption) (*BakeMacaroonResponse, error)
	// lncli: `listmacaroonids`
	// ListMacaroonIDs returns all root key IDs that are in use.
	ListMacaroonIDs(ctx context.Context, in *ListMacaroonIDsRequest, opts ...grpc.CallOption) (*ListMacaroonIDsResponse, error)
	// lncli: `deletemacaroonid`
	// DeleteMacaroonID deletes the specified macaroon ID and invalidates all
	// macaroons derived from that ID.
	DeleteMacaroonID(ctx context.Context, in *DeleteMacaroonIDRequest, opts ...grpc.CallOption) (*DeleteMacaroonIDResponse, error)
	// lncli: `listpermissions`
	// ListPermissions lists all RPC method URIs and their required macaroon
	// permissions to access them.
	ListPermissions(ctx context.Context, in *ListPermissionsRequest, opts ...grpc.CallOption) (*ListPermissionsResponse, error)
	// CheckMacaroonPermissions checks whether a request follows the constraints
	// imposed on the macaroon and that the macaroon is authorized to follow the
	// provided permissions.
	CheckMacaroonPermissions(ctx context.Context, in *CheckMacPermRequest, opts ...grpc.CallOption) (*CheckMacPermResponse, error)
	// RegisterRPCMiddleware adds a new gRPC middleware to the interceptor chain. A
	// gRPC middleware is software component external to lnd that aims to add
	// additional business logic to lnd by observing/intercepting/validating
	// incoming gRPC client requests and (if needed) replacing/overwriting outgoing
	// messages before they're sent to the client. When registering the middleware
	// must identify itself and indicate what custom macaroon caveats it wants to
	// be responsible for. Only requests that contain a macaroon with that specific
	// custom caveat are then sent to the middleware for inspection. The other
	// option is to register for the read-only mode in which all requests/responses
	// are forwarded for interception to the middleware but the middleware is not
	// allowed to modify any responses. As a security measure, _no_ middleware can
	// modify responses for requests made with _unencumbered_ macaroons!
	RegisterRPCMiddleware(ctx context.Context, opts ...grpc.CallOption) (Lightning_RegisterRPCMiddlewareClient, error)
	// lncli: `sendcustom`
	// SendCustomMessage sends a custom peer message.
	SendCustomMessage(ctx context.Context, in *SendCustomMessageRequest, opts ...grpc.CallOption) (*SendCustomMessageResponse, error)
	// lncli: `subscribecustom`
	// SubscribeCustomMessages subscribes to a stream of incoming custom peer
	// messages.
	//
	// To include messages with type outside of the custom range (>= 32768) lnd
	// needs to be compiled with  the `dev` build tag, and the message type to
	// override should be specified in lnd's experimental protocol configuration.
	SubscribeCustomMessages(ctx context.Context, in *SubscribeCustomMessagesRequest, opts ...grpc.CallOption) (Lightning_SubscribeCustomMessagesClient, error)
	// lncli: `listaliases`
	// ListAliases returns the set of all aliases that have ever existed with
	// their confirmed SCID (if it exists) and/or the base SCID (in the case of
	// zero conf).
	ListAliases(ctx context.Context, in *ListAliasesRequest, opts ...grpc.CallOption) (*ListAliasesResponse, error)
	// LookupHtlcResolution retrieves a final htlc resolution from the database.
	// If the htlc has no final resolution yet, a NotFound grpc status code is
	// returned.
	LookupHtlcResolution(ctx context.Context, in *LookupHtlcResolutionRequest, opts ...grpc.CallOption) (*LookupHtlcResolutionResponse, error)
}

type lightningClient struct {
	cc grpc.ClientConnInterface
}

func NewLightningClient(cc grpc.ClientConnInterface) LightningClient {
	return &lightningClient{cc}
}

func (c *lightningClient) WalletBalance(ctx context.Context, in *WalletBalanceRequest, opts ...grpc.CallOption) (*WalletBalanceResponse, error) {
	out := new(WalletBalanceResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/WalletBalance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ChannelBalance(ctx context.Context, in *ChannelBalanceRequest, opts ...grpc.CallOption) (*ChannelBalanceResponse, error) {
	out := new(ChannelBalanceResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ChannelBalance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetTransactions(ctx context.Context, in *GetTransactionsRequest, opts ...grpc.CallOption) (*TransactionDetails, error) {
	out := new(TransactionDetails)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) EstimateFee(ctx context.Context, in *EstimateFeeRequest, opts ...grpc.CallOption) (*EstimateFeeResponse, error) {
	out := new(EstimateFeeResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/EstimateFee", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SendCoins(ctx context.Context, in *SendCoinsRequest, opts ...grpc.CallOption) (*SendCoinsResponse, error) {
	out := new(SendCoinsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/SendCoins", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListUnspent(ctx context.Context, in *ListUnspentRequest, opts ...grpc.CallOption) (*ListUnspentResponse, error) {
	out := new(ListUnspentResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListUnspent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribeTransactions(ctx context.Context, in *GetTransactionsRequest, opts ...grpc.CallOption) (Lightning_SubscribeTransactionsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[0], "/lnrpc.Lightning/SubscribeTransactions", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribeTransactionsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribeTransactionsClient interface {
	Recv() (*Transaction, error)
	grpc.ClientStream
}

type lightningSubscribeTransactionsClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribeTransactionsClient) Recv() (*Transaction, error) {
	m := new(Transaction)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) SendMany(ctx context.Context, in *SendManyRequest, opts ...grpc.CallOption) (*SendManyResponse, error) {
	out := new(SendManyResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/SendMany", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) NewAddress(ctx context.Context, in *NewAddressRequest, opts ...grpc.CallOption) (*NewAddressResponse, error) {
	out := new(NewAddressResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/NewAddress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SignMessage(ctx context.Context, in *SignMessageRequest, opts ...grpc.CallOption) (*SignMessageResponse, error) {
	out := new(SignMessageResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/SignMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) VerifyMessage(ctx context.Context, in *VerifyMessageRequest, opts ...grpc.CallOption) (*VerifyMessageResponse, error) {
	out := new(VerifyMessageResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/VerifyMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ConnectPeer(ctx context.Context, in *ConnectPeerRequest, opts ...grpc.CallOption) (*ConnectPeerResponse, error) {
	out := new(ConnectPeerResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ConnectPeer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) DisconnectPeer(ctx context.Context, in *DisconnectPeerRequest, opts ...grpc.CallOption) (*DisconnectPeerResponse, error) {
	out := new(DisconnectPeerResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DisconnectPeer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListPeers(ctx context.Context, in *ListPeersRequest, opts ...grpc.CallOption) (*ListPeersResponse, error) {
	out := new(ListPeersResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListPeers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribePeerEvents(ctx context.Context, in *PeerEventSubscription, opts ...grpc.CallOption) (Lightning_SubscribePeerEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[1], "/lnrpc.Lightning/SubscribePeerEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribePeerEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribePeerEventsClient interface {
	Recv() (*PeerEvent, error)
	grpc.ClientStream
}

type lightningSubscribePeerEventsClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribePeerEventsClient) Recv() (*PeerEvent, error) {
	m := new(PeerEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) GetInfo(ctx context.Context, in *GetInfoRequest, opts ...grpc.CallOption) (*GetInfoResponse, error) {
	out := new(GetInfoResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetDebugInfo(ctx context.Context, in *GetDebugInfoRequest, opts ...grpc.CallOption) (*GetDebugInfoResponse, error) {
	out := new(GetDebugInfoResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetDebugInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetRecoveryInfo(ctx context.Context, in *GetRecoveryInfoRequest, opts ...grpc.CallOption) (*GetRecoveryInfoResponse, error) {
	out := new(GetRecoveryInfoResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetRecoveryInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) PendingChannels(ctx context.Context, in *PendingChannelsRequest, opts ...grpc.CallOption) (*PendingChannelsResponse, error) {
	out := new(PendingChannelsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/PendingChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribeChannelEvents(ctx context.Context, in *ChannelEventSubscription, opts ...grpc.CallOption) (Lightning_SubscribeChannelEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[2], "/lnrpc.Lightning/SubscribeChannelEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribeChannelEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribeChannelEventsClient interface {
	Recv() (*ChannelEventUpdate, error)
	grpc.ClientStream
}

type lightningSubscribeChannelEventsClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribeChannelEventsClient) Recv() (*ChannelEventUpdate, error) {
	m := new(ChannelEventUpdate)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) ClosedChannels(ctx context.Context, in *ClosedChannelsRequest, opts ...grpc.CallOption) (*ClosedChannelsResponse, error) {
	out := new(ClosedChannelsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ClosedChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) OpenChannelSync(ctx context.Context, in *OpenChannelRequest, opts ...grpc.CallOption) (*ChannelPoint, error) {
	out := new(ChannelPoint)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/OpenChannelSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) OpenChannel(ctx context.Context, in *OpenChannelRequest, opts ...grpc.CallOption) (Lightning_OpenChannelClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[3], "/lnrpc.Lightning/OpenChannel", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningOpenChannelClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_OpenChannelClient interface {
	Recv() (*OpenStatusUpdate, error)
	grpc.ClientStream
}

type lightningOpenChannelClient struct {
	grpc.ClientStream
}

func (x *lightningOpenChannelClient) Recv() (*OpenStatusUpdate, error) {
	m := new(OpenStatusUpdate)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) BatchOpenChannel(ctx context.Context, in *BatchOpenChannelRequest, opts ...grpc.CallOption) (*BatchOpenChannelResponse, error) {
	out := new(BatchOpenChannelResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/BatchOpenChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) FundingStateStep(ctx context.Context, in *FundingTransitionMsg, opts ...grpc.CallOption) (*FundingStateStepResp, error) {
	out := new(FundingStateStepResp)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/FundingStateStep", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ChannelAcceptor(ctx context.Context, opts ...grpc.CallOption) (Lightning_ChannelAcceptorClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[4], "/lnrpc.Lightning/ChannelAcceptor", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningChannelAcceptorClient{stream}
	return x, nil
}

type Lightning_ChannelAcceptorClient interface {
	Send(*ChannelAcceptResponse) error
	Recv() (*ChannelAcceptRequest, error)
	grpc.ClientStream
}

type lightningChannelAcceptorClient struct {
	grpc.ClientStream
}

func (x *lightningChannelAcceptorClient) Send(m *ChannelAcceptResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *lightningChannelAcceptorClient) Recv() (*ChannelAcceptRequest, error) {
	m := new(ChannelAcceptRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) CloseChannel(ctx context.Context, in *CloseChannelRequest, opts ...grpc.CallOption) (Lightning_CloseChannelClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[5], "/lnrpc.Lightning/CloseChannel", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningCloseChannelClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_CloseChannelClient interface {
	Recv() (*CloseStatusUpdate, error)
	grpc.ClientStream
}

type lightningCloseChannelClient struct {
	grpc.ClientStream
}

func (x *lightningCloseChannelClient) Recv() (*CloseStatusUpdate, error) {
	m := new(CloseStatusUpdate)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) AbandonChannel(ctx context.Context, in *AbandonChannelRequest, opts ...grpc.CallOption) (*AbandonChannelResponse, error) {
	out := new(AbandonChannelResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/AbandonChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *lightningClient) SendPayment(ctx context.Context, opts ...grpc.CallOption) (Lightning_SendPaymentClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[6], "/lnrpc.Lightning/SendPayment", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSendPaymentClient{stream}
	return x, nil
}

type Lightning_SendPaymentClient interface {
	Send(*SendRequest) error
	Recv() (*SendResponse, error)
	grpc.ClientStream
}

type lightningSendPaymentClient struct {
	grpc.ClientStream
}

func (x *lightningSendPaymentClient) Send(m *SendRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *lightningSendPaymentClient) Recv() (*SendResponse, error) {
	m := new(SendResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) SendPaymentSync(ctx context.Context, in *SendRequest, opts ...grpc.CallOption) (*SendResponse, error) {
	out := new(SendResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/SendPaymentSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *lightningClient) SendToRoute(ctx context.Context, opts ...grpc.CallOption) (Lightning_SendToRouteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[7], "/lnrpc.Lightning/SendToRoute", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSendToRouteClient{stream}
	return x, nil
}

type Lightning_SendToRouteClient interface {
	Send(*SendToRouteRequest) error
	Recv() (*SendResponse, error)
	grpc.ClientStream
}

type lightningSendToRouteClient struct {
	grpc.ClientStream
}

func (x *lightningSendToRouteClient) Send(m *SendToRouteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *lightningSendToRouteClient) Recv() (*SendResponse, error) {
	m := new(SendResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) SendToRouteSync(ctx context.Context, in *SendToRouteRequest, opts ...grpc.CallOption) (*SendResponse, error) {
	out := new(SendResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/SendToRouteSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) AddInvoice(ctx context.Context, in *Invoice, opts ...grpc.CallOption) (*AddInvoiceResponse, error) {
	out := new(AddInvoiceResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/AddInvoice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListInvoices(ctx context.Context, in *ListInvoiceRequest, opts ...grpc.CallOption) (*ListInvoiceResponse, error) {
	out := new(ListInvoiceResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListInvoices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) LookupInvoice(ctx context.Context, in *PaymentHash, opts ...grpc.CallOption) (*Invoice, error) {
	out := new(Invoice)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/LookupInvoice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribeInvoices(ctx context.Context, in *InvoiceSubscription, opts ...grpc.CallOption) (Lightning_SubscribeInvoicesClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[8], "/lnrpc.Lightning/SubscribeInvoices", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribeInvoicesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribeInvoicesClient interface {
	Recv() (*Invoice, error)
	grpc.ClientStream
}

type lightningSubscribeInvoicesClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribeInvoicesClient) Recv() (*Invoice, error) {
	m := new(Invoice)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) DecodePayReq(ctx context.Context, in *PayReqString, opts ...grpc.CallOption) (*PayReq, error) {
	out := new(PayReq)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DecodePayReq", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListPayments(ctx context.Context, in *ListPaymentsRequest, opts ...grpc.CallOption) (*ListPaymentsResponse, error) {
	out := new(ListPaymentsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListPayments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) DeletePayment(ctx context.Context, in *DeletePaymentRequest, opts ...grpc.CallOption) (*DeletePaymentResponse, error) {
	out := new(DeletePaymentResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DeletePayment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) DeleteAllPayments(ctx context.Context, in *DeleteAllPaymentsRequest, opts ...grpc.CallOption) (*DeleteAllPaymentsResponse, error) {
	out := new(DeleteAllPaymentsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DeleteAllPayments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) DescribeGraph(ctx context.Context, in *ChannelGraphRequest, opts ...grpc.CallOption) (*ChannelGraph, error) {
	out := new(ChannelGraph)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DescribeGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetNodeMetrics(ctx context.Context, in *NodeMetricsRequest, opts ...grpc.CallOption) (*NodeMetricsResponse, error) {
	out := new(NodeMetricsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetNodeMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetChanInfo(ctx context.Context, in *ChanInfoRequest, opts ...grpc.CallOption) (*ChannelEdge, error) {
	out := new(ChannelEdge)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetChanInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetNodeInfo(ctx context.Context, in *NodeInfoRequest, opts ...grpc.CallOption) (*NodeInfo, error) {
	out := new(NodeInfo)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetNodeInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) QueryRoutes(ctx context.Context, in *QueryRoutesRequest, opts ...grpc.CallOption) (*QueryRoutesResponse, error) {
	out := new(QueryRoutesResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/QueryRoutes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) GetNetworkInfo(ctx context.Context, in *NetworkInfoRequest, opts ...grpc.CallOption) (*NetworkInfo, error) {
	out := new(NetworkInfo)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/GetNetworkInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) StopDaemon(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error) {
	out := new(StopResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/StopDaemon", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribeChannelGraph(ctx context.Context, in *GraphTopologySubscription, opts ...grpc.CallOption) (Lightning_SubscribeChannelGraphClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[9], "/lnrpc.Lightning/SubscribeChannelGraph", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribeChannelGraphClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribeChannelGraphClient interface {
	Recv() (*GraphTopologyUpdate, error)
	grpc.ClientStream
}

type lightningSubscribeChannelGraphClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribeChannelGraphClient) Recv() (*GraphTopologyUpdate, error) {
	m := new(GraphTopologyUpdate)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) DebugLevel(ctx context.Context, in *DebugLevelRequest, opts ...grpc.CallOption) (*DebugLevelResponse, error) {
	out := new(DebugLevelResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DebugLevel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) FeeReport(ctx context.Context, in *FeeReportRequest, opts ...grpc.CallOption) (*FeeReportResponse, error) {
	out := new(FeeReportResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/FeeReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) UpdateChannelPolicy(ctx context.Context, in *PolicyUpdateRequest, opts ...grpc.CallOption) (*PolicyUpdateResponse, error) {
	out := new(PolicyUpdateResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/UpdateChannelPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ForwardingHistory(ctx context.Context, in *ForwardingHistoryRequest, opts ...grpc.CallOption) (*ForwardingHistoryResponse, error) {
	out := new(ForwardingHistoryResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ForwardingHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ExportChannelBackup(ctx context.Context, in *ExportChannelBackupRequest, opts ...grpc.CallOption) (*ChannelBackup, error) {
	out := new(ChannelBackup)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ExportChannelBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ExportAllChannelBackups(ctx context.Context, in *ChanBackupExportRequest, opts ...grpc.CallOption) (*ChanBackupSnapshot, error) {
	out := new(ChanBackupSnapshot)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ExportAllChannelBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) VerifyChanBackup(ctx context.Context, in *ChanBackupSnapshot, opts ...grpc.CallOption) (*VerifyChanBackupResponse, error) {
	out := new(VerifyChanBackupResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/VerifyChanBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) RestoreChannelBackups(ctx context.Context, in *RestoreChanBackupRequest, opts ...grpc.CallOption) (*RestoreBackupResponse, error) {
	out := new(RestoreBackupResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/RestoreChannelBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribeChannelBackups(ctx context.Context, in *ChannelBackupSubscription, opts ...grpc.CallOption) (Lightning_SubscribeChannelBackupsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[10], "/lnrpc.Lightning/SubscribeChannelBackups", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribeChannelBackupsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribeChannelBackupsClient interface {
	Recv() (*ChanBackupSnapshot, error)
	grpc.ClientStream
}

type lightningSubscribeChannelBackupsClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribeChannelBackupsClient) Recv() (*ChanBackupSnapshot, error) {
	m := new(ChanBackupSnapshot)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) BakeMacaroon(ctx context.Context, in *BakeMacaroonRequest, opts ...grpc.CallOption) (*BakeMacaroonResponse, error) {
	out := new(BakeMacaroonResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/BakeMacaroon", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListMacaroonIDs(ctx context.Context, in *ListMacaroonIDsRequest, opts ...grpc.CallOption) (*ListMacaroonIDsResponse, error) {
	out := new(ListMacaroonIDsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListMacaroonIDs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) DeleteMacaroonID(ctx context.Context, in *DeleteMacaroonIDRequest, opts ...grpc.CallOption) (*DeleteMacaroonIDResponse, error) {
	out := new(DeleteMacaroonIDResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/DeleteMacaroonID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) ListPermissions(ctx context.Context, in *ListPermissionsRequest, opts ...grpc.CallOption) (*ListPermissionsResponse, error) {
	out := new(ListPermissionsResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) CheckMacaroonPermissions(ctx context.Context, in *CheckMacPermRequest, opts ...grpc.CallOption) (*CheckMacPermResponse, error) {
	out := new(CheckMacPermResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/CheckMacaroonPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) RegisterRPCMiddleware(ctx context.Context, opts ...grpc.CallOption) (Lightning_RegisterRPCMiddlewareClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[11], "/lnrpc.Lightning/RegisterRPCMiddleware", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningRegisterRPCMiddlewareClient{stream}
	return x, nil
}

type Lightning_RegisterRPCMiddlewareClient interface {
	Send(*RPCMiddlewareResponse) error
	Recv() (*RPCMiddlewareRequest, error)
	grpc.ClientStream
}

type lightningRegisterRPCMiddlewareClient struct {
	grpc.ClientStream
}

func (x *lightningRegisterRPCMiddlewareClient) Send(m *RPCMiddlewareResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *lightningRegisterRPCMiddlewareClient) Recv() (*RPCMiddlewareRequest, error) {
	m := new(RPCMiddlewareRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) SendCustomMessage(ctx context.Context, in *SendCustomMessageRequest, opts ...grpc.CallOption) (*SendCustomMessageResponse, error) {
	out := new(SendCustomMessageResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/SendCustomMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) SubscribeCustomMessages(ctx context.Context, in *SubscribeCustomMessagesRequest, opts ...grpc.CallOption) (Lightning_SubscribeCustomMessagesClient, error) {
	stream, err := c.cc.NewStream(ctx, &Lightning_ServiceDesc.Streams[12], "/lnrpc.Lightning/SubscribeCustomMessages", opts...)
	if err != nil {
		return nil, err
	}
	x := &lightningSubscribeCustomMessagesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Lightning_SubscribeCustomMessagesClient interface {
	Recv() (*CustomMessage, error)
	grpc.ClientStream
}

type lightningSubscribeCustomMessagesClient struct {
	grpc.ClientStream
}

func (x *lightningSubscribeCustomMessagesClient) Recv() (*CustomMessage, error) {
	m := new(CustomMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *lightningClient) ListAliases(ctx context.Context, in *ListAliasesRequest, opts ...grpc.CallOption) (*ListAliasesResponse, error) {
	out := new(ListAliasesResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/ListAliases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lightningClient) LookupHtlcResolution(ctx context.Context, in *LookupHtlcResolutionRequest, opts ...grpc.CallOption) (*LookupHtlcResolutionResponse, error) {
	out := new(LookupHtlcResolutionResponse)
	err := c.cc.Invoke(ctx, "/lnrpc.Lightning/LookupHtlcResolution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LightningServer is the server API for Lightning service.
// All implementations must embed UnimplementedLightningServer
// for forward compatibility
type LightningServer interface {
	// lncli: `walletbalance`
	// WalletBalance returns total unspent outputs(confirmed and unconfirmed), all
	// confirmed unspent outputs and all unconfirmed unspent outputs under control
	// of the wallet.
	WalletBalance(context.Context, *WalletBalanceRequest) (*WalletBalanceResponse, error)
	// lncli: `channelbalance`
	// ChannelBalance returns a report on the total funds across all open channels,
	// categorized in local/remote, pending local/remote and unsettled local/remote
	// balances.
	ChannelBalance(context.Context, *ChannelBalanceRequest) (*ChannelBalanceResponse, error)
	// lncli: `listchaintxns`
	// GetTransactions returns a list describing all the known transactions
	// relevant to the wallet.
	GetTransactions(context.Context, *GetTransactionsRequest) (*TransactionDetails, error)
	// lncli: `estimatefee`
	// EstimateFee asks the chain backend to estimate the fee rate and total fees
	// for a transaction that pays to multiple specified outputs.
	//
	// When using REST, the `AddrToAmount` map type can be set by appending
	// `&AddrToAmount[<address>]=<amount_to_send>` to the URL. Unfortunately this
	// map type doesn't appear in the REST API documentation because of a bug in
	// the grpc-gateway library.
	EstimateFee(context.Context, *EstimateFeeRequest) (*EstimateFeeResponse, error)
	// lncli: `sendcoins`
	// SendCoins executes a request to send coins to a particular address. Unlike
	// SendMany, this RPC call only allows creating a single output at a time. If
	// neither target_conf, or sat_per_vbyte are set, then the internal wallet will
	// consult its fee model to determine a fee for the default confirmation
	// target.
	SendCoins(context.Context, *SendCoinsRequest) (*SendCoinsResponse, error)
	// lncli: `listunspent`
	// Deprecated, use walletrpc.ListUnspent instead.
	//
	// ListUnspent returns a list of all utxos spendable by the wallet with a
	// number of confirmations between the specified minimum and maximum.
	ListUnspent(context.Context, *ListUnspentRequest) (*ListUnspentResponse, error)
	// SubscribeTransactions creates a uni-directional stream from the server to
	// the client in which any newly discovered transactions relevant to the
	// wallet are sent over.
	SubscribeTransactions(*GetTransactionsRequest, Lightning_SubscribeTransactionsServer) error
	// lncli: `sendmany`
	// SendMany handles a request for a transaction that creates multiple specified
	// outputs in parallel. If neither target_conf, or sat_per_vbyte are set, then
	// the internal wallet will consult its fee model to determine a fee for the
	// default confirmation target.
	SendMany(context.Context, *SendManyRequest) (*SendManyResponse, error)
	// lncli: `newaddress`
	// NewAddress creates a new address under control of the local wallet.
	NewAddress(context.Context, *NewAddressRequest) (*NewAddressResponse, error)
	// lncli: `signmessage`
	// SignMessage signs a message with this node's private key. The returned
	// signature string is `zbase32` encoded and pubkey recoverable, meaning that
	// only the message digest and signature are needed for verification.
	SignMessage(context.Context, *SignMessageRequest) (*SignMessageResponse, error)
	// lncli: `verifymessage`
	// VerifyMessage verifies a signature over a message and recovers the signer's
	// public key. The signature is only deemed valid if the recovered public key
	// corresponds to a node key in the public Lightning network. The signature
	// must be zbase32 encoded and signed by an active node in the resident node's
	// channel database. In addition to returning the validity of the signature,
	// VerifyMessage also returns the recovered pubkey from the signature.
	VerifyMessage(context.Context, *VerifyMessageRequest) (*VerifyMessageResponse, error)
	// lncli: `connect`
	// ConnectPeer attempts to establish a connection to a remote peer. This is at
	// the networking level, and is used for communication between nodes. This is
	// distinct from establishing a channel with a peer.
	ConnectPeer(context.Context, *ConnectPeerRequest) (*ConnectPeerResponse, error)
	// lncli: `disconnect`
	// DisconnectPeer attempts to disconnect one peer from another identified by a
	// given pubKey. In the case that we currently have a pending or active channel
	// with the target peer, then this action will be not be allowed.
	DisconnectPeer(context.Context, *DisconnectPeerRequest) (*DisconnectPeerResponse, error)
	// lncli: `listpeers`
	// ListPeers returns a verbose listing of all currently active peers.
	ListPeers(context.Context, *ListPeersRequest) (*ListPeersResponse, error)
	// SubscribePeerEvents creates a uni-directional stream from the server to
	// the client in which any events relevant to the state of peers are sent
	// over. Events include peers going online and offline.
	SubscribePeerEvents(*PeerEventSubscription, Lightning_SubscribePeerEventsServer) error
	// lncli: `getinfo`
	// GetInfo returns general information concerning the lightning node including
	// it's identity pubkey, alias, the chains it is connected to, and information
	// concerning the number of open+pending channels.
	GetInfo(context.Context, *GetInfoRequest) (*GetInfoResponse, error)
	// lncli: 'getdebuginfo'
	// GetDebugInfo returns debug information concerning the state of the daemon
	// and its subsystems. This includes the full configuration and the latest log
	// entries from the log file.
	GetDebugInfo(context.Context, *GetDebugInfoRequest) (*GetDebugInfoResponse, error)
	// * lncli: `getrecoveryinfo`
	// GetRecoveryInfo returns information concerning the recovery mode including
	// whether it's in a recovery mode, whether the recovery is finished, and the
	// progress made so far.
	GetRecoveryInfo(context.Context, *GetRecoveryInfoRequest) (*GetRecoveryInfoResponse, error)
	// lncli: `pendingchannels`
	// PendingChannels returns a list of all the channels that are currently
	// considered "pending". A channel is pending if it has finished the funding
	// workflow and is waiting for confirmations for the funding txn, or is in the
	// process of closure, either initiated cooperatively or non-cooperatively.
	PendingChannels(context.Context, *PendingChannelsRequest) (*PendingChannelsResponse, error)
	// lncli: `listchannels`
	// ListChannels returns a description of all the open channels that this node
	// is a participant in.
	ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error)
	// SubscribeChannelEvents creates a uni-directional stream from the server to
	// the client in which any updates relevant to the state of the channels are
	// sent over. Events include new active channels, inactive channels, and closed
	// channels.
	SubscribeChannelEvents(*ChannelEventSubscription, Lightning_SubscribeChannelEventsServer) error
	// lncli: `closedchannels`
	// ClosedChannels returns a description of all the closed channels that
	// this node was a participant in.
	ClosedChannels(context.Context, *ClosedChannelsRequest) (*ClosedChannelsResponse, error)
	// OpenChannelSync is a synchronous version of the OpenChannel RPC call. This
	// call is meant to be consumed by clients to the REST proxy. As with all
	// other sync calls, all byte slices are intended to be populated as hex
	// encoded strings.
	OpenChannelSync(context.Context, *OpenChannelRequest) (*ChannelPoint, error)
	// lncli: `openchannel`
	// OpenChannel attempts to open a singly funded channel specified in the
	// request to a remote peer. Users are able to specify a target number of
	// blocks that the funding transaction should be confirmed in, or a manual fee
	// rate to us for the funding transaction. If neither are specified, then a
	// lax block confirmation target is used. Each OpenStatusUpdate will return
	// the pending channel ID of the in-progress channel. Depending on the
	// arguments specified in the OpenChannelRequest, this pending channel ID can
	// then be used to manually progress the channel funding flow.
	OpenChannel(*OpenChannelRequest, Lightning_OpenChannelServer) error
	// lncli: `batchopenchannel`
	// BatchOpenChannel attempts to open multiple single-funded channels in a
	// single transaction in an atomic way. This means either all channel open
	// requests succeed at once or all attempts are aborted if any of them fail.
	// This is the safer variant of using PSBTs to manually fund a batch of
	// channels through the OpenChannel RPC.
	BatchOpenChannel(context.Context, *BatchOpenChannelRequest) (*BatchOpenChannelResponse, error)
	// FundingStateStep is an advanced funding related call that allows the caller
	// to either execute some preparatory steps for a funding workflow, or
	// manually progress a funding workflow. The primary way a funding flow is
	// identified is via its pending channel ID. As an example, this method can be
	// used to specify that we're expecting a funding flow for a particular
	// pending channel ID, for which we need to use specific parameters.
	// Alternatively, this can be used to interactively drive PSBT signing for
	// funding for partially complete funding transactions.
	FundingStateStep(context.Context, *FundingTransitionMsg) (*FundingStateStepResp, error)
	// ChannelAcceptor dispatches a bi-directional streaming RPC in which
	// OpenChannel requests are sent to the client and the client responds with
	// a boolean that tells LND whether or not to accept the channel. This allows
	// node operators to specify their own criteria for accepting inbound channels
	// through a single persistent connection.
	ChannelAcceptor(Lightning_ChannelAcceptorServer) error
	// lncli: `closechannel`
	// CloseChannel attempts to close an active channel identified by its channel
	// outpoint (ChannelPoint). The actions of this method can additionally be
	// augmented to attempt a force close after a timeout period in the case of an
	// inactive peer. If a non-force close (cooperative closure) is requested,
	// then the user can specify either a target number of blocks until the
	// closure transaction is confirmed, or a manual fee rate. If neither are
	// specified, then a default lax, block confirmation target is used.
	CloseChannel(*CloseChannelRequest, Lightning_CloseChannelServer) error
	// lncli: `abandonchannel`
	// AbandonChannel removes all channel state from the database except for a
	// close summary. This method can be used to get rid of permanently unusable
	// channels due to bugs fixed in newer versions of lnd. This method can also be
	// used to remove externally funded channels where the funding transaction was
	// never broadcast. Only available for non-externally funded channels in dev
	// build.
	AbandonChannel(context.Context, *AbandonChannelRequest) (*AbandonChannelResponse, error)
	// Deprecated: Do not use.
	// lncli: `sendpayment`
	// Deprecated, use routerrpc.SendPaymentV2. SendPayment dispatches a
	// bi-directional streaming RPC for sending payments through the Lightning
	// Network. A single RPC invocation creates a persistent bi-directional
	// stream allowing clients to rapidly send payments through the Lightning
	// Network with a single persistent connection.
	SendPayment(Lightning_SendPaymentServer) error
	// SendPaymentSync is the synchronous non-streaming version of SendPayment.
	// This RPC is intended to be consumed by clients of the REST proxy.
	// Additionally, this RPC expects the destination's public key and the payment
	// hash (if any) to be encoded as hex strings.
	SendPaymentSync(context.Context, *SendRequest) (*SendResponse, error)
	// Deprecated: Do not use.
	// lncli: `sendtoroute`
	// Deprecated, use routerrpc.SendToRouteV2. SendToRoute is a bi-directional
	// streaming RPC for sending payment through the Lightning Network. This
	// method differs from SendPayment in that it allows users to specify a full
	// route manually. This can be used for things like rebalancing, and atomic
	// swaps.
	SendToRoute(Lightning_SendToRouteServer) error
	// SendToRouteSync is a synchronous version of SendToRoute. It Will block
	// until the payment either fails or succeeds.
	SendToRouteSync(context.Context, *SendToRouteRequest) (*SendResponse, error)
	// lncli: `addinvoice`
	// AddInvoice attempts to add a new invoice to the invoice database. Any
	// duplicated invoices are rejected, therefore all invoices *must* have a
	// unique payment preimage.
	AddInvoice(context.Context, *Invoice) (*AddInvoiceResponse, error)
	// lncli: `listinvoices`
	// ListInvoices returns a list of all the invoices currently stored within the
	// database. Any active debug invoices are ignored. It has full support for
	// paginated responses, allowing users to query for specific invoices through
	// their add_index. This can be done by using either the first_index_offset or
	// last_index_offset fields included in the response as the index_offset of the
	// next request. By default, the first 100 invoices created will be returned.
	// Backwards pagination is also supported through the Reversed flag.
	ListInvoices(context.Context, *ListInvoiceRequest) (*ListInvoiceResponse, error)
	// lncli: `lookupinvoice`
	// LookupInvoice attempts to look up an invoice according to its payment hash.
	// The passed payment hash *must* be exactly 32 bytes, if not, an error is
	// returned.
	LookupInvoice(context.Context, *PaymentHash) (*Invoice, error)
	// SubscribeInvoices returns a uni-directional stream (server -> client) for
	// notifying the client of newly added/settled invoices. The caller can
	// optionally specify the add_index and/or the settle_index. If the add_index
	// is specified, then we'll first start by sending add invoice events for all
	// invoices with an add_index greater than the specified value. If the
	// settle_index is specified, then next, we'll send out all settle events for
	// invoices with a settle_index greater than the specified value. One or both
	// of these fields can be set. If no fields are set, then we'll only send out
	// the latest add/settle events.
	SubscribeInvoices(*InvoiceSubscription, Lightning_SubscribeInvoicesServer) error
	// lncli: `decodepayreq`
	// DecodePayReq takes an encoded payment request string and attempts to decode
	// it, returning a full description of the conditions encoded within the
	// payment request.
	DecodePayReq(context.Context, *PayReqString) (*PayReq, error)
	// lncli: `listpayments`
	// ListPayments returns a list of all outgoing payments.
	ListPayments(context.Context, *ListPaymentsRequest) (*ListPaymentsResponse, error)
	// lncli: `deletepayments`
	// DeletePayment deletes an outgoing payment from DB. Note that it will not
	// attempt to delete an In-Flight payment, since that would be unsafe.
	DeletePayment(context.Context, *DeletePaymentRequest) (*DeletePaymentResponse, error)
	// lncli: `deletepayments --all`
	// DeleteAllPayments deletes all outgoing payments from DB. Note that it will
	// not attempt to delete In-Flight payments, since that would be unsafe.
	DeleteAllPayments(context.Context, *DeleteAllPaymentsRequest) (*DeleteAllPaymentsResponse, error)
	// lncli: `describegraph`
	// DescribeGraph returns a description of the latest graph state from the
	// point of view of the node. The graph information is partitioned into two
	// components: all the nodes/vertexes, and all the edges that connect the
	// vertexes themselves. As this is a directed graph, the edges also contain
	// the node directional specific routing policy which includes: the time lock
	// delta, fee information, etc.
	DescribeGraph(context.Context, *ChannelGraphRequest) (*ChannelGraph, error)
	// lncli: `getnodemetrics`
	// GetNodeMetrics returns node metrics calculated from the graph. Currently
	// the only supported metric is betweenness centrality of individual nodes.
	GetNodeMetrics(context.Context, *NodeMetricsRequest) (*NodeMetricsResponse, error)
	// lncli: `getchaninfo`
	// GetChanInfo returns the latest authenticated network announcement for the
	// given channel identified by its channel ID: an 8-byte integer which
	// uniquely identifies the location of transaction's funding output within the
	// blockchain.
	GetChanInfo(context.Context, *ChanInfoRequest) (*ChannelEdge, error)
	// lncli: `getnodeinfo`
	// GetNodeInfo returns the latest advertised, aggregated, and authenticated
	// channel information for the specified node identified by its public key.
	GetNodeInfo(context.Context, *NodeInfoRequest) (*NodeInfo, error)
	// lncli: `queryroutes`
	// QueryRoutes attempts to query the daemon's Channel Router for a possible
	// route to a target destination capable of carrying a specific amount of
	// satoshis. The returned route contains the full details required to craft and
	// send an HTLC, also including the necessary information that should be
	// present within the Sphinx packet encapsulated within the HTLC.
	//
	// When using REST, the `dest_custom_records` map type can be set by appending
	// `&dest_custom_records[<record_number>]=<record_data_base64_url_encoded>`
	// to the URL. Unfortunately this map type doesn't appear in the REST API
	// documentation because of a bug in the grpc-gateway library.
	QueryRoutes(context.Context, *QueryRoutesRequest) (*QueryRoutesResponse, error)
	// lncli: `getnetworkinfo`
	// GetNetworkInfo returns some basic stats about the known channel graph from
	// the point of view of the node.
	GetNetworkInfo(context.Context, *NetworkInfoRequest) (*NetworkInfo, error)
	// lncli: `stop`
	// StopDaemon will send a shutdown request to the interrupt handler, triggering
	// a graceful shutdown of the daemon.
	StopDaemon(context.Context, *StopRequest) (*StopResponse, error)
	// SubscribeChannelGraph launches a streaming RPC that allows the caller to
	// receive notifications upon any changes to the channel graph topology from
	// the point of view of the responding node. Events notified include: new
	// nodes coming online, nodes updating their authenticated attributes, new
	// channels being advertised, updates in the routing policy for a directional
	// channel edge, and when channels are closed on-chain.
	SubscribeChannelGraph(*GraphTopologySubscription, Lightning_SubscribeChannelGraphServer) error
	// lncli: `debuglevel`
	// DebugLevel allows a caller to programmatically set the logging verbosity of
	// lnd. The logging can be targeted according to a coarse daemon-wide logging
	// level, or in a granular fashion to specify the logging for a target
	// sub-system.
	DebugLevel(context.Context, *DebugLevelRequest) (*DebugLevelResponse, error)
	// lncli: `feereport`
	// FeeReport allows the caller to obtain a report detailing the current fee
	// schedule enforced by the node globally for each channel.
	FeeReport(context.Context, *FeeReportRequest) (*FeeReportResponse, error)
	// lncli: `updatechanpolicy`
	// UpdateChannelPolicy allows the caller to update the fee schedule and
	// channel policies for all channels globally, or a particular channel.
	UpdateChannelPolicy(context.Context, *PolicyUpdateRequest) (*PolicyUpdateResponse, error)
	// lncli: `fwdinghistory`
	// ForwardingHistory allows the caller to query the htlcswitch for a record of
	// all HTLCs forwarded within the target time range, and integer offset
	// within that time range, for a maximum number of events. If no maximum number
	// of events is specified, up to 100 events will be returned. If no time-range
	// is specified, then events will be returned in the order that they occured.
	//
	// A list of forwarding events are returned. The size of each forwarding event
	// is 40 bytes, and the max message size able to be returned in gRPC is 4 MiB.
	// As a result each message can only contain 50k entries. Each response has
	// the index offset of the last entry. The index offset can be provided to the
	// request to allow the caller to skip a series of records.
	ForwardingHistory(context.Context, *ForwardingHistoryRequest) (*ForwardingHistoryResponse, error)
	// lncli: `exportchanbackup`
	// ExportChannelBackup attempts to return an encrypted static channel backup
	// for the target channel identified by it channel point. The backup is
	// encrypted with a key generated from the aezeed seed of the user. The
	// returned backup can either be restored using the RestoreChannelBackup
	// method once lnd is running, or via the InitWallet and UnlockWallet methods
	// from the WalletUnlocker service.
	ExportChannelBackup(context.Context, *ExportChannelBackupRequest) (*ChannelBackup, error)
	// ExportAllChannelBackups returns static channel backups for all existing
	// channels known to lnd. A set of regular singular static channel backups for
	// each channel are returned. Additionally, a multi-channel backup is returned
	// as well, which contains a single encrypted blob containing the backups of
	// each channel.
	ExportAllChannelBackups(context.Context, *ChanBackupExportRequest) (*ChanBackupSnapshot, error)
	// lncli: `verifychanbackup`
	// VerifyChanBackup allows a caller to verify the integrity of a channel backup
	// snapshot. This method will accept either a packed Single or a packed Multi.
	// Specifying both will result in an error.
	VerifyChanBackup(context.Context, *ChanBackupSnapshot) (*VerifyChanBackupResponse, error)
	// lncli: `restorechanbackup`
	// RestoreChannelBackups accepts a set of singular channel backups, or a
	// single encrypted multi-chan backup and attempts to recover any funds
	// remaining within the channel. If we are able to unpack the backup, then the
	// new channel will be shown under listchannels, as well as pending channels.
	RestoreChannelBackups(context.Context, *RestoreChanBackupRequest) (*RestoreBackupResponse, error)
	// SubscribeChannelBackups allows a client to sub-subscribe to the most up to
	// date information concerning the state of all channel backups. Each time a
	// new channel is added, we return the new set of channels, along with a
	// multi-chan backup containing the backup info for all channels. Each time a
	// channel is closed, we send a new update, which contains new new chan back
	// ups, but the updated set of encrypted multi-chan backups with the closed
	// channel(s) removed.
	SubscribeChannelBackups(*ChannelBackupSubscription, Lightning_SubscribeChannelBackupsServer) error
	// lncli: `bakemacaroon`
	// BakeMacaroon allows the creation of a new macaroon with custom read and
	// write permissions. No first-party caveats are added since this can be done
	// offline.
	BakeMacaroon(context.Context, *BakeMacaroonRequest) (*BakeMacaroonResponse, error)
	// lncli: `listmacaroonids`
	// ListMacaroonIDs returns all root key IDs that are in use.
	ListMacaroonIDs(context.Context, *ListMacaroonIDsRequest) (*ListMacaroonIDsResponse, error)
	// lncli: `deletemacaroonid`
	// DeleteMacaroonID deletes the specified macaroon ID and invalidates all
	// macaroons derived from that ID.
	DeleteMacaroonID(context.Context, *DeleteMacaroonIDRequest) (*DeleteMacaroonIDResponse, error)
	// lncli: `listpermissions`
	// ListPermissions lists all RPC method URIs and their required macaroon
	// permissions to access them.
	ListPermissions(context.Context, *ListPermissionsRequest) (*ListPermissionsResponse, error)
	// CheckMacaroonPermissions checks whether a request follows the constraints
	// imposed on the macaroon and that the macaroon is authorized to follow the
	// provided permissions.
	CheckMacaroonPermissions(context.Context, *CheckMacPermRequest) (*CheckMacPermResponse, error)
	// RegisterRPCMiddleware adds a new gRPC middleware to the interceptor chain. A
	// gRPC middleware is software component external to lnd that aims to add
	// additional business logic to lnd by observing/intercepting/validating
	// incoming gRPC client requests and (if needed) replacing/overwriting outgoing
	// messages before they're sent to the client. When registering the middleware
	// must identify itself and indicate what custom macaroon caveats it wants to
	// be responsible for. Only requests that contain a macaroon with that specific
	// custom caveat are then sent to the middleware for inspection. The other
	// option is to register for the read-only mode in which all requests/responses
	// are forwarded for interception to the middleware but the middleware is not
	// allowed to modify any responses. As a security measure, _no_ middleware can
	// modify responses for requests made with _unencumbered_ macaroons!
	RegisterRPCMiddleware(Lightning_RegisterRPCMiddlewareServer) error
	// lncli: `sendcustom`
	// SendCustomMessage sends a custom peer message.
	SendCustomMessage(context.Context, *SendCustomMessageRequest) (*SendCustomMessageResponse, error)
	// lncli: `subscribecustom`
	// SubscribeCustomMessages subscribes to a stream of incoming custom peer
	// messages.
	//
	// To include messages with type outside of the custom range (>= 32768) lnd
	// needs to be compiled with  the `dev` build tag, and the message type to
	// override should be specified in lnd's experimental protocol configuration.
	SubscribeCustomMessages(*SubscribeCustomMessagesRequest, Lightning_SubscribeCustomMessagesServer) error
	// lncli: `listaliases`
	// ListAliases returns the set of all aliases that have ever existed with
	// their confirmed SCID (if it exists) and/or the base SCID (in the case of
	// zero conf).
	ListAliases(context.Context, *ListAliasesRequest) (*ListAliasesResponse, error)
	// LookupHtlcResolution retrieves a final htlc resolution from the database.
	// If the htlc has no final resolution yet, a NotFound grpc status code is
	// returned.
	LookupHtlcResolution(context.Context, *LookupHtlcResolutionRequest) (*LookupHtlcResolutionResponse, error)
	mustEmbedUnimplementedLightningServer()
}

// UnimplementedLightningServer must be embedded to have forward compatible implementations.
type UnimplementedLightningServer struct {
}

func (UnimplementedLightningServer) WalletBalance(context.Context, *WalletBalanceRequest) (*WalletBalanceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WalletBalance not implemented")
}
func (UnimplementedLightningServer) ChannelBalance(context.Context, *ChannelBalanceRequest) (*ChannelBalanceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChannelBalance not implemented")
}
func (UnimplementedLightningServer) GetTransactions(context.Context, *GetTransactionsRequest) (*TransactionDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransactions not implemented")
}
func (UnimplementedLightningServer) EstimateFee(context.Context, *EstimateFeeRequest) (*EstimateFeeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EstimateFee not implemented")
}
func (UnimplementedLightningServer) SendCoins(context.Context, *SendCoinsRequest) (*SendCoinsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendCoins not implemented")
}
func (UnimplementedLightningServer) ListUnspent(context.Context, *ListUnspentRequest) (*ListUnspentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUnspent not implemented")
}
func (UnimplementedLightningServer) SubscribeTransactions(*GetTransactionsRequest, Lightning_SubscribeTransactionsServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeTransactions not implemented")
}
func (UnimplementedLightningServer) SendMany(context.Context, *SendManyRequest) (*SendManyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendMany not implemented")
}
func (UnimplementedLightningServer) NewAddress(context.Context, *NewAddressRequest) (*NewAddressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewAddress not implemented")
}
func (UnimplementedLightningServer) SignMessage(context.Context, *SignMessageRequest) (*SignMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignMessage not implemented")
}
func (UnimplementedLightningServer) VerifyMessage(context.Context, *VerifyMessageRequest) (*VerifyMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyMessage not implemented")
}
func (UnimplementedLightningServer) ConnectPeer(context.Context, *ConnectPeerRequest) (*ConnectPeerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConnectPeer not implemented")
}
func (UnimplementedLightningServer) DisconnectPeer(context.Context, *DisconnectPeerRequest) (*DisconnectPeerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisconnectPeer not implemented")
}
func (UnimplementedLightningServer) ListPeers(context.Context, *ListPeersRequest) (*ListPeersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPeers not implemented")
}
func (UnimplementedLightningServer) SubscribePeerEvents(*PeerEventSubscription, Lightning_SubscribePeerEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribePeerEvents not implemented")
}
func (UnimplementedLightningServer) GetInfo(context.Context, *GetInfoRequest) (*GetInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInfo not implemented")
}
func (UnimplementedLightningServer) GetDebugInfo(context.Context, *GetDebugInfoRequest) (*GetDebugInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDebugInfo not implemented")
}
func (UnimplementedLightningServer) GetRecoveryInfo(context.Context, *GetRecoveryInfoRequest) (*GetRecoveryInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecoveryInfo not implemented")
}
func (UnimplementedLightningServer) PendingChannels(context.Context, *PendingChannelsRequest) (*PendingChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PendingChannels not implemented")
}
func (UnimplementedLightningServer) ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannels not implemented")
}
func (UnimplementedLightningServer) SubscribeChannelEvents(*ChannelEventSubscription, Lightning_SubscribeChannelEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeChannelEvents not implemented")
}
func (UnimplementedLightningServer) ClosedChannels(context.Context, *ClosedChannelsRequest) (*ClosedChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClosedChannels not implemented")
}
func (UnimplementedLightningServer) OpenChannelSync(context.Context, *OpenChannelRequest) (*ChannelPoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenChannelSync not implemented")
}
func (UnimplementedLightningServer) OpenChannel(*OpenChannelRequest, Lightning_OpenChannelServer) error {
	return status.Errorf(codes.Unimplemented, "method OpenChannel not implemented")
}
func (UnimplementedLightningServer) BatchOpenChannel(context.Context, *BatchOpenChannelRequest) (*BatchOpenChannelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchOpenChannel not implemented")
}
func (UnimplementedLightningServer) FundingStateStep(context.Context, *FundingTransitionMsg) (*FundingStateStepResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FundingStateStep not implemented")
}
func (UnimplementedLightningServer) ChannelAcceptor(Lightning_ChannelAcceptorServer) error {
	return status.Errorf(codes.Unimplemented, "method ChannelAcceptor not implemented")
}
func (UnimplementedLightningServer) CloseChannel(*CloseChannelRequest, Lightning_CloseChannelServer) error {
	return status.Errorf(codes.Unimplemented, "method CloseChannel not implemented")
}
func (UnimplementedLightningServer) AbandonChannel(context.Context, *AbandonChannelRequest) (*AbandonChannelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AbandonChannel not implemented")
}
func (UnimplementedLightningServer) SendPayment(Lightning_SendPaymentServer) error {
	return status.Errorf(codes.Unimplemented, "method SendPayment not implemented")
}
func (UnimplementedLightningServer) SendPaymentSync(context.Context, *SendRequest) (*SendResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendPaymentSync not implemented")
}
func (UnimplementedLightningServer) SendToRoute(Lightning_SendToRouteServer) error {
	return status.Errorf(codes.Unimplemented, "method SendToRoute not implemented")
}
func (UnimplementedLightningServer) SendToRouteSync(context.Context, *SendToRouteRequest) (*SendResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendToRouteSync not implemented")
}
func (UnimplementedLightningServer) AddInvoice(context.Context, *Invoice) (*AddInvoiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddInvoice not implemented")
}
func (UnimplementedLightningServer) ListInvoices(context.Context, *ListInvoiceRequest) (*ListInvoiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInvoices not implemented")
}
func (UnimplementedLightningServer) LookupInvoice(context.Context, *PaymentHash) (*Invoice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupInvoice not implemented")
}
func (UnimplementedLightningServer) SubscribeInvoices(*InvoiceSubscription, Lightning_SubscribeInvoicesServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeInvoices not implemented")
}
func (UnimplementedLightningServer) DecodePayReq(context.Context, *PayReqString) (*PayReq, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DecodePayReq not implemented")
}
func (UnimplementedLightningServer) ListPayments(context.Context, *ListPaymentsRequest) (*ListPaymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPayments not implemented")
}
func (UnimplementedLightningServer) DeletePayment(context.Context, *DeletePaymentRequest) (*DeletePaymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePayment not implemented")
}
func (UnimplementedLightningServer) DeleteAllPayments(context.Context, *DeleteAllPaymentsRequest) (*DeleteAllPaymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAllPayments not implemented")
}
func (UnimplementedLightningServer) DescribeGraph(context.Context, *ChannelGraphRequest) (*ChannelGraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribeGraph not implemented")
}
func (UnimplementedLightningServer) GetNodeMetrics(context.Context, *NodeMetricsRequest) (*NodeMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeMetrics not implemented")
}
func (UnimplementedLightningServer) GetChanInfo(context.Context, *ChanInfoRequest) (*ChannelEdge, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChanInfo not implemented")
}
func (UnimplementedLightningServer) GetNodeInfo(context.Context, *NodeInfoRequest) (*NodeInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeInfo not implemented")
}
func (UnimplementedLightningServer) QueryRoutes(context.Context, *QueryRoutesRequest) (*QueryRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryRoutes not implemented")
}
func (UnimplementedLightningServer) GetNetworkInfo(context.Context, *NetworkInfoRequest) (*NetworkInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkInfo not implemented")
}
func (UnimplementedLightningServer) StopDaemon(context.Context, *StopRequest) (*StopResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopDaemon not implemented")
}
func (UnimplementedLightningServer) SubscribeChannelGraph(*GraphTopologySubscription, Lightning_SubscribeChannelGraphServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeChannelGraph not implemented")
}
func (UnimplementedLightningServer) DebugLevel(context.Context, *DebugLevelRequest) (*DebugLevelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DebugLevel not implemented")
}
func (UnimplementedLightningServer) FeeReport(context.Context, *FeeReportRequest) (*FeeReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FeeReport not implemented")
}
func (UnimplementedLightningServer) UpdateChannelPolicy(context.Context, *PolicyUpdateRequest) (*PolicyUpdateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelPolicy not implemented")
}
func (UnimplementedLightningServer) ForwardingHistory(context.Context, *ForwardingHistoryRequest) (*ForwardingHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForwardingHistory not implemented")
}
func (UnimplementedLightningServer) ExportChannelBackup(context.Context, *ExportChannelBackupRequest) (*ChannelBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportChannelBackup not implemented")
}
func (UnimplementedLightningServer) ExportAllChannelBackups(context.Context, *ChanBackupExportRequest) (*ChanBackupSnapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAllChannelBackups not implemented")
}
func (UnimplementedLightningServer) VerifyChanBackup(context.Context, *ChanBackupSnapshot) (*VerifyChanBackupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyChanBackup not implemented")
}
func (UnimplementedLightningServer) RestoreChannelBackups(context.Context, *RestoreChanBackupRequest) (*RestoreBackupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreChannelBackups not implemented")
}
func (UnimplementedLightningServer) SubscribeChannelBackups(*ChannelBackupSubscription, Lightning_SubscribeChannelBackupsServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeChannelBackups not implemented")
}
func (UnimplementedLightningServer) BakeMacaroon(context.Context, *BakeMacaroonRequest) (*BakeMacaroonResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BakeMacaroon not implemented")
}
func (UnimplementedLightningServer) ListMacaroonIDs(context.Context, *ListMacaroonIDsRequest) (*ListMacaroonIDsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMacaroonIDs not implemented")
}
func (UnimplementedLightningServer) DeleteMacaroonID(context.Context, *DeleteMacaroonIDRequest) (*DeleteMacaroonIDResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMacaroonID not implemented")
}
func (UnimplementedLightningServer) ListPermissions(context.Context, *ListPermissionsRequest) (*ListPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPermissions not implemented")
}
func (UnimplementedLightningServer) CheckMacaroonPermissions(context.Context, *CheckMacPermRequest) (*CheckMacPermResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckMacaroonPermissions not implemented")
}
func (UnimplementedLightningServer) RegisterRPCMiddleware(Lightning_RegisterRPCMiddlewareServer) error {
	return status.Errorf(codes.Unimplemented, "method RegisterRPCMiddleware not implemented")
}
func (UnimplementedLightningServer) SendCustomMessage(context.Context, *SendCustomMessageRequest) (*SendCustomMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendCustomMessage not implemented")
}
func (UnimplementedLightningServer) SubscribeCustomMessages(*SubscribeCustomMessagesRequest, Lightning_SubscribeCustomMessagesServer) error {
	return status.Errorf(codes.Unimplemented, "method SubscribeCustomMessages not implemented")
}
func (UnimplementedLightningServer) ListAliases(context.Context, *ListAliasesRequest) (*ListAliasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAliases not implemented")
}
func (UnimplementedLightningServer) LookupHtlcResolution(context.Context, *LookupHtlcResolutionRequest) (*LookupHtlcResolutionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupHtlcResolution not implemented")
}
func (UnimplementedLightningServer) mustEmbedUnimplementedLightningServer() {}

// UnsafeLightningServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LightningServer will
// result in compilation errors.
type UnsafeLightningServer interface {
	mustEmbedUnimplementedLightningServer()
}

func RegisterLightningServer(s grpc.ServiceRegistrar, srv LightningServer) {
	s.RegisterService(&Lightning_ServiceDesc, srv)
}

func _Lightning_WalletBalance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WalletBalanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).WalletBalance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/WalletBalance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).WalletBalance(ctx, req.(*WalletBalanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ChannelBalance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChannelBalanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ChannelBalance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ChannelBalance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ChannelBalance(ctx, req.(*ChannelBalanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetTransactions(ctx, req.(*GetTransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_EstimateFee_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EstimateFeeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).EstimateFee(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/EstimateFee",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).EstimateFee(ctx, req.(*EstimateFeeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SendCoins_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendCoinsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).SendCoins(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/SendCoins",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).SendCoins(ctx, req.(*SendCoinsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListUnspent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUnspentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListUnspent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListUnspent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListUnspent(ctx, req.(*ListUnspentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribeTransactions_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTransactionsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribeTransactions(m, &lightningSubscribeTransactionsServer{stream})
}

type Lightning_SubscribeTransactionsServer interface {
	Send(*Transaction) error
	grpc.ServerStream
}

type lightningSubscribeTransactionsServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribeTransactionsServer) Send(m *Transaction) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_SendMany_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendManyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).SendMany(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/SendMany",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).SendMany(ctx, req.(*SendManyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_NewAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NewAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).NewAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/NewAddress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).NewAddress(ctx, req.(*NewAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SignMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).SignMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/SignMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).SignMessage(ctx, req.(*SignMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_VerifyMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).VerifyMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/VerifyMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).VerifyMessage(ctx, req.(*VerifyMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ConnectPeer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConnectPeerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ConnectPeer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ConnectPeer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ConnectPeer(ctx, req.(*ConnectPeerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_DisconnectPeer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisconnectPeerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DisconnectPeer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DisconnectPeer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DisconnectPeer(ctx, req.(*DisconnectPeerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListPeers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPeersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListPeers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListPeers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListPeers(ctx, req.(*ListPeersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribePeerEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PeerEventSubscription)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribePeerEvents(m, &lightningSubscribePeerEventsServer{stream})
}

type Lightning_SubscribePeerEventsServer interface {
	Send(*PeerEvent) error
	grpc.ServerStream
}

type lightningSubscribePeerEventsServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribePeerEventsServer) Send(m *PeerEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_GetInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetInfo(ctx, req.(*GetInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetDebugInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDebugInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetDebugInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetDebugInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetDebugInfo(ctx, req.(*GetDebugInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetRecoveryInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecoveryInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetRecoveryInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetRecoveryInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetRecoveryInfo(ctx, req.(*GetRecoveryInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_PendingChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PendingChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).PendingChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/PendingChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).PendingChannels(ctx, req.(*PendingChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListChannels(ctx, req.(*ListChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribeChannelEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ChannelEventSubscription)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribeChannelEvents(m, &lightningSubscribeChannelEventsServer{stream})
}

type Lightning_SubscribeChannelEventsServer interface {
	Send(*ChannelEventUpdate) error
	grpc.ServerStream
}

type lightningSubscribeChannelEventsServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribeChannelEventsServer) Send(m *ChannelEventUpdate) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_ClosedChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClosedChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ClosedChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ClosedChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ClosedChannels(ctx, req.(*ClosedChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_OpenChannelSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).OpenChannelSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/OpenChannelSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).OpenChannelSync(ctx, req.(*OpenChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_OpenChannel_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(OpenChannelRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).OpenChannel(m, &lightningOpenChannelServer{stream})
}

type Lightning_OpenChannelServer interface {
	Send(*OpenStatusUpdate) error
	grpc.ServerStream
}

type lightningOpenChannelServer struct {
	grpc.ServerStream
}

func (x *lightningOpenChannelServer) Send(m *OpenStatusUpdate) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_BatchOpenChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchOpenChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).BatchOpenChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/BatchOpenChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).BatchOpenChannel(ctx, req.(*BatchOpenChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_FundingStateStep_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FundingTransitionMsg)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).FundingStateStep(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/FundingStateStep",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).FundingStateStep(ctx, req.(*FundingTransitionMsg))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ChannelAcceptor_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LightningServer).ChannelAcceptor(&lightningChannelAcceptorServer{stream})
}

type Lightning_ChannelAcceptorServer interface {
	Send(*ChannelAcceptRequest) error
	Recv() (*ChannelAcceptResponse, error)
	grpc.ServerStream
}

type lightningChannelAcceptorServer struct {
	grpc.ServerStream
}

func (x *lightningChannelAcceptorServer) Send(m *ChannelAcceptRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *lightningChannelAcceptorServer) Recv() (*ChannelAcceptResponse, error) {
	m := new(ChannelAcceptResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Lightning_CloseChannel_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CloseChannelRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).CloseChannel(m, &lightningCloseChannelServer{stream})
}

type Lightning_CloseChannelServer interface {
	Send(*CloseStatusUpdate) error
	grpc.ServerStream
}

type lightningCloseChannelServer struct {
	grpc.ServerStream
}

func (x *lightningCloseChannelServer) Send(m *CloseStatusUpdate) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_AbandonChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AbandonChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).AbandonChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/AbandonChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).AbandonChannel(ctx, req.(*AbandonChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SendPayment_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LightningServer).SendPayment(&lightningSendPaymentServer{stream})
}

type Lightning_SendPaymentServer interface {
	Send(*SendResponse) error
	Recv() (*SendRequest, error)
	grpc.ServerStream
}

type lightningSendPaymentServer struct {
	grpc.ServerStream
}

func (x *lightningSendPaymentServer) Send(m *SendResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *lightningSendPaymentServer) Recv() (*SendRequest, error) {
	m := new(SendRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Lightning_SendPaymentSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).SendPaymentSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/SendPaymentSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).SendPaymentSync(ctx, req.(*SendRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SendToRoute_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LightningServer).SendToRoute(&lightningSendToRouteServer{stream})
}

type Lightning_SendToRouteServer interface {
	Send(*SendResponse) error
	Recv() (*SendToRouteRequest, error)
	grpc.ServerStream
}

type lightningSendToRouteServer struct {
	grpc.ServerStream
}

func (x *lightningSendToRouteServer) Send(m *SendResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *lightningSendToRouteServer) Recv() (*SendToRouteRequest, error) {
	m := new(SendToRouteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Lightning_SendToRouteSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendToRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).SendToRouteSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/SendToRouteSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).SendToRouteSync(ctx, req.(*SendToRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_AddInvoice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Invoice)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).AddInvoice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/AddInvoice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).AddInvoice(ctx, req.(*Invoice))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListInvoices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInvoiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListInvoices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListInvoices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListInvoices(ctx, req.(*ListInvoiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_LookupInvoice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PaymentHash)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).LookupInvoice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/LookupInvoice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).LookupInvoice(ctx, req.(*PaymentHash))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribeInvoices_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InvoiceSubscription)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribeInvoices(m, &lightningSubscribeInvoicesServer{stream})
}

type Lightning_SubscribeInvoicesServer interface {
	Send(*Invoice) error
	grpc.ServerStream
}

type lightningSubscribeInvoicesServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribeInvoicesServer) Send(m *Invoice) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_DecodePayReq_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PayReqString)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DecodePayReq(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DecodePayReq",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DecodePayReq(ctx, req.(*PayReqString))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListPayments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPaymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListPayments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListPayments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListPayments(ctx, req.(*ListPaymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_DeletePayment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePaymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DeletePayment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DeletePayment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DeletePayment(ctx, req.(*DeletePaymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_DeleteAllPayments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAllPaymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DeleteAllPayments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DeleteAllPayments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DeleteAllPayments(ctx, req.(*DeleteAllPaymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_DescribeGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChannelGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DescribeGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DescribeGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DescribeGraph(ctx, req.(*ChannelGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetNodeMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetNodeMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetNodeMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetNodeMetrics(ctx, req.(*NodeMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetChanInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChanInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetChanInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetChanInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetChanInfo(ctx, req.(*ChanInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetNodeInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetNodeInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetNodeInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetNodeInfo(ctx, req.(*NodeInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_QueryRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).QueryRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/QueryRoutes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).QueryRoutes(ctx, req.(*QueryRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_GetNetworkInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NetworkInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).GetNetworkInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/GetNetworkInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).GetNetworkInfo(ctx, req.(*NetworkInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_StopDaemon_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).StopDaemon(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/StopDaemon",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).StopDaemon(ctx, req.(*StopRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribeChannelGraph_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GraphTopologySubscription)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribeChannelGraph(m, &lightningSubscribeChannelGraphServer{stream})
}

type Lightning_SubscribeChannelGraphServer interface {
	Send(*GraphTopologyUpdate) error
	grpc.ServerStream
}

type lightningSubscribeChannelGraphServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribeChannelGraphServer) Send(m *GraphTopologyUpdate) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_DebugLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DebugLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DebugLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DebugLevel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DebugLevel(ctx, req.(*DebugLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_FeeReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FeeReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).FeeReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/FeeReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).FeeReport(ctx, req.(*FeeReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_UpdateChannelPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PolicyUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).UpdateChannelPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/UpdateChannelPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).UpdateChannelPolicy(ctx, req.(*PolicyUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ForwardingHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForwardingHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ForwardingHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ForwardingHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ForwardingHistory(ctx, req.(*ForwardingHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ExportChannelBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportChannelBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ExportChannelBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ExportChannelBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ExportChannelBackup(ctx, req.(*ExportChannelBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ExportAllChannelBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChanBackupExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ExportAllChannelBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ExportAllChannelBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ExportAllChannelBackups(ctx, req.(*ChanBackupExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_VerifyChanBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChanBackupSnapshot)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).VerifyChanBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/VerifyChanBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).VerifyChanBackup(ctx, req.(*ChanBackupSnapshot))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_RestoreChannelBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreChanBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).RestoreChannelBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/RestoreChannelBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).RestoreChannelBackups(ctx, req.(*RestoreChanBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribeChannelBackups_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ChannelBackupSubscription)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribeChannelBackups(m, &lightningSubscribeChannelBackupsServer{stream})
}

type Lightning_SubscribeChannelBackupsServer interface {
	Send(*ChanBackupSnapshot) error
	grpc.ServerStream
}

type lightningSubscribeChannelBackupsServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribeChannelBackupsServer) Send(m *ChanBackupSnapshot) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_BakeMacaroon_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BakeMacaroonRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).BakeMacaroon(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/BakeMacaroon",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).BakeMacaroon(ctx, req.(*BakeMacaroonRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListMacaroonIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMacaroonIDsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListMacaroonIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListMacaroonIDs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListMacaroonIDs(ctx, req.(*ListMacaroonIDsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_DeleteMacaroonID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMacaroonIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).DeleteMacaroonID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/DeleteMacaroonID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).DeleteMacaroonID(ctx, req.(*DeleteMacaroonIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_ListPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListPermissions(ctx, req.(*ListPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_CheckMacaroonPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckMacPermRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).CheckMacaroonPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/CheckMacaroonPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).CheckMacaroonPermissions(ctx, req.(*CheckMacPermRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_RegisterRPCMiddleware_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(LightningServer).RegisterRPCMiddleware(&lightningRegisterRPCMiddlewareServer{stream})
}

type Lightning_RegisterRPCMiddlewareServer interface {
	Send(*RPCMiddlewareRequest) error
	Recv() (*RPCMiddlewareResponse, error)
	grpc.ServerStream
}

type lightningRegisterRPCMiddlewareServer struct {
	grpc.ServerStream
}

func (x *lightningRegisterRPCMiddlewareServer) Send(m *RPCMiddlewareRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *lightningRegisterRPCMiddlewareServer) Recv() (*RPCMiddlewareResponse, error) {
	m := new(RPCMiddlewareResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Lightning_SendCustomMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendCustomMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).SendCustomMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/SendCustomMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).SendCustomMessage(ctx, req.(*SendCustomMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_SubscribeCustomMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SubscribeCustomMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LightningServer).SubscribeCustomMessages(m, &lightningSubscribeCustomMessagesServer{stream})
}

type Lightning_SubscribeCustomMessagesServer interface {
	Send(*CustomMessage) error
	grpc.ServerStream
}

type lightningSubscribeCustomMessagesServer struct {
	grpc.ServerStream
}

func (x *lightningSubscribeCustomMessagesServer) Send(m *CustomMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Lightning_ListAliases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAliasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).ListAliases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/ListAliases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).ListAliases(ctx, req.(*ListAliasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lightning_LookupHtlcResolution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupHtlcResolutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LightningServer).LookupHtlcResolution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/lnrpc.Lightning/LookupHtlcResolution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LightningServer).LookupHtlcResolution(ctx, req.(*LookupHtlcResolutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Lightning_ServiceDesc is the grpc.ServiceDesc for Lightning service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Lightning_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "lnrpc.Lightning",
	HandlerType: (*LightningServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "WalletBalance",
			Handler:    _Lightning_WalletBalance_Handler,
		},
		{
			MethodName: "ChannelBalance",
			Handler:    _Lightning_ChannelBalance_Handler,
		},
		{
			MethodName: "GetTransactions",
			Handler:    _Lightning_GetTransactions_Handler,
		},
		{
			MethodName: "EstimateFee",
			Handler:    _Lightning_EstimateFee_Handler,
		},
		{
			MethodName: "SendCoins",
			Handler:    _Lightning_SendCoins_Handler,
		},
		{
			MethodName: "ListUnspent",
			Handler:    _Lightning_ListUnspent_Handler,
		},
		{
			MethodName: "SendMany",
			Handler:    _Lightning_SendMany_Handler,
		},
		{
			MethodName: "NewAddress",
			Handler:    _Lightning_NewAddress_Handler,
		},
		{
			MethodName: "SignMessage",
			Handler:    _Lightning_SignMessage_Handler,
		},
		{
			MethodName: "VerifyMessage",
			Handler:    _Lightning_VerifyMessage_Handler,
		},
		{
			MethodName: "ConnectPeer",
			Handler:    _Lightning_ConnectPeer_Handler,
		},
		{
			MethodName: "DisconnectPeer",
			Handler:    _Lightning_DisconnectPeer_Handler,
		},
		{
			MethodName: "ListPeers",
			Handler:    _Lightning_ListPeers_Handler,
		},
		{
			MethodName: "GetInfo",
			Handler:    _Lightning_GetInfo_Handler,
		},
		{
			MethodName: "GetDebugInfo",
			Handler:    _Lightning_GetDebugInfo_Handler,
		},
		{
			MethodName: "GetRecoveryInfo",
			Handler:    _Lightning_GetRecoveryInfo_Handler,
		},
		{
			MethodName: "PendingChannels",
			Handler:    _Lightning_PendingChannels_Handler,
		},
		{
			MethodName: "ListChannels",
			Handler:    _Lightning_ListChannels_Handler,
		},
		{
			MethodName: "ClosedChannels",
			Handler:    _Lightning_ClosedChannels_Handler,
		},
		{
			MethodName: "OpenChannelSync",
			Handler:    _Lightning_OpenChannelSync_Handler,
		},
		{
			MethodName: "BatchOpenChannel",
			Handler:    _Lightning_BatchOpenChannel_Handler,
		},
		{
			MethodName: "FundingStateStep",
			Handler:    _Lightning_FundingStateStep_Handler,
		},
		{
			MethodName: "AbandonChannel",
			Handler:    _Lightning_AbandonChannel_Handler,
		},
		{
			MethodName: "SendPaymentSync",
			Handler:    _Lightning_SendPaymentSync_Handler,
		},
		{
			MethodName: "SendToRouteSync",
			Handler:    _Lightning_SendToRouteSync_Handler,
		},
		{
			MethodName: "AddInvoice",
			Handler:    _Lightning_AddInvoice_Handler,
		},
		{
			MethodName: "ListInvoices",
			Handler:    _Lightning_ListInvoices_Handler,
		},
		{
			MethodName: "LookupInvoice",
			Handler:    _Lightning_LookupInvoice_Handler,
		},
		{
			MethodName: "DecodePayReq",
			Handler:    _Lightning_DecodePayReq_Handler,
		},
		{
			MethodName: "ListPayments",
			Handler:    _Lightning_ListPayments_Handler,
		},
		{
			MethodName: "DeletePayment",
			Handler:    _Lightning_DeletePayment_Handler,
		},
		{
			MethodName: "DeleteAllPayments",
			Handler:    _Lightning_DeleteAllPayments_Handler,
		},
		{
			MethodName: "DescribeGraph",
			Handler:    _Lightning_DescribeGraph_Handler,
		},
		{
			MethodName: "GetNodeMetrics",
			Handler:    _Lightning_GetNodeMetrics_Handler,
		},
		{
			MethodName: "GetChanInfo",
			Handler:    _Lightning_GetChanInfo_Handler,
		},
		{
			MethodName: "GetNodeInfo",
			Handler:    _Lightning_GetNodeInfo_Handler,
		},
		{
			MethodName: "QueryRoutes",
			Handler:    _Lightning_QueryRoutes_Handler,
		},
		{
			MethodName: "GetNetworkInfo",
			Handler:    _Lightning_GetNetworkInfo_Handler,
		},
		{
			MethodName: "StopDaemon",
			Handler:    _Lightning_StopDaemon_Handler,
		},
		{
			MethodName: "DebugLevel",
			Handler:    _Lightning_DebugLevel_Handler,
		},
		{
			MethodName: "FeeReport",
			Handler:    _Lightning_FeeReport_Handler,
		},
		{
			MethodName: "UpdateChannelPolicy",
			Handler:    _Lightning_UpdateChannelPolicy_Handler,
		},
		{
			MethodName: "ForwardingHistory",
			Handler:    _Lightning_ForwardingHistory_Handler,
		},
		{
			MethodName: "ExportChannelBackup",
			Handler:    _Lightning_ExportChannelBackup_Handler,
		},
		{
			MethodName: "ExportAllChannelBackups",
			Handler:    _Lightning_ExportAllChannelBackups_Handler,
		},
		{
			MethodName: "VerifyChanBackup",
			Handler:    _Lightning_VerifyChanBackup_Handler,
		},
		{
			MethodName: "RestoreChannelBackups",
			Handler:    _Lightning_RestoreChannelBackups_Handler,
		},
		{
			MethodName: "BakeMacaroon",
			Handler:    _Lightning_BakeMacaroon_Handler,
		},
		{
			MethodName: "ListMacaroonIDs",
			Handler:    _Lightning_ListMacaroonIDs_Handler,
		},
		{
			MethodName: "DeleteMacaroonID",
			Handler:    _Lightning_DeleteMacaroonID_Handler,
		},
		{
			MethodName: "ListPermissions",
			Handler:    _Lightning_ListPermissions_Handler,
		},
		{
			MethodName: "CheckMacaroonPermissions",
			Handler:    _Lightning_CheckMacaroonPermissions_Handler,
		},
		{
			MethodName: "SendCustomMessage",
			Handler:    _Lightning_SendCustomMessage_Handler,
		},
		{
			MethodName: "ListAliases",
			Handler:    _Lightning_ListAliases_Handler,
		},
		{
			MethodName: "LookupHtlcResolution",
			Handler:    _Lightning_LookupHtlcResolution_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SubscribeTransactions",
			Handler:       _Lightning_SubscribeTransactions_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SubscribePeerEvents",
			Handler:       _Lightning_SubscribePeerEvents_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SubscribeChannelEvents",
			Handler:       _Lightning_SubscribeChannelEvents_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "OpenChannel",
			Handler:       _Lightning_OpenChannel_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ChannelAcceptor",
			Handler:       _Lightning_ChannelAcceptor_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "CloseChannel",
			Handler:       _Lightning_CloseChannel_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SendPayment",
			Handler:       _Lightning_SendPayment_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SendToRoute",
			Handler:       _Lightning_SendToRoute_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SubscribeInvoices",
			Handler:       _Lightning_SubscribeInvoices_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SubscribeChannelGraph",
			Handler:       _Lightning_SubscribeChannelGraph_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SubscribeChannelBackups",
			Handler:       _Lightning_SubscribeChannelBackups_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RegisterRPCMiddleware",
			Handler:       _Lightning_RegisterRPCMiddleware_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SubscribeCustomMessages",
			Handler:       _Lightning_SubscribeCustomMessages_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "lightning.proto",
}
