// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package autopilotrpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// AutopilotClient is the client API for Autopilot service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutopilotClient interface {
	// lncli: `autopilot status`
	// Status returns whether the daemon's autopilot agent is active.
	Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error)
	// ModifyStatus is used to modify the status of the autopilot agent, like
	// enabling or disabling it.
	ModifyStatus(ctx context.Context, in *ModifyStatusRequest, opts ...grpc.CallOption) (*ModifyStatusResponse, error)
	// lncli: `autopilot query`
	// QueryScores queries all available autopilot heuristics, in addition to any
	// active combination of these heruristics, for the scores they would give to
	// the given nodes.
	QueryScores(ctx context.Context, in *QueryScoresRequest, opts ...grpc.CallOption) (*QueryScoresResponse, error)
	// SetScores attempts to set the scores used by the running autopilot agent,
	// if the external scoring heuristic is enabled.
	SetScores(ctx context.Context, in *SetScoresRequest, opts ...grpc.CallOption) (*SetScoresResponse, error)
}

type autopilotClient struct {
	cc grpc.ClientConnInterface
}

func NewAutopilotClient(cc grpc.ClientConnInterface) AutopilotClient {
	return &autopilotClient{cc}
}

func (c *autopilotClient) Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error) {
	out := new(StatusResponse)
	err := c.cc.Invoke(ctx, "/autopilotrpc.Autopilot/Status", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autopilotClient) ModifyStatus(ctx context.Context, in *ModifyStatusRequest, opts ...grpc.CallOption) (*ModifyStatusResponse, error) {
	out := new(ModifyStatusResponse)
	err := c.cc.Invoke(ctx, "/autopilotrpc.Autopilot/ModifyStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autopilotClient) QueryScores(ctx context.Context, in *QueryScoresRequest, opts ...grpc.CallOption) (*QueryScoresResponse, error) {
	out := new(QueryScoresResponse)
	err := c.cc.Invoke(ctx, "/autopilotrpc.Autopilot/QueryScores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autopilotClient) SetScores(ctx context.Context, in *SetScoresRequest, opts ...grpc.CallOption) (*SetScoresResponse, error) {
	out := new(SetScoresResponse)
	err := c.cc.Invoke(ctx, "/autopilotrpc.Autopilot/SetScores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutopilotServer is the server API for Autopilot service.
// All implementations must embed UnimplementedAutopilotServer
// for forward compatibility
type AutopilotServer interface {
	// lncli: `autopilot status`
	// Status returns whether the daemon's autopilot agent is active.
	Status(context.Context, *StatusRequest) (*StatusResponse, error)
	// ModifyStatus is used to modify the status of the autopilot agent, like
	// enabling or disabling it.
	ModifyStatus(context.Context, *ModifyStatusRequest) (*ModifyStatusResponse, error)
	// lncli: `autopilot query`
	// QueryScores queries all available autopilot heuristics, in addition to any
	// active combination of these heruristics, for the scores they would give to
	// the given nodes.
	QueryScores(context.Context, *QueryScoresRequest) (*QueryScoresResponse, error)
	// SetScores attempts to set the scores used by the running autopilot agent,
	// if the external scoring heuristic is enabled.
	SetScores(context.Context, *SetScoresRequest) (*SetScoresResponse, error)
	mustEmbedUnimplementedAutopilotServer()
}

// UnimplementedAutopilotServer must be embedded to have forward compatible implementations.
type UnimplementedAutopilotServer struct {
}

func (UnimplementedAutopilotServer) Status(context.Context, *StatusRequest) (*StatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Status not implemented")
}
func (UnimplementedAutopilotServer) ModifyStatus(context.Context, *ModifyStatusRequest) (*ModifyStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyStatus not implemented")
}
func (UnimplementedAutopilotServer) QueryScores(context.Context, *QueryScoresRequest) (*QueryScoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryScores not implemented")
}
func (UnimplementedAutopilotServer) SetScores(context.Context, *SetScoresRequest) (*SetScoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetScores not implemented")
}
func (UnimplementedAutopilotServer) mustEmbedUnimplementedAutopilotServer() {}

// UnsafeAutopilotServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutopilotServer will
// result in compilation errors.
type UnsafeAutopilotServer interface {
	mustEmbedUnimplementedAutopilotServer()
}

func RegisterAutopilotServer(s grpc.ServiceRegistrar, srv AutopilotServer) {
	s.RegisterService(&Autopilot_ServiceDesc, srv)
}

func _Autopilot_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutopilotServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/autopilotrpc.Autopilot/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutopilotServer).Status(ctx, req.(*StatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autopilot_ModifyStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutopilotServer).ModifyStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/autopilotrpc.Autopilot/ModifyStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutopilotServer).ModifyStatus(ctx, req.(*ModifyStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autopilot_QueryScores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryScoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutopilotServer).QueryScores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/autopilotrpc.Autopilot/QueryScores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutopilotServer).QueryScores(ctx, req.(*QueryScoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autopilot_SetScores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetScoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutopilotServer).SetScores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/autopilotrpc.Autopilot/SetScores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutopilotServer).SetScores(ctx, req.(*SetScoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Autopilot_ServiceDesc is the grpc.ServiceDesc for Autopilot service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Autopilot_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "autopilotrpc.Autopilot",
	HandlerType: (*AutopilotServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Status",
			Handler:    _Autopilot_Status_Handler,
		},
		{
			MethodName: "ModifyStatus",
			Handler:    _Autopilot_ModifyStatus_Handler,
		},
		{
			MethodName: "QueryScores",
			Handler:    _Autopilot_QueryScores_Handler,
		},
		{
			MethodName: "SetScores",
			Handler:    _Autopilot_SetScores_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "autopilotrpc/autopilot.proto",
}
