//go:build integration

package itest

import "github.com/lightningnetwork/lnd/lntest"

var allTestCases = []*lntest.TestCase{
	{
		Name:     "update channel status",
		TestFunc: testUpdateChanStatus,
	},
	{
		Name:     "basic funding flow",
		TestFunc: testBasicChannelFunding,
	},
	{
		Name:     "multi hop receiver chain claim",
		TestFunc: testMultiHopReceiverChainClaim,
	},
	{
		Name:     "external channel funding",
		TestFunc: testExternalFundingChanPoint,
	},
	{
		Name:     "channel backup restore basic",
		TestFunc: testChannelBackupRestoreBasic,
	},
	{
		Name:     "channel backup restore unconfirmed",
		TestFunc: testChannelBackupRestoreUnconfirmed,
	},
	{
		Name:     "channel backup restore commit types",
		TestFunc: testChannelBackupRestoreCommitTypes,
	},
	{
		Name:     "channel backup restore force close",
		TestFunc: testChannelBackupRestoreForceClose,
	},
	{
		Name:     "channel backup restore legacy",
		TestFunc: testChannelBackupRestoreLegacy,
	},
	{
		Name:     "data loss protection",
		TestFunc: testDataLossProtection,
	},
	{
		Name:     "send all coins",
		TestFunc: testSendAllCoins,
	},
	{
		Name:     "send selected coins",
		TestFunc: testSendSelectedCoins,
	},
	{
		Name:     "send selected coins channel reserve",
		TestFunc: testSendSelectedCoinsChannelReserve,
	},
	{
		Name:     "disconnecting target peer",
		TestFunc: testDisconnectingTargetPeer,
	},
	{
		Name:     "sphinx replay persistence",
		TestFunc: testSphinxReplayPersistence,
	},
	{
		Name:     "funding expiry blocks on pending",
		TestFunc: testFundingExpiryBlocksOnPending,
	},
	{
		Name:     "list channels",
		TestFunc: testListChannels,
	},
	{
		Name:     "max pending channel",
		TestFunc: testMaxPendingChannels,
	},
	{
		Name:     "garbage collect link nodes",
		TestFunc: testGarbageCollectLinkNodes,
	},
	{
		Name:     "reject onward htlc",
		TestFunc: testRejectHTLC,
	},
	{
		Name:     "node sign verify",
		TestFunc: testNodeSignVerify,
	},
	{
		Name:     "list addresses",
		TestFunc: testListAddresses,
	},
	{
		Name:     "abandonchannel",
		TestFunc: testAbandonChannel,
	},
	{
		Name:     "recovery info",
		TestFunc: testGetRecoveryInfo,
	},
	{
		Name:     "onchain fund recovery",
		TestFunc: testOnchainFundRecovery,
	},
	{
		Name:     "wallet rescan address detection",
		TestFunc: testRescanAddressDetection,
	},
	{
		Name:     "basic funding flow with all input types",
		TestFunc: testChannelFundingInputTypes,
	},
	{
		Name:     "unconfirmed channel funding",
		TestFunc: testUnconfirmedChannelFunding,
	},
	{
		Name:     "funding flow persistence",
		TestFunc: testChannelFundingPersistence,
	},
	{
		Name:     "batch channel funding",
		TestFunc: testBatchChanFunding,
	},
	{
		Name:     "open channel with unstable utxos",
		TestFunc: testChannelFundingWithUnstableUtxos,
	},
	{
		Name:     "open psbt channel with unstable utxos",
		TestFunc: testPsbtChanFundingWithUnstableUtxos,
	},
	{
		Name:     "update channel policy",
		TestFunc: testUpdateChannelPolicy,
	},
	{
		Name:     "send update disable channel",
		TestFunc: testSendUpdateDisableChannel,
	},
	{
		Name:     "connection timeout",
		TestFunc: testNetworkConnectionTimeout,
	},
	{
		Name:     "reconnect after ip change",
		TestFunc: testReconnectAfterIPChange,
	},
	{
		Name:     "addpeer config",
		TestFunc: testAddPeerConfig,
	},
	{
		Name:     "multi hop htlc local timeout",
		TestFunc: testMultiHopHtlcLocalTimeout,
	},
	{
		Name:     "multi hop local force close on-chain htlc timeout",
		TestFunc: testMultiHopLocalForceCloseOnChainHtlcTimeout,
	},
	{
		Name:     "multi hop remote force close on-chain htlc timeout",
		TestFunc: testMultiHopRemoteForceCloseOnChainHtlcTimeout,
	},
	{
		Name:     "private channel update policy",
		TestFunc: testUpdateChannelPolicyForPrivateChannel,
	},
	{
		Name:     "update channel policy fee rate accuracy",
		TestFunc: testUpdateChannelPolicyFeeRateAccuracy,
	},
	{
		Name:     "unannounced channels",
		TestFunc: testUnannouncedChannels,
	},
	{
		Name:     "graph topology notifications",
		TestFunc: testGraphTopologyNotifications,
	},
	{
		Name:     "node announcement",
		TestFunc: testNodeAnnouncement,
	},
	{
		Name:     "update node announcement rpc",
		TestFunc: testUpdateNodeAnnouncement,
	},
	{
		Name:     "list payments",
		TestFunc: testListPayments,
	},
	{
		Name:     "send direct payment",
		TestFunc: testSendDirectPayment,
	},
	{
		Name:     "immediate payment after channel opened",
		TestFunc: testPaymentFollowingChannelOpen,
	},
	{
		Name:     "payment failure reason canceled",
		TestFunc: testPaymentFailureReasonCanceled,
	},
	{
		Name:     "invoice update subscription",
		TestFunc: testInvoiceSubscriptions,
	},
	{
		Name:     "streaming channel backup update",
		TestFunc: testChannelBackupUpdates,
	},
	{
		Name:     "export channel backup",
		TestFunc: testExportChannelBackup,
	},
	{
		Name:     "channel balance",
		TestFunc: testChannelBalance,
	},
	{
		Name:     "channel unsettled balance",
		TestFunc: testChannelUnsettledBalance,
	},
	{
		Name:     "channel force closure",
		TestFunc: testChannelForceClosure,
	},
	{
		Name:     "failing link",
		TestFunc: testFailingChannel,
	},
	{
		Name:     "chain kit",
		TestFunc: testChainKit,
	},
	{
		Name:     "neutrino kit",
		TestFunc: testNeutrino,
	},
	{
		Name:     "etcd failover",
		TestFunc: testEtcdFailover,
	},
	{
		Name:     "leader health check",
		TestFunc: testLeaderHealthCheck,
	},
	{
		Name:     "hold invoice force close",
		TestFunc: testHoldInvoiceForceClose,
	},
	{
		Name:     "hold invoice sender persistence",
		TestFunc: testHoldInvoicePersistence,
	},
	{
		Name:     "maximum channel size",
		TestFunc: testMaxChannelSize,
	},
	{
		Name:     "wumbo channels",
		TestFunc: testWumboChannels,
	},
	{
		Name:     "max htlc pathfind",
		TestFunc: testMaxHtlcPathfind,
	},
	{
		Name:     "multi-hop htlc error propagation",
		TestFunc: testHtlcErrorPropagation,
	},
	{
		Name:     "multi-hop payments",
		TestFunc: testMultiHopPayments,
	},
	{
		Name:     "estimate route fee",
		TestFunc: testEstimateRouteFee,
	},
	{
		Name:     "anchors reserved value",
		TestFunc: testAnchorReservedValue,
	},
	{
		Name:     "3rd party anchor spend",
		TestFunc: testAnchorThirdPartySpend,
	},
	{
		Name:     "open channel reorg test",
		TestFunc: testOpenChannelAfterReorg,
	},
	{
		Name:     "psbt channel funding",
		TestFunc: testPsbtChanFunding,
	},
	{
		Name:     "sign psbt",
		TestFunc: testSignPsbt,
	},
	{
		Name:     "fund psbt",
		TestFunc: testFundPsbt,
	},
	{
		Name:     "resolution handoff",
		TestFunc: testResHandoff,
	},
	{
		Name:     "REST API",
		TestFunc: testRestAPI,
	},
	{
		Name:     "multi hop htlc local chain claim",
		TestFunc: testMultiHopHtlcLocalChainClaim,
	},
	{
		Name:     "multi hop htlc remote chain claim",
		TestFunc: testMultiHopHtlcRemoteChainClaim,
	},
	{
		Name:     "multi hop htlc aggregation",
		TestFunc: testMultiHopHtlcAggregation,
	},
	{
		Name:     "revoked uncooperative close retribution",
		TestFunc: testRevokedCloseRetribution,
	},
	{
		Name: "revoked uncooperative close retribution zero value " +
			"remote output",
		TestFunc: testRevokedCloseRetributionZeroValueRemoteOutput,
	},
	{
		Name:     "revoked uncooperative close retribution remote hodl",
		TestFunc: testRevokedCloseRetributionRemoteHodl,
	},
	{
		Name:     "single-hop send to route",
		TestFunc: testSingleHopSendToRoute,
	},
	{
		Name:     "multi-hop send to route",
		TestFunc: testMultiHopSendToRoute,
	},
	{
		Name:     "send to route error propagation",
		TestFunc: testSendToRouteErrorPropagation,
	},
	{
		Name:     "private channels",
		TestFunc: testPrivateChannels,
	},
	{
		Name:     "invoice routing hints",
		TestFunc: testInvoiceRoutingHints,
	},
	{
		Name:     "scid alias routing hints",
		TestFunc: testScidAliasRoutingHints,
	},
	{
		Name:     "multi-hop payments over private channels",
		TestFunc: testMultiHopOverPrivateChannels,
	},
	{
		Name:     "query routes",
		TestFunc: testQueryRoutes,
	},
	{
		Name:     "route fee cutoff",
		TestFunc: testRouteFeeCutoff,
	},
	{
		Name:     "route fee limit after queryroutes",
		TestFunc: testFeeLimitAfterQueryRoutes,
	},
	{
		Name:     "rpc middleware interceptor",
		TestFunc: testRPCMiddlewareInterceptor,
	},
	{
		Name:     "macaroon authentication",
		TestFunc: testMacaroonAuthentication,
	},
	{
		Name:     "bake macaroon",
		TestFunc: testBakeMacaroon,
	},
	{
		Name:     "delete macaroon id",
		TestFunc: testDeleteMacaroonID,
	},
	{
		Name:     "stateless init",
		TestFunc: testStatelessInit,
	},
	{
		Name:     "single hop invoice",
		TestFunc: testSingleHopInvoice,
	},
	{
		Name:     "wipe forwarding packages",
		TestFunc: testWipeForwardingPackages,
	},
	{
		Name:     "switch circuit persistence",
		TestFunc: testSwitchCircuitPersistence,
	},
	{
		Name:     "switch offline delivery",
		TestFunc: testSwitchOfflineDelivery,
	},
	{
		Name:     "switch offline delivery persistence",
		TestFunc: testSwitchOfflineDeliveryPersistence,
	},
	{
		Name:     "switch offline delivery outgoing offline",
		TestFunc: testSwitchOfflineDeliveryOutgoingOffline,
	},
	{
		Name:     "sendtoroute multi path payment",
		TestFunc: testSendToRouteMultiPath,
	},
	{
		Name:     "send multi path payment",
		TestFunc: testSendMultiPathPayment,
	},
	{
		Name:     "sendpayment amp invoice",
		TestFunc: testSendPaymentAMPInvoice,
	},
	{
		Name:     "sendpayment amp invoice repeat",
		TestFunc: testSendPaymentAMPInvoiceRepeat,
	},
	{
		Name:     "send payment amp",
		TestFunc: testSendPaymentAMP,
	},
	{
		Name:     "sendtoroute amp",
		TestFunc: testSendToRouteAMP,
	},
	{
		Name:     "forward interceptor dedup htlcs",
		TestFunc: testForwardInterceptorDedupHtlc,
	},
	{
		Name:     "forward interceptor",
		TestFunc: testForwardInterceptorBasic,
	},
	{
		Name:     "forward interceptor modified htlc",
		TestFunc: testForwardInterceptorModifiedHtlc,
	},
	{
		Name:     "forward interceptor wire records",
		TestFunc: testForwardInterceptorWireRecords,
	},
	{
		Name:     "forward interceptor restart",
		TestFunc: testForwardInterceptorRestart,
	},
	{
		Name:     "invoice HTLC modifier basic",
		TestFunc: testInvoiceHtlcModifierBasic,
	},
	{
		Name:     "zero conf channel open",
		TestFunc: testZeroConfChannelOpen,
	},
	{
		Name:     "option scid alias",
		TestFunc: testOptionScidAlias,
	},
	{
		Name:     "scid alias channel update",
		TestFunc: testUpdateChannelPolicyScidAlias,
	},
	{
		Name:     "scid alias upgrade",
		TestFunc: testOptionScidUpgrade,
	},
	{
		Name:     "nonstd sweep",
		TestFunc: testNonstdSweep,
	},
	{
		Name:     "multiple channel creation and update subscription",
		TestFunc: testBasicChannelCreationAndUpdates,
	},
	{
		Name:     "derive shared key",
		TestFunc: testDeriveSharedKey,
	},
	{
		Name:     "sign output raw",
		TestFunc: testSignOutputRaw,
	},
	{
		Name:     "sign verify message",
		TestFunc: testSignVerifyMessage,
	},
	{
		Name:     "bumpfee",
		TestFunc: testBumpFee,
	},
	{
		Name:     "bumpforceclosefee",
		TestFunc: testBumpForceCloseFee,
	},
	{
		Name:     "taproot",
		TestFunc: testTaproot,
	},
	{
		Name:     "simple taproot channel activation",
		TestFunc: testSimpleTaprootChannelActivation,
	},
	{
		Name:     "wallet import account",
		TestFunc: testWalletImportAccount,
	},
	{
		Name:     "wallet import pubkey",
		TestFunc: testWalletImportPubKey,
	},
	{
		Name:     "async payments benchmark",
		TestFunc: testAsyncPayments,
	},
	{
		Name:     "remote signer",
		TestFunc: testRemoteSigner,
	},
	{
		Name:     "taproot coop close",
		TestFunc: testTaprootCoopClose,
	},
	{
		Name:     "trackpayments",
		TestFunc: testTrackPayments,
	},
	{
		Name:     "trackpayments compatible",
		TestFunc: testTrackPaymentsCompatible,
	},
	{
		Name:     "open channel fee policy",
		TestFunc: testOpenChannelUpdateFeePolicy,
	},
	{
		Name:     "custom message",
		TestFunc: testCustomMessage,
	},
	{
		Name:     "sign verify message with addr",
		TestFunc: testSignVerifyMessageWithAddr,
	},
	{
		Name:     "zero conf reorg edge existence",
		TestFunc: testZeroConfReorg,
	},
	{
		Name:     "async bidirectional payments",
		TestFunc: testBidirectionalAsyncPayments,
	},
	{
		Name:     "lookup htlc resolution",
		TestFunc: testLookupHtlcResolution,
	},
	{
		Name:     "watchtower",
		TestFunc: testWatchtower,
	},
	{
		Name:     "channel fundmax",
		TestFunc: testChannelFundMax,
	},
	{
		Name:     "htlc timeout resolver extract preimage remote",
		TestFunc: testHtlcTimeoutResolverExtractPreimageRemote,
	},
	{
		Name:     "htlc timeout resolver extract preimage local",
		TestFunc: testHtlcTimeoutResolverExtractPreimageLocal,
	},
	{
		Name:     "custom features",
		TestFunc: testCustomFeatures,
	},
	{
		Name:     "utxo selection funding",
		TestFunc: testChannelUtxoSelection,
	},
	{
		Name:     "update pending open channels",
		TestFunc: testUpdateOnPendingOpenChannels,
	},
	{
		Name:     "blinded payment htlc re-forward",
		TestFunc: testBlindedPaymentHTLCReForward,
	},
	{
		Name:     "query blinded route",
		TestFunc: testQueryBlindedRoutes,
	},
	{
		Name:     "route blinding invoices",
		TestFunc: testBlindedRouteInvoices,
	},
	{
		Name:     "receiver blinded error",
		TestFunc: testReceiverBlindedError,
	},
	{
		Name:     "relayer blinded error",
		TestFunc: testRelayingBlindedError,
	},
	{
		Name:     "introduction blinded error",
		TestFunc: testIntroductionNodeError,
	},
	{
		Name:     "disable introduction node",
		TestFunc: testDisableIntroductionNode,
	},
	{
		Name:     "on chain to blinded",
		TestFunc: testErrorHandlingOnChainFailure,
	},
	{
		Name:     "mpp to single blinded path",
		TestFunc: testMPPToSingleBlindedPath,
	},
	{
		Name:     "mpp to multiple blinded paths",
		TestFunc: testMPPToMultipleBlindedPaths,
	},
	{
		Name:     "route blinding dummy hops",
		TestFunc: testBlindedRouteDummyHops,
	},
	{
		Name:     "removetx",
		TestFunc: testRemoveTx,
	},
	{
		Name:     "listsweeps",
		TestFunc: testListSweeps,
	},
	{
		Name:     "fail funding flow psbt",
		TestFunc: testPsbtChanFundingFailFlow,
	},
	{
		Name:     "coop close with htlcs",
		TestFunc: testCoopCloseWithHtlcs,
	},
	{
		Name:     "open channel locked balance",
		TestFunc: testOpenChannelLockedBalance,
	},
	{
		Name:     "nativesql no migration",
		TestFunc: testNativeSQLNoMigration,
	},
	{
		Name:     "sweep cpfp anchor outgoing timeout",
		TestFunc: testSweepCPFPAnchorOutgoingTimeout,
	},
	{
		Name:     "sweep cpfp anchor incoming timeout",
		TestFunc: testSweepCPFPAnchorIncomingTimeout,
	},
	{
		Name:     "sweep htlcs",
		TestFunc: testSweepHTLCs,
	},
	{
		Name:     "sweep commit output and anchor",
		TestFunc: testSweepCommitOutputAndAnchor,
	},
	{
		Name:     "coop close with external delivery",
		TestFunc: testCoopCloseWithExternalDelivery,
	},
	{
		Name:     "payment failed htlc local swept",
		TestFunc: testPaymentFailedHTLCLocalSwept,
	},
	{
		Name:     "payment succeeded htlc remote swept",
		TestFunc: testPaymentSucceededHTLCRemoteSwept,
	},
	{
		Name:     "send to route failed htlc timeout",
		TestFunc: testSendToRouteFailHTLCTimeout,
	},
}
