/*
 * Copyright (c) 2021-present, Trail of Bits, Inc.
 * All rights reserved.
 *
 * This source code is licensed in accordance with the terms specified in
 * the LICENSE file found in the root directory of this source tree.
 */

#pragma once

#include <clang/AST/ASTContext.h>
#include <llvm/ADT/APInt.h>
#include <llvm/Support/raw_ostream.h>

#include <functional>
#include <memory>

namespace rellic {
// Converts integer literals in `ast_ctx` to hexadecimal form when
// `shouldConvert` return true.
//
// Note: the context should have valid source range information, i.e. cannot be
// the one directly generated by Rellic. To obtain a context with valid source
// range information, serialize the AST to a string and parse it back into a
// context.
void ConvertIntegerLiteralsToHex(
    clang::ASTContext& ast_ctx, llvm::raw_ostream& os,
    std::function<bool(const llvm::APInt&)> shouldConvert);
}  // namespace rellic
