// swift-tools-version:5.0
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
    name: "tommath",
    platforms: [
        .macOS(.v10_10), .iOS(.v9), .tvOS(.v9)
    ],
    products: [
        // Products define the executables and libraries a package produces, and make them visible to other packages.
        .library(
            name: "libtommath",
            targets: ["libtommath"])
    ],
    dependencies: [
        // Dependencies declare other packages that this package depends on.
        // .package(url: /* package url */, from: "1.0.0"),
    ],
    targets: [
        // Targets are the basic building blocks of a package. A target can define a module or a test suite.
        // Targets can depend on other targets in this package, and on products in packages this package depends on.
        .target(
            name: "libtommath",
            path: ".",
            exclude: ["demo", "doc", "etc", "logs", "mtest"],
            sources: ["."],
            publicHeadersPath: "modulemap",
            cSettings: [
                .unsafeFlags(["-flto=thin"])  // for Dead Code Elimination
            ]),
        .testTarget(name: "TommathTests",
                    dependencies: ["libtommath"],
                    path: "demo",
                    sources: ["tommath_tests.swift"])
    ],
    cLanguageStandard: .gnu11,
    cxxLanguageStandard: .gnucxx14
)
