# Sample ASP.NET

[![Codacy Badge](https://api.codacy.com/project/badge/Grade/bdf83dcafdb24a37ba846eb0720b7141)](https://www.codacy.com/manual/liannoi/sample-aspnet?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=liannoi/sample-aspnet&amp;utm_campaign=Badge_Grade)
[![CodeFactor](https://www.codefactor.io/repository/github/liannoi/sample-aspnet/badge)](https://www.codefactor.io/repository/github/liannoi/sample-aspnet)
[![License](https://img.shields.io/badge/License-Apache%202.0-yellow.svg)](https://github.com/liannoi/sample-aspnet/blob/master/LICENSE)

An application designed to demonstrate and serve as an example for writing
monolithic applications with a three-tier architecture, not only on the .NET
Framework, but also on .NET Core.

In this project, I tried to implement the idea of ["Clean Architecture" by Robert Martin](https://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html).

Also, the project contains a Web API that you can deploy locally and use if
necessary. The data is based on a test database that simulates a student
testing system that I implemented in [this](https://github.com/liannoi/testing-system)
project.

## Technologies

- .NET Framework 4.8
- ASP.NET MVC 5
- ASP.NET Web API 2
- Entity Framework 6.4
- Bootstrap 4.4.1
- **[Dependence]** jQuery 3.4.1

## License

This repository is licensed under [Apache-2.0](https://github.com/liannoi/sample-aspnet/blob/master/LICENSE).
