---
order: 0
title: 🈚️
---

```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>remixicon(3.4.0)</title>
  <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
   
  <meta name="description" content="Remix Icon is a set of neutral system symbols carefully crafted for designers and developers, each icon is designed based on 24×24 grid">
   
  <meta name="keywords" content="remixicon,TTF,EOT,WOFF,WOFF2,SVG">
  
  <style>
    *{margin: 0;padding: 0;list-style: none;}
    body { color: #696969; font: 12px/1.5 tahoma, arial, \5b8b\4f53, sans-serif; }
    a:hover { color: rgb(9, 73, 209); }
    .header { color: #333; text-align: center; padding: 80px 0 60px 0; min-height: 153px; font-size: 14px; }
    .header .logo svg { height: 120px; width: 120px; }
    .header h1 { font-size: 42px; padding: 26px 0 10px 0; }
    .header sup {font-size: 14px; margin: 8px 0 0 8px; position: absolute; color: #7b7b7b; }
    .info {
      color: #999;
      font-weight: normal;
      max-width: 346px;
      margin: 0 auto;
      padding: 20px 0;
      font-size: 14px;
    }

    .icons { max-width: 1190px; margin: 0 auto; }
    .icons ul { text-align: center; }
    .icons ul li {
      vertical-align: top;
      width: 120px;
      display: inline-block;
      text-align: center;
      background-color: rgba(0,0,0,.02);
      border-radius: 3px;
      padding: 29px 0 10px 0;
      margin-right: 10px;
      margin-top: 10px;
      transition: all 0.6s ease;
    }
    .icons ul li:hover { background-color: rgba(0,0,0,.06); }
    .icons ul li:hover span { color: #3c75e4; opacity: 1; }
    .icons ul li .unicode { color: #8c8c8c; opacity: 0.3; }
    .icons ul li h4 {
      font-weight: normal;
      padding: 10px 0 5px 0;
      display: block;
      color: #8c8c8c;
      font-size: 14px;
      line-height: 12px;
      opacity: 0.8;
    }
    .icons ul li:hover h4 { opacity: 1; }
    .icons ul li svg { width: 24px; height: 24px; }
    .icons ul li:hover { color: #3c75e4; }
    .footer { text-align: center; padding: 10px 0 90px 0; }
    .footer a { text-align: center; padding: 10px 0 90px 0; color: #696969;}
    .footer a:hover { color: #0949d1; }
    .links { text-align: center; padding: 50px 0 0 0; font-size: 14px; }
    
    .icons ul li.class-icon { font-size: 21px; line-height: 21px; padding-bottom: 20px; }
    .icons ul li.class-icon p{ font-size: 12px; }
    .icons ul li.class-icon [class^="ri-"]{ font-size: 26px; }
    
    
    
  </style>
  
</head>

<body>
  
  <div class="header">
    
    <div class="logo">
      <a href="./"><svg width="160" height="32" viewBox="0 0 160 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M121.5 9.80005C123.33 9.80005 124.984 10.5797 126.165 11.8344L124.75 13.2496C123.929 12.3549 122.773 11.8 121.5 11.8C119.029 11.8 117 13.891 117 16.5C117 19.1091 119.029 21.2 121.5 21.2C122.773 21.2 123.929 20.6452 124.75 19.7505L126.165 21.1657C124.984 22.4204 123.33 23.2 121.5 23.2C117.91 23.2 115 20.2004 115 16.5C115 12.7997 117.91 9.80005 121.5 9.80005Z" fill="#1A2947"/>
<path d="M113 10V23H111V10H113Z" fill="#1A2947"/>
<path d="M154 23V9.99988H152L152 19.6019L144.997 9.99988L143 10.0039V23H145L145 13.3969L152 23H154Z" fill="#1A2947"/>
<path d="M68 10V12H60V15.5H67V17.5H60V21H68V23H58V10H68Z" fill="#1A2947"/>
<path d="M82 10L77.4999 17.201L73 10H71V23H73V13.775L77.4999 20.975L82 13.773V23H84V10H82Z" fill="#1A2947"/>
<path d="M89 10V23H87V10H89Z" fill="#1A2947"/>
<path d="M96.9999 14.7565L93.6689 9.99951H91.2279L95.7789 16.4995L91.2289 22.9995H93.6689L96.9999 18.2435L100.33 22.9995H102.772L98.2209 16.4995L102.773 9.99951H100.33L96.9999 14.7565Z" fill="#1A2947"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M141 16.5C141 12.7997 138.09 9.80005 134.5 9.80005C130.91 9.80005 128 12.7997 128 16.5C128 20.2004 130.91 23.2 134.5 23.2C138.09 23.2 141 20.2004 141 16.5ZM130 16.5C130 13.891 132.029 11.8 134.5 11.8C136.971 11.8 139 13.891 139 16.5C139 19.1091 136.971 21.2 134.5 21.2C132.029 21.2 130 19.1091 130 16.5Z" fill="#1A2947"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M51 10C53.2091 10 55 11.7909 55 14C55 15.7175 53.9176 17.1821 52.3977 17.749L55.1901 22.999H52.9251L50.267 18H46V23H44V10H51ZM46 11.999V15.999L51 16C52.1046 16 53 15.1046 53 14C53 12.8955 52.1 12 51 12L46 11.999Z" fill="#1A2947"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M19.2887 3.00389C19.1928 3.0013 19.0965 3 19 3H3V24H19C24.799 24 29.5 19.299 29.5 13.5C29.5 12.7108 29.4129 11.942 29.2479 11.2025C28.2772 11.7119 27.1722 12 26 12C22.134 12 19 8.86599 19 5C19 4.30645 19.1009 3.63646 19.2887 3.00389Z" fill="url(#paint0_linear_960_1054)"/>
<g filter="url(#filter0_b_960_1054)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 3L29 29H3V3Z" fill="url(#paint1_linear_960_1054)"/>
</g>
<circle cx="26" cy="5" r="4" fill="url(#paint2_linear_960_1054)"/>
<defs>
<filter id="filter0_b_960_1054" x="-2.43656" y="-2.43656" width="36.8731" height="36.8731" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
<feFlood flood-opacity="0" result="BackgroundImageFix"/>
<feGaussianBlur in="BackgroundImage" stdDeviation="2.71828"/>
<feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_960_1054"/>
<feBlend mode="normal" in="SourceGraphic" in2="effect1_backgroundBlur_960_1054" result="shape"/>
</filter>
<linearGradient id="paint0_linear_960_1054" x1="3" y1="3" x2="3" y2="24" gradientUnits="userSpaceOnUse">
<stop stop-color="#05A0FA"/>
<stop offset="1" stop-color="#4785FF"/>
</linearGradient>
<linearGradient id="paint1_linear_960_1054" x1="3" y1="3" x2="3" y2="29" gradientUnits="userSpaceOnUse">
<stop stop-color="#1A8CFF"/>
<stop offset="1" stop-color="#0557FA"/>
</linearGradient>
<linearGradient id="paint2_linear_960_1054" x1="22" y1="1" x2="22" y2="9" gradientUnits="userSpaceOnUse">
<stop stop-color="#FF463A"/>
<stop offset="1" stop-color="#FF1F5A"/>
</linearGradient>
</defs>
</svg>
</a>
    </div>
    
    <h1>remixicon(3.4.0)<sup>1.0.0</sup></h1>
    <div class="info">
      Remix Icon is a set of neutral system symbols carefully crafted for designers and developers, each icon is designed based on 24×24 grid
    </div>
    <p>
      
      <a href="https://github.com/Remix-Design/remixicon.git">GitHub</a> · 
      
      <a href="index.html">Font Class</a> · 
      
      <a href="unicode.html">Unicode</a>
      
    </p>
  </div>
  <div class="icons">
    <ul>
      <li class="class-icon"><i class="ri-24-hours-fill"></i><p class="name">24-hours-fill</p></li><li class="class-icon"><i class="ri-24-hours-line"></i><p class="name">24-hours-line</p></li><li class="class-icon"><i class="ri-4k-fill"></i><p class="name">4k-fill</p></li><li class="class-icon"><i class="ri-4k-line"></i><p class="name">4k-line</p></li><li class="class-icon"><i class="ri-a-b"></i><p class="name">a-b</p></li><li class="class-icon"><i class="ri-account-box-fill"></i><p class="name">account-box-fill</p></li><li class="class-icon"><i class="ri-account-box-line"></i><p class="name">account-box-line</p></li><li class="class-icon"><i class="ri-account-circle-fill"></i><p class="name">account-circle-fill</p></li><li class="class-icon"><i class="ri-account-circle-line"></i><p class="name">account-circle-line</p></li><li class="class-icon"><i class="ri-account-pin-box-fill"></i><p class="name">account-pin-box-fill</p></li><li class="class-icon"><i class="ri-account-pin-box-line"></i><p class="name">account-pin-box-line</p></li><li class="class-icon"><i class="ri-account-pin-circle-fill"></i><p class="name">account-pin-circle-fill</p></li><li class="class-icon"><i class="ri-account-pin-circle-line"></i><p class="name">account-pin-circle-line</p></li><li class="class-icon"><i class="ri-add-box-fill"></i><p class="name">add-box-fill</p></li><li class="class-icon"><i class="ri-add-box-line"></i><p class="name">add-box-line</p></li><li class="class-icon"><i class="ri-add-circle-fill"></i><p class="name">add-circle-fill</p></li><li class="class-icon"><i class="ri-add-circle-line"></i><p class="name">add-circle-line</p></li><li class="class-icon"><i class="ri-add-fill"></i><p class="name">add-fill</p></li><li class="class-icon"><i class="ri-add-line"></i><p class="name">add-line</p></li><li class="class-icon"><i class="ri-admin-fill"></i><p class="name">admin-fill</p></li><li class="class-icon"><i class="ri-admin-line"></i><p class="name">admin-line</p></li><li class="class-icon"><i class="ri-advertisement-fill"></i><p class="name">advertisement-fill</p></li><li class="class-icon"><i class="ri-advertisement-line"></i><p class="name">advertisement-line</p></li><li class="class-icon"><i class="ri-airplay-fill"></i><p class="name">airplay-fill</p></li><li class="class-icon"><i class="ri-airplay-line"></i><p class="name">airplay-line</p></li><li class="class-icon"><i class="ri-alarm-fill"></i><p class="name">alarm-fill</p></li><li class="class-icon"><i class="ri-alarm-line"></i><p class="name">alarm-line</p></li><li class="class-icon"><i class="ri-alarm-warning-fill"></i><p class="name">alarm-warning-fill</p></li><li class="class-icon"><i class="ri-alarm-warning-line"></i><p class="name">alarm-warning-line</p></li><li class="class-icon"><i class="ri-album-fill"></i><p class="name">album-fill</p></li><li class="class-icon"><i class="ri-album-line"></i><p class="name">album-line</p></li><li class="class-icon"><i class="ri-alert-fill"></i><p class="name">alert-fill</p></li><li class="class-icon"><i class="ri-alert-line"></i><p class="name">alert-line</p></li><li class="class-icon"><i class="ri-aliens-fill"></i><p class="name">aliens-fill</p></li><li class="class-icon"><i class="ri-aliens-line"></i><p class="name">aliens-line</p></li><li class="class-icon"><i class="ri-align-bottom"></i><p class="name">align-bottom</p></li><li class="class-icon"><i class="ri-align-center"></i><p class="name">align-center</p></li><li class="class-icon"><i class="ri-align-justify"></i><p class="name">align-justify</p></li><li class="class-icon"><i class="ri-align-left"></i><p class="name">align-left</p></li><li class="class-icon"><i class="ri-align-right"></i><p class="name">align-right</p></li><li class="class-icon"><i class="ri-align-top"></i><p class="name">align-top</p></li><li class="class-icon"><i class="ri-align-vertically"></i><p class="name">align-vertically</p></li><li class="class-icon"><i class="ri-alipay-fill"></i><p class="name">alipay-fill</p></li><li class="class-icon"><i class="ri-alipay-line"></i><p class="name">alipay-line</p></li><li class="class-icon"><i class="ri-amazon-fill"></i><p class="name">amazon-fill</p></li><li class="class-icon"><i class="ri-amazon-line"></i><p class="name">amazon-line</p></li><li class="class-icon"><i class="ri-anchor-fill"></i><p class="name">anchor-fill</p></li><li class="class-icon"><i class="ri-anchor-line"></i><p class="name">anchor-line</p></li><li class="class-icon"><i class="ri-ancient-gate-fill"></i><p class="name">ancient-gate-fill</p></li><li class="class-icon"><i class="ri-ancient-gate-line"></i><p class="name">ancient-gate-line</p></li><li class="class-icon"><i class="ri-ancient-pavilion-fill"></i><p class="name">ancient-pavilion-fill</p></li><li class="class-icon"><i class="ri-ancient-pavilion-line"></i><p class="name">ancient-pavilion-line</p></li><li class="class-icon"><i class="ri-android-fill"></i><p class="name">android-fill</p></li><li class="class-icon"><i class="ri-android-line"></i><p class="name">android-line</p></li><li class="class-icon"><i class="ri-angularjs-fill"></i><p class="name">angularjs-fill</p></li><li class="class-icon"><i class="ri-angularjs-line"></i><p class="name">angularjs-line</p></li><li class="class-icon"><i class="ri-anticlockwise-2-fill"></i><p class="name">anticlockwise-2-fill</p></li><li class="class-icon"><i class="ri-anticlockwise-2-line"></i><p class="name">anticlockwise-2-line</p></li><li class="class-icon"><i class="ri-anticlockwise-fill"></i><p class="name">anticlockwise-fill</p></li><li class="class-icon"><i class="ri-anticlockwise-line"></i><p class="name">anticlockwise-line</p></li><li class="class-icon"><i class="ri-app-store-fill"></i><p class="name">app-store-fill</p></li><li class="class-icon"><i class="ri-app-store-line"></i><p class="name">app-store-line</p></li><li class="class-icon"><i class="ri-apple-fill"></i><p class="name">apple-fill</p></li><li class="class-icon"><i class="ri-apple-line"></i><p class="name">apple-line</p></li><li class="class-icon"><i class="ri-apps-2-fill"></i><p class="name">apps-2-fill</p></li><li class="class-icon"><i class="ri-apps-2-line"></i><p class="name">apps-2-line</p></li><li class="class-icon"><i class="ri-apps-fill"></i><p class="name">apps-fill</p></li><li class="class-icon"><i class="ri-apps-line"></i><p class="name">apps-line</p></li><li class="class-icon"><i class="ri-archive-drawer-fill"></i><p class="name">archive-drawer-fill</p></li><li class="class-icon"><i class="ri-archive-drawer-line"></i><p class="name">archive-drawer-line</p></li><li class="class-icon"><i class="ri-archive-fill"></i><p class="name">archive-fill</p></li><li class="class-icon"><i class="ri-archive-line"></i><p class="name">archive-line</p></li><li class="class-icon"><i class="ri-arrow-down-circle-fill"></i><p class="name">arrow-down-circle-fill</p></li><li class="class-icon"><i class="ri-arrow-down-circle-line"></i><p class="name">arrow-down-circle-line</p></li><li class="class-icon"><i class="ri-arrow-down-fill"></i><p class="name">arrow-down-fill</p></li><li class="class-icon"><i class="ri-arrow-down-line"></i><p class="name">arrow-down-line</p></li><li class="class-icon"><i class="ri-arrow-down-s-fill"></i><p class="name">arrow-down-s-fill</p></li><li class="class-icon"><i class="ri-arrow-down-s-line"></i><p class="name">arrow-down-s-line</p></li><li class="class-icon"><i class="ri-arrow-drop-down-fill"></i><p class="name">arrow-drop-down-fill</p></li><li class="class-icon"><i class="ri-arrow-drop-down-line"></i><p class="name">arrow-drop-down-line</p></li><li class="class-icon"><i class="ri-arrow-drop-left-fill"></i><p class="name">arrow-drop-left-fill</p></li><li class="class-icon"><i class="ri-arrow-drop-left-line"></i><p class="name">arrow-drop-left-line</p></li><li class="class-icon"><i class="ri-arrow-drop-right-fill"></i><p class="name">arrow-drop-right-fill</p></li><li class="class-icon"><i class="ri-arrow-drop-right-line"></i><p class="name">arrow-drop-right-line</p></li><li class="class-icon"><i class="ri-arrow-drop-up-fill"></i><p class="name">arrow-drop-up-fill</p></li><li class="class-icon"><i class="ri-arrow-drop-up-line"></i><p class="name">arrow-drop-up-line</p></li><li class="class-icon"><i class="ri-arrow-go-back-fill"></i><p class="name">arrow-go-back-fill</p></li><li class="class-icon"><i class="ri-arrow-go-back-line"></i><p class="name">arrow-go-back-line</p></li><li class="class-icon"><i class="ri-arrow-go-forward-fill"></i><p class="name">arrow-go-forward-fill</p></li><li class="class-icon"><i class="ri-arrow-go-forward-line"></i><p class="name">arrow-go-forward-line</p></li><li class="class-icon"><i class="ri-arrow-left-circle-fill"></i><p class="name">arrow-left-circle-fill</p></li><li class="class-icon"><i class="ri-arrow-left-circle-line"></i><p class="name">arrow-left-circle-line</p></li><li class="class-icon"><i class="ri-arrow-left-down-fill"></i><p class="name">arrow-left-down-fill</p></li><li class="class-icon"><i class="ri-arrow-left-down-line"></i><p class="name">arrow-left-down-line</p></li><li class="class-icon"><i class="ri-arrow-left-fill"></i><p class="name">arrow-left-fill</p></li><li class="class-icon"><i class="ri-arrow-left-line"></i><p class="name">arrow-left-line</p></li><li class="class-icon"><i class="ri-arrow-left-right-fill"></i><p class="name">arrow-left-right-fill</p></li><li class="class-icon"><i class="ri-arrow-left-right-line"></i><p class="name">arrow-left-right-line</p></li><li class="class-icon"><i class="ri-arrow-left-s-fill"></i><p class="name">arrow-left-s-fill</p></li><li class="class-icon"><i class="ri-arrow-left-s-line"></i><p class="name">arrow-left-s-line</p></li><li class="class-icon"><i class="ri-arrow-left-up-fill"></i><p class="name">arrow-left-up-fill</p></li><li class="class-icon"><i class="ri-arrow-left-up-line"></i><p class="name">arrow-left-up-line</p></li><li class="class-icon"><i class="ri-arrow-right-circle-fill"></i><p class="name">arrow-right-circle-fill</p></li><li class="class-icon"><i class="ri-arrow-right-circle-line"></i><p class="name">arrow-right-circle-line</p></li><li class="class-icon"><i class="ri-arrow-right-down-fill"></i><p class="name">arrow-right-down-fill</p></li><li class="class-icon"><i class="ri-arrow-right-down-line"></i><p class="name">arrow-right-down-line</p></li><li class="class-icon"><i class="ri-arrow-right-fill"></i><p class="name">arrow-right-fill</p></li><li class="class-icon"><i class="ri-arrow-right-line"></i><p class="name">arrow-right-line</p></li><li class="class-icon"><i class="ri-arrow-right-s-fill"></i><p class="name">arrow-right-s-fill</p></li><li class="class-icon"><i class="ri-arrow-right-s-line"></i><p class="name">arrow-right-s-line</p></li><li class="class-icon"><i class="ri-arrow-right-up-fill"></i><p class="name">arrow-right-up-fill</p></li><li class="class-icon"><i class="ri-arrow-right-up-line"></i><p class="name">arrow-right-up-line</p></li><li class="class-icon"><i class="ri-arrow-up-circle-fill"></i><p class="name">arrow-up-circle-fill</p></li><li class="class-icon"><i class="ri-arrow-up-circle-line"></i><p class="name">arrow-up-circle-line</p></li><li class="class-icon"><i class="ri-arrow-up-down-fill"></i><p class="name">arrow-up-down-fill</p></li><li class="class-icon"><i class="ri-arrow-up-down-line"></i><p class="name">arrow-up-down-line</p></li><li class="class-icon"><i class="ri-arrow-up-fill"></i><p class="name">arrow-up-fill</p></li><li class="class-icon"><i class="ri-arrow-up-line"></i><p class="name">arrow-up-line</p></li><li class="class-icon"><i class="ri-arrow-up-s-fill"></i><p class="name">arrow-up-s-fill</p></li><li class="class-icon"><i class="ri-arrow-up-s-line"></i><p class="name">arrow-up-s-line</p></li><li class="class-icon"><i class="ri-artboard-2-fill"></i><p class="name">artboard-2-fill</p></li><li class="class-icon"><i class="ri-artboard-2-line"></i><p class="name">artboard-2-line</p></li><li class="class-icon"><i class="ri-artboard-fill"></i><p class="name">artboard-fill</p></li><li class="class-icon"><i class="ri-artboard-line"></i><p class="name">artboard-line</p></li><li class="class-icon"><i class="ri-article-fill"></i><p class="name">article-fill</p></li><li class="class-icon"><i class="ri-article-line"></i><p class="name">article-line</p></li><li class="class-icon"><i class="ri-aspect-ratio-fill"></i><p class="name">aspect-ratio-fill</p></li><li class="class-icon"><i class="ri-aspect-ratio-line"></i><p class="name">aspect-ratio-line</p></li><li class="class-icon"><i class="ri-asterisk"></i><p class="name">asterisk</p></li><li class="class-icon"><i class="ri-at-fill"></i><p class="name">at-fill</p></li><li class="class-icon"><i class="ri-at-line"></i><p class="name">at-line</p></li><li class="class-icon"><i class="ri-attachment-2"></i><p class="name">attachment-2</p></li><li class="class-icon"><i class="ri-attachment-fill"></i><p class="name">attachment-fill</p></li><li class="class-icon"><i class="ri-attachment-line"></i><p class="name">attachment-line</p></li><li class="class-icon"><i class="ri-auction-fill"></i><p class="name">auction-fill</p></li><li class="class-icon"><i class="ri-auction-line"></i><p class="name">auction-line</p></li><li class="class-icon"><i class="ri-award-fill"></i><p class="name">award-fill</p></li><li class="class-icon"><i class="ri-award-line"></i><p class="name">award-line</p></li><li class="class-icon"><i class="ri-baidu-fill"></i><p class="name">baidu-fill</p></li><li class="class-icon"><i class="ri-baidu-line"></i><p class="name">baidu-line</p></li><li class="class-icon"><i class="ri-ball-pen-fill"></i><p class="name">ball-pen-fill</p></li><li class="class-icon"><i class="ri-ball-pen-line"></i><p class="name">ball-pen-line</p></li><li class="class-icon"><i class="ri-bank-card-2-fill"></i><p class="name">bank-card-2-fill</p></li><li class="class-icon"><i class="ri-bank-card-2-line"></i><p class="name">bank-card-2-line</p></li><li class="class-icon"><i class="ri-bank-card-fill"></i><p class="name">bank-card-fill</p></li><li class="class-icon"><i class="ri-bank-card-line"></i><p class="name">bank-card-line</p></li><li class="class-icon"><i class="ri-bank-fill"></i><p class="name">bank-fill</p></li><li class="class-icon"><i class="ri-bank-line"></i><p class="name">bank-line</p></li><li class="class-icon"><i class="ri-bar-chart-2-fill"></i><p class="name">bar-chart-2-fill</p></li><li class="class-icon"><i class="ri-bar-chart-2-line"></i><p class="name">bar-chart-2-line</p></li><li class="class-icon"><i class="ri-bar-chart-box-fill"></i><p class="name">bar-chart-box-fill</p></li><li class="class-icon"><i class="ri-bar-chart-box-line"></i><p class="name">bar-chart-box-line</p></li><li class="class-icon"><i class="ri-bar-chart-fill"></i><p class="name">bar-chart-fill</p></li><li class="class-icon"><i class="ri-bar-chart-grouped-fill"></i><p class="name">bar-chart-grouped-fill</p></li><li class="class-icon"><i class="ri-bar-chart-grouped-line"></i><p class="name">bar-chart-grouped-line</p></li><li class="class-icon"><i class="ri-bar-chart-horizontal-fill"></i><p class="name">bar-chart-horizontal-fill</p></li><li class="class-icon"><i class="ri-bar-chart-horizontal-line"></i><p class="name">bar-chart-horizontal-line</p></li><li class="class-icon"><i class="ri-bar-chart-line"></i><p class="name">bar-chart-line</p></li><li class="class-icon"><i class="ri-barcode-box-fill"></i><p class="name">barcode-box-fill</p></li><li class="class-icon"><i class="ri-barcode-box-line"></i><p class="name">barcode-box-line</p></li><li class="class-icon"><i class="ri-barcode-fill"></i><p class="name">barcode-fill</p></li><li class="class-icon"><i class="ri-barcode-line"></i><p class="name">barcode-line</p></li><li class="class-icon"><i class="ri-barricade-fill"></i><p class="name">barricade-fill</p></li><li class="class-icon"><i class="ri-barricade-line"></i><p class="name">barricade-line</p></li><li class="class-icon"><i class="ri-base-station-fill"></i><p class="name">base-station-fill</p></li><li class="class-icon"><i class="ri-base-station-line"></i><p class="name">base-station-line</p></li><li class="class-icon"><i class="ri-basketball-fill"></i><p class="name">basketball-fill</p></li><li class="class-icon"><i class="ri-basketball-line"></i><p class="name">basketball-line</p></li><li class="class-icon"><i class="ri-battery-2-charge-fill"></i><p class="name">battery-2-charge-fill</p></li><li class="class-icon"><i class="ri-battery-2-charge-line"></i><p class="name">battery-2-charge-line</p></li><li class="class-icon"><i class="ri-battery-2-fill"></i><p class="name">battery-2-fill</p></li><li class="class-icon"><i class="ri-battery-2-line"></i><p class="name">battery-2-line</p></li><li class="class-icon"><i class="ri-battery-charge-fill"></i><p class="name">battery-charge-fill</p></li><li class="class-icon"><i class="ri-battery-charge-line"></i><p class="name">battery-charge-line</p></li><li class="class-icon"><i class="ri-battery-fill"></i><p class="name">battery-fill</p></li><li class="class-icon"><i class="ri-battery-line"></i><p class="name">battery-line</p></li><li class="class-icon"><i class="ri-battery-low-fill"></i><p class="name">battery-low-fill</p></li><li class="class-icon"><i class="ri-battery-low-line"></i><p class="name">battery-low-line</p></li><li class="class-icon"><i class="ri-battery-saver-fill"></i><p class="name">battery-saver-fill</p></li><li class="class-icon"><i class="ri-battery-saver-line"></i><p class="name">battery-saver-line</p></li><li class="class-icon"><i class="ri-battery-share-fill"></i><p class="name">battery-share-fill</p></li><li class="class-icon"><i class="ri-battery-share-line"></i><p class="name">battery-share-line</p></li><li class="class-icon"><i class="ri-bear-smile-fill"></i><p class="name">bear-smile-fill</p></li><li class="class-icon"><i class="ri-bear-smile-line"></i><p class="name">bear-smile-line</p></li><li class="class-icon"><i class="ri-behance-fill"></i><p class="name">behance-fill</p></li><li class="class-icon"><i class="ri-behance-line"></i><p class="name">behance-line</p></li><li class="class-icon"><i class="ri-bell-fill"></i><p class="name">bell-fill</p></li><li class="class-icon"><i class="ri-bell-line"></i><p class="name">bell-line</p></li><li class="class-icon"><i class="ri-bike-fill"></i><p class="name">bike-fill</p></li><li class="class-icon"><i class="ri-bike-line"></i><p class="name">bike-line</p></li><li class="class-icon"><i class="ri-bilibili-fill"></i><p class="name">bilibili-fill</p></li><li class="class-icon"><i class="ri-bilibili-line"></i><p class="name">bilibili-line</p></li><li class="class-icon"><i class="ri-bill-fill"></i><p class="name">bill-fill</p></li><li class="class-icon"><i class="ri-bill-line"></i><p class="name">bill-line</p></li><li class="class-icon"><i class="ri-billiards-fill"></i><p class="name">billiards-fill</p></li><li class="class-icon"><i class="ri-billiards-line"></i><p class="name">billiards-line</p></li><li class="class-icon"><i class="ri-bit-coin-fill"></i><p class="name">bit-coin-fill</p></li><li class="class-icon"><i class="ri-bit-coin-line"></i><p class="name">bit-coin-line</p></li><li class="class-icon"><i class="ri-blaze-fill"></i><p class="name">blaze-fill</p></li><li class="class-icon"><i class="ri-blaze-line"></i><p class="name">blaze-line</p></li><li class="class-icon"><i class="ri-bluetooth-connect-fill"></i><p class="name">bluetooth-connect-fill</p></li><li class="class-icon"><i class="ri-bluetooth-connect-line"></i><p class="name">bluetooth-connect-line</p></li><li class="class-icon"><i class="ri-bluetooth-fill"></i><p class="name">bluetooth-fill</p></li><li class="class-icon"><i class="ri-bluetooth-line"></i><p class="name">bluetooth-line</p></li><li class="class-icon"><i class="ri-blur-off-fill"></i><p class="name">blur-off-fill</p></li><li class="class-icon"><i class="ri-blur-off-line"></i><p class="name">blur-off-line</p></li><li class="class-icon"><i class="ri-body-scan-fill"></i><p class="name">body-scan-fill</p></li><li class="class-icon"><i class="ri-body-scan-line"></i><p class="name">body-scan-line</p></li><li class="class-icon"><i class="ri-bold"></i><p class="name">bold</p></li><li class="class-icon"><i class="ri-book-2-fill"></i><p class="name">book-2-fill</p></li><li class="class-icon"><i class="ri-book-2-line"></i><p class="name">book-2-line</p></li><li class="class-icon"><i class="ri-book-3-fill"></i><p class="name">book-3-fill</p></li><li class="class-icon"><i class="ri-book-3-line"></i><p class="name">book-3-line</p></li><li class="class-icon"><i class="ri-book-fill"></i><p class="name">book-fill</p></li><li class="class-icon"><i class="ri-book-line"></i><p class="name">book-line</p></li><li class="class-icon"><i class="ri-book-mark-fill"></i><p class="name">book-mark-fill</p></li><li class="class-icon"><i class="ri-book-mark-line"></i><p class="name">book-mark-line</p></li><li class="class-icon"><i class="ri-book-open-fill"></i><p class="name">book-open-fill</p></li><li class="class-icon"><i class="ri-book-open-line"></i><p class="name">book-open-line</p></li><li class="class-icon"><i class="ri-book-read-fill"></i><p class="name">book-read-fill</p></li><li class="class-icon"><i class="ri-book-read-line"></i><p class="name">book-read-line</p></li><li class="class-icon"><i class="ri-booklet-fill"></i><p class="name">booklet-fill</p></li><li class="class-icon"><i class="ri-booklet-line"></i><p class="name">booklet-line</p></li><li class="class-icon"><i class="ri-bookmark-2-fill"></i><p class="name">bookmark-2-fill</p></li><li class="class-icon"><i class="ri-bookmark-2-line"></i><p class="name">bookmark-2-line</p></li><li class="class-icon"><i class="ri-bookmark-3-fill"></i><p class="name">bookmark-3-fill</p></li><li class="class-icon"><i class="ri-bookmark-3-line"></i><p class="name">bookmark-3-line</p></li><li class="class-icon"><i class="ri-bookmark-fill"></i><p class="name">bookmark-fill</p></li><li class="class-icon"><i class="ri-bookmark-line"></i><p class="name">bookmark-line</p></li><li class="class-icon"><i class="ri-boxing-fill"></i><p class="name">boxing-fill</p></li><li class="class-icon"><i class="ri-boxing-line"></i><p class="name">boxing-line</p></li><li class="class-icon"><i class="ri-braces-fill"></i><p class="name">braces-fill</p></li><li class="class-icon"><i class="ri-braces-line"></i><p class="name">braces-line</p></li><li class="class-icon"><i class="ri-brackets-fill"></i><p class="name">brackets-fill</p></li><li class="class-icon"><i class="ri-brackets-line"></i><p class="name">brackets-line</p></li><li class="class-icon"><i class="ri-briefcase-2-fill"></i><p class="name">briefcase-2-fill</p></li><li class="class-icon"><i class="ri-briefcase-2-line"></i><p class="name">briefcase-2-line</p></li><li class="class-icon"><i class="ri-briefcase-3-fill"></i><p class="name">briefcase-3-fill</p></li><li class="class-icon"><i class="ri-briefcase-3-line"></i><p class="name">briefcase-3-line</p></li><li class="class-icon"><i class="ri-briefcase-4-fill"></i><p class="name">briefcase-4-fill</p></li><li class="class-icon"><i class="ri-briefcase-4-line"></i><p class="name">briefcase-4-line</p></li><li class="class-icon"><i class="ri-briefcase-5-fill"></i><p class="name">briefcase-5-fill</p></li><li class="class-icon"><i class="ri-briefcase-5-line"></i><p class="name">briefcase-5-line</p></li><li class="class-icon"><i class="ri-briefcase-fill"></i><p class="name">briefcase-fill</p></li><li class="class-icon"><i class="ri-briefcase-line"></i><p class="name">briefcase-line</p></li><li class="class-icon"><i class="ri-bring-forward"></i><p class="name">bring-forward</p></li><li class="class-icon"><i class="ri-bring-to-front"></i><p class="name">bring-to-front</p></li><li class="class-icon"><i class="ri-broadcast-fill"></i><p class="name">broadcast-fill</p></li><li class="class-icon"><i class="ri-broadcast-line"></i><p class="name">broadcast-line</p></li><li class="class-icon"><i class="ri-brush-2-fill"></i><p class="name">brush-2-fill</p></li><li class="class-icon"><i class="ri-brush-2-line"></i><p class="name">brush-2-line</p></li><li class="class-icon"><i class="ri-brush-3-fill"></i><p class="name">brush-3-fill</p></li><li class="class-icon"><i class="ri-brush-3-line"></i><p class="name">brush-3-line</p></li><li class="class-icon"><i class="ri-brush-4-fill"></i><p class="name">brush-4-fill</p></li><li class="class-icon"><i class="ri-brush-4-line"></i><p class="name">brush-4-line</p></li><li class="class-icon"><i class="ri-brush-fill"></i><p class="name">brush-fill</p></li><li class="class-icon"><i class="ri-brush-line"></i><p class="name">brush-line</p></li><li class="class-icon"><i class="ri-bubble-chart-fill"></i><p class="name">bubble-chart-fill</p></li><li class="class-icon"><i class="ri-bubble-chart-line"></i><p class="name">bubble-chart-line</p></li><li class="class-icon"><i class="ri-bug-2-fill"></i><p class="name">bug-2-fill</p></li><li class="class-icon"><i class="ri-bug-2-line"></i><p class="name">bug-2-line</p></li><li class="class-icon"><i class="ri-bug-fill"></i><p class="name">bug-fill</p></li><li class="class-icon"><i class="ri-bug-line"></i><p class="name">bug-line</p></li><li class="class-icon"><i class="ri-building-2-fill"></i><p class="name">building-2-fill</p></li><li class="class-icon"><i class="ri-building-2-line"></i><p class="name">building-2-line</p></li><li class="class-icon"><i class="ri-building-3-fill"></i><p class="name">building-3-fill</p></li><li class="class-icon"><i class="ri-building-3-line"></i><p class="name">building-3-line</p></li><li class="class-icon"><i class="ri-building-4-fill"></i><p class="name">building-4-fill</p></li><li class="class-icon"><i class="ri-building-4-line"></i><p class="name">building-4-line</p></li><li class="class-icon"><i class="ri-building-fill"></i><p class="name">building-fill</p></li><li class="class-icon"><i class="ri-building-line"></i><p class="name">building-line</p></li><li class="class-icon"><i class="ri-bus-2-fill"></i><p class="name">bus-2-fill</p></li><li class="class-icon"><i class="ri-bus-2-line"></i><p class="name">bus-2-line</p></li><li class="class-icon"><i class="ri-bus-fill"></i><p class="name">bus-fill</p></li><li class="class-icon"><i class="ri-bus-line"></i><p class="name">bus-line</p></li><li class="class-icon"><i class="ri-bus-wifi-fill"></i><p class="name">bus-wifi-fill</p></li><li class="class-icon"><i class="ri-bus-wifi-line"></i><p class="name">bus-wifi-line</p></li><li class="class-icon"><i class="ri-cactus-fill"></i><p class="name">cactus-fill</p></li><li class="class-icon"><i class="ri-cactus-line"></i><p class="name">cactus-line</p></li><li class="class-icon"><i class="ri-cake-2-fill"></i><p class="name">cake-2-fill</p></li><li class="class-icon"><i class="ri-cake-2-line"></i><p class="name">cake-2-line</p></li><li class="class-icon"><i class="ri-cake-3-fill"></i><p class="name">cake-3-fill</p></li><li class="class-icon"><i class="ri-cake-3-line"></i><p class="name">cake-3-line</p></li><li class="class-icon"><i class="ri-cake-fill"></i><p class="name">cake-fill</p></li><li class="class-icon"><i class="ri-cake-line"></i><p class="name">cake-line</p></li><li class="class-icon"><i class="ri-calculator-fill"></i><p class="name">calculator-fill</p></li><li class="class-icon"><i class="ri-calculator-line"></i><p class="name">calculator-line</p></li><li class="class-icon"><i class="ri-calendar-2-fill"></i><p class="name">calendar-2-fill</p></li><li class="class-icon"><i class="ri-calendar-2-line"></i><p class="name">calendar-2-line</p></li><li class="class-icon"><i class="ri-calendar-check-fill"></i><p class="name">calendar-check-fill</p></li><li class="class-icon"><i class="ri-calendar-check-line"></i><p class="name">calendar-check-line</p></li><li class="class-icon"><i class="ri-calendar-event-fill"></i><p class="name">calendar-event-fill</p></li><li class="class-icon"><i class="ri-calendar-event-line"></i><p class="name">calendar-event-line</p></li><li class="class-icon"><i class="ri-calendar-fill"></i><p class="name">calendar-fill</p></li><li class="class-icon"><i class="ri-calendar-line"></i><p class="name">calendar-line</p></li><li class="class-icon"><i class="ri-calendar-todo-fill"></i><p class="name">calendar-todo-fill</p></li><li class="class-icon"><i class="ri-calendar-todo-line"></i><p class="name">calendar-todo-line</p></li><li class="class-icon"><i class="ri-camera-2-fill"></i><p class="name">camera-2-fill</p></li><li class="class-icon"><i class="ri-camera-2-line"></i><p class="name">camera-2-line</p></li><li class="class-icon"><i class="ri-camera-3-fill"></i><p class="name">camera-3-fill</p></li><li class="class-icon"><i class="ri-camera-3-line"></i><p class="name">camera-3-line</p></li><li class="class-icon"><i class="ri-camera-fill"></i><p class="name">camera-fill</p></li><li class="class-icon"><i class="ri-camera-lens-fill"></i><p class="name">camera-lens-fill</p></li><li class="class-icon"><i class="ri-camera-lens-line"></i><p class="name">camera-lens-line</p></li><li class="class-icon"><i class="ri-camera-line"></i><p class="name">camera-line</p></li><li class="class-icon"><i class="ri-camera-off-fill"></i><p class="name">camera-off-fill</p></li><li class="class-icon"><i class="ri-camera-off-line"></i><p class="name">camera-off-line</p></li><li class="class-icon"><i class="ri-camera-switch-fill"></i><p class="name">camera-switch-fill</p></li><li class="class-icon"><i class="ri-camera-switch-line"></i><p class="name">camera-switch-line</p></li><li class="class-icon"><i class="ri-capsule-fill"></i><p class="name">capsule-fill</p></li><li class="class-icon"><i class="ri-capsule-line"></i><p class="name">capsule-line</p></li><li class="class-icon"><i class="ri-car-fill"></i><p class="name">car-fill</p></li><li class="class-icon"><i class="ri-car-line"></i><p class="name">car-line</p></li><li class="class-icon"><i class="ri-car-washing-fill"></i><p class="name">car-washing-fill</p></li><li class="class-icon"><i class="ri-car-washing-line"></i><p class="name">car-washing-line</p></li><li class="class-icon"><i class="ri-caravan-fill"></i><p class="name">caravan-fill</p></li><li class="class-icon"><i class="ri-caravan-line"></i><p class="name">caravan-line</p></li><li class="class-icon"><i class="ri-cast-fill"></i><p class="name">cast-fill</p></li><li class="class-icon"><i class="ri-cast-line"></i><p class="name">cast-line</p></li><li class="class-icon"><i class="ri-cellphone-fill"></i><p class="name">cellphone-fill</p></li><li class="class-icon"><i class="ri-cellphone-line"></i><p class="name">cellphone-line</p></li><li class="class-icon"><i class="ri-celsius-fill"></i><p class="name">celsius-fill</p></li><li class="class-icon"><i class="ri-celsius-line"></i><p class="name">celsius-line</p></li><li class="class-icon"><i class="ri-centos-fill"></i><p class="name">centos-fill</p></li><li class="class-icon"><i class="ri-centos-line"></i><p class="name">centos-line</p></li><li class="class-icon"><i class="ri-character-recognition-fill"></i><p class="name">character-recognition-fill</p></li><li class="class-icon"><i class="ri-character-recognition-line"></i><p class="name">character-recognition-line</p></li><li class="class-icon"><i class="ri-charging-pile-2-fill"></i><p class="name">charging-pile-2-fill</p></li><li class="class-icon"><i class="ri-charging-pile-2-line"></i><p class="name">charging-pile-2-line</p></li><li class="class-icon"><i class="ri-charging-pile-fill"></i><p class="name">charging-pile-fill</p></li><li class="class-icon"><i class="ri-charging-pile-line"></i><p class="name">charging-pile-line</p></li><li class="class-icon"><i class="ri-chat-1-fill"></i><p class="name">chat-1-fill</p></li><li class="class-icon"><i class="ri-chat-1-line"></i><p class="name">chat-1-line</p></li><li class="class-icon"><i class="ri-chat-2-fill"></i><p class="name">chat-2-fill</p></li><li class="class-icon"><i class="ri-chat-2-line"></i><p class="name">chat-2-line</p></li><li class="class-icon"><i class="ri-chat-3-fill"></i><p class="name">chat-3-fill</p></li><li class="class-icon"><i class="ri-chat-3-line"></i><p class="name">chat-3-line</p></li><li class="class-icon"><i class="ri-chat-4-fill"></i><p class="name">chat-4-fill</p></li><li class="class-icon"><i class="ri-chat-4-line"></i><p class="name">chat-4-line</p></li><li class="class-icon"><i class="ri-chat-check-fill"></i><p class="name">chat-check-fill</p></li><li class="class-icon"><i class="ri-chat-check-line"></i><p class="name">chat-check-line</p></li><li class="class-icon"><i class="ri-chat-delete-fill"></i><p class="name">chat-delete-fill</p></li><li class="class-icon"><i class="ri-chat-delete-line"></i><p class="name">chat-delete-line</p></li><li class="class-icon"><i class="ri-chat-download-fill"></i><p class="name">chat-download-fill</p></li><li class="class-icon"><i class="ri-chat-download-line"></i><p class="name">chat-download-line</p></li><li class="class-icon"><i class="ri-chat-follow-up-fill"></i><p class="name">chat-follow-up-fill</p></li><li class="class-icon"><i class="ri-chat-follow-up-line"></i><p class="name">chat-follow-up-line</p></li><li class="class-icon"><i class="ri-chat-forward-fill"></i><p class="name">chat-forward-fill</p></li><li class="class-icon"><i class="ri-chat-forward-line"></i><p class="name">chat-forward-line</p></li><li class="class-icon"><i class="ri-chat-heart-fill"></i><p class="name">chat-heart-fill</p></li><li class="class-icon"><i class="ri-chat-heart-line"></i><p class="name">chat-heart-line</p></li><li class="class-icon"><i class="ri-chat-history-fill"></i><p class="name">chat-history-fill</p></li><li class="class-icon"><i class="ri-chat-history-line"></i><p class="name">chat-history-line</p></li><li class="class-icon"><i class="ri-chat-new-fill"></i><p class="name">chat-new-fill</p></li><li class="class-icon"><i class="ri-chat-new-line"></i><p class="name">chat-new-line</p></li><li class="class-icon"><i class="ri-chat-off-fill"></i><p class="name">chat-off-fill</p></li><li class="class-icon"><i class="ri-chat-off-line"></i><p class="name">chat-off-line</p></li><li class="class-icon"><i class="ri-chat-poll-fill"></i><p class="name">chat-poll-fill</p></li><li class="class-icon"><i class="ri-chat-poll-line"></i><p class="name">chat-poll-line</p></li><li class="class-icon"><i class="ri-chat-private-fill"></i><p class="name">chat-private-fill</p></li><li class="class-icon"><i class="ri-chat-private-line"></i><p class="name">chat-private-line</p></li><li class="class-icon"><i class="ri-chat-quote-fill"></i><p class="name">chat-quote-fill</p></li><li class="class-icon"><i class="ri-chat-quote-line"></i><p class="name">chat-quote-line</p></li><li class="class-icon"><i class="ri-chat-settings-fill"></i><p class="name">chat-settings-fill</p></li><li class="class-icon"><i class="ri-chat-settings-line"></i><p class="name">chat-settings-line</p></li><li class="class-icon"><i class="ri-chat-smile-2-fill"></i><p class="name">chat-smile-2-fill</p></li><li class="class-icon"><i class="ri-chat-smile-2-line"></i><p class="name">chat-smile-2-line</p></li><li class="class-icon"><i class="ri-chat-smile-3-fill"></i><p class="name">chat-smile-3-fill</p></li><li class="class-icon"><i class="ri-chat-smile-3-line"></i><p class="name">chat-smile-3-line</p></li><li class="class-icon"><i class="ri-chat-smile-fill"></i><p class="name">chat-smile-fill</p></li><li class="class-icon"><i class="ri-chat-smile-line"></i><p class="name">chat-smile-line</p></li><li class="class-icon"><i class="ri-chat-upload-fill"></i><p class="name">chat-upload-fill</p></li><li class="class-icon"><i class="ri-chat-upload-line"></i><p class="name">chat-upload-line</p></li><li class="class-icon"><i class="ri-chat-voice-fill"></i><p class="name">chat-voice-fill</p></li><li class="class-icon"><i class="ri-chat-voice-line"></i><p class="name">chat-voice-line</p></li><li class="class-icon"><i class="ri-check-double-fill"></i><p class="name">check-double-fill</p></li><li class="class-icon"><i class="ri-check-double-line"></i><p class="name">check-double-line</p></li><li class="class-icon"><i class="ri-check-fill"></i><p class="name">check-fill</p></li><li class="class-icon"><i class="ri-check-line"></i><p class="name">check-line</p></li><li class="class-icon"><i class="ri-checkbox-blank-circle-fill"></i><p class="name">checkbox-blank-circle-fill</p></li><li class="class-icon"><i class="ri-checkbox-blank-circle-line"></i><p class="name">checkbox-blank-circle-line</p></li><li class="class-icon"><i class="ri-checkbox-blank-fill"></i><p class="name">checkbox-blank-fill</p></li><li class="class-icon"><i class="ri-checkbox-blank-line"></i><p class="name">checkbox-blank-line</p></li><li class="class-icon"><i class="ri-checkbox-circle-fill"></i><p class="name">checkbox-circle-fill</p></li><li class="class-icon"><i class="ri-checkbox-circle-line"></i><p class="name">checkbox-circle-line</p></li><li class="class-icon"><i class="ri-checkbox-fill"></i><p class="name">checkbox-fill</p></li><li class="class-icon"><i class="ri-checkbox-indeterminate-fill"></i><p class="name">checkbox-indeterminate-fill</p></li><li class="class-icon"><i class="ri-checkbox-indeterminate-line"></i><p class="name">checkbox-indeterminate-line</p></li><li class="class-icon"><i class="ri-checkbox-line"></i><p class="name">checkbox-line</p></li><li class="class-icon"><i class="ri-checkbox-multiple-blank-fill"></i><p class="name">checkbox-multiple-blank-fill</p></li><li class="class-icon"><i class="ri-checkbox-multiple-blank-line"></i><p class="name">checkbox-multiple-blank-line</p></li><li class="class-icon"><i class="ri-checkbox-multiple-fill"></i><p class="name">checkbox-multiple-fill</p></li><li class="class-icon"><i class="ri-checkbox-multiple-line"></i><p class="name">checkbox-multiple-line</p></li><li class="class-icon"><i class="ri-china-railway-fill"></i><p class="name">china-railway-fill</p></li><li class="class-icon"><i class="ri-china-railway-line"></i><p class="name">china-railway-line</p></li><li class="class-icon"><i class="ri-chrome-fill"></i><p class="name">chrome-fill</p></li><li class="class-icon"><i class="ri-chrome-line"></i><p class="name">chrome-line</p></li><li class="class-icon"><i class="ri-clapperboard-fill"></i><p class="name">clapperboard-fill</p></li><li class="class-icon"><i class="ri-clapperboard-line"></i><p class="name">clapperboard-line</p></li><li class="class-icon"><i class="ri-clipboard-fill"></i><p class="name">clipboard-fill</p></li><li class="class-icon"><i class="ri-clipboard-line"></i><p class="name">clipboard-line</p></li><li class="class-icon"><i class="ri-clockwise-2-fill"></i><p class="name">clockwise-2-fill</p></li><li class="class-icon"><i class="ri-clockwise-2-line"></i><p class="name">clockwise-2-line</p></li><li class="class-icon"><i class="ri-clockwise-fill"></i><p class="name">clockwise-fill</p></li><li class="class-icon"><i class="ri-clockwise-line"></i><p class="name">clockwise-line</p></li><li class="class-icon"><i class="ri-close-circle-fill"></i><p class="name">close-circle-fill</p></li><li class="class-icon"><i class="ri-close-circle-line"></i><p class="name">close-circle-line</p></li><li class="class-icon"><i class="ri-close-fill"></i><p class="name">close-fill</p></li><li class="class-icon"><i class="ri-close-line"></i><p class="name">close-line</p></li><li class="class-icon"><i class="ri-closed-captioning-fill"></i><p class="name">closed-captioning-fill</p></li><li class="class-icon"><i class="ri-closed-captioning-line"></i><p class="name">closed-captioning-line</p></li><li class="class-icon"><i class="ri-cloud-fill"></i><p class="name">cloud-fill</p></li><li class="class-icon"><i class="ri-cloud-line"></i><p class="name">cloud-line</p></li><li class="class-icon"><i class="ri-cloud-off-fill"></i><p class="name">cloud-off-fill</p></li><li class="class-icon"><i class="ri-cloud-off-line"></i><p class="name">cloud-off-line</p></li><li class="class-icon"><i class="ri-cloud-windy-fill"></i><p class="name">cloud-windy-fill</p></li><li class="class-icon"><i class="ri-cloud-windy-line"></i><p class="name">cloud-windy-line</p></li><li class="class-icon"><i class="ri-cloudy-2-fill"></i><p class="name">cloudy-2-fill</p></li><li class="class-icon"><i class="ri-cloudy-2-line"></i><p class="name">cloudy-2-line</p></li><li class="class-icon"><i class="ri-cloudy-fill"></i><p class="name">cloudy-fill</p></li><li class="class-icon"><i class="ri-cloudy-line"></i><p class="name">cloudy-line</p></li><li class="class-icon"><i class="ri-code-box-fill"></i><p class="name">code-box-fill</p></li><li class="class-icon"><i class="ri-code-box-line"></i><p class="name">code-box-line</p></li><li class="class-icon"><i class="ri-code-fill"></i><p class="name">code-fill</p></li><li class="class-icon"><i class="ri-code-line"></i><p class="name">code-line</p></li><li class="class-icon"><i class="ri-code-s-fill"></i><p class="name">code-s-fill</p></li><li class="class-icon"><i class="ri-code-s-line"></i><p class="name">code-s-line</p></li><li class="class-icon"><i class="ri-code-s-slash-fill"></i><p class="name">code-s-slash-fill</p></li><li class="class-icon"><i class="ri-code-s-slash-line"></i><p class="name">code-s-slash-line</p></li><li class="class-icon"><i class="ri-code-view"></i><p class="name">code-view</p></li><li class="class-icon"><i class="ri-codepen-fill"></i><p class="name">codepen-fill</p></li><li class="class-icon"><i class="ri-codepen-line"></i><p class="name">codepen-line</p></li><li class="class-icon"><i class="ri-coin-fill"></i><p class="name">coin-fill</p></li><li class="class-icon"><i class="ri-coin-line"></i><p class="name">coin-line</p></li><li class="class-icon"><i class="ri-coins-fill"></i><p class="name">coins-fill</p></li><li class="class-icon"><i class="ri-coins-line"></i><p class="name">coins-line</p></li><li class="class-icon"><i class="ri-collage-fill"></i><p class="name">collage-fill</p></li><li class="class-icon"><i class="ri-collage-line"></i><p class="name">collage-line</p></li><li class="class-icon"><i class="ri-command-fill"></i><p class="name">command-fill</p></li><li class="class-icon"><i class="ri-command-line"></i><p class="name">command-line</p></li><li class="class-icon"><i class="ri-community-fill"></i><p class="name">community-fill</p></li><li class="class-icon"><i class="ri-community-line"></i><p class="name">community-line</p></li><li class="class-icon"><i class="ri-compass-2-fill"></i><p class="name">compass-2-fill</p></li><li class="class-icon"><i class="ri-compass-2-line"></i><p class="name">compass-2-line</p></li><li class="class-icon"><i class="ri-compass-3-fill"></i><p class="name">compass-3-fill</p></li><li class="class-icon"><i class="ri-compass-3-line"></i><p class="name">compass-3-line</p></li><li class="class-icon"><i class="ri-compass-4-fill"></i><p class="name">compass-4-fill</p></li><li class="class-icon"><i class="ri-compass-4-line"></i><p class="name">compass-4-line</p></li><li class="class-icon"><i class="ri-compass-discover-fill"></i><p class="name">compass-discover-fill</p></li><li class="class-icon"><i class="ri-compass-discover-line"></i><p class="name">compass-discover-line</p></li><li class="class-icon"><i class="ri-compass-fill"></i><p class="name">compass-fill</p></li><li class="class-icon"><i class="ri-compass-line"></i><p class="name">compass-line</p></li><li class="class-icon"><i class="ri-compasses-2-fill"></i><p class="name">compasses-2-fill</p></li><li class="class-icon"><i class="ri-compasses-2-line"></i><p class="name">compasses-2-line</p></li><li class="class-icon"><i class="ri-compasses-fill"></i><p class="name">compasses-fill</p></li><li class="class-icon"><i class="ri-compasses-line"></i><p class="name">compasses-line</p></li><li class="class-icon"><i class="ri-computer-fill"></i><p class="name">computer-fill</p></li><li class="class-icon"><i class="ri-computer-line"></i><p class="name">computer-line</p></li><li class="class-icon"><i class="ri-contacts-book-2-fill"></i><p class="name">contacts-book-2-fill</p></li><li class="class-icon"><i class="ri-contacts-book-2-line"></i><p class="name">contacts-book-2-line</p></li><li class="class-icon"><i class="ri-contacts-book-fill"></i><p class="name">contacts-book-fill</p></li><li class="class-icon"><i class="ri-contacts-book-line"></i><p class="name">contacts-book-line</p></li><li class="class-icon"><i class="ri-contacts-book-upload-fill"></i><p class="name">contacts-book-upload-fill</p></li><li class="class-icon"><i class="ri-contacts-book-upload-line"></i><p class="name">contacts-book-upload-line</p></li><li class="class-icon"><i class="ri-contacts-fill"></i><p class="name">contacts-fill</p></li><li class="class-icon"><i class="ri-contacts-line"></i><p class="name">contacts-line</p></li><li class="class-icon"><i class="ri-contrast-2-fill"></i><p class="name">contrast-2-fill</p></li><li class="class-icon"><i class="ri-contrast-2-line"></i><p class="name">contrast-2-line</p></li><li class="class-icon"><i class="ri-contrast-drop-2-fill"></i><p class="name">contrast-drop-2-fill</p></li><li class="class-icon"><i class="ri-contrast-drop-2-line"></i><p class="name">contrast-drop-2-line</p></li><li class="class-icon"><i class="ri-contrast-drop-fill"></i><p class="name">contrast-drop-fill</p></li><li class="class-icon"><i class="ri-contrast-drop-line"></i><p class="name">contrast-drop-line</p></li><li class="class-icon"><i class="ri-contrast-fill"></i><p class="name">contrast-fill</p></li><li class="class-icon"><i class="ri-contrast-line"></i><p class="name">contrast-line</p></li><li class="class-icon"><i class="ri-copper-coin-fill"></i><p class="name">copper-coin-fill</p></li><li class="class-icon"><i class="ri-copper-coin-line"></i><p class="name">copper-coin-line</p></li><li class="class-icon"><i class="ri-copper-diamond-fill"></i><p class="name">copper-diamond-fill</p></li><li class="class-icon"><i class="ri-copper-diamond-line"></i><p class="name">copper-diamond-line</p></li><li class="class-icon"><i class="ri-copyleft-fill"></i><p class="name">copyleft-fill</p></li><li class="class-icon"><i class="ri-copyleft-line"></i><p class="name">copyleft-line</p></li><li class="class-icon"><i class="ri-copyright-fill"></i><p class="name">copyright-fill</p></li><li class="class-icon"><i class="ri-copyright-line"></i><p class="name">copyright-line</p></li><li class="class-icon"><i class="ri-coreos-fill"></i><p class="name">coreos-fill</p></li><li class="class-icon"><i class="ri-coreos-line"></i><p class="name">coreos-line</p></li><li class="class-icon"><i class="ri-coupon-2-fill"></i><p class="name">coupon-2-fill</p></li><li class="class-icon"><i class="ri-coupon-2-line"></i><p class="name">coupon-2-line</p></li><li class="class-icon"><i class="ri-coupon-3-fill"></i><p class="name">coupon-3-fill</p></li><li class="class-icon"><i class="ri-coupon-3-line"></i><p class="name">coupon-3-line</p></li><li class="class-icon"><i class="ri-coupon-4-fill"></i><p class="name">coupon-4-fill</p></li><li class="class-icon"><i class="ri-coupon-4-line"></i><p class="name">coupon-4-line</p></li><li class="class-icon"><i class="ri-coupon-5-fill"></i><p class="name">coupon-5-fill</p></li><li class="class-icon"><i class="ri-coupon-5-line"></i><p class="name">coupon-5-line</p></li><li class="class-icon"><i class="ri-coupon-fill"></i><p class="name">coupon-fill</p></li><li class="class-icon"><i class="ri-coupon-line"></i><p class="name">coupon-line</p></li><li class="class-icon"><i class="ri-cpu-fill"></i><p class="name">cpu-fill</p></li><li class="class-icon"><i class="ri-cpu-line"></i><p class="name">cpu-line</p></li><li class="class-icon"><i class="ri-creative-commons-by-fill"></i><p class="name">creative-commons-by-fill</p></li><li class="class-icon"><i class="ri-creative-commons-by-line"></i><p class="name">creative-commons-by-line</p></li><li class="class-icon"><i class="ri-creative-commons-fill"></i><p class="name">creative-commons-fill</p></li><li class="class-icon"><i class="ri-creative-commons-line"></i><p class="name">creative-commons-line</p></li><li class="class-icon"><i class="ri-creative-commons-nc-fill"></i><p class="name">creative-commons-nc-fill</p></li><li class="class-icon"><i class="ri-creative-commons-nc-line"></i><p class="name">creative-commons-nc-line</p></li><li class="class-icon"><i class="ri-creative-commons-nd-fill"></i><p class="name">creative-commons-nd-fill</p></li><li class="class-icon"><i class="ri-creative-commons-nd-line"></i><p class="name">creative-commons-nd-line</p></li><li class="class-icon"><i class="ri-creative-commons-sa-fill"></i><p class="name">creative-commons-sa-fill</p></li><li class="class-icon"><i class="ri-creative-commons-sa-line"></i><p class="name">creative-commons-sa-line</p></li><li class="class-icon"><i class="ri-creative-commons-zero-fill"></i><p class="name">creative-commons-zero-fill</p></li><li class="class-icon"><i class="ri-creative-commons-zero-line"></i><p class="name">creative-commons-zero-line</p></li><li class="class-icon"><i class="ri-criminal-fill"></i><p class="name">criminal-fill</p></li><li class="class-icon"><i class="ri-criminal-line"></i><p class="name">criminal-line</p></li><li class="class-icon"><i class="ri-crop-2-fill"></i><p class="name">crop-2-fill</p></li><li class="class-icon"><i class="ri-crop-2-line"></i><p class="name">crop-2-line</p></li><li class="class-icon"><i class="ri-crop-fill"></i><p class="name">crop-fill</p></li><li class="class-icon"><i class="ri-crop-line"></i><p class="name">crop-line</p></li><li class="class-icon"><i class="ri-css3-fill"></i><p class="name">css3-fill</p></li><li class="class-icon"><i class="ri-css3-line"></i><p class="name">css3-line</p></li><li class="class-icon"><i class="ri-cup-fill"></i><p class="name">cup-fill</p></li><li class="class-icon"><i class="ri-cup-line"></i><p class="name">cup-line</p></li><li class="class-icon"><i class="ri-currency-fill"></i><p class="name">currency-fill</p></li><li class="class-icon"><i class="ri-currency-line"></i><p class="name">currency-line</p></li><li class="class-icon"><i class="ri-cursor-fill"></i><p class="name">cursor-fill</p></li><li class="class-icon"><i class="ri-cursor-line"></i><p class="name">cursor-line</p></li><li class="class-icon"><i class="ri-customer-service-2-fill"></i><p class="name">customer-service-2-fill</p></li><li class="class-icon"><i class="ri-customer-service-2-line"></i><p class="name">customer-service-2-line</p></li><li class="class-icon"><i class="ri-customer-service-fill"></i><p class="name">customer-service-fill</p></li><li class="class-icon"><i class="ri-customer-service-line"></i><p class="name">customer-service-line</p></li><li class="class-icon"><i class="ri-dashboard-2-fill"></i><p class="name">dashboard-2-fill</p></li><li class="class-icon"><i class="ri-dashboard-2-line"></i><p class="name">dashboard-2-line</p></li><li class="class-icon"><i class="ri-dashboard-3-fill"></i><p class="name">dashboard-3-fill</p></li><li class="class-icon"><i class="ri-dashboard-3-line"></i><p class="name">dashboard-3-line</p></li><li class="class-icon"><i class="ri-dashboard-fill"></i><p class="name">dashboard-fill</p></li><li class="class-icon"><i class="ri-dashboard-line"></i><p class="name">dashboard-line</p></li><li class="class-icon"><i class="ri-database-2-fill"></i><p class="name">database-2-fill</p></li><li class="class-icon"><i class="ri-database-2-line"></i><p class="name">database-2-line</p></li><li class="class-icon"><i class="ri-database-fill"></i><p class="name">database-fill</p></li><li class="class-icon"><i class="ri-database-line"></i><p class="name">database-line</p></li><li class="class-icon"><i class="ri-delete-back-2-fill"></i><p class="name">delete-back-2-fill</p></li><li class="class-icon"><i class="ri-delete-back-2-line"></i><p class="name">delete-back-2-line</p></li><li class="class-icon"><i class="ri-delete-back-fill"></i><p class="name">delete-back-fill</p></li><li class="class-icon"><i class="ri-delete-back-line"></i><p class="name">delete-back-line</p></li><li class="class-icon"><i class="ri-delete-bin-2-fill"></i><p class="name">delete-bin-2-fill</p></li><li class="class-icon"><i class="ri-delete-bin-2-line"></i><p class="name">delete-bin-2-line</p></li><li class="class-icon"><i class="ri-delete-bin-3-fill"></i><p class="name">delete-bin-3-fill</p></li><li class="class-icon"><i class="ri-delete-bin-3-line"></i><p class="name">delete-bin-3-line</p></li><li class="class-icon"><i class="ri-delete-bin-4-fill"></i><p class="name">delete-bin-4-fill</p></li><li class="class-icon"><i class="ri-delete-bin-4-line"></i><p class="name">delete-bin-4-line</p></li><li class="class-icon"><i class="ri-delete-bin-5-fill"></i><p class="name">delete-bin-5-fill</p></li><li class="class-icon"><i class="ri-delete-bin-5-line"></i><p class="name">delete-bin-5-line</p></li><li class="class-icon"><i class="ri-delete-bin-6-fill"></i><p class="name">delete-bin-6-fill</p></li><li class="class-icon"><i class="ri-delete-bin-6-line"></i><p class="name">delete-bin-6-line</p></li><li class="class-icon"><i class="ri-delete-bin-7-fill"></i><p class="name">delete-bin-7-fill</p></li><li class="class-icon"><i class="ri-delete-bin-7-line"></i><p class="name">delete-bin-7-line</p></li><li class="class-icon"><i class="ri-delete-bin-fill"></i><p class="name">delete-bin-fill</p></li><li class="class-icon"><i class="ri-delete-bin-line"></i><p class="name">delete-bin-line</p></li><li class="class-icon"><i class="ri-delete-column"></i><p class="name">delete-column</p></li><li class="class-icon"><i class="ri-delete-row"></i><p class="name">delete-row</p></li><li class="class-icon"><i class="ri-device-fill"></i><p class="name">device-fill</p></li><li class="class-icon"><i class="ri-device-line"></i><p class="name">device-line</p></li><li class="class-icon"><i class="ri-device-recover-fill"></i><p class="name">device-recover-fill</p></li><li class="class-icon"><i class="ri-device-recover-line"></i><p class="name">device-recover-line</p></li><li class="class-icon"><i class="ri-dingding-fill"></i><p class="name">dingding-fill</p></li><li class="class-icon"><i class="ri-dingding-line"></i><p class="name">dingding-line</p></li><li class="class-icon"><i class="ri-direction-fill"></i><p class="name">direction-fill</p></li><li class="class-icon"><i class="ri-direction-line"></i><p class="name">direction-line</p></li><li class="class-icon"><i class="ri-disc-fill"></i><p class="name">disc-fill</p></li><li class="class-icon"><i class="ri-disc-line"></i><p class="name">disc-line</p></li><li class="class-icon"><i class="ri-discord-fill"></i><p class="name">discord-fill</p></li><li class="class-icon"><i class="ri-discord-line"></i><p class="name">discord-line</p></li><li class="class-icon"><i class="ri-discuss-fill"></i><p class="name">discuss-fill</p></li><li class="class-icon"><i class="ri-discuss-line"></i><p class="name">discuss-line</p></li><li class="class-icon"><i class="ri-dislike-fill"></i><p class="name">dislike-fill</p></li><li class="class-icon"><i class="ri-dislike-line"></i><p class="name">dislike-line</p></li><li class="class-icon"><i class="ri-disqus-fill"></i><p class="name">disqus-fill</p></li><li class="class-icon"><i class="ri-disqus-line"></i><p class="name">disqus-line</p></li><li class="class-icon"><i class="ri-divide-fill"></i><p class="name">divide-fill</p></li><li class="class-icon"><i class="ri-divide-line"></i><p class="name">divide-line</p></li><li class="class-icon"><i class="ri-donut-chart-fill"></i><p class="name">donut-chart-fill</p></li><li class="class-icon"><i class="ri-donut-chart-line"></i><p class="name">donut-chart-line</p></li><li class="class-icon"><i class="ri-door-closed-fill"></i><p class="name">door-closed-fill</p></li><li class="class-icon"><i class="ri-door-closed-line"></i><p class="name">door-closed-line</p></li><li class="class-icon"><i class="ri-door-fill"></i><p class="name">door-fill</p></li><li class="class-icon"><i class="ri-door-line"></i><p class="name">door-line</p></li><li class="class-icon"><i class="ri-door-lock-box-fill"></i><p class="name">door-lock-box-fill</p></li><li class="class-icon"><i class="ri-door-lock-box-line"></i><p class="name">door-lock-box-line</p></li><li class="class-icon"><i class="ri-door-lock-fill"></i><p class="name">door-lock-fill</p></li><li class="class-icon"><i class="ri-door-lock-line"></i><p class="name">door-lock-line</p></li><li class="class-icon"><i class="ri-door-open-fill"></i><p class="name">door-open-fill</p></li><li class="class-icon"><i class="ri-door-open-line"></i><p class="name">door-open-line</p></li><li class="class-icon"><i class="ri-dossier-fill"></i><p class="name">dossier-fill</p></li><li class="class-icon"><i class="ri-dossier-line"></i><p class="name">dossier-line</p></li><li class="class-icon"><i class="ri-douban-fill"></i><p class="name">douban-fill</p></li><li class="class-icon"><i class="ri-douban-line"></i><p class="name">douban-line</p></li><li class="class-icon"><i class="ri-double-quotes-l"></i><p class="name">double-quotes-l</p></li><li class="class-icon"><i class="ri-double-quotes-r"></i><p class="name">double-quotes-r</p></li><li class="class-icon"><i class="ri-download-2-fill"></i><p class="name">download-2-fill</p></li><li class="class-icon"><i class="ri-download-2-line"></i><p class="name">download-2-line</p></li><li class="class-icon"><i class="ri-download-cloud-2-fill"></i><p class="name">download-cloud-2-fill</p></li><li class="class-icon"><i class="ri-download-cloud-2-line"></i><p class="name">download-cloud-2-line</p></li><li class="class-icon"><i class="ri-download-cloud-fill"></i><p class="name">download-cloud-fill</p></li><li class="class-icon"><i class="ri-download-cloud-line"></i><p class="name">download-cloud-line</p></li><li class="class-icon"><i class="ri-download-fill"></i><p class="name">download-fill</p></li><li class="class-icon"><i class="ri-download-line"></i><p class="name">download-line</p></li><li class="class-icon"><i class="ri-draft-fill"></i><p class="name">draft-fill</p></li><li class="class-icon"><i class="ri-draft-line"></i><p class="name">draft-line</p></li><li class="class-icon"><i class="ri-drag-drop-fill"></i><p class="name">drag-drop-fill</p></li><li class="class-icon"><i class="ri-drag-drop-line"></i><p class="name">drag-drop-line</p></li><li class="class-icon"><i class="ri-drag-move-2-fill"></i><p class="name">drag-move-2-fill</p></li><li class="class-icon"><i class="ri-drag-move-2-line"></i><p class="name">drag-move-2-line</p></li><li class="class-icon"><i class="ri-drag-move-fill"></i><p class="name">drag-move-fill</p></li><li class="class-icon"><i class="ri-drag-move-line"></i><p class="name">drag-move-line</p></li><li class="class-icon"><i class="ri-dribbble-fill"></i><p class="name">dribbble-fill</p></li><li class="class-icon"><i class="ri-dribbble-line"></i><p class="name">dribbble-line</p></li><li class="class-icon"><i class="ri-drive-fill"></i><p class="name">drive-fill</p></li><li class="class-icon"><i class="ri-drive-line"></i><p class="name">drive-line</p></li><li class="class-icon"><i class="ri-drizzle-fill"></i><p class="name">drizzle-fill</p></li><li class="class-icon"><i class="ri-drizzle-line"></i><p class="name">drizzle-line</p></li><li class="class-icon"><i class="ri-drop-fill"></i><p class="name">drop-fill</p></li><li class="class-icon"><i class="ri-drop-line"></i><p class="name">drop-line</p></li><li class="class-icon"><i class="ri-dropbox-fill"></i><p class="name">dropbox-fill</p></li><li class="class-icon"><i class="ri-dropbox-line"></i><p class="name">dropbox-line</p></li><li class="class-icon"><i class="ri-dual-sim-1-fill"></i><p class="name">dual-sim-1-fill</p></li><li class="class-icon"><i class="ri-dual-sim-1-line"></i><p class="name">dual-sim-1-line</p></li><li class="class-icon"><i class="ri-dual-sim-2-fill"></i><p class="name">dual-sim-2-fill</p></li><li class="class-icon"><i class="ri-dual-sim-2-line"></i><p class="name">dual-sim-2-line</p></li><li class="class-icon"><i class="ri-dv-fill"></i><p class="name">dv-fill</p></li><li class="class-icon"><i class="ri-dv-line"></i><p class="name">dv-line</p></li><li class="class-icon"><i class="ri-dvd-fill"></i><p class="name">dvd-fill</p></li><li class="class-icon"><i class="ri-dvd-line"></i><p class="name">dvd-line</p></li><li class="class-icon"><i class="ri-e-bike-2-fill"></i><p class="name">e-bike-2-fill</p></li><li class="class-icon"><i class="ri-e-bike-2-line"></i><p class="name">e-bike-2-line</p></li><li class="class-icon"><i class="ri-e-bike-fill"></i><p class="name">e-bike-fill</p></li><li class="class-icon"><i class="ri-e-bike-line"></i><p class="name">e-bike-line</p></li><li class="class-icon"><i class="ri-earth-fill"></i><p class="name">earth-fill</p></li><li class="class-icon"><i class="ri-earth-line"></i><p class="name">earth-line</p></li><li class="class-icon"><i class="ri-earthquake-fill"></i><p class="name">earthquake-fill</p></li><li class="class-icon"><i class="ri-earthquake-line"></i><p class="name">earthquake-line</p></li><li class="class-icon"><i class="ri-edge-fill"></i><p class="name">edge-fill</p></li><li class="class-icon"><i class="ri-edge-line"></i><p class="name">edge-line</p></li><li class="class-icon"><i class="ri-edit-2-fill"></i><p class="name">edit-2-fill</p></li><li class="class-icon"><i class="ri-edit-2-line"></i><p class="name">edit-2-line</p></li><li class="class-icon"><i class="ri-edit-box-fill"></i><p class="name">edit-box-fill</p></li><li class="class-icon"><i class="ri-edit-box-line"></i><p class="name">edit-box-line</p></li><li class="class-icon"><i class="ri-edit-circle-fill"></i><p class="name">edit-circle-fill</p></li><li class="class-icon"><i class="ri-edit-circle-line"></i><p class="name">edit-circle-line</p></li><li class="class-icon"><i class="ri-edit-fill"></i><p class="name">edit-fill</p></li><li class="class-icon"><i class="ri-edit-line"></i><p class="name">edit-line</p></li><li class="class-icon"><i class="ri-eject-fill"></i><p class="name">eject-fill</p></li><li class="class-icon"><i class="ri-eject-line"></i><p class="name">eject-line</p></li><li class="class-icon"><i class="ri-emotion-2-fill"></i><p class="name">emotion-2-fill</p></li><li class="class-icon"><i class="ri-emotion-2-line"></i><p class="name">emotion-2-line</p></li><li class="class-icon"><i class="ri-emotion-fill"></i><p class="name">emotion-fill</p></li><li class="class-icon"><i class="ri-emotion-happy-fill"></i><p class="name">emotion-happy-fill</p></li><li class="class-icon"><i class="ri-emotion-happy-line"></i><p class="name">emotion-happy-line</p></li><li class="class-icon"><i class="ri-emotion-laugh-fill"></i><p class="name">emotion-laugh-fill</p></li><li class="class-icon"><i class="ri-emotion-laugh-line"></i><p class="name">emotion-laugh-line</p></li><li class="class-icon"><i class="ri-emotion-line"></i><p class="name">emotion-line</p></li><li class="class-icon"><i class="ri-emotion-normal-fill"></i><p class="name">emotion-normal-fill</p></li><li class="class-icon"><i class="ri-emotion-normal-line"></i><p class="name">emotion-normal-line</p></li><li class="class-icon"><i class="ri-emotion-sad-fill"></i><p class="name">emotion-sad-fill</p></li><li class="class-icon"><i class="ri-emotion-sad-line"></i><p class="name">emotion-sad-line</p></li><li class="class-icon"><i class="ri-emotion-unhappy-fill"></i><p class="name">emotion-unhappy-fill</p></li><li class="class-icon"><i class="ri-emotion-unhappy-line"></i><p class="name">emotion-unhappy-line</p></li><li class="class-icon"><i class="ri-empathize-fill"></i><p class="name">empathize-fill</p></li><li class="class-icon"><i class="ri-empathize-line"></i><p class="name">empathize-line</p></li><li class="class-icon"><i class="ri-emphasis-cn"></i><p class="name">emphasis-cn</p></li><li class="class-icon"><i class="ri-emphasis"></i><p class="name">emphasis</p></li><li class="class-icon"><i class="ri-english-input"></i><p class="name">english-input</p></li><li class="class-icon"><i class="ri-equalizer-fill"></i><p class="name">equalizer-fill</p></li><li class="class-icon"><i class="ri-equalizer-line"></i><p class="name">equalizer-line</p></li><li class="class-icon"><i class="ri-eraser-fill"></i><p class="name">eraser-fill</p></li><li class="class-icon"><i class="ri-eraser-line"></i><p class="name">eraser-line</p></li><li class="class-icon"><i class="ri-error-warning-fill"></i><p class="name">error-warning-fill</p></li><li class="class-icon"><i class="ri-error-warning-line"></i><p class="name">error-warning-line</p></li><li class="class-icon"><i class="ri-evernote-fill"></i><p class="name">evernote-fill</p></li><li class="class-icon"><i class="ri-evernote-line"></i><p class="name">evernote-line</p></li><li class="class-icon"><i class="ri-exchange-box-fill"></i><p class="name">exchange-box-fill</p></li><li class="class-icon"><i class="ri-exchange-box-line"></i><p class="name">exchange-box-line</p></li><li class="class-icon"><i class="ri-exchange-cny-fill"></i><p class="name">exchange-cny-fill</p></li><li class="class-icon"><i class="ri-exchange-cny-line"></i><p class="name">exchange-cny-line</p></li><li class="class-icon"><i class="ri-exchange-dollar-fill"></i><p class="name">exchange-dollar-fill</p></li><li class="class-icon"><i class="ri-exchange-dollar-line"></i><p class="name">exchange-dollar-line</p></li><li class="class-icon"><i class="ri-exchange-fill"></i><p class="name">exchange-fill</p></li><li class="class-icon"><i class="ri-exchange-funds-fill"></i><p class="name">exchange-funds-fill</p></li><li class="class-icon"><i class="ri-exchange-funds-line"></i><p class="name">exchange-funds-line</p></li><li class="class-icon"><i class="ri-exchange-line"></i><p class="name">exchange-line</p></li><li class="class-icon"><i class="ri-external-link-fill"></i><p class="name">external-link-fill</p></li><li class="class-icon"><i class="ri-external-link-line"></i><p class="name">external-link-line</p></li><li class="class-icon"><i class="ri-eye-2-fill"></i><p class="name">eye-2-fill</p></li><li class="class-icon"><i class="ri-eye-2-line"></i><p class="name">eye-2-line</p></li><li class="class-icon"><i class="ri-eye-close-fill"></i><p class="name">eye-close-fill</p></li><li class="class-icon"><i class="ri-eye-close-line"></i><p class="name">eye-close-line</p></li><li class="class-icon"><i class="ri-eye-fill"></i><p class="name">eye-fill</p></li><li class="class-icon"><i class="ri-eye-line"></i><p class="name">eye-line</p></li><li class="class-icon"><i class="ri-eye-off-fill"></i><p class="name">eye-off-fill</p></li><li class="class-icon"><i class="ri-eye-off-line"></i><p class="name">eye-off-line</p></li><li class="class-icon"><i class="ri-facebook-box-fill"></i><p class="name">facebook-box-fill</p></li><li class="class-icon"><i class="ri-facebook-box-line"></i><p class="name">facebook-box-line</p></li><li class="class-icon"><i class="ri-facebook-circle-fill"></i><p class="name">facebook-circle-fill</p></li><li class="class-icon"><i class="ri-facebook-circle-line"></i><p class="name">facebook-circle-line</p></li><li class="class-icon"><i class="ri-facebook-fill"></i><p class="name">facebook-fill</p></li><li class="class-icon"><i class="ri-facebook-line"></i><p class="name">facebook-line</p></li><li class="class-icon"><i class="ri-fahrenheit-fill"></i><p class="name">fahrenheit-fill</p></li><li class="class-icon"><i class="ri-fahrenheit-line"></i><p class="name">fahrenheit-line</p></li><li class="class-icon"><i class="ri-feedback-fill"></i><p class="name">feedback-fill</p></li><li class="class-icon"><i class="ri-feedback-line"></i><p class="name">feedback-line</p></li><li class="class-icon"><i class="ri-file-2-fill"></i><p class="name">file-2-fill</p></li><li class="class-icon"><i class="ri-file-2-line"></i><p class="name">file-2-line</p></li><li class="class-icon"><i class="ri-file-3-fill"></i><p class="name">file-3-fill</p></li><li class="class-icon"><i class="ri-file-3-line"></i><p class="name">file-3-line</p></li><li class="class-icon"><i class="ri-file-4-fill"></i><p class="name">file-4-fill</p></li><li class="class-icon"><i class="ri-file-4-line"></i><p class="name">file-4-line</p></li><li class="class-icon"><i class="ri-file-add-fill"></i><p class="name">file-add-fill</p></li><li class="class-icon"><i class="ri-file-add-line"></i><p class="name">file-add-line</p></li><li class="class-icon"><i class="ri-file-chart-2-fill"></i><p class="name">file-chart-2-fill</p></li><li class="class-icon"><i class="ri-file-chart-2-line"></i><p class="name">file-chart-2-line</p></li><li class="class-icon"><i class="ri-file-chart-fill"></i><p class="name">file-chart-fill</p></li><li class="class-icon"><i class="ri-file-chart-line"></i><p class="name">file-chart-line</p></li><li class="class-icon"><i class="ri-file-cloud-fill"></i><p class="name">file-cloud-fill</p></li><li class="class-icon"><i class="ri-file-cloud-line"></i><p class="name">file-cloud-line</p></li><li class="class-icon"><i class="ri-file-code-fill"></i><p class="name">file-code-fill</p></li><li class="class-icon"><i class="ri-file-code-line"></i><p class="name">file-code-line</p></li><li class="class-icon"><i class="ri-file-copy-2-fill"></i><p class="name">file-copy-2-fill</p></li><li class="class-icon"><i class="ri-file-copy-2-line"></i><p class="name">file-copy-2-line</p></li><li class="class-icon"><i class="ri-file-copy-fill"></i><p class="name">file-copy-fill</p></li><li class="class-icon"><i class="ri-file-copy-line"></i><p class="name">file-copy-line</p></li><li class="class-icon"><i class="ri-file-damage-fill"></i><p class="name">file-damage-fill</p></li><li class="class-icon"><i class="ri-file-damage-line"></i><p class="name">file-damage-line</p></li><li class="class-icon"><i class="ri-file-download-fill"></i><p class="name">file-download-fill</p></li><li class="class-icon"><i class="ri-file-download-line"></i><p class="name">file-download-line</p></li><li class="class-icon"><i class="ri-file-edit-fill"></i><p class="name">file-edit-fill</p></li><li class="class-icon"><i class="ri-file-edit-line"></i><p class="name">file-edit-line</p></li><li class="class-icon"><i class="ri-file-excel-2-fill"></i><p class="name">file-excel-2-fill</p></li><li class="class-icon"><i class="ri-file-excel-2-line"></i><p class="name">file-excel-2-line</p></li><li class="class-icon"><i class="ri-file-excel-fill"></i><p class="name">file-excel-fill</p></li><li class="class-icon"><i class="ri-file-excel-line"></i><p class="name">file-excel-line</p></li><li class="class-icon"><i class="ri-file-fill"></i><p class="name">file-fill</p></li><li class="class-icon"><i class="ri-file-forbid-fill"></i><p class="name">file-forbid-fill</p></li><li class="class-icon"><i class="ri-file-forbid-line"></i><p class="name">file-forbid-line</p></li><li class="class-icon"><i class="ri-file-gif-fill"></i><p class="name">file-gif-fill</p></li><li class="class-icon"><i class="ri-file-gif-line"></i><p class="name">file-gif-line</p></li><li class="class-icon"><i class="ri-file-history-fill"></i><p class="name">file-history-fill</p></li><li class="class-icon"><i class="ri-file-history-line"></i><p class="name">file-history-line</p></li><li class="class-icon"><i class="ri-file-hwp-fill"></i><p class="name">file-hwp-fill</p></li><li class="class-icon"><i class="ri-file-hwp-line"></i><p class="name">file-hwp-line</p></li><li class="class-icon"><i class="ri-file-info-fill"></i><p class="name">file-info-fill</p></li><li class="class-icon"><i class="ri-file-info-line"></i><p class="name">file-info-line</p></li><li class="class-icon"><i class="ri-file-line"></i><p class="name">file-line</p></li><li class="class-icon"><i class="ri-file-list-2-fill"></i><p class="name">file-list-2-fill</p></li><li class="class-icon"><i class="ri-file-list-2-line"></i><p class="name">file-list-2-line</p></li><li class="class-icon"><i class="ri-file-list-3-fill"></i><p class="name">file-list-3-fill</p></li><li class="class-icon"><i class="ri-file-list-3-line"></i><p class="name">file-list-3-line</p></li><li class="class-icon"><i class="ri-file-list-fill"></i><p class="name">file-list-fill</p></li><li class="class-icon"><i class="ri-file-list-line"></i><p class="name">file-list-line</p></li><li class="class-icon"><i class="ri-file-lock-fill"></i><p class="name">file-lock-fill</p></li><li class="class-icon"><i class="ri-file-lock-line"></i><p class="name">file-lock-line</p></li><li class="class-icon"><i class="ri-file-mark-fill"></i><p class="name">file-mark-fill</p></li><li class="class-icon"><i class="ri-file-mark-line"></i><p class="name">file-mark-line</p></li><li class="class-icon"><i class="ri-file-music-fill"></i><p class="name">file-music-fill</p></li><li class="class-icon"><i class="ri-file-music-line"></i><p class="name">file-music-line</p></li><li class="class-icon"><i class="ri-file-paper-2-fill"></i><p class="name">file-paper-2-fill</p></li><li class="class-icon"><i class="ri-file-paper-2-line"></i><p class="name">file-paper-2-line</p></li><li class="class-icon"><i class="ri-file-paper-fill"></i><p class="name">file-paper-fill</p></li><li class="class-icon"><i class="ri-file-paper-line"></i><p class="name">file-paper-line</p></li><li class="class-icon"><i class="ri-file-pdf-fill"></i><p class="name">file-pdf-fill</p></li><li class="class-icon"><i class="ri-file-pdf-line"></i><p class="name">file-pdf-line</p></li><li class="class-icon"><i class="ri-file-ppt-2-fill"></i><p class="name">file-ppt-2-fill</p></li><li class="class-icon"><i class="ri-file-ppt-2-line"></i><p class="name">file-ppt-2-line</p></li><li class="class-icon"><i class="ri-file-ppt-fill"></i><p class="name">file-ppt-fill</p></li><li class="class-icon"><i class="ri-file-ppt-line"></i><p class="name">file-ppt-line</p></li><li class="class-icon"><i class="ri-file-reduce-fill"></i><p class="name">file-reduce-fill</p></li><li class="class-icon"><i class="ri-file-reduce-line"></i><p class="name">file-reduce-line</p></li><li class="class-icon"><i class="ri-file-search-fill"></i><p class="name">file-search-fill</p></li><li class="class-icon"><i class="ri-file-search-line"></i><p class="name">file-search-line</p></li><li class="class-icon"><i class="ri-file-settings-fill"></i><p class="name">file-settings-fill</p></li><li class="class-icon"><i class="ri-file-settings-line"></i><p class="name">file-settings-line</p></li><li class="class-icon"><i class="ri-file-shield-2-fill"></i><p class="name">file-shield-2-fill</p></li><li class="class-icon"><i class="ri-file-shield-2-line"></i><p class="name">file-shield-2-line</p></li><li class="class-icon"><i class="ri-file-shield-fill"></i><p class="name">file-shield-fill</p></li><li class="class-icon"><i class="ri-file-shield-line"></i><p class="name">file-shield-line</p></li><li class="class-icon"><i class="ri-file-shred-fill"></i><p class="name">file-shred-fill</p></li><li class="class-icon"><i class="ri-file-shred-line"></i><p class="name">file-shred-line</p></li><li class="class-icon"><i class="ri-file-text-fill"></i><p class="name">file-text-fill</p></li><li class="class-icon"><i class="ri-file-text-line"></i><p class="name">file-text-line</p></li><li class="class-icon"><i class="ri-file-transfer-fill"></i><p class="name">file-transfer-fill</p></li><li class="class-icon"><i class="ri-file-transfer-line"></i><p class="name">file-transfer-line</p></li><li class="class-icon"><i class="ri-file-unknow-fill"></i><p class="name">file-unknow-fill</p></li><li class="class-icon"><i class="ri-file-unknow-line"></i><p class="name">file-unknow-line</p></li><li class="class-icon"><i class="ri-file-upload-fill"></i><p class="name">file-upload-fill</p></li><li class="class-icon"><i class="ri-file-upload-line"></i><p class="name">file-upload-line</p></li><li class="class-icon"><i class="ri-file-user-fill"></i><p class="name">file-user-fill</p></li><li class="class-icon"><i class="ri-file-user-line"></i><p class="name">file-user-line</p></li><li class="class-icon"><i class="ri-file-warning-fill"></i><p class="name">file-warning-fill</p></li><li class="class-icon"><i class="ri-file-warning-line"></i><p class="name">file-warning-line</p></li><li class="class-icon"><i class="ri-file-word-2-fill"></i><p class="name">file-word-2-fill</p></li><li class="class-icon"><i class="ri-file-word-2-line"></i><p class="name">file-word-2-line</p></li><li class="class-icon"><i class="ri-file-word-fill"></i><p class="name">file-word-fill</p></li><li class="class-icon"><i class="ri-file-word-line"></i><p class="name">file-word-line</p></li><li class="class-icon"><i class="ri-file-zip-fill"></i><p class="name">file-zip-fill</p></li><li class="class-icon"><i class="ri-file-zip-line"></i><p class="name">file-zip-line</p></li><li class="class-icon"><i class="ri-film-fill"></i><p class="name">film-fill</p></li><li class="class-icon"><i class="ri-film-line"></i><p class="name">film-line</p></li><li class="class-icon"><i class="ri-filter-2-fill"></i><p class="name">filter-2-fill</p></li><li class="class-icon"><i class="ri-filter-2-line"></i><p class="name">filter-2-line</p></li><li class="class-icon"><i class="ri-filter-3-fill"></i><p class="name">filter-3-fill</p></li><li class="class-icon"><i class="ri-filter-3-line"></i><p class="name">filter-3-line</p></li><li class="class-icon"><i class="ri-filter-fill"></i><p class="name">filter-fill</p></li><li class="class-icon"><i class="ri-filter-line"></i><p class="name">filter-line</p></li><li class="class-icon"><i class="ri-filter-off-fill"></i><p class="name">filter-off-fill</p></li><li class="class-icon"><i class="ri-filter-off-line"></i><p class="name">filter-off-line</p></li><li class="class-icon"><i class="ri-find-replace-fill"></i><p class="name">find-replace-fill</p></li><li class="class-icon"><i class="ri-find-replace-line"></i><p class="name">find-replace-line</p></li><li class="class-icon"><i class="ri-finder-fill"></i><p class="name">finder-fill</p></li><li class="class-icon"><i class="ri-finder-line"></i><p class="name">finder-line</p></li><li class="class-icon"><i class="ri-fingerprint-2-fill"></i><p class="name">fingerprint-2-fill</p></li><li class="class-icon"><i class="ri-fingerprint-2-line"></i><p class="name">fingerprint-2-line</p></li><li class="class-icon"><i class="ri-fingerprint-fill"></i><p class="name">fingerprint-fill</p></li><li class="class-icon"><i class="ri-fingerprint-line"></i><p class="name">fingerprint-line</p></li><li class="class-icon"><i class="ri-fire-fill"></i><p class="name">fire-fill</p></li><li class="class-icon"><i class="ri-fire-line"></i><p class="name">fire-line</p></li><li class="class-icon"><i class="ri-firefox-fill"></i><p class="name">firefox-fill</p></li><li class="class-icon"><i class="ri-firefox-line"></i><p class="name">firefox-line</p></li><li class="class-icon"><i class="ri-first-aid-kit-fill"></i><p class="name">first-aid-kit-fill</p></li><li class="class-icon"><i class="ri-first-aid-kit-line"></i><p class="name">first-aid-kit-line</p></li><li class="class-icon"><i class="ri-flag-2-fill"></i><p class="name">flag-2-fill</p></li><li class="class-icon"><i class="ri-flag-2-line"></i><p class="name">flag-2-line</p></li><li class="class-icon"><i class="ri-flag-fill"></i><p class="name">flag-fill</p></li><li class="class-icon"><i class="ri-flag-line"></i><p class="name">flag-line</p></li><li class="class-icon"><i class="ri-flashlight-fill"></i><p class="name">flashlight-fill</p></li><li class="class-icon"><i class="ri-flashlight-line"></i><p class="name">flashlight-line</p></li><li class="class-icon"><i class="ri-flask-fill"></i><p class="name">flask-fill</p></li><li class="class-icon"><i class="ri-flask-line"></i><p class="name">flask-line</p></li><li class="class-icon"><i class="ri-flight-land-fill"></i><p class="name">flight-land-fill</p></li><li class="class-icon"><i class="ri-flight-land-line"></i><p class="name">flight-land-line</p></li><li class="class-icon"><i class="ri-flight-takeoff-fill"></i><p class="name">flight-takeoff-fill</p></li><li class="class-icon"><i class="ri-flight-takeoff-line"></i><p class="name">flight-takeoff-line</p></li><li class="class-icon"><i class="ri-flood-fill"></i><p class="name">flood-fill</p></li><li class="class-icon"><i class="ri-flood-line"></i><p class="name">flood-line</p></li><li class="class-icon"><i class="ri-flow-chart"></i><p class="name">flow-chart</p></li><li class="class-icon"><i class="ri-flutter-fill"></i><p class="name">flutter-fill</p></li><li class="class-icon"><i class="ri-flutter-line"></i><p class="name">flutter-line</p></li><li class="class-icon"><i class="ri-focus-2-fill"></i><p class="name">focus-2-fill</p></li><li class="class-icon"><i class="ri-focus-2-line"></i><p class="name">focus-2-line</p></li><li class="class-icon"><i class="ri-focus-3-fill"></i><p class="name">focus-3-fill</p></li><li class="class-icon"><i class="ri-focus-3-line"></i><p class="name">focus-3-line</p></li><li class="class-icon"><i class="ri-focus-fill"></i><p class="name">focus-fill</p></li><li class="class-icon"><i class="ri-focus-line"></i><p class="name">focus-line</p></li><li class="class-icon"><i class="ri-foggy-fill"></i><p class="name">foggy-fill</p></li><li class="class-icon"><i class="ri-foggy-line"></i><p class="name">foggy-line</p></li><li class="class-icon"><i class="ri-folder-2-fill"></i><p class="name">folder-2-fill</p></li><li class="class-icon"><i class="ri-folder-2-line"></i><p class="name">folder-2-line</p></li><li class="class-icon"><i class="ri-folder-3-fill"></i><p class="name">folder-3-fill</p></li><li class="class-icon"><i class="ri-folder-3-line"></i><p class="name">folder-3-line</p></li><li class="class-icon"><i class="ri-folder-4-fill"></i><p class="name">folder-4-fill</p></li><li class="class-icon"><i class="ri-folder-4-line"></i><p class="name">folder-4-line</p></li><li class="class-icon"><i class="ri-folder-5-fill"></i><p class="name">folder-5-fill</p></li><li class="class-icon"><i class="ri-folder-5-line"></i><p class="name">folder-5-line</p></li><li class="class-icon"><i class="ri-folder-add-fill"></i><p class="name">folder-add-fill</p></li><li class="class-icon"><i class="ri-folder-add-line"></i><p class="name">folder-add-line</p></li><li class="class-icon"><i class="ri-folder-chart-2-fill"></i><p class="name">folder-chart-2-fill</p></li><li class="class-icon"><i class="ri-folder-chart-2-line"></i><p class="name">folder-chart-2-line</p></li><li class="class-icon"><i class="ri-folder-chart-fill"></i><p class="name">folder-chart-fill</p></li><li class="class-icon"><i class="ri-folder-chart-line"></i><p class="name">folder-chart-line</p></li><li class="class-icon"><i class="ri-folder-download-fill"></i><p class="name">folder-download-fill</p></li><li class="class-icon"><i class="ri-folder-download-line"></i><p class="name">folder-download-line</p></li><li class="class-icon"><i class="ri-folder-fill"></i><p class="name">folder-fill</p></li><li class="class-icon"><i class="ri-folder-forbid-fill"></i><p class="name">folder-forbid-fill</p></li><li class="class-icon"><i class="ri-folder-forbid-line"></i><p class="name">folder-forbid-line</p></li><li class="class-icon"><i class="ri-folder-history-fill"></i><p class="name">folder-history-fill</p></li><li class="class-icon"><i class="ri-folder-history-line"></i><p class="name">folder-history-line</p></li><li class="class-icon"><i class="ri-folder-info-fill"></i><p class="name">folder-info-fill</p></li><li class="class-icon"><i class="ri-folder-info-line"></i><p class="name">folder-info-line</p></li><li class="class-icon"><i class="ri-folder-keyhole-fill"></i><p class="name">folder-keyhole-fill</p></li><li class="class-icon"><i class="ri-folder-keyhole-line"></i><p class="name">folder-keyhole-line</p></li><li class="class-icon"><i class="ri-folder-line"></i><p class="name">folder-line</p></li><li class="class-icon"><i class="ri-folder-lock-fill"></i><p class="name">folder-lock-fill</p></li><li class="class-icon"><i class="ri-folder-lock-line"></i><p class="name">folder-lock-line</p></li><li class="class-icon"><i class="ri-folder-music-fill"></i><p class="name">folder-music-fill</p></li><li class="class-icon"><i class="ri-folder-music-line"></i><p class="name">folder-music-line</p></li><li class="class-icon"><i class="ri-folder-open-fill"></i><p class="name">folder-open-fill</p></li><li class="class-icon"><i class="ri-folder-open-line"></i><p class="name">folder-open-line</p></li><li class="class-icon"><i class="ri-folder-received-fill"></i><p class="name">folder-received-fill</p></li><li class="class-icon"><i class="ri-folder-received-line"></i><p class="name">folder-received-line</p></li><li class="class-icon"><i class="ri-folder-reduce-fill"></i><p class="name">folder-reduce-fill</p></li><li class="class-icon"><i class="ri-folder-reduce-line"></i><p class="name">folder-reduce-line</p></li><li class="class-icon"><i class="ri-folder-settings-fill"></i><p class="name">folder-settings-fill</p></li><li class="class-icon"><i class="ri-folder-settings-line"></i><p class="name">folder-settings-line</p></li><li class="class-icon"><i class="ri-folder-shared-fill"></i><p class="name">folder-shared-fill</p></li><li class="class-icon"><i class="ri-folder-shared-line"></i><p class="name">folder-shared-line</p></li><li class="class-icon"><i class="ri-folder-shield-2-fill"></i><p class="name">folder-shield-2-fill</p></li><li class="class-icon"><i class="ri-folder-shield-2-line"></i><p class="name">folder-shield-2-line</p></li><li class="class-icon"><i class="ri-folder-shield-fill"></i><p class="name">folder-shield-fill</p></li><li class="class-icon"><i class="ri-folder-shield-line"></i><p class="name">folder-shield-line</p></li><li class="class-icon"><i class="ri-folder-transfer-fill"></i><p class="name">folder-transfer-fill</p></li><li class="class-icon"><i class="ri-folder-transfer-line"></i><p class="name">folder-transfer-line</p></li><li class="class-icon"><i class="ri-folder-unknow-fill"></i><p class="name">folder-unknow-fill</p></li><li class="class-icon"><i class="ri-folder-unknow-line"></i><p class="name">folder-unknow-line</p></li><li class="class-icon"><i class="ri-folder-upload-fill"></i><p class="name">folder-upload-fill</p></li><li class="class-icon"><i class="ri-folder-upload-line"></i><p class="name">folder-upload-line</p></li><li class="class-icon"><i class="ri-folder-user-fill"></i><p class="name">folder-user-fill</p></li><li class="class-icon"><i class="ri-folder-user-line"></i><p class="name">folder-user-line</p></li><li class="class-icon"><i class="ri-folder-warning-fill"></i><p class="name">folder-warning-fill</p></li><li class="class-icon"><i class="ri-folder-warning-line"></i><p class="name">folder-warning-line</p></li><li class="class-icon"><i class="ri-folder-zip-fill"></i><p class="name">folder-zip-fill</p></li><li class="class-icon"><i class="ri-folder-zip-line"></i><p class="name">folder-zip-line</p></li><li class="class-icon"><i class="ri-folders-fill"></i><p class="name">folders-fill</p></li><li class="class-icon"><i class="ri-folders-line"></i><p class="name">folders-line</p></li><li class="class-icon"><i class="ri-font-color"></i><p class="name">font-color</p></li><li class="class-icon"><i class="ri-font-size-2"></i><p class="name">font-size-2</p></li><li class="class-icon"><i class="ri-font-size"></i><p class="name">font-size</p></li><li class="class-icon"><i class="ri-football-fill"></i><p class="name">football-fill</p></li><li class="class-icon"><i class="ri-football-line"></i><p class="name">football-line</p></li><li class="class-icon"><i class="ri-footprint-fill"></i><p class="name">footprint-fill</p></li><li class="class-icon"><i class="ri-footprint-line"></i><p class="name">footprint-line</p></li><li class="class-icon"><i class="ri-forbid-2-fill"></i><p class="name">forbid-2-fill</p></li><li class="class-icon"><i class="ri-forbid-2-line"></i><p class="name">forbid-2-line</p></li><li class="class-icon"><i class="ri-forbid-fill"></i><p class="name">forbid-fill</p></li><li class="class-icon"><i class="ri-forbid-line"></i><p class="name">forbid-line</p></li><li class="class-icon"><i class="ri-format-clear"></i><p class="name">format-clear</p></li><li class="class-icon"><i class="ri-fridge-fill"></i><p class="name">fridge-fill</p></li><li class="class-icon"><i class="ri-fridge-line"></i><p class="name">fridge-line</p></li><li class="class-icon"><i class="ri-fullscreen-exit-fill"></i><p class="name">fullscreen-exit-fill</p></li><li class="class-icon"><i class="ri-fullscreen-exit-line"></i><p class="name">fullscreen-exit-line</p></li><li class="class-icon"><i class="ri-fullscreen-fill"></i><p class="name">fullscreen-fill</p></li><li class="class-icon"><i class="ri-fullscreen-line"></i><p class="name">fullscreen-line</p></li><li class="class-icon"><i class="ri-function-fill"></i><p class="name">function-fill</p></li><li class="class-icon"><i class="ri-function-line"></i><p class="name">function-line</p></li><li class="class-icon"><i class="ri-functions"></i><p class="name">functions</p></li><li class="class-icon"><i class="ri-funds-box-fill"></i><p class="name">funds-box-fill</p></li><li class="class-icon"><i class="ri-funds-box-line"></i><p class="name">funds-box-line</p></li><li class="class-icon"><i class="ri-funds-fill"></i><p class="name">funds-fill</p></li><li class="class-icon"><i class="ri-funds-line"></i><p class="name">funds-line</p></li><li class="class-icon"><i class="ri-gallery-fill"></i><p class="name">gallery-fill</p></li><li class="class-icon"><i class="ri-gallery-line"></i><p class="name">gallery-line</p></li><li class="class-icon"><i class="ri-gallery-upload-fill"></i><p class="name">gallery-upload-fill</p></li><li class="class-icon"><i class="ri-gallery-upload-line"></i><p class="name">gallery-upload-line</p></li><li class="class-icon"><i class="ri-game-fill"></i><p class="name">game-fill</p></li><li class="class-icon"><i class="ri-game-line"></i><p class="name">game-line</p></li><li class="class-icon"><i class="ri-gamepad-fill"></i><p class="name">gamepad-fill</p></li><li class="class-icon"><i class="ri-gamepad-line"></i><p class="name">gamepad-line</p></li><li class="class-icon"><i class="ri-gas-station-fill"></i><p class="name">gas-station-fill</p></li><li class="class-icon"><i class="ri-gas-station-line"></i><p class="name">gas-station-line</p></li><li class="class-icon"><i class="ri-gatsby-fill"></i><p class="name">gatsby-fill</p></li><li class="class-icon"><i class="ri-gatsby-line"></i><p class="name">gatsby-line</p></li><li class="class-icon"><i class="ri-genderless-fill"></i><p class="name">genderless-fill</p></li><li class="class-icon"><i class="ri-genderless-line"></i><p class="name">genderless-line</p></li><li class="class-icon"><i class="ri-ghost-2-fill"></i><p class="name">ghost-2-fill</p></li><li class="class-icon"><i class="ri-ghost-2-line"></i><p class="name">ghost-2-line</p></li><li class="class-icon"><i class="ri-ghost-fill"></i><p class="name">ghost-fill</p></li><li class="class-icon"><i class="ri-ghost-line"></i><p class="name">ghost-line</p></li><li class="class-icon"><i class="ri-ghost-smile-fill"></i><p class="name">ghost-smile-fill</p></li><li class="class-icon"><i class="ri-ghost-smile-line"></i><p class="name">ghost-smile-line</p></li><li class="class-icon"><i class="ri-gift-2-fill"></i><p class="name">gift-2-fill</p></li><li class="class-icon"><i class="ri-gift-2-line"></i><p class="name">gift-2-line</p></li><li class="class-icon"><i class="ri-gift-fill"></i><p class="name">gift-fill</p></li><li class="class-icon"><i class="ri-gift-line"></i><p class="name">gift-line</p></li><li class="class-icon"><i class="ri-git-branch-fill"></i><p class="name">git-branch-fill</p></li><li class="class-icon"><i class="ri-git-branch-line"></i><p class="name">git-branch-line</p></li><li class="class-icon"><i class="ri-git-commit-fill"></i><p class="name">git-commit-fill</p></li><li class="class-icon"><i class="ri-git-commit-line"></i><p class="name">git-commit-line</p></li><li class="class-icon"><i class="ri-git-merge-fill"></i><p class="name">git-merge-fill</p></li><li class="class-icon"><i class="ri-git-merge-line"></i><p class="name">git-merge-line</p></li><li class="class-icon"><i class="ri-git-pull-request-fill"></i><p class="name">git-pull-request-fill</p></li><li class="class-icon"><i class="ri-git-pull-request-line"></i><p class="name">git-pull-request-line</p></li><li class="class-icon"><i class="ri-git-repository-commits-fill"></i><p class="name">git-repository-commits-fill</p></li><li class="class-icon"><i class="ri-git-repository-commits-line"></i><p class="name">git-repository-commits-line</p></li><li class="class-icon"><i class="ri-git-repository-fill"></i><p class="name">git-repository-fill</p></li><li class="class-icon"><i class="ri-git-repository-line"></i><p class="name">git-repository-line</p></li><li class="class-icon"><i class="ri-git-repository-private-fill"></i><p class="name">git-repository-private-fill</p></li><li class="class-icon"><i class="ri-git-repository-private-line"></i><p class="name">git-repository-private-line</p></li><li class="class-icon"><i class="ri-github-fill"></i><p class="name">github-fill</p></li><li class="class-icon"><i class="ri-github-line"></i><p class="name">github-line</p></li><li class="class-icon"><i class="ri-gitlab-fill"></i><p class="name">gitlab-fill</p></li><li class="class-icon"><i class="ri-gitlab-line"></i><p class="name">gitlab-line</p></li><li class="class-icon"><i class="ri-global-fill"></i><p class="name">global-fill</p></li><li class="class-icon"><i class="ri-global-line"></i><p class="name">global-line</p></li><li class="class-icon"><i class="ri-globe-fill"></i><p class="name">globe-fill</p></li><li class="class-icon"><i class="ri-globe-line"></i><p class="name">globe-line</p></li><li class="class-icon"><i class="ri-goblet-fill"></i><p class="name">goblet-fill</p></li><li class="class-icon"><i class="ri-goblet-line"></i><p class="name">goblet-line</p></li><li class="class-icon"><i class="ri-google-fill"></i><p class="name">google-fill</p></li><li class="class-icon"><i class="ri-google-line"></i><p class="name">google-line</p></li><li class="class-icon"><i class="ri-google-play-fill"></i><p class="name">google-play-fill</p></li><li class="class-icon"><i class="ri-google-play-line"></i><p class="name">google-play-line</p></li><li class="class-icon"><i class="ri-government-fill"></i><p class="name">government-fill</p></li><li class="class-icon"><i class="ri-government-line"></i><p class="name">government-line</p></li><li class="class-icon"><i class="ri-gps-fill"></i><p class="name">gps-fill</p></li><li class="class-icon"><i class="ri-gps-line"></i><p class="name">gps-line</p></li><li class="class-icon"><i class="ri-gradienter-fill"></i><p class="name">gradienter-fill</p></li><li class="class-icon"><i class="ri-gradienter-line"></i><p class="name">gradienter-line</p></li><li class="class-icon"><i class="ri-grid-fill"></i><p class="name">grid-fill</p></li><li class="class-icon"><i class="ri-grid-line"></i><p class="name">grid-line</p></li><li class="class-icon"><i class="ri-group-2-fill"></i><p class="name">group-2-fill</p></li><li class="class-icon"><i class="ri-group-2-line"></i><p class="name">group-2-line</p></li><li class="class-icon"><i class="ri-group-fill"></i><p class="name">group-fill</p></li><li class="class-icon"><i class="ri-group-line"></i><p class="name">group-line</p></li><li class="class-icon"><i class="ri-guide-fill"></i><p class="name">guide-fill</p></li><li class="class-icon"><i class="ri-guide-line"></i><p class="name">guide-line</p></li><li class="class-icon"><i class="ri-h-1"></i><p class="name">h-1</p></li><li class="class-icon"><i class="ri-h-2"></i><p class="name">h-2</p></li><li class="class-icon"><i class="ri-h-3"></i><p class="name">h-3</p></li><li class="class-icon"><i class="ri-h-4"></i><p class="name">h-4</p></li><li class="class-icon"><i class="ri-h-5"></i><p class="name">h-5</p></li><li class="class-icon"><i class="ri-h-6"></i><p class="name">h-6</p></li><li class="class-icon"><i class="ri-hail-fill"></i><p class="name">hail-fill</p></li><li class="class-icon"><i class="ri-hail-line"></i><p class="name">hail-line</p></li><li class="class-icon"><i class="ri-hammer-fill"></i><p class="name">hammer-fill</p></li><li class="class-icon"><i class="ri-hammer-line"></i><p class="name">hammer-line</p></li><li class="class-icon"><i class="ri-hand-coin-fill"></i><p class="name">hand-coin-fill</p></li><li class="class-icon"><i class="ri-hand-coin-line"></i><p class="name">hand-coin-line</p></li><li class="class-icon"><i class="ri-hand-heart-fill"></i><p class="name">hand-heart-fill</p></li><li class="class-icon"><i class="ri-hand-heart-line"></i><p class="name">hand-heart-line</p></li><li class="class-icon"><i class="ri-hand-sanitizer-fill"></i><p class="name">hand-sanitizer-fill</p></li><li class="class-icon"><i class="ri-hand-sanitizer-line"></i><p class="name">hand-sanitizer-line</p></li><li class="class-icon"><i class="ri-handbag-fill"></i><p class="name">handbag-fill</p></li><li class="class-icon"><i class="ri-handbag-line"></i><p class="name">handbag-line</p></li><li class="class-icon"><i class="ri-hard-drive-2-fill"></i><p class="name">hard-drive-2-fill</p></li><li class="class-icon"><i class="ri-hard-drive-2-line"></i><p class="name">hard-drive-2-line</p></li><li class="class-icon"><i class="ri-hard-drive-fill"></i><p class="name">hard-drive-fill</p></li><li class="class-icon"><i class="ri-hard-drive-line"></i><p class="name">hard-drive-line</p></li><li class="class-icon"><i class="ri-hashtag"></i><p class="name">hashtag</p></li><li class="class-icon"><i class="ri-haze-2-fill"></i><p class="name">haze-2-fill</p></li><li class="class-icon"><i class="ri-haze-2-line"></i><p class="name">haze-2-line</p></li><li class="class-icon"><i class="ri-haze-fill"></i><p class="name">haze-fill</p></li><li class="class-icon"><i class="ri-haze-line"></i><p class="name">haze-line</p></li><li class="class-icon"><i class="ri-hd-fill"></i><p class="name">hd-fill</p></li><li class="class-icon"><i class="ri-hd-line"></i><p class="name">hd-line</p></li><li class="class-icon"><i class="ri-heading"></i><p class="name">heading</p></li><li class="class-icon"><i class="ri-headphone-fill"></i><p class="name">headphone-fill</p></li><li class="class-icon"><i class="ri-headphone-line"></i><p class="name">headphone-line</p></li><li class="class-icon"><i class="ri-health-book-fill"></i><p class="name">health-book-fill</p></li><li class="class-icon"><i class="ri-health-book-line"></i><p class="name">health-book-line</p></li><li class="class-icon"><i class="ri-heart-2-fill"></i><p class="name">heart-2-fill</p></li><li class="class-icon"><i class="ri-heart-2-line"></i><p class="name">heart-2-line</p></li><li class="class-icon"><i class="ri-heart-3-fill"></i><p class="name">heart-3-fill</p></li><li class="class-icon"><i class="ri-heart-3-line"></i><p class="name">heart-3-line</p></li><li class="class-icon"><i class="ri-heart-add-fill"></i><p class="name">heart-add-fill</p></li><li class="class-icon"><i class="ri-heart-add-line"></i><p class="name">heart-add-line</p></li><li class="class-icon"><i class="ri-heart-fill"></i><p class="name">heart-fill</p></li><li class="class-icon"><i class="ri-heart-line"></i><p class="name">heart-line</p></li><li class="class-icon"><i class="ri-heart-pulse-fill"></i><p class="name">heart-pulse-fill</p></li><li class="class-icon"><i class="ri-heart-pulse-line"></i><p class="name">heart-pulse-line</p></li><li class="class-icon"><i class="ri-hearts-fill"></i><p class="name">hearts-fill</p></li><li class="class-icon"><i class="ri-hearts-line"></i><p class="name">hearts-line</p></li><li class="class-icon"><i class="ri-heavy-showers-fill"></i><p class="name">heavy-showers-fill</p></li><li class="class-icon"><i class="ri-heavy-showers-line"></i><p class="name">heavy-showers-line</p></li><li class="class-icon"><i class="ri-history-fill"></i><p class="name">history-fill</p></li><li class="class-icon"><i class="ri-history-line"></i><p class="name">history-line</p></li><li class="class-icon"><i class="ri-home-2-fill"></i><p class="name">home-2-fill</p></li><li class="class-icon"><i class="ri-home-2-line"></i><p class="name">home-2-line</p></li><li class="class-icon"><i class="ri-home-3-fill"></i><p class="name">home-3-fill</p></li><li class="class-icon"><i class="ri-home-3-line"></i><p class="name">home-3-line</p></li><li class="class-icon"><i class="ri-home-4-fill"></i><p class="name">home-4-fill</p></li><li class="class-icon"><i class="ri-home-4-line"></i><p class="name">home-4-line</p></li><li class="class-icon"><i class="ri-home-5-fill"></i><p class="name">home-5-fill</p></li><li class="class-icon"><i class="ri-home-5-line"></i><p class="name">home-5-line</p></li><li class="class-icon"><i class="ri-home-6-fill"></i><p class="name">home-6-fill</p></li><li class="class-icon"><i class="ri-home-6-line"></i><p class="name">home-6-line</p></li><li class="class-icon"><i class="ri-home-7-fill"></i><p class="name">home-7-fill</p></li><li class="class-icon"><i class="ri-home-7-line"></i><p class="name">home-7-line</p></li><li class="class-icon"><i class="ri-home-8-fill"></i><p class="name">home-8-fill</p></li><li class="class-icon"><i class="ri-home-8-line"></i><p class="name">home-8-line</p></li><li class="class-icon"><i class="ri-home-fill"></i><p class="name">home-fill</p></li><li class="class-icon"><i class="ri-home-gear-fill"></i><p class="name">home-gear-fill</p></li><li class="class-icon"><i class="ri-home-gear-line"></i><p class="name">home-gear-line</p></li><li class="class-icon"><i class="ri-home-heart-fill"></i><p class="name">home-heart-fill</p></li><li class="class-icon"><i class="ri-home-heart-line"></i><p class="name">home-heart-line</p></li><li class="class-icon"><i class="ri-home-line"></i><p class="name">home-line</p></li><li class="class-icon"><i class="ri-home-smile-2-fill"></i><p class="name">home-smile-2-fill</p></li><li class="class-icon"><i class="ri-home-smile-2-line"></i><p class="name">home-smile-2-line</p></li><li class="class-icon"><i class="ri-home-smile-fill"></i><p class="name">home-smile-fill</p></li><li class="class-icon"><i class="ri-home-smile-line"></i><p class="name">home-smile-line</p></li><li class="class-icon"><i class="ri-home-wifi-fill"></i><p class="name">home-wifi-fill</p></li><li class="class-icon"><i class="ri-home-wifi-line"></i><p class="name">home-wifi-line</p></li><li class="class-icon"><i class="ri-honor-of-kings-fill"></i><p class="name">honor-of-kings-fill</p></li><li class="class-icon"><i class="ri-honor-of-kings-line"></i><p class="name">honor-of-kings-line</p></li><li class="class-icon"><i class="ri-honour-fill"></i><p class="name">honour-fill</p></li><li class="class-icon"><i class="ri-honour-line"></i><p class="name">honour-line</p></li><li class="class-icon"><i class="ri-hospital-fill"></i><p class="name">hospital-fill</p></li><li class="class-icon"><i class="ri-hospital-line"></i><p class="name">hospital-line</p></li><li class="class-icon"><i class="ri-hotel-bed-fill"></i><p class="name">hotel-bed-fill</p></li><li class="class-icon"><i class="ri-hotel-bed-line"></i><p class="name">hotel-bed-line</p></li><li class="class-icon"><i class="ri-hotel-fill"></i><p class="name">hotel-fill</p></li><li class="class-icon"><i class="ri-hotel-line"></i><p class="name">hotel-line</p></li><li class="class-icon"><i class="ri-hotspot-fill"></i><p class="name">hotspot-fill</p></li><li class="class-icon"><i class="ri-hotspot-line"></i><p class="name">hotspot-line</p></li><li class="class-icon"><i class="ri-hq-fill"></i><p class="name">hq-fill</p></li><li class="class-icon"><i class="ri-hq-line"></i><p class="name">hq-line</p></li><li class="class-icon"><i class="ri-html5-fill"></i><p class="name">html5-fill</p></li><li class="class-icon"><i class="ri-html5-line"></i><p class="name">html5-line</p></li><li class="class-icon"><i class="ri-ie-fill"></i><p class="name">ie-fill</p></li><li class="class-icon"><i class="ri-ie-line"></i><p class="name">ie-line</p></li><li class="class-icon"><i class="ri-image-2-fill"></i><p class="name">image-2-fill</p></li><li class="class-icon"><i class="ri-image-2-line"></i><p class="name">image-2-line</p></li><li class="class-icon"><i class="ri-image-add-fill"></i><p class="name">image-add-fill</p></li><li class="class-icon"><i class="ri-image-add-line"></i><p class="name">image-add-line</p></li><li class="class-icon"><i class="ri-image-edit-fill"></i><p class="name">image-edit-fill</p></li><li class="class-icon"><i class="ri-image-edit-line"></i><p class="name">image-edit-line</p></li><li class="class-icon"><i class="ri-image-fill"></i><p class="name">image-fill</p></li><li class="class-icon"><i class="ri-image-line"></i><p class="name">image-line</p></li><li class="class-icon"><i class="ri-inbox-archive-fill"></i><p class="name">inbox-archive-fill</p></li><li class="class-icon"><i class="ri-inbox-archive-line"></i><p class="name">inbox-archive-line</p></li><li class="class-icon"><i class="ri-inbox-fill"></i><p class="name">inbox-fill</p></li><li class="class-icon"><i class="ri-inbox-line"></i><p class="name">inbox-line</p></li><li class="class-icon"><i class="ri-inbox-unarchive-fill"></i><p class="name">inbox-unarchive-fill</p></li><li class="class-icon"><i class="ri-inbox-unarchive-line"></i><p class="name">inbox-unarchive-line</p></li><li class="class-icon"><i class="ri-increase-decrease-fill"></i><p class="name">increase-decrease-fill</p></li><li class="class-icon"><i class="ri-increase-decrease-line"></i><p class="name">increase-decrease-line</p></li><li class="class-icon"><i class="ri-indent-decrease"></i><p class="name">indent-decrease</p></li><li class="class-icon"><i class="ri-indent-increase"></i><p class="name">indent-increase</p></li><li class="class-icon"><i class="ri-indeterminate-circle-fill"></i><p class="name">indeterminate-circle-fill</p></li><li class="class-icon"><i class="ri-indeterminate-circle-line"></i><p class="name">indeterminate-circle-line</p></li><li class="class-icon"><i class="ri-information-fill"></i><p class="name">information-fill</p></li><li class="class-icon"><i class="ri-information-line"></i><p class="name">information-line</p></li><li class="class-icon"><i class="ri-infrared-thermometer-fill"></i><p class="name">infrared-thermometer-fill</p></li><li class="class-icon"><i class="ri-infrared-thermometer-line"></i><p class="name">infrared-thermometer-line</p></li><li class="class-icon"><i class="ri-ink-bottle-fill"></i><p class="name">ink-bottle-fill</p></li><li class="class-icon"><i class="ri-ink-bottle-line"></i><p class="name">ink-bottle-line</p></li><li class="class-icon"><i class="ri-input-cursor-move"></i><p class="name">input-cursor-move</p></li><li class="class-icon"><i class="ri-input-method-fill"></i><p class="name">input-method-fill</p></li><li class="class-icon"><i class="ri-input-method-line"></i><p class="name">input-method-line</p></li><li class="class-icon"><i class="ri-insert-column-left"></i><p class="name">insert-column-left</p></li><li class="class-icon"><i class="ri-insert-column-right"></i><p class="name">insert-column-right</p></li><li class="class-icon"><i class="ri-insert-row-bottom"></i><p class="name">insert-row-bottom</p></li><li class="class-icon"><i class="ri-insert-row-top"></i><p class="name">insert-row-top</p></li><li class="class-icon"><i class="ri-instagram-fill"></i><p class="name">instagram-fill</p></li><li class="class-icon"><i class="ri-instagram-line"></i><p class="name">instagram-line</p></li><li class="class-icon"><i class="ri-install-fill"></i><p class="name">install-fill</p></li><li class="class-icon"><i class="ri-install-line"></i><p class="name">install-line</p></li><li class="class-icon"><i class="ri-invision-fill"></i><p class="name">invision-fill</p></li><li class="class-icon"><i class="ri-invision-line"></i><p class="name">invision-line</p></li><li class="class-icon"><i class="ri-italic"></i><p class="name">italic</p></li><li class="class-icon"><i class="ri-kakao-talk-fill"></i><p class="name">kakao-talk-fill</p></li><li class="class-icon"><i class="ri-kakao-talk-line"></i><p class="name">kakao-talk-line</p></li><li class="class-icon"><i class="ri-key-2-fill"></i><p class="name">key-2-fill</p></li><li class="class-icon"><i class="ri-key-2-line"></i><p class="name">key-2-line</p></li><li class="class-icon"><i class="ri-key-fill"></i><p class="name">key-fill</p></li><li class="class-icon"><i class="ri-key-line"></i><p class="name">key-line</p></li><li class="class-icon"><i class="ri-keyboard-box-fill"></i><p class="name">keyboard-box-fill</p></li><li class="class-icon"><i class="ri-keyboard-box-line"></i><p class="name">keyboard-box-line</p></li><li class="class-icon"><i class="ri-keyboard-fill"></i><p class="name">keyboard-fill</p></li><li class="class-icon"><i class="ri-keyboard-line"></i><p class="name">keyboard-line</p></li><li class="class-icon"><i class="ri-keynote-fill"></i><p class="name">keynote-fill</p></li><li class="class-icon"><i class="ri-keynote-line"></i><p class="name">keynote-line</p></li><li class="class-icon"><i class="ri-knife-blood-fill"></i><p class="name">knife-blood-fill</p></li><li class="class-icon"><i class="ri-knife-blood-line"></i><p class="name">knife-blood-line</p></li><li class="class-icon"><i class="ri-knife-fill"></i><p class="name">knife-fill</p></li><li class="class-icon"><i class="ri-knife-line"></i><p class="name">knife-line</p></li><li class="class-icon"><i class="ri-landscape-fill"></i><p class="name">landscape-fill</p></li><li class="class-icon"><i class="ri-landscape-line"></i><p class="name">landscape-line</p></li><li class="class-icon"><i class="ri-layout-2-fill"></i><p class="name">layout-2-fill</p></li><li class="class-icon"><i class="ri-layout-2-line"></i><p class="name">layout-2-line</p></li><li class="class-icon"><i class="ri-layout-3-fill"></i><p class="name">layout-3-fill</p></li><li class="class-icon"><i class="ri-layout-3-line"></i><p class="name">layout-3-line</p></li><li class="class-icon"><i class="ri-layout-4-fill"></i><p class="name">layout-4-fill</p></li><li class="class-icon"><i class="ri-layout-4-line"></i><p class="name">layout-4-line</p></li><li class="class-icon"><i class="ri-layout-5-fill"></i><p class="name">layout-5-fill</p></li><li class="class-icon"><i class="ri-layout-5-line"></i><p class="name">layout-5-line</p></li><li class="class-icon"><i class="ri-layout-6-fill"></i><p class="name">layout-6-fill</p></li><li class="class-icon"><i class="ri-layout-6-line"></i><p class="name">layout-6-line</p></li><li class="class-icon"><i class="ri-layout-bottom-2-fill"></i><p class="name">layout-bottom-2-fill</p></li><li class="class-icon"><i class="ri-layout-bottom-2-line"></i><p class="name">layout-bottom-2-line</p></li><li class="class-icon"><i class="ri-layout-bottom-fill"></i><p class="name">layout-bottom-fill</p></li><li class="class-icon"><i class="ri-layout-bottom-line"></i><p class="name">layout-bottom-line</p></li><li class="class-icon"><i class="ri-layout-column-fill"></i><p class="name">layout-column-fill</p></li><li class="class-icon"><i class="ri-layout-column-line"></i><p class="name">layout-column-line</p></li><li class="class-icon"><i class="ri-layout-fill"></i><p class="name">layout-fill</p></li><li class="class-icon"><i class="ri-layout-grid-fill"></i><p class="name">layout-grid-fill</p></li><li class="class-icon"><i class="ri-layout-grid-line"></i><p class="name">layout-grid-line</p></li><li class="class-icon"><i class="ri-layout-left-2-fill"></i><p class="name">layout-left-2-fill</p></li><li class="class-icon"><i class="ri-layout-left-2-line"></i><p class="name">layout-left-2-line</p></li><li class="class-icon"><i class="ri-layout-left-fill"></i><p class="name">layout-left-fill</p></li><li class="class-icon"><i class="ri-layout-left-line"></i><p class="name">layout-left-line</p></li><li class="class-icon"><i class="ri-layout-line"></i><p class="name">layout-line</p></li><li class="class-icon"><i class="ri-layout-masonry-fill"></i><p class="name">layout-masonry-fill</p></li><li class="class-icon"><i class="ri-layout-masonry-line"></i><p class="name">layout-masonry-line</p></li><li class="class-icon"><i class="ri-layout-right-2-fill"></i><p class="name">layout-right-2-fill</p></li><li class="class-icon"><i class="ri-layout-right-2-line"></i><p class="name">layout-right-2-line</p></li><li class="class-icon"><i class="ri-layout-right-fill"></i><p class="name">layout-right-fill</p></li><li class="class-icon"><i class="ri-layout-right-line"></i><p class="name">layout-right-line</p></li><li class="class-icon"><i class="ri-layout-row-fill"></i><p class="name">layout-row-fill</p></li><li class="class-icon"><i class="ri-layout-row-line"></i><p class="name">layout-row-line</p></li><li class="class-icon"><i class="ri-layout-top-2-fill"></i><p class="name">layout-top-2-fill</p></li><li class="class-icon"><i class="ri-layout-top-2-line"></i><p class="name">layout-top-2-line</p></li><li class="class-icon"><i class="ri-layout-top-fill"></i><p class="name">layout-top-fill</p></li><li class="class-icon"><i class="ri-layout-top-line"></i><p class="name">layout-top-line</p></li><li class="class-icon"><i class="ri-leaf-fill"></i><p class="name">leaf-fill</p></li><li class="class-icon"><i class="ri-leaf-line"></i><p class="name">leaf-line</p></li><li class="class-icon"><i class="ri-lifebuoy-fill"></i><p class="name">lifebuoy-fill</p></li><li class="class-icon"><i class="ri-lifebuoy-line"></i><p class="name">lifebuoy-line</p></li><li class="class-icon"><i class="ri-lightbulb-fill"></i><p class="name">lightbulb-fill</p></li><li class="class-icon"><i class="ri-lightbulb-flash-fill"></i><p class="name">lightbulb-flash-fill</p></li><li class="class-icon"><i class="ri-lightbulb-flash-line"></i><p class="name">lightbulb-flash-line</p></li><li class="class-icon"><i class="ri-lightbulb-line"></i><p class="name">lightbulb-line</p></li><li class="class-icon"><i class="ri-line-chart-fill"></i><p class="name">line-chart-fill</p></li><li class="class-icon"><i class="ri-line-chart-line"></i><p class="name">line-chart-line</p></li><li class="class-icon"><i class="ri-line-fill"></i><p class="name">line-fill</p></li><li class="class-icon"><i class="ri-line-height"></i><p class="name">line-height</p></li><li class="class-icon"><i class="ri-line-line"></i><p class="name">line-line</p></li><li class="class-icon"><i class="ri-link-m"></i><p class="name">link-m</p></li><li class="class-icon"><i class="ri-link-unlink-m"></i><p class="name">link-unlink-m</p></li><li class="class-icon"><i class="ri-link-unlink"></i><p class="name">link-unlink</p></li><li class="class-icon"><i class="ri-link"></i><p class="name">link</p></li><li class="class-icon"><i class="ri-linkedin-box-fill"></i><p class="name">linkedin-box-fill</p></li><li class="class-icon"><i class="ri-linkedin-box-line"></i><p class="name">linkedin-box-line</p></li><li class="class-icon"><i class="ri-linkedin-fill"></i><p class="name">linkedin-fill</p></li><li class="class-icon"><i class="ri-linkedin-line"></i><p class="name">linkedin-line</p></li><li class="class-icon"><i class="ri-links-fill"></i><p class="name">links-fill</p></li><li class="class-icon"><i class="ri-links-line"></i><p class="name">links-line</p></li><li class="class-icon"><i class="ri-list-check-2"></i><p class="name">list-check-2</p></li><li class="class-icon"><i class="ri-list-check"></i><p class="name">list-check</p></li><li class="class-icon"><i class="ri-list-ordered"></i><p class="name">list-ordered</p></li><li class="class-icon"><i class="ri-list-settings-fill"></i><p class="name">list-settings-fill</p></li><li class="class-icon"><i class="ri-list-settings-line"></i><p class="name">list-settings-line</p></li><li class="class-icon"><i class="ri-list-unordered"></i><p class="name">list-unordered</p></li><li class="class-icon"><i class="ri-live-fill"></i><p class="name">live-fill</p></li><li class="class-icon"><i class="ri-live-line"></i><p class="name">live-line</p></li><li class="class-icon"><i class="ri-loader-2-fill"></i><p class="name">loader-2-fill</p></li><li class="class-icon"><i class="ri-loader-2-line"></i><p class="name">loader-2-line</p></li><li class="class-icon"><i class="ri-loader-3-fill"></i><p class="name">loader-3-fill</p></li><li class="class-icon"><i class="ri-loader-3-line"></i><p class="name">loader-3-line</p></li><li class="class-icon"><i class="ri-loader-4-fill"></i><p class="name">loader-4-fill</p></li><li class="class-icon"><i class="ri-loader-4-line"></i><p class="name">loader-4-line</p></li><li class="class-icon"><i class="ri-loader-5-fill"></i><p class="name">loader-5-fill</p></li><li class="class-icon"><i class="ri-loader-5-line"></i><p class="name">loader-5-line</p></li><li class="class-icon"><i class="ri-loader-fill"></i><p class="name">loader-fill</p></li><li class="class-icon"><i class="ri-loader-line"></i><p class="name">loader-line</p></li><li class="class-icon"><i class="ri-lock-2-fill"></i><p class="name">lock-2-fill</p></li><li class="class-icon"><i class="ri-lock-2-line"></i><p class="name">lock-2-line</p></li><li class="class-icon"><i class="ri-lock-fill"></i><p class="name">lock-fill</p></li><li class="class-icon"><i class="ri-lock-line"></i><p class="name">lock-line</p></li><li class="class-icon"><i class="ri-lock-password-fill"></i><p class="name">lock-password-fill</p></li><li class="class-icon"><i class="ri-lock-password-line"></i><p class="name">lock-password-line</p></li><li class="class-icon"><i class="ri-lock-unlock-fill"></i><p class="name">lock-unlock-fill</p></li><li class="class-icon"><i class="ri-lock-unlock-line"></i><p class="name">lock-unlock-line</p></li><li class="class-icon"><i class="ri-login-box-fill"></i><p class="name">login-box-fill</p></li><li class="class-icon"><i class="ri-login-box-line"></i><p class="name">login-box-line</p></li><li class="class-icon"><i class="ri-login-circle-fill"></i><p class="name">login-circle-fill</p></li><li class="class-icon"><i class="ri-login-circle-line"></i><p class="name">login-circle-line</p></li><li class="class-icon"><i class="ri-logout-box-fill"></i><p class="name">logout-box-fill</p></li><li class="class-icon"><i class="ri-logout-box-line"></i><p class="name">logout-box-line</p></li><li class="class-icon"><i class="ri-logout-box-r-fill"></i><p class="name">logout-box-r-fill</p></li><li class="class-icon"><i class="ri-logout-box-r-line"></i><p class="name">logout-box-r-line</p></li><li class="class-icon"><i class="ri-logout-circle-fill"></i><p class="name">logout-circle-fill</p></li><li class="class-icon"><i class="ri-logout-circle-line"></i><p class="name">logout-circle-line</p></li><li class="class-icon"><i class="ri-logout-circle-r-fill"></i><p class="name">logout-circle-r-fill</p></li><li class="class-icon"><i class="ri-logout-circle-r-line"></i><p class="name">logout-circle-r-line</p></li><li class="class-icon"><i class="ri-luggage-cart-fill"></i><p class="name">luggage-cart-fill</p></li><li class="class-icon"><i class="ri-luggage-cart-line"></i><p class="name">luggage-cart-line</p></li><li class="class-icon"><i class="ri-luggage-deposit-fill"></i><p class="name">luggage-deposit-fill</p></li><li class="class-icon"><i class="ri-luggage-deposit-line"></i><p class="name">luggage-deposit-line</p></li><li class="class-icon"><i class="ri-lungs-fill"></i><p class="name">lungs-fill</p></li><li class="class-icon"><i class="ri-lungs-line"></i><p class="name">lungs-line</p></li><li class="class-icon"><i class="ri-mac-fill"></i><p class="name">mac-fill</p></li><li class="class-icon"><i class="ri-mac-line"></i><p class="name">mac-line</p></li><li class="class-icon"><i class="ri-macbook-fill"></i><p class="name">macbook-fill</p></li><li class="class-icon"><i class="ri-macbook-line"></i><p class="name">macbook-line</p></li><li class="class-icon"><i class="ri-magic-fill"></i><p class="name">magic-fill</p></li><li class="class-icon"><i class="ri-magic-line"></i><p class="name">magic-line</p></li><li class="class-icon"><i class="ri-mail-add-fill"></i><p class="name">mail-add-fill</p></li><li class="class-icon"><i class="ri-mail-add-line"></i><p class="name">mail-add-line</p></li><li class="class-icon"><i class="ri-mail-check-fill"></i><p class="name">mail-check-fill</p></li><li class="class-icon"><i class="ri-mail-check-line"></i><p class="name">mail-check-line</p></li><li class="class-icon"><i class="ri-mail-close-fill"></i><p class="name">mail-close-fill</p></li><li class="class-icon"><i class="ri-mail-close-line"></i><p class="name">mail-close-line</p></li><li class="class-icon"><i class="ri-mail-download-fill"></i><p class="name">mail-download-fill</p></li><li class="class-icon"><i class="ri-mail-download-line"></i><p class="name">mail-download-line</p></li><li class="class-icon"><i class="ri-mail-fill"></i><p class="name">mail-fill</p></li><li class="class-icon"><i class="ri-mail-forbid-fill"></i><p class="name">mail-forbid-fill</p></li><li class="class-icon"><i class="ri-mail-forbid-line"></i><p class="name">mail-forbid-line</p></li><li class="class-icon"><i class="ri-mail-line"></i><p class="name">mail-line</p></li><li class="class-icon"><i class="ri-mail-lock-fill"></i><p class="name">mail-lock-fill</p></li><li class="class-icon"><i class="ri-mail-lock-line"></i><p class="name">mail-lock-line</p></li><li class="class-icon"><i class="ri-mail-open-fill"></i><p class="name">mail-open-fill</p></li><li class="class-icon"><i class="ri-mail-open-line"></i><p class="name">mail-open-line</p></li><li class="class-icon"><i class="ri-mail-send-fill"></i><p class="name">mail-send-fill</p></li><li class="class-icon"><i class="ri-mail-send-line"></i><p class="name">mail-send-line</p></li><li class="class-icon"><i class="ri-mail-settings-fill"></i><p class="name">mail-settings-fill</p></li><li class="class-icon"><i class="ri-mail-settings-line"></i><p class="name">mail-settings-line</p></li><li class="class-icon"><i class="ri-mail-star-fill"></i><p class="name">mail-star-fill</p></li><li class="class-icon"><i class="ri-mail-star-line"></i><p class="name">mail-star-line</p></li><li class="class-icon"><i class="ri-mail-unread-fill"></i><p class="name">mail-unread-fill</p></li><li class="class-icon"><i class="ri-mail-unread-line"></i><p class="name">mail-unread-line</p></li><li class="class-icon"><i class="ri-mail-volume-fill"></i><p class="name">mail-volume-fill</p></li><li class="class-icon"><i class="ri-mail-volume-line"></i><p class="name">mail-volume-line</p></li><li class="class-icon"><i class="ri-map-2-fill"></i><p class="name">map-2-fill</p></li><li class="class-icon"><i class="ri-map-2-line"></i><p class="name">map-2-line</p></li><li class="class-icon"><i class="ri-map-fill"></i><p class="name">map-fill</p></li><li class="class-icon"><i class="ri-map-line"></i><p class="name">map-line</p></li><li class="class-icon"><i class="ri-map-pin-2-fill"></i><p class="name">map-pin-2-fill</p></li><li class="class-icon"><i class="ri-map-pin-2-line"></i><p class="name">map-pin-2-line</p></li><li class="class-icon"><i class="ri-map-pin-3-fill"></i><p class="name">map-pin-3-fill</p></li><li class="class-icon"><i class="ri-map-pin-3-line"></i><p class="name">map-pin-3-line</p></li><li class="class-icon"><i class="ri-map-pin-4-fill"></i><p class="name">map-pin-4-fill</p></li><li class="class-icon"><i class="ri-map-pin-4-line"></i><p class="name">map-pin-4-line</p></li><li class="class-icon"><i class="ri-map-pin-5-fill"></i><p class="name">map-pin-5-fill</p></li><li class="class-icon"><i class="ri-map-pin-5-line"></i><p class="name">map-pin-5-line</p></li><li class="class-icon"><i class="ri-map-pin-add-fill"></i><p class="name">map-pin-add-fill</p></li><li class="class-icon"><i class="ri-map-pin-add-line"></i><p class="name">map-pin-add-line</p></li><li class="class-icon"><i class="ri-map-pin-fill"></i><p class="name">map-pin-fill</p></li><li class="class-icon"><i class="ri-map-pin-line"></i><p class="name">map-pin-line</p></li><li class="class-icon"><i class="ri-map-pin-range-fill"></i><p class="name">map-pin-range-fill</p></li><li class="class-icon"><i class="ri-map-pin-range-line"></i><p class="name">map-pin-range-line</p></li><li class="class-icon"><i class="ri-map-pin-time-fill"></i><p class="name">map-pin-time-fill</p></li><li class="class-icon"><i class="ri-map-pin-time-line"></i><p class="name">map-pin-time-line</p></li><li class="class-icon"><i class="ri-map-pin-user-fill"></i><p class="name">map-pin-user-fill</p></li><li class="class-icon"><i class="ri-map-pin-user-line"></i><p class="name">map-pin-user-line</p></li><li class="class-icon"><i class="ri-mark-pen-fill"></i><p class="name">mark-pen-fill</p></li><li class="class-icon"><i class="ri-mark-pen-line"></i><p class="name">mark-pen-line</p></li><li class="class-icon"><i class="ri-markdown-fill"></i><p class="name">markdown-fill</p></li><li class="class-icon"><i class="ri-markdown-line"></i><p class="name">markdown-line</p></li><li class="class-icon"><i class="ri-markup-fill"></i><p class="name">markup-fill</p></li><li class="class-icon"><i class="ri-markup-line"></i><p class="name">markup-line</p></li><li class="class-icon"><i class="ri-mastercard-fill"></i><p class="name">mastercard-fill</p></li><li class="class-icon"><i class="ri-mastercard-line"></i><p class="name">mastercard-line</p></li><li class="class-icon"><i class="ri-mastodon-fill"></i><p class="name">mastodon-fill</p></li><li class="class-icon"><i class="ri-mastodon-line"></i><p class="name">mastodon-line</p></li><li class="class-icon"><i class="ri-medal-2-fill"></i><p class="name">medal-2-fill</p></li><li class="class-icon"><i class="ri-medal-2-line"></i><p class="name">medal-2-line</p></li><li class="class-icon"><i class="ri-medal-fill"></i><p class="name">medal-fill</p></li><li class="class-icon"><i class="ri-medal-line"></i><p class="name">medal-line</p></li><li class="class-icon"><i class="ri-medicine-bottle-fill"></i><p class="name">medicine-bottle-fill</p></li><li class="class-icon"><i class="ri-medicine-bottle-line"></i><p class="name">medicine-bottle-line</p></li><li class="class-icon"><i class="ri-medium-fill"></i><p class="name">medium-fill</p></li><li class="class-icon"><i class="ri-medium-line"></i><p class="name">medium-line</p></li><li class="class-icon"><i class="ri-men-fill"></i><p class="name">men-fill</p></li><li class="class-icon"><i class="ri-men-line"></i><p class="name">men-line</p></li><li class="class-icon"><i class="ri-mental-health-fill"></i><p class="name">mental-health-fill</p></li><li class="class-icon"><i class="ri-mental-health-line"></i><p class="name">mental-health-line</p></li><li class="class-icon"><i class="ri-menu-2-fill"></i><p class="name">menu-2-fill</p></li><li class="class-icon"><i class="ri-menu-2-line"></i><p class="name">menu-2-line</p></li><li class="class-icon"><i class="ri-menu-3-fill"></i><p class="name">menu-3-fill</p></li><li class="class-icon"><i class="ri-menu-3-line"></i><p class="name">menu-3-line</p></li><li class="class-icon"><i class="ri-menu-4-fill"></i><p class="name">menu-4-fill</p></li><li class="class-icon"><i class="ri-menu-4-line"></i><p class="name">menu-4-line</p></li><li class="class-icon"><i class="ri-menu-5-fill"></i><p class="name">menu-5-fill</p></li><li class="class-icon"><i class="ri-menu-5-line"></i><p class="name">menu-5-line</p></li><li class="class-icon"><i class="ri-menu-add-fill"></i><p class="name">menu-add-fill</p></li><li class="class-icon"><i class="ri-menu-add-line"></i><p class="name">menu-add-line</p></li><li class="class-icon"><i class="ri-menu-fill"></i><p class="name">menu-fill</p></li><li class="class-icon"><i class="ri-menu-fold-fill"></i><p class="name">menu-fold-fill</p></li><li class="class-icon"><i class="ri-menu-fold-line"></i><p class="name">menu-fold-line</p></li><li class="class-icon"><i class="ri-menu-line"></i><p class="name">menu-line</p></li><li class="class-icon"><i class="ri-menu-unfold-fill"></i><p class="name">menu-unfold-fill</p></li><li class="class-icon"><i class="ri-menu-unfold-line"></i><p class="name">menu-unfold-line</p></li><li class="class-icon"><i class="ri-merge-cells-horizontal"></i><p class="name">merge-cells-horizontal</p></li><li class="class-icon"><i class="ri-merge-cells-vertical"></i><p class="name">merge-cells-vertical</p></li><li class="class-icon"><i class="ri-message-2-fill"></i><p class="name">message-2-fill</p></li><li class="class-icon"><i class="ri-message-2-line"></i><p class="name">message-2-line</p></li><li class="class-icon"><i class="ri-message-3-fill"></i><p class="name">message-3-fill</p></li><li class="class-icon"><i class="ri-message-3-line"></i><p class="name">message-3-line</p></li><li class="class-icon"><i class="ri-message-fill"></i><p class="name">message-fill</p></li><li class="class-icon"><i class="ri-message-line"></i><p class="name">message-line</p></li><li class="class-icon"><i class="ri-messenger-fill"></i><p class="name">messenger-fill</p></li><li class="class-icon"><i class="ri-messenger-line"></i><p class="name">messenger-line</p></li><li class="class-icon"><i class="ri-meteor-fill"></i><p class="name">meteor-fill</p></li><li class="class-icon"><i class="ri-meteor-line"></i><p class="name">meteor-line</p></li><li class="class-icon"><i class="ri-mic-2-fill"></i><p class="name">mic-2-fill</p></li><li class="class-icon"><i class="ri-mic-2-line"></i><p class="name">mic-2-line</p></li><li class="class-icon"><i class="ri-mic-fill"></i><p class="name">mic-fill</p></li><li class="class-icon"><i class="ri-mic-line"></i><p class="name">mic-line</p></li><li class="class-icon"><i class="ri-mic-off-fill"></i><p class="name">mic-off-fill</p></li><li class="class-icon"><i class="ri-mic-off-line"></i><p class="name">mic-off-line</p></li><li class="class-icon"><i class="ri-mickey-fill"></i><p class="name">mickey-fill</p></li><li class="class-icon"><i class="ri-mickey-line"></i><p class="name">mickey-line</p></li><li class="class-icon"><i class="ri-microscope-fill"></i><p class="name">microscope-fill</p></li><li class="class-icon"><i class="ri-microscope-line"></i><p class="name">microscope-line</p></li><li class="class-icon"><i class="ri-microsoft-fill"></i><p class="name">microsoft-fill</p></li><li class="class-icon"><i class="ri-microsoft-line"></i><p class="name">microsoft-line</p></li><li class="class-icon"><i class="ri-mind-map"></i><p class="name">mind-map</p></li><li class="class-icon"><i class="ri-mini-program-fill"></i><p class="name">mini-program-fill</p></li><li class="class-icon"><i class="ri-mini-program-line"></i><p class="name">mini-program-line</p></li><li class="class-icon"><i class="ri-mist-fill"></i><p class="name">mist-fill</p></li><li class="class-icon"><i class="ri-mist-line"></i><p class="name">mist-line</p></li><li class="class-icon"><i class="ri-money-cny-box-fill"></i><p class="name">money-cny-box-fill</p></li><li class="class-icon"><i class="ri-money-cny-box-line"></i><p class="name">money-cny-box-line</p></li><li class="class-icon"><i class="ri-money-cny-circle-fill"></i><p class="name">money-cny-circle-fill</p></li><li class="class-icon"><i class="ri-money-cny-circle-line"></i><p class="name">money-cny-circle-line</p></li><li class="class-icon"><i class="ri-money-dollar-box-fill"></i><p class="name">money-dollar-box-fill</p></li><li class="class-icon"><i class="ri-money-dollar-box-line"></i><p class="name">money-dollar-box-line</p></li><li class="class-icon"><i class="ri-money-dollar-circle-fill"></i><p class="name">money-dollar-circle-fill</p></li><li class="class-icon"><i class="ri-money-dollar-circle-line"></i><p class="name">money-dollar-circle-line</p></li><li class="class-icon"><i class="ri-money-euro-box-fill"></i><p class="name">money-euro-box-fill</p></li><li class="class-icon"><i class="ri-money-euro-box-line"></i><p class="name">money-euro-box-line</p></li><li class="class-icon"><i class="ri-money-euro-circle-fill"></i><p class="name">money-euro-circle-fill</p></li><li class="class-icon"><i class="ri-money-euro-circle-line"></i><p class="name">money-euro-circle-line</p></li><li class="class-icon"><i class="ri-money-pound-box-fill"></i><p class="name">money-pound-box-fill</p></li><li class="class-icon"><i class="ri-money-pound-box-line"></i><p class="name">money-pound-box-line</p></li><li class="class-icon"><i class="ri-money-pound-circle-fill"></i><p class="name">money-pound-circle-fill</p></li><li class="class-icon"><i class="ri-money-pound-circle-line"></i><p class="name">money-pound-circle-line</p></li><li class="class-icon"><i class="ri-moon-clear-fill"></i><p class="name">moon-clear-fill</p></li><li class="class-icon"><i class="ri-moon-clear-line"></i><p class="name">moon-clear-line</p></li><li class="class-icon"><i class="ri-moon-cloudy-fill"></i><p class="name">moon-cloudy-fill</p></li><li class="class-icon"><i class="ri-moon-cloudy-line"></i><p class="name">moon-cloudy-line</p></li><li class="class-icon"><i class="ri-moon-fill"></i><p class="name">moon-fill</p></li><li class="class-icon"><i class="ri-moon-foggy-fill"></i><p class="name">moon-foggy-fill</p></li><li class="class-icon"><i class="ri-moon-foggy-line"></i><p class="name">moon-foggy-line</p></li><li class="class-icon"><i class="ri-moon-line"></i><p class="name">moon-line</p></li><li class="class-icon"><i class="ri-more-2-fill"></i><p class="name">more-2-fill</p></li><li class="class-icon"><i class="ri-more-2-line"></i><p class="name">more-2-line</p></li><li class="class-icon"><i class="ri-more-fill"></i><p class="name">more-fill</p></li><li class="class-icon"><i class="ri-more-line"></i><p class="name">more-line</p></li><li class="class-icon"><i class="ri-motorbike-fill"></i><p class="name">motorbike-fill</p></li><li class="class-icon"><i class="ri-motorbike-line"></i><p class="name">motorbike-line</p></li><li class="class-icon"><i class="ri-mouse-fill"></i><p class="name">mouse-fill</p></li><li class="class-icon"><i class="ri-mouse-line"></i><p class="name">mouse-line</p></li><li class="class-icon"><i class="ri-movie-2-fill"></i><p class="name">movie-2-fill</p></li><li class="class-icon"><i class="ri-movie-2-line"></i><p class="name">movie-2-line</p></li><li class="class-icon"><i class="ri-movie-fill"></i><p class="name">movie-fill</p></li><li class="class-icon"><i class="ri-movie-line"></i><p class="name">movie-line</p></li><li class="class-icon"><i class="ri-music-2-fill"></i><p class="name">music-2-fill</p></li><li class="class-icon"><i class="ri-music-2-line"></i><p class="name">music-2-line</p></li><li class="class-icon"><i class="ri-music-fill"></i><p class="name">music-fill</p></li><li class="class-icon"><i class="ri-music-line"></i><p class="name">music-line</p></li><li class="class-icon"><i class="ri-mv-fill"></i><p class="name">mv-fill</p></li><li class="class-icon"><i class="ri-mv-line"></i><p class="name">mv-line</p></li><li class="class-icon"><i class="ri-navigation-fill"></i><p class="name">navigation-fill</p></li><li class="class-icon"><i class="ri-navigation-line"></i><p class="name">navigation-line</p></li><li class="class-icon"><i class="ri-netease-cloud-music-fill"></i><p class="name">netease-cloud-music-fill</p></li><li class="class-icon"><i class="ri-netease-cloud-music-line"></i><p class="name">netease-cloud-music-line</p></li><li class="class-icon"><i class="ri-netflix-fill"></i><p class="name">netflix-fill</p></li><li class="class-icon"><i class="ri-netflix-line"></i><p class="name">netflix-line</p></li><li class="class-icon"><i class="ri-newspaper-fill"></i><p class="name">newspaper-fill</p></li><li class="class-icon"><i class="ri-newspaper-line"></i><p class="name">newspaper-line</p></li><li class="class-icon"><i class="ri-node-tree"></i><p class="name">node-tree</p></li><li class="class-icon"><i class="ri-notification-2-fill"></i><p class="name">notification-2-fill</p></li><li class="class-icon"><i class="ri-notification-2-line"></i><p class="name">notification-2-line</p></li><li class="class-icon"><i class="ri-notification-3-fill"></i><p class="name">notification-3-fill</p></li><li class="class-icon"><i class="ri-notification-3-line"></i><p class="name">notification-3-line</p></li><li class="class-icon"><i class="ri-notification-4-fill"></i><p class="name">notification-4-fill</p></li><li class="class-icon"><i class="ri-notification-4-line"></i><p class="name">notification-4-line</p></li><li class="class-icon"><i class="ri-notification-badge-fill"></i><p class="name">notification-badge-fill</p></li><li class="class-icon"><i class="ri-notification-badge-line"></i><p class="name">notification-badge-line</p></li><li class="class-icon"><i class="ri-notification-fill"></i><p class="name">notification-fill</p></li><li class="class-icon"><i class="ri-notification-line"></i><p class="name">notification-line</p></li><li class="class-icon"><i class="ri-notification-off-fill"></i><p class="name">notification-off-fill</p></li><li class="class-icon"><i class="ri-notification-off-line"></i><p class="name">notification-off-line</p></li><li class="class-icon"><i class="ri-npmjs-fill"></i><p class="name">npmjs-fill</p></li><li class="class-icon"><i class="ri-npmjs-line"></i><p class="name">npmjs-line</p></li><li class="class-icon"><i class="ri-number-0"></i><p class="name">number-0</p></li><li class="class-icon"><i class="ri-number-1"></i><p class="name">number-1</p></li><li class="class-icon"><i class="ri-number-2"></i><p class="name">number-2</p></li><li class="class-icon"><i class="ri-number-3"></i><p class="name">number-3</p></li><li class="class-icon"><i class="ri-number-4"></i><p class="name">number-4</p></li><li class="class-icon"><i class="ri-number-5"></i><p class="name">number-5</p></li><li class="class-icon"><i class="ri-number-6"></i><p class="name">number-6</p></li><li class="class-icon"><i class="ri-number-7"></i><p class="name">number-7</p></li><li class="class-icon"><i class="ri-number-8"></i><p class="name">number-8</p></li><li class="class-icon"><i class="ri-number-9"></i><p class="name">number-9</p></li><li class="class-icon"><i class="ri-numbers-fill"></i><p class="name">numbers-fill</p></li><li class="class-icon"><i class="ri-numbers-line"></i><p class="name">numbers-line</p></li><li class="class-icon"><i class="ri-nurse-fill"></i><p class="name">nurse-fill</p></li><li class="class-icon"><i class="ri-nurse-line"></i><p class="name">nurse-line</p></li><li class="class-icon"><i class="ri-oil-fill"></i><p class="name">oil-fill</p></li><li class="class-icon"><i class="ri-oil-line"></i><p class="name">oil-line</p></li><li class="class-icon"><i class="ri-omega"></i><p class="name">omega</p></li><li class="class-icon"><i class="ri-open-arm-fill"></i><p class="name">open-arm-fill</p></li><li class="class-icon"><i class="ri-open-arm-line"></i><p class="name">open-arm-line</p></li><li class="class-icon"><i class="ri-open-source-fill"></i><p class="name">open-source-fill</p></li><li class="class-icon"><i class="ri-open-source-line"></i><p class="name">open-source-line</p></li><li class="class-icon"><i class="ri-opera-fill"></i><p class="name">opera-fill</p></li><li class="class-icon"><i class="ri-opera-line"></i><p class="name">opera-line</p></li><li class="class-icon"><i class="ri-order-play-fill"></i><p class="name">order-play-fill</p></li><li class="class-icon"><i class="ri-order-play-line"></i><p class="name">order-play-line</p></li><li class="class-icon"><i class="ri-organization-chart"></i><p class="name">organization-chart</p></li><li class="class-icon"><i class="ri-outlet-2-fill"></i><p class="name">outlet-2-fill</p></li><li class="class-icon"><i class="ri-outlet-2-line"></i><p class="name">outlet-2-line</p></li><li class="class-icon"><i class="ri-outlet-fill"></i><p class="name">outlet-fill</p></li><li class="class-icon"><i class="ri-outlet-line"></i><p class="name">outlet-line</p></li><li class="class-icon"><i class="ri-page-separator"></i><p class="name">page-separator</p></li><li class="class-icon"><i class="ri-pages-fill"></i><p class="name">pages-fill</p></li><li class="class-icon"><i class="ri-pages-line"></i><p class="name">pages-line</p></li><li class="class-icon"><i class="ri-paint-brush-fill"></i><p class="name">paint-brush-fill</p></li><li class="class-icon"><i class="ri-paint-brush-line"></i><p class="name">paint-brush-line</p></li><li class="class-icon"><i class="ri-paint-fill"></i><p class="name">paint-fill</p></li><li class="class-icon"><i class="ri-paint-line"></i><p class="name">paint-line</p></li><li class="class-icon"><i class="ri-palette-fill"></i><p class="name">palette-fill</p></li><li class="class-icon"><i class="ri-palette-line"></i><p class="name">palette-line</p></li><li class="class-icon"><i class="ri-pantone-fill"></i><p class="name">pantone-fill</p></li><li class="class-icon"><i class="ri-pantone-line"></i><p class="name">pantone-line</p></li><li class="class-icon"><i class="ri-paragraph"></i><p class="name">paragraph</p></li><li class="class-icon"><i class="ri-parent-fill"></i><p class="name">parent-fill</p></li><li class="class-icon"><i class="ri-parent-line"></i><p class="name">parent-line</p></li><li class="class-icon"><i class="ri-parentheses-fill"></i><p class="name">parentheses-fill</p></li><li class="class-icon"><i class="ri-parentheses-line"></i><p class="name">parentheses-line</p></li><li class="class-icon"><i class="ri-parking-box-fill"></i><p class="name">parking-box-fill</p></li><li class="class-icon"><i class="ri-parking-box-line"></i><p class="name">parking-box-line</p></li><li class="class-icon"><i class="ri-parking-fill"></i><p class="name">parking-fill</p></li><li class="class-icon"><i class="ri-parking-line"></i><p class="name">parking-line</p></li><li class="class-icon"><i class="ri-passport-fill"></i><p class="name">passport-fill</p></li><li class="class-icon"><i class="ri-passport-line"></i><p class="name">passport-line</p></li><li class="class-icon"><i class="ri-patreon-fill"></i><p class="name">patreon-fill</p></li><li class="class-icon"><i class="ri-patreon-line"></i><p class="name">patreon-line</p></li><li class="class-icon"><i class="ri-pause-circle-fill"></i><p class="name">pause-circle-fill</p></li><li class="class-icon"><i class="ri-pause-circle-line"></i><p class="name">pause-circle-line</p></li><li class="class-icon"><i class="ri-pause-fill"></i><p class="name">pause-fill</p></li><li class="class-icon"><i class="ri-pause-line"></i><p class="name">pause-line</p></li><li class="class-icon"><i class="ri-pause-mini-fill"></i><p class="name">pause-mini-fill</p></li><li class="class-icon"><i class="ri-pause-mini-line"></i><p class="name">pause-mini-line</p></li><li class="class-icon"><i class="ri-paypal-fill"></i><p class="name">paypal-fill</p></li><li class="class-icon"><i class="ri-paypal-line"></i><p class="name">paypal-line</p></li><li class="class-icon"><i class="ri-pen-nib-fill"></i><p class="name">pen-nib-fill</p></li><li class="class-icon"><i class="ri-pen-nib-line"></i><p class="name">pen-nib-line</p></li><li class="class-icon"><i class="ri-pencil-fill"></i><p class="name">pencil-fill</p></li><li class="class-icon"><i class="ri-pencil-line"></i><p class="name">pencil-line</p></li><li class="class-icon"><i class="ri-pencil-ruler-2-fill"></i><p class="name">pencil-ruler-2-fill</p></li><li class="class-icon"><i class="ri-pencil-ruler-2-line"></i><p class="name">pencil-ruler-2-line</p></li><li class="class-icon"><i class="ri-pencil-ruler-fill"></i><p class="name">pencil-ruler-fill</p></li><li class="class-icon"><i class="ri-pencil-ruler-line"></i><p class="name">pencil-ruler-line</p></li><li class="class-icon"><i class="ri-percent-fill"></i><p class="name">percent-fill</p></li><li class="class-icon"><i class="ri-percent-line"></i><p class="name">percent-line</p></li><li class="class-icon"><i class="ri-phone-camera-fill"></i><p class="name">phone-camera-fill</p></li><li class="class-icon"><i class="ri-phone-camera-line"></i><p class="name">phone-camera-line</p></li><li class="class-icon"><i class="ri-phone-fill"></i><p class="name">phone-fill</p></li><li class="class-icon"><i class="ri-phone-find-fill"></i><p class="name">phone-find-fill</p></li><li class="class-icon"><i class="ri-phone-find-line"></i><p class="name">phone-find-line</p></li><li class="class-icon"><i class="ri-phone-line"></i><p class="name">phone-line</p></li><li class="class-icon"><i class="ri-phone-lock-fill"></i><p class="name">phone-lock-fill</p></li><li class="class-icon"><i class="ri-phone-lock-line"></i><p class="name">phone-lock-line</p></li><li class="class-icon"><i class="ri-picture-in-picture-2-fill"></i><p class="name">picture-in-picture-2-fill</p></li><li class="class-icon"><i class="ri-picture-in-picture-2-line"></i><p class="name">picture-in-picture-2-line</p></li><li class="class-icon"><i class="ri-picture-in-picture-exit-fill"></i><p class="name">picture-in-picture-exit-fill</p></li><li class="class-icon"><i class="ri-picture-in-picture-exit-line"></i><p class="name">picture-in-picture-exit-line</p></li><li class="class-icon"><i class="ri-picture-in-picture-fill"></i><p class="name">picture-in-picture-fill</p></li><li class="class-icon"><i class="ri-picture-in-picture-line"></i><p class="name">picture-in-picture-line</p></li><li class="class-icon"><i class="ri-pie-chart-2-fill"></i><p class="name">pie-chart-2-fill</p></li><li class="class-icon"><i class="ri-pie-chart-2-line"></i><p class="name">pie-chart-2-line</p></li><li class="class-icon"><i class="ri-pie-chart-box-fill"></i><p class="name">pie-chart-box-fill</p></li><li class="class-icon"><i class="ri-pie-chart-box-line"></i><p class="name">pie-chart-box-line</p></li><li class="class-icon"><i class="ri-pie-chart-fill"></i><p class="name">pie-chart-fill</p></li><li class="class-icon"><i class="ri-pie-chart-line"></i><p class="name">pie-chart-line</p></li><li class="class-icon"><i class="ri-pin-distance-fill"></i><p class="name">pin-distance-fill</p></li><li class="class-icon"><i class="ri-pin-distance-line"></i><p class="name">pin-distance-line</p></li><li class="class-icon"><i class="ri-ping-pong-fill"></i><p class="name">ping-pong-fill</p></li><li class="class-icon"><i class="ri-ping-pong-line"></i><p class="name">ping-pong-line</p></li><li class="class-icon"><i class="ri-pinterest-fill"></i><p class="name">pinterest-fill</p></li><li class="class-icon"><i class="ri-pinterest-line"></i><p class="name">pinterest-line</p></li><li class="class-icon"><i class="ri-pinyin-input"></i><p class="name">pinyin-input</p></li><li class="class-icon"><i class="ri-pixelfed-fill"></i><p class="name">pixelfed-fill</p></li><li class="class-icon"><i class="ri-pixelfed-line"></i><p class="name">pixelfed-line</p></li><li class="class-icon"><i class="ri-plane-fill"></i><p class="name">plane-fill</p></li><li class="class-icon"><i class="ri-plane-line"></i><p class="name">plane-line</p></li><li class="class-icon"><i class="ri-plant-fill"></i><p class="name">plant-fill</p></li><li class="class-icon"><i class="ri-plant-line"></i><p class="name">plant-line</p></li><li class="class-icon"><i class="ri-play-circle-fill"></i><p class="name">play-circle-fill</p></li><li class="class-icon"><i class="ri-play-circle-line"></i><p class="name">play-circle-line</p></li><li class="class-icon"><i class="ri-play-fill"></i><p class="name">play-fill</p></li><li class="class-icon"><i class="ri-play-line"></i><p class="name">play-line</p></li><li class="class-icon"><i class="ri-play-list-2-fill"></i><p class="name">play-list-2-fill</p></li><li class="class-icon"><i class="ri-play-list-2-line"></i><p class="name">play-list-2-line</p></li><li class="class-icon"><i class="ri-play-list-add-fill"></i><p class="name">play-list-add-fill</p></li><li class="class-icon"><i class="ri-play-list-add-line"></i><p class="name">play-list-add-line</p></li><li class="class-icon"><i class="ri-play-list-fill"></i><p class="name">play-list-fill</p></li><li class="class-icon"><i class="ri-play-list-line"></i><p class="name">play-list-line</p></li><li class="class-icon"><i class="ri-play-mini-fill"></i><p class="name">play-mini-fill</p></li><li class="class-icon"><i class="ri-play-mini-line"></i><p class="name">play-mini-line</p></li><li class="class-icon"><i class="ri-playstation-fill"></i><p class="name">playstation-fill</p></li><li class="class-icon"><i class="ri-playstation-line"></i><p class="name">playstation-line</p></li><li class="class-icon"><i class="ri-plug-2-fill"></i><p class="name">plug-2-fill</p></li><li class="class-icon"><i class="ri-plug-2-line"></i><p class="name">plug-2-line</p></li><li class="class-icon"><i class="ri-plug-fill"></i><p class="name">plug-fill</p></li><li class="class-icon"><i class="ri-plug-line"></i><p class="name">plug-line</p></li><li class="class-icon"><i class="ri-polaroid-2-fill"></i><p class="name">polaroid-2-fill</p></li><li class="class-icon"><i class="ri-polaroid-2-line"></i><p class="name">polaroid-2-line</p></li><li class="class-icon"><i class="ri-polaroid-fill"></i><p class="name">polaroid-fill</p></li><li class="class-icon"><i class="ri-polaroid-line"></i><p class="name">polaroid-line</p></li><li class="class-icon"><i class="ri-police-car-fill"></i><p class="name">police-car-fill</p></li><li class="class-icon"><i class="ri-police-car-line"></i><p class="name">police-car-line</p></li><li class="class-icon"><i class="ri-price-tag-2-fill"></i><p class="name">price-tag-2-fill</p></li><li class="class-icon"><i class="ri-price-tag-2-line"></i><p class="name">price-tag-2-line</p></li><li class="class-icon"><i class="ri-price-tag-3-fill"></i><p class="name">price-tag-3-fill</p></li><li class="class-icon"><i class="ri-price-tag-3-line"></i><p class="name">price-tag-3-line</p></li><li class="class-icon"><i class="ri-price-tag-fill"></i><p class="name">price-tag-fill</p></li><li class="class-icon"><i class="ri-price-tag-line"></i><p class="name">price-tag-line</p></li><li class="class-icon"><i class="ri-printer-cloud-fill"></i><p class="name">printer-cloud-fill</p></li><li class="class-icon"><i class="ri-printer-cloud-line"></i><p class="name">printer-cloud-line</p></li><li class="class-icon"><i class="ri-printer-fill"></i><p class="name">printer-fill</p></li><li class="class-icon"><i class="ri-printer-line"></i><p class="name">printer-line</p></li><li class="class-icon"><i class="ri-product-hunt-fill"></i><p class="name">product-hunt-fill</p></li><li class="class-icon"><i class="ri-product-hunt-line"></i><p class="name">product-hunt-line</p></li><li class="class-icon"><i class="ri-profile-fill"></i><p class="name">profile-fill</p></li><li class="class-icon"><i class="ri-profile-line"></i><p class="name">profile-line</p></li><li class="class-icon"><i class="ri-projector-2-fill"></i><p class="name">projector-2-fill</p></li><li class="class-icon"><i class="ri-projector-2-line"></i><p class="name">projector-2-line</p></li><li class="class-icon"><i class="ri-projector-fill"></i><p class="name">projector-fill</p></li><li class="class-icon"><i class="ri-projector-line"></i><p class="name">projector-line</p></li><li class="class-icon"><i class="ri-psychotherapy-fill"></i><p class="name">psychotherapy-fill</p></li><li class="class-icon"><i class="ri-psychotherapy-line"></i><p class="name">psychotherapy-line</p></li><li class="class-icon"><i class="ri-pulse-fill"></i><p class="name">pulse-fill</p></li><li class="class-icon"><i class="ri-pulse-line"></i><p class="name">pulse-line</p></li><li class="class-icon"><i class="ri-pushpin-2-fill"></i><p class="name">pushpin-2-fill</p></li><li class="class-icon"><i class="ri-pushpin-2-line"></i><p class="name">pushpin-2-line</p></li><li class="class-icon"><i class="ri-pushpin-fill"></i><p class="name">pushpin-fill</p></li><li class="class-icon"><i class="ri-pushpin-line"></i><p class="name">pushpin-line</p></li><li class="class-icon"><i class="ri-qq-fill"></i><p class="name">qq-fill</p></li><li class="class-icon"><i class="ri-qq-line"></i><p class="name">qq-line</p></li><li class="class-icon"><i class="ri-qr-code-fill"></i><p class="name">qr-code-fill</p></li><li class="class-icon"><i class="ri-qr-code-line"></i><p class="name">qr-code-line</p></li><li class="class-icon"><i class="ri-qr-scan-2-fill"></i><p class="name">qr-scan-2-fill</p></li><li class="class-icon"><i class="ri-qr-scan-2-line"></i><p class="name">qr-scan-2-line</p></li><li class="class-icon"><i class="ri-qr-scan-fill"></i><p class="name">qr-scan-fill</p></li><li class="class-icon"><i class="ri-qr-scan-line"></i><p class="name">qr-scan-line</p></li><li class="class-icon"><i class="ri-question-answer-fill"></i><p class="name">question-answer-fill</p></li><li class="class-icon"><i class="ri-question-answer-line"></i><p class="name">question-answer-line</p></li><li class="class-icon"><i class="ri-question-fill"></i><p class="name">question-fill</p></li><li class="class-icon"><i class="ri-question-line"></i><p class="name">question-line</p></li><li class="class-icon"><i class="ri-question-mark"></i><p class="name">question-mark</p></li><li class="class-icon"><i class="ri-questionnaire-fill"></i><p class="name">questionnaire-fill</p></li><li class="class-icon"><i class="ri-questionnaire-line"></i><p class="name">questionnaire-line</p></li><li class="class-icon"><i class="ri-quill-pen-fill"></i><p class="name">quill-pen-fill</p></li><li class="class-icon"><i class="ri-quill-pen-line"></i><p class="name">quill-pen-line</p></li><li class="class-icon"><i class="ri-radar-fill"></i><p class="name">radar-fill</p></li><li class="class-icon"><i class="ri-radar-line"></i><p class="name">radar-line</p></li><li class="class-icon"><i class="ri-radio-2-fill"></i><p class="name">radio-2-fill</p></li><li class="class-icon"><i class="ri-radio-2-line"></i><p class="name">radio-2-line</p></li><li class="class-icon"><i class="ri-radio-button-fill"></i><p class="name">radio-button-fill</p></li><li class="class-icon"><i class="ri-radio-button-line"></i><p class="name">radio-button-line</p></li><li class="class-icon"><i class="ri-radio-fill"></i><p class="name">radio-fill</p></li><li class="class-icon"><i class="ri-radio-line"></i><p class="name">radio-line</p></li><li class="class-icon"><i class="ri-rainbow-fill"></i><p class="name">rainbow-fill</p></li><li class="class-icon"><i class="ri-rainbow-line"></i><p class="name">rainbow-line</p></li><li class="class-icon"><i class="ri-rainy-fill"></i><p class="name">rainy-fill</p></li><li class="class-icon"><i class="ri-rainy-line"></i><p class="name">rainy-line</p></li><li class="class-icon"><i class="ri-reactjs-fill"></i><p class="name">reactjs-fill</p></li><li class="class-icon"><i class="ri-reactjs-line"></i><p class="name">reactjs-line</p></li><li class="class-icon"><i class="ri-record-circle-fill"></i><p class="name">record-circle-fill</p></li><li class="class-icon"><i class="ri-record-circle-line"></i><p class="name">record-circle-line</p></li><li class="class-icon"><i class="ri-record-mail-fill"></i><p class="name">record-mail-fill</p></li><li class="class-icon"><i class="ri-record-mail-line"></i><p class="name">record-mail-line</p></li><li class="class-icon"><i class="ri-recycle-fill"></i><p class="name">recycle-fill</p></li><li class="class-icon"><i class="ri-recycle-line"></i><p class="name">recycle-line</p></li><li class="class-icon"><i class="ri-red-packet-fill"></i><p class="name">red-packet-fill</p></li><li class="class-icon"><i class="ri-red-packet-line"></i><p class="name">red-packet-line</p></li><li class="class-icon"><i class="ri-reddit-fill"></i><p class="name">reddit-fill</p></li><li class="class-icon"><i class="ri-reddit-line"></i><p class="name">reddit-line</p></li><li class="class-icon"><i class="ri-refresh-fill"></i><p class="name">refresh-fill</p></li><li class="class-icon"><i class="ri-refresh-line"></i><p class="name">refresh-line</p></li><li class="class-icon"><i class="ri-refund-2-fill"></i><p class="name">refund-2-fill</p></li><li class="class-icon"><i class="ri-refund-2-line"></i><p class="name">refund-2-line</p></li><li class="class-icon"><i class="ri-refund-fill"></i><p class="name">refund-fill</p></li><li class="class-icon"><i class="ri-refund-line"></i><p class="name">refund-line</p></li><li class="class-icon"><i class="ri-registered-fill"></i><p class="name">registered-fill</p></li><li class="class-icon"><i class="ri-registered-line"></i><p class="name">registered-line</p></li><li class="class-icon"><i class="ri-remixicon-fill"></i><p class="name">remixicon-fill</p></li><li class="class-icon"><i class="ri-remixicon-line"></i><p class="name">remixicon-line</p></li><li class="class-icon"><i class="ri-remote-control-2-fill"></i><p class="name">remote-control-2-fill</p></li><li class="class-icon"><i class="ri-remote-control-2-line"></i><p class="name">remote-control-2-line</p></li><li class="class-icon"><i class="ri-remote-control-fill"></i><p class="name">remote-control-fill</p></li><li class="class-icon"><i class="ri-remote-control-line"></i><p class="name">remote-control-line</p></li><li class="class-icon"><i class="ri-repeat-2-fill"></i><p class="name">repeat-2-fill</p></li><li class="class-icon"><i class="ri-repeat-2-line"></i><p class="name">repeat-2-line</p></li><li class="class-icon"><i class="ri-repeat-fill"></i><p class="name">repeat-fill</p></li><li class="class-icon"><i class="ri-repeat-line"></i><p class="name">repeat-line</p></li><li class="class-icon"><i class="ri-repeat-one-fill"></i><p class="name">repeat-one-fill</p></li><li class="class-icon"><i class="ri-repeat-one-line"></i><p class="name">repeat-one-line</p></li><li class="class-icon"><i class="ri-reply-all-fill"></i><p class="name">reply-all-fill</p></li><li class="class-icon"><i class="ri-reply-all-line"></i><p class="name">reply-all-line</p></li><li class="class-icon"><i class="ri-reply-fill"></i><p class="name">reply-fill</p></li><li class="class-icon"><i class="ri-reply-line"></i><p class="name">reply-line</p></li><li class="class-icon"><i class="ri-reserved-fill"></i><p class="name">reserved-fill</p></li><li class="class-icon"><i class="ri-reserved-line"></i><p class="name">reserved-line</p></li><li class="class-icon"><i class="ri-rest-time-fill"></i><p class="name">rest-time-fill</p></li><li class="class-icon"><i class="ri-rest-time-line"></i><p class="name">rest-time-line</p></li><li class="class-icon"><i class="ri-restart-fill"></i><p class="name">restart-fill</p></li><li class="class-icon"><i class="ri-restart-line"></i><p class="name">restart-line</p></li><li class="class-icon"><i class="ri-restaurant-2-fill"></i><p class="name">restaurant-2-fill</p></li><li class="class-icon"><i class="ri-restaurant-2-line"></i><p class="name">restaurant-2-line</p></li><li class="class-icon"><i class="ri-restaurant-fill"></i><p class="name">restaurant-fill</p></li><li class="class-icon"><i class="ri-restaurant-line"></i><p class="name">restaurant-line</p></li><li class="class-icon"><i class="ri-rewind-fill"></i><p class="name">rewind-fill</p></li><li class="class-icon"><i class="ri-rewind-line"></i><p class="name">rewind-line</p></li><li class="class-icon"><i class="ri-rewind-mini-fill"></i><p class="name">rewind-mini-fill</p></li><li class="class-icon"><i class="ri-rewind-mini-line"></i><p class="name">rewind-mini-line</p></li><li class="class-icon"><i class="ri-rhythm-fill"></i><p class="name">rhythm-fill</p></li><li class="class-icon"><i class="ri-rhythm-line"></i><p class="name">rhythm-line</p></li><li class="class-icon"><i class="ri-riding-fill"></i><p class="name">riding-fill</p></li><li class="class-icon"><i class="ri-riding-line"></i><p class="name">riding-line</p></li><li class="class-icon"><i class="ri-road-map-fill"></i><p class="name">road-map-fill</p></li><li class="class-icon"><i class="ri-road-map-line"></i><p class="name">road-map-line</p></li><li class="class-icon"><i class="ri-roadster-fill"></i><p class="name">roadster-fill</p></li><li class="class-icon"><i class="ri-roadster-line"></i><p class="name">roadster-line</p></li><li class="class-icon"><i class="ri-robot-fill"></i><p class="name">robot-fill</p></li><li class="class-icon"><i class="ri-robot-line"></i><p class="name">robot-line</p></li><li class="class-icon"><i class="ri-rocket-2-fill"></i><p class="name">rocket-2-fill</p></li><li class="class-icon"><i class="ri-rocket-2-line"></i><p class="name">rocket-2-line</p></li><li class="class-icon"><i class="ri-rocket-fill"></i><p class="name">rocket-fill</p></li><li class="class-icon"><i class="ri-rocket-line"></i><p class="name">rocket-line</p></li><li class="class-icon"><i class="ri-rotate-lock-fill"></i><p class="name">rotate-lock-fill</p></li><li class="class-icon"><i class="ri-rotate-lock-line"></i><p class="name">rotate-lock-line</p></li><li class="class-icon"><i class="ri-rounded-corner"></i><p class="name">rounded-corner</p></li><li class="class-icon"><i class="ri-route-fill"></i><p class="name">route-fill</p></li><li class="class-icon"><i class="ri-route-line"></i><p class="name">route-line</p></li><li class="class-icon"><i class="ri-router-fill"></i><p class="name">router-fill</p></li><li class="class-icon"><i class="ri-router-line"></i><p class="name">router-line</p></li><li class="class-icon"><i class="ri-rss-fill"></i><p class="name">rss-fill</p></li><li class="class-icon"><i class="ri-rss-line"></i><p class="name">rss-line</p></li><li class="class-icon"><i class="ri-ruler-2-fill"></i><p class="name">ruler-2-fill</p></li><li class="class-icon"><i class="ri-ruler-2-line"></i><p class="name">ruler-2-line</p></li><li class="class-icon"><i class="ri-ruler-fill"></i><p class="name">ruler-fill</p></li><li class="class-icon"><i class="ri-ruler-line"></i><p class="name">ruler-line</p></li><li class="class-icon"><i class="ri-run-fill"></i><p class="name">run-fill</p></li><li class="class-icon"><i class="ri-run-line"></i><p class="name">run-line</p></li><li class="class-icon"><i class="ri-safari-fill"></i><p class="name">safari-fill</p></li><li class="class-icon"><i class="ri-safari-line"></i><p class="name">safari-line</p></li><li class="class-icon"><i class="ri-safe-2-fill"></i><p class="name">safe-2-fill</p></li><li class="class-icon"><i class="ri-safe-2-line"></i><p class="name">safe-2-line</p></li><li class="class-icon"><i class="ri-safe-fill"></i><p class="name">safe-fill</p></li><li class="class-icon"><i class="ri-safe-line"></i><p class="name">safe-line</p></li><li class="class-icon"><i class="ri-sailboat-fill"></i><p class="name">sailboat-fill</p></li><li class="class-icon"><i class="ri-sailboat-line"></i><p class="name">sailboat-line</p></li><li class="class-icon"><i class="ri-save-2-fill"></i><p class="name">save-2-fill</p></li><li class="class-icon"><i class="ri-save-2-line"></i><p class="name">save-2-line</p></li><li class="class-icon"><i class="ri-save-3-fill"></i><p class="name">save-3-fill</p></li><li class="class-icon"><i class="ri-save-3-line"></i><p class="name">save-3-line</p></li><li class="class-icon"><i class="ri-save-fill"></i><p class="name">save-fill</p></li><li class="class-icon"><i class="ri-save-line"></i><p class="name">save-line</p></li><li class="class-icon"><i class="ri-scales-2-fill"></i><p class="name">scales-2-fill</p></li><li class="class-icon"><i class="ri-scales-2-line"></i><p class="name">scales-2-line</p></li><li class="class-icon"><i class="ri-scales-3-fill"></i><p class="name">scales-3-fill</p></li><li class="class-icon"><i class="ri-scales-3-line"></i><p class="name">scales-3-line</p></li><li class="class-icon"><i class="ri-scales-fill"></i><p class="name">scales-fill</p></li><li class="class-icon"><i class="ri-scales-line"></i><p class="name">scales-line</p></li><li class="class-icon"><i class="ri-scan-2-fill"></i><p class="name">scan-2-fill</p></li><li class="class-icon"><i class="ri-scan-2-line"></i><p class="name">scan-2-line</p></li><li class="class-icon"><i class="ri-scan-fill"></i><p class="name">scan-fill</p></li><li class="class-icon"><i class="ri-scan-line"></i><p class="name">scan-line</p></li><li class="class-icon"><i class="ri-scissors-2-fill"></i><p class="name">scissors-2-fill</p></li><li class="class-icon"><i class="ri-scissors-2-line"></i><p class="name">scissors-2-line</p></li><li class="class-icon"><i class="ri-scissors-cut-fill"></i><p class="name">scissors-cut-fill</p></li><li class="class-icon"><i class="ri-scissors-cut-line"></i><p class="name">scissors-cut-line</p></li><li class="class-icon"><i class="ri-scissors-fill"></i><p class="name">scissors-fill</p></li><li class="class-icon"><i class="ri-scissors-line"></i><p class="name">scissors-line</p></li><li class="class-icon"><i class="ri-screenshot-2-fill"></i><p class="name">screenshot-2-fill</p></li><li class="class-icon"><i class="ri-screenshot-2-line"></i><p class="name">screenshot-2-line</p></li><li class="class-icon"><i class="ri-screenshot-fill"></i><p class="name">screenshot-fill</p></li><li class="class-icon"><i class="ri-screenshot-line"></i><p class="name">screenshot-line</p></li><li class="class-icon"><i class="ri-sd-card-fill"></i><p class="name">sd-card-fill</p></li><li class="class-icon"><i class="ri-sd-card-line"></i><p class="name">sd-card-line</p></li><li class="class-icon"><i class="ri-sd-card-mini-fill"></i><p class="name">sd-card-mini-fill</p></li><li class="class-icon"><i class="ri-sd-card-mini-line"></i><p class="name">sd-card-mini-line</p></li><li class="class-icon"><i class="ri-search-2-fill"></i><p class="name">search-2-fill</p></li><li class="class-icon"><i class="ri-search-2-line"></i><p class="name">search-2-line</p></li><li class="class-icon"><i class="ri-search-eye-fill"></i><p class="name">search-eye-fill</p></li><li class="class-icon"><i class="ri-search-eye-line"></i><p class="name">search-eye-line</p></li><li class="class-icon"><i class="ri-search-fill"></i><p class="name">search-fill</p></li><li class="class-icon"><i class="ri-search-line"></i><p class="name">search-line</p></li><li class="class-icon"><i class="ri-secure-payment-fill"></i><p class="name">secure-payment-fill</p></li><li class="class-icon"><i class="ri-secure-payment-line"></i><p class="name">secure-payment-line</p></li><li class="class-icon"><i class="ri-seedling-fill"></i><p class="name">seedling-fill</p></li><li class="class-icon"><i class="ri-seedling-line"></i><p class="name">seedling-line</p></li><li class="class-icon"><i class="ri-send-backward"></i><p class="name">send-backward</p></li><li class="class-icon"><i class="ri-send-plane-2-fill"></i><p class="name">send-plane-2-fill</p></li><li class="class-icon"><i class="ri-send-plane-2-line"></i><p class="name">send-plane-2-line</p></li><li class="class-icon"><i class="ri-send-plane-fill"></i><p class="name">send-plane-fill</p></li><li class="class-icon"><i class="ri-send-plane-line"></i><p class="name">send-plane-line</p></li><li class="class-icon"><i class="ri-send-to-back"></i><p class="name">send-to-back</p></li><li class="class-icon"><i class="ri-sensor-fill"></i><p class="name">sensor-fill</p></li><li class="class-icon"><i class="ri-sensor-line"></i><p class="name">sensor-line</p></li><li class="class-icon"><i class="ri-separator"></i><p class="name">separator</p></li><li class="class-icon"><i class="ri-server-fill"></i><p class="name">server-fill</p></li><li class="class-icon"><i class="ri-server-line"></i><p class="name">server-line</p></li><li class="class-icon"><i class="ri-service-fill"></i><p class="name">service-fill</p></li><li class="class-icon"><i class="ri-service-line"></i><p class="name">service-line</p></li><li class="class-icon"><i class="ri-settings-2-fill"></i><p class="name">settings-2-fill</p></li><li class="class-icon"><i class="ri-settings-2-line"></i><p class="name">settings-2-line</p></li><li class="class-icon"><i class="ri-settings-3-fill"></i><p class="name">settings-3-fill</p></li><li class="class-icon"><i class="ri-settings-3-line"></i><p class="name">settings-3-line</p></li><li class="class-icon"><i class="ri-settings-4-fill"></i><p class="name">settings-4-fill</p></li><li class="class-icon"><i class="ri-settings-4-line"></i><p class="name">settings-4-line</p></li><li class="class-icon"><i class="ri-settings-5-fill"></i><p class="name">settings-5-fill</p></li><li class="class-icon"><i class="ri-settings-5-line"></i><p class="name">settings-5-line</p></li><li class="class-icon"><i class="ri-settings-6-fill"></i><p class="name">settings-6-fill</p></li><li class="class-icon"><i class="ri-settings-6-line"></i><p class="name">settings-6-line</p></li><li class="class-icon"><i class="ri-settings-fill"></i><p class="name">settings-fill</p></li><li class="class-icon"><i class="ri-settings-line"></i><p class="name">settings-line</p></li><li class="class-icon"><i class="ri-shape-2-fill"></i><p class="name">shape-2-fill</p></li><li class="class-icon"><i class="ri-shape-2-line"></i><p class="name">shape-2-line</p></li><li class="class-icon"><i class="ri-shape-fill"></i><p class="name">shape-fill</p></li><li class="class-icon"><i class="ri-shape-line"></i><p class="name">shape-line</p></li><li class="class-icon"><i class="ri-share-box-fill"></i><p class="name">share-box-fill</p></li><li class="class-icon"><i class="ri-share-box-line"></i><p class="name">share-box-line</p></li><li class="class-icon"><i class="ri-share-circle-fill"></i><p class="name">share-circle-fill</p></li><li class="class-icon"><i class="ri-share-circle-line"></i><p class="name">share-circle-line</p></li><li class="class-icon"><i class="ri-share-fill"></i><p class="name">share-fill</p></li><li class="class-icon"><i class="ri-share-forward-2-fill"></i><p class="name">share-forward-2-fill</p></li><li class="class-icon"><i class="ri-share-forward-2-line"></i><p class="name">share-forward-2-line</p></li><li class="class-icon"><i class="ri-share-forward-box-fill"></i><p class="name">share-forward-box-fill</p></li><li class="class-icon"><i class="ri-share-forward-box-line"></i><p class="name">share-forward-box-line</p></li><li class="class-icon"><i class="ri-share-forward-fill"></i><p class="name">share-forward-fill</p></li><li class="class-icon"><i class="ri-share-forward-line"></i><p class="name">share-forward-line</p></li><li class="class-icon"><i class="ri-share-line"></i><p class="name">share-line</p></li><li class="class-icon"><i class="ri-shield-check-fill"></i><p class="name">shield-check-fill</p></li><li class="class-icon"><i class="ri-shield-check-line"></i><p class="name">shield-check-line</p></li><li class="class-icon"><i class="ri-shield-cross-fill"></i><p class="name">shield-cross-fill</p></li><li class="class-icon"><i class="ri-shield-cross-line"></i><p class="name">shield-cross-line</p></li><li class="class-icon"><i class="ri-shield-fill"></i><p class="name">shield-fill</p></li><li class="class-icon"><i class="ri-shield-flash-fill"></i><p class="name">shield-flash-fill</p></li><li class="class-icon"><i class="ri-shield-flash-line"></i><p class="name">shield-flash-line</p></li><li class="class-icon"><i class="ri-shield-keyhole-fill"></i><p class="name">shield-keyhole-fill</p></li><li class="class-icon"><i class="ri-shield-keyhole-line"></i><p class="name">shield-keyhole-line</p></li><li class="class-icon"><i class="ri-shield-line"></i><p class="name">shield-line</p></li><li class="class-icon"><i class="ri-shield-star-fill"></i><p class="name">shield-star-fill</p></li><li class="class-icon"><i class="ri-shield-star-line"></i><p class="name">shield-star-line</p></li><li class="class-icon"><i class="ri-shield-user-fill"></i><p class="name">shield-user-fill</p></li><li class="class-icon"><i class="ri-shield-user-line"></i><p class="name">shield-user-line</p></li><li class="class-icon"><i class="ri-ship-2-fill"></i><p class="name">ship-2-fill</p></li><li class="class-icon"><i class="ri-ship-2-line"></i><p class="name">ship-2-line</p></li><li class="class-icon"><i class="ri-ship-fill"></i><p class="name">ship-fill</p></li><li class="class-icon"><i class="ri-ship-line"></i><p class="name">ship-line</p></li><li class="class-icon"><i class="ri-shirt-fill"></i><p class="name">shirt-fill</p></li><li class="class-icon"><i class="ri-shirt-line"></i><p class="name">shirt-line</p></li><li class="class-icon"><i class="ri-shopping-bag-2-fill"></i><p class="name">shopping-bag-2-fill</p></li><li class="class-icon"><i class="ri-shopping-bag-2-line"></i><p class="name">shopping-bag-2-line</p></li><li class="class-icon"><i class="ri-shopping-bag-3-fill"></i><p class="name">shopping-bag-3-fill</p></li><li class="class-icon"><i class="ri-shopping-bag-3-line"></i><p class="name">shopping-bag-3-line</p></li><li class="class-icon"><i class="ri-shopping-bag-fill"></i><p class="name">shopping-bag-fill</p></li><li class="class-icon"><i class="ri-shopping-bag-line"></i><p class="name">shopping-bag-line</p></li><li class="class-icon"><i class="ri-shopping-basket-2-fill"></i><p class="name">shopping-basket-2-fill</p></li><li class="class-icon"><i class="ri-shopping-basket-2-line"></i><p class="name">shopping-basket-2-line</p></li><li class="class-icon"><i class="ri-shopping-basket-fill"></i><p class="name">shopping-basket-fill</p></li><li class="class-icon"><i class="ri-shopping-basket-line"></i><p class="name">shopping-basket-line</p></li><li class="class-icon"><i class="ri-shopping-cart-2-fill"></i><p class="name">shopping-cart-2-fill</p></li><li class="class-icon"><i class="ri-shopping-cart-2-line"></i><p class="name">shopping-cart-2-line</p></li><li class="class-icon"><i class="ri-shopping-cart-fill"></i><p class="name">shopping-cart-fill</p></li><li class="class-icon"><i class="ri-shopping-cart-line"></i><p class="name">shopping-cart-line</p></li><li class="class-icon"><i class="ri-showers-fill"></i><p class="name">showers-fill</p></li><li class="class-icon"><i class="ri-showers-line"></i><p class="name">showers-line</p></li><li class="class-icon"><i class="ri-shuffle-fill"></i><p class="name">shuffle-fill</p></li><li class="class-icon"><i class="ri-shuffle-line"></i><p class="name">shuffle-line</p></li><li class="class-icon"><i class="ri-shut-down-fill"></i><p class="name">shut-down-fill</p></li><li class="class-icon"><i class="ri-shut-down-line"></i><p class="name">shut-down-line</p></li><li class="class-icon"><i class="ri-side-bar-fill"></i><p class="name">side-bar-fill</p></li><li class="class-icon"><i class="ri-side-bar-line"></i><p class="name">side-bar-line</p></li><li class="class-icon"><i class="ri-signal-tower-fill"></i><p class="name">signal-tower-fill</p></li><li class="class-icon"><i class="ri-signal-tower-line"></i><p class="name">signal-tower-line</p></li><li class="class-icon"><i class="ri-signal-wifi-1-fill"></i><p class="name">signal-wifi-1-fill</p></li><li class="class-icon"><i class="ri-signal-wifi-1-line"></i><p class="name">signal-wifi-1-line</p></li><li class="class-icon"><i class="ri-signal-wifi-2-fill"></i><p class="name">signal-wifi-2-fill</p></li><li class="class-icon"><i class="ri-signal-wifi-2-line"></i><p class="name">signal-wifi-2-line</p></li><li class="class-icon"><i class="ri-signal-wifi-3-fill"></i><p class="name">signal-wifi-3-fill</p></li><li class="class-icon"><i class="ri-signal-wifi-3-line"></i><p class="name">signal-wifi-3-line</p></li><li class="class-icon"><i class="ri-signal-wifi-error-fill"></i><p class="name">signal-wifi-error-fill</p></li><li class="class-icon"><i class="ri-signal-wifi-error-line"></i><p class="name">signal-wifi-error-line</p></li><li class="class-icon"><i class="ri-signal-wifi-fill"></i><p class="name">signal-wifi-fill</p></li><li class="class-icon"><i class="ri-signal-wifi-line"></i><p class="name">signal-wifi-line</p></li><li class="class-icon"><i class="ri-signal-wifi-off-fill"></i><p class="name">signal-wifi-off-fill</p></li><li class="class-icon"><i class="ri-signal-wifi-off-line"></i><p class="name">signal-wifi-off-line</p></li><li class="class-icon"><i class="ri-sim-card-2-fill"></i><p class="name">sim-card-2-fill</p></li><li class="class-icon"><i class="ri-sim-card-2-line"></i><p class="name">sim-card-2-line</p></li><li class="class-icon"><i class="ri-sim-card-fill"></i><p class="name">sim-card-fill</p></li><li class="class-icon"><i class="ri-sim-card-line"></i><p class="name">sim-card-line</p></li><li class="class-icon"><i class="ri-single-quotes-l"></i><p class="name">single-quotes-l</p></li><li class="class-icon"><i class="ri-single-quotes-r"></i><p class="name">single-quotes-r</p></li><li class="class-icon"><i class="ri-sip-fill"></i><p class="name">sip-fill</p></li><li class="class-icon"><i class="ri-sip-line"></i><p class="name">sip-line</p></li><li class="class-icon"><i class="ri-skip-back-fill"></i><p class="name">skip-back-fill</p></li><li class="class-icon"><i class="ri-skip-back-line"></i><p class="name">skip-back-line</p></li><li class="class-icon"><i class="ri-skip-back-mini-fill"></i><p class="name">skip-back-mini-fill</p></li><li class="class-icon"><i class="ri-skip-back-mini-line"></i><p class="name">skip-back-mini-line</p></li><li class="class-icon"><i class="ri-skip-forward-fill"></i><p class="name">skip-forward-fill</p></li><li class="class-icon"><i class="ri-skip-forward-line"></i><p class="name">skip-forward-line</p></li><li class="class-icon"><i class="ri-skip-forward-mini-fill"></i><p class="name">skip-forward-mini-fill</p></li><li class="class-icon"><i class="ri-skip-forward-mini-line"></i><p class="name">skip-forward-mini-line</p></li><li class="class-icon"><i class="ri-skull-2-fill"></i><p class="name">skull-2-fill</p></li><li class="class-icon"><i class="ri-skull-2-line"></i><p class="name">skull-2-line</p></li><li class="class-icon"><i class="ri-skull-fill"></i><p class="name">skull-fill</p></li><li class="class-icon"><i class="ri-skull-line"></i><p class="name">skull-line</p></li><li class="class-icon"><i class="ri-skype-fill"></i><p class="name">skype-fill</p></li><li class="class-icon"><i class="ri-skype-line"></i><p class="name">skype-line</p></li><li class="class-icon"><i class="ri-slack-fill"></i><p class="name">slack-fill</p></li><li class="class-icon"><i class="ri-slack-line"></i><p class="name">slack-line</p></li><li class="class-icon"><i class="ri-slice-fill"></i><p class="name">slice-fill</p></li><li class="class-icon"><i class="ri-slice-line"></i><p class="name">slice-line</p></li><li class="class-icon"><i class="ri-slideshow-2-fill"></i><p class="name">slideshow-2-fill</p></li><li class="class-icon"><i class="ri-slideshow-2-line"></i><p class="name">slideshow-2-line</p></li><li class="class-icon"><i class="ri-slideshow-3-fill"></i><p class="name">slideshow-3-fill</p></li><li class="class-icon"><i class="ri-slideshow-3-line"></i><p class="name">slideshow-3-line</p></li><li class="class-icon"><i class="ri-slideshow-4-fill"></i><p class="name">slideshow-4-fill</p></li><li class="class-icon"><i class="ri-slideshow-4-line"></i><p class="name">slideshow-4-line</p></li><li class="class-icon"><i class="ri-slideshow-fill"></i><p class="name">slideshow-fill</p></li><li class="class-icon"><i class="ri-slideshow-line"></i><p class="name">slideshow-line</p></li><li class="class-icon"><i class="ri-smartphone-fill"></i><p class="name">smartphone-fill</p></li><li class="class-icon"><i class="ri-smartphone-line"></i><p class="name">smartphone-line</p></li><li class="class-icon"><i class="ri-snapchat-fill"></i><p class="name">snapchat-fill</p></li><li class="class-icon"><i class="ri-snapchat-line"></i><p class="name">snapchat-line</p></li><li class="class-icon"><i class="ri-snowy-fill"></i><p class="name">snowy-fill</p></li><li class="class-icon"><i class="ri-snowy-line"></i><p class="name">snowy-line</p></li><li class="class-icon"><i class="ri-sort-asc"></i><p class="name">sort-asc</p></li><li class="class-icon"><i class="ri-sort-desc"></i><p class="name">sort-desc</p></li><li class="class-icon"><i class="ri-sound-module-fill"></i><p class="name">sound-module-fill</p></li><li class="class-icon"><i class="ri-sound-module-line"></i><p class="name">sound-module-line</p></li><li class="class-icon"><i class="ri-soundcloud-fill"></i><p class="name">soundcloud-fill</p></li><li class="class-icon"><i class="ri-soundcloud-line"></i><p class="name">soundcloud-line</p></li><li class="class-icon"><i class="ri-space-ship-fill"></i><p class="name">space-ship-fill</p></li><li class="class-icon"><i class="ri-space-ship-line"></i><p class="name">space-ship-line</p></li><li class="class-icon"><i class="ri-space"></i><p class="name">space</p></li><li class="class-icon"><i class="ri-spam-2-fill"></i><p class="name">spam-2-fill</p></li><li class="class-icon"><i class="ri-spam-2-line"></i><p class="name">spam-2-line</p></li><li class="class-icon"><i class="ri-spam-3-fill"></i><p class="name">spam-3-fill</p></li><li class="class-icon"><i class="ri-spam-3-line"></i><p class="name">spam-3-line</p></li><li class="class-icon"><i class="ri-spam-fill"></i><p class="name">spam-fill</p></li><li class="class-icon"><i class="ri-spam-line"></i><p class="name">spam-line</p></li><li class="class-icon"><i class="ri-speaker-2-fill"></i><p class="name">speaker-2-fill</p></li><li class="class-icon"><i class="ri-speaker-2-line"></i><p class="name">speaker-2-line</p></li><li class="class-icon"><i class="ri-speaker-3-fill"></i><p class="name">speaker-3-fill</p></li><li class="class-icon"><i class="ri-speaker-3-line"></i><p class="name">speaker-3-line</p></li><li class="class-icon"><i class="ri-speaker-fill"></i><p class="name">speaker-fill</p></li><li class="class-icon"><i class="ri-speaker-line"></i><p class="name">speaker-line</p></li><li class="class-icon"><i class="ri-spectrum-fill"></i><p class="name">spectrum-fill</p></li><li class="class-icon"><i class="ri-spectrum-line"></i><p class="name">spectrum-line</p></li><li class="class-icon"><i class="ri-speed-fill"></i><p class="name">speed-fill</p></li><li class="class-icon"><i class="ri-speed-line"></i><p class="name">speed-line</p></li><li class="class-icon"><i class="ri-speed-mini-fill"></i><p class="name">speed-mini-fill</p></li><li class="class-icon"><i class="ri-speed-mini-line"></i><p class="name">speed-mini-line</p></li><li class="class-icon"><i class="ri-split-cells-horizontal"></i><p class="name">split-cells-horizontal</p></li><li class="class-icon"><i class="ri-split-cells-vertical"></i><p class="name">split-cells-vertical</p></li><li class="class-icon"><i class="ri-spotify-fill"></i><p class="name">spotify-fill</p></li><li class="class-icon"><i class="ri-spotify-line"></i><p class="name">spotify-line</p></li><li class="class-icon"><i class="ri-spy-fill"></i><p class="name">spy-fill</p></li><li class="class-icon"><i class="ri-spy-line"></i><p class="name">spy-line</p></li><li class="class-icon"><i class="ri-stack-fill"></i><p class="name">stack-fill</p></li><li class="class-icon"><i class="ri-stack-line"></i><p class="name">stack-line</p></li><li class="class-icon"><i class="ri-stack-overflow-fill"></i><p class="name">stack-overflow-fill</p></li><li class="class-icon"><i class="ri-stack-overflow-line"></i><p class="name">stack-overflow-line</p></li><li class="class-icon"><i class="ri-stackshare-fill"></i><p class="name">stackshare-fill</p></li><li class="class-icon"><i class="ri-stackshare-line"></i><p class="name">stackshare-line</p></li><li class="class-icon"><i class="ri-star-fill"></i><p class="name">star-fill</p></li><li class="class-icon"><i class="ri-star-half-fill"></i><p class="name">star-half-fill</p></li><li class="class-icon"><i class="ri-star-half-line"></i><p class="name">star-half-line</p></li><li class="class-icon"><i class="ri-star-half-s-fill"></i><p class="name">star-half-s-fill</p></li><li class="class-icon"><i class="ri-star-half-s-line"></i><p class="name">star-half-s-line</p></li><li class="class-icon"><i class="ri-star-line"></i><p class="name">star-line</p></li><li class="class-icon"><i class="ri-star-s-fill"></i><p class="name">star-s-fill</p></li><li class="class-icon"><i class="ri-star-s-line"></i><p class="name">star-s-line</p></li><li class="class-icon"><i class="ri-star-smile-fill"></i><p class="name">star-smile-fill</p></li><li class="class-icon"><i class="ri-star-smile-line"></i><p class="name">star-smile-line</p></li><li class="class-icon"><i class="ri-steam-fill"></i><p class="name">steam-fill</p></li><li class="class-icon"><i class="ri-steam-line"></i><p class="name">steam-line</p></li><li class="class-icon"><i class="ri-steering-2-fill"></i><p class="name">steering-2-fill</p></li><li class="class-icon"><i class="ri-steering-2-line"></i><p class="name">steering-2-line</p></li><li class="class-icon"><i class="ri-steering-fill"></i><p class="name">steering-fill</p></li><li class="class-icon"><i class="ri-steering-line"></i><p class="name">steering-line</p></li><li class="class-icon"><i class="ri-stethoscope-fill"></i><p class="name">stethoscope-fill</p></li><li class="class-icon"><i class="ri-stethoscope-line"></i><p class="name">stethoscope-line</p></li><li class="class-icon"><i class="ri-sticky-note-2-fill"></i><p class="name">sticky-note-2-fill</p></li><li class="class-icon"><i class="ri-sticky-note-2-line"></i><p class="name">sticky-note-2-line</p></li><li class="class-icon"><i class="ri-sticky-note-fill"></i><p class="name">sticky-note-fill</p></li><li class="class-icon"><i class="ri-sticky-note-line"></i><p class="name">sticky-note-line</p></li><li class="class-icon"><i class="ri-stock-fill"></i><p class="name">stock-fill</p></li><li class="class-icon"><i class="ri-stock-line"></i><p class="name">stock-line</p></li><li class="class-icon"><i class="ri-stop-circle-fill"></i><p class="name">stop-circle-fill</p></li><li class="class-icon"><i class="ri-stop-circle-line"></i><p class="name">stop-circle-line</p></li><li class="class-icon"><i class="ri-stop-fill"></i><p class="name">stop-fill</p></li><li class="class-icon"><i class="ri-stop-line"></i><p class="name">stop-line</p></li><li class="class-icon"><i class="ri-stop-mini-fill"></i><p class="name">stop-mini-fill</p></li><li class="class-icon"><i class="ri-stop-mini-line"></i><p class="name">stop-mini-line</p></li><li class="class-icon"><i class="ri-store-2-fill"></i><p class="name">store-2-fill</p></li><li class="class-icon"><i class="ri-store-2-line"></i><p class="name">store-2-line</p></li><li class="class-icon"><i class="ri-store-3-fill"></i><p class="name">store-3-fill</p></li><li class="class-icon"><i class="ri-store-3-line"></i><p class="name">store-3-line</p></li><li class="class-icon"><i class="ri-store-fill"></i><p class="name">store-fill</p></li><li class="class-icon"><i class="ri-store-line"></i><p class="name">store-line</p></li><li class="class-icon"><i class="ri-strikethrough-2"></i><p class="name">strikethrough-2</p></li><li class="class-icon"><i class="ri-strikethrough"></i><p class="name">strikethrough</p></li><li class="class-icon"><i class="ri-subscript-2"></i><p class="name">subscript-2</p></li><li class="class-icon"><i class="ri-subscript"></i><p class="name">subscript</p></li><li class="class-icon"><i class="ri-subtract-fill"></i><p class="name">subtract-fill</p></li><li class="class-icon"><i class="ri-subtract-line"></i><p class="name">subtract-line</p></li><li class="class-icon"><i class="ri-subway-fill"></i><p class="name">subway-fill</p></li><li class="class-icon"><i class="ri-subway-line"></i><p class="name">subway-line</p></li><li class="class-icon"><i class="ri-subway-wifi-fill"></i><p class="name">subway-wifi-fill</p></li><li class="class-icon"><i class="ri-subway-wifi-line"></i><p class="name">subway-wifi-line</p></li><li class="class-icon"><i class="ri-suitcase-2-fill"></i><p class="name">suitcase-2-fill</p></li><li class="class-icon"><i class="ri-suitcase-2-line"></i><p class="name">suitcase-2-line</p></li><li class="class-icon"><i class="ri-suitcase-3-fill"></i><p class="name">suitcase-3-fill</p></li><li class="class-icon"><i class="ri-suitcase-3-line"></i><p class="name">suitcase-3-line</p></li><li class="class-icon"><i class="ri-suitcase-fill"></i><p class="name">suitcase-fill</p></li><li class="class-icon"><i class="ri-suitcase-line"></i><p class="name">suitcase-line</p></li><li class="class-icon"><i class="ri-sun-cloudy-fill"></i><p class="name">sun-cloudy-fill</p></li><li class="class-icon"><i class="ri-sun-cloudy-line"></i><p class="name">sun-cloudy-line</p></li><li class="class-icon"><i class="ri-sun-fill"></i><p class="name">sun-fill</p></li><li class="class-icon"><i class="ri-sun-foggy-fill"></i><p class="name">sun-foggy-fill</p></li><li class="class-icon"><i class="ri-sun-foggy-line"></i><p class="name">sun-foggy-line</p></li><li class="class-icon"><i class="ri-sun-line"></i><p class="name">sun-line</p></li><li class="class-icon"><i class="ri-superscript-2"></i><p class="name">superscript-2</p></li><li class="class-icon"><i class="ri-superscript"></i><p class="name">superscript</p></li><li class="class-icon"><i class="ri-surgical-mask-fill"></i><p class="name">surgical-mask-fill</p></li><li class="class-icon"><i class="ri-surgical-mask-line"></i><p class="name">surgical-mask-line</p></li><li class="class-icon"><i class="ri-surround-sound-fill"></i><p class="name">surround-sound-fill</p></li><li class="class-icon"><i class="ri-surround-sound-line"></i><p class="name">surround-sound-line</p></li><li class="class-icon"><i class="ri-survey-fill"></i><p class="name">survey-fill</p></li><li class="class-icon"><i class="ri-survey-line"></i><p class="name">survey-line</p></li><li class="class-icon"><i class="ri-swap-box-fill"></i><p class="name">swap-box-fill</p></li><li class="class-icon"><i class="ri-swap-box-line"></i><p class="name">swap-box-line</p></li><li class="class-icon"><i class="ri-swap-fill"></i><p class="name">swap-fill</p></li><li class="class-icon"><i class="ri-swap-line"></i><p class="name">swap-line</p></li><li class="class-icon"><i class="ri-switch-fill"></i><p class="name">switch-fill</p></li><li class="class-icon"><i class="ri-switch-line"></i><p class="name">switch-line</p></li><li class="class-icon"><i class="ri-sword-fill"></i><p class="name">sword-fill</p></li><li class="class-icon"><i class="ri-sword-line"></i><p class="name">sword-line</p></li><li class="class-icon"><i class="ri-syringe-fill"></i><p class="name">syringe-fill</p></li><li class="class-icon"><i class="ri-syringe-line"></i><p class="name">syringe-line</p></li><li class="class-icon"><i class="ri-t-box-fill"></i><p class="name">t-box-fill</p></li><li class="class-icon"><i class="ri-t-box-line"></i><p class="name">t-box-line</p></li><li class="class-icon"><i class="ri-t-shirt-2-fill"></i><p class="name">t-shirt-2-fill</p></li><li class="class-icon"><i class="ri-t-shirt-2-line"></i><p class="name">t-shirt-2-line</p></li><li class="class-icon"><i class="ri-t-shirt-air-fill"></i><p class="name">t-shirt-air-fill</p></li><li class="class-icon"><i class="ri-t-shirt-air-line"></i><p class="name">t-shirt-air-line</p></li><li class="class-icon"><i class="ri-t-shirt-fill"></i><p class="name">t-shirt-fill</p></li><li class="class-icon"><i class="ri-t-shirt-line"></i><p class="name">t-shirt-line</p></li><li class="class-icon"><i class="ri-table-2"></i><p class="name">table-2</p></li><li class="class-icon"><i class="ri-table-alt-fill"></i><p class="name">table-alt-fill</p></li><li class="class-icon"><i class="ri-table-alt-line"></i><p class="name">table-alt-line</p></li><li class="class-icon"><i class="ri-table-fill"></i><p class="name">table-fill</p></li><li class="class-icon"><i class="ri-table-line"></i><p class="name">table-line</p></li><li class="class-icon"><i class="ri-tablet-fill"></i><p class="name">tablet-fill</p></li><li class="class-icon"><i class="ri-tablet-line"></i><p class="name">tablet-line</p></li><li class="class-icon"><i class="ri-takeaway-fill"></i><p class="name">takeaway-fill</p></li><li class="class-icon"><i class="ri-takeaway-line"></i><p class="name">takeaway-line</p></li><li class="class-icon"><i class="ri-taobao-fill"></i><p class="name">taobao-fill</p></li><li class="class-icon"><i class="ri-taobao-line"></i><p class="name">taobao-line</p></li><li class="class-icon"><i class="ri-tape-fill"></i><p class="name">tape-fill</p></li><li class="class-icon"><i class="ri-tape-line"></i><p class="name">tape-line</p></li><li class="class-icon"><i class="ri-task-fill"></i><p class="name">task-fill</p></li><li class="class-icon"><i class="ri-task-line"></i><p class="name">task-line</p></li><li class="class-icon"><i class="ri-taxi-fill"></i><p class="name">taxi-fill</p></li><li class="class-icon"><i class="ri-taxi-line"></i><p class="name">taxi-line</p></li><li class="class-icon"><i class="ri-taxi-wifi-fill"></i><p class="name">taxi-wifi-fill</p></li><li class="class-icon"><i class="ri-taxi-wifi-line"></i><p class="name">taxi-wifi-line</p></li><li class="class-icon"><i class="ri-team-fill"></i><p class="name">team-fill</p></li><li class="class-icon"><i class="ri-team-line"></i><p class="name">team-line</p></li><li class="class-icon"><i class="ri-telegram-fill"></i><p class="name">telegram-fill</p></li><li class="class-icon"><i class="ri-telegram-line"></i><p class="name">telegram-line</p></li><li class="class-icon"><i class="ri-temp-cold-fill"></i><p class="name">temp-cold-fill</p></li><li class="class-icon"><i class="ri-temp-cold-line"></i><p class="name">temp-cold-line</p></li><li class="class-icon"><i class="ri-temp-hot-fill"></i><p class="name">temp-hot-fill</p></li><li class="class-icon"><i class="ri-temp-hot-line"></i><p class="name">temp-hot-line</p></li><li class="class-icon"><i class="ri-terminal-box-fill"></i><p class="name">terminal-box-fill</p></li><li class="class-icon"><i class="ri-terminal-box-line"></i><p class="name">terminal-box-line</p></li><li class="class-icon"><i class="ri-terminal-fill"></i><p class="name">terminal-fill</p></li><li class="class-icon"><i class="ri-terminal-line"></i><p class="name">terminal-line</p></li><li class="class-icon"><i class="ri-terminal-window-fill"></i><p class="name">terminal-window-fill</p></li><li class="class-icon"><i class="ri-terminal-window-line"></i><p class="name">terminal-window-line</p></li><li class="class-icon"><i class="ri-test-tube-fill"></i><p class="name">test-tube-fill</p></li><li class="class-icon"><i class="ri-test-tube-line"></i><p class="name">test-tube-line</p></li><li class="class-icon"><i class="ri-text-direction-l"></i><p class="name">text-direction-l</p></li><li class="class-icon"><i class="ri-text-direction-r"></i><p class="name">text-direction-r</p></li><li class="class-icon"><i class="ri-text-spacing"></i><p class="name">text-spacing</p></li><li class="class-icon"><i class="ri-text-wrap"></i><p class="name">text-wrap</p></li><li class="class-icon"><i class="ri-text"></i><p class="name">text</p></li><li class="class-icon"><i class="ri-thermometer-fill"></i><p class="name">thermometer-fill</p></li><li class="class-icon"><i class="ri-thermometer-line"></i><p class="name">thermometer-line</p></li><li class="class-icon"><i class="ri-thumb-down-fill"></i><p class="name">thumb-down-fill</p></li><li class="class-icon"><i class="ri-thumb-down-line"></i><p class="name">thumb-down-line</p></li><li class="class-icon"><i class="ri-thumb-up-fill"></i><p class="name">thumb-up-fill</p></li><li class="class-icon"><i class="ri-thumb-up-line"></i><p class="name">thumb-up-line</p></li><li class="class-icon"><i class="ri-thunderstorms-fill"></i><p class="name">thunderstorms-fill</p></li><li class="class-icon"><i class="ri-thunderstorms-line"></i><p class="name">thunderstorms-line</p></li><li class="class-icon"><i class="ri-ticket-2-fill"></i><p class="name">ticket-2-fill</p></li><li class="class-icon"><i class="ri-ticket-2-line"></i><p class="name">ticket-2-line</p></li><li class="class-icon"><i class="ri-ticket-fill"></i><p class="name">ticket-fill</p></li><li class="class-icon"><i class="ri-ticket-line"></i><p class="name">ticket-line</p></li><li class="class-icon"><i class="ri-time-fill"></i><p class="name">time-fill</p></li><li class="class-icon"><i class="ri-time-line"></i><p class="name">time-line</p></li><li class="class-icon"><i class="ri-timer-2-fill"></i><p class="name">timer-2-fill</p></li><li class="class-icon"><i class="ri-timer-2-line"></i><p class="name">timer-2-line</p></li><li class="class-icon"><i class="ri-timer-fill"></i><p class="name">timer-fill</p></li><li class="class-icon"><i class="ri-timer-flash-fill"></i><p class="name">timer-flash-fill</p></li><li class="class-icon"><i class="ri-timer-flash-line"></i><p class="name">timer-flash-line</p></li><li class="class-icon"><i class="ri-timer-line"></i><p class="name">timer-line</p></li><li class="class-icon"><i class="ri-todo-fill"></i><p class="name">todo-fill</p></li><li class="class-icon"><i class="ri-todo-line"></i><p class="name">todo-line</p></li><li class="class-icon"><i class="ri-toggle-fill"></i><p class="name">toggle-fill</p></li><li class="class-icon"><i class="ri-toggle-line"></i><p class="name">toggle-line</p></li><li class="class-icon"><i class="ri-tools-fill"></i><p class="name">tools-fill</p></li><li class="class-icon"><i class="ri-tools-line"></i><p class="name">tools-line</p></li><li class="class-icon"><i class="ri-tornado-fill"></i><p class="name">tornado-fill</p></li><li class="class-icon"><i class="ri-tornado-line"></i><p class="name">tornado-line</p></li><li class="class-icon"><i class="ri-trademark-fill"></i><p class="name">trademark-fill</p></li><li class="class-icon"><i class="ri-trademark-line"></i><p class="name">trademark-line</p></li><li class="class-icon"><i class="ri-traffic-light-fill"></i><p class="name">traffic-light-fill</p></li><li class="class-icon"><i class="ri-traffic-light-line"></i><p class="name">traffic-light-line</p></li><li class="class-icon"><i class="ri-train-fill"></i><p class="name">train-fill</p></li><li class="class-icon"><i class="ri-train-line"></i><p class="name">train-line</p></li><li class="class-icon"><i class="ri-train-wifi-fill"></i><p class="name">train-wifi-fill</p></li><li class="class-icon"><i class="ri-train-wifi-line"></i><p class="name">train-wifi-line</p></li><li class="class-icon"><i class="ri-translate-2"></i><p class="name">translate-2</p></li><li class="class-icon"><i class="ri-translate"></i><p class="name">translate</p></li><li class="class-icon"><i class="ri-travesti-fill"></i><p class="name">travesti-fill</p></li><li class="class-icon"><i class="ri-travesti-line"></i><p class="name">travesti-line</p></li><li class="class-icon"><i class="ri-treasure-map-fill"></i><p class="name">treasure-map-fill</p></li><li class="class-icon"><i class="ri-treasure-map-line"></i><p class="name">treasure-map-line</p></li><li class="class-icon"><i class="ri-trello-fill"></i><p class="name">trello-fill</p></li><li class="class-icon"><i class="ri-trello-line"></i><p class="name">trello-line</p></li><li class="class-icon"><i class="ri-trophy-fill"></i><p class="name">trophy-fill</p></li><li class="class-icon"><i class="ri-trophy-line"></i><p class="name">trophy-line</p></li><li class="class-icon"><i class="ri-truck-fill"></i><p class="name">truck-fill</p></li><li class="class-icon"><i class="ri-truck-line"></i><p class="name">truck-line</p></li><li class="class-icon"><i class="ri-tumblr-fill"></i><p class="name">tumblr-fill</p></li><li class="class-icon"><i class="ri-tumblr-line"></i><p class="name">tumblr-line</p></li><li class="class-icon"><i class="ri-tv-2-fill"></i><p class="name">tv-2-fill</p></li><li class="class-icon"><i class="ri-tv-2-line"></i><p class="name">tv-2-line</p></li><li class="class-icon"><i class="ri-tv-fill"></i><p class="name">tv-fill</p></li><li class="class-icon"><i class="ri-tv-line"></i><p class="name">tv-line</p></li><li class="class-icon"><i class="ri-twitch-fill"></i><p class="name">twitch-fill</p></li><li class="class-icon"><i class="ri-twitch-line"></i><p class="name">twitch-line</p></li><li class="class-icon"><i class="ri-twitter-fill"></i><p class="name">twitter-fill</p></li><li class="class-icon"><i class="ri-twitter-line"></i><p class="name">twitter-line</p></li><li class="class-icon"><i class="ri-typhoon-fill"></i><p class="name">typhoon-fill</p></li><li class="class-icon"><i class="ri-typhoon-line"></i><p class="name">typhoon-line</p></li><li class="class-icon"><i class="ri-u-disk-fill"></i><p class="name">u-disk-fill</p></li><li class="class-icon"><i class="ri-u-disk-line"></i><p class="name">u-disk-line</p></li><li class="class-icon"><i class="ri-ubuntu-fill"></i><p class="name">ubuntu-fill</p></li><li class="class-icon"><i class="ri-ubuntu-line"></i><p class="name">ubuntu-line</p></li><li class="class-icon"><i class="ri-umbrella-fill"></i><p class="name">umbrella-fill</p></li><li class="class-icon"><i class="ri-umbrella-line"></i><p class="name">umbrella-line</p></li><li class="class-icon"><i class="ri-underline"></i><p class="name">underline</p></li><li class="class-icon"><i class="ri-uninstall-fill"></i><p class="name">uninstall-fill</p></li><li class="class-icon"><i class="ri-uninstall-line"></i><p class="name">uninstall-line</p></li><li class="class-icon"><i class="ri-unsplash-fill"></i><p class="name">unsplash-fill</p></li><li class="class-icon"><i class="ri-unsplash-line"></i><p class="name">unsplash-line</p></li><li class="class-icon"><i class="ri-upload-2-fill"></i><p class="name">upload-2-fill</p></li><li class="class-icon"><i class="ri-upload-2-line"></i><p class="name">upload-2-line</p></li><li class="class-icon"><i class="ri-upload-cloud-2-fill"></i><p class="name">upload-cloud-2-fill</p></li><li class="class-icon"><i class="ri-upload-cloud-2-line"></i><p class="name">upload-cloud-2-line</p></li><li class="class-icon"><i class="ri-upload-cloud-fill"></i><p class="name">upload-cloud-fill</p></li><li class="class-icon"><i class="ri-upload-cloud-line"></i><p class="name">upload-cloud-line</p></li><li class="class-icon"><i class="ri-upload-fill"></i><p class="name">upload-fill</p></li><li class="class-icon"><i class="ri-upload-line"></i><p class="name">upload-line</p></li><li class="class-icon"><i class="ri-usb-fill"></i><p class="name">usb-fill</p></li><li class="class-icon"><i class="ri-usb-line"></i><p class="name">usb-line</p></li><li class="class-icon"><i class="ri-user-2-fill"></i><p class="name">user-2-fill</p></li><li class="class-icon"><i class="ri-user-2-line"></i><p class="name">user-2-line</p></li><li class="class-icon"><i class="ri-user-3-fill"></i><p class="name">user-3-fill</p></li><li class="class-icon"><i class="ri-user-3-line"></i><p class="name">user-3-line</p></li><li class="class-icon"><i class="ri-user-4-fill"></i><p class="name">user-4-fill</p></li><li class="class-icon"><i class="ri-user-4-line"></i><p class="name">user-4-line</p></li><li class="class-icon"><i class="ri-user-5-fill"></i><p class="name">user-5-fill</p></li><li class="class-icon"><i class="ri-user-5-line"></i><p class="name">user-5-line</p></li><li class="class-icon"><i class="ri-user-6-fill"></i><p class="name">user-6-fill</p></li><li class="class-icon"><i class="ri-user-6-line"></i><p class="name">user-6-line</p></li><li class="class-icon"><i class="ri-user-add-fill"></i><p class="name">user-add-fill</p></li><li class="class-icon"><i class="ri-user-add-line"></i><p class="name">user-add-line</p></li><li class="class-icon"><i class="ri-user-fill"></i><p class="name">user-fill</p></li><li class="class-icon"><i class="ri-user-follow-fill"></i><p class="name">user-follow-fill</p></li><li class="class-icon"><i class="ri-user-follow-line"></i><p class="name">user-follow-line</p></li><li class="class-icon"><i class="ri-user-heart-fill"></i><p class="name">user-heart-fill</p></li><li class="class-icon"><i class="ri-user-heart-line"></i><p class="name">user-heart-line</p></li><li class="class-icon"><i class="ri-user-line"></i><p class="name">user-line</p></li><li class="class-icon"><i class="ri-user-location-fill"></i><p class="name">user-location-fill</p></li><li class="class-icon"><i class="ri-user-location-line"></i><p class="name">user-location-line</p></li><li class="class-icon"><i class="ri-user-received-2-fill"></i><p class="name">user-received-2-fill</p></li><li class="class-icon"><i class="ri-user-received-2-line"></i><p class="name">user-received-2-line</p></li><li class="class-icon"><i class="ri-user-received-fill"></i><p class="name">user-received-fill</p></li><li class="class-icon"><i class="ri-user-received-line"></i><p class="name">user-received-line</p></li><li class="class-icon"><i class="ri-user-search-fill"></i><p class="name">user-search-fill</p></li><li class="class-icon"><i class="ri-user-search-line"></i><p class="name">user-search-line</p></li><li class="class-icon"><i class="ri-user-settings-fill"></i><p class="name">user-settings-fill</p></li><li class="class-icon"><i class="ri-user-settings-line"></i><p class="name">user-settings-line</p></li><li class="class-icon"><i class="ri-user-shared-2-fill"></i><p class="name">user-shared-2-fill</p></li><li class="class-icon"><i class="ri-user-shared-2-line"></i><p class="name">user-shared-2-line</p></li><li class="class-icon"><i class="ri-user-shared-fill"></i><p class="name">user-shared-fill</p></li><li class="class-icon"><i class="ri-user-shared-line"></i><p class="name">user-shared-line</p></li><li class="class-icon"><i class="ri-user-smile-fill"></i><p class="name">user-smile-fill</p></li><li class="class-icon"><i class="ri-user-smile-line"></i><p class="name">user-smile-line</p></li><li class="class-icon"><i class="ri-user-star-fill"></i><p class="name">user-star-fill</p></li><li class="class-icon"><i class="ri-user-star-line"></i><p class="name">user-star-line</p></li><li class="class-icon"><i class="ri-user-unfollow-fill"></i><p class="name">user-unfollow-fill</p></li><li class="class-icon"><i class="ri-user-unfollow-line"></i><p class="name">user-unfollow-line</p></li><li class="class-icon"><i class="ri-user-voice-fill"></i><p class="name">user-voice-fill</p></li><li class="class-icon"><i class="ri-user-voice-line"></i><p class="name">user-voice-line</p></li><li class="class-icon"><i class="ri-video-add-fill"></i><p class="name">video-add-fill</p></li><li class="class-icon"><i class="ri-video-add-line"></i><p class="name">video-add-line</p></li><li class="class-icon"><i class="ri-video-chat-fill"></i><p class="name">video-chat-fill</p></li><li class="class-icon"><i class="ri-video-chat-line"></i><p class="name">video-chat-line</p></li><li class="class-icon"><i class="ri-video-download-fill"></i><p class="name">video-download-fill</p></li><li class="class-icon"><i class="ri-video-download-line"></i><p class="name">video-download-line</p></li><li class="class-icon"><i class="ri-video-fill"></i><p class="name">video-fill</p></li><li class="class-icon"><i class="ri-video-line"></i><p class="name">video-line</p></li><li class="class-icon"><i class="ri-video-upload-fill"></i><p class="name">video-upload-fill</p></li><li class="class-icon"><i class="ri-video-upload-line"></i><p class="name">video-upload-line</p></li><li class="class-icon"><i class="ri-vidicon-2-fill"></i><p class="name">vidicon-2-fill</p></li><li class="class-icon"><i class="ri-vidicon-2-line"></i><p class="name">vidicon-2-line</p></li><li class="class-icon"><i class="ri-vidicon-fill"></i><p class="name">vidicon-fill</p></li><li class="class-icon"><i class="ri-vidicon-line"></i><p class="name">vidicon-line</p></li><li class="class-icon"><i class="ri-vimeo-fill"></i><p class="name">vimeo-fill</p></li><li class="class-icon"><i class="ri-vimeo-line"></i><p class="name">vimeo-line</p></li><li class="class-icon"><i class="ri-vip-crown-2-fill"></i><p class="name">vip-crown-2-fill</p></li><li class="class-icon"><i class="ri-vip-crown-2-line"></i><p class="name">vip-crown-2-line</p></li><li class="class-icon"><i class="ri-vip-crown-fill"></i><p class="name">vip-crown-fill</p></li><li class="class-icon"><i class="ri-vip-crown-line"></i><p class="name">vip-crown-line</p></li><li class="class-icon"><i class="ri-vip-diamond-fill"></i><p class="name">vip-diamond-fill</p></li><li class="class-icon"><i class="ri-vip-diamond-line"></i><p class="name">vip-diamond-line</p></li><li class="class-icon"><i class="ri-vip-fill"></i><p class="name">vip-fill</p></li><li class="class-icon"><i class="ri-vip-line"></i><p class="name">vip-line</p></li><li class="class-icon"><i class="ri-virus-fill"></i><p class="name">virus-fill</p></li><li class="class-icon"><i class="ri-virus-line"></i><p class="name">virus-line</p></li><li class="class-icon"><i class="ri-visa-fill"></i><p class="name">visa-fill</p></li><li class="class-icon"><i class="ri-visa-line"></i><p class="name">visa-line</p></li><li class="class-icon"><i class="ri-voice-recognition-fill"></i><p class="name">voice-recognition-fill</p></li><li class="class-icon"><i class="ri-voice-recognition-line"></i><p class="name">voice-recognition-line</p></li><li class="class-icon"><i class="ri-voiceprint-fill"></i><p class="name">voiceprint-fill</p></li><li class="class-icon"><i class="ri-voiceprint-line"></i><p class="name">voiceprint-line</p></li><li class="class-icon"><i class="ri-volume-down-fill"></i><p class="name">volume-down-fill</p></li><li class="class-icon"><i class="ri-volume-down-line"></i><p class="name">volume-down-line</p></li><li class="class-icon"><i class="ri-volume-mute-fill"></i><p class="name">volume-mute-fill</p></li><li class="class-icon"><i class="ri-volume-mute-line"></i><p class="name">volume-mute-line</p></li><li class="class-icon"><i class="ri-volume-off-vibrate-fill"></i><p class="name">volume-off-vibrate-fill</p></li><li class="class-icon"><i class="ri-volume-off-vibrate-line"></i><p class="name">volume-off-vibrate-line</p></li><li class="class-icon"><i class="ri-volume-up-fill"></i><p class="name">volume-up-fill</p></li><li class="class-icon"><i class="ri-volume-up-line"></i><p class="name">volume-up-line</p></li><li class="class-icon"><i class="ri-volume-vibrate-fill"></i><p class="name">volume-vibrate-fill</p></li><li class="class-icon"><i class="ri-volume-vibrate-line"></i><p class="name">volume-vibrate-line</p></li><li class="class-icon"><i class="ri-vuejs-fill"></i><p class="name">vuejs-fill</p></li><li class="class-icon"><i class="ri-vuejs-line"></i><p class="name">vuejs-line</p></li><li class="class-icon"><i class="ri-walk-fill"></i><p class="name">walk-fill</p></li><li class="class-icon"><i class="ri-walk-line"></i><p class="name">walk-line</p></li><li class="class-icon"><i class="ri-wallet-2-fill"></i><p class="name">wallet-2-fill</p></li><li class="class-icon"><i class="ri-wallet-2-line"></i><p class="name">wallet-2-line</p></li><li class="class-icon"><i class="ri-wallet-3-fill"></i><p class="name">wallet-3-fill</p></li><li class="class-icon"><i class="ri-wallet-3-line"></i><p class="name">wallet-3-line</p></li><li class="class-icon"><i class="ri-wallet-fill"></i><p class="name">wallet-fill</p></li><li class="class-icon"><i class="ri-wallet-line"></i><p class="name">wallet-line</p></li><li class="class-icon"><i class="ri-water-flash-fill"></i><p class="name">water-flash-fill</p></li><li class="class-icon"><i class="ri-water-flash-line"></i><p class="name">water-flash-line</p></li><li class="class-icon"><i class="ri-webcam-fill"></i><p class="name">webcam-fill</p></li><li class="class-icon"><i class="ri-webcam-line"></i><p class="name">webcam-line</p></li><li class="class-icon"><i class="ri-wechat-2-fill"></i><p class="name">wechat-2-fill</p></li><li class="class-icon"><i class="ri-wechat-2-line"></i><p class="name">wechat-2-line</p></li><li class="class-icon"><i class="ri-wechat-fill"></i><p class="name">wechat-fill</p></li><li class="class-icon"><i class="ri-wechat-line"></i><p class="name">wechat-line</p></li><li class="class-icon"><i class="ri-wechat-pay-fill"></i><p class="name">wechat-pay-fill</p></li><li class="class-icon"><i class="ri-wechat-pay-line"></i><p class="name">wechat-pay-line</p></li><li class="class-icon"><i class="ri-weibo-fill"></i><p class="name">weibo-fill</p></li><li class="class-icon"><i class="ri-weibo-line"></i><p class="name">weibo-line</p></li><li class="class-icon"><i class="ri-whatsapp-fill"></i><p class="name">whatsapp-fill</p></li><li class="class-icon"><i class="ri-whatsapp-line"></i><p class="name">whatsapp-line</p></li><li class="class-icon"><i class="ri-wheelchair-fill"></i><p class="name">wheelchair-fill</p></li><li class="class-icon"><i class="ri-wheelchair-line"></i><p class="name">wheelchair-line</p></li><li class="class-icon"><i class="ri-wifi-fill"></i><p class="name">wifi-fill</p></li><li class="class-icon"><i class="ri-wifi-line"></i><p class="name">wifi-line</p></li><li class="class-icon"><i class="ri-wifi-off-fill"></i><p class="name">wifi-off-fill</p></li><li class="class-icon"><i class="ri-wifi-off-line"></i><p class="name">wifi-off-line</p></li><li class="class-icon"><i class="ri-window-2-fill"></i><p class="name">window-2-fill</p></li><li class="class-icon"><i class="ri-window-2-line"></i><p class="name">window-2-line</p></li><li class="class-icon"><i class="ri-window-fill"></i><p class="name">window-fill</p></li><li class="class-icon"><i class="ri-window-line"></i><p class="name">window-line</p></li><li class="class-icon"><i class="ri-windows-fill"></i><p class="name">windows-fill</p></li><li class="class-icon"><i class="ri-windows-line"></i><p class="name">windows-line</p></li><li class="class-icon"><i class="ri-windy-fill"></i><p class="name">windy-fill</p></li><li class="class-icon"><i class="ri-windy-line"></i><p class="name">windy-line</p></li><li class="class-icon"><i class="ri-wireless-charging-fill"></i><p class="name">wireless-charging-fill</p></li><li class="class-icon"><i class="ri-wireless-charging-line"></i><p class="name">wireless-charging-line</p></li><li class="class-icon"><i class="ri-women-fill"></i><p class="name">women-fill</p></li><li class="class-icon"><i class="ri-women-line"></i><p class="name">women-line</p></li><li class="class-icon"><i class="ri-wubi-input"></i><p class="name">wubi-input</p></li><li class="class-icon"><i class="ri-xbox-fill"></i><p class="name">xbox-fill</p></li><li class="class-icon"><i class="ri-xbox-line"></i><p class="name">xbox-line</p></li><li class="class-icon"><i class="ri-xing-fill"></i><p class="name">xing-fill</p></li><li class="class-icon"><i class="ri-xing-line"></i><p class="name">xing-line</p></li><li class="class-icon"><i class="ri-youtube-fill"></i><p class="name">youtube-fill</p></li><li class="class-icon"><i class="ri-youtube-line"></i><p class="name">youtube-line</p></li><li class="class-icon"><i class="ri-zcool-fill"></i><p class="name">zcool-fill</p></li><li class="class-icon"><i class="ri-zcool-line"></i><p class="name">zcool-line</p></li><li class="class-icon"><i class="ri-zhihu-fill"></i><p class="name">zhihu-fill</p></li><li class="class-icon"><i class="ri-zhihu-line"></i><p class="name">zhihu-line</p></li><li class="class-icon"><i class="ri-zoom-in-fill"></i><p class="name">zoom-in-fill</p></li><li class="class-icon"><i class="ri-zoom-in-line"></i><p class="name">zoom-in-line</p></li><li class="class-icon"><i class="ri-zoom-out-fill"></i><p class="name">zoom-out-fill</p></li><li class="class-icon"><i class="ri-zoom-out-line"></i><p class="name">zoom-out-line</p></li><li class="class-icon"><i class="ri-zzz-fill"></i><p class="name">zzz-fill</p></li><li class="class-icon"><i class="ri-zzz-line"></i><p class="name">zzz-line</p></li><li class="class-icon"><i class="ri-arrow-down-double-fill"></i><p class="name">arrow-down-double-fill</p></li><li class="class-icon"><i class="ri-arrow-down-double-line"></i><p class="name">arrow-down-double-line</p></li><li class="class-icon"><i class="ri-arrow-left-double-fill"></i><p class="name">arrow-left-double-fill</p></li><li class="class-icon"><i class="ri-arrow-left-double-line"></i><p class="name">arrow-left-double-line</p></li><li class="class-icon"><i class="ri-arrow-right-double-fill"></i><p class="name">arrow-right-double-fill</p></li><li class="class-icon"><i class="ri-arrow-right-double-line"></i><p class="name">arrow-right-double-line</p></li><li class="class-icon"><i class="ri-arrow-turn-back-fill"></i><p class="name">arrow-turn-back-fill</p></li><li class="class-icon"><i class="ri-arrow-turn-back-line"></i><p class="name">arrow-turn-back-line</p></li><li class="class-icon"><i class="ri-arrow-turn-forward-fill"></i><p class="name">arrow-turn-forward-fill</p></li><li class="class-icon"><i class="ri-arrow-turn-forward-line"></i><p class="name">arrow-turn-forward-line</p></li><li class="class-icon"><i class="ri-arrow-up-double-fill"></i><p class="name">arrow-up-double-fill</p></li><li class="class-icon"><i class="ri-arrow-up-double-line"></i><p class="name">arrow-up-double-line</p></li><li class="class-icon"><i class="ri-bard-fill"></i><p class="name">bard-fill</p></li><li class="class-icon"><i class="ri-bard-line"></i><p class="name">bard-line</p></li><li class="class-icon"><i class="ri-bootstrap-fill"></i><p class="name">bootstrap-fill</p></li><li class="class-icon"><i class="ri-bootstrap-line"></i><p class="name">bootstrap-line</p></li><li class="class-icon"><i class="ri-box-1-fill"></i><p class="name">box-1-fill</p></li><li class="class-icon"><i class="ri-box-1-line"></i><p class="name">box-1-line</p></li><li class="class-icon"><i class="ri-box-2-fill"></i><p class="name">box-2-fill</p></li><li class="class-icon"><i class="ri-box-2-line"></i><p class="name">box-2-line</p></li><li class="class-icon"><i class="ri-box-3-fill"></i><p class="name">box-3-fill</p></li><li class="class-icon"><i class="ri-box-3-line"></i><p class="name">box-3-line</p></li><li class="class-icon"><i class="ri-brain-fill"></i><p class="name">brain-fill</p></li><li class="class-icon"><i class="ri-brain-line"></i><p class="name">brain-line</p></li><li class="class-icon"><i class="ri-candle-fill"></i><p class="name">candle-fill</p></li><li class="class-icon"><i class="ri-candle-line"></i><p class="name">candle-line</p></li><li class="class-icon"><i class="ri-cash-fill"></i><p class="name">cash-fill</p></li><li class="class-icon"><i class="ri-cash-line"></i><p class="name">cash-line</p></li><li class="class-icon"><i class="ri-contract-left-fill"></i><p class="name">contract-left-fill</p></li><li class="class-icon"><i class="ri-contract-left-line"></i><p class="name">contract-left-line</p></li><li class="class-icon"><i class="ri-contract-left-right-fill"></i><p class="name">contract-left-right-fill</p></li><li class="class-icon"><i class="ri-contract-left-right-line"></i><p class="name">contract-left-right-line</p></li><li class="class-icon"><i class="ri-contract-right-fill"></i><p class="name">contract-right-fill</p></li><li class="class-icon"><i class="ri-contract-right-line"></i><p class="name">contract-right-line</p></li><li class="class-icon"><i class="ri-contract-up-down-fill"></i><p class="name">contract-up-down-fill</p></li><li class="class-icon"><i class="ri-contract-up-down-line"></i><p class="name">contract-up-down-line</p></li><li class="class-icon"><i class="ri-copilot-fill"></i><p class="name">copilot-fill</p></li><li class="class-icon"><i class="ri-copilot-line"></i><p class="name">copilot-line</p></li><li class="class-icon"><i class="ri-corner-down-left-fill"></i><p class="name">corner-down-left-fill</p></li><li class="class-icon"><i class="ri-corner-down-left-line"></i><p class="name">corner-down-left-line</p></li><li class="class-icon"><i class="ri-corner-down-right-fill"></i><p class="name">corner-down-right-fill</p></li><li class="class-icon"><i class="ri-corner-down-right-line"></i><p class="name">corner-down-right-line</p></li><li class="class-icon"><i class="ri-corner-left-down-fill"></i><p class="name">corner-left-down-fill</p></li><li class="class-icon"><i class="ri-corner-left-down-line"></i><p class="name">corner-left-down-line</p></li><li class="class-icon"><i class="ri-corner-left-up-fill"></i><p class="name">corner-left-up-fill</p></li><li class="class-icon"><i class="ri-corner-left-up-line"></i><p class="name">corner-left-up-line</p></li><li class="class-icon"><i class="ri-corner-right-down-fill"></i><p class="name">corner-right-down-fill</p></li><li class="class-icon"><i class="ri-corner-right-down-line"></i><p class="name">corner-right-down-line</p></li><li class="class-icon"><i class="ri-corner-right-up-fill"></i><p class="name">corner-right-up-fill</p></li><li class="class-icon"><i class="ri-corner-right-up-line"></i><p class="name">corner-right-up-line</p></li><li class="class-icon"><i class="ri-corner-up-left-double-fill"></i><p class="name">corner-up-left-double-fill</p></li><li class="class-icon"><i class="ri-corner-up-left-double-line"></i><p class="name">corner-up-left-double-line</p></li><li class="class-icon"><i class="ri-corner-up-left-fill"></i><p class="name">corner-up-left-fill</p></li><li class="class-icon"><i class="ri-corner-up-left-line"></i><p class="name">corner-up-left-line</p></li><li class="class-icon"><i class="ri-corner-up-right-double-fill"></i><p class="name">corner-up-right-double-fill</p></li><li class="class-icon"><i class="ri-corner-up-right-double-line"></i><p class="name">corner-up-right-double-line</p></li><li class="class-icon"><i class="ri-corner-up-right-fill"></i><p class="name">corner-up-right-fill</p></li><li class="class-icon"><i class="ri-corner-up-right-line"></i><p class="name">corner-up-right-line</p></li><li class="class-icon"><i class="ri-cross-fill"></i><p class="name">cross-fill</p></li><li class="class-icon"><i class="ri-cross-line"></i><p class="name">cross-line</p></li><li class="class-icon"><i class="ri-edge-new-fill"></i><p class="name">edge-new-fill</p></li><li class="class-icon"><i class="ri-edge-new-line"></i><p class="name">edge-new-line</p></li><li class="class-icon"><i class="ri-equal-fill"></i><p class="name">equal-fill</p></li><li class="class-icon"><i class="ri-equal-line"></i><p class="name">equal-line</p></li><li class="class-icon"><i class="ri-expand-left-fill"></i><p class="name">expand-left-fill</p></li><li class="class-icon"><i class="ri-expand-left-line"></i><p class="name">expand-left-line</p></li><li class="class-icon"><i class="ri-expand-left-right-fill"></i><p class="name">expand-left-right-fill</p></li><li class="class-icon"><i class="ri-expand-left-right-line"></i><p class="name">expand-left-right-line</p></li><li class="class-icon"><i class="ri-expand-right-fill"></i><p class="name">expand-right-fill</p></li><li class="class-icon"><i class="ri-expand-right-line"></i><p class="name">expand-right-line</p></li><li class="class-icon"><i class="ri-expand-up-down-fill"></i><p class="name">expand-up-down-fill</p></li><li class="class-icon"><i class="ri-expand-up-down-line"></i><p class="name">expand-up-down-line</p></li><li class="class-icon"><i class="ri-flickr-fill"></i><p class="name">flickr-fill</p></li><li class="class-icon"><i class="ri-flickr-line"></i><p class="name">flickr-line</p></li><li class="class-icon"><i class="ri-forward-10-fill"></i><p class="name">forward-10-fill</p></li><li class="class-icon"><i class="ri-forward-10-line"></i><p class="name">forward-10-line</p></li><li class="class-icon"><i class="ri-forward-15-fill"></i><p class="name">forward-15-fill</p></li><li class="class-icon"><i class="ri-forward-15-line"></i><p class="name">forward-15-line</p></li><li class="class-icon"><i class="ri-forward-30-fill"></i><p class="name">forward-30-fill</p></li><li class="class-icon"><i class="ri-forward-30-line"></i><p class="name">forward-30-line</p></li><li class="class-icon"><i class="ri-forward-5-fill"></i><p class="name">forward-5-fill</p></li><li class="class-icon"><i class="ri-forward-5-line"></i><p class="name">forward-5-line</p></li><li class="class-icon"><i class="ri-graduation-cap-fill"></i><p class="name">graduation-cap-fill</p></li><li class="class-icon"><i class="ri-graduation-cap-line"></i><p class="name">graduation-cap-line</p></li><li class="class-icon"><i class="ri-home-office-fill"></i><p class="name">home-office-fill</p></li><li class="class-icon"><i class="ri-home-office-line"></i><p class="name">home-office-line</p></li><li class="class-icon"><i class="ri-hourglass-2-fill"></i><p class="name">hourglass-2-fill</p></li><li class="class-icon"><i class="ri-hourglass-2-line"></i><p class="name">hourglass-2-line</p></li><li class="class-icon"><i class="ri-hourglass-fill"></i><p class="name">hourglass-fill</p></li><li class="class-icon"><i class="ri-hourglass-line"></i><p class="name">hourglass-line</p></li><li class="class-icon"><i class="ri-javascript-fill"></i><p class="name">javascript-fill</p></li><li class="class-icon"><i class="ri-javascript-line"></i><p class="name">javascript-line</p></li><li class="class-icon"><i class="ri-loop-left-fill"></i><p class="name">loop-left-fill</p></li><li class="class-icon"><i class="ri-loop-left-line"></i><p class="name">loop-left-line</p></li><li class="class-icon"><i class="ri-loop-right-fill"></i><p class="name">loop-right-fill</p></li><li class="class-icon"><i class="ri-loop-right-line"></i><p class="name">loop-right-line</p></li><li class="class-icon"><i class="ri-memories-fill"></i><p class="name">memories-fill</p></li><li class="class-icon"><i class="ri-memories-line"></i><p class="name">memories-line</p></li><li class="class-icon"><i class="ri-meta-fill"></i><p class="name">meta-fill</p></li><li class="class-icon"><i class="ri-meta-line"></i><p class="name">meta-line</p></li><li class="class-icon"><i class="ri-microsoft-loop-fill"></i><p class="name">microsoft-loop-fill</p></li><li class="class-icon"><i class="ri-microsoft-loop-line"></i><p class="name">microsoft-loop-line</p></li><li class="class-icon"><i class="ri-nft-fill"></i><p class="name">nft-fill</p></li><li class="class-icon"><i class="ri-nft-line"></i><p class="name">nft-line</p></li><li class="class-icon"><i class="ri-notion-fill"></i><p class="name">notion-fill</p></li><li class="class-icon"><i class="ri-notion-line"></i><p class="name">notion-line</p></li><li class="class-icon"><i class="ri-openai-fill"></i><p class="name">openai-fill</p></li><li class="class-icon"><i class="ri-openai-line"></i><p class="name">openai-line</p></li><li class="class-icon"><i class="ri-overline"></i><p class="name">overline</p></li><li class="class-icon"><i class="ri-p2p-fill"></i><p class="name">p2p-fill</p></li><li class="class-icon"><i class="ri-p2p-line"></i><p class="name">p2p-line</p></li><li class="class-icon"><i class="ri-presentation-fill"></i><p class="name">presentation-fill</p></li><li class="class-icon"><i class="ri-presentation-line"></i><p class="name">presentation-line</p></li><li class="class-icon"><i class="ri-replay-10-fill"></i><p class="name">replay-10-fill</p></li><li class="class-icon"><i class="ri-replay-10-line"></i><p class="name">replay-10-line</p></li><li class="class-icon"><i class="ri-replay-15-fill"></i><p class="name">replay-15-fill</p></li><li class="class-icon"><i class="ri-replay-15-line"></i><p class="name">replay-15-line</p></li><li class="class-icon"><i class="ri-replay-30-fill"></i><p class="name">replay-30-fill</p></li><li class="class-icon"><i class="ri-replay-30-line"></i><p class="name">replay-30-line</p></li><li class="class-icon"><i class="ri-replay-5-fill"></i><p class="name">replay-5-fill</p></li><li class="class-icon"><i class="ri-replay-5-line"></i><p class="name">replay-5-line</p></li><li class="class-icon"><i class="ri-school-fill"></i><p class="name">school-fill</p></li><li class="class-icon"><i class="ri-school-line"></i><p class="name">school-line</p></li><li class="class-icon"><i class="ri-shining-2-fill"></i><p class="name">shining-2-fill</p></li><li class="class-icon"><i class="ri-shining-2-line"></i><p class="name">shining-2-line</p></li><li class="class-icon"><i class="ri-shining-fill"></i><p class="name">shining-fill</p></li><li class="class-icon"><i class="ri-shining-line"></i><p class="name">shining-line</p></li><li class="class-icon"><i class="ri-sketching"></i><p class="name">sketching</p></li><li class="class-icon"><i class="ri-skip-down-fill"></i><p class="name">skip-down-fill</p></li><li class="class-icon"><i class="ri-skip-down-line"></i><p class="name">skip-down-line</p></li><li class="class-icon"><i class="ri-skip-left-fill"></i><p class="name">skip-left-fill</p></li><li class="class-icon"><i class="ri-skip-left-line"></i><p class="name">skip-left-line</p></li><li class="class-icon"><i class="ri-skip-right-fill"></i><p class="name">skip-right-fill</p></li><li class="class-icon"><i class="ri-skip-right-line"></i><p class="name">skip-right-line</p></li><li class="class-icon"><i class="ri-skip-up-fill"></i><p class="name">skip-up-fill</p></li><li class="class-icon"><i class="ri-skip-up-line"></i><p class="name">skip-up-line</p></li><li class="class-icon"><i class="ri-slow-down-fill"></i><p class="name">slow-down-fill</p></li><li class="class-icon"><i class="ri-slow-down-line"></i><p class="name">slow-down-line</p></li><li class="class-icon"><i class="ri-sparkling-2-fill"></i><p class="name">sparkling-2-fill</p></li><li class="class-icon"><i class="ri-sparkling-2-line"></i><p class="name">sparkling-2-line</p></li><li class="class-icon"><i class="ri-sparkling-fill"></i><p class="name">sparkling-fill</p></li><li class="class-icon"><i class="ri-sparkling-line"></i><p class="name">sparkling-line</p></li><li class="class-icon"><i class="ri-speak-fill"></i><p class="name">speak-fill</p></li><li class="class-icon"><i class="ri-speak-line"></i><p class="name">speak-line</p></li><li class="class-icon"><i class="ri-speed-up-fill"></i><p class="name">speed-up-fill</p></li><li class="class-icon"><i class="ri-speed-up-line"></i><p class="name">speed-up-line</p></li><li class="class-icon"><i class="ri-tiktok-fill"></i><p class="name">tiktok-fill</p></li><li class="class-icon"><i class="ri-tiktok-line"></i><p class="name">tiktok-line</p></li><li class="class-icon"><i class="ri-token-swap-fill"></i><p class="name">token-swap-fill</p></li><li class="class-icon"><i class="ri-token-swap-line"></i><p class="name">token-swap-line</p></li><li class="class-icon"><i class="ri-unpin-fill"></i><p class="name">unpin-fill</p></li><li class="class-icon"><i class="ri-unpin-line"></i><p class="name">unpin-line</p></li><li class="class-icon"><i class="ri-wechat-channels-fill"></i><p class="name">wechat-channels-fill</p></li><li class="class-icon"><i class="ri-wechat-channels-line"></i><p class="name">wechat-channels-line</p></li><li class="class-icon"><i class="ri-wordpress-fill"></i><p class="name">wordpress-fill</p></li><li class="class-icon"><i class="ri-wordpress-line"></i><p class="name">wordpress-line</p></li><li class="class-icon"><i class="ri-blender-fill"></i><p class="name">blender-fill</p></li><li class="class-icon"><i class="ri-blender-line"></i><p class="name">blender-line</p></li><li class="class-icon"><i class="ri-emoji-sticker-fill"></i><p class="name">emoji-sticker-fill</p></li><li class="class-icon"><i class="ri-emoji-sticker-line"></i><p class="name">emoji-sticker-line</p></li><li class="class-icon"><i class="ri-git-close-pull-request-fill"></i><p class="name">git-close-pull-request-fill</p></li><li class="class-icon"><i class="ri-git-close-pull-request-line"></i><p class="name">git-close-pull-request-line</p></li><li class="class-icon"><i class="ri-instance-fill"></i><p class="name">instance-fill</p></li><li class="class-icon"><i class="ri-instance-line"></i><p class="name">instance-line</p></li><li class="class-icon"><i class="ri-megaphone-fill"></i><p class="name">megaphone-fill</p></li><li class="class-icon"><i class="ri-megaphone-line"></i><p class="name">megaphone-line</p></li><li class="class-icon"><i class="ri-pass-expired-fill"></i><p class="name">pass-expired-fill</p></li><li class="class-icon"><i class="ri-pass-expired-line"></i><p class="name">pass-expired-line</p></li><li class="class-icon"><i class="ri-pass-pending-fill"></i><p class="name">pass-pending-fill</p></li><li class="class-icon"><i class="ri-pass-pending-line"></i><p class="name">pass-pending-line</p></li><li class="class-icon"><i class="ri-pass-valid-fill"></i><p class="name">pass-valid-fill</p></li><li class="class-icon"><i class="ri-pass-valid-line"></i><p class="name">pass-valid-line</p></li><li class="class-icon"><i class="ri-ai-generate"></i><p class="name">ai-generate</p></li><li class="class-icon"><i class="ri-calendar-close-fill"></i><p class="name">calendar-close-fill</p></li><li class="class-icon"><i class="ri-calendar-close-line"></i><p class="name">calendar-close-line</p></li><li class="class-icon"><i class="ri-draggable"></i><p class="name">draggable</p></li><li class="class-icon"><i class="ri-font-family"></i><p class="name">font-family</p></li><li class="class-icon"><i class="ri-font-mono"></i><p class="name">font-mono</p></li><li class="class-icon"><i class="ri-font-sans-serif"></i><p class="name">font-sans-serif</p></li><li class="class-icon"><i class="ri-font-sans"></i><p class="name">font-sans</p></li><li class="class-icon"><i class="ri-hard-drive-3-fill"></i><p class="name">hard-drive-3-fill</p></li><li class="class-icon"><i class="ri-hard-drive-3-line"></i><p class="name">hard-drive-3-line</p></li><li class="class-icon"><i class="ri-kick-fill"></i><p class="name">kick-fill</p></li><li class="class-icon"><i class="ri-kick-line"></i><p class="name">kick-line</p></li><li class="class-icon"><i class="ri-list-check-3"></i><p class="name">list-check-3</p></li><li class="class-icon"><i class="ri-list-indefinite"></i><p class="name">list-indefinite</p></li><li class="class-icon"><i class="ri-list-ordered-2"></i><p class="name">list-ordered-2</p></li><li class="class-icon"><i class="ri-list-radio"></i><p class="name">list-radio</p></li><li class="class-icon"><i class="ri-openbase-fill"></i><p class="name">openbase-fill</p></li><li class="class-icon"><i class="ri-openbase-line"></i><p class="name">openbase-line</p></li><li class="class-icon"><i class="ri-planet-fill"></i><p class="name">planet-fill</p></li><li class="class-icon"><i class="ri-planet-line"></i><p class="name">planet-line</p></li><li class="class-icon"><i class="ri-prohibited-fill"></i><p class="name">prohibited-fill</p></li><li class="class-icon"><i class="ri-prohibited-line"></i><p class="name">prohibited-line</p></li><li class="class-icon"><i class="ri-quote-text"></i><p class="name">quote-text</p></li><li class="class-icon"><i class="ri-seo-fill"></i><p class="name">seo-fill</p></li><li class="class-icon"><i class="ri-seo-line"></i><p class="name">seo-line</p></li><li class="class-icon"><i class="ri-slash-commands"></i><p class="name">slash-commands</p></li><li class="class-icon"><i class="ri-archive-2-fill"></i><p class="name">archive-2-fill</p></li><li class="class-icon"><i class="ri-archive-2-line"></i><p class="name">archive-2-line</p></li><li class="class-icon"><i class="ri-inbox-2-fill"></i><p class="name">inbox-2-fill</p></li><li class="class-icon"><i class="ri-inbox-2-line"></i><p class="name">inbox-2-line</p></li><li class="class-icon"><i class="ri-shake-hands-fill"></i><p class="name">shake-hands-fill</p></li><li class="class-icon"><i class="ri-shake-hands-line"></i><p class="name">shake-hands-line</p></li><li class="class-icon"><i class="ri-supabase-fill"></i><p class="name">supabase-fill</p></li><li class="class-icon"><i class="ri-supabase-line"></i><p class="name">supabase-line</p></li><li class="class-icon"><i class="ri-water-percent-fill"></i><p class="name">water-percent-fill</p></li><li class="class-icon"><i class="ri-water-percent-line"></i><p class="name">water-percent-line</p></li><li class="class-icon"><i class="ri-yuque-fill"></i><p class="name">yuque-fill</p></li><li class="class-icon"><i class="ri-yuque-line"></i><p class="name">yuque-line</p></li><li class="class-icon"><i class="ri-crosshair-2-fill"></i><p class="name">crosshair-2-fill</p></li><li class="class-icon"><i class="ri-crosshair-2-line"></i><p class="name">crosshair-2-line</p></li><li class="class-icon"><i class="ri-crosshair-fill"></i><p class="name">crosshair-fill</p></li><li class="class-icon"><i class="ri-crosshair-line"></i><p class="name">crosshair-line</p></li><li class="class-icon"><i class="ri-file-close-fill"></i><p class="name">file-close-fill</p></li><li class="class-icon"><i class="ri-file-close-line"></i><p class="name">file-close-line</p></li><li class="class-icon"><i class="ri-infinity-fill"></i><p class="name">infinity-fill</p></li><li class="class-icon"><i class="ri-infinity-line"></i><p class="name">infinity-line</p></li><li class="class-icon"><i class="ri-rfid-fill"></i><p class="name">rfid-fill</p></li><li class="class-icon"><i class="ri-rfid-line"></i><p class="name">rfid-line</p></li><li class="class-icon"><i class="ri-slash-commands-2"></i><p class="name">slash-commands-2</p></li><li class="class-icon"><i class="ri-user-forbid-fill"></i><p class="name">user-forbid-fill</p></li><li class="class-icon"><i class="ri-user-forbid-line"></i><p class="name">user-forbid-line</p></li>
    </ul>
  </div>
  <p class="links">
    
    <a href="https://github.com/Remix-Design/remixicon.git">GitHub</a> · 
    
    <a href="index.html">Font Class</a> · 
    
    <a href="unicode.html">Unicode</a>
    
  </p>
  <div class="footer">
    Licensed under MIT. (Yes it's free and <a href="https://github.com/Remix-Design/remixicon">open-sourced</a>)
    <div><a target="_blank" href="https://github.com/jaywcjlove/svgtofont">Created By svgtofont</a></div>
  </div>
</body>

</html>

```
```jsx
```