import { GetLgtmDataResult, InputData } from "@/types/lgtm-data";
import getFontData from "@/utils/google-font";
import { ImageResponseOptions } from "next/server";

async function getLgtmData(inputData: InputData): Promise<GetLgtmDataResult> {
  const designInfo = {
    author: "kazzyfrog",
    description:
      "淹れたてのアイスコーヒーです。一言メッセージを書いて差し入れできます:)",
    editableFields: ["text"],
  };

  const options: ImageResponseOptions = {
    width: 302,
    height: 457,
    emoji: "noto",
    fonts: [
      {
        name: "Caveat",
        data: await getFontData(
          "https://fonts.googleapis.com/css2?family=Caveat:wght@700",
        ),
        weight: 700,
      },
      {
        name: "Yusei Magic",
        data: await getFontData(
          "https://fonts.googleapis.com/css2?family=Yusei+Magic&display=swap",
        ),
        weight: 400,
      },
    ],
  };

  const element = (
    <div tw="flex h-full w-full flex-col items-center justify-center">
      <div tw="absolute flex">
        <svg
          width="302"
          height="457"
          viewBox="0 0 302 457"
          fill="none"
          xmlns="http://www.w3.org/2000/svg"
        >
          <path
            fill="#339B3E"
            d="M113.084 2.897 125.5 0l62.305 264.955-12.415 2.897z"
          />
          <path
            d="M38.584 456 17.107 149.103h267.45L263.194 456z"
            fill="#fff"
            fill-opacity=".3"
            stroke="#D9D9D9"
          />
          <path
            d="M20.883 199.249 38.584 456l224.161-.334 18.06-256.417z"
            fill="#463112"
          />
          <path
            d="M77.51 235.355h146.309v164.481H77.51z"
            fill="#fff"
            fill-opacity=".98"
          />
          <path
            stroke="#fff"
            stroke-width="4"
            d="M68.772 224.651h161.772V410.54H68.772z"
          />
          <path
            d="M101.08 363.54h1.94v12.6h7.34V378h-9.28zm23.488 13.22q-.3.26-.84.52-.54.24-1.2.44-.64.2-1.34.32-.68.12-1.28.12-1.74 0-3.14-.54a7.2 7.2 0 0 1-2.38-1.5 6.8 6.8 0 0 1-1.52-2.26 7.5 7.5 0 0 1-.52-2.82q0-1.8.58-3.22.6-1.44 1.62-2.42a6.85 6.85 0 0 1 2.38-1.5 7.8 7.8 0 0 1 2.84-.52q1.26 0 2.34.3t1.9.76l-.66 1.78q-.4-.24-1-.44a9 9 0 0 0-1.2-.32 5.3 5.3 0 0 0-1.16-.14q-1.28 0-2.32.4a4.8 4.8 0 0 0-1.78 1.12 4.85 4.85 0 0 0-1.14 1.76q-.4 1.02-.4 2.3 0 1.18.4 2.16a5 5 0 0 0 1.14 1.7q.74.7 1.76 1.1 1.04.38 2.28.38.74 0 1.46-.14.72-.16 1.24-.44v-2.88h-2.88v-1.86h4.82zm2.64-13.22h9.6v1.86h-3.88V378h-1.94v-12.6h-3.78zM139.889 378v-14.92h.02l7.58 10.76-.82-.16 7.56-10.6h.04V378h-1.92v-10.52l.12.98-5.46 7.72h-.04l-5.54-7.72.34-.9V378zm31.123-.76q-.56.44-1.34.7t-1.56.26q-1.36 0-2.38-.54a4.04 4.04 0 0 1-1.6-1.5q-.56-.98-.56-2.3t.6-2.3a4.2 4.2 0 0 1 1.6-1.5q1-.54 2.14-.54 1 0 1.78.28.8.28 1.36.76l-.92 1.2a4 4 0 0 0-.88-.5 3 3 0 0 0-1.18-.22q-.72 0-1.34.38-.6.36-.96 1a3 3 0 0 0-.34 1.44q0 .76.36 1.42.36.64 1 1.02.64.36 1.46.36.54 0 .98-.16.46-.16.82-.44zm5.841.96q-1.16 0-2.12-.5a3.75 3.75 0 0 1-1.5-1.46q-.54-.98-.54-2.38 0-1.38.58-2.38.58-1.02 1.54-1.56a4.36 4.36 0 0 1 2.14-.54q1.16 0 1.96.54.8.52 1.22 1.24l-.12.32.18-1.76h1.72V378h-1.86v-2.16l.2.48q-.08.2-.36.52-.26.3-.72.62a4.4 4.4 0 0 1-1.02.54q-.58.2-1.3.2m.5-1.54a3 3 0 0 0 1.26-.26q.56-.26.92-.72.38-.48.52-1.14v-1.62a2.46 2.46 0 0 0-.56-1.04 2.6 2.6 0 0 0-.96-.7 2.9 2.9 0 0 0-1.24-.26q-.74 0-1.36.36t-1 1q-.36.64-.36 1.5a2.88 2.88 0 0 0 1.4 2.5q.64.38 1.38.38m8.459 1.34v-6.62h-1.42v-1.66h1.42v-3.5q0-1.8.8-2.76.819-.96 2.4-.96.42 0 .92.12.519.12.9.4l-.78 1.34a.9.9 0 0 0-.4-.24 1.3 1.3 0 0 0-.44-.08q-.741 0-1.14.5-.4.5-.4 1.7v3.48h2.62v1.66h-2.62V378zm10.289.2q-1.42 0-2.44-.56a4.13 4.13 0 0 1-1.58-1.56q-.54-1-.54-2.28 0-1.22.62-2.22t1.66-1.6 2.32-.6q1.64 0 2.72.96t1.46 2.64l-6.82 2.4-.44-1.1 5.6-2.04-.4.26q-.24-.66-.8-1.14-.56-.5-1.46-.5-.76 0-1.36.38-.6.36-.94 1t-.34 1.46q0 .86.36 1.52.36.64.98 1.02.639.36 1.44.36.54 0 1.04-.2.519-.2.96-.52l.86 1.38q-.62.42-1.4.68a4.6 4.6 0 0 1-1.5.26"
            fill="#000"
          />
          <path stroke="#000" d="M82.879 389.306h136.248" />
          <path
            d="m1 149.103 7.383-31.426h285.234L301 149.103z"
            fill="#fff"
            fill-opacity=".3"
            stroke="#D9D9D9"
          />
          <path
            d="m21.771 196.973-.724-.966.18 3.339 3.686-.198-.353-.316-.688-.298-.688-.298-.707-.631zm258.131.686.738-.956-.227 3.336-4.916-.121 1.59-.439.693-.288.692-.289.715-.622z"
            fill="#463112"
            stroke="#463112"
          />
        </svg>
      </div>
      <div tw="w-[140px] h-[120px] flex items-center px-1 justify-center">
        <p
          tw="text-[30px] mt-34"
          style={{
            transform: "rotate(-6.5deg)",
            wordBreak: "break-all",
          }}
        >
          {inputData.text}
        </p>
      </div>
    </div>
  );

  return {
    designInfo,
    element,
    options,
  };
}

export default getLgtmData;
