import { GetLgtmDataResult, InputData } from "@/types/lgtm-data";
import getFontData from "@/utils/google-font";
import { ImageResponseOptions } from "next/server";

async function getLgtmData(inputData: InputData): Promise<GetLgtmDataResult> {
  const designInfo = {
    author: "kagome",
    description: "ケーキ好きな方に😼🍓",
    editableFields: [],
  };

  const options: ImageResponseOptions = {
    width: 1200,
    height: 630,
    emoji: "twemoji",
    fonts: [
      {
        name: "Aclonica",
        data: await getFontData(
          "https://fonts.googleapis.com/css2?family=Aclonica",
        ),
      },
    ],
  };

  const element = (
    <div tw="flex h-full w-full flex-col items-center justify-center bg-teal-400 rounded-3xl">
      <p tw="text-[192px] leading-none">🍰</p>
      <p tw="text-5xl text-white mb-8">Looks Good To Me🤍</p>
      <svg
        width="306"
        height="79"
        viewBox="0 0 306 79"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          fill-rule="evenodd"
          clip-rule="evenodd"
          d="M159.15 74.0107C169.903 80.4674 203.947 81.496 217.841 67.8547C235.595 83.0794 277.347 66.892 290.992 55.972C295.72 52.1887 306.897 41.2187 305.677 39.9994C305.146 39.4687 303.27 37.4614 301.222 35.27L301.221 35.2687L301.215 35.262C298.803 32.6807 296.155 29.8474 295.187 28.874C295.047 28.734 293.609 30.4607 291.593 32.8814C287.835 37.3954 282.069 44.32 278.975 46.038C276.993 47.14 274.992 48.3047 272.972 49.4807C259.876 57.104 245.934 65.2207 230.344 60.0234C228.785 59.504 231.567 57.854 234.171 56.31C235.723 55.3894 237.213 54.506 237.68 53.9227C241.571 49.0574 243.669 43.54 244.663 36.638C245.636 29.8274 246.004 21.666 241.151 15.8414C240.216 14.72 239.459 13.53 238.707 12.3494C237.735 10.82 236.773 9.30736 235.448 7.9827C232.965 5.49203 229.349 3.87137 225.9 2.4927C209.948 -3.88864 196.487 7.9907 194.433 24.4247C193.49 31.9694 195.453 40.218 198.884 46.9927C199.148 47.5134 199.438 48.0734 199.741 48.658C202.065 53.1454 205.141 59.0814 202.677 59.636C197.219 60.8634 191.155 60.9787 185.533 60.9787H185.133C181.669 60.98 178.368 60.9814 175.045 60.0234C173.693 59.638 172.118 59.3314 170.479 59.012C166.371 58.212 161.864 57.334 159.468 54.9394C159.401 54.8714 160.645 53.1174 162.081 51.0954C163.817 48.65 165.833 45.8114 166.143 45.0854C166.345 44.616 166.555 44.1334 166.769 43.638C170.209 35.6967 174.999 24.638 170.917 16.478C169.441 13.536 165.354 10.1907 162.651 8.56336C146.394 -1.21864 127.841 6.26003 125.455 23.472C124.337 31.5394 127.313 41.1254 131.177 47.3094C131.387 47.644 132.751 49.2294 134.271 50.994C136.442 53.516 138.928 56.4047 138.805 56.5287C137.429 57.9047 132.574 57.6834 129.517 57.5447C128.773 57.5107 128.135 57.4814 127.68 57.4814C118.763 57.4814 102.287 54.2174 95.7773 47.7074C95.3133 47.2467 96.294 46.286 97.7753 44.8347C100.318 42.3427 104.337 38.4047 105.06 33.0674C107.135 17.7374 100.044 7.2867 85.406 3.12736C74.6987 0.0800314 57.1727 9.89403 55.5253 21.562C53.5067 35.878 60.7093 47.594 63.892 48.4647C21.966 49.4534 11.744 28.6027 10.9513 26.986C10.9193 26.9214 10.9027 26.8874 10.9 26.8874C9.91135 26.8874 5.30068 31.846 4.66801 32.6874C4.18868 33.3274 3.59934 33.8994 3.01134 34.4714C1.99334 35.4607 0.97801 36.4474 0.536677 37.7754C-1.32799 43.368 5.70734 47.5874 11.1607 50.858C12.9847 51.952 14.632 52.94 15.7093 53.8374C29.6213 65.432 53.302 65.058 70.1473 62.2494C70.5713 62.1787 71.0327 62.108 71.5173 62.034C74.0073 61.6547 77.124 61.1787 79.0467 60.0234C79.1167 59.982 79.3053 59.8514 79.5687 59.67C80.6967 58.8914 83.1867 57.172 83.4967 57.4814C91.174 65.1534 104.899 71.32 116.237 72.74C123.895 73.6967 130.281 72.4154 137.698 70.9267L137.923 70.882L138.487 70.7687C139.314 70.6027 142.482 69.0214 145.177 67.6767C147.323 66.606 149.169 65.6834 149.294 65.746C150.868 66.5327 152.488 68.124 154.167 69.7747C155.769 71.3487 157.426 72.976 159.15 74.0107ZM79.3273 45.5927C73.0973 42.3107 62.5913 14.8114 78.3547 14.7354C103.243 14.614 86.9973 43.42 79.3273 45.5927ZM149.467 50.9227C149.022 51.81 146.419 47.8894 144.889 45.5854C144.437 44.9047 144.079 44.3647 143.897 44.132C138.328 36.9714 131.702 20.2267 146.439 18.3827C154.305 17.4027 160.409 25.44 158.838 33.3227C157.693 39.046 154.699 43.2227 152.255 46.634C151.133 48.1994 150.126 49.604 149.467 50.9227ZM208.778 23.2047C207.537 31.9047 215.189 55.3007 217.974 52.2454C224.019 50.0094 235.953 24.028 229.863 19.3634C223.788 14.7367 210.336 12.302 208.778 23.2047Z"
          fill="#D55816"
        />
      </svg>
    </div>
  );

  return {
    designInfo,
    element,
    options,
  };
}

export default getLgtmData;
