<p align="center">
  <img src="/public/github-social-preview.png">
</p>

<p align="left">
  <img src="https://awesome.re/badge.svg" alt="Awesome">
  <img src="https://img.shields.io/badge/PRs-welcome-brightgreen?style=flat" alt="Static Badge">
  <img src="https://badges.frapsoft.com/os/v1/open-source.svg?v=103" alt="Open Source Love">
  <img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="License MIT">
  <img src="https://img.shields.io/badge/contributions-welcome-blue.svg?style=flat" alt="Contributions Welcome">
  <img src="https://img.shields.io/badge/Looks_Good_To_Me-👀-black?style=flat" alt="Static Badge">
</p>

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twttr-share]

> 自由自在な LGTM 画像で、プロジェクトを彩る 📦

HTML & CSS で作成された、LGTM 画像のコレクションです。<br>
楽しいコミュニケーションで、プロジェクトを彩りましょう！

フリー素材のみを使用した OSS なので、安心してご利用いただけます！ 🙌

<br>

## 特徴

- 🎨 単純な HTML/CSS で、デザインされた LGTM 画像
- 🛠 毎回動的な値を入力して、カスタマイズ可能
- 🆓 著作権を気にせず安心して使える OSS
- 📦 誰でも自由に追加できるコレクション

[Web サイト](https://lgtm-factory.pages.dev)**上で、お気に入りの画像を取得してください**！<br>
GitHub 上から、新しいデザインを追加してください！！

### FAQ:

<details><summary><strong>「LGTM とはなんですか？」</strong></summary>
<p>

「LGTM」は、Looks Good To Me の略です。
チーム開発において、他のメンバーが書いたコードをレビューする際に、問題なく確認が完了したことを伝えるために使われる、開発者の慣習的な言葉です。
そこから転じて、承認を表す際に「LGTM」という言葉だけでなく、「LGTM」という言葉入りの画像を貼る慣習も存在します！

</p>
</details>

<details><summary><strong>「どうして Factory という名前なんですか？」</strong></summary>
<p>
  
- 動的な値を入力して、毎回オリジナルの画像を生成できること
- HTML, CSS のコードで書かれたデザインテーマを作成することで、誰でもサイト上にコンテンツを追加できること

上記の特徴を踏まえて、手作り・モノ作りの雰囲気から、ポップな工場風のコンセプトに決定しました！🔧

</p>
</details> 
<details><summary><strong>「これは、類似のLGTM 画像共有サービスとどう違うのですか？」</strong></summary>
<p>

大きな違いを挙げると、３つあります。

**コンテンツの雰囲気**：
単に画像をアップロードするのではなく、１つ１つデザインされた、コードベースのコンテンツを用意しています。
これにより、ステッカー・スタンプのような、誰に対しても使いやすい雰囲気の画像を目指します。

**オリジナルのメッセージ**：
リモートでのコミュニケーションをさらに楽しくするため、動的な値（メッセージなど）を入力できます。

**ライセンスフリー**：
ミーム LGTM 画像も、もちろん好きですが、社内利用などでは著作権を無視して使用を続けることは、少し気がかりです。
当然、チーム内や社内の規定によっては、そのようなLGTM画像を使用できないケースがあります。
LGTM Factory は、HTML と CSS、そしてフリー素材のみを使用しているので、安心してご利用いただけます！

</p>
</details> 
<details><summary><strong>「コードレビュー以外でも使用可能ですか？」</strong></summary>
<p>

もちろんです👍<br>
GitHub プロフィールや、GitHub上のドキュメントの装飾など。そして、常識の範囲内であれば GitHub 以外でも自由に使用できます！（その場合は、画像のダウンロードをお勧めします）

ただし、極めて過剰な数のリクエストを確認した場合、特定のご利用者様を予告無しにアクセス禁止・制限することがあります。

</p>
</details> 
<details><summary><strong>「喉が渇きました。何か飲み物はありますか？」</strong></summary>
<p>

どうぞ！！<br>

[![](https://lgtm-factory.pages.dev/api/v1/lgtm-images?theme=iced-coffee&text=Have%20a%20nice%20day%20:）)](https://lgtm-factory.pages.dev)

</p>
</details>

<br>

## 技術構成:

LGTM Factory の基本的な構成は、以下のとおりです:)

- ⚡ Next.js v14/ App Router による、フルスタックアプリケーション
- ☁️ Cloudflare Pages & Workers を使用したホスティング
- ⛑️ TypeScript による型チェック
- 🌪️ Tailwind CSS でのスタイリング
- 🐦‍⬛ Shadcn/ui のコンポーネントを使用
- 📦 @vercel/og による画像生成

<br>

## コントリビュート

LGTM Factory に貢献する主な方法は、３つあります：)

### 1.新たな画像（デザインテーマ）を追加する

> **LGTM Factory は、単純な HTML と CSS のコードから、画像を生成しています**🫠

Web サイト・UI コンポーネントを作成するように、LGTM ステッカーを作成できます！

新たなデザインを追加したい場合は、[デザインテーマを追加するガイド](/design-guide.md)を参照してください！<br>
OSS へのコントリビュートが初めての場合でも、最大限サポートします！！

### 2.Issue を立てる

バグ、ドキュメントの欠落、または予期しない動作については、[Issues](https://github.com/lgtm-factory/lgtm-factory/issues) から報告してください！<br>
新機能の提案も大歓迎です💡

### 3.未解決の Issue に着手する

着手可能な Issue があれば、ぜひコメントを追加してください！<br>
また、問題の解決策や、機能の実装方針が定まっていない議論段階の Issue を見つけたら、ぜひあなたの知見を貸してください！

実際に Issue に取り組む際は、[CONTRIBUTINGガイドライン](/.github/CONTRIBUTING.md)を参照してください🤝

<br>

## ライセンス

LGTM Factory は、[MIT LICENSE](/LICENSE)の下でライセンスされたオープンソースプロジェクトです。

## 謝辞

このプロジェクトは、[Shields.io](https://github.com/badges/shields)や、`@vercel/og`の[ImageResponse](https://nextjs.org/docs/app/api-reference/functions/image-response)、<br>
そして、多くの素晴らしい LGTM 画像共有サービスから影響を受けています。

[twttr-share]: https://twitter.com/intent/tweet?text=自由自在なフリーLGTM画像で、プロジェクトを彩る📦&url=https://github.com/lgtm-factory/lgtm-factory&hashtags=LGTMfactory,OpenSource "Tweet this project"
