import type { AppState } from "@excalidraw/excalidraw/types/types";
import type { ExcalidrawElement } from "@excalidraw/excalidraw/types/element/types";

export const predefineState: Partial<AppState> = {
  activeTool: {
    type: "freedraw",
    customType: null,
    locked: false,
    lastActiveTool: null,
  },
  openMenu: "shape",
};

export const paintingTypes = [
  "oil painting",
  "watercolor painting",
  "acrylic painting",
  "drawing",
  "printmaking",
];

export const artStyles = [
  "realism",
  "impressionism",
  "expressionism",
  "cubism",
  "abstract art",
  "surrealism",
  "baroque",
  "rococo",
  "fauvism",
];

export const presets: {
  name: string;
  prompt: string;
  elements: ExcalidrawElement[];
  base64: string;
}[] = [
  {
    name: "Christmas tree",
    prompt: "A beautiful Christmas tree with gift",
    elements: [
      {
        type: "rectangle",
        version: 366,
        versionNonce: 2104328121,
        isDeleted: false,
        id: "NYDWlTR1mCz1GaDYO0v6S",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 118.53739034948461,
        y: 113.36873150210562,
        strokeColor: "transparent",
        backgroundColor: "#e9ecef",
        width: 320.9903313478011,
        height: 360.0489088158824,
        seed: 2033299961,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703142025429,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 340,
        versionNonce: 2139415129,
        isDeleted: false,
        id: "1wkVAF3ncemAXmV_9oyhS",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 263.18831799704475,
        y: 338.7489624176975,
        strokeColor: "#846358",
        backgroundColor: "#a18072",
        width: 22.501256732918648,
        height: 80.91161098507786,
        seed: 371702713,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
      },
      {
        type: "freedraw",
        version: 435,
        versionNonce: 155791161,
        isDeleted: false,
        id: "tBtal7-82ne0gCuXaob8p",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 257.3593654612882,
        y: 289.09870302359985,
        strokeColor: "#099268",
        backgroundColor: "#12b886",
        width: 230.06029856368866,
        height: 83.4969326780278,
        seed: 939799127,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-3.8477753157764027, 4.2352610811983595],
          [-8.443439823953327, 9.57881478177569],
          [-17.76184750531104, 18.913888517560167],
          [-26.37403113033517, 26.926094183221267],
          [-32.35297815593245, 32.363394439949104],
          [-38.01943666102815, 37.50278897379877],
          [-43.96088506416527, 42.558853235514675],
          [-48.189896374953605, 46.14413819406968],
          [-50.21482198780399, 47.95865486978232],
          [-53.404288153723655, 50.54397656273227],
          [-55.46462913223087, 52.08766985401013],
          [-56.70416693022054, 53.052217753958416],
          [-57.7478785886959, 53.81468974398234],
          [-58.62492970290373, 54.2688397271113],
          [-59.66030833416568, 54.893816768114505],
          [-60.81026608961159, 55.78128416633905],
          [-61.95189081784412, 56.63333619890676],
          [-62.79352656639509, 57.33539374163371],
          [-63.66849442379956, 58.07911642042751],
          [-64.670540946208, 58.94158473701191],
          [-65.22052074229083, 59.412400774567686],
          [-65.6767539822232, 59.78947025597296],
          [-66.71421587028851, 61.04775736519275],
          [-67.63501537736653, 62.40604080097302],
          [-67.98083600672166, 63.19559512944039],
          [-68.33707292009348, 63.90390244257736],
          [-68.74955776715558, 64.62470929653438],
          [-69.084962112494, 65.39343105696832],
          [-69.41619994422567, 65.98090947551134],
          [-69.67660704464367, 66.3288133616698],
          [-69.8432675889112, 66.65796793659814],
          [-69.95159694268509, 67.04753695882346],
          [-70.17658867744623, 67.45168877867218],
          [-70.4265794938475, 67.62251583654643],
          [-70.78073315041598, 67.88708945057107],
          [-71.10572121173766, 68.20582774148272],
          [-71.57445399249008, 68.57456419567461],
          [-72.10568447734278, 68.90996854101303],
          [-72.44108882268117, 69.14745981659422],
          [-72.76399362719951, 69.46828136430918],
          [-73.15564590622816, 69.77035360079407],
          [-73.4368855746796, 69.96201322670174],
          [-74.04311330445273, 70.38908087138725],
          [-74.54309493725526, 70.77864989361257],
          [-75.00141143399094, 71.12863703657439],
          [-75.33681577932936, 71.46195812510939],
          [-75.72846805835803, 71.85152714733476],
          [-76.06178914689303, 72.1140175045561],
          [-76.38886046501807, 72.27651153521691],
          [-76.78467925765341, 72.56191771727504],
          [-77.12216685979516, 72.81815830408635],
          [-77.44507166431347, 72.97856907794386],
          [-77.73256110317493, 73.15564590622807],
          [-78.01380077162639, 73.33063947770898],
          [-78.2554585608143, 73.47855071074639],
          [-78.392953509835, 73.54729818525675],
          [-78.65752712385967, 73.65146102542394],
          [-79.08667802534853, 73.82228808329819],
          [-79.83040070414236, 74.14310963101315],
          [-80.87827887622439, 74.65350754783242],
          [-81.78449558567905, 75.10140776055141],
          [-82.85528958259786, 75.57430705491049],
          [-84.13857577345777, 76.14511941902674],
          [-85.05520876692913, 76.54093821166208],
          [-85.6593532398989, 76.83051090732693],
          [-86.26558096967199, 77.13258314381181],
          [-86.71348118239098, 77.34924185135958],
          [-86.94888920116881, 77.5013195980037],
          [-87.18221396314334, 77.64923083104111],
          [-87.29470983052394, 77.80964160489862],
          [-87.36345730503427, 77.88047233621228],
          [-87.500952254055, 77.94713655391928],
          [-86.91347383551198, 78.02838356924974],
          [-83.99483105402703, 77.58673312694077],
          [-77.39090698742655, 76.37011115378789],
          [-66.28714822560298, 74.46601443553146],
          [-49.25652385826572, 72.30984364407044],
          [-27.494823290534242, 71.24738267436499],
          [-11.84539818381404, 71.20571753829807],
          [3.551952849701479, 71.20571753829807],
          [25.976129080896385, 71.20571753829807],
          [45.6691556429073, 71.91194159463174],
          [63.9539006058576, 73.52854887402668],
          [83.77817234647921, 74.97641235235074],
          [94.54027699255431, 75.62638847499409],
          [98.95469815884024, 76.04512309246621],
          [107.01273547417486, 76.67218339027278],
          [114.73745170097447, 77.27007809283248],
          [119.53727537587906, 77.54715124767728],
          [122.74757410983216, 77.54715124767728],
          [125.87662582845485, 77.54715124767728],
          [127.61197874564039, 77.54715124767728],
          [128.5140289414884, 77.54715124767728],
          [129.29941675634905, 77.54715124767728],
          [129.60148899283394, 77.54715124767728],
          [129.73065091464127, 77.54715124767728],
          [129.88897843169542, 77.54715124767728],
          [130.0452226919462, 77.54715124767728],
          [130.26188139949397, 77.54715124767728],
          [130.5972857448324, 77.54715124767728],
          [130.982688253451, 77.54715124767728],
          [131.3139260851827, 77.54715124767728],
          [131.64099740330772, 77.54715124767728],
          [132.16806137455376, 77.44090515070673],
          [132.59512901923927, 77.34715859455622],
          [132.91595056695422, 77.26799483602917],
          [133.6513402185347, 77.04716961487469],
          [134.48880945347895, 76.80759508249014],
          [135.20336653702594, 76.60135265895906],
          [136.1324990713174, 76.25344877280065],
          [137.419951775784, 75.84304718254185],
          [138.5240778815563, 75.59305636614056],
          [139.42612807740426, 75.36598137457605],
          [140.6677491321973, 75.00141143399088],
          [141.65729611378572, 74.6764233726692],
          [142.03853210879765, 74.57226053250201],
          [142.2114424234752, 74.48893026036825],
          [142.3447708588892, 74.41393301544787],
          [142.48018255110657, 74.41393301544787],
          [142.55934630963367, 74.34935205454423],
          [142.48434906471329, 74.12019380617636],
          [141.46980300148476, 73.47021768353301],
          [132.15972834734038, 67.93083784344134],
          [124.50375959505118, 63.04768389640299],
          [115.72491542575949, 57.52705336754133],
          [104.90447958919071, 50.14815777009687],
          [92.89450411791256, 41.14015535243743],
          [78.48878332278878, 31.02594357220221],
          [68.85163735051935, 24.751174080530063],
          [61.29774818159399, 20.113844436286342],
          [51.44602675858016, 13.805742835760725],
          [43.87547153522809, 8.841341873391912],
          [35.00913058019603, 3.493621659207861],
          [31.588422909105134, 1.156207525855848],
          [29.43225211764411, -0.34373737255180004],
          [27.807311811035788, -1.3853657742238283],
          [26.36153158951504, -2.3499136741720577],
          [25.65114101957471, -2.90614324066496],
          [25.32198644464637, -3.154050800262894],
          [24.95324999045448, -3.4144579006808726],
          [24.805338757417076, -3.5519528497015926],
          [24.665760551592996, -3.6248668378186153],
          [24.494933493718804, -3.724863164379144],
          [24.347022260681342, -3.7998604092995265],
          [24.201194284447297, -3.872774397416549],
          [23.94078718402932, -3.9498548991402913],
          [23.511636282540394, -4.0373516848807185],
          [22.59083677546238, -4.137348011441247],
          [21.336716179849304, -4.285259244478652],
          [20.313837089407343, -4.501917952026474],
          [19.074299291417674, -4.749825511624408],
          [17.670184205963835, -4.939401880728667],
          [16.54314227535474, -5.0935628841760945],
          [15.632759052293409, -5.2206415491801295],
          [14.695293490788572, -5.3373039301674225],
          [13.416173813535352, -5.460216081564681],
          [12.437043115963661, -5.468549108778063],
          [11.69332043716986, -5.468549108778063],
          [10.81835257976536, -5.468549108778063],
          [10.253789986059132, -5.468549108778063],
          [9.803806516536838, -5.468549108778063],
          [9.33715699258778, -5.468549108778063],
          [9.04133452651297, -5.468549108778063],
          [8.893423293475507, -5.468549108778063],
          [8.755928344454787, -5.468549108778063],
          [8.343443497392741, -5.468549108778063],
          [7.360146286214331, -5.468549108778063],
          [6.9976596024324635, -5.468549108778063],
          [6.566425444140236, -5.468549108778063],
          [5.9622809711705145, -5.468549108778063],
          [5.37271929582414, -5.468549108778063],
          [4.751908768427597, -5.468549108778063],
          [3.8415255453662667, -5.468549108778063],
          [3.1790498819029267, -5.468549108778063],
          [2.8540618205812507, -5.468549108778063],
          [2.456159771142552, -5.468549108778063],
          [2.093673087360685, -5.468549108778063],
          [1.9811772199801112, -5.401884891071063],
          [1.8957636910430438, -5.266473198853646],
          [1.8957636910430438, -5.266473198853646],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "freedraw",
        version: 391,
        versionNonce: 1924194329,
        isDeleted: false,
        id: "3qfds02j2AFAvBB6TrfKL",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 289.2019457004014,
        y: 213.534812252706,
        strokeColor: "#099268",
        backgroundColor: "#12b886",
        width: 197.34252676565038,
        height: 111.38965801800066,
        seed: 2055338551,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
        points: [
          [-12.961814275069912, 0],
          [-12.899545513086219, 0],
          [-12.99294865606176, 0],
          [-14.507544719607022, 1.719716691256352],
          [-18.952435464739306, 6.834912344801621],
          [-26.356923838274348, 15.907837252665256],
          [-36.916973297043384, 29.097826188158606],
          [-48.81213827011051, 44.02767759084417],
          [-62.774992427872384, 61.79442053214121],
          [-74.40276801124469, 75.9129465948624],
          [-82.14973457569023, 84.99869154195802],
          [-89.16046460138705, 93.10645063907391],
          [-93.0650822646017, 97.30043490209526],
          [-96.60158165844196, 100.91385453132726],
          [-100.58311955704825, 105.06571580830072],
          [-103.61597455249078, 108.2872085238704],
          [-105.60491206761793, 110.0527110695266],
          [-106.45469752527818, 110.66074721595588],
          [-106.88325312246026, 110.99589967016237],
          [-107.15979968303502, 111.23948041556929],
          [-107.22939418172271, 111.36951224206474],
          [-107.17078828809095, 111.38965801800066],
          [-106.19463387228731, 111.03802265621016],
          [-104.08848456989665, 110.33475193262932],
          [-100.41096474450501, 109.2377228612102],
          [-90.80509249142774, 107.10043917782771],
          [-75.99245287600561, 104.5455885023191],
          [-60.42709381425083, 102.46324784421633],
          [-39.78133634829465, 100.41204156710545],
          [-24.263594575115633, 99.44321288800573],
          [-10.960056720710833, 99.06227457939944],
          [4.91115184843456, 98.54031583924177],
          [15.372303861700065, 98.47621564308207],
          [29.39010104474174, 98.12274884711567],
          [42.5031697448434, 97.77843922202919],
          [52.83978423414142, 97.22351466670362],
          [58.07219167495015, 96.79862193787349],
          [61.301010127223805, 96.6044899152184],
          [64.03167848362764, 96.41768362926722],
          [65.65066629520449, 96.16311427880437],
          [66.64147218441607, 95.94334217768534],
          [67.46561756361238, 95.81147891701393],
          [68.00589064553002, 95.72723294491831],
          [68.52235508315972, 95.63932410447069],
          [69.27690596366833, 95.51295514632724],
          [71.18892324340382, 95.16681408706476],
          [72.10647176557578, 95.03678226056937],
          [72.94160574982803, 94.85363884297014],
          [73.88479435046386, 94.74924709493867],
          [75.07705799903458, 94.6027323608593],
          [76.96709806865816, 94.31702862940452],
          [78.56410867012302, 94.06978501564565],
          [79.55491455933466, 93.98187617519802],
          [81.04936484694402, 93.83719287529468],
          [82.37166032201013, 93.70716104879928],
          [85.4319868300925, 93.46358030339236],
          [86.69933927987884, 93.35369425283282],
          [87.62787640710673, 93.24563963644934],
          [88.48132473311894, 93.15773079600172],
          [89.146135339004, 93.06432765302613],
          [89.57652237036204, 93.05883335049816],
          [89.78164299807314, 93.00022745686643],
          [89.94097777138442, 92.93612726070673],
          [90.05452669029593, 92.93063295817876],
          [90.11313258392767, 92.87385849872298],
          [90.03438091436003, 92.64309779254802],
          [89.53989368684223, 92.08267893469447],
          [87.53630469830715, 90.44903964970979],
          [84.24888035240177, 87.7403485034178],
          [80.63362928899382, 84.34303810695289],
          [74.63018806009254, 78.89085856502517],
          [65.65432916355645, 71.14938630310762],
          [56.50631545447713, 63.21561345271088],
          [45.636753619965454, 54.309349054862466],
          [32.54932499832767, 43.872005685884886],
          [23.665037810591222, 36.91621868546784],
          [17.370398547707186, 32.365104758128076],
          [9.26447088476726, 26.29390046471508],
          [1.5889302531853708, 20.73549774057978],
          [-2.3779561720130236, 17.98834647659203],
          [-4.771640640034324, 16.112957880376346],
          [-7.961998974612152, 13.700959070595038],
          [-9.826398965771855, 12.276103281673404],
          [-11.24209758381361, 11.224860064654083],
          [-12.432529798208314, 10.424523329745641],
          [-13.174260639484974, 9.814655749140345],
          [-13.727353760634495, 9.358628639318376],
          [-14.022214662969212, 9.138856538199342],
          [-14.364692853879678, 8.812861254872802],
          [-14.655890887862384, 8.525326089242082],
          [-14.936100316789156, 8.245116660315334],
          [-15.452564754418864, 7.728652222685628],
          [-16.163161214703674, 7.018055762400791],
          [-16.849949030700664, 6.4118510501474795],
          [-17.72720600100074, 5.745209010086454],
          [-18.785774954724037, 4.943040841002033],
          [-19.690503437664002, 4.263578761709043],
          [-20.30952818914928, 3.761765797487257],
          [-20.83698123183492, 3.3496931078890997],
          [-21.261873960665042, 3.0200349562105737],
          [-21.468826022552086, 2.8130828943235047],
          [-21.628160795863383, 2.653748121012209],
          [-21.74354114895089, 2.5383677679246994],
          [-21.80397847675863, 2.421155980661235],
          [-21.82961855522251, 2.2691469440539116],
          [-21.683103821143156, 2.194058142838228],
          [-21.250885355609057, 2.194058142838228],
          [-20.749072391387298, 2.194058142838228],
          [-20.21978791452565, 2.194058142838228],
          [-19.45791129731303, 2.194058142838228],
          [-18.78943782307605, 2.194058142838228],
          [-18.274804819622297, 2.194058142838228],
          [-17.78031759210451, 2.194058142838228],
          [-17.496445294825776, 2.194058142838228],
          [-17.29865040381861, 2.194058142838228],
          [-17.115506986219437, 2.194058142838228],
          [-16.970823686316088, 2.194058142838228],
          [-16.85178046487662, 2.194058142838228],
          [-16.85178046487662, 2.194058142838228],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "freedraw",
        version: 350,
        versionNonce: 967800057,
        isDeleted: false,
        id: "XGezOjP6WkV5Q1gCJKNfW",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 265.33615576129233,
        y: 182.965101920436,
        strokeColor: "#099268",
        backgroundColor: "#12b886",
        width: 196.28445601107228,
        height: 77.08883475094166,
        seed: 642956313,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.07291398811702265, 0],
          [-1.8978469478463467, 0.8687180869944768],
          [-6.5435096193035065, 4.551916115306653],
          [-15.180692325967755, 11.787066993320394],
          [-25.25115571333265, 20.186758424403422],
          [-38.563166686700896, 31.569673597875067],
          [-58.402021224945884, 48.37113971684448],
          [-71.08697190050754, 58.70201020462741],
          [-76.78259600085005, 63.622662774125956],
          [-81.7803290720723, 68.05791650844532],
          [-84.33856842657875, 70.25991894957997],
          [-87.74469330004621, 72.90148857622017],
          [-90.47375971242684, 74.99932817718758],
          [-91.81121058017368, 76.19303432550367],
          [-92.30494244256624, 76.57843683412233],
          [-92.73409334405508, 76.8075950824902],
          [-92.98408416045635, 76.87842581380386],
          [-93.12157910947707, 77.0075877356112],
          [-92.87992132028916, 77.07841846692492],
          [-90.9883241428528, 77.08883475094166],
          [-84.41564892830246, 76.23886597517725],
          [-72.53066886522492, 74.25768875519708],
          [-55.745868800682274, 72.1910980062799],
          [-37.87569194159738, 70.91197832902668],
          [-16.288984945346783, 70.48699394114448],
          [4.766491566051059, 70.38699761458395],
          [24.24702593412087, 70.3619985329438],
          [45.00043020903388, 70.3619985329438],
          [58.48743475388301, 70.3619985329438],
          [79.77831928405874, 70.3619985329438],
          [85.41144568030091, 70.3619985329438],
          [96.6068677414716, 70.3619985329438],
          [99.16094058237138, 70.3619985329438],
          [102.07541685024961, 70.3619985329438],
          [102.52748357657526, 70.3619985329438],
          [102.85247163789694, 70.3619985329438],
          [103.00038287093435, 70.3619985329438],
          [103.12954479274168, 70.3619985329438],
          [103.16287690159521, 70.3619985329438],
          [102.61914687592241, 70.23908638154654],
          [101.04420473259432, 69.34120269930526],
          [98.05889773340238, 67.14753328538404],
          [93.2882396537446, 63.16642953419364],
          [88.12384603825484, 58.31035792559874],
          [81.9449063595365, 52.70014735419335],
          [75.70138571991453, 47.073270728361194],
          [71.13905332059113, 42.55260346510468],
          [65.15802303819049, 37.088220869933366],
          [57.64579900533204, 30.73428761973412],
          [52.48140538984222, 26.688602907640075],
          [48.03573537150612, 23.774126639761818],
          [43.035919043480476, 20.672157259582605],
          [39.12356276680043, 18.518069724924885],
          [36.275750716629204, 17.09312207143759],
          [34.357071200749374, 16.261902606903334],
          [31.91966074083689, 15.216107691624643],
          [29.84473696470627, 14.216144426019525],
          [28.45520467687578, 13.5203366537026],
          [27.248998987739583, 12.980773141636519],
          [26.06570912344023, 12.457875683997173],
          [24.903251827174245, 11.837065156600659],
          [23.91578810238923, 11.210004858794093],
          [22.819995023830245, 10.630859467464461],
          [21.89086248953879, 10.255873242862549],
          [21.136723526728304, 9.945467979164277],
          [20.226340303666973, 9.58506455218577],
          [19.55344835618689, 9.305908140537696],
          [18.388907803117547, 8.874673982245497],
          [17.18478537078471, 8.57676825936727],
          [16.580640897814988, 8.37469234944291],
          [14.809872614972562, 7.897626541477138],
          [13.893239621501152, 7.668468293109299],
          [12.982856398439822, 7.308064866130792],
          [12.472458481620606, 7.014325656859285],
          [12.022475012098312, 6.835165571771711],
          [11.349583064618173, 6.462262603973102],
          [10.93501496075271, 6.078943352157808],
          [10.643359008284506, 5.803953454116424],
          [10.216291363598998, 5.547712867305108],
          [9.95380100637766, 5.306055078117197],
          [9.803806516536895, 5.072730316142668],
          [9.595480836202512, 4.914402799088521],
          [9.372572358244724, 4.764408309247756],
          [9.182995989140409, 4.593581251373564],
          [9.005919160856138, 4.426920707106035],
          [8.739262290028137, 4.249843878821764],
          [8.497604500840225, 4.095682875374337],
          [8.260113225259033, 3.9415218719268523],
          [7.891376771067144, 3.7498622460192337],
          [7.645552468272513, 3.597784499375109],
          [7.510140776055152, 3.462372807157749],
          [7.422643990314668, 3.3019620333002706],
          [7.358063029411028, 3.1644670842795506],
          [7.2143183099802854, 3.091553096162528],
          [7.1247382674364985, 3.0019730536187126],
          [7.049741022516116, 2.92905906550169],
          [6.9080795598887335, 2.86031159099133],
          [6.776834381278036, 2.79156411648097],
          [6.706003649964373, 2.7248998987739697],
          [6.622673377830608, 2.579071922539896],
          [6.047694500107696, 2.351996930975389],
          [5.808119967723087, 2.1124223985908372],
          [5.383135579840882, 1.8978469478464035],
          [4.9873167872056, 1.6436896178384472],
          [4.741492484410969, 1.3957820582405134],
          [4.4727523567795515, 1.1957894051194558],
          [4.324841123742203, 1.0520446856887418],
          [4.193595945131506, 0.9832972111783818],
          [4.104015902587662, 0.8937171686345948],
          [0, 0],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "ellipse",
        version: 251,
        versionNonce: 1372089817,
        isDeleted: false,
        id: "Iz1oZz-YhYEeDnoYBWBBZ",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 299.22449418128934,
        y: 275.77627576621484,
        strokeColor: "#c2255c",
        backgroundColor: "#e64980",
        width: 18.528486008941513,
        height: 18.528486008941513,
        seed: 43864471,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 337,
        versionNonce: 1913604793,
        isDeleted: false,
        id: "BQm3AQ3JrJejX5JoRsu67",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 239.27252989465552,
        y: 329.880538205862,
        strokeColor: "#c2255c",
        backgroundColor: "#e64980",
        width: 18.528486008941513,
        height: 18.528486008941513,
        seed: 1750581751,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
      },
      {
        type: "freedraw",
        version: 189,
        versionNonce: 589794201,
        isDeleted: false,
        id: "ypzOWj2zV7UWrx3LR5p5s",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 313.7197950189569,
        y: 222.79905525717675,
        strokeColor: "#f08c00",
        backgroundColor: "#fab005",
        width: 73.1868947582783,
        height: 17.820178695804657,
        seed: 1695774681,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, -0.07291398811705108],
          [-0.3166550341082939, -0.14582797623410215],
          [-1.381199260617052, -0.14582797623410215],
          [-3.166550341082882, -0.14582797623410215],
          [-5.376885809430917, -0.14582797623410215],
          [-8.835092102981946, 0.06041444729697787],
          [-13.095352265820395, 0.4624830103423676],
          [-17.56393810899334, 1.3541169221736027],
          [-21.715868918057936, 2.381162526222198],
          [-24.599096333886052, 2.9290590655016615],
          [-27.88439231275953, 3.5936179857683896],
          [-31.236352509340065, 4.576915196946771],
          [-33.70917833490938, 5.406051404677697],
          [-36.15908833564191, 6.251853666835359],
          [-38.398589399236755, 7.078906617762925],
          [-40.43809780971054, 7.555972425728726],
          [-42.81926033593271, 8.295528590915808],
          [-44.508781603444675, 8.928838659132396],
          [-45.6024914252003, 9.295491856520954],
          [-46.88786087286354, 9.71839298759977],
          [-47.90240693609206, 10.05588058974152],
          [-48.96486790579752, 10.520446856887247],
          [-50.156490797310255, 10.96418055599952],
          [-51.26478341668934, 11.387081687078336],
          [-52.183499666963996, 11.837065156600659],
          [-52.9397218865779, 12.164136474725638],
          [-53.62719663168144, 12.407877520716909],
          [-54.30842160637491, 12.637035769084719],
          [-54.912566079344685, 12.839111679009108],
          [-55.4875449570676, 13.028688048113395],
          [-56.050024293970466, 13.243263498857857],
          [-56.525006845132964, 13.426590097552122],
          [-57.24164718548326, 13.628666007476482],
          [-58.08953270444425, 13.872407053467725],
          [-58.99158290029226, 14.124481126672379],
          [-59.75405489031613, 14.334890063810121],
          [-60.47069523066648, 14.536965973734482],
          [-61.51232363233845, 14.803622844562483],
          [-62.52270318196031, 15.03069783612699],
          [-63.76015772314662, 15.276522138921592],
          [-65.41009711139515, 15.609843227456622],
          [-66.94129086185296, 15.916081977548203],
          [-68.3308231496834, 16.193155132392974],
          [-69.5370288388196, 16.457728746417644],
          [-70.27450174720337, 16.661887913145364],
          [-71.04114025083396, 16.876463363889798],
          [-71.77444664561102, 17.107704869060967],
          [-72.23276314234676, 17.28686495414854],
          [-72.59524982612862, 17.449358984809408],
          [-72.92023788745024, 17.545188797763217],
          [-73.12439705417796, 17.609769758666886],
          [-73.1868947582783, 17.674350719570555],
          [-73.1868947582783, 17.674350719570555],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "freedraw",
        version: 160,
        versionNonce: 222605433,
        isDeleted: false,
        id: "gt5gcetaw8b4anTIHDwId",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 222.11274360551096,
        y: 301.0982622108612,
        strokeColor: "#f08c00",
        backgroundColor: "#fab005",
        width: 70.28491803122006,
        height: 17.724348882850848,
        seed: 847714327,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.07291398811705108, 0.07083073131371975],
          [0.029165595246809062, 0.1416614626274395],
          [1.3770327470103894, 0.1416614626274395],
          [5.231057833196786, -0.09999632656047197],
          [10.410034246310005, -0.9666311567516459],
          [18.12433418909282, -2.35616344458208],
          [27.965639328089907, -4.356089975792315],
          [36.6132383187709, -6.847665112591699],
          [45.154591212481336, -9.157996907500205],
          [51.88976045769252, -10.772520930091844],
          [56.27293277192828, -12.27871559890957],
          [59.76863768793956, -13.65991485952668],
          [63.143513709356824, -14.793206560545741],
          [66.02882438198824, -15.955663856811725],
          [67.40794038580205, -16.530642734534695],
          [68.52664928919776, -16.891046161513202],
          [69.23495660233473, -17.166036059554585],
          [69.50369672996604, -17.257699358901732],
          [69.75160428956403, -17.34727940144552],
          [69.92868111784824, -17.368111969478946],
          [69.99951184916196, -17.441025957596025],
          [70.0765923508857, -17.513939945713048],
          [70.21200404310301, -17.582687420223408],
          [70.21200404310301, -17.582687420223408],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "freedraw",
        version: 216,
        versionNonce: 103430489,
        isDeleted: false,
        id: "An8IewHH4If6yL8Xb0EJ6",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 348.1164480989698,
        y: 335.5511632245644,
        strokeColor: "#f08c00",
        backgroundColor: "#fab005",
        width: 58.597847364460165,
        height: 15.368185438268767,
        seed: 1956111991,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.17707682828421412, 0],
          [-1.5499430616879408, 0],
          [-4.27692621726527, 0],
          [-6.597674296190462, 0],
          [-9.691310649156321, 0],
          [-14.303641211759953, 0],
          [-18.09933510745276, 0],
          [-20.33883617104749, 0],
          [-22.717915440466356, 0],
          [-25.274071538169494, 0],
          [-27.51565585856764, -0.15832751705414694],
          [-29.671826650028663, -0.3312378317316984],
          [-31.532174975414875, -0.06874747451036001],
          [-33.53626802023183, 0.39581879263539577],
          [-35.61327505316575, 0.9228827638813755],
          [-37.47570663535532, 1.5624426025079856],
          [-39.304806108691366, 2.464492798355991],
          [-41.43181130490558, 3.616533810605233],
          [-43.12549908602426, 4.4810853839929905],
          [-44.617110957218586, 5.228974576393455],
          [-46.48579230981812, 6.162273624291572],
          [-48.266976876677234, 7.285149041294005],
          [-49.45859976819003, 8.216364832388763],
          [-50.406481613711605, 8.818426048555182],
          [-51.56060588276415, 9.562148727348983],
          [-52.5293202963191, 10.247540215649167],
          [-53.17929641896245, 10.778770700501923],
          [-53.99593308587333, 11.362082605438218],
          [-54.91673259295135, 12.03705780972166],
          [-56.30209836717512, 13.199515105987643],
          [-56.997906139492045, 13.784910267727298],
          [-57.399974702537406, 14.09323227462221],
          [-57.7166297366457, 14.330723550203402],
          [-58.14578063813457, 14.574464596194673],
          [-58.439519847406075, 14.764040965298989],
          [-58.52909988994986, 14.901535914319652],
          [-58.597847364460165, 15.036947606537069],
          [-58.597847364460165, 15.036947606537069],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "ellipse",
        version: 212,
        versionNonce: 1596696121,
        isDeleted: false,
        id: "K-iNW4wHwdRUEtLJHQmsJ",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 238.99129022620411,
        y: 219.95540972061218,
        strokeColor: "#c2255c",
        backgroundColor: "#e64980",
        width: 18.528486008941513,
        height: 18.528486008941513,
        seed: 150239543,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703141746269,
        link: null,
        locked: false,
      },
      {
        id: "X_1FB0ZAVz1ZCIfvR8xek",
        type: "rectangle",
        x: 178.55888041410088,
        y: 418.9616459959034,
        width: 27.68461997177525,
        height: 22.077041483602954,
        angle: 0,
        strokeColor: "#40c057",
        backgroundColor: "#40c057",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        seed: 613444288,
        version: 54,
        versionNonce: 1054103872,
        isDeleted: false,
        boundElements: null,
        updated: 1703155233866,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 112,
        versionNonce: 1153051328,
        isDeleted: false,
        id: "RuIhfhT-cr7VBKgybxLrj",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 298.4625418231303,
        y: 424.47717461537013,
        strokeColor: "#40c057",
        backgroundColor: "#40c057",
        width: 27.68461997177525,
        height: 22.077041483602954,
        seed: 1912539456,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155246958,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 134,
        versionNonce: 616350016,
        isDeleted: false,
        id: "uuq1Z8RlMD1QrJhEU63Ky",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 214.04534871724627,
        y: 388.620019003113,
        strokeColor: "#fa5252",
        backgroundColor: "#fa5252",
        width: 27.68461997177525,
        height: 22.077041483602954,
        seed: 1859920192,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155242598,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 171,
        versionNonce: 180019904,
        isDeleted: false,
        id: "DjWuxBbNLrrbpJqoGHPGa",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 342.00710538944793,
        y: 382.5994600229102,
        strokeColor: "#fa5252",
        backgroundColor: "#fa5252",
        width: 27.68461997177525,
        height: 22.077041483602954,
        seed: 1995272512,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155243975,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 250,
        versionNonce: 945486528,
        isDeleted: false,
        id: "LKXHxQ5bZnE_nJJEcSoeu",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 233.22903892234686,
        y: 434.50812246998885,
        strokeColor: "#fa5252",
        backgroundColor: "#fa5252",
        width: 27.68461997177525,
        height: 22.077041483602954,
        seed: 446767808,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155250409,
        link: null,
        locked: false,
      },
    ],
    base64:
      "data:image/jpeg;base64,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",
  },
  {
    name: "Santa Claus",
    prompt: "Santa Claus with gifts",
    base64:
      "data:image/jpeg;base64,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",
    elements: [
      {
        type: "ellipse",
        version: 467,
        versionNonce: 1561771120,
        isDeleted: false,
        id: "7xALkFHlHl3u3zU6H7uWR",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 311.8466275490225,
        y: 96.59634693188832,
        strokeColor: "transparent",
        backgroundColor: "#fa5252",
        width: 310.9238492134734,
        height: 375.6040534274463,
        seed: 1338615920,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703155043595,
        link: null,
        locked: false,
      },
      {
        type: "text",
        version: 709,
        versionNonce: 1782956176,
        isDeleted: false,
        id: "JMYWI5jjN10TVeu4sgLx0",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 291.4483674770814,
        y: -157.69515413683553,
        strokeColor: "#40c057",
        backgroundColor: "#40c057",
        width: 366.5085674555726,
        height: 458.14252050349495,
        seed: 1104873076,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703154988026,
        link: null,
        locked: false,
        fontSize: 366.5140164027957,
        fontFamily: 1,
        text: "🎅",
        textAlign: "left",
        verticalAlign: "top",
        containerId: null,
        originalText: "🎅",
        lineHeight: 1.25,
        baseline: 323.00000000000034,
      } as unknown as ExcalidrawElement,
      {
        id: "pX6dx-iwB4Vtm7OQd5CTv",
        type: "rectangle",
        x: 837.4922825328608,
        y: 17.026967215046056,
        width: 83.0543724951364,
        height: 89.75755476460299,
        angle: 0,
        strokeColor: "transparent",
        backgroundColor: "#fa5252",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        seed: 1699046544,
        version: 312,
        versionNonce: 1162960016,
        isDeleted: false,
        boundElements: null,
        updated: 1703155036067,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 467,
        versionNonce: 932696688,
        isDeleted: false,
        id: "tYGhPVo1CuzlaCKjfTXuH",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 933.5433830820264,
        y: 114.81740330339528,
        strokeColor: "transparent",
        backgroundColor: "#40c057",
        width: 84.18762943974625,
        height: 90.98227501968819,
        seed: 1682224272,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155030700,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 500,
        versionNonce: 1204070544,
        isDeleted: false,
        id: "8ouhBAfRBucorwzJuhTBS",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 922.0794664252235,
        y: -83.4214861954749,
        strokeColor: "transparent",
        backgroundColor: "#40c057",
        width: 84.18762943974625,
        height: 90.98227501968819,
        seed: 1304032880,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155031953,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 549,
        versionNonce: 746905200,
        isDeleted: false,
        id: "WmRwav1u0Kdc_Snr_Ltfv",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 789.6224945575646,
        y: 138.7074704626327,
        strokeColor: "transparent",
        backgroundColor: "#40c057",
        width: 84.18762943974625,
        height: 90.98227501968819,
        seed: 1228442736,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703155034859,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 608,
        versionNonce: 1779901552,
        isDeleted: false,
        id: "JEgt2cOWBDg1-3SwjP34W",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 355.50068467623845,
        y: 390.28586853832286,
        strokeColor: "transparent",
        backgroundColor: "#fa5252",
        width: 105.70031057424848,
        height: 202.90245309028614,
        seed: 375529104,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703155049658,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 670,
        versionNonce: 1341332112,
        isDeleted: false,
        id: "ONC4chE1L5twU0bjw4rWv",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 490.48999296653005,
        y: 387.6599399564589,
        strokeColor: "transparent",
        backgroundColor: "#fa5252",
        width: 105.70031057424848,
        height: 202.90245309028614,
        seed: 1750480528,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703155051775,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 808,
        versionNonce: 194710672,
        isDeleted: false,
        id: "4w5brcn3UdXiuzkUvLG_M",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 5.292384144713878,
        x: 221.85910347887915,
        y: 106.79789228811052,
        strokeColor: "transparent",
        backgroundColor: "#fa5252",
        width: 105.70031057424848,
        height: 202.90245309028614,
        seed: 1538897552,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703155056721,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 957,
        versionNonce: 1571677840,
        isDeleted: false,
        id: "U-Nl6sr_LV7kgnmGKGafL",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 4.475235967117692,
        x: 579.3276705089731,
        y: 134.20702463444854,
        strokeColor: "transparent",
        backgroundColor: "#fa5252",
        width: 105.70031057424848,
        height: 202.90245309028614,
        seed: 698574960,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703155062210,
        link: null,
        locked: false,
      },
    ],
  },
  {
    name: "Santa Claus's reindeer",
    prompt: "Santa Claus's reindeer with gifts",
    base64:
      "data:image/jpeg;base64,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",
    elements: [
      {
        id: "yUvBAwn7lq45OIK6gQfrF",
        type: "freedraw",
        x: 297.19152464294956,
        y: 73.76453582241925,
        width: 138.30573320732123,
        height: 195.1057874865728,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 768251910,
        version: 90,
        versionNonce: 567375238,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, -0.6274210024348577],
          [0, -4.5617197588794625],
          [0, -12.157204600120508],
          [0, -35.46774019646574],
          [0, -50.70299842029618],
          [0, -80.3689397001288],
          [-0.7602866264799104, -96.11351614946523],
          [-2.5982610924361325, -109.94630389726476],
          [-6.451364189742094, -122.26589981566255],
          [-10.57019853513816, -135.58198791439807],
          [-13.485860840570808, -144.15920208886075],
          [-17.560406644618524, -151.2896572459442],
          [-21.981879355894876, -157.72625858857023],
          [-26.366444949380934, -163.7864073297353],
          [-31.068411755863508, -169.3003307276042],
          [-35.38654453732704, -173.30106229607134],
          [-39.11416343414601, -176.51198154382627],
          [-43.54301756898053, -179.82624072139402],
          [-47.292780736473674, -182.61641882633973],
          [-50.21582446546438, -185.1113399889631],
          [-54.26084457527986, -187.73912677563158],
          [-57.78916503603125, -189.61400835937815],
          [-61.789896604498324, -190.92052032915433],
          [-67.85742676922155, -192.6699177124139],
          [-74.6704807133085, -193.82880121102892],
          [-81.00374212612172, -193.82880121102892],
          [-88.59922696736277, -193.82880121102892],
          [-94.5043658138087, -193.82880121102892],
          [-100.03305205879366, -193.82880121102892],
          [-107.94593811303116, -193.82880121102892],
          [-113.07602748588107, -193.82880121102892],
          [-118.23564255296316, -193.82880121102892],
          [-124.22197705854774, -193.82880121102892],
          [-131.67721485218567, -193.82880121102892],
          [-133.92854903739317, -193.82880121102892],
          [-135.53031794949163, -193.82880121102892],
          [-136.46775874136495, -194.02809964709644],
          [-136.97707696687087, -194.28644947162843],
          [-137.54544658084131, -194.5964692610669],
          [-138.04738338278923, -194.84743766204082],
          [-138.30573320732123, -195.1057874865728],
          [-138.30573320732123, -195.1057874865728],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [-138.30573320732123, -195.1057874865728],
      },
      {
        id: "CvZXVhWylU5Cid3kX8Qu8",
        type: "freedraw",
        x: 236.4793158779276,
        y: -104.44517313976019,
        width: 73.6518442622966,
        height: 39.63086308321016,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1369904710,
        version: 73,
        versionNonce: 1683281094,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0.2509684009739317, -0.258349824532047],
          [-2.804940952061827, -0.516699649064094],
          [-8.134328760979258, -0.516699649064094],
          [-12.762481331881247, -0.516699649064094],
          [-19.951987877429133, 1.3138933933341832],
          [-27.104587305186726, 4.008112992025133],
          [-33.615002883393345, 7.292846475360648],
          [-40.479726792386714, 11.455969362105066],
          [-48.51809704711121, 15.729813602220247],
          [-51.37470796407945, 17.84828216338269],
          [-55.80356209891386, 21.288025541437463],
          [-58.34277180288558, 23.79770955117698],
          [-60.02573637412269, 25.11898436806925],
          [-61.8932365343112, 26.610031926796836],
          [-63.089027150716504, 27.532709871554005],
          [-63.98217940124147, 28.41109927496285],
          [-65.59871116045599, 30.263836588035247],
          [-67.69503545094432, 32.73661347998447],
          [-69.5330099169006, 34.62625791084716],
          [-70.92809896937342, 35.94753272773943],
          [-71.79172552566615, 37.0252205672158],
          [-72.62582638772665, 37.85932142927629],
          [-73.07609322476816, 38.553175243733676],
          [-73.40087586132267, 39.114163434146064],
          [-73.40087586132267, 39.114163434146064],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [-73.40087586132267, 39.114163434146064],
      },
      {
        id: "5NCClVhnUMBTRr2QDSS0z",
        type: "freedraw",
        x: 257.95187700831656,
        y: -79.71740422026798,
        width: 80.87087650207667,
        height: 60.904125777531476,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1668043078,
        version: 67,
        versionNonce: 363482118,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0.25096840097387485, -0.2583498245320186],
          [-0.11810277692893578, -0.5166996490640088],
          [-4.059782956931599, 0.029525694232233946],
          [-9.315356530268446, 1.350800511124504],
          [-15.013815517088801, 4.5174312175311115],
          [-23.908430904547913, 10.525909993789838],
          [-32.648036397287854, 16.194843286377903],
          [-41.44669327849226, 22.491197581400854],
          [-51.10159529243134, 30.367176517848094],
          [-56.06929334700396, 34.58935079305692],
          [-59.981447832774336, 38.46459816103703],
          [-66.85355316532576, 45.203837869543435],
          [-71.88768403192091, 50.223205889022466],
          [-74.60404790128604, 53.31602235984849],
          [-77.05468052256111, 55.88475775805247],
          [-79.52745741451031, 58.94066711108823],
          [-80.04415706357435, 59.74524227891649],
          [-80.6199081011028, 60.38742612846747],
          [-80.6199081011028, 60.38742612846747],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [-80.6199081011028, 60.38742612846747],
      },
      {
        id: "d4ZotaD1begEkglrmUWb8",
        type: "freedraw",
        x: 421.2953989245685,
        y: 72.68684798294288,
        width: 149.5550227098007,
        height: 245.292086257805,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1015470278,
        version: 83,
        versionNonce: 1137630022,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, -0.2583498245319902],
          [0, -3.063290776593817],
          [0, -11.182856690456958],
          [0, -26.68384616237745],
          [0, -40.642118110664],
          [0, -55.109708284456474],
          [2.6130239395522494, -77.58614301874121],
          [7.049259497944718, -99.74517654002946],
          [11.699556339520882, -117.67465436255085],
          [17.220861160947834, -134.17951743836718],
          [23.08909288960342, -150.24149510070004],
          [26.94957741046744, -158.97371916988192],
          [30.212166623128837, -164.90100228700203],
          [35.755615715229965, -174.65924423075387],
          [44.25901565411209, -186.19640925199758],
          [55.035894048875775, -198.78173641848542],
          [58.719224404346505, -202.55364385665274],
          [63.50238686996761, -207.83874312422182],
          [68.7358161726304, -214.15724168991898],
          [74.57452220705375, -221.24340830565404],
          [79.9703428279937, -226.87543448045182],
          [85.927151639346, -231.20094868547346],
          [91.93563041560469, -235.00238181787302],
          [96.65236006920338, -237.4603958627061],
          [110.65492055883828, -242.81930936585576],
          [117.41630453801884, -244.26606838323505],
          [124.56890396577637, -244.8934893856699],
          [131.39672075697945, -245.23303486934054],
          [137.85546637027971, -245.292086257805],
          [142.520526058972, -245.292086257805],
          [145.20736423410483, -244.95254077413438],
          [147.31106994815127, -244.3546454659317],
          [148.63972618860157, -243.79365727551937],
          [149.5550227098007, -243.19576196731674],
          [149.5550227098007, -243.19576196731674],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [149.5550227098007, -243.19576196731674],
      },
      {
        id: "zYF2nYM8h5Mw6gbGwrnrj",
        type: "freedraw",
        x: 488.47373472644875,
        y: -132.31004707142688,
        width: 25.76854964117831,
        height: 11.559309291917884,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 868906054,
        version: 61,
        versionNonce: 891257478,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [1.0924506865924286, 0],
          [3.71285604970285, 0],
          [7.08616661573501, 0.41335971925127524],
          [9.66228343749708, 1.1588834986150687],
          [15.353361000759264, 3.9712058742348972],
          [18.778341531697947, 5.314624961801314],
          [21.10348995248603, 6.355405683487447],
          [22.033549320801285, 7.123073733525416],
          [22.513341852074973, 7.595484841241046],
          [23.568885420877223, 8.318864349930664],
          [24.705624648818002, 9.455603577871557],
          [25.76854964117831, 11.559309291917884],
          [25.76854964117831, 11.559309291917884],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [25.76854964117831, 11.559309291917884],
      },
      {
        id: "hGYp3BlvYVc75mXj_HPwZ",
        type: "freedraw",
        x: 430.30073566539846,
        y: -61.596009385237096,
        width: 75.58577723450765,
        height: 35.895862762833076,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1673085530,
        version: 64,
        versionNonce: 1549353414,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, 0.2509684009739601],
          [9.057006705736399, 0.5019368019478918],
          [14.784991386788874, 0.5019368019478918],
          [22.62406320544585, 1.5943874885404057],
          [33.20902458770013, 5.462253432962456],
          [44.657612526247135, 10.282323016373937],
          [52.20880882613983, 13.589200770383655],
          [58.07704055479553, 17.338963937876798],
          [63.57620110554819, 21.258499847205258],
          [66.58044049367766, 23.960100869454266],
          [69.52562849334254, 27.355555706160686],
          [72.18294097424314, 31.34890585106973],
          [73.64446283873849, 33.69619854253196],
          [74.81810918446968, 34.86984488826309],
          [75.58577723450765, 35.895862762833076],
          [75.58577723450765, 35.895862762833076],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [75.58577723450765, 35.895862762833076],
      },
      {
        type: "ellipse",
        version: 328,
        versionNonce: 1285101830,
        isDeleted: false,
        id: "_6sA6Ji1CDIruEYzHbQ3s",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 359.88933634508913,
        y: 225.21289367486162,
        strokeColor: "transparent",
        backgroundColor: "#fd7e14",
        width: 583.2062753221143,
        height: 223.428309678839,
        seed: 805130586,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1703161268716,
        link: null,
        locked: false,
      },
      {
        id: "P3tji-2qeDG-7dGCb9W2S",
        type: "freedraw",
        x: 462.5132680727608,
        y: 396.8346821114749,
        width: 126.61355829135829,
        height: 256.9694983266519,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 377853914,
        version: 73,
        versionNonce: 761006150,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, -0.258349824532047],
          [0, 1.9413143957691545],
          [0, 6.259447177232687],
          [-1.6534388770047599, 12.400791577536438],
          [-8.392678585511248, 29.806188327435734],
          [-21.642333872224185, 58.394441767792046],
          [-28.16013087398892, 72.97275329495528],
          [-33.68881711897393, 85.36616344893366],
          [-40.184469850064374, 98.31318036976631],
          [-45.617197588794625, 108.52907057411778],
          [-51.263986610708514, 119.79312292371333],
          [-57.46438239947673, 132.19391450124976],
          [-62.439461877607414, 141.4576010666118],
          [-68.307693606263, 151.85064543635656],
          [-72.39700225742683, 159.34279034778478],
          [-75.63006577585594, 165.794154537527],
          [-79.21743762507185, 172.96151681240076],
          [-81.84522441174028, 179.1028612127045],
          [-84.26633133878306, 184.5282075278767],
          [-88.64351550871112, 192.99470034896854],
          [-91.83229048579193, 200.04395984691314],
          [-93.71455349309656, 204.6056796057926],
          [-96.57116441006474, 211.61803198594725],
          [-98.97750848999146, 217.21315104295468],
          [-101.17717271029255, 221.5681909422085],
          [-102.93395151711019, 226.25539490157507],
          [-104.6169160883473, 231.00165024940588],
          [-106.24082927111994, 234.47830074525086],
          [-107.2668471456899, 236.90678909585176],
          [-108.48478203276937, 239.74125574214577],
          [-109.76176830831332, 242.39118679948842],
          [-110.58110632325764, 244.7163352202765],
          [-111.25281586704091, 246.4214440621879],
          [-111.79904121033712, 247.5508018665705],
          [-112.63314207239762, 248.68015967095334],
          [-116.03597833266207, 253.09425095867164],
          [-117.9182413399667, 254.3417115399834],
          [-119.49786598139099, 255.28653375541467],
          [-120.3098225727773, 255.8106148280367],
          [-121.25464478820862, 256.4306544069136],
          [-121.72705589592431, 256.6816228078876],
          [-122.18470415652388, 256.67424138432943],
          [-122.7825994647265, 256.71114850211984],
          [-123.72742168015787, 256.71114850211984],
          [-124.63533677779895, 256.71114850211984],
          [-125.1225107326307, 256.71114850211984],
          [-125.58754041678833, 256.71114850211984],
          [-126.08209579517819, 256.71114850211984],
          [-126.61355829135829, 256.71114850211984],
          [-126.61355829135829, 256.71114850211984],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [-126.61355829135829, 256.71114850211984],
      },
      {
        id: "-1A9M4H83CADxlPVLFPyC",
        type: "freedraw",
        x: 485.37353683206453,
        y: 432.6714934858435,
        width: 3.572609002099739,
        height: 161.54983599164393,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 297601798,
        version: 43,
        versionNonce: 780078982,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, 1.1072135337086593],
          [0, 6.503034154648617],
          [0, 14.976908399298395],
          [0, 25.561869781552787],
          [0, 78.19880117406001],
          [0, 91.83967190935005],
          [0, 101.33218260501178],
          [-0.6421838495509746, 112.33050370651733],
          [-1.9265515486529239, 123.2550105724423],
          [-2.9599508467809983, 129.92781746892615],
          [-3.4323619544966277, 133.8694976489287],
          [-3.543083307867505, 137.2428082149611],
          [-3.572609002099739, 141.16972554784752],
          [-3.572609002099739, 145.2664156225694],
          [-3.572609002099739, 149.5402598626847],
          [-3.572609002099739, 153.22359021815532],
          [-3.572609002099739, 156.27949957119108],
          [-3.572609002099739, 159.36493461845907],
          [-3.572609002099739, 161.54983599164393],
          [-3.572609002099739, 161.54983599164393],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [-3.572609002099739, 161.54983599164393],
      },
      {
        id: "CIQZc8QTbkPRsAMxRr-WS",
        type: "freedraw",
        x: 827.3844159710955,
        y: 429.0915030601857,
        width: 19.15479413315893,
        height: 157.7779285534766,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 947356102,
        version: 63,
        versionNonce: 2084515526,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.3764526014608691, -1.1219763808247762],
          [-0.7529052029218519, -0.5757510375284483],
          [-1.446759017379236, 7.949793172027739],
          [-1.417233323147002, 24.476800518518303],
          [1.6165317592145811, 44.709282491153544],
          [6.163488670977927, 70.58117206214467],
          [11.935761893378867, 103.99687650947044],
          [15.847916379149297, 129.6177976794877],
          [16.86655283016114, 144.09276927683823],
          [17.708035115779694, 156.65595217265184],
          [17.708035115779694, 156.65595217265184],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [17.708035115779694, 156.65595217265184],
      },
      {
        id: "P9qTfD2qC6TotUinVYdP_",
        type: "freedraw",
        x: 853.4998925195025,
        y: 425.0686272210444,
        width: 89.58095630058449,
        height: 221.54604667153433,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "transparent",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1178259270,
        version: 67,
        versionNonce: 859399686,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [0, -0.258349824532047],
          [0.25096840097398854, -0.5166996490639804],
          [2.4653954683911934, -0.5166996490639804],
          [8.163854455211435, 2.2808598794397312],
          [18.704527296117476, 14.452827326676356],
          [32.7366134799845, 37.24666327395755],
          [46.45129845085512, 64.56531186232792],
          [61.863710840078966, 102.74203450460072],
          [70.96500608716372, 130.0975902107615],
          [75.9991369537588, 148.8464060482272],
          [84.13346571473812, 178.28352319776013],
          [88.75423686208205, 203.6534759668034],
          [89.43332782942332, 213.63316061729688],
          [89.58095630058449, 221.02934702247035],
          [89.58095630058449, 221.02934702247035],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [89.58095630058449, 221.02934702247035],
      },
      {
        id: "lp1Jtp7uRm9W8t5HJsC7l",
        type: "ellipse",
        x: 252.98568932984898,
        y: 38.02730945281547,
        width: 190.16363597228644,
        height: 308.90519448114355,
        angle: 0.43352766485477545,
        strokeColor: "transparent",
        backgroundColor: "#ffa94d",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        seed: 602198426,
        version: 318,
        versionNonce: 1232928346,
        isDeleted: false,
        boundElements: null,
        updated: 1703161296369,
        link: null,
        locked: false,
      },
      {
        id: "ZYeFRpiJE06vO2q7e8Evb",
        type: "ellipse",
        x: 578.7559262650486,
        y: 218.1968505829281,
        width: 206.9751165679291,
        height: 72.552012152146,
        angle: 0,
        strokeColor: "transparent",
        backgroundColor: "#2f9e44",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        seed: 301985990,
        version: 290,
        versionNonce: 1611911322,
        isDeleted: false,
        boundElements: null,
        updated: 1703161284257,
        link: null,
        locked: false,
      },
      {
        id: "EX6hhFXzlOt13bYDphfOr",
        type: "freedraw",
        x: 292.3419293653059,
        y: 148.84099483142086,
        width: 38.66389659710461,
        height: 0,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "#fd7e14",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1281688582,
        version: 37,
        versionNonce: 122067910,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.258349824532047, 0],
          [0.6052767317606822, 0],
          [3.742381743935084, 0],
          [8.377915738395131, 0],
          [14.57831152716335, 0],
          [21.472561130388954, 0],
          [25.237087144998213, 0],
          [28.322522192266206, 0],
          [32.21991383092046, 0],
          [34.382670933431314, 0],
          [36.04349123399419, 0],
          [37.48286882781542, 0],
          [38.40554677257256, 0],
          [38.40554677257256, 0],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [38.40554677257256, 0],
      },
      {
        id: "FzO5JVKAZJSMfiRTspsTn",
        type: "freedraw",
        x: 403.07066415972474,
        y: 150.24346530745174,
        width: 21.214211305856963,
        height: 0,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "#fd7e14",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1816151878,
        version: 34,
        versionNonce: 617296646,
        isDeleted: false,
        boundElements: null,
        updated: 1703161268716,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.258349824532047, 0],
          [0.6052767317606822, 0],
          [3.587371849215856, 0],
          [6.443982766184092, 0],
          [10.090406003864416, 0],
          [13.891839136263968, 0],
          [15.936493461845885, 0],
          [18.09186914079862, 0],
          [20.047946383683836, 0],
          [20.955861481324916, 0],
          [20.955861481324916, 0],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [20.955861481324916, 0],
      },
      {
        id: "aw2KSYi6PhfTNTBJvQ2XX",
        type: "freedraw",
        x: 272.03563315709,
        y: 251.11799965186412,
        width: 116.0581226033363,
        height: 41.8821972684176,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "#fd7e14",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: null,
        seed: 1566421402,
        version: 38,
        versionNonce: 630182214,
        isDeleted: false,
        boundElements: null,
        updated: 1703161273191,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [1.4689032880534683, 2.95256942322294],
          [3.668567508354556, 6.503034154648503],
          [7.470000640754108, 11.28619662026972],
          [15.670762213755836, 22.793835947281195],
          [20.557264609189872, 29.053283124513882],
          [23.11861858383577, 31.96156400638847],
          [25.39209703971744, 34.235042462270144],
          [26.846237480654736, 35.15033898346928],
          [27.63604980136688, 35.42345165511733],
          [28.536583475449902, 35.72609002099773],
          [29.10495308942029, 35.755615715229965],
          [29.643797009158504, 35.76299713878802],
          [30.411465059196473, 35.76299713878802],
          [32.035378241969056, 35.76299713878802],
          [34.39743378054743, 35.76299713878802],
          [36.94402490807727, 35.76299713878802],
          [39.852305789951856, 35.408688808001216],
          [43.32895628579689, 34.62625791084713],
          [51.751160565540374, 32.803046292007025],
          [55.49354230947546, 31.555585710695254],
          [61.16247560206352, 29.414972878858634],
          [66.38852348116814, 27.3481742826026],
          [72.544630728588, 24.77205746084053],
          [79.54960168518448, 21.34707692990196],
          [83.42484905316462, 19.05883562690417],
          [88.72471116784982, 15.921730614729768],
          [98.52724165295001, 8.783894034088235],
          [102.73465308104272, 5.078419407943443],
          [107.46614558175753, 0.9817293332215513],
          [111.11256881943785, -1.7567788068176924],
          [112.89149189692972, -3.1444864357324604],
          [114.05037539554468, -4.310751357905588],
          [115.06901184655663, -5.33676923247549],
          [115.60047434273673, -5.875613152213759],
          [116.0581226033363, -6.119200129629576],
          [116.0581226033363, -6.119200129629576],
        ],
        pressures: [],
        simulatePressure: true,
        lastCommittedPoint: [116.0581226033363, -6.119200129629576],
      },
    ],
  },
  {
    name: "Kung Fu Panda",
    prompt: "Kung Fu Panda",
    elements: [
      {
        type: "rectangle",
        version: 272,
        versionNonce: 1541146198,
        isDeleted: false,
        id: "fCwIeuDdfCeD-eNuGWz8A",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 317.8955110523906,
        y: 12.884227843883139,
        strokeColor: "transparent",
        backgroundColor: "#e9ecef",
        width: 566.7938043946904,
        height: 198.99247833957514,
        seed: 1147822602,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        boundElements: [],
        updated: 1703145461178,
        link: null,
        locked: false,
      },
      {
        type: "text",
        version: 548,
        versionNonce: 1687073290,
        isDeleted: false,
        id: "JMYWI5jjN10TVeu4sgLx0",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 386.4845200223352,
        y: -190.5005429782866,
        strokeColor: "#40c057",
        backgroundColor: "#40c057",
        width: 422.7699890136719,
        height: 528.4703430116597,
        seed: 1104873076,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703145461178,
        link: null,
        locked: false,
        fontSize: 422.77627440932775,
        fontFamily: 1,
        text: "🐼",
        textAlign: "left",
        verticalAlign: "top",
        containerId: null,
        originalText: "🐼",
        lineHeight: 1.25,
        baseline: 372,
      } as unknown as ExcalidrawElement,
      {
        type: "text",
        version: 674,
        versionNonce: 1987365782,
        isDeleted: false,
        id: "gLHzD97GnKoreYPjUn7Yq",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 367.24510133854415,
        y: 376.3446309936107,
        strokeColor: "#1e1e1e",
        backgroundColor: "#40c057",
        width: 506.66015625,
        height: 207.52886413595104,
        seed: 1732611828,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703145461178,
        link: null,
        locked: false,
        fontSize: 172.94072011329254,
        fontFamily: 3,
        text: "PANDA",
        textAlign: "left",
        verticalAlign: "top",
        containerId: null,
        originalText: "PANDA",
        lineHeight: 1.2,
        baseline: 167,
      } as unknown as ExcalidrawElement,
    ],
    base64:
      "data:image/jpeg;base64,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",
  },
  {
    name: "Beer",
    prompt: "Beer on the desk",
    elements: [
      {
        id: "gJlLoVQWd_HjnX9cxGl2D",
        type: "rectangle",
        x: 218.36677890870186,
        y: -149.10713760576223,
        width: 778.6279354479998,
        height: 648.2941685640474,
        angle: 0,
        strokeColor: "#1e1e1e",
        backgroundColor: "#1e1e1e",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: { type: 3 },
        seed: 872346719,
        version: 101,
        versionNonce: 2099915199,
        isDeleted: false,
        boundElements: null,
        updated: 1703161537319,
        link: null,
        locked: false,
      },
      {
        type: "rectangle",
        version: 466,
        versionNonce: 651991519,
        isDeleted: false,
        id: "fCwIeuDdfCeD-eNuGWz8A",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 345.7538857630391,
        y: 160.07527963625654,
        strokeColor: "transparent",
        backgroundColor: "#e8590c",
        width: 533.0685383310793,
        height: 201.06755021281987,
        seed: 1147822602,
        groupIds: [],
        frameId: null,
        roundness: { type: 3 },
        boundElements: [],
        updated: 1703161537319,
        link: null,
        locked: false,
      },
      {
        type: "text",
        version: 686,
        versionNonce: 755762687,
        isDeleted: false,
        id: "JMYWI5jjN10TVeu4sgLx0",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 521.8401747644751,
        y: -32.222831409530926,
        strokeColor: "#40c057",
        backgroundColor: "#40c057",
        width: 201.61767872179755,
        height: 252.0258452590334,
        seed: 1104873076,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703161537319,
        link: null,
        locked: false,
        fontSize: 201.62067620722678,
        fontFamily: 1,
        text: "🍺",
        textAlign: "left",
        verticalAlign: "top",
        containerId: null,
        originalText: "🍺",
        lineHeight: 1.25,
        baseline: 177.99999999999991,
      } as unknown as ExcalidrawElement,
    ],
    base64:
      "data:image/jpeg;base64,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",
  },
  {
    name: "Nav officer",
    prompt: "nav officer with white hat looking at the viewer, rembrandt style",
    elements: [
      {
        type: "rectangle",
        version: 107,
        versionNonce: 637448533,
        isDeleted: false,
        id: "_O7B-B-0xLQYdm1dvBO1d",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 313.26652819370224,
        y: 202.27192493133506,
        strokeColor: "#1e1e1e",
        backgroundColor: "#1e1e1e",
        width: 453.5656059960347,
        height: 398.05675176198383,
        seed: 2095312347,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1700555503870,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 148,
        versionNonce: 1378336437,
        isDeleted: false,
        id: "v55Dq_0FvfIbXRHcbqC-5",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 509.2309221643378,
        y: 284.1002750684379,
        strokeColor: "#f08c00",
        backgroundColor: "#f08c00",
        width: 109.49891763772712,
        height: 98.3549063915446,
        seed: 1132427899,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1700555503870,
        link: null,
        locked: false,
      },
      {
        type: "freedraw",
        version: 402,
        versionNonce: 612900885,
        isDeleted: false,
        id: "SgkfPYbnUAva5MqTQNAF_",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 561.3450148900057,
        y: 358.2383877903935,
        strokeColor: "#4dabf7",
        backgroundColor: "#228be6",
        width: 236.46237686890026,
        height: 248.44187836737467,
        seed: 339768091,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1700555503870,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.5435345507474949, 0],
          [-1.97535985300226, 0],
          [-3.407185155257025, 0],
          [-5.699348003552132, 0],
          [-8.463609433067859, 0.6895124015196643],
          [-11.786934971923813, 1.7641578561404003],
          [-14.551196401439597, 2.453670257660008],
          [-17.315457830955324, 3.4879388599395043],
          [-19.219381714430767, 4.435241934099395],
          [-21.03944598150514, 5.037788807499453],
          [-23.769542382116754, 6.845429427699628],
          [-26.061705230411803, 8.13748870261935],
          [-28.912932188047137, 9.12516862912048],
          [-31.677193617562864, 10.504193432159752],
          [-34.44145504707859, 11.193705833679417],
          [-36.7336178953737, 11.839735471139306],
          [-38.16544319762846, 12.141008907839307],
          [-39.20902953506362, 12.398799580479533],
          [-40.25261587249878, 12.914380925759986],
          [-42.59447330829073, 14.336888492859146],
          [-44.026298610545496, 15.458122623258191],
          [-45.846362877619924, 16.663216370058308],
          [-47.27818817987469, 17.78445050045741],
          [-49.22559482740991, 19.421265976136908],
          [-50.74127974606574, 20.930739071355617],
          [-52.81602877406186, 22.99927627591461],
          [-55.533701527799224, 26.098976171034508],
          [-58.251374281536584, 29.19867606615435],
          [-62.040586578176146, 34.95703639235904],
          [-65.91676440293526, 42.70007430672166],
          [-68.62822533323555, 48.59198883682427],
          [-71.64095970023578, 55.51196014576931],
          [-74.6102113031763, 62.94751279999474],
          [-78.91189903337778, 72.09752872286367],
          [-83.04276161905858, 80.34683024735108],
          [-87.17362420473938, 88.08055042655803],
          [-90.65845715296035, 95.00052173550301],
          [-94.2737383933607, 103.24982325999042],
          [-98.01946792594043, 112.62346482659547],
          [-99.65938931333852, 117.14256637709587],
          [-100.74024659139639, 119.98758151129408],
          [-100.74024659139639, 120.72368258859211],
          [-101.12848555621599, 124.77689738130897],
          [-103.19702276077493, 129.29599893180944],
          [-104.36173965523386, 131.234087844189],
          [-108.1571637753105, 137.25645066647104],
          [-112.37188597739231, 143.57387510201596],
          [-115.99027312951125, 148.55886341029998],
          [-119.6086602816302, 153.54385171858394],
          [-121.93809407054795, 157.03179057852344],
          [-123.70846375012542, 159.48856674790204],
          [-124.6184958836626, 161.30241919153934],
          [-125.52852801719979, 163.11627163517664],
          [-126.52552567885658, 165.40222266003457],
          [-127.82690268893197, 168.5950999067112],
          [-129.21213931540842, 171.3531495127898],
          [-130.2091369770652, 173.63910053764772],
          [-131.42044254730246, 175.45295298128502],
          [-132.33047468083964, 177.26680542492232],
          [-133.19702405031705, 178.69241890373996],
          [-133.80578274715418, 180.50627134737726],
          [-134.41454144399137, 182.32012379101457],
          [-135.11026566894816, 185.07817339709317],
          [-136.57936191182563, 190.3333760248916],
          [-137.35583984146484, 194.20955384965077],
          [-138.4366971195227, 197.52666756506966],
          [-139.47717754523927, 200.28471717114826],
          [-140.17290177019606, 203.04276677722686],
          [-141.16989943185285, 205.32871780208484],
          [-141.82214089274981, 207.61466882694276],
          [-142.08303747710863, 208.65204334094085],
          [-142.08303747710863, 209.08687098153882],
          [-142.08303747710863, 209.26390794949657],
          [-142.6048306458262, 211.20820868531325],
          [-143.17010657860357, 212.6338221641309],
          [-144.12362147620058, 214.91977318898887],
          [-145.03365360973777, 216.73362563262612],
          [-145.29455019409653, 217.7710001466242],
          [-145.55544677845535, 218.50710122392223],
          [-145.81634336281417, 219.24320230122015],
          [-145.81634336281417, 220.49799063551728],
          [-146.0368630948317, 221.2340917128152],
          [-146.2573828268492, 221.97019279011323],
          [-146.2573828268492, 222.70629386741126],
          [-146.2573828268492, 223.4423949447093],
          [-146.2573828268492, 224.17849602200732],
          [-146.2573828268492, 225.2158705360053],
          [-146.2573828268492, 225.95197161330333],
          [-146.2573828268492, 226.68807269060136],
          [-146.2573828268492, 227.4241737678994],
          [-146.2573828268492, 228.0764152287963],
          [-146.2573828268492, 228.51124286939427],
          [-146.2573828268492, 228.94607050999224],
          [-145.78217833391005, 229.68217158729027],
          [-145.34735069331202, 230.11699922788824],
          [-144.91252305271405, 230.55182686848622],
          [-143.87514853871602, 231.06740821376667],
          [-142.837774024718, 231.58298955904712],
          [-141.41216054590035, 231.84078023168735],
          [-138.69138188044434, 232.1420536683874],
          [-136.8775294368071, 232.44332710508746],
          [-135.0636769931698, 232.44332710508746],
          [-133.63806351435215, 232.74460054178752],
          [-132.21245003553446, 232.74460054178752],
          [-131.17507552153643, 232.74460054178752],
          [-129.7494620427188, 232.74460054178752],
          [-128.3238485639011, 232.74460054178752],
          [-127.28647404990306, 232.74460054178752],
          [-125.73041227890604, 232.74460054178752],
          [-124.69303776490796, 232.74460054178752],
          [-123.65566325090992, 232.74460054178752],
          [-122.23004977209229, 232.74460054178752],
          [-120.80443629327459, 232.74460054178752],
          [-119.37882281445695, 233.04587397848746],
          [-117.95320933563931, 233.34714741518752],
          [-116.13935689200201, 233.94969428858764],
          [-114.32550444836471, 234.2509677252877],
          [-112.89989096954702, 234.81003183462786],
          [-110.17911230409112, 235.71385214472804],
          [-108.36525986045382, 236.6176724548281],
          [-106.55140741681652, 237.8227662016282],
          [-104.73755497317921, 239.02785994842833],
          [-103.31194149436158, 240.14909407882743],
          [-101.88632801554394, 241.00943162486766],
          [-101.15022693824591, 241.48463611780693],
          [-100.41412586094788, 241.95984061074608],
          [-99.67802478364985, 242.43504510368535],
          [-98.72450988605289, 242.65245892398428],
          [-97.98840880875485, 242.86987274428333],
          [-96.95103429475682, 243.12766341692355],
          [-96.21493321745885, 243.38545408956378],
          [-95.17755870346076, 243.643244762204],
          [-93.75194522464312, 243.643244762204],
          [-92.71457071064509, 243.90103543484418],
          [-91.677196196647, 243.90103543484418],
          [-90.63982168264903, 243.90103543484418],
          [-89.08375991165195, 243.90103543484418],
          [-87.65814643283426, 243.90103543484418],
          [-86.23253295401662, 243.90103543484418],
          [-84.41868051037932, 243.90103543484418],
          [-82.60482806674207, 243.90103543484418],
          [-80.79097562310477, 243.90103543484418],
          [-78.50502459824679, 243.90103543484418],
          [-76.69117215460955, 243.59665608642564],
          [-74.87731971097224, 243.29227673800705],
          [-72.97960765093393, 243.29227673800705],
          [-70.64706795029758, 243.29227673800705],
          [-69.91096687299961, 243.29227673800705],
          [-69.17486579570158, 243.29227673800705],
          [-68.7400381551036, 242.851237273972],
          [-68.52262433480456, 242.63071754195443],
          [-67.98219569577572, 242.63071754195443],
          [-66.16834325213841, 242.63071754195443],
          [-63.882392227280434, 242.63071754195443],
          [-61.12434262120183, 242.63071754195443],
          [-57.80722890578295, 242.63071754195443],
          [-55.04917929970435, 242.63071754195443],
          [-51.73206558428541, 242.63071754195443],
          [-48.97401597820681, 242.63071754195443],
          [-46.688064953348885, 242.93199097865448],
          [-44.402113928490905, 242.93199097865448],
          [-42.588261484853604, 243.23326441535454],
          [-40.255721784217315, 243.53453785205448],
          [-38.44186934058001, 243.8358112887546],
          [-36.62801689694277, 244.13708472545466],
          [-34.34206587208479, 244.4383581621547],
          [-32.05611484722681, 244.73963159885454],
          [-29.770163822368886, 244.73963159885454],
          [-27.484212797510907, 245.38566123631438],
          [-25.198261772652984, 245.68693467301443],
          [-23.384409329015682, 246.28948154641455],
          [-20.66363066355973, 246.89202841981466],
          [-18.849778219922484, 247.19330185651472],
          [-17.812403705924396, 247.19330185651472],
          [-17.076302628626422, 247.19330185651472],
          [-16.858888808327436, 247.19330185651472],
          [-16.50170896069335, 247.19330185651472],
          [-14.687856517056105, 247.19330185651472],
          [-12.401905492198125, 247.19330185651472],
          [-9.643855886119525, 247.88281425803427],
          [-6.8858062800408675, 247.88281425803427],
          [-4.599855255182945, 248.18408769473433],
          [-2.786002811545643, 248.18408769473433],
          [-1.3603893327280048, 248.44187836737467],
          [-0.3230148187299733, 248.44187836737467],
          [0.714359695268115, 248.44187836737467],
          [1.9691480295651331, 248.44187836737467],
          [2.1865618498641197, 248.44187836737467],
          [3.140076747461137, 248.44187836737467],
          [4.177451261459169, 248.44187836737467],
          [5.2148257754572, 248.44187836737467],
          [6.2522002894552315, 248.44187836737467],
          [7.67781376827287, 248.44187836737467],
          [9.103427247090565, 248.44187836737467],
          [9.839528324388539, 248.44187836737467],
          [10.57562940168657, 248.44187836737467],
          [11.3117304789846, 248.44187836737467],
          [13.256031214801283, 248.44187836737467],
          [14.68164469361892, 248.44187836737467],
          [15.719019207616952, 248.44187836737467],
          [17.144632686434647, 248.44187836737467],
          [18.570246165252286, 248.44187836737467],
          [19.607620679250317, 248.44187836737467],
          [21.033234158068012, 248.44187836737467],
          [23.319185182925935, 248.09401625489625],
          [25.605136207783914, 247.09701859323934],
          [30.860338835582354, 245.9726785511217],
          [34.17745255100124, 245.62481643864328],
          [36.46340357585916, 245.27695432616508],
          [38.74935460071714, 244.92909221368666],
          [39.78672911471517, 244.6681956293279],
          [40.221556755313145, 244.22715616529274],
          [40.43897057561213, 244.22715616529274],
          [41.31173176852667, 244.22715616529274],
          [42.73734524734431, 244.22715616529274],
          [44.162958726162, 244.22715616529274],
          [45.58857220497964, 244.22715616529274],
          [46.32467328227767, 244.22715616529274],
          [47.362047796275704, 244.22715616529274],
          [48.61683613057272, 244.48494683793285],
          [49.35293720787075, 244.7023606582319],
          [50.39031172186873, 244.96015133087224],
          [51.427686235866815, 244.96015133087224],
          [52.85329971468451, 244.96015133087224],
          [54.66715215832181, 244.96015133087224],
          [56.953103183179735, 244.96015133087224],
          [58.76695562681704, 244.96015133087224],
          [60.19256910563462, 244.96015133087224],
          [61.83559640475136, 244.96015133087224],
          [62.87297091874933, 244.4383581621547],
          [64.29858439756703, 243.31091220831837],
          [65.72419787638472, 242.1834662544822],
          [67.14981135520242, 241.05602030064603],
          [68.9636637988396, 239.84471473040884],
          [70.0010383128377, 238.80112839297368],
          [71.42665179165527, 237.6736824391375],
          [72.46402630565348, 236.63009610170235],
          [73.66912005245348, 234.81003183462786],
          [76.34020413041247, 231.82525067309467],
          [78.19132751467254, 228.89016409905827],
          [79.95548537081294, 226.4271761062426],
          [81.2475446457326, 224.1350132579475],
          [82.15136495583266, 222.31494899087312],
          [83.05518526593272, 219.5848525902615],
          [83.05518526593272, 218.20272187550364],
          [83.35645870263278, 215.91055902720854],
          [83.35645870263278, 211.385245653271],
          [83.35645870263278, 206.1207252903169],
          [83.35645870263278, 202.2383356421206],
          [83.35645870263278, 200.41827137504623],
          [83.35645870263278, 199.28771950949147],
          [83.35645870263278, 199.06719977747395],
          [83.15768035264517, 199.06719977747395],
          [83.15768035264517, 198.33420461189445],
          [83.15768035264517, 189.76499418039572],
          [83.6297789338658, 186.45098637669537],
          [84.48701056818749, 177.06802707493466],
          [85.34424220250929, 171.89978997525583],
          [86.58971280165059, 167.3744766013183],
          [88.05259722109093, 164.05115106246228],
          [89.1707254397715, 160.72782552360627],
          [90.20499404205106, 157.96356409409054],
          [90.20499404205106, 154.6402385552346],
          [90.20499404205106, 151.31691301637858],
          [90.20499404205106, 148.55265158686285],
          [88.81975741557454, 145.78839015734712],
          [86.36298124619606, 139.32188195931144],
          [85.49953778843718, 135.35563269471413],
          [85.06781605955774, 130.8303193207766],
          [84.67957709473802, 126.94792967258036],
          [84.67957709473802, 124.18366824306463],
          [84.67957709473802, 121.89150539476952],
          [84.67957709473802, 119.59934254647447],
          [84.41868051037926, 118.55575620903932],
          [84.41868051037926, 117.81344330830422],
          [84.41868051037926, 117.26990875755672],
          [82.64831083080179, 114.806920764741],
          [80.44621942234488, 112.21659039146448],
          [78.80319212322826, 110.26918374392926],
          [77.07319929599197, 107.84967851517331],
          [76.07620163433518, 105.55751566687826],
          [74.95186159221754, 102.23419012802225],
          [73.398905732939, 96.41060565572792],
          [73.05104362046069, 93.08728011687191],
          [73.05104362046069, 90.32301868735618],
          [73.05104362046069, 88.03085583906108],
          [73.05104362046069, 86.2107915719867],
          [73.05104362046069, 83.91862872369165],
          [73.74055602198035, 81.15436729417593],
          [74.4704452758412, 77.83104175531992],
          [75.20033452970205, 74.5077162164639],
          [75.58546758280312, 71.18439067760795],
          [75.58546758280312, 66.47893442399408],
          [75.28108823438464, 64.18677157569903],
          [73.98281713602779, 61.89460872740392],
          [71.78072572757077, 59.304278354127405],
          [69.57863431911386, 56.71394798085083],
          [67.63122767157864, 55.07092068173421],
          [64.69614109754235, 53.21358547403713],
          [61.844914139907075, 51.83145475927927],
          [56.676677040228185, 50.10456784376157],
          [50.76923295153273, 48.16026710794489],
          [45.2593455628126, 45.91779884714674],
          [41.37695591461636, 43.976604023048594],
          [38.44186934058001, 42.11926881535152],
          [36.149706492284906, 40.82099771699467],
          [34.329642225210534, 39.609692146757425],
          [33.286055887775376, 38.827002393681084],
          [32.543742987040275, 38.305209224963505],
          [32.102703523005175, 37.864169760928405],
          [31.903925173017512, 37.66539141094074],
          [31.903925173017512, 37.4759307961088],
          [31.711358646466977, 37.4759307961088],
          [31.711358646466977, 37.0348913320737],
          [31.490838914449398, 36.29257843133854],
          [31.229942330090637, 35.24899209390344],
          [30.925562981672044, 33.42892782682901],
          [30.31680428483486, 31.60886355975458],
          [29.70804558799773, 29.78879929268021],
          [28.577493722442966, 27.446941856888202],
          [27.96873502560578, 25.62687758981383],
          [27.18604527252944, 24.58329125237867],
          [26.35987275539327, 23.151465950123907],
          [25.533700238257097, 21.719640647869085],
          [24.791387337521996, 20.977327747133984],
          [24.309971021145657, 20.235014846398883],
          [23.828554704769317, 19.492701945663725],
          [23.387515240734217, 19.051662481628625],
          [22.6855791923403, 18.088829848876003],
          [22.244539728305256, 17.647790384840903],
          [21.803500264270156, 17.427270652823324],
          [21.582980532252577, 17.206750920805803],
          [21.362460800235056, 16.986231188788224],
          [21.163682450247393, 16.78745283880062],
          [20.96490410025973, 16.368154756795377],
          [20.766125750272124, 16.368154756795377],
          [20.545606018254546, 16.147635024777856],
          [20.346827668266883, 15.927115292760277],
          [20.12630793624936, 15.734548766209798],
          [19.713221677681247, 15.734548766209798],
          [19.492701945663725, 15.51402903419222],
          [18.750389044928625, 15.51402903419222],
          [18.228595876211045, 15.293509302174698],
          [18.008076144193467, 15.07298957015712],
          [17.567036680158367, 15.07298957015712],
          [17.125997216123267, 14.852469838139598],
          [16.684957752088224, 14.852469838139598],
          [16.243918288053123, 14.852469838139598],
          [15.802878824018023, 14.852469838139598],
          [15.361839359982923, 14.63195010612202],
          [14.920799895947823, 14.63195010612202],
          [14.700280163930245, 14.63195010612202],
          [14.28098208192506, 14.63195010612202],
          [14.060462349907539, 14.63195010612202],
          [13.420644535884776, 14.63195010612202],
          [13.200124803867254, 14.63195010612202],
          [13.001346453879592, 14.63195010612202],
          [13.001346453879592, 14.433171756134413],
          [13.001346453879592, 13.70328250227351],
          [13.001346453879592, 11.41733147741553],
          [13.001346453879592, 10.507299343878344],
          [13.001346453879592, 8.941919837725607],
          [13.001346453879592, 7.5100945354708415],
          [13.001346453879592, 6.466508198035683],
          [13.001346453879592, 6.025468734000583],
          [13.001346453879592, 5.584429269965483],
          [12.81188583904759, 5.584429269965483],
          [12.150326642994969, 5.584429269965483],
          [11.929806910977447, 5.584429269965483],
          [10.66570084152471, 5.363909537947961],
          [9.92338794078961, 4.882493221571622],
          [9.181075040054509, 4.661973489554043],
          [8.438762139319351, 3.9196605888189424],
          [7.957345822943012, 3.1773476880837848],
          [7.475929506566672, 2.435034787348684],
          [7.034890042531572, 1.9939953233135839],
          [6.593850578496472, 1.5529558592784838],
          [6.37333084647895, 1.3324361272609622],
          [6.152811114461429, 1.1119163952433837],
          [5.733513032456187, 1.1119163952433837],
          [5.5347346824685815, 1.1119163952433837],
          [5.093695218433481, 1.1119163952433837],
          [4.652655754398381, 1.1119163952433837],
          [4.432136022380803, 1.1119163952433837],
          [4.239569495830267, 1.1119163952433837],
          [4.047002969279731, 0.8913966632258621],
          [3.8264832372622095, 0.6926183132381993],
          [3.605963505244688, 0.6926183132381993],
          [3.413396978694152, 0.5000517866876635],
          [0, 0],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
      {
        type: "freedraw",
        version: 618,
        versionNonce: 51729781,
        isDeleted: false,
        id: "EmdnG2sDffXNwRyOd1j9J",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 533.2520433956576,
        y: 294.58583303028627,
        strokeColor: "#f8f9fa",
        backgroundColor: "#f8f9fa",
        width: 191.97950923572682,
        height: 89.66767131474066,
        seed: 1603884987,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1700555503870,
        link: null,
        locked: false,
        points: [
          [0, 0],
          [-0.3975566999753255, 0],
          [-0.8385961640104256, 0],
          [-1.5809090647455264, 0],
          [-1.7796874147331891, 0],
          [-2.2238327904868243, 0],
          [-2.422611140474487, 0],
          [-3.164924041209588, 0],
          [-3.9072369419447455, 0],
          [-4.950823279379904, 0.25779067264022615],
          [-5.693136180115005, 0.25779067264022615],
          [-6.736722517550163, 0.5155813452804523],
          [-8.3021020237029, 1.031162690560933],
          [-9.733927325957666, 1.3324361272609622],
          [-11.16575262821243, 1.6337095639609913],
          [-12.98581689528686, 1.9349830006610205],
          [-14.805881162361231, 2.2362564373610496],
          [-17.098044010656338, 2.2362564373610496],
          [-18.91810827773071, 2.5375298740610788],
          [-20.34993357998553, 2.795320546701305],
          [-22.169997847059904, 3.096593983401334],
          [-23.990062114134332, 3.3978674201013632],
          [-26.331919549926283, 3.9569315294416185],
          [-28.151983817000712, 4.258204966141648],
          [-29.972048084075084, 4.258204966141648],
          [-31.792112351149513, 4.559478402841677],
          [-34.08427519944456, 4.559478402841677],
          [-36.37643804773967, 4.904234603601509],
          [-40.050731610792525, 5.55026424106137],
          [-40.96076374432977, 5.55026424106137],
          [-43.252926592624874, 5.895020441821202],
          [-45.594784028416825, 6.497567315221261],
          [-47.02660933067159, 6.755357987861487],
          [-48.45843463292641, 7.013148660501713],
          [-49.89025993518118, 7.572212769841968],
          [-51.32208523743594, 7.8734862065419975],
          [-52.75391053969071, 8.432550315882253],
          [-53.797496877125866, 8.690340988522507],
          [-54.53980977786097, 8.907754808821494],
          [-55.803915847313704, 9.640749974400933],
          [-57.23574114956847, 10.199814083741188],
          [-58.667566451823234, 10.758878193081472],
          [-60.099391754078, 11.317942302421727],
          [-61.91945602115243, 11.920489175821785],
          [-62.96304235858753, 11.920489175821785],
          [-64.00662869602269, 11.920489175821785],
          [-64.74894159675785, 11.920489175821785],
          [-65.792527934193, 11.920489175821785],
          [-66.83611427162816, 12.178279848462012],
          [-67.27715373566326, 12.178279848462012],
          [-68.01946663639836, 12.178279848462012],
          [-68.21824498638603, 12.178279848462012],
          [-68.41081151293656, 12.178279848462012],
          [-68.59095439261284, 12.178279848462012],
          [-68.78041500744484, 12.178279848462012],
          [-68.97919335743251, 11.979501498474349],
          [-69.19971308945003, 11.538462034439277],
          [-69.64075255348513, 11.317942302421727],
          [-69.86127228550271, 11.097422570404177],
          [-70.28057036750789, 10.898644220416514],
          [-70.47003098233984, 10.898644220416514],
          [-70.6688093323275, 10.898644220416514],
          [-71.08810741433268, 10.898644220416514],
          [-71.52914687836778, 10.898644220416514],
          [-71.7496666103853, 10.898644220416514],
          [-72.16896469239049, 10.898644220416514],
          [-72.35842530722249, 10.898644220416514],
          [-72.54788592205449, 10.898644220416514],
          [-72.96718400405967, 10.898644220416514],
          [-73.48897717277725, 10.898644220416514],
          [-73.90827525478244, 10.898644220416514],
          [-74.12879498679996, 10.898644220416514],
          [-74.32757333678768, 10.898644220416514],
          [-74.51703395161962, 10.898644220416514],
          [-74.7002827430145, 10.898644220416514],
          [-74.7002827430145, 10.497981608722682],
          [-74.48286892271545, 9.755668707987553],
          [-74.22507825007523, 9.233875539269974],
          [-73.27156335247827, 8.271042906517295],
          [-72.8367357118803, 7.8300034424821945],
          [-72.40190807128232, 7.388963978447123],
          [-71.62543014164305, 6.606274225370754],
          [-71.19060250104508, 6.165234761335654],
          [-70.71539800810586, 5.422921860600525],
          [-70.2401935151666, 4.6806089598653955],
          [-69.50409243786862, 4.199192643489056],
          [-68.81147412463037, 3.456879742753955],
          [-68.37664648403239, 3.015840278718855],
          [-68.15923266373346, 2.795320546701305],
          [-67.74614640516535, 2.3760224646961206],
          [-67.31131876456737, 2.1555027326785705],
          [-66.57521768726934, 1.894606148319781],
          [-65.83911660997131, 1.4131898319434413],
          [-65.10301553267334, 1.1522932475846517],
          [-64.66818789207537, 0.9317735155671016],
          [-64.0159464311784, 0.49073405153200156],
          [-63.279845353880376, 0.009317735155661921],
          [-62.8450177132824, -0.43172172887940974],
          [-62.10891663598437, -0.6522414608969598],
          [-61.3728155586864, -1.1336577772732994],
          [-60.93798791808837, -1.3541775092908495],
          [-60.201886840790394, -1.615074093649639],
          [-59.46578576349242, -2.0964904100259787],
          [-58.72968468619439, -2.5779067264023183],
          [-57.99358360889636, -3.0593230427786295],
          [-56.6984184222581, -4.102909380213788],
          [-55.96231734496013, -4.584325696590128],
          [-55.226216267662096, -5.065742012966467],
          [-54.490115190364065, -5.286261744984017],
          [-54.05528754976609, -5.727301209019117],
          [-53.27880962012688, -6.770887546454247],
          [-52.45884892642778, -7.898333500290448],
          [-51.68237099678851, -8.941919837725607],
          [-50.86241030308946, -10.373745139980372],
          [-49.86851855315126, -11.63785120943308],
          [-49.09204062351199, -12.420540962509449],
          [-48.35593954621396, -12.901957278885789],
          [-47.61983846891599, -13.383373595262128],
          [-46.88373739161801, -13.86478991163844],
          [-45.846362877619924, -14.647479664714808],
          [-45.110261800321894, -15.389792565449937],
          [-43.98902766992285, -16.56072128334594],
          [-42.95165315592482, -17.60430762078107],
          [-39.97618972954723, -20.284709433895785],
          [-38.12506634528722, -23.219796007932132],
          [-35.63101923528592, -26.968631452230454],
          [-33.77989585102597, -30.291956991086437],
          [-32.40087104798664, -33.056218420602164],
          [-31.410085209766976, -35.34838126889724],
          [-30.894503864486524, -36.3919676063324],
          [-30.636713191846297, -37.1342805070675],
          [-30.37892251920607, -37.87659340780263],
          [-30.37892251920607, -38.61890630853776],
          [-30.121131846565845, -39.58173894129044],
          [-30.121131846565845, -39.80225867330799],
          [-29.925459408296717, -40.22155675531317],
          [-29.735998793464773, -40.22155675531317],
          [-29.735998793464773, -42.69386248328453],
          [-29.735998793464773, -46.5762521314808],
          [-28.534010958383192, -51.101565505418336],
          [-27.37550588736144, -54.9839551536146],
          [-26.645616633500538, -58.307280692470584],
          [-25.956104231980873, -61.07154212198631],
          [-25.31007459452104, -63.36370497028139],
          [-25.008801157820983, -64.79553027253618],
          [-24.751010485180757, -66.22735557479095],
          [-24.49321981254053, -67.65918087704571],
          [-24.19194637584053, -69.0910061793005],
          [-23.331608829800246, -71.43286361509249],
          [-23.07381815716002, -72.47644995252764],
          [-22.816027484519736, -73.52003628996277],
          [-22.59861366422075, -73.96107575399787],
          [-22.381199843921763, -74.40211521803298],
          [-21.974325408790833, -74.62263495005053],
          [-21.56123915022272, -74.82141330003816],
          [-21.34382532992373, -75.04193303205571],
          [-20.607724252625758, -75.52334934843205],
          [-19.65420935502874, -76.22528539682594],
          [-18.91810827773071, -76.44580512884349],
          [-18.182007200432736, -76.44580512884349],
          [-17.747179559834763, -76.44580512884349],
          [-16.709805045836674, -76.44580512884349],
          [-15.9737039685387, -76.44580512884349],
          [-14.936329454540669, -76.44580512884349],
          [-14.501501813942696, -76.44580512884349],
          [-13.765400736644665, -76.44580512884349],
          [-12.510612402347647, -76.70670171320228],
          [-11.774511325049616, -76.96759829756107],
          [-10.348897846231978, -76.96759829756107],
          [-8.923284367414283, -76.96759829756107],
          [-7.4976708885966445, -77.22849488191986],
          [-6.460296374598613, -77.48939146627865],
          [-5.724195297300582, -77.48939146627865],
          [-4.686820783302551, -77.48939146627865],
          [-3.95071970600452, -77.48939146627865],
          [-2.695931371707502, -77.48939146627865],
          [-1.6585568577094705, -77.48939146627865],
          [-0.9224557804114397, -77.48939146627865],
          [0.11491873358659177, -77.48939146627865],
          [1.54053221240423, -77.48939146627865],
          [2.5779067264022615, -77.48939146627865],
          [4.0035202052199566, -77.48939146627865],
          [5.429133684037595, -77.48939146627865],
          [6.85474716285529, -77.48939146627865],
          [8.280360641672928, -77.18811802957862],
          [9.836422412670004, -76.93032735693836],
          [11.262035891487642, -76.67253668429814],
          [12.299410405485673, -76.41474601165791],
          [13.336784919483762, -76.15695533901768],
          [14.072885996781736, -75.68175084607847],
          [15.110260510779767, -75.42396017343822],
          [15.846361588077798, -75.42396017343822],
          [16.58246266537583, -74.948755680499],
          [17.61983717937386, -74.43317433521855],
          [18.87462551367088, -73.70017916963909],
          [19.91200002766891, -72.92370123999984],
          [21.337613506486548, -72.36463713065959],
          [22.763226985304243, -71.80557302131933],
          [24.577079428941545, -71.20302614791927],
          [26.863030453799468, -70.55699651045941],
          [29.621080059878125, -69.86748410893975],
          [32.93819377529695, -69.13759485507885],
          [36.255307490715836, -68.40770560121797],
          [40.131485315475004, -67.63743949501583],
          [45.386687943273444, -66.52241718805385],
          [48.70380165869233, -65.79252793419298],
          [51.46185126477093, -65.44777173343314],
          [54.77896498018981, -64.71788247957224],
          [58.096078695608696, -64.71788247957224],
          [60.8541283016873, -64.71788247957224],
          [62.6679807453246, -64.41660904287221],
          [63.792320787442236, -64.41660904287221],
          [64.52842186474027, -64.41660904287221],
          [64.94150812330832, -64.41660904287221],
          [64.41971495459075, -64.86386033034444],
          [64.59675192254849, -64.50668048271038],
          [65.7179860529476, -63.08106700389271],
          [66.92307979974771, -61.26721456025541],
          [68.04431393014676, -59.841601081437744],
          [68.94813424024687, -58.02774863780047],
          [69.85195455034693, -56.21389619416317],
          [70.92970591668615, -54.26959545834649],
          [71.79004346272649, -52.84398197952882],
          [72.65038100876683, -51.41836850071115],
          [73.209445118107, -49.99275502189349],
          [74.41453886490723, -48.17890257825621],
          [75.27487641094746, -46.75328909943855],
          [76.47997015774757, -44.939436655801245],
          [78.03292601702611, -43.38648079652276],
          [79.54239911224482, -41.87700770130405],
          [82.26317777770072, -40.06936708110388],
          [83.81613363697926, -38.777307806184155],
          [85.7573284610774, -37.44176576720466],
          [86.79470297507538, -36.665287837565415],
          [88.22031645389308, -35.8049502915251],
          [89.25769096789105, -35.28936894624465],
          [89.99379204518908, -35.28936894624465],
          [90.72989312248711, -35.28936894624465],
          [91.46599419978514, -35.28936894624465],
          [92.11823566068216, -35.28936894624465],
          [92.55306330128002, -35.28936894624465],
          [93.28916437857816, -35.28936894624465],
          [94.02526545587608, -35.28936894624465],
          [94.76136653317411, -35.28936894624465],
          [95.49746761047214, -35.28936894624465],
          [96.23356868777006, -35.28936894624465],
          [96.66839632836815, -35.28936894624465],
          [97.103223968966, -35.28936894624465],
          [97.83932504626415, -35.031578273604424],
          [99.39538681726123, -34.51599692832397],
          [100.13148789455914, -34.29858310802496],
          [100.56631553515712, -34.08116928772597],
          [101.00114317575509, -33.863755467426984],
          [101.43597081635318, -33.646341647128],
          [102.1720718936511, -33.646341647128],
          [103.20944640764907, -33.38855097448777],
          [104.24682092164716, -33.38855097448777],
          [105.67243440046485, -33.38855097448777],
          [106.62594929806193, -33.38855097448777],
          [107.06077693865979, -33.38855097448777],
          [107.49560457925787, -33.38855097448777],
          [108.23170565655579, -33.38855097448777],
          [109.65731913537348, -33.38855097448777],
          [111.9432701602314, -33.38855097448777],
          [113.75712260386871, -33.38855097448777],
          [115.1827360826864, -33.38855097448777],
          [116.22011059668449, -33.38855097448777],
          [116.65493823728235, -33.38855097448777],
          [117.08976587788044, -33.38855097448777],
          [117.27922649271233, -33.38855097448777],
          [116.87856388101847, -33.171137154188784],
          [115.83497754358342, -32.655555808908304],
          [114.01491327650893, -32.053008935508245],
          [111.72275042821394, -31.105705861348383],
          [108.95848899869821, -30.071437259068887],
          [106.66632615040311, -29.425407621609025],
          [103.9362297497915, -28.521587311508938],
          [102.89264341235634, -28.006005966228486],
          [101.46081811010157, -27.74821529358826],
          [100.02899280784669, -27.44694185688823],
          [97.7368299595517, -27.1021856561284],
          [95.91676569247733, -26.80091221942837],
          [93.62460284418222, -26.80091221942837],
          [92.19277754192746, -26.49963878272834],
          [90.76095223967269, -26.49963878272834],
          [88.41909480388068, -26.49963878272834],
          [86.98726950162592, -26.49963878272834],
          [85.16720523455155, -26.19836534602831],
          [82.87504238625644, -26.19836534602831],
          [80.58287953796145, -25.85360914526848],
          [78.29071668966634, -25.508852944508646],
          [75.99855384137123, -25.207579507808617],
          [74.17848957429686, -25.207579507808617],
          [72.35842530722249, -25.207579507808617],
          [71.31483896978722, -24.94978883516839],
          [69.74945946363454, -24.691998162528165],
          [69.00714656289944, -24.691998162528165],
          [67.96356022546428, -24.43420748988794],
          [67.22124732472918, -24.43420748988794],
          [66.17766098729402, -24.176416817247713],
          [65.13407464985886, -24.176416817247713],
          [63.702249347604095, -24.176416817247713],
          [62.27042404534933, -23.875143380547684],
          [60.83859874309451, -23.61735270790743],
          [58.49674130730256, -23.359562035267203],
          [57.06491600504779, -22.800497925926948],
          [55.24485173797336, -22.19795105252689],
          [53.424787470898934, -21.294130742426802],
          [51.132624622603885, -20.00207146750708],
          [48.840461774308835, -19.054768393347217],
          [46.548298926013786, -18.063982555127524],
          [44.25613607771868, -17.07319671690783],
          [41.96397322942363, -16.42716707944797],
          [39.1997117999079, -15.737654677928333],
          [35.99751681807561, -14.790351603768443],
          [33.70535396978056, -14.144321966308581],
          [32.273528667525795, -13.843048529608552],
          [30.841703365270973, -13.541775092908523],
          [29.798117027835872, -13.541775092908523],
          [29.055804127100714, -13.541775092908523],
          [28.614764663065614, -13.541775092908523],
          [27.872451762330513, -13.541775092908523],
          [27.130138861595356, -13.541775092908523],
          [25.866032792142676, -13.324361272609536],
          [24.822446454707517, -13.324361272609536],
          [24.080133553972416, -13.06657059996931],
          [23.33782065323726, -12.849156779670324],
          [22.896781189202216, -12.849156779670324],
          [22.455741725167115, -12.849156779670324],
          [21.713428824431958, -12.591366107030069],
          [20.971115923696857, -12.591366107030069],
          [20.2288030229617, -12.333575434389843],
          [18.96469695350902, -11.81799408910939],
          [18.22238405277392, -11.560203416469164],
          [17.48007115203876, -11.342789596170178],
          [16.73775825130366, -11.125375775871191],
          [15.99544535056856, -11.125375775871191],
          [15.253132449833402, -10.867585103230937],
          [14.5108195490983, -10.60979443059071],
          [13.467233211663142, -10.352003757950484],
          [13.026193747628042, -10.134589937651498],
          [12.283880846892941, -9.659385444712285],
          [11.321048214140262, -9.44197162441327],
          [10.880008750105162, -9.224557804114283],
          [10.137695849370004, -8.74935331117507],
          [9.395382948634904, -8.531939490876084],
          [8.954343484599804, -8.314525670577098],
          [8.513304020564703, -8.097111850278111],
          [8.292784288547182, -8.097111850278111],
          [8.094005938559519, -7.879698029979124],
          [7.460399947973883, -7.444870389381123],
          [7.019360483938783, -7.01004274878315],
          [6.578321019903683, -6.792628928484163],
          [6.137281555868583, -6.575215108185176],
          [5.916761823851061, -6.35780128788619],
          [5.916761823851061, -6.180764319928443],
          [5.69624209183354, -5.786313531671681],
          [5.25520262779844, -5.3514858910737075],
          [5.034682895780861, -5.134072070774721],
          [4.8141631637633395, -4.916658250475734],
          [4.615384813775677, -4.916658250475734],
          [4.432136022380803, -4.916658250475734],
          [3.770576826328181, -4.264416789578746],
          [3.248783657610602, -4.00662611693852],
          [2.5064707568754443, -3.5314216239993073],
          [1.8449115608228226, -3.096593983401334],
          [1.624391828805301, -2.8791801631023475],
          [1.4256134788176382, -2.8791801631023475],
          [0, 0],
        ],
        lastCommittedPoint: null,
        simulatePressure: true,
        pressures: [],
      },
    ],
    base64:
      "data:image/jpeg;base64,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",
  },
  {
    name: "Polar Bear",
    elements: [
      {
        id: "rkdfXP1-7ZG5jDzZppqoM",
        type: "rectangle",
        x: 299.02830577737325,
        y: -163.03912126678125,
        width: 603.3132756577128,
        height: 680.7401650033169,
        angle: 0,
        strokeColor: "transparent",
        backgroundColor: "#1e1e1e",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 3,
        },
        seed: 57557403,
        version: 248,
        versionNonce: 685733141,
        isDeleted: false,
        boundElements: null,
        updated: 1703154666721,
        link: null,
        locked: false,
      },
      {
        type: "text",
        version: 659,
        versionNonce: 1204536437,
        isDeleted: false,
        id: "JMYWI5jjN10TVeu4sgLx0",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 386.88051074813353,
        y: -48.50576042347231,
        strokeColor: "#40c057",
        backgroundColor: "#40c057",
        width: 422.7699890136719,
        height: 528.4703430116597,
        seed: 1104873076,
        groupIds: [],
        frameId: null,
        roundness: null,
        boundElements: [],
        updated: 1703154681350,
        link: null,
        locked: false,
        fontSize: 422.77627440932775,
        fontFamily: 1,
        text: "🐻‍❄️",
        textAlign: "left",
        verticalAlign: "top",
        containerId: null,
        originalText: "🐻‍❄️",
        lineHeight: 1.25,
        baseline: 372,
      } as unknown as ExcalidrawElement,
      {
        id: "0FQICsb1hzlHDmfYwWJfN",
        type: "ellipse",
        x: 450.3556265185674,
        y: -46.64995523824501,
        width: 302.7509635508259,
        height: 77.44294302367706,
        angle: 0,
        strokeColor: "transparent",
        backgroundColor: "#e03131",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        seed: 1432024021,
        version: 81,
        versionNonce: 1378180699,
        isDeleted: false,
        boundElements: null,
        updated: 1703154697966,
        link: null,
        locked: false,
      },
    ],
    base64:
      "data:image/jpeg;base64,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",
    prompt: "Lovely Polar Bear with hat",
  },
  {
    name: "Anime character",
    prompt:
      "school boy with long loose hair, smiling, hoodie, 3d rendering, chibi cartoon style",
    elements: [
      {
        type: "ellipse",
        version: 313,
        versionNonce: 1060610547,
        isDeleted: false,
        id: "-mqytIBEx-7ZpgzR9abTG",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 327.64606442061205,
        y: 103.1941440301396,
        strokeColor: "transparent",
        backgroundColor: "#ffec99",
        width: 184.38808193958738,
        height: 136.47265625,
        seed: 573296475,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1700556582568,
        link: null,
        locked: false,
      },
      {
        type: "ellipse",
        version: 383,
        versionNonce: 1853156243,
        isDeleted: false,
        id: "DaLVerXr9y9Kso83Nxuut",
        fillStyle: "solid",
        strokeWidth: 2,
        strokeStyle: "solid",
        roughness: 1,
        opacity: 100,
        angle: 0,
        x: 325.7408185180012,
        y: 242.15438688006896,
        strokeColor: "transparent",
        backgroundColor: "#a5d8ff",
        width: 193.05859375,
        height: 293.5812424469882,
        seed: 139406331,
        groupIds: [],
        frameId: null,
        roundness: {
          type: 2,
        },
        boundElements: [],
        updated: 1700556582568,
        link: null,
        locked: false,
      },
    ],
    base64:
      "data:image/jpeg;base64,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",
  },
];
