from locust import task, FastHttpUser

EXAMPLE_IMAGE_BASE64 = "/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAIAAgADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3yiiigBaKKKAFFFAooAKWkpaACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBlFFFAC0uKSlFABiilNJQAUtJS0AFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFADcUYoooAKUUlKKAFoxRRQAYooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAG0UtFACYpRS0UAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAJRSU6gAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAbThSYpaACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoopM0ALRSZpaACiiigAooooAKKKKACiiigAoopM0ALRSZpaACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooATIyR6UuaYxGcfyoYhBywA96AH5pMiqU2oWcBw9wgPuao3HijS7YEtMrY9DUucVuy40qktom3kUua4q6+IumQqwRWJFZsvxOgA/doQfcVjLE00dEcFXl0PR6TcPWvKZfihc5/d+WB7iqr/ELUGz86c+1Q8ZTRostrPfQ9g3L6ikyD/EPzrxaTxxqD/8tRVdvFt9IcmR8/7JqPr0XsjVZXPrI9wLKP4l/OkM0SdZF/OvDj4gvZP+Wso/GkGq3jHmeT/vo1Lxz/lLWVPrI9va9t16yr+dRnU7MdZlrxcancd5JD+NPGpS/wB58/Wp+vPsV/ZS/mPY/wC1rL/nutH9rWX/AD3WvHf7Sm/vn86X+0pv75/On9dl2D+y4/zHsH9r2X/PcUf2vZf89xXkP9pT4+/S/wBpT/36X16XYf8AZS7nrv8Aa9l/z3FOGqWZ6TCvH/7Sm7ufzo/tWVf4z+dH16XYP7Kj/MexDULVjgSipFuIW6SL+deMtrEzjb5jfgaF1WUf8tZR/wACoWOfYTyldJHtIZT/ABL+dKHU9GH514yutyj/AJby/wDfVWk8T3ER4uB+dWscuqIeVT6O567ketGRXmEPjW6UY81DWjb+NbhgAdp+grSOMpswnl1aJ32RS5rmrXxVCwHmqcmti01CC6yY259M1vGrGWxyTo1IbouZFGRRRgVoZi0UUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAGFqmux2lwYIcNMOorhPFHjG5sD+9cx57CpvEkzWviO7kJ43cVi3yWGuw+XqQIHYg4rzqlaTk4tntYfDQUFJI5C+8X3l3IWDEr2Oay5NTu5zkuw/GujufBFpIALC4WNR/z0brVF/BmpQc/aYXX0Fc7szuiuUx0mkY/NM1TK57uTUsuhX8RyLd5Mf3RUf2C/T71jOPqtRZI0TvqyVWX0zT1Y56mohDcL962lH4VKq3A6p+lLY0TRZj5/hzU6kgcDHtVdGcdVNShs85x9alpspMsoW9amXd/eqqj4/iFTI4J65osuwX8yypPrUgZvwqBXFSK4phcl3j0pdw9KZmjNF2K7H9aMUAHGdppNsnZTU3YAeKYRmn+XK38BNNMD90alqUpDFBVsihmPenrbOTwdp9W6UptZD1mjosHN5lY47mmFUboAKsmzPUzR0wmzT/AFiOfoaFETkVGG3oTT7e7lSQqjsW7DFTG6tF/wBTC+f9qo21WcZjWNAB3281agQ5HRaRLcxfvL1F8v1LVq2HiO3/ALahgtHyGbDAV57JNNK3zSsB6ZrZ8MqF1616Elq6aWkkcda7iz3eNsxqfUU4Hmmxf6lPpTh1r1VsfODqKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigDyrxioOuz57tXPzRKcBhn0rp/GK41pz6mubBPLHqK8it/EZ9LhdaUbEeGQhSmR2PpUmXj5Ln6U8MR83c0ud3Wuf0Oq6Y+O7uAMqcKO9O+1yv95y31qMJ6U8KaNR2Qu7d1hU0uyA9bZKUBqXDUJsVkR+RanrbJSi2s+9qhqTDUuGp3YWI/s9kP8Al0SjybMdLZBT9po2sKLsBmy0H/LBaCLXtAuaeVb0ppQ96BXGbY/+eK0bY/8AnitLtHvTcUhjS+CQIwKbvY9FqTPFNJp3CxE8sinHSmGSQ/xmpH5NRNRcdiOQtt5YkelQNzU5FMagViAxj+9UJA7HP1qwwqJiT6UCKz5B9PpTFBPfI9anIpjMQMDFWiWQyRjP3q1fDWV1615/irKJJPNa/h3nX7QH+9W0N0c1X4We8wn9wn0qQdajiGIE+lPFeqj5sdRRRQMKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAPN/G6bdUVvU1y2MV13jxcX9v/tZrkzzz6GvKr/Gz6LBP91EUDtTgKBzzTgK5bHag6c0oenBacFFAxA9LvpwUUuBQIbvpd9LgelKAKAG76UPTsCkKjFMQm+ml80pWmkUANNMNPNNxSGNpp6U4imGmAxqjYVKaY1AyIio2FStUbUCIWqEipmPWoiaaQmRkVE4qUmonarRDIsc1r+HB/wAVBaf71ZGcmtrwyhfxDaAHndWsN0c9X4We7Rf6lPpTxUcX+pX2FPB6V6qPnB1FFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQBwnxAj/fWcg964t+oAr0Dx3HusUkx9zPPpXnkbBl3E15mKVpnvYB3oolHFPU1GuSMinjiuRnokoNKDUYI9acGHrSAlFFNBHrTs0AFKKSkzzTBjwaCabmlJoJEJphpxNMoGIaSlpKQxpqNqkNRtTAYaa3SnHimMRQAxulRPUp5qJ6aAhbvUR6VIxFRt0poTIzUT1KeelMYEkgDkVaIZEBzW/4RjL+KbEDpv5rCUZPHOK7DwBZyTa6kwjJWI5Y+la0leSOXEu1Js9fAAGKB1FIT6UDORXqHzw+iiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAx/EGnvqmlXFrCAZGHGe1eTTwtDObeRDGY+ORgEivbWIJPqKyNb0Oz1WBlniGVG4FeOa569BTV0dmExXsXyy2Z5V8wwV6GngL3Y5qS4szHcSReaAEOAncVXKTIeImI9a82UGtD341U0S89MDHrTlFQhmAyxx7U5ZazsaXuWAKdmoRJTwaAJAaQnmm5ooAdRTaKAFppopD0oAKbRSUABphpTTTTsFxrDNRstK7bTUbSUWC4hAHOajcj1NDyDFNBLfdUmmosTZGwFR49OfrVryJ2HERxTF09m++2z601FkXRUYkfwgfSowsjvlMgdyO9aYtIousqv9KVZ44tyxR7X/vHpWiiyXJMm0nwzfa1cqLZAsQ++2cV614f0GHQ7dkjOZHA3msn4fxyjRJJJ8bzJwQMcV14wa9GlTUVc8HFYic5uHRAKWilrY5AooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAG5p1NpwoAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBmBu6daCB3FO70daOgjyLxRA1p4kuGxhZGyKxWupkcjzGx6V2vxDtMXVpOg6g5riZF3YOK82srSZ9BhLSppjUuirFmG761KLwN/yzApojHHFHle1YcyOtJkomU98U7zE/wCejVB5NL5XtSbKSJ/MT/no1PU5GVbI96riL2o8th0OBQGpZ5/vUoDnoR+Jqp5b/wB6lCMOpNAtSyVk9V/OmlZB1I/OoCnuaZs56mkVaRY3H1pNx9ahKf7VJs/2qLisTHb3c0wmLvK1RFE7tzTSqdlJqrhYkLQf89GNL50S9Bu+tQlc9IzTdpHbFFwsTtdoo5hTFRteg/dQL9KifG3k1EQvY0XFykpup+0hA+tNe7ZxyxNQlfem+XTTE4CNIe1PBZlQ5PWlEYqzZQefdRwj+I1pHVmc3aLZ7N4bg8nRYOMblBrXXGKr2EYh063j/uoB+lWFGCa9OK0Pm5vmm2OooopkhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUANpc0lFAC5ozSUooAWiiigAooooAKKKKACiiigAooooAKKKKACiiigBMUbeMUtFAHNeM7RZNHa46vEOBXmzKPLGBya9e1q3+1aVNFjO4V5K8ZSZ0P8JIrgxS1uevl0rxafQiCYIFSBBTgnGacBXG0erHYaEHpSeWKlApdtIoi8sUeWKm20baAIfLFIYxU+2kK0AVzGKaYhVjbTStAWRW8oUnlD1qzspuygCqUGegppWrRUZppUUDK2GHc1Gyk96tFRTGUUxFXYM80jKo7VM4wKiamIiKj0prDFPPWmPTQhBzWz4YtxP4is0Odu/msZetdd4DtvO1kSY/1ZzW1JXkjkxMrU2erBAqBR0FOB5NHrQK9M+dFooooGFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQA3NGaSigBc0oNNpaAHZozSUUALRSUtABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFADJBuGOxFeT6vbta6pKrjBJJGK9aavOvGFt5es+Zj5WQfnXNio3hc7cBPlqNdzA4xQBSEYwPSnCvNPfTFp+KZTqQx2KCKQGg0AHFIcUGkoASkNKaTvQO43IpNwp5WmlaBELZzUZNTkVEwoHciY5pjZqRuDUbGmIjbOKiapWPFRNTAjNNYcD3pTTS3I9qaJewAEPt716F8N7ZlkupWAwQNteeqclm9q9Z8A2vlaDHORzIK6sMryPOx8rU7HVdBz604daTGaUda7zxELRRRQMKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigBlFJS0AFLSUtAC0UGgUAFLRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAh61yHjeHNpFMB8wfFdc1ZPiG3M+kuQPufNUVFeLRth58tVM8yHO5j3oFNDbmJ9adXkPc+ji76jqWmU7NSaDhQaTNIetAAaBRSGiwxTSUlJQFhS1MLUE000ILDWeomannrTDQFhhOajY1I1RNTCwxjxUTU9qjNMGMNMfhc080zqyn+7VJGciSJcsij+IgV7d4bh+z6DbRYxha8V09C+oQADOZB/Ove7ZPLto09FFduFWh5OYy1USSkU06ius8sKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAjpaSloAKWiigBTQKSlFAC0UUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAIeeKhuoxNaSx/3lIqY9RSEYIx60rBtqeRXdv8AZ7yaH+42KhrZ8SQfZ9XnYjHmtkVjV5NWNpNH0lCXNBMKTNHNJisTpHZpc0zmlB4oGhc0E0lFAxM0madikxTAaaaTTjTDQgGnrTDTjTCaLgMfrULGpHPNRPTAYajJpzUwmmhMYTTSdoPvSk03GRz2qkZy2N3wla/bNeij/ujdXti/dFeU/Dm3D660+PlWMj8a9WUYFejh42ieDj5XrWFoooNbnGFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAR0tJS5oAWikzS0AFKKMUUALRRmjNABRRmigAooooAKKKKACiiigAooooAKKKKAEPSkPanU0igDi/HNsS9vOo4UHNccDmvSPFdv5uhzuOWXpXmoO1tvoK8/ExtO57eAlenYmAzSYpVYbc0vPpXIz0U9BmKTpUmDTGBBpFISgUUDmkMKSnYpuKAGmmGpCKYVpgRE1GxqRhUbUkMjbrUb1IetRvTERN0qJjUrdKiYVSExhPNKTgfWmmmscgH0qkZSZ6Z8NbcJp005Hzb8V3vmCuL8IH7Fom3GfMO76V0CXeFwRXqUlaCPncQ+arJmrvFKGBrOF0D2qRLgGtDAu5FLVYTA08SAc0ATUVGJQe1ODZoAdRSA0tABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAEdFFFABmlBptLQA7NGaSigBc0tIOtLQAUtJS0AFFFFABRRRQAUUUUAFFFFABRRRQAUhpaQ0AV7yEXFpJEwyCK8hnUx3UqkdHIr2Ujg59K8t8Q2v2bV5Y8YON2K5MWvduell07TcTMRSXAqXeKgEmMEU8AHvXns9pbEvmCjhuaYFHrR04FIaHYFIRTcmgZ70mUFJS0h6UgGk0wmnGmGqAY1RNUrVE1AyM9ajepG61E9AiNqjapGqJqpEyIzSBC7BB1NKas6VEZtWt48Z3NgVpFXdjGo7RbPT9OQQaXbr/sDNWdxzUCApEqngKMU8tzXqJWSR87LVtlhWb1qRZSlV1Y08HPWrRFiytwalSclgKqKBUowOlAi8stSiWqCsalDGkIvB/epA9VFbpUit70AWN2aXNRKwx1pwYUASUU0GnZoAKKKKACiiigAooooAKKKKAI6KKKAFooooAUUUCigApaSloAKWkpaACiiigAooooAKKKKACiiigAooooAKKKKAEPSuE8b23l3CXY/jwld23Suf8AFNn9q0cnHMZLVlWjzQaN8LPkqpnnO1aBUYyRmnCvJkfTR2JAaU9aaDS0ihRSmkFKaAG0h6UtIelADaYafTDQAxutRmpG61GaAIn61E9Sv1qJ6YELVG1SNUbU0TIiPWtnwtAZ9ZD44hOaxm4rqvBcYDXEuOWArooq8jjxcuWm2dju3ZHvTsc01Rhvwp6cqDXonhseoqQCkUU8CqRI5RUgFNUVKooEKBUoHFNUVKooJHAU9RTQKkWkA5aeKYKeKAHL1p4pi9aeKAFooooAKKKKACiiigAooooAZRRRQAUUo6UuKAEFFFFABS0lLQAUtJS0AFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAB6VVvofNsZ48Z3IQKtU3hhSewLe545OhguXgIwUOKjra8VWX2XVpJAMCQ5FYea8qrHllY+nw8+emmPFKDTAacDWB0oeKCaaDSk0wCkozTc0ABpppSaYTQAhNROaexqFzQAxjUL1IxqJzTERNyKjdsjFPZsVA3XNNEsYeMjPWvQPCsPkaOhI5PevPwd8qD1YV6dpSBbKOIelduHhqeXjqnu2NRD8v1qVIyBSxRbiB6VcWIYruseU2QqlSqntU6RVKIhQQ2V1T2qRE+bpU6x1II6LiIgvtTgvtUoSnhKQEYX2pQKftpdtADQKcBTttKBQAijmnUYooAKKKKACiiigAooooAKKKKAG4oxRRQAZxRmkpaAFoxRRQAYpcUlLQAYooooAKKKKACiiigAooooAKKKKACiiigAooooAKZyBxTjyKQDgigOhzPi3R31CzE0IzLGOK87XqQ5EZU4IfivaMYXDDIrndX8Kafq6kooif++B3rnq4f2mvU78JjHSXK9jzktzx+dKC3Yitm88GatYDFmpvV7ZOMVkva6hZgrd2ZjkHUDmuCdCpHoexTxVGfXUAGp209yKq/bk3bWZgfTbUwYMMpz9ay5ZLdG6knsx529KaVbrkYpCV/ix+dNyp7jH1qX6lWYvXowppwOv6UjBf4cCoy2OrD86fzCzBiCTiomH4UjSgkhQB75qCSULy7EiqWoX8xz/AC/NuUj0HWoS+85AKj3qvLf20RDBWyPRTU0Ueo6im6wtWnP908Vcacn0Mp1YR3aQ1tjcDINUZ72GFSHbDdl7mty28BeJ9VYC4iawTrvU5xXV6L8LbC3ZZL2f+0JR/E64xXTTwrerOKtj6cPh1OG8PaXeaxcqwiZIg2csK9asdNERXAPArVtdHtrSMR26BAPQVfjhVe1d8YKC0PIq1nUd2U4rTZyAc1YS3AUZzVrAA6UoAx0ptmLZXEQFSLGO9S4FGKQhgQCl2inYoxQAbQKMUtFACYFGKWigAooooAKKKKACiiigAooooAKKKKACiig4xzQA2ilxRigBMZpcUo6UUAJijFLRQAlLRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUABpvOc06koAaQSfamsh6rgVJSYoGMAP8ROfamPBFI254kY+4zUuKMUAijPpFhcKQ9tEPcKKy5/BOkXH3llX/AHWxXR4oxScU90Wqk47M5F/h1oj97j/v5ULfDXR+qSXGe2XrtMUYqfZQ7GixNZfaZxH/AArXTj1lm/77pP8AhV2jP9+W5/CSu4oo9lDsH1qt/Mzil+F3h9e9yf8AtpV+28B6Ja/cjkb/AHmzXTUU1CK6EOrUluzNt9C0624S0hYf7SA1bS1giOYoIk/3VAqejFVZENt7jCpPU8e1IFOecD6VJigCnckTYDzTttGKWkAUmKWigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoNFIxwM0ALRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFJS0UAJRS0UANpRS0UAJRS0hoAKKSigAooooAKKKKAFFFApaAEopaKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKQ9KWigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigD/9k="


class WebsiteUser(FastHttpUser):
    def on_start(self):
        self._payload = {
            "prompt": (
                "Portrait of The Terminator, glare pose, detailed, intricate, full of"
                " colour, cinematic lighting, trending on artstation, 8k,"
                " hyperrealistic, focused, extreme details, unreal engine 5, cinematic,"
                " masterpiece"
            ),
            "seed": 2159232,
            "strength": 0.5,
            "steps": 4,
            "guidance_scale": 8.0,
            "width": 512,
            "height": 512,
            "lcm_steps": 50,
            "input_image": EXAMPLE_IMAGE_BASE64,
        }

        self._post_payload()

    @task
    def post_payload(self):
        self._post_payload()

    def _post_payload(self):
        self.client.post("/run", json=self._payload)
