classDiagram
direction BT
class BaseServlet {
  + service(HttpServletRequest, HttpServletResponse) void
  + BaseServlet() 
}
class DepManagerService {
<<Interface>>
  + updateJobSalary(Job) void
  + searchEmployeesByName(String, int) List~Employee~
  + selectJobInfos(int) List~Job~
  + updateEmp(Employee) void
  + insertEmp(Employee) void
  + insertJob(Job) void
  + selectJobIdByName(String) int
  + selectByName(String) List~Employee~
  + selectIdByName(String) int
  + deleteEmp(int) void
  + selectAllEmployees(int) List~Employee~
  + selectById(int) Employee
  + selectJobs(int) String[]
}
class DepManagerServiceImpl {
  + selectJobs(int) String[]
  + selectAllEmployees(int) List~Employee~
  + selectById(int) Employee
  + selectIdByName(String) int
  + selectByName(String) List~Employee~
  + updateEmp(Employee) void
  + insertEmp(Employee) void
  + selectJobInfos(int) List~Job~
  + searchEmployeesByName(String, int) List~Employee~
  + updateJobSalary(Job) void
  + insertJob(Job) void
  + deleteEmp(int) void
  + selectJobIdByName(String) int
  + DepManagerServiceImpl() 
}
class DepManagerServlet {
  + updateEmp(HttpServletRequest, HttpServletResponse) void
  + addEmp(HttpServletRequest, HttpServletResponse) void
  + updateJobSalary(HttpServletRequest, HttpServletResponse) void
  + deleteEmployee(HttpServletRequest, HttpServletResponse) void
  + insertJob(HttpServletRequest, HttpServletResponse) void
  + selectAllEmp(HttpServletRequest, HttpServletResponse) void
  + selectJobNames(HttpServletRequest, HttpServletResponse) void
  + selectJobInfos(HttpServletRequest, HttpServletResponse) void
  + searchEmployeesByName(HttpServletRequest, HttpServletResponse) void
  + DepManagerServlet() 
}
class EmpServlet {
  + login(HttpServletRequest, HttpServletResponse) void
  + changePasswd(HttpServletRequest, HttpServletResponse) void
  + updateSelfInfo(HttpServletRequest, HttpServletResponse) void
  + EmpServlet() 
}
class Employee {
  - String dep_name
  - String name
  - Integer dep_id
  - String job_name
  - Float rate
  - String sex
  - String tel
  - Integer id
  - Integer manager_id
  - String address
  - Float salary
  - String birth
  - Integer job_id
  - String age
  - String cardId
  - String passwd
   String birth
   int dep_id
   String tel
   String dep_name
   String job_name
   String address
   Float salary
   String name
   String age
   String passwd
   String cardId
   int id
   int job_id
   String sex
   Integer manager_id
   Float rate
  + toString() String
  + Employee(String, String, String, String, String, String, String, int, int) 
  + Employee() 
}
class EmployeeService {
<<Interface>>
  + changePasswd(int, String) boolean
  + login(int, String) Employee
  + updateEmp(Employee) boolean
}
class EmployeeServiceImpl {
  + updateEmp(Employee) boolean
  + login(int, String) Employee
  + changePasswd(int, String) boolean
  + EmployeeServiceImpl() 
}
class Manager {
  - String name
  - String passwd
  - int id
   String name
   int id
   String type
   String passwd
  + toString() String
  + Manager(String, String) 
  + Manager() 
  + Manager(String) 
  + Manager(int, String, String) 
}
class ManagerService {
<<Interface>>
  + selectAllDepInfo() List~HashMap~String, String~~
  + login(String, String) boolean
  + changePasswd(String, String) boolean
  + updateManagerOfDep(int, int) boolean
  + backupDatabase() boolean
}
class ManagerServiceImpl {
   String _time
  + login(String, String) boolean
  + updateManagerOfDep(int, int) boolean
  + selectManagerIdOfDep(int) int
  + backupDatabase() boolean
  + changePasswd(String, String) boolean
  + selectAllDepInfo() List~HashMap~String, String~~
  + ManagerServiceImpl() 
}
class ManagerServlet {
  + backupDatabase(HttpServletRequest, HttpServletResponse) void
  + getAllDepInfo(HttpServletRequest, HttpServletResponse) void
  + login(HttpServletRequest, HttpServletResponse) void
  + changePasswd(HttpServletRequest, HttpServletResponse) void
  + updateManagerOfDep(HttpServletRequest, HttpServletResponse) void
  + ManagerServlet() 
}
class People {
  - Integer id
  - String name
   String name
   int id
  + People() 
}

DepManagerServiceImpl  ..>  DepManagerService 
DepManagerServlet  -->  BaseServlet 
EmpServlet  -->  BaseServlet 
Employee  -->  People 
EmployeeServiceImpl  ..>  EmployeeService 
Manager  -->  People 
ManagerServiceImpl  ..>  ManagerService 
ManagerServlet  -->  BaseServlet 
