from setuptools import setup, find_packages

setup(
    name="odin-slides",
    version="0.9",
    packages=find_packages(),
    install_requires=[
        'python-pptx',
        'python-docx',
        'requests',
        'colorama',
        'tqdm'
    ],
    entry_points={
        "console_scripts": [
            "odin-slides=odin_slides.main:main",
        ],
    },
    test_suite="tests",
    long_description_content_type="text/markdown",
    long_description = """
## Odin-Slides: Empower Your Presentations with AI

Odin-Slides is an advanced Python tool that empowers you to effortlessly craft impressive PowerPoint presentations. By harnessing the capabilities of Language Models (LLM), Odin-Slides takes presentation creation to the next level.

### Key Features:

1. **Smart Presentation Creation:**
   Easily craft new PowerPoint presentations or update existing ones through odin-slides' intuitive command-line interface. Provide a template, and let odin-slides manage the rest, ensuring a seamless experience.

2. **Input-Driven Presentation Generation:**
   Harness the power of odin-slides to effortlessly transform Microsoft Word (docx) files into captivating presentations. This intelligent tool expertly distills extensive Word documents, converting input into impactful and concise slides. Keep an eye out for upcoming updates that will expand compatibility to include file formats like LaTeX and PDF.

3. **Customizable Language Models:**
   odin-slides supports various language models, with OpenAI GPT-3.5 Turbo as the initial option. Tailor your choice of language model to best suit your presentation requirements, granting you flexibility and control.

4. **Automatic Template Loading:**
   Specify your desired PowerPoint file as a template, and odin-slides will automatically apply its layout theme. Eliminate the need for manual template configuration each time you create a presentation.

5. **Session Resumption:**
   Save your presentation creation sessions for future resumption, allowing you to work at your preferred pace. odin-slides keeps track of your progress, enabling you to seamlessly continue from where you left off.

6. **Extensibility:**
   odin-slides is designed for extensibility, accommodating additional Language Models and file types in forthcoming updates. Anticipate enhanced functionality and new features as the tool evolves.

### Latest Updates

#### Version 0.9 (February 27, 2024)

- Deprecated `gpt-3.5-turbo-16k` in favor of defaulting to `gpt-3.5-turbo` with a 16k context window.

#### Version 0.7 (November 19, 2023)

- This update addresses a bug in prior versions that resulted in the creation of empty presentations due to certain inconsistencies. The update not only resolves this specific issue but also incorporates improved handling of undeterministic inconsistencies, ensuring a more reliable and stable user experience in alignment with the latest OpenAI updates. ([Issue #2](https://github.com/leonid20000/odin-slides/issues/2))

#### Version 0.6 (September 27, 2023)

- Added a new feature that allows odin-slides adopt manual modifications done by the user to the pptx text. This includes manually modified text in the title or the content of the slides. ([Issue #1](https://github.com/leonid20000/odin-slides/issues/1))


Stay ahead in the world of presentations with odin-slides — your versatile and intelligent helper in creating impactful content.
""",
    description="An advanced Python tool that empowers you to effortlessly draft impressive PowerPoint presentations from Word documents using generative AI.",
    url="https://github.com/leonid20000/odin-slides",
    author="Dr. Leonit Zeynalvand",
    license="MIT",    
)