#pragma once

#include "common/types.h"

namespace game::act {
class Actor;
};

namespace game::sound {

enum class EffectId : u32 {
  SEQ_DUMMY = 0x01000000,
  NA_SE_PL_WALK_GROUND = 0x01000001,
  NA_SE_PL_WALK_SAND = 0x01000002,
  NA_SE_PL_WALK_CONCRETE = 0x01000003,
  NA_SE_PL_WALK_DIRT = 0x01000004,
  NA_SE_PL_WALK_WATER0 = 0x01000005,
  NA_SE_PL_WALK_WATER1 = 0x01000006,
  NA_SE_PL_WALK_WATER2 = 0x01000007,
  NA_SE_PL_WALK_MAGMA = 0x01000008,
  NA_SE_PL_WALK_GRASS = 0x01000009,
  NA_SE_PL_WALK_IRON = 0x0100000a,
  NA_SE_PL_WALK_LADDER = 0x0100000b,
  NA_SE_PL_WALK_GLASS = 0x0100000c,
  NA_SE_PL_WALK_METAL1 = 0x0100000d,
  NA_CODE_DIRT_DEEP = 0x0100000e,
  NA_SE_PL_WALK_SNOW = 0x0100000f,
  NA_SE_PL_WALK_ICE = 0x01000010,
  NA_SE_PL_JUMP_GROUND = 0x01000011,
  NA_SE_PL_JUMP_SAND = 0x01000012,
  NA_SE_PL_JUMP_CONCRETE = 0x01000013,
  NA_SE_PL_JUMP_DIRT = 0x01000014,
  NA_SE_PL_JUMP_WATER0 = 0x01000015,
  NA_SE_PL_JUMP_WATER1 = 0x01000016,
  NA_SE_PL_JUMP_WATER2 = 0x01000017,
  NA_SE_PL_JUMP_MAGMA = 0x01000018,
  NA_SE_PL_JUMP_GRASS = 0x01000019,
  NA_SE_PL_JUMP_IRON = 0x0100001a,
  NA_SE_PL_JUMP_LADDER = 0x0100001b,
  NA_SE_PL_JUMP_GLASS = 0x0100001c,
  NA_SE_PL_DUMMY_28 = 0x0100001d,
  NA_SE_PL_JUMP_HEAVYBOOTS = 0x0100001e,
  NA_SE_PL_JUMP_SNOW = 0x0100001f,
  NA_SE_PL_JUMP_ICE = 0x01000020,
  NA_SE_PL_LAND_GROUND = 0x01000021,
  NA_SE_PL_LAND_SAND = 0x01000022,
  NA_SE_PL_LAND_CONCRETE = 0x01000023,
  NA_SE_PL_LAND_DIRT = 0x01000024,
  NA_SE_PL_LAND_WATER0 = 0x01000025,
  NA_SE_PL_LAND_WATER1 = 0x01000026,
  NA_SE_PL_LAND_WATER2 = 0x01000027,
  NA_SE_PL_LAND_MAGMA = 0x01000028,
  NA_SE_PL_LAND_GRASS = 0x01000029,
  NA_SE_PL_LAND_IRON = 0x0100002a,
  NA_SE_PL_LAND_LADDER = 0x0100002b,
  NA_SE_PL_LAND_GLASS = 0x0100002c,
  NA_SE_PL_DUMMY_44 = 0x0100002d,
  NA_SE_PL_LAND_HEAVYBOOTS = 0x0100002e,
  NA_SE_PL_LAND_SNOW = 0x0100002f,
  NA_SE_PL_LAND_ICE = 0x01000030,
  NA_SE_PL_SLIPDOWN = 0x01000031,
  NA_SE_PL_CLIMB_CLIFF = 0x01000032,
  NA_SE_PL_SIT_ON_HORSE = 0x01000033,
  NA_SE_PL_GET_OFF_HORSE = 0x01000034,
  NA_SE_PL_TAKE_OUT_SHIELD = 0x01000035,
  NA_SE_PL_CHANGE_ARMS = 0x01000036,
  NA_SE_PL_CATCH_BOOMERANG = 0x01000037,
  NA_SE_PL_DIVE_INTO_WATER = 0x01000038,
  NA_SE_PL_JUMP_OUT_WATER = 0x01000039,
  NA_SE_PL_SWIM = 0x0100003a,
  NA_SE_PL_THROW = 0x0100003b,
  NA_SE_PL_BODY_BOUND = 0x0100003c,
  NA_SE_PL_ROLL = 0x0100003d,
  NA_SE_PL_SKIP = 0x0100003e,
  NA_SE_PL_BODY_HIT = 0x0100003f,
  NA_SE_PL_DAMAGE = 0x01000040,
  NA_SE_PL_SLIP = 0x01000041,
  NA_SE_PL_SLIP_SAND = 0x01000042,
  NA_SE_PL_SLIP_CONCRETE = 0x01000043,
  NA_SE_PL_SLIP_DIRT = 0x01000044,
  NA_SE_PL_SLIP_WATER0 = 0x01000045,
  NA_SE_PL_SLIP_WATER1 = 0x01000046,
  NA_SE_PL_SLIP_WATER2 = 0x01000047,
  NA_SE_PL_SLIP_MAGMA = 0x01000048,
  NA_SE_PL_SLIP_GRASS = 0x01000049,
  NA_SE_PL_SLIP_IRON = 0x0100004a,
  NA_SE_PL_SLIP_LADDER = 0x0100004b,
  NA_SE_PL_SLIP_GLASS = 0x0100004c,
  NA_SE_PL_DUMMY76 = 0x0100004d,
  NA_SE_PL_SLIP_HEAVYBOOTS = 0x0100004e,
  NA_SE_PL_SLIP_SNOW = 0x0100004f,
  NA_SE_PL_SLIP_ICE = 0x01000050,
  NA_SE_PL_BOUND = 0x01000051,
  NA_SE_PL_BOUND_SAND = 0x01000052,
  NA_SE_PL_BOUND_CONCRETE = 0x01000053,
  NA_SE_PL_BOUND_DIRT = 0x01000054,
  NA_SE_PL_BOUND_WATER0 = 0x01000055,
  NA_SE_PL_BOUND_WATER1 = 0x01000056,
  NA_SE_PL_BOUND_WATER2 = 0x01000057,
  NA_SE_PL_BOUND_MAGMA = 0x01000058,
  NA_SE_PL_BOUND_GRASS = 0x01000059,
  NA_SE_PL_BOUND_IRON = 0x0100005a,
  NA_SE_PL_BOUND_LADDER = 0x0100005b,
  NA_SE_PL_BOUND_WOOD = 0x0100005c,
  NA_SE_PL_DUMMY_92 = 0x0100005d,
  NA_SE_PL_BOUND_HEAVYBOOTS = 0x0100005e,
  NA_SE_PL_BOUND_SNOW = 0x0100005f,
  NA_SE_PL_BOUND_ICE = 0x01000060,
  NA_SE_PL_BOW_DRAW = 0x01000061,
  NA_SE_PL_MEATL_BOOTS_JUMP = 0x01000062,
  NA_SE_PL_DUMMY_98 = 0x01000063,
  NA_SE_PL_FACE_UP = 0x01000064,
  NA_SE_PL_DIVE_BUBBLE = 0x01000065,
  NA_SE_PL_MOVE_BUBBLE = 0x01000066,
  NA_SE_PL_METALEFFECT_KID = 0x01000067,
  NA_SE_PL_METALEFFECT_ADULT = 0x01000068,
  NA_SE_PL_SPARK = 0x01000069,
  NA_SE_PL_PULL_UP_PLANT = 0x0100006a,
  NA_SE_PL_PULL_UP_ROCK = 0x0100006b,
  NA_SE_PL_IN_BUBBLE = 0x0100006c,
  NA_SE_PL_PULL_UP_BIGROCK = 0x0100006d,
  NA_SE_PL_SWORD_CHARGE = 0x0100006e,
  NA_SE_PL_FREEZE = 0x0100006f,
  NA_SE_PL_PULL_UP_POT = 0x01000070,
  NA_SE_PL_KNOCK = 0x01000071,
  NA_SE_PL_CALM_HIT = 0x01000072,
  NA_SE_PL_CALM_PAT = 0x01000073,
  NA_SE_PL_SUBMERGE = 0x01000074,
  NA_SE_PL_FREEZE_S = 0x01000075,
  NA_SE_PL_ICE_BROKEN = 0x01000076,
  NA_SE_PL_SLIP_ICE_LELEL = 0x01000077,
  NA_SE_PL_PUT_OUT_ITEM = 0x01000078,
  NA_SE_PL_PULL_UP_WOODBOX = 0x01000079,
  NA_SE_PL_MAGIC_FIRE = 0x0100007a,
  NA_SE_PL_MAGIC_WIND_NORMAL = 0x0100007b,
  NA_SE_PL_MAGIC_WIND_WARP = 0x0100007c,
  NA_SE_PL_MAGIC_SOUL_NORMAL = 0x0100007d,
  NA_SE_PL_ARROW_CHARGE_FIRE = 0x0100007e,
  NA_SE_PL_ARROW_CHARGE_ICE = 0x0100007f,
  NA_SE_PL_ARROW_CHARGE_LIGHT = 0x01000080,
  NA_SE_DUMMY_128 = 0x01000081,
  NA_SE_DUMMY_129 = 0x01000082,
  NA_SE_DUMMY_130 = 0x01000083,
  NA_SE_PL_PULL_UP_RUTO = 0x01000084,
  NA_SE_DUMMY_132 = 0x01000085,
  NA_SE_DUMMY_133 = 0x01000086,
  NA_SE_DUMMY_134 = 0x01000087,
  NA_SE_DUMMY_135 = 0x01000088,
  NA_SE_DUMMY_136 = 0x01000089,
  NA_SE_DUMMY_137 = 0x0100008a,
  NA_SE_DUMMY_138 = 0x0100008b,
  NA_SE_DUMMY_139 = 0x0100008c,
  NA_SE_DUMMY_140 = 0x0100008d,
  NA_SE_DUMMY_141 = 0x0100008e,
  NA_SE_DUMMY_142 = 0x0100008f,
  NA_SE_DUMMY_143 = 0x01000090,
  NA_SE_DUMMY_144 = 0x01000091,
  NA_SE_DUMMY_145 = 0x01000092,
  NA_SE_DUMMY_146 = 0x01000093,
  NA_SE_DUMMY_147 = 0x01000094,
  NA_SE_DUMMY_148 = 0x01000095,
  NA_SE_DUMMY_149 = 0x01000096,
  NA_SE_DUMMY_150 = 0x01000097,
  NA_SE_DUMMY_151 = 0x01000098,
  NA_SE_DUMMY_152 = 0x01000099,
  NA_SE_DUMMY_153 = 0x0100009a,
  NA_SE_DUMMY_154 = 0x0100009b,
  NA_SE_DUMMY_155 = 0x0100009c,
  NA_SE_DUMMY_156 = 0x0100009d,
  NA_SE_DUMMY_157 = 0x0100009e,
  NA_SE_DUMMY_158 = 0x0100009f,
  NA_SE_DUMMY_159 = 0x010000a0,
  NA_SE_DUMMY_160 = 0x010000a1,
  NA_SE_DUMMY_161 = 0x010000a2,
  NA_SE_DUMMY_162 = 0x010000a3,
  NA_SE_DUMMY_163 = 0x010000a4,
  NA_SE_DUMMY_164 = 0x010000a5,
  NA_SE_DUMMY_165 = 0x010000a6,
  NA_SE_DUMMY_166 = 0x010000a7,
  NA_SE_DUMMY_167 = 0x010000a8,
  NA_SE_DUMMY_168 = 0x010000a9,
  NA_SE_DUMMY_169 = 0x010000aa,
  NA_SE_DUMMY_170 = 0x010000ab,
  NA_SE_DUMMY_171 = 0x010000ac,
  NA_SE_DUMMY_172 = 0x010000ad,
  NA_SE_DUMMY_173 = 0x010000ae,
  NA_SE_DUMMY_174 = 0x010000af,
  NA_SE_DUMMY_175 = 0x010000b0,
  NA_SE_PL_CRAWL = 0x010000b1,
  NA_SE_PL_CRAWL_SAND = 0x010000b2,
  NA_SE_PL_CRAWL_CONCRETE = 0x010000b3,
  NA_SE_PL_CRAWL_DIRT = 0x010000b4,
  NA_SE_PL_CRAWL_WATER0 = 0x010000b5,
  NA_SE_DUMMY_181 = 0x010000b6,
  NA_SE_DUMMY_182 = 0x010000b7,
  NA_SE_DUMMY_183 = 0x010000b8,
  NA_SE_DUMMY_184 = 0x010000b9,
  NA_SE_DUMMY_185 = 0x010000ba,
  NA_SE_DUMMY_186 = 0x010000bb,
  NA_SE_PL_CRAWL_WOOD = 0x010000bc,
  NA_SE_DUMMY_188 = 0x010000bd,
  NA_SE_DUMMY_189 = 0x010000be,
  NA_SE_DUMMY_190 = 0x010000bf,
  NA_SE_PL_CRAWL_ICE = 0x010000c0,
  NA_SE_PL_MAGIC_SOUL_FLASH = 0x010000c1,
  NA_SE_PL_ROLL_DUST = 0x010000c2,
  NA_SE_DUMMY_194 = 0x010000c3,
  NA_SE_PL_MAGIC_SOUL_BALL = 0x010000c4,
  NA_SE_PL_SPIRAL_HEAL_BEAM = 0x010000c5,
  NA_SE_PL_BOUND_NOWEAPON = 0x010000c6,
  NA_SE_PL_PLANT_GROW_UP = 0x010000c7,
  NA_SE_PL_PLANT_TALLER = 0x010000c8,
  NA_SE_PL_MAGIC_WIND_VANISH = 0x010000c9,
  NA_SE_PL_HOBBERBOOTS_LV = 0x010000ca,
  NA_SE_PL_PLANT_MOVE = 0x010000cb,
  NA_SE_EV_WALL_MOVE_SP = 0x010000cc,
  NA_SE_PL_PLANT_GROW_BIG = 0x010000cd,
  NA_SE_PL_TELESCOPE_MOVEMENT = 0x010000ce,
  NA_SE_PL_GIANT_WALK = 0x010000cf,
  NA_SE_PL_CHIBI_FAIRY_HEAL = 0x010000d0,
  NA_SE_PL_SLIP_LEVEL = 0x010000d1,
  NA_SE_PL_SLIP_SAND_LEVEL = 0x010000d2,
  NA_SE_PL_SLIP_CONCRETE_LEVEL = 0x010000d3,
  NA_SE_PL_SLIP_DIRT_LEVEL = 0x010000d4,
  NA_SE_PL_SLIP_WATER0_LEVEL = 0x010000d5,
  NA_SE_PL_SLIP_WATER1_LEVEL = 0x010000d6,
  NA_SE_PL_SLIP_WATER2_LEVEL = 0x010000d7,
  NA_SE_PL_SLIP_MAGMA_LEVEL = 0x010000d8,
  NA_SE_PL_SLIP_GRASS_LEVEL = 0x010000d9,
  NA_SE_PL_SLIP_IRON_LEVEL = 0x010000da,
  NA_SE_PL_SLIP_LADDER_LEVEL = 0x010000db,
  NA_SE_PL_SLIP_GLASS_LEVEL = 0x010000dc,
  NA_SE_PL_DUMMY_220 = 0x010000dd,
  NA_SE_PL_SLIP_HEAVYBOOTS_LEVEL = 0x010000de,
  NA_SE_PL_DUMMY_222 = 0x010000df,
  NA_SE_PL_SLIP_ICE_LEVEL = 0x010000e0,
  NA_SE_PL_DEKUNUTS_FIRE = 0x010000e1,
  NA_SE_PL_GORON_BALLJUMP = 0x010000e2,
  NA_SE_PL_DEKUNUTS_IN_GRD = 0x010000e3,
  NA_SE_PL_DEKUNUTS_OUT_GRD = 0x010000e4,
  NA_SE_PL_TRANSFORM = 0x010000e5,
  NA_SE_PL_TRANSFORM_DEMO = 0x010000e6,
  NA_SE_PL_GORON_TO_BALL = 0x010000e7,
  NA_SE_PL_BALL_TO_GORON = 0x010000e8,
  NA_SE_PL_GORON_PUNCH = 0x010000e9,
  NA_SE_PL_SINK_ON_SAND = 0x010000ea,
  NA_SE_PL_SINK_ON_SNOW = 0x010000eb,
  NA_SE_PL_GORON_BALL_CHARGE = 0x010000ec,
  NA_SE_PL_ZORA_SWIM_DASH = 0x010000ed,
  NA_SE_PL_ZORA_SWIM_LV = 0x010000ee,
  NA_SE_PL_ZORA_SWIM_ROLL = 0x010000ef,
  NA_SE_PL_GORON_SQUAT = 0x010000f0,
  NA_SE_PL_DUMMY_240 = 0x010000f1,
  NA_SE_PL_DUMMY_241 = 0x010000f2,
  NA_SE_PL_DUMMY_242 = 0x010000f3,
  NA_SE_PL_DUMMY_243 = 0x010000f4,
  NA_SE_PL_DUMMY_244 = 0x010000f5,
  NA_SE_PL_DUMMY_245 = 0x010000f6,
  NA_SE_PL_DUMMY_246 = 0x010000f7,
  NA_SE_PL_DUMMY_247 = 0x010000f8,
  NA_SE_PL_DUMMY_248 = 0x010000f9,
  NA_SE_PL_DUMMY_249 = 0x010000fa,
  NA_SE_PL_DUMMY_250 = 0x010000fb,
  NA_SE_PL_DUMMY_251 = 0x010000fc,
  NA_SE_PL_DUMMY_252 = 0x010000fd,
  NA_SE_PL_DUMMY_253 = 0x010000fe,
  NA_SE_PL_DUMMY_254 = 0x010000ff,
  NA_SE_PL_DUMMY_255 = 0x01000100,
  NA_SE_PL_DUMMY_256 = 0x01000101,
  NA_SE_PL_DUMMY_257 = 0x01000102,
  NA_SE_PL_DUMMY_258 = 0x01000103,
  NA_SE_PL_DUMMY_259 = 0x01000104,
  NA_SE_PL_DUMMY_260 = 0x01000105,
  NA_SE_PL_DUMMY_261 = 0x01000106,
  NA_SE_PL_DUMMY_262 = 0x01000107,
  NA_SE_PL_DUMMY_263 = 0x01000108,
  NA_SE_PL_DUMMY_264 = 0x01000109,
  NA_SE_PL_DUMMY_265 = 0x0100010a,
  NA_SE_PL_DUMMY_266 = 0x0100010b,
  NA_SE_PL_DUMMY_267 = 0x0100010c,
  NA_SE_PL_DUMMY_268 = 0x0100010d,
  NA_SE_PL_DUMMY_269 = 0x0100010e,
  NA_SE_PL_DUMMY_270 = 0x0100010f,
  NA_SE_PL_DUMMY_271 = 0x01000110,
  NA_SE_PL_DUMMY_272 = 0x01000111,
  NA_SE_PL_DUMMY_273 = 0x01000112,
  NA_SE_PL_DUMMY_274 = 0x01000113,
  NA_SE_PL_DUMMY_275 = 0x01000114,
  NA_SE_PL_DUMMY_276 = 0x01000115,
  NA_SE_PL_DUMMY_277 = 0x01000116,
  NA_SE_PL_DUMMY_278 = 0x01000117,
  NA_SE_PL_DUMMY_279 = 0x01000118,
  NA_SE_PL_DUMMY_280 = 0x01000119,
  NA_SE_PL_DUMMY_281 = 0x0100011a,
  NA_SE_PL_DUMMY_282 = 0x0100011b,
  NA_SE_PL_DUMMY_283 = 0x0100011c,
  NA_SE_PL_DUMMY_284 = 0x0100011d,
  NA_SE_PL_DUMMY_285 = 0x0100011e,
  NA_SE_PL_DUMMY_286 = 0x0100011f,
  NA_SE_PL_DUMMY_287 = 0x01000120,
  NA_SE_PL_DUMMY_288 = 0x01000121,
  NA_SE_PL_DUMMY_289 = 0x01000122,
  NA_SE_PL_DUMMY_290 = 0x01000123,
  NA_SE_PL_DUMMY_291 = 0x01000124,
  NA_SE_PL_DUMMY_292 = 0x01000125,
  NA_SE_PL_DUMMY_293 = 0x01000126,
  NA_SE_PL_DUMMY_294 = 0x01000127,
  NA_SE_PL_DUMMY_295 = 0x01000128,
  NA_SE_PL_DUMMY_296 = 0x01000129,
  NA_SE_PL_DUMMY_297 = 0x0100012a,
  NA_SE_PL_DUMMY_298 = 0x0100012b,
  NA_SE_PL_DUMMY_299 = 0x0100012c,
  NA_SE_PL_DUMMY_300 = 0x0100012d,
  NA_SE_PL_DUMMY_301 = 0x0100012e,
  NA_SE_PL_DUMMY_302 = 0x0100012f,
  NA_SE_PL_DUMMY_303 = 0x01000130,
  NA_SE_PL_DUMMY_304 = 0x01000131,
  NA_SE_PL_DUMMY_305 = 0x01000132,
  NA_SE_PL_DUMMY_306 = 0x01000133,
  NA_SE_PL_DUMMY_307 = 0x01000134,
  NA_SE_PL_DUMMY_308 = 0x01000135,
  NA_SE_PL_DUMMY_309 = 0x01000136,
  NA_SE_PL_DUMMY_310 = 0x01000137,
  NA_SE_PL_DUMMY_311 = 0x01000138,
  NA_SE_PL_DUMMY_312 = 0x01000139,
  NA_SE_PL_DUMMY_313 = 0x0100013a,
  NA_SE_PL_DUMMY_314 = 0x0100013b,
  NA_SE_PL_DUMMY_315 = 0x0100013c,
  NA_SE_PL_DUMMY_316 = 0x0100013d,
  NA_SE_PL_DUMMY_317 = 0x0100013e,
  NA_SE_PL_DUMMY_318 = 0x0100013f,
  NA_SE_PL_DUMMY_319 = 0x01000140,
  NA_SE_PL_DUMMY_320 = 0x01000141,
  NA_SE_PL_DUMMY_321 = 0x01000142,
  NA_SE_PL_DUMMY_322 = 0x01000143,
  NA_SE_PL_DUMMY_323 = 0x01000144,
  NA_SE_PL_DUMMY_324 = 0x01000145,
  NA_SE_PL_DUMMY_325 = 0x01000146,
  NA_SE_PL_DUMMY_326 = 0x01000147,
  NA_SE_PL_DUMMY_327 = 0x01000148,
  NA_SE_PL_DUMMY_328 = 0x01000149,
  NA_SE_PL_DUMMY_329 = 0x0100014a,
  NA_SE_PL_DUMMY_330 = 0x0100014b,
  NA_SE_PL_DUMMY_331 = 0x0100014c,
  NA_SE_PL_DUMMY_332 = 0x0100014d,
  NA_SE_PL_DUMMY_333 = 0x0100014e,
  NA_SE_PL_DUMMY_334 = 0x0100014f,
  NA_SE_PL_DUMMY_335 = 0x01000150,
  NA_SE_PL_DUMMY_336 = 0x01000151,
  NA_SE_PL_DUMMY_337 = 0x01000152,
  NA_SE_PL_DUMMY_338 = 0x01000153,
  NA_SE_PL_DUMMY_339 = 0x01000154,
  NA_SE_PL_DUMMY_340 = 0x01000155,
  NA_SE_PL_DUMMY_341 = 0x01000156,
  NA_SE_PL_DUMMY_342 = 0x01000157,
  NA_SE_PL_DUMMY_343 = 0x01000158,
  NA_SE_PL_DUMMY_344 = 0x01000159,
  NA_SE_PL_DUMMY_345 = 0x0100015a,
  NA_SE_PL_DUMMY_346 = 0x0100015b,
  NA_SE_PL_DUMMY_347 = 0x0100015c,
  NA_SE_PL_DUMMY_348 = 0x0100015d,
  NA_SE_PL_DUMMY_349 = 0x0100015e,
  NA_SE_PL_DUMMY_350 = 0x0100015f,
  NA_SE_PL_DUMMY_351 = 0x01000160,
  NA_SE_EV_MARATHONMAN_RISE = 0x01000161,
  NA_SE_PL_DUMMY_353 = 0x01000162,
  NA_SE_PL_DUMMY_354 = 0x01000163,
  NA_SE_PL_DUMMY_355 = 0x01000164,
  NA_SE_PL_DUMMY_356 = 0x01000165,
  NA_SE_PL_DUMMY_357 = 0x01000166,
  NA_SE_PL_DUMMY_358 = 0x01000167,
  NA_SE_PL_DUMMY_359 = 0x01000168,
  NA_SE_PL_DUMMY_360 = 0x01000169,
  NA_SE_PL_DUMMY_361 = 0x0100016a,
  NA_SE_PL_DUMMY_362 = 0x0100016b,
  NA_SE_PL_DUMMY_363 = 0x0100016c,
  NA_SE_PL_DUMMY_364 = 0x0100016d,
  NA_SE_PL_DUMMY_365 = 0x0100016e,
  NA_SE_PL_DUMMY_366 = 0x0100016f,
  NA_SE_PL_DUMMY_367 = 0x01000170,
  NA_SE_EV_MARATHONMAN_LAND = 0x01000171,
  NA_SE_PL_DUMMY_369 = 0x01000172,
  NA_SE_PL_DUMMY_370 = 0x01000173,
  NA_SE_PL_DUMMY_371 = 0x01000174,
  NA_SE_PL_DUMMY_372 = 0x01000175,
  NA_SE_PL_DUMMY_373 = 0x01000176,
  NA_SE_PL_DUMMY_374 = 0x01000177,
  NA_SE_PL_DUMMY_375 = 0x01000178,
  NA_SE_PL_DUMMY_376 = 0x01000179,
  NA_SE_PL_DUMMY_377 = 0x0100017a,
  NA_SE_PL_DUMMY378 = 0x0100017b,
  NA_SE_PL_DUMMY_379 = 0x0100017c,
  NA_SE_PL_DUMMY_380 = 0x0100017d,
  NA_SE_PL_DUMMY_381 = 0x0100017e,
  NA_SE_PL_DUMMY_382 = 0x0100017f,
  NA_SE_PL_DUMMY_383 = 0x01000180,
  NA_SE_PL_GORON_CHG_ROLL = 0x01000181,
  NA_SE_PL_DUMMY_385 = 0x01000182,
  NA_SE_PL_DUMMY_386 = 0x01000183,
  NA_SE_PL_DUMMY_387 = 0x01000184,
  NA_SE_PL_DUMMY_388 = 0x01000185,
  NA_SE_PL_DUMMY_389 = 0x01000186,
  NA_SE_PL_DUMMY_390 = 0x01000187,
  NA_SE_PL_DUMMY_391 = 0x01000188,
  NA_SE_PL_DUMMY_392 = 0x01000189,
  NA_SE_PL_DUMMY_393 = 0x0100018a,
  NA_SE_PL_DUMMY_394 = 0x0100018b,
  NA_SE_PL_DUMMY_395 = 0x0100018c,
  NA_SE_PL_DUMMY_396 = 0x0100018d,
  NA_SE_PL_DUMMY_397 = 0x0100018e,
  NA_SE_PL_DUMMY_398 = 0x0100018f,
  NA_SE_PL_GORON_CHG_ROLL_ICE = 0x01000190,
  NA_SE_PL_GORON_ROLL = 0x01000191,
  NA_SE_PL_DUMMY_401 = 0x01000192,
  NA_SE_PL_DUMMY_402 = 0x01000193,
  NA_SE_PL_DUMMY_403 = 0x01000194,
  NA_SE_PL_DUMMY_404 = 0x01000195,
  NA_SE_PL_DUMMY_405 = 0x01000196,
  NA_SE_PL_DUMMY_406 = 0x01000197,
  NA_SE_PL_DUMMY_407 = 0x01000198,
  NA_SE_PL_DUMMY_408 = 0x01000199,
  NA_SE_PL_DUMMY_409 = 0x0100019a,
  NA_SE_PL_DUMMY_410 = 0x0100019b,
  NA_SE_PL_DUMMY_411 = 0x0100019c,
  NA_SE_PL_DUMMY_412 = 0x0100019d,
  NA_SE_PL_DUMMY_413 = 0x0100019e,
  NA_SE_PL_DUMMY_414 = 0x0100019f,
  NA_SE_PL_GORON_ROLL_ICE = 0x010001a0,
  NA_SE_PL_DEKUNUTS_BUD = 0x010001a1,
  NA_SE_PL_DEKUNUTS_BUBLE_BREATH = 0x010001a2,
  NA_SE_PL_GORON_BALL_CHARGE_FAILED = 0x010001a3,
  NA_SE_PL_GORON_BALL_CHARGE_DASH = 0x010001a4,
  NA_SE_PL_FACE_CHANGE = 0x010001a5,
  NA_SE_PL_FACE_UP_S = 0x010001a6,
  NA_SE_PL_DEKUNUTS_STRUGGLE = 0x010001a7,
  NA_SE_PL_WARP_PLATE = 0x010001a8,
  NA_SE_PL_WARP_PLATE_OUT = 0x010001a9,
  NA_SE_PL_DEKUNUTS_ATTACK = 0x010001aa,
  NA_SE_PL_TRANSFORM_VOICE = 0x010001ab,
  NA_SE_PL_FACE_RETURN = 0x010001ac,
  NA_SE_PL_DEKUNUTS_DROP_BOMB = 0x010001ad,
  NA_SE_PL_GORON_SLIP = 0x010001ae,
  NA_SE_PL_ROLL_SNOW_DUST = 0x010001af,
  NA_SE_PL_ZORA_SPARK_BARRIER = 0x010001b0,
  NA_SE_PL_DEKUNUTS_JUMP = 0x010001b1,
  NA_SE_PL_DEKUNUTS_JUMP2 = 0x010001b2,
  NA_SE_PL_DEKUNUTS_JUMP3 = 0x010001b3,
  NA_SE_PL_DEKUNUTS_JUMP4 = 0x010001b4,
  NA_SE_PL_DEKUNUTS_JUMP5 = 0x010001b5,
  NA_SE_PL_DEKUNUTS_JUMP6 = 0x010001b6,
  NA_SE_PL_DEKUNUTS_JUMP7 = 0x010001b7,
  NA_SE_PL_DEKUNUTS_JUMP8 = 0x010001b8,
  NA_SE_PL_GORON_STOMACH_EXPLOSION = 0x010001b9,
  NA_SE_PL_GORON_DRINK_BOMB = 0x010001ba,
  NA_SE_PL_GET_UP = 0x010001bb,
  NA_SE_PL_WARP_WING_OPEN = 0x010001bc,
  NA_SE_PL_WARP_WING_CLOSE = 0x010001bd,
  NA_SE_PL_WARP_WING_ROLL = 0x010001be,
  NA_SE_PL_WARP_WING_VANISH = 0x010001bf,
  NA_SE_PL_DEKUNUTS_MISS_FIRE = 0x010001c0,
  NA_SE_PL_FLYING_AIR = 0x010001c1,
  NA_SE_PL_FIREWORKS = 0x010001c2,
  NA_SE_PL_FIREWORKS_DUMMY = 0x010001c3,
  NA_SE_PL_PULL_UP_SNOWBALL = 0x010001c4,
  NA_SE_PL_WARP_WING_ROLL_2 = 0x010001c5,
  NA_SE_PL_TRANSFORM_GIANT = 0x010001c6,
  NA_SE_PL_TRANSFORM_NORAML = 0x010001c7,
  NA_SE_PL_LI_OKARINATORI = 0x010001c8,
  NA_SE_PL_LI_FUTTOBI = 0x010001c9,
  NA_SE_PL_LI_OP_OKIAGARI = 0x010001ca,
  NA_SE_PL_LI_OP_TATIAGARI = 0x010001cb,
  NA_SE_PL_JUMP_METAL = 0x010001cc,
  NA_SE_PL_LAND_METAL = 0x010001cd,
  NA_SE_PL_BOUND_METAL = 0x010001ce,
  NA_SE_PL_WALK_WALL = 0x010001cf,
  NA_SE_PL_WALK_WALL_DEKU = 0x010001d0,
  NA_SE_PL_WALK_WALL_ZORA = 0x010001d1,
  NA_SE_PL_WALK_WALL_GORON = 0x010001d2,
  NA_SE_PL_DEKU_IDOLING1 = 0x010001d3,
  NA_SE_PL_GOLON_IDOLING1 = 0x010001d4,
  NA_SE_PL_ZORA_IDOLING1 = 0x010001d5,
  NA_SE_PL_WALK_WALL2_METAL = 0x010001d6,
  NA_SE_PL_WALK_WALL2_DEKU = 0x010001d7,
  NA_SE_PL_WALK_WALL2_ZORA = 0x010001d8,
  NA_SE_PL_WALK_WALL2_GORON = 0x010001d9,
  NA_SE_PL_WALK_WEED = 0x010001da,
  NA_SE_PL_WALK_WOOD = 0x010001db,
  NA_SE_PL_JUMP_WOOD = 0x010001dc,
  NA_SE_PL_LAND_WOOD = 0x010001dd,
  NA_SE_PL_GIANT_SWING = 0x010001de,
  NA_SE_PL_GIANT_SWING2 = 0x010001df,
  NA_SE_PL_GIANT_SWING_FINISH = 0x010001e0,
  NA_SE_PL_GIANT_GUARD = 0x010001e1,
  NA_SE_PL_GIANT_GUARD_OFF = 0x010001e2,
  NA_SE_PL_GORON_GAKKI_START = 0x010001e3,
  NA_SE_PL_KEIREI = 0x010001e4,
  NA_SE_PL_GIANT_LINK_FOOT = 0x010001e5,
  NA_SE_PL_DUMMY485 = 0x010001e6,
  NA_SE_IT_SWORD_IMPACT = 0x010001e7,
  NA_SE_IT_SWORD_SWING = 0x010001e8,
  NA_SE_IT_SWORD_PUTAWAY = 0x010001e9,
  NA_SE_IT_SWORD_PICKOUT = 0x010001ea,
  NA_SE_IT_ARROW_SHOT = 0x010001eb,
  NA_SE_IT_BOOMERANG_THROW = 0x010001ec,
  NA_SE_IT_SHIELD_BOUND = 0x010001ed,
  NA_SE_IT_BOW_DRAW = 0x010001ee,
  NA_SE_IT_SHIELD_REFLECT_SW = 0x010001ef,
  NA_SE_IT_ARROW_STICK_HRAD = 0x010001f0,
  NA_SE_IT_HAMMER_HIT = 0x010001f1,
  NA_SE_IT_HOOKSHOT_CHAIN = 0x010001f2,
  NA_SE_IT_SHIELD_REFLECT_MG = 0x010001f3,
  NA_SE_IT_BOMB_IGNIT = 0x010001f4,
  NA_SE_IT_BOMB_EXPLOSION = 0x010001f5,
  NA_SE_IT_BOMB_UNEXPLOSION = 0x010001f6,
  NA_SE_IT_BOOMERANG_FLY = 0x010001f7,
  NA_SE_IT_SWORD_STRIKE = 0x010001f8,
  NA_SE_IT_HAMMER_SWING = 0x010001f9,
  NA_SE_IT_HOOKSHOT_REFLECT = 0x010001fa,
  NA_SE_IT_HOOKSHOT_STICK_CRE = 0x010001fb,
  NA_SE_IT_ARROW_STICK_OBJ = 0x010001fc,
  NA_SE_IT_SWORD_SLASH = 0x010001fd,
  NA_SE_IT_SWORD_SLASH_HARD = 0x010001fe,
  NA_SE_IT_SWORD_SWING_HARD = 0x010001ff,
  NA_SE_IT_BOMB_BOUND = 0x01000200,
  NA_SE_IT_WALL_HIT_HARD = 0x01000201,
  NA_SE_IT_WALL_HIT_SOFT = 0x01000202,
  NA_SE_IT_STONE_HIT = 0x01000203,
  NA_SE_IT_WOODSTICK_BROKEN = 0x01000204,
  NA_SE_IT_LASH = 0x01000205,
  NA_SE_IT_SHIELD_SWING = 0x01000206,
  NA_SE_IT_SLING_SHOT = 0x01000207,
  NA_SE_IT_SLING_DRAW = 0x01000208,
  NA_SE_IT_SWORD_CHARGE = 0x01000209,
  NA_SE_IT_ROLLING_CUT = 0x0100020a,
  NA_SE_IT_SWORD_STRIKE_HARD = 0x0100020b,
  NA_SE_IT_SLING_REFLECT = 0x0100020c,
  NA_SE_IT_SHIELD_REMOVE = 0x0100020d,
  NA_SE_IT_HOOKSHOT_READY = 0x0100020e,
  NA_SE_IT_HOOKSHOT_RECEIVE = 0x0100020f,
  NA_SE_IT_HOOKSHOT_STICK_OBJ = 0x01000210,
  NA_SE_IT_SWORD_REFLECT_MG = 0x01000211,
  NA_SE_IT_DEKU = 0x01000212,
  NA_SE_IT_WALL_HIT_BUYO = 0x01000213,
  NA_SE_IT_SWORD_PUTAWAY_STN = 0x01000214,
  NA_SE_IT_ROLLING_CUT_LV1 = 0x01000215,
  NA_SE_IT_ROLLING_CUT_LV2 = 0x01000216,
  NA_SE_IT_BOW_FLICK = 0x01000217,
  NA_SE_IT_BOMBCHU_MOVE = 0x01000218,
  NA_SE_IT_SHIELD_CHARGE_LV1 = 0x01000219,
  NA_SE_IT_SHIELD_CHARGE_LV2 = 0x0100021a,
  NA_SE_IT_SHIELD_CHARGE_LV3 = 0x0100021b,
  NA_SE_IT_SLING_FLICK = 0x0100021c,
  NA_SE_IT_SWORD_STICK_STN = 0x0100021d,
  NA_SE_IT_REFLECTION_WOOD = 0x0100021e,
  NA_SE_IT_SHIELD_REFLECT_MG2 = 0x0100021f,
  NA_SE_IT_MAGIC_ARROW_SHOT = 0x01000220,
  NA_SE_IT_EXPLOSION_FRAME = 0x01000221,
  NA_SE_IT_EXPLOSION_ICE = 0x01000222,
  NA_SE_IT_EXPLOSION_LIGHT = 0x01000223,
  NA_SE_IT_FISHING_REEL_SLOW = 0x01000224,
  NA_SE_IT_FISHING_REEL_HIGH = 0x01000225,
  NA_SE_IT_PULL_FISHING_ROD = 0x01000226,
  NA_SE_IT_DM_FLYING_GOD_PASS = 0x01000227,
  NA_SE_IT_DM_FLYING_GOD_DASH = 0x01000228,
  NA_SE_IT_DM_RING_EXPLOSION = 0x01000229,
  NA_SE_IT_DM_RING_GATHER = 0x0100022a,
  NA_SE_IT_INGO_HORSE_NEIGH = 0x0100022b,
  NA_SE_IT_EARTHQUAKE = 0x0100022c,
  NA_SE_IT_ERUPTION_PILLAR = 0x0100022d,
  NA_SE_IT_KAKASHI_JUMP = 0x0100022e,
  NA_SE_IT_FLAME = 0x0100022f,
  NA_SE_IT_SHIELD_BEAM = 0x01000230,
  NA_SE_IT_FISHING_HIT = 0x01000231,
  NA_SE_IT_GOODS_APPEAR = 0x01000232,
  NA_SE_IT_MAJIN_SWORD_BROKEN = 0x01000233,
  NA_SE_IT_HAND_CLAP = 0x01000234,
  NA_SE_IT_MASTER_SWORD_SWING = 0x01000235,
  NA_SE_IT_GORON_BALLFANG = 0x01000236,
  NA_SE_IT_DEKUNUTS_FLOWER_OPEN = 0x01000237,
  NA_SE_IT_DEKUNUTS_FLOWER_ROLL = 0x01000238,
  NA_SE_IT_DEKUNUTS_FLOWER_CLOSE = 0x01000239,
  NA_SE_IT_DEKUNUTS_BUBLE_BROKEN = 0x0100023a,
  NA_SE_IT_DEKUNUTS_BUBLE_VANISH = 0x0100023b,
  NA_SE_IT_DEKUNUTS_DROP_BOMB = 0x0100023c,
  NA_SE_IT_SET_TRANSFORM_MASK = 0x0100023d,
  NA_SE_IT_GORON_PUNCH_SWING = 0x0100023e,
  NA_SE_IT_TRANSFORM_MASK_BROKEN = 0x0100023f,
  NA_SE_IT_ZORA_KICK_SWING = 0x01000240,
  NA_SE_IT_DEKUNUTS_BUBLE_SHOT_LEVEL = 0x01000241,
  NA_SE_IT_BIG_BOMB_IGNIT = 0x01000242,
  NA_SE_IT_BIG_BOMB_EXPLOSION = 0x01000243,
  NA_SE_IT_REFLECTION_SNOW = 0x01000244,
  NA_SE_IT_GORON_ROLLING_REFLECTION = 0x01000245,
  NA_SE_IT_MASK_BOUND_0 = 0x01000246,
  NA_SE_IT_MASK_BOUND_1 = 0x01000247,
  NA_SE_IT_MASK_BOUND_SAND = 0x01000248,
  NA_SE_IT_REFLECTION_WATER = 0x01000249,
  NA_SE_IT_KYOJIN_BEARING = 0x0100024a,
  NA_SE_FISHING_REEL_SLOW2 = 0x0100024b,
  NA_SE_IT_LURE_LAND1 = 0x0100024c,
  NA_SE_IT_ROD_THROW = 0x0100024d,
  NA_SE_IT_REFLECT_BOSS = 0x0100024e,
  NA_SE_IT_SHIELD_SWING_ZORA = 0x0100024f,
  NA_SE_IT_SHIELD_REMOVE_ZORA = 0x01000250,
  NA_SE_IT_BOMB_EXPLOSION2 = 0x01000251,
  NA_SE_IT_FISHING_REEL_REVERSE = 0x01000252,
  NA_SE_IT_FISHING_WORM_BOUND = 0x01000253,
  NA_SE_IT_DUMMY_109 = 0x01000254,
  NA_SE_IT_DUMMY_110 = 0x01000255,
  NA_SE_EV_DOOR_OPEN = 0x01000256,
  NA_SE_EV_DOOR_CLOSE = 0x01000257,
  NA_SE_EV_EXPLOSION = 0x01000258,
  NA_SE_EV_HORSE_WALK = 0x01000259,
  NA_SE_EV_HORSE_RUN = 0x0100025a,
  NA_SE_EV_HORSE_NEIGH = 0x0100025b,
  NA_SE_EV_RIVER_STREAM = 0x0100025c,
  NA_SE_EV_WATER_WALL_BIG = 0x0100025d,
  NA_SE_EV_OUT_OF_WATER = 0x0100025e,
  NA_SE_EV_DIVE_WATER = 0x0100025f,
  NA_SE_EV_ROCK_SLIDE = 0x01000260,
  NA_SE_EV_MAGMA_LEVEL = 0x01000261,
  NA_SE_EV_BRIDGE_OPEN = 0x01000262,
  NA_SE_EV_BRIDGE_CLOSE = 0x01000263,
  NA_SE_EV_BRIDGE_OPEN_STOP = 0x01000264,
  NA_SE_EV_BRIDGE_CLOSE_STOP = 0x01000265,
  NA_SE_EV_WALL_BROKEN = 0x01000266,
  NA_SE_EV_CHICKEN_CRY_N = 0x01000267,
  NA_SE_EV_CHICKEN_CRY_A = 0x01000268,
  NA_SE_EV_CHICKEN_CRY_M = 0x01000269,
  NA_SE_EV_SLIDE_DOOR_OPEN = 0x0100026a,
  NA_SE_EV_FOOT_SWITCH = 0x0100026b,
  NA_SE_EV_HORSE_GROAN = 0x0100026c,
  NA_SE_EV_BOMB_DROP_WATER = 0x0100026d,
  NA_SE_EV_HORSE_JUMP = 0x0100026e,
  NA_SE_EV_HORSE_LAND = 0x0100026f,
  NA_SE_EV_HORSE_SLIP = 0x01000270,
  NA_SE_EV_WHITE_FAIRY_DASH = 0x01000271,
  NA_SE_EV_SLIDE_DOOR_CLOSE = 0x01000272,
  NA_SE_EV_BIGWALL_BOUND = 0x01000273,
  NA_SE_EV_STONE_STATUE_OPEN = 0x01000274,
  NA_SE_EV_TBOX_UNLOCK = 0x01000275,
  NA_SE_EV_TBOX_OPEN = 0x01000276,
  NA_SE_SY_TIMER = 0x01000277,
  NA_SE_EV_FLAME_IGNITION = 0x01000278,
  NA_SE_EV_SPEAR_HIT = 0x01000279,
  NA_SE_EV_ELEVATOR_MOVE = 0x0100027a,
  NA_SE_EV_WARP_HOLE = 0x0100027b,
  NA_SE_EV_LINK_WARP = 0x0100027c,
  NA_SE_EV_PILLAR_SINK = 0x0100027d,
  NA_SE_EV_WATER_WALL = 0x0100027e,
  NA_SE_EV_RIVER_STREAM_S = 0x0100027f,
  NA_SE_EV_RIVER_STREAM_F = 0x01000280,
  NA_SE_EV_KID_HORSE_LAND2 = 0x01000281,
  NA_SE_EV_KID_HORSE_SANDDUST = 0x01000282,
  NA_SE_EV_DUMMY_45 = 0x01000283,
  NA_SE_EV_LIGHTNING = 0x01000284,
  NA_SE_EV_BOMB_BOUND = 0x01000285,
  NA_SE_EV_WATERDROP = 0x01000286,
  NA_SE_EV_TORCH = 0x01000287,
  NA_SE_EV_MAGMA_LEVEL_M = 0x01000288,
  NA_SE_EV_FIRE_PILLAR = 0x01000289,
  NA_SE_EV_FIRE_PLATE = 0x0100028a,
  NA_SE_EV_BLOCK_BOUND = 0x0100028b,
  NA_SE_EV_METALDOOR_SLIDE = 0x0100028c,
  NA_SE_EV_METALDOOR_STOP = 0x0100028d,
  NA_SE_EV_BLOCK_SHAKE = 0x0100028e,
  NA_SE_EV_BOX_BREAK = 0x0100028f,
  NA_SE_EV_HAMMER_SWITCH = 0x01000290,
  NA_SE_EV_MAGMA_LEVEL_L = 0x01000291,
  NA_SE_EV_SPEAR_FENCE = 0x01000292,
  NA_SE_EV_WATERDROP_GRD = 0x01000293,
  NA_SE_EV_EXPLSION_LONG = 0x01000294,
  NA_SE_EV_WATER_WALL_BIG_SILENT = 0x01000295,
  NA_SE_EV_DESERT_WARPHOLE = 0x01000296,
  NA_SE_EV_FOUNTAIN = 0x01000297,
  NA_SE_EV_KID_HORSE_WALK = 0x01000298,
  NA_SE_EV_KID_HORSE_RUN = 0x01000299,
  NA_SE_EV_KID_HORSE_NEIGH = 0x0100029a,
  NA_SE_EV_KID_HORSE_GROAN = 0x0100029b,
  NA_SE_EV_S_STONE_FLASH = 0x0100029c,
  NA_SE_EV_LIGHT_GATHER = 0x0100029d,
  NA_SE_EV_TREE_CUT = 0x0100029e,
  NA_SE_EV_VOLCANO = 0x0100029f,
  NA_SE_EV_POSTMAN_WALK = 0x010002a0,
  NA_SE_EV_POSTMACHINE_HIT_OPEN = 0x010002a1,
  NA_SE_EV_POSTMACHINE_OPEN = 0x010002a2,
  NA_SE_EV_CHINETRAP_DOWN = 0x010002a3,
  NA_SE_EV_PLANT_BROKEN = 0x010002a4,
  NA_SE_EV_STONE_SWITCH_ON = 0x010002a5,
  NA_SE_EV_FLUTTER_FLAG = 0x010002a6,
  NA_SE_EV_TRAP_BOUND = 0x010002a7,
  NA_SE_EV_ROCK_BROKEN = 0x010002a8,
  NA_SE_EV_FANTOM_WARP_S2 = 0x010002a9,
  NA_SE_EV_FANTOM_WARP_L2 = 0x010002aa,
  NA_SE_EV_COFFIN_CAP_OPEN = 0x010002ab,
  NA_SE_EV_TRE_BOX_BOUND = 0x010002ac,
  NA_SE_EV_WIND_TRAP = 0x010002ad,
  NA_SE_EV_TRAP_OBJ_SLIDE = 0x010002ae,
  NA_SE_EV_METALDOOR_OPEN = 0x010002af,
  NA_SE_EV_METALDOOR_CLOSE = 0x010002b0,
  NA_SE_EV_BURN_OUT = 0x010002b1,
  NA_SE_EV_BLOCKSINK = 0x010002b2,
  NA_SE_EV_CROWD = 0x010002b3,
  NA_SE_EV_WATER_LEVEL_DOWN = 0x010002b4,
  NA_SE_EV_NAVY_VANISH = 0x010002b5,
  NA_SE_EV_STONE_SWITCH_OFF = 0x010002b6,
  NA_SE_EV_WEB_VIBRATION = 0x010002b7,
  NA_SE_EV_ICE_STAND_APPEAR = 0x010002b8,
  NA_SE_EV_ROLL_STAND = 0x010002b9,
  NA_SE_EV_SEESAW_WATER_BOUND = 0x010002ba,
  NA_SE_EV_SECOM_CONVEYOR = 0x010002bb,
  NA_SE_EV_WOODDOOR_OPEN = 0x010002bc,
  NA_SE_EV_METALGATE_OPEN = 0x010002bd,
  NA_SE_IT_SCOOP_UP_WATER = 0x010002be,
  NA_SE_EV_FISH_LEAP = 0x010002bf,
  NA_SE_EV_KAKASHI_SWING = 0x010002c0,
  NA_SE_EV_KAKASHI_ROLL = 0x010002c1,
  NA_SE_EV_BOTTLE_CAP_OPEN = 0x010002c2,
  NA_SE_EV_G_STONE_CRUSH = 0x010002c3,
  NA_SE_EV_KAKASH_LONGI_ROLL = 0x010002c4,
  NA_SE_EV_SUN_MARK_FLASH = 0x010002c5,
  NA_SE_EV_FALL_DOWN_DIRT = 0x010002c6,
  NA_SE_EV_SEESAW_BOUND = 0x010002c7,
  NA_SE_EV_FAIRY_ATTACK = 0x010002c8,
  NA_SE_EV_WOOD_HIT = 0x010002c9,
  NA_SE_EV_SCOOPUP_WATER = 0x010002ca,
  NA_SE_EV_DROP_FALL = 0x010002cb,
  NA_SE_EV_WOOD_GEAR = 0x010002cc,
  NA_SE_EV_TREE_SWING = 0x010002cd,
  NA_SE_EV_AUTO_DOOR_CLOSE = 0x010002ce,
  NA_SE_EV_NAVY_FLY_REBIRTH = 0x010002cf,
  NA_SE_EV_CHAINLIFT_STOP = 0x010002d0,
  NA_SE_EV_TRE_BOX_APPEAR = 0x010002d1,
  NA_SE_EV_CHAIN_KEY_UNLOCK = 0x010002d2,
  NA_SE_EV_SPINE_TRAP_MOVE = 0x010002d3,
  NA_SE_EV_HEALING = 0x010002d4,
  NA_SE_EV_GREAT_FAIRY_APPEAR = 0x010002d5,
  NA_SE_EV_GREAT_FAIRY_VANISH = 0x010002d6,
  NA_SE_EV_RED_EYE = 0x010002d7,
  NA_SE_EV_ROLL_STAND_2 = 0x010002d8,
  NA_SE_EV_WALL_SLIDE = 0x010002d9,
  NA_SE_EV_TRE_BOX_FLASH = 0x010002da,
  NA_SE_EV_WINDMILL_LEVEL = 0x010002db,
  NA_SE_EV_GOTO_HEAVEN = 0x010002dc,
  NA_SE_EV_POT_BROKEN = 0x010002dd,
  NA_SE_PL_PUT_DOWN_POT = 0x010002de,
  NA_SE_EV_DIVE_INTO_WATER = 0x010002df,
  NA_SE_EV_JUMP_OUT_WATER = 0x010002e0,
  NA_SE_EV_ICE_PIECE = 0x010002e1,
  NA_SE_EV_TRIFORCE = 0x010002e2,
  NA_SE_EV_AURORA = 0x010002e3,
  NA_SE_EV_CHIBI_FAIRY_SAVED = 0x010002e4,
  NA_SE_EV_BUYOSTAND_RISING = 0x010002e5,
  NA_SE_EV_BUYOSTAND_FALL = 0x010002e6,
  NA_SE_EV_MILK_POT_BROKEN = 0x010002e7,
  NA_SE_EV_CHAIR_ROLL = 0x010002e8,
  NA_SE_EV_STONEDOOR_STOP = 0x010002e9,
  NA_SE_EV_S_STONE_REVIVAL = 0x010002ea,
  NA_SE_EV_WATER_TANK = 0x010002eb,
  NA_SE_EV_HUMAN_BOUND = 0x010002ec,
  NA_SE_EV_TOILET_WATER = 0x010002ed,
  NA_SE_EV_EARTHQUAKE = 0x010002ee,
  NA_SE_EV_SWEEP = 0x010002ef,
  NA_SE_EV_GOD_LIGHTBALL_2 = 0x010002f0,
  NA_SE_EV_RUN_AROUND = 0x010002f1,
  NA_SE_EV_CONSENTRATION = 0x010002f2,
  NA_SE_EV_TIMETRIP_LIGHT = 0x010002f3,
  NA_SE_EV_DOOR_BELL = 0x010002f4,
  NA_SE_EV_BOUND_ON_MAGMA = 0x010002f5,
  NA_SE_EV_HONEYCOMB_FALL = 0x010002f6,
  NA_SE_EV_JUMP_CONC = 0x010002f7,
  NA_SE_EV_ICE_MELT = 0x010002f8,
  NA_SE_EV_FIRE_PILLAR_S = 0x010002f9,
  NA_SE_EV_BLOCK_RISING = 0x010002fa,
  NA_SE_EV_CHINCLE_SPELL_EFFECT = 0x010002fb,
  NA_SE_EV_LINK_WARP_IN = 0x010002fc,
  NA_SE_EV_LINK_WARP_OUT = 0x010002fd,
  NA_SE_EV_FIATY_HEAL = 0x010002fe,
  NA_SE_EV_CHAIN_KEY_UNLOCK_B = 0x010002ff,
  NA_SE_EV_WOODBOX_BREAK = 0x01000300,
  NA_SE_EV_PUT_DOWN_WOODBOX = 0x01000301,
  NA_SE_EV_LAND_DIRT = 0x01000302,
  NA_SE_EV_FLOOR_ROLLING = 0x01000303,
  NA_SE_EV_DOG_CRY_EVENING = 0x01000304,
  NA_SE_EV_JABJAB_HICCUP = 0x01000305,
  NA_SE_EV_STICK_SWING = 0x01000306,
  NA_SE_EV_FROG_JUMP = 0x01000307,
  NA_SE_EV_ICE_FREEZE = 0x01000308,
  NA_SE_EV_BURNING = 0x01000309,
  NA_SE_EV_WOODPLATE_BOUND = 0x0100030a,
  NA_SE_EV_MOON_CRY = 0x0100030b,
  NA_SE_EV_JABJAB_GROAN = 0x0100030c,
  NA_SE_EV_WAVE_S = 0x0100030d,
  NA_SE_EV_BIGBALL_ROLL = 0x0100030e,
  NA_SE_EV_ELEVATOR_MOVE3 = 0x0100030f,
  NA_SE_EV_DIAMOND_SWITCH = 0x01000310,
  NA_SE_EV_FLAME_OF_FIRE = 0x01000311,
  NA_SE_EV_FISH_GROW_UP = 0x01000312,
  NA_SE_EV_FLYING_AIR = 0x01000313,
  NA_SE_EV_PASS_AIR = 0x01000314,
  NA_SE_EV_COME_UP_DEKU_JR = 0x01000315,
  NA_SE_EV_SAND_STORM = 0x01000316,
  NA_SE_EV_BOILED_WATER_S = 0x01000317,
  NA_SE_EV_GRAVE_EXPLOSION = 0x01000318,
  NA_SE_EV_LURE_MOVE_W = 0x01000319,
  NA_SE_EV_POT_MOVE_START = 0x0100031a,
  NA_SE_EV_DIVE_INTO_WATER_L = 0x0100031b,
  NA_SE_EV_OUT_OF_WATER_L = 0x0100031c,
  NA_SE_EV_BOILED_WATER_L = 0x0100031d,
  NA_SE_EV_DIG_UP = 0x0100031e,
  NA_SE_EV_WOOD_BOUND = 0x0100031f,
  NA_SE_EV_WATER_BUBBLE = 0x01000320,
  NA_SE_EV_ICE_BROKEN = 0x01000321,
  NA_SE_EV_FROG_GROW_UP = 0x01000322,
  NA_SE_EV_WATER_CONVECTION = 0x01000323,
  NA_SE_EV_GROUND_GATE_OPEN = 0x01000324,
  NA_SE_EV_FACE_BREAKDOWN = 0x01000325,
  NA_SE_EV_TOILET_HAND_APPEAR = 0x01000326,
  NA_SE_EV_TOILET_HAND_VANISH = 0x01000327,
  NA_SE_EV_ROUND_TRAP_MOVE = 0x01000328,
  NA_SE_EV_HIT_SOUND = 0x01000329,
  NA_SE_EV_ICE_SWING = 0x0100032a,
  NA_SE_EV_DOWN_TO_GROUND = 0x0100032b,
  NA_SE_EV_BIG_TORTOISE_SWIM = 0x0100032c,
  NA_SE_EV_TORTOISE_WAKE_UP = 0x0100032d,
  NA_SE_EV_SMALL_DOG_BARK = 0x0100032e,
  NA_SE_EV_RUPY_FALL = 0x0100032f,
  NA_SE_EV_RAIN = 0x01000330,
  NA_SE_EV_IRON_DOOR_OPEN = 0x01000331,
  NA_SE_EV_IRON_DOOR_CLOSE = 0x01000332,
  NA_SE_EV_WHIRLPOOL = 0x01000333,
  NA_SE_EV_BIG_TORTOISE_ROLL = 0x01000334,
  NA_SE_EV_COW_CRY = 0x01000335,
  NA_SE_EV_METAL_BOX_BOUND = 0x01000336,
  NA_SE_EV_ELECTRIC_EXPLOSION = 0x01000337,
  NA_SE_EV_HEAVY_THROW = 0x01000338,
  NA_SE_EV_FROG_CRY_0 = 0x01000339,
  NA_SE_EV_FROG_CRY_1 = 0x0100033a,
  NA_SE_EV_COW_CRY_LV = 0x0100033b,
  NA_SE_EV_RONRON_DOOR_CLOSE = 0x0100033c,
  NA_SE_EV_BUTTERFRY_TO_FAIRY = 0x0100033d,
  NA_SE_EV_FIVE_COUNT_LUPY = 0x0100033e,
  NA_SE_EV_STONE_GROW_UP = 0x0100033f,
  NA_SE_EV_STONE_LAUNCH = 0x01000340,
  NA_SE_EV_STONE_ROLLING = 0x01000341,
  NA_SE_EV_TOGE_STICK_ROLLING = 0x01000342,
  NA_SE_EV_TOWER_ENERGY = 0x01000343,
  NA_SE_EV_MOON_LIGHT_PILLAR = 0x01000344,
  NA_SE_EV_MONKEY_WALK = 0x01000345,
  NA_SE_EV_KNIGHT_WALK = 0x01000346,
  NA_SE_EV_PILLAR_MOVE_STOP = 0x01000347,
  NA_SE_EV_WAVE = 0x01000348,
  NA_SE_EV_BIGBELL = 0x01000349,
  NA_SE_EV_NUTS_BROKEN = 0x0100034a,
  NA_SE_EV_SNOWBALL_BROKEN = 0x0100034b,
  NA_SE_EV_SMALLBALL_ROLL = 0x0100034c,
  NA_SE_EV_FLOWERPETAL_MOVE = 0x0100034d,
  NA_SE_EV_FLOWERPETAL_STOP = 0x0100034e,
  NA_SE_EV_FLOWER_ROLLING = 0x0100034f,
  NA_SE_EV_GLASSBROKEN_IMPACT = 0x01000350,
  NA_SE_EV_GLASSBROKEN_BOUND = 0x01000351,
  NA_SE_EV_BIGBALL_ROLL_SR = 0x01000352,
  NA_SE_EV_SMALL_SNOWBALL_BROKEN = 0x01000353,
  NA_SE_EV_STATUE_VANISH = 0x01000354,
  NA_SE_EV_BIGBALL_BOUND = 0x01000355,
  NA_SE_EV_MONKEY_VO_WALK = 0x01000356,
  NA_SE_EV_MONKEY_VO_JOY = 0x01000357,
  NA_SE_EV_WALK_WATER = 0x01000358,
  NA_SE_EV_PLATE_LIFT_LEVEL = 0x01000359,
  NA_SE_EV_BIGBALL_ROLL_2 = 0x0100035a,
  NA_SE_EV_BIGBALL_ROLL_SR_2 = 0x0100035b,
  NA_SE_EV_BIGBALL_ROLL_3 = 0x0100035c,
  NA_SE_EV_BIGBALL_ROLL_SR_3 = 0x0100035d,
  NA_SE_EV_BEAVER_SWIM_MOTOR = 0x0100035e,
  NA_SE_EV_BEAVER_SWIM_HAND = 0x0100035f,
  NA_SE_EV_SMALL_DOG_CRY = 0x01000360,
  NA_SE_EV_SMALL_DOG_GROAN = 0x01000361,
  NA_SE_EV_SMALL_DOG_ATK_BARK = 0x01000362,
  NA_SE_EV_ICE_PILLAR_RISING = 0x01000363,
  NA_SE_EV_ICE_PILLAR_FALL = 0x01000364,
  NA_SE_EV_GORON_CHEER = 0x01000365,
  NA_SE_EV_SMALL_DOG_ANG_BARK = 0x01000366,
  NA_SE_EV_COMICAL_JUMP = 0x01000367,
  NA_SE_EV_LIGHTNING_HARD = 0x01000368,
  NA_SE_EV_SMALL_DOG_WHINE = 0x01000369,
  NA_SE_EV_PANIC_IN_HOUSE = 0x0100036a,
  NA_SE_EV_CLOCK_TOWER_BELL = 0x0100036b,
  NA_SE_EV_CLOCK_TOWER_SECOND_HAND = 0x0100036c,
  NA_SE_EV_SIGNAL_BIGBELL = 0x0100036d,
  NA_SE_EV_DUMMY_280 = 0x0100036e,
  NA_SE_EV_BEAVER_VOICE_0 = 0x0100036f,
  NA_SE_EV_BEAVER_VOICE_1 = 0x01000370,
  NA_SE_EV_WATERWHEEL_LEVEL = 0x01000371,
  NA_SE_EV_WOOD_GATE_OPEN_N = 0x01000372,
  NA_SE_EV_INVISIBLE_MONKEY = 0x01000373,
  NA_SE_EV_CRUISER = 0x01000374,
  NA_SE_EV_SECRET_CHEER = 0x01000375,
  NA_SE_EV_BOTTLE_WATERING = 0x01000376,
  NA_SE_EV_MONKEY_VO_SADNESS = 0x01000377,
  NA_SE_EV_SNOWSTORM_HARD = 0x01000378,
  NA_SE_EV_UNSKILLFUL_OCARINA = 0x01000379,
  NA_SE_EV_BLACK_FAIRY_DASH = 0x0100037a,
  NA_SE_EV_FAIRY_SURPRISE = 0x0100037b,
  NA_SE_EV_MONDO_SURPRISE = 0x0100037c,
  NA_SE_EV_SPOT_LIGHT_OPEN = 0x0100037d,
  NA_SE_EV_HOUSE_BROKEN = 0x0100037e,
  NA_SE_EV_MOON_FALL = 0x0100037f,
  NA_SE_EV_OCARINA_BOUND_0 = 0x01000380,
  NA_SE_EV_OCARINA_BOUND_1 = 0x01000381,
  NA_SE_EV_BOMBERS_WALK = 0x01000382,
  NA_SE_EV_BOMBERS_LAND = 0x01000383,
  NA_SE_EV_BOMBERS_SHOT_BREATH = 0x01000384,
  NA_SE_EV_BOMBERS_SHOT_EXPLOSUIN = 0x01000385,
  NA_SE_EV_BOMBERS_JUMP = 0x01000386,
  NA_SE_EV_SOLDIER_WALK = 0x01000387,
  NA_SE_EV_ROCK_CUBE_RISING = 0x01000388,
  NA_SE_EV_ROCK_CUBE_FALL = 0x01000389,
  NA_SE_EV_BELL_SPIT = 0x0100038a,
  NA_SE_EV_BELL_SIGH = 0x0100038b,
  NA_SE_EV_BELL_BRAKE = 0x0100038c,
  NA_SE_EV_DOG_SWIM = 0x0100038d,
  NA_SE_EV_CHIBI_FAIRY_HEAL_ORG = 0x0100038e,
  NA_SE_EV_BOMBERS_CLIMB = 0x0100038f,
  NA_SE_EV_WOODPLATE_BROKEN = 0x01000390,
  NA_SE_EV_WATER_LEVEL_DOWN_FIX = 0x01000391,
  NA_SE_EV_HONEYCOMB_BROKEN = 0x01000392,
  NA_SE_EV_CLOCK_TOWER_UP = 0x01000393,
  NA_SE_EV_CLOCK_TOWER_STOP = 0x01000394,
  NA_SE_EV_CLOCK_TOWER_FALL = 0x01000395,
  NA_SE_EV_CLOCK_TOWER_BOUND_0 = 0x01000396,
  NA_SE_EV_CLOCK_TOWER_BOUND_1 = 0x01000397,
  NA_SE_EV_CLOCK_TOWER_BOUND_2 = 0x01000398,
  NA_SE_EV_STONEDOOR_OPEN_S = 0x01000399,
  NA_SE_EV_ICE_MELT_LEVEL = 0x0100039a,
  NA_SE_EV_CLOCK_TOWER_STAIR_MOVE = 0x0100039b,
  NA_SE_EV_DUMMY_326 = 0x0100039c,
  NA_SE_EV_OBJECT_STICK = 0x0100039d,
  NA_SE_EV_CHICK_TO_CHICKEN = 0x0100039e,
  NA_SE_EV_MUJURA_BALLOON_BROKEN = 0x0100039f,
  NA_SE_EV_BALLOON_SWELL = 0x010003a0,
  NA_SE_EV_SEAHORSE_OUT_BOTTLE = 0x010003a1,
  NA_SE_EV_KYOJIN_VOICE_SUCCESS = 0x010003a2,
  NA_SE_EV_KYOJIN_VOICE_FAIL = 0x010003a3,
  NA_SE_EV_KYOJIN_WALK = 0x010003a4,
  NA_SE_EV_MOON_FALL_LAST = 0x010003a5,
  NA_SE_EV_EARTHQUAKE_LAST = 0x010003a6,
  NA_SE_EV_SEAHORSE_SWIM = 0x010003a7,
  NA_SE_EV_OPEN_AMBRELLA = 0x010003a8,
  NA_SE_EV_BUTLER_FRY = 0x010003a9,
  NA_SE_EV_PIRATE_SHIP = 0x010003aa,
  NA_SE_EV_DRAIN = 0x010003ab,
  NA_SE_EV_DORA_L = 0x010003ac,
  NA_SE_EV_LOG_BOUND = 0x010003ad,
  NA_SE_EV_CART_WHEEL = 0x010003ae,
  NA_SE_EV_EARTHQUAKE_LAST2 = 0x010003af,
  NA_SE_EV_DORA_S = 0x010003b0,
  NA_SE_EV_ROCK_FALL = 0x010003b1,
  NA_SE_EV_FREEZE_S = 0x010003b2,
  NA_SE_EV_WOOD_BOUND_S = 0x010003b3,
  NA_SE_EV_CLOSE_AMBRELLA = 0x010003b4,
  NA_SE_EV_OBJECT_SLIDE = 0x010003b5,
  NA_SE_EV_ROLL_AND_FALL = 0x010003b6,
  NA_SE_EV_GORON_BOUND_0 = 0x010003b7,
  NA_SE_EV_GORON_BOUND_1 = 0x010003b8,
  NA_SE_EV_MONKEY_VO_DAMAGE = 0x010003b9,
  NA_SE_EV_FORT_RISING = 0x010003ba,
  NA_SE_EV_MONKEY_VO_REWARD = 0x010003bb,
  NA_SE_EV_WATER_PURIFICATION = 0x010003bc,
  NA_SE_EV_OWL_WARP_SWITCH_ON = 0x010003bd,
  NA_SE_EV_BIG_WATER_WHEEL_RR = 0x010003be,
  NA_SE_EV_BIG_WATER_WHEEL_LR = 0x010003bf,
  NA_SE_EV_SMALL_WATER_WHEEL = 0x010003c0,
  NA_SE_EV_COCK_SWITCH_ROLL = 0x010003c1,
  NA_SE_EV_COCK_SWITCH_STOP = 0x010003c2,
  NA_SE_EV_PIPE_STREAM_START = 0x010003c3,
  NA_SE_EV_WATER_PILLAR = 0x010003c4,
  NA_SE_EV_SEESAW_INCLINE = 0x010003c5,
  NA_SE_EV_ZORA_WALK = 0x010003c6,
  NA_SE_EV_PIRATE_WALK = 0x010003c7,
  NA_SE_EV_PILLAR_UP_FAST = 0x010003c8,
  NA_SE_EV_DUMMY_WATER_WHEEL_RR = 0x010003c9,
  NA_SE_EV_DUMMY_WATER_WHEEL_LR = 0x010003ca,
  NA_SE_EV_MUJURA_FOLLOWERS_FLY = 0x010003cb,
  NA_SE_EV_MAKE_TURRET = 0x010003cc,
  NA_SE_EV_CHANDELIER_ROLL = 0x010003cd,
  NA_SE_EV_CHANDELIER_BROKEN = 0x010003ce,
  NA_SE_EV_SINK_WOOD_FLOOR = 0x010003cf,
  NA_SE_EV_REBOUND_WOOD_FLOOR = 0x010003d0,
  NA_SE_EV_UFO_APPEAR = 0x010003d1,
  NA_SE_EV_UFO_DASH = 0x010003d2,
  NA_SE_EV_TORNADE = 0x010003d3,
  NA_SE_EV_MILK_POT_DAMAGE = 0x010003d4,
  NA_SE_EV_DUMMY_383 = 0x010003d5,
  NA_SE_EV_KYOJIN_SIGN = 0x010003d6,
  NA_SE_EV_KYOJIN_GRATITUDE0 = 0x010003d7,
  NA_SE_EV_KYOJIN_GRATITUDE1 = 0x010003d8,
  NA_SE_EV_KYOJIN_GRATITUDE2 = 0x010003d9,
  NA_SE_EV_IKANA_DOOR_OPEN = 0x010003da,
  NA_SE_EV_IKANA_DOOR_CLOSE = 0x010003db,
  NA_SE_EV_MOONSTONE_FALL = 0x010003dc,
  NA_SE_EV_COMING_FIRE = 0x010003dd,
  NA_SE_EV_FAIRY_GROUP_FRY = 0x010003de,
  NA_SE_EV_FAIRY_GROUP_HEAL = 0x010003df,
  NA_SE_EV_WOOD_DOOR_OPEN_SPEEDY = 0x010003e0,
  NA_SE_EV_PAMERA_WALK = 0x010003e1,
  NA_SE_EV_G_STONE_CHANGE_COLOR = 0x010003e2,
  NA_SE_EV_CURTAIN_DOWN = 0x010003e3,
  NA_SE_EV_GORON_HAND_HIT = 0x010003e4,
  NA_SE_EV_SMALL_WOODPLATE_BOUND_0 = 0x010003e5,
  NA_SE_EV_GET_UP_ON_BED = 0x010003e6,
  NA_SE_EV_LIE_DOWN_ON_BED = 0x010003e7,
  NA_SE_EV_BANK_MAN_HAND_HIT = 0x010003e8,
  NA_SE_EV_HANKO = 0x010003e9,
  NA_SE_EV_CHICK_SONG = 0x010003ea,
  NA_SE_EV_LAND_SAND = 0x010003eb,
  NA_SE_EV_JUMP_SAND = 0x010003ec,
  NA_SE_EV_SECRET_LADDER_APPEAR = 0x010003ed,
  NA_SE_EV_CLAPPING_2P = 0x010003ee,
  NA_SE_EV_DIVE_INTO_WEED = 0x010003ef,
  NA_SE_EV_FAIRY_SHIVER = 0x010003f0,
  NA_SE_EV_MASK_RISING = 0x010003f1,
  NA_SE_EV_MOON_EYE_FLASH = 0x010003f2,
  NA_SE_EV_SLIP_MOON = 0x010003f3,
  NA_SE_EV_FALL_POWER = 0x010003f4,
  NA_SE_EV_BELL_DASH_NORMAL = 0x010003f5,
  NA_SE_EV_IKANA_BLOCK_MOVE_X = 0x010003f6,
  NA_SE_EV_IKANA_BLOCK_MOVE_Z = 0x010003f7,
  NA_SE_EV_IKANA_BLOCK_MOVE_Y = 0x010003f8,
  NA_SE_EV_IKANA_BLOCK_STOP_C = 0x010003f9,
  NA_SE_EV_IKANA_BLOCK_STOP_F = 0x010003fa,
  NA_SE_EV_BELL_ANGER = 0x010003fb,
  NA_SE_EV_IKANA_BLOCK_SWITCH = 0x010003fc,
  NA_SE_EV_BAT_FLY = 0x010003fd,
  NA_SE_EV_UFO_LIGHT_BEAM = 0x010003fe,
  NA_SE_EV_DOOR_UNLOCK = 0x010003ff,
  NA_SE_EV_WOOD_WATER_WHEEL = 0x01000400,
  NA_SE_EV_CONVEYOR_SHUTTER_OPEN = 0x01000401,
  NA_SE_EV_CONVEYOR_SHUTTER_CLOSE = 0x01000402,
  NA_SE_EV_ROOM_CARTAIN = 0x01000403,
  NA_SE_EV_ZORA_KIDS_BORN = 0x01000404,
  NA_SE_EV_ZORA_KIDS_SWIM_0 = 0x01000405,
  NA_SE_EV_ZORA_KIDS_SWIM_1 = 0x01000406,
  NA_SE_EV_MOON_EXPLOSION = 0x01000407,
  NA_SE_EV_RAINBOW = 0x01000408,
  NA_SE_EV_OMENYA_WALK = 0x01000409,
  NA_SE_EV_KYOJIN_GROAN = 0x0100040a,
  NA_SE_EV_UFO_FLY = 0x0100040b,
  NA_SE_EV_GRASS_WALL_BROKEN = 0x0100040c,
  NA_SE_EV_WARP_HOLE_ENERGY = 0x0100040d,
  NA_SE_EV_BOSS_WARP_HOLE = 0x0100040e,
  NA_SE_EV_FIREWORKS_LAUNCH = 0x0100040f,
  NA_SE_EV_IKANA_SOUL_LV = 0x01000410,
  NA_SE_EV_IKANA_PURIFICATION = 0x01000411,
  NA_SE_EV_ZORA_KIDS_SWIM_2 = 0x01000412,
  NA_SE_EV_DARUMA_VANISH = 0x01000413,
  NA_SE_EV_IKANA_SOUL_TRANSFORM = 0x01000414,
  NA_SE_EV_ROMANY_BOW_FLICK = 0x01000415,
  NA_SE_EV_WHITE_FAIRY_SHOT_DASH = 0x01000416,
  NA_SE_EV_BLACK_FAIRY_SHOT_DASH = 0x01000417,
  NA_SE_EV_SWORD_FORGE = 0x01000418,
  NA_SE_EV_STONEDOOR_CLOSE_S = 0x01000419,
  NA_SE_EV_BOTTLE_CAP_CLOSE = 0x0100041a,
  NA_SE_EV_PAMET_ROCK_CRASH = 0x0100041b,
  NA_SE_EV_GUILLOTINE_UP = 0x0100041c,
  NA_SE_EV_ROCK_BROKEN2 = 0x0100041d,
  NA_SE_EV_OBJECT_STICK2 = 0x0100041e,
  NA_SE_EV_WOODBOX_BOUND2 = 0x0100041f,
  NA_SE_EV_DEMO_KID_ATOZUSARI = 0x01000420,
  NA_SE_EV_UNDER_WATER = 0x01000421,
  NA_SE_EV_FREEZE2 = 0x01000422,
  NA_SE_EV_DEMO_KID_SAGURU = 0x01000423,
  NA_SE_EV_WATER_WALL3 = 0x01000424,
  NA_SE_EV_BOMBERS_TAORE = 0x01000425,
  NA_SE_EV_RIVER_STREAM_TOWER = 0x01000426,
  NA_SE_EV_MONKEY_ROPE = 0x01000427,
  NA_SE_EV_MONKEY_FOOT_PAN = 0x01000428,
  NA_SE_EV_BODYFALL_SAND1 = 0x01000429,
  NA_SE_EV_SCOOP_SAND1 = 0x0100042a,
  NA_SE_EV_CHICKEN_CRY_M_0600 = 0x0100042b,
  NA_SE_EV_WATER_WALL_BIG2 = 0x0100042c,
  NA_SE_EV_WATER_VOLTEX = 0x0100042d,
  NA_SE_EV_WATER_WALL_IKANA = 0x0100042e,
  NA_SE_EV_DOOR_OPEN_GATYA = 0x0100042f,
  NA_SE_EV_CLAP_1SHOT = 0x01000430,
  NA_SE_EV_TRR_APPEAR = 0x01000431,
  NA_SE_EV_ICE_MELT_SHORT = 0x01000432,
  NA_SE_EV_DEMO37_CLOTH1 = 0x01000433,
  NA_SE_EV_DEMO37_CLOTH2 = 0x01000434,
  NA_SE_EV_DEMO37_CLOTH3 = 0x01000435,
  NA_SE_EV_DEMO37_CLOTH4 = 0x01000436,
  NA_SE_EV_WHITE_FAIRY_DASH_SHORT = 0x01000437,
  NA_SE_EV_WHITE_FAIRY_DASH_SHORT2 = 0x01000438,
  NA_SE_EV_DEMO27_BODYFALL = 0x01000439,
  NA_SE_EV_DEMO30_LINK_RIDE = 0x0100043a,
  NA_SE_EV_DEMO16_WHITEOUT = 0x0100043b,
  NA_SE_EV_DEMO16_MIKAU_FADE = 0x0100043c,
  NA_SE_EV_DEMO27_WHITEOUT = 0x0100043d,
  NA_SE_SC_ZHOP_WAVE = 0x0100043e,
  NA_SE_EV_DEMO02_ME1 = 0x0100043f,
  NA_SE_EV_DEMO02_WHOOSH = 0x01000440,
  NA_SE_EV_DEMO02_ME2 = 0x01000441,
  NA_SE_EV_DEMO25_ME1 = 0x01000442,
  NA_SE_EV_DEMO25_HEAD_HIT = 0x01000443,
  NA_SE_EV_TENTI_GYAKUTEN = 0x01000444,
  NA_SE_EV_IKANA_JYOUKA = 0x01000445,
  NA_SE_EV_IKANA_SHARP = 0x01000446,
  NA_SE_EV_IKANA_JYOUKA_FLASH = 0x01000447,
  NA_SE_EV_IKACASTLE_SLIDE1 = 0x01000448,
  NA_SE_EV_OKUJYOU_WIND = 0x01000449,
  NA_SE_EV_CAM_WHOOSH = 0x0100044a,
  NA_SE_EV_DESK_HIT = 0x0100044b,
  NA_SE_EV_DEMO08_FIRE = 0x0100044c,
  NA_SE_EV_DEMO08_ME1 = 0x0100044d,
  NA_SE_EV_OCARINA_FALL = 0x0100044e,
  NA_SE_EV_LINK_WARP_LV = 0x0100044f,
  NA_SE_EV_DEMO_ATATAME = 0x01000450,
  NA_SE_EV_DEMO12_KIRAKIRA = 0x01000451,
  NA_SE_EV_DEMO32_FIRE_SIPPAI = 0x01000452,
  NA_SE_EV_KYOJIN_DOWN = 0x01000453,
  NA_SE_EV_FACE_BREAKDOWN_OFF = 0x01000454,
  NA_SE_EV_DEMO_MOON_IN = 0x01000455,
  NA_SE_EV_1ST_MODORU_ME = 0x01000456,
  NA_SE_EV_WATER_WALL_BIG_SILENT2 = 0x01000457,
  NA_SE_EV_MOONFALL_WIND1 = 0x01000458,
  NA_SE_EV_MOONFALL_WIND2 = 0x01000459,
  NA_SE_EV_MOONFALL_WIND3 = 0x0100045a,
  NA_SE_EV_MOONFALL_WIND4 = 0x0100045b,
  NA_SE_EV_TOKEITOU_EXPLO1 = 0x0100045c,
  NA_SE_EV_TOKEITOU_EXPLO2 = 0x0100045d,
  NA_SE_EV_MOONFALL_WIND5 = 0x0100045e,
  NA_SE_EV_MOONFALL_WIND6 = 0x0100045f,
  NA_SE_EV_MOONFALL_WIND7 = 0x01000460,
  NA_SE_EV_GIANT_DOWN = 0x01000461,
  NA_SE_SC_DEMO_SPLASH1 = 0x01000462,
  NA_SE_EV_TURI_SPLASH = 0x01000463,
  NA_SE_EV_DUMMY_525 = 0x01000464,
  NA_SE_EV_WAVE_S_TURIBORI = 0x01000465,
  NA_SE_EN_LAST_DAMAGE_3DOFF = 0x01000466,
  NA_SE_EV_DUMMY_529 = 0x01000467,
  NA_SE_EN_DODO_J_WALK = 0x01000468,
  NA_SE_EN_DODO_J_CRY = 0x01000469,
  NA_SE_EN_DODO_J_FIRE = 0x0100046a,
  NA_SE_EN_DODO_J_DAMAGE = 0x0100046b,
  NA_SE_EN_DODO_J_DEAD = 0x0100046c,
  NA_SE_EN_BAKUO_ROLL = 0x0100046d,
  NA_SE_EN_MIZUBABA2_VOICE = 0x0100046e,
  NA_SE_EN_MIZUBABA2_DAMAGE = 0x0100046f,
  NA_SE_EN_MIBOSS_FALL_OLD_OLD = 0x01000470,
  NA_SE_EN_MIBOSS_DAMAGE_OLD = 0x01000471,
  NA_SE_EN_MIBOSS_DASH_OLD = 0x01000472,
  NA_SE_EN_MIBOSS_DEAD_OLD = 0x01000473,
  NA_SE_EN_MIBOSS_GND1_OLD = 0x01000474,
  NA_SE_EN_GOMA_DOWN = 0x01000475,
  NA_SE_EN_MIBOSS_GND2_OLD = 0x01000476,
  NA_SE_EN_MIBOSS_UNARI_OLD = 0x01000477,
  NA_SE_EN_MIBOSS_RHYTHM_OLD = 0x01000478,
  NA_SE_EN_MIBOSS_SWORD_OLD = 0x01000479,
  NA_SE_EN_ANSATSUSYA_ENTRY = 0x0100047a,
  NA_SE_EN_MIBOSS_JUMP1 = 0x0100047b,
  NA_SE_EN_MIBOSS_JUMP2 = 0x0100047c,
  NA_SE_EN_MIBOSS_VOICE1_OLD = 0x0100047d,
  NA_SE_EN_MIBOSS_VOICE2_OLD = 0x0100047e,
  NA_SE_EN_MIBOSS_VOICE3_OLD = 0x0100047f,
  NA_SE_EN_INBOSS_SAND_OLD = 0x01000480,
  NA_SE_EN_INBOSS_ROAR_OLD = 0x01000481,
  NA_SE_EN_INBOSS_DAMAGE_OLD = 0x01000482,
  NA_SE_EN_COMMON_WEAKENED = 0x01000483,
  NA_SE_EN_MIBOSS_FAINT_OLD = 0x01000484,
  NA_SE_EN_MIBOSS_ROLLING_OLD = 0x01000485,
  NA_SE_EN_MIZUBABA1_DAMAGE = 0x01000486,
  NA_SE_EN_MIZUBABA_DEAD = 0x01000487,
  NA_SE_EN_DODO_M_CRY = 0x01000488,
  NA_SE_EN_DODO_M_DEAD = 0x01000489,
  NA_SE_EN_DODO_M_MOVE = 0x0100048a,
  NA_SE_EN_DODO_M_DOWN = 0x0100048b,
  NA_SE_EN_DODO_M_UP = 0x0100048c,
  NA_SE_EN_MIZUBABA_TRANSFORM = 0x0100048d,
  NA_SE_EN_DODO_M_EAT = 0x0100048e,
  NA_SE_EN_MIZUBABA2_WALK = 0x0100048f,
  NA_SE_EN_BOMCHU_WALK = 0x01000490,
  NA_SE_EN_RIZA_CRY = 0x01000491,
  NA_SE_EN_RIZA_ATTACK = 0x01000492,
  NA_SE_EN_RIZA_DAMAGE = 0x01000493,
  NA_SE_EN_RIZA_WARAU = 0x01000494,
  NA_SE_EN_RIZA_DEAD = 0x01000495,
  NA_SE_EN_RIZA_WALK = 0x01000496,
  NA_SE_EN_RIZA_JUMP = 0x01000497,
  NA_SE_EN_STALKID_WALK = 0x01000498,
  NA_SE_EN_STALKID_ATTACK = 0x01000499,
  NA_SE_EN_STALKID_DAMAGE = 0x0100049a,
  NA_SE_EN_STALKID_DEAD = 0x0100049b,
  NA_SE_EN_FLOORMASTER_SLIDING = 0x0100049c,
  NA_SE_EN_TEKU_WALK_WATER = 0x0100049d,
  NA_SE_EN_LIGHT_ARROW_HIT = 0x0100049e,
  NA_SE_EN_MIZUBABA2_ATTACK = 0x0100049f,
  NA_SE_EN_STAL_WARAU = 0x010004a0,
  NA_SE_EN_STAL_SAKEBI = 0x010004a1,
  NA_SE_EN_STAL_DAMAGE = 0x010004a2,
  NA_SE_EN_STAL_DEAD = 0x010004a3,
  NA_SE_EN_WOLFOS_APPEAR = 0x010004a4,
  NA_SE_EN_STAL_WALK = 0x010004a5,
  NA_SE_EN_WOLFOS_CRY = 0x010004a6,
  NA_SE_EN_WOLFOS_ATTACK = 0x010004a7,
  NA_SE_EN_FFLY_ATTACK = 0x010004a8,
  NA_SE_EN_FFLY_FLY = 0x010004a9,
  NA_SE_EN_FFLY_DEAD = 0x010004aa,
  NA_SE_EN_WOLFOS_DAMAGE = 0x010004ab,
  NA_SE_EN_AMOS_WALK = 0x010004ac,
  NA_SE_EN_AMOS_WAVE = 0x010004ad,
  NA_SE_EN_EYEGOLE_DEAD = 0x010004ae,
  NA_SE_EN_EYEGOLE_DAMAGE = 0x010004af,
  NA_SE_EN_AMOS_VOICE = 0x010004b0,
  NA_SE_EN_KUSAMUSHI_VIBE = 0x010004b1,
  NA_SE_EN_BEE_FLY = 0x010004b2,
  NA_SE_EN_WOLFOS_DEAD = 0x010004b3,
  NA_SE_EN_COMMON_E_BALL = 0x010004b4,
  NA_SE_EN_COMMON_THUNDER_THR = 0x010004b5,
  NA_SE_EN_COMMON_E_BALL_HIT = 0x010004b6,
  NA_SE_EN_COMMON_ELEC_ARK = 0x010004b7,
  NA_SE_EN_SUISEN_EAT = 0x010004b8,
  NA_SE_EN_SUISEN_DEAD = 0x010004b9,
  NA_SE_EN_COMMON_E_BALL_THR = 0x010004ba,
  NA_SE_EN_UTSUBO_APPEAR = 0x010004bb,
  NA_SE_EN_BOMCHU_VOICE = 0x010004bc,
  NA_SE_EN_BOMCHU_AIM = 0x010004bd,
  NA_SE_EN_BOMCHU_RUN = 0x010004be,
  NA_SE_EN_UTSUBO_BACK = 0x010004bf,
  NA_SE_EN_DODO_J_BREATH = 0x010004c0,
  NA_SE_EN_DODO_J_TAIL = 0x010004c1,
  NA_SE_EN_WOLFOS_WALK = 0x010004c2,
  NA_SE_EN_DODO_J_EAT = 0x010004c3,
  NA_SE_EN_DEKU_MOUTH = 0x010004c4,
  NA_SE_EN_DEKU_ATTACK = 0x010004c5,
  NA_SE_EN_DEKU_DAMAGE = 0x010004c6,
  NA_SE_EN_DEKU_DEAD = 0x010004c7,
  NA_SE_EN_MIZUBABA1_MOUTH = 0x010004c8,
  NA_SE_EN_MIZUBABA1_ATTACK = 0x010004c9,
  NA_SE_EN_DEKU_JR_DEAD = 0x010004ca,
  NA_SE_EN_DEKU_SCRAPE = 0x010004cb,
  NA_SE_EN_TAIL_FLY = 0x010004cc,
  NA_SE_EN_TAIL_CRY = 0x010004cd,
  NA_SE_EN_TAIL_DEAD = 0x010004ce,
  NA_SE_EN_GOLON_STAND_IMT = 0x010004cf,
  NA_SE_EN_STALTU_DOWN = 0x010004d0,
  NA_SE_EN_STALTU_UP = 0x010004d1,
  NA_SE_EN_STALTU_LAUGH = 0x010004d2,
  NA_SE_EN_STALTU_DAMAGE = 0x010004d3,
  NA_SE_EN_TEKU_JUMP = 0x010004d4,
  NA_SE_EN_TEKU_DAMAGE = 0x010004d5,
  NA_SE_EN_TEKU_DEAD = 0x010004d6,
  NA_SE_EN_TEKU_WALK = 0x010004d7,
  NA_SE_EN_PO_KANTERA = 0x010004d8,
  NA_SE_EN_PO_FLY = 0x010004d9,
  NA_SE_EN_PO_AWAY = 0x010004da,
  NA_SE_EN_STALKIDS_APPEAR = 0x010004db,
  NA_SE_EN_PO_DISAPPEAR = 0x010004dc,
  NA_SE_EN_PO_DAMAGE = 0x010004dd,
  NA_SE_EN_PO_DEAD = 0x010004de,
  NA_SE_EN_WIZ_DISAPPEAR = 0x010004df,
  NA_SE_EN_EXTINCT = 0x010004e0,
  NA_SE_EN_GOLON_LAND_BIG = 0x010004e1,
  NA_SE_EN_GERUDOFT_DOWN = 0x010004e2,
  NA_SE_EN_EYEGOLE_ATTACK = 0x010004e3,
  NA_SE_EN_NUTS_UP = 0x010004e4,
  NA_SE_EN_NUTS_DOWN = 0x010004e5,
  NA_SE_EN_NUTS_THROW = 0x010004e6,
  NA_SE_EN_NUTS_WALK = 0x010004e7,
  NA_SE_EN_NUTS_DAMAGE = 0x010004e8,
  NA_SE_EN_NUTS_DEAD = 0x010004e9,
  NA_SE_EN_NUT_FAINT = 0x010004ea,
  NA_SE_EN_PO_BIG_GET = 0x010004eb,
  NA_SE_EN_STALTU_ROLL = 0x010004ec,
  NA_SE_EN_STALTU_DEAD = 0x010004ed,
  NA_SE_EN_PO_SISTER_DEAD = 0x010004ee,
  NA_SE_EN_BARI_SPLIT = 0x010004ef,
  NA_SE_EN_LAST1_GROW_HEAD = 0x010004f0,
  NA_SE_EN_NUTS_VOICE = 0x010004f1,
  NA_SE_EN_TEKU_LAND_WATER = 0x010004f2,
  NA_SE_EN_LAST_DAMAGE = 0x010004f3,
  NA_SE_EN_STALWALL_ROLL = 0x010004f4,
  NA_SE_EN_STALWALL_DASH = 0x010004f5,
  NA_SE_EN_TEKU_JUMP_WATER = 0x010004f6,
  NA_SE_EN_TEKU_LAND_WATER2 = 0x010004f7,
  NA_SE_EN_FALL_AIM = 0x010004f8,
  NA_SE_EN_FALL_UP = 0x010004f9,
  NA_SE_EN_FALL_CATCH = 0x010004fa,
  NA_SE_EN_FALL_LAND = 0x010004fb,
  NA_SE_EN_FALL_WALK = 0x010004fc,
  NA_SE_EN_FALL_DAMAGE = 0x010004fd,
  NA_SE_EN_DAIOCTA_REVERSE = 0x010004fe,
  NA_SE_EN_KAICHO_FLUTTER = 0x010004ff,
  NA_SE_EN_BIRI_FLY = 0x01000500,
  NA_SE_EN_BIRI_JUMP = 0x01000501,
  NA_SE_EN_BIRI_SPARK = 0x01000502,
  NA_SE_EN_BIRI_DEAD = 0x01000503,
  NA_SE_EN_COMMON_WATER_DEEP = 0x01000504,
  NA_SE_EN_BARI_ROLL = 0x01000505,
  NA_SE_EN_COMMON_FREEZE = 0x01000506,
  NA_SE_EN_BARI_DEAD = 0x01000507,
  NA_SE_EN_BATTA_FLY = 0x01000508,
  NA_SE_EN_BATTA_ATTACK = 0x01000509,
  NA_SE_EN_BATTA_DAMAGE = 0x0100050a,
  NA_SE_EN_BATTA_DEAD = 0x0100050b,
  NA_SE_EN_WIZ_UNARI = 0x0100050c,
  NA_SE_EN_WIZ_RUN = 0x0100050d,
  NA_SE_EN_WIZ_VOICE = 0x0100050e,
  NA_SE_EN_WIZ_LAUGH = 0x0100050f,
  NA_SE_EN_WIZ_ATTACK = 0x01000510,
  NA_SE_EN_WIZ_DAMAGE = 0x01000511,
  NA_SE_EN_WIZ_DEAD = 0x01000512,
  NA_SE_EN_WIZ_EXP = 0x01000513,
  NA_SE_EN_DAIOCTA_DEAD = 0x01000514,
  NA_SE_EN_DAIOCTA_DEAD2 = 0x01000515,
  NA_SE_EN_FANTOM_DAMAGE = 0x01000516,
  NA_SE_EN_DAIOCTA_DAMAGE = 0x01000517,
  NA_SE_EN_WIZ_LAUGH2 = 0x01000518,
  NA_SE_EN_GOLON_SIT_IMT = 0x01000519,
  NA_SE_EN_FANTOM_VOICE = 0x0100051a,
  NA_SE_EN_KAICHO_DAMAGE = 0x0100051b,
  NA_SE_EN_GOLON_COLD = 0x0100051c,
  NA_SE_EN_GOLON_JUMP = 0x0100051d,
  NA_SE_EN_KAICHO_CRY = 0x0100051e,
  NA_SE_EN_KAICHO_ATTACK = 0x0100051f,
  NA_SE_EN_GOLON_WALK = 0x01000520,
  NA_SE_EN_SLIME_JUMP = 0x01000521,
  NA_SE_EN_SLIME_DAMAGE = 0x01000522,
  NA_SE_EN_SLIME_BREAK = 0x01000523,
  NA_SE_EN_KUROSUKE_MOVE = 0x01000524,
  NA_SE_EN_KUROSUKE_ATTACK = 0x01000525,
  NA_SE_EN_SLIME_DEAD = 0x01000526,
  NA_SE_EN_SLIME_DEFENCE = 0x01000527,
  NA_SE_EN_OCTAROCK_ROCK = 0x01000528,
  NA_SE_EN_COMMON_WATER_SLW = 0x01000529,
  NA_SE_EN_OCTAROCK_JUMP = 0x0100052a,
  NA_SE_EN_DAIOCTA_LAND = 0x0100052b,
  NA_SE_EN_DAIOCTA_SINK = 0x0100052c,
  NA_SE_EN_COMMON_WATER_MID = 0x0100052d,
  NA_SE_EN_OCTAROCK_DEAD1 = 0x0100052e,
  NA_SE_EN_OCTAROCK_DEAD2 = 0x0100052f,
  NA_SE_EN_BUBLE_WING = 0x01000530,
  NA_SE_EN_BUBLE_MOUTH = 0x01000531,
  NA_SE_EN_BUBLE_LAUGH = 0x01000532,
  NA_SE_EN_BUBLE_BITE = 0x01000533,
  NA_SE_EN_BUBLE_UP = 0x01000534,
  NA_SE_EN_BUBLE_DOWN = 0x01000535,
  NA_SE_EN_BUBLE_DEAD = 0x01000536,
  NA_SE_EN_BUBLEFALL_FIRE = 0x01000537,
  NA_SE_EN_UTSUBO_DEAD = 0x01000538,
  NA_SE_EN_UTSUBO_DAMAGE = 0x01000539,
  NA_SE_EN_FROG_REAL = 0x0100053a,
  NA_SE_EN_FROG_DAMAGE = 0x0100053b,
  NA_SE_EN_B_SLIME_EAT = 0x0100053c,
  NA_SE_EN_B_SLIME_LAUGH = 0x0100053d,
  NA_SE_EN_FROG_DEAD = 0x0100053e,
  NA_SE_EN_UTSUBO_BITE = 0x0100053f,
  NA_SE_EN_B_SLIME_REVERSE = 0x01000540,
  NA_SE_EN_SLIME_JUMP1 = 0x01000541,
  NA_SE_EN_SLIME_JUMP2 = 0x01000542,
  NA_SE_EN_B_SLIME_BREAK = 0x01000543,
  NA_SE_EN_BARI_DAMAGE = 0x01000544,
  NA_SE_EN_HIPLOOP_LAND = 0x01000545,
  NA_SE_EN_MOFER_CORE_MOVE_WT = 0x01000546,
  NA_SE_EN_MOFER_CORE_SMJUMP = 0x01000547,
  NA_SE_EN_MONBLIN_GNDWAVE = 0x01000548,
  NA_SE_EN_MONBLIN_HAM_DOWN = 0x01000549,
  NA_SE_EN_MONBLIN_HAM_UP = 0x0100054a,
  NA_SE_EN_BUBLE_DAMAGE = 0x0100054b,
  NA_SE_EN_REDEAD_CRY = 0x0100054c,
  NA_SE_EN_REDEAD_AIM = 0x0100054d,
  NA_SE_EN_REDEAD_DAMAGE = 0x0100054e,
  NA_SE_EN_REDEAD_DEAD = 0x0100054f,
  NA_SE_EN_REDEAD_ATTACK = 0x01000550,
  NA_SE_EN_GOLON_KID_SOB = 0x01000551,
  NA_SE_EN_GOLON_KID_CRY = 0x01000552,
  NA_SE_EN_KAICHO_DEAD = 0x01000553,
  NA_SE_EN_PO_LAUGH = 0x01000554,
  NA_SE_EN_PO_CRY = 0x01000555,
  NA_SE_EN_PO_ROLL = 0x01000556,
  NA_SE_EN_PO_LAUGH2 = 0x01000557,
  NA_SE_EN_GOLON_ROLLING = 0x01000558,
  NA_SE_EN_GOLON_READY = 0x01000559,
  NA_SE_EN_GOLON_DASH = 0x0100055a,
  NA_SE_EN_PAMET_VOICE = 0x0100055b,
  NA_SE_EN_PAMET_ROLL = 0x0100055c,
  NA_SE_EN_PAMET_WALK = 0x0100055d,
  NA_SE_EN_PAMET_ROAR = 0x0100055e,
  NA_SE_EN_PAMET_WAKEUP = 0x0100055f,
  NA_SE_EN_PAMET_REVERSE = 0x01000560,
  NA_SE_EN_PAMET_DAMAGE = 0x01000561,
  NA_SE_EN_PAMET_DEAD = 0x01000562,
  NA_SE_EN_BAKUO_VOICE = 0x01000563,
  NA_SE_EN_GOLON_WAKE_UP = 0x01000564,
  NA_SE_EN_GOLON_SIT_DOWN = 0x01000565,
  NA_SE_EN_DAIGOLON_SLEEP3 = 0x01000566,
  NA_SE_EN_CHICKEN_FLUTTER = 0x01000567,
  NA_SE_EN_KOUME_ILL = 0x01000568,
  NA_SE_EN_KOUME_REGAIN = 0x01000569,
  NA_SE_EN_KOUME_DRINK = 0x0100056a,
  NA_SE_EN_KOUME_LAUGH = 0x0100056b,
  NA_SE_EN_KOUME_FLY = 0x0100056c,
  NA_SE_EN_KOUME_AWAY = 0x0100056d,
  NA_SE_EN_KOUME_MAGIC = 0x0100056e,
  NA_SE_EN_DAIGOLON_SLEEP2 = 0x0100056f,
  NA_SE_EN_STALKIDS_JUMP = 0x01000570,
  NA_SE_EN_STALKIDS_FADEOUT = 0x01000571,
  NA_SE_EN_STALKIDS_LAUGH = 0x01000572,
  NA_SE_EN_STALKIDS_SHAKEHEAD = 0x01000573,
  NA_SE_EN_STALKIDS_ONGND = 0x01000574,
  NA_SE_EN_STALKIDS_SURPRISED = 0x01000575,
  NA_SE_EN_STALKIDS_WALK = 0x01000576,
  NA_SE_EN_STALKIDS_REVERSE = 0x01000577,
  NA_SE_EN_STALKIDS_FLOAT = 0x01000578,
  NA_SE_EN_EYEGOLE_EYE = 0x01000579,
  NA_SE_EN_STALKIDS_CAUGHT = 0x0100057a,
  NA_SE_EN_STALKIDS_MASK_ON = 0x0100057b,
  NA_SE_EN_TWINROBA_CUTBODY = 0x0100057c,
  NA_SE_EN_STALKIDS_MASK_OFF = 0x0100057d,
  NA_SE_EN_STALKIDS_RIDE = 0x0100057e,
  NA_SE_EN_DEKNUTS_DANCE = 0x0100057f,
  NA_SE_EN_DEKNUTS_DANCE1 = 0x01000580,
  NA_SE_EN_DEKNUTS_DANCE2 = 0x01000581,
  NA_SE_EN_DEKNUTS_DANCE_BIG = 0x01000582,
  NA_SE_EN_EYEGOLE_BEAM = 0x01000583,
  NA_SE_EN_GOLON_EYE_BIG = 0x01000584,
  NA_SE_EN_GOLON_GOOD_BIG = 0x01000585,
  NA_SE_EN_STALKIDS_LAUGH_MID = 0x01000586,
  NA_SE_EN_STALKIDS_FLOAT_COPY = 0x01000587,
  NA_SE_EN_STALKIDS_TURN = 0x01000588,
  NA_SE_EN_STALKIDS_DAMAGE = 0x01000589,
  NA_SE_EN_STALKIDS_SCREAM = 0x0100058a,
  NA_SE_EN_STALKIDS_OTEDAMA2 = 0x0100058b,
  NA_SE_EN_STALKIDS_STRETCH = 0x0100058c,
  NA_SE_EN_STALKIDS_LAUGH_MD2 = 0x0100058d,
  NA_SE_EN_OWL_FLUTTER = 0x0100058e,
  NA_SE_EN_VALVAISA_LAND = 0x0100058f,
  NA_SE_EN_IRONNACK_WALK = 0x01000590,
  NA_SE_EN_IRONNACK_SWING_AXE = 0x01000591,
  NA_SE_EN_STALKIDS_OTEDAMA1 = 0x01000592,
  NA_SE_EN_PAMET_CUTTER_ON = 0x01000593,
  NA_SE_EN_IRONNACK_ARMOR_OFF_DEMO = 0x01000594,
  NA_SE_EN_PAMET_CUTTER_OFF = 0x01000595,
  NA_SE_EN_B_SLIME_JUMP1 = 0x01000596,
  NA_SE_EN_B_SLIME_JUMP2 = 0x01000597,
  NA_SE_EN_FLOORMASTER_ATTACK = 0x01000598,
  NA_SE_EN_FLOORMASTER_SM_WALK = 0x01000599,
  NA_SE_EN_FLOORMASTER_SM_DEAD = 0x0100059a,
  NA_SE_EN_FLOORMASTER_RESTORE = 0x0100059b,
  NA_SE_EN_FLOORMASTER_EXPAND = 0x0100059c,
  NA_SE_EN_KUSAMUSHI_HIDE = 0x0100059d,
  NA_SE_EN_FLOORMASTER_SM_STICK = 0x0100059e,
  NA_SE_EN_FLOORMASTER_SM_LAND = 0x0100059f,
  NA_SE_EN_B_SLIME_COMBINE = 0x010005a0,
  NA_SE_EN_B_SLIME_PUNCH_MOVE = 0x010005a1,
  NA_SE_EN_IRONNACK_ARMOR_HIT = 0x010005a2,
  NA_SE_EN_CUTBODY = 0x010005a3,
  NA_SE_EN_LAST1_TRANSFORM = 0x010005a4,
  NA_SE_EN_LAST1_DEMO_BREAK = 0x010005a5,
  NA_SE_EN_LAST1_DEMO_WALL = 0x010005a6,
  NA_SE_EN_B_PAMET_BREAK = 0x010005a7,
  NA_SE_EN_KONB_DEMO_MOVE_OLD = 0x010005a8,
  NA_SE_EN_KONB_JUMP_OLD = 0x010005a9,
  NA_SE_EN_KONB_SINK_OLD = 0x010005aa,
  NA_SE_EN_UTSUBO_EAT = 0x010005ab,
  NA_SE_EN_YMAJIN_HOLD_SNOW = 0x010005ac,
  NA_SE_EN_KONB_DAMAGE_OLD = 0x010005ad,
  NA_SE_EN_KONB_DEAD_OLD = 0x010005ae,
  NA_SE_EN_KONB_BOUND_OLD = 0x010005af,
  NA_SE_EN_AWA_BOUND = 0x010005b0,
  NA_SE_EN_AWA_BREAK = 0x010005b1,
  NA_SE_EN_ICEB_FOOTSTEP_OLD = 0x010005b2,
  NA_SE_EN_COMMON_THUNDER = 0x010005b3,
  NA_SE_EN_ICEB_CRY_OLD = 0x010005b4,
  NA_SE_EN_ICEB_STEAM_LONG_OLD = 0x010005b5,
  NA_SE_EN_ICEB_STEAMS_DEMO_OLD = 0x010005b6,
  NA_SE_EN_ICEB_STEAM_DEMO_UP_OLD = 0x010005b7,
  NA_SE_EN_ICEB_DEAD_OLD = 0x010005b8,
  NA_SE_EN_ICEB_DAMAGE_OLD = 0x010005b9,
  NA_SE_EN_KONB_INIT_OLD = 0x010005ba,
  NA_SE_EN_KONB_DEAD2_OLD = 0x010005bb,
  NA_SE_EN_PIHAT_UP = 0x010005bc,
  NA_SE_EN_PIHAT_FLY = 0x010005bd,
  NA_SE_EN_PIHAT_DAMAGE = 0x010005be,
  NA_SE_EN_PIHAT_LAND = 0x010005bf,
  NA_SE_EN_KONB_BOUND2_OLD = 0x010005c0,
  NA_SE_EN_KONB_DEAD_JUMP_OLD = 0x010005c1,
  NA_SE_EN_KONB_DEAD_JUMP2_OLD = 0x010005c2,
  NA_SE_EN_FROG_JUMP = 0x010005c3,
  NA_SE_EN_FROG_GREET = 0x010005c4,
  NA_SE_EN_FROG_HOLD_SLIME = 0x010005c5,
  NA_SE_EN_FROG_THROW_SLIME = 0x010005c6,
  NA_SE_EN_FROG_JUMP_MID = 0x010005c7,
  NA_SE_EN_KONB_BITE_OLD = 0x010005c8,
  NA_SE_EN_FROG_PUNCH1 = 0x010005c9,
  NA_SE_EN_FROG_PUNCH2 = 0x010005ca,
  NA_SE_EN_UTSUBO_APPEAR_TRG = 0x010005cb,
  NA_SE_EN_FROG_DOWN = 0x010005cc,
  NA_SE_EN_FROG_JUMP_ABOVE = 0x010005cd,
  NA_SE_EN_FROG_KICK = 0x010005ce,
  NA_SE_EN_YMAJIN_MINI_HOLD = 0x010005cf,
  NA_SE_EN_YMAJIN_MINI_THROW = 0x010005d0,
  NA_SE_EN_YMAJIN_MOVE = 0x010005d1,
  NA_SE_EN_YMAJIN_MINI_MOVE = 0x010005d2,
  NA_SE_EN_YMAJIN_SURFACE = 0x010005d3,
  NA_SE_EN_YMAJIN_HIDE = 0x010005d4,
  NA_SE_EN_YMAJIN_SPLIT = 0x010005d5,
  NA_SE_EN_YMAJIN_UNITE = 0x010005d6,
  NA_SE_EN_YMAJIN_DEAD_BREAK = 0x010005d7,
  NA_SE_EN_BIMOS_ROLL_HEAD = 0x010005d8,
  NA_SE_EN_BIMOS_LAZER = 0x010005d9,
  NA_SE_EN_BIMOS_LAZER_GND = 0x010005da,
  NA_SE_EN_BIMOS_AIM = 0x010005db,
  NA_SE_EN_BUBLEWALK_WALK = 0x010005dc,
  NA_SE_EN_BUBLEWALK_AIM = 0x010005dd,
  NA_SE_EN_BUBLEWALK_REVERSE = 0x010005de,
  NA_SE_EN_BUBLEWALK_DAMAGE = 0x010005df,
  NA_SE_EN_BUBLEWALK_DEAD = 0x010005e0,
  NA_SE_EN_HIPLOOP_RUN = 0x010005e1,
  NA_SE_EN_HIPLOOP_PAUSE = 0x010005e2,
  NA_SE_EN_HIPLOOP_MASC_OFF = 0x010005e3,
  NA_SE_EN_HIPLOOP_FOOT = 0x010005e4,
  NA_SE_EN_HIPLOOP_DAMAGE = 0x010005e5,
  NA_SE_EN_HIPLOOP_DEAD = 0x010005e6,
  NA_SE_EN_HIPLOOP_FOOTSTEP = 0x010005e7,
  NA_SE_EN_DEKUHIME_WALK = 0x010005e8,
  NA_SE_EN_DEKUHIME_TURN = 0x010005e9,
  NA_SE_EN_DEKUHIME_GREET = 0x010005ea,
  NA_SE_EN_DEKUHIME_GREET2 = 0x010005eb,
  NA_SE_EN_PIHAT_SM_FLY = 0x010005ec,
  NA_SE_EN_PIHAT_SM_DEAD = 0x010005ed,
  NA_SE_EN_STALKID_APPEAR = 0x010005ee,
  NA_SE_EN_AKINDONUTS_HIDE = 0x010005ef,
  NA_SE_EN_RIVA_DAMAGE = 0x010005f0,
  NA_SE_EN_RIVA_DEAD = 0x010005f1,
  NA_SE_EN_RIVA_MOVE = 0x010005f2,
  NA_SE_EN_DEKUHIME_VOICE_SAD = 0x010005f3,
  NA_SE_EN_DEKUHIME_VOICE_JOY = 0x010005f4,
  NA_SE_EN_NUTS_JUMP = 0x010005f5,
  NA_SE_EN_NUTS_CLOTHES = 0x010005f6,
  NA_SE_EN_SITSUJI_VOICE = 0x010005f7,
  NA_SE_EN_LIKE_WALK = 0x010005f8,
  NA_SE_EN_LIKE_UNARI = 0x010005f9,
  NA_SE_EN_SUISEN_DRINK = 0x010005fa,
  NA_SE_EN_EYEGOLE_DEMO_EYE = 0x010005fb,
  NA_SE_EN_SUISEN_THROW = 0x010005fc,
  NA_SE_EN_LIKE_DAMAGE = 0x010005fd,
  NA_SE_EN_LIKE_DEAD = 0x010005fe,
  NA_SE_EN_MGANON_SWORD = 0x010005ff,
  NA_SE_EN_PIRATE_ATTACK = 0x01000600,
  NA_SE_EN_PIRATE_DAMAGE = 0x01000601,
  NA_SE_EN_PIRATE_DEAD = 0x01000602,
  NA_SE_EN_MB_MOTH_FLY = 0x01000603,
  NA_SE_EN_MB_MOTH_DEAD = 0x01000604,
  NA_SE_EN_MB_INSECT_WALK = 0x01000605,
  NA_SE_EN_B_PAMET_ROLL = 0x01000606,
  NA_SE_EN_FROG_VOICE1 = 0x01000607,
  NA_SE_EN_GERUDOFT_WALK = 0x01000608,
  NA_SE_EN_FROG_VOICE2 = 0x01000609,
  NA_SE_EN_B_PAMET_VOICE = 0x0100060a,
  NA_SE_EN_B_PAMET_REVERSE = 0x0100060b,
  NA_SE_EN_FREEZAD_BREATH = 0x0100060c,
  NA_SE_EN_FREEZAD_DAMAGE = 0x0100060d,
  NA_SE_EN_FREEZAD_DEAD = 0x0100060e,
  NA_SE_EN_DEKUHIMA_VOICE_HURY = 0x0100060f,
  NA_SE_EN_KINGNUTS_VOICE = 0x01000610,
  NA_SE_EN_FROG_RUNAWAY = 0x01000611,
  NA_SE_EN_LAST3_DEAD_DEAD1_OLD = 0x01000612,
  NA_SE_EN_LAST3_DEAD_DEAD2_OLD = 0x01000613,
  NA_SE_EN_FROG_RUNAWAY2 = 0x01000614,
  NA_SE_EN_DAIGOLON_SLEEP1 = 0x01000615,
  NA_SE_EN_IRONNACK_HIT_GND = 0x01000616,
  NA_SE_EN_LAST3_DEAD_WIND1_OLD = 0x01000617,
  NA_SE_EN_TWINROBA_LAUGH = 0x01000618,
  NA_SE_EN_TWINROBA_LAUGH2 = 0x01000619,
  NA_SE_EN_IRONNACK_PULLOUT = 0x0100061a,
  NA_SE_EN_TWINROBA_SHOOT_VOICE = 0x0100061b,
  NA_SE_EN_LAST3_DEAD_WIND2_OLD = 0x0100061c,
  NA_SE_EN_LAST3_DEAD_WIND3_OLD = 0x0100061d,
  NA_SE_EN_LAST3_DEAD_LIGHTS_OLD = 0x0100061e,
  NA_SE_EN_PIRATE_BREATH = 0x0100061f,
  NA_SE_EN_LAST3_DEAD_ROD = 0x01000620,
  NA_SE_EN_LAST2_SHOUT = 0x01000621,
  NA_SE_EN_LAST2_PUMP_UP_OLD = 0x01000622,
  NA_SE_EN_LAST2_GROW_HEAD_OLD = 0x01000623,
  NA_SE_EN_LAST2_HEARTBEAT_OLD = 0x01000624,
  NA_SE_EN_ANSATSUSYA_MOVING = 0x01000625,
  NA_SE_EN_ANSATSUSYA_DASH_2 = 0x01000626,
  NA_SE_EN_LAST3_DEAD_FLOAT = 0x01000627,
  NA_SE_EN_ANSATSUSYA_CRYING = 0x01000628,
  NA_SE_EN_ANSATSUSYA_SKIP = 0x01000629,
  NA_SE_EN_STALTURA_APPEAR = 0x0100062a,
  NA_SE_EN_ANSATSUSYA_JUMP = 0x0100062b,
  NA_SE_EN_ANSATSUSYA_FALL = 0x0100062c,
  NA_SE_EN_ANSATSUSYA_DAMAGE = 0x0100062d,
  NA_SE_EN_ANSATSUSYA_DEAD = 0x0100062e,
  NA_SE_EN_ANSATSUSYA_SWORD = 0x0100062f,
  NA_SE_EN_BAKUO_DEAD = 0x01000630,
  NA_SE_EN_BAKUO_APPEAR = 0x01000631,
  NA_SE_EN_LAST3_ROD_WIND_OLD = 0x01000632,
  NA_SE_EN_LAST3_ROD_FLOOR_OLD = 0x01000633,
  NA_SE_EN_LAST3_ROD_DANCE_OLD = 0x01000634,
  NA_SE_EN_LAST3_ROD_HOP_OLD = 0x01000635,
  NA_SE_EN_LAST3_ROD_HOP2_OLD = 0x01000636,
  NA_SE_EN_GANON_RESTORE = 0x01000637,
  NA_SE_EN_GOLON_CIRCLE = 0x01000638,
  NA_SE_EN_GOLON_CIRCLE_OFF = 0x01000639,
  NA_SE_EN_LAST1_BLOW_OLD = 0x0100063a,
  NA_SE_EN_LAST1_BEAM_OLD = 0x0100063b,
  NA_SE_EN_LAST1_ATTACK_OLD = 0x0100063c,
  NA_SE_EN_LAST1_DAMAGE1_OLD = 0x0100063d,
  NA_SE_EN_LAST1_DAMAGE2_OLD = 0x0100063e,
  NA_SE_EN_LAST1_FALL_OLD = 0x0100063f,
  NA_SE_EN_MGANON_STAND = 0x01000640,
  NA_SE_EN_LAST2_FIRE_OLD = 0x01000641,
  NA_SE_EN_STALGOLD_ROLL = 0x01000642,
  NA_SE_EN_LAST2_WALK_OLD = 0x01000643,
  NA_SE_EN_LAST2_WAIT_OLD = 0x01000644,
  NA_SE_EN_LAST2_JUMP_OLD = 0x01000645,
  NA_SE_EN_LAST2_BIRD_OLD = 0x01000646,
  NA_SE_EN_LAST2_BIRD2_OLD = 0x01000647,
  NA_SE_EN_STALTU_WAVE = 0x01000648,
  NA_SE_EN_STALTU_DOWN_SET = 0x01000649,
  NA_SE_EN_DEKU_WAKEUP = 0x0100064a,
  NA_SE_EN_LAST2_WALK2_OLD = 0x0100064b,
  NA_SE_EN_LAST1_FLOAT_OLD = 0x0100064c,
  NA_SE_EN_LAST1_ATTACK_2ND_OLD = 0x0100064d,
  NA_SE_EN_LAST1_ROLLING_OLD = 0x0100064e,
  NA_SE_EN_LAST3_GET_LINK_OLD = 0x0100064f,
  NA_SE_EN_PO_BIG_CRY = 0x01000650,
  NA_SE_EN_STALTURA_BOUND = 0x01000651,
  NA_SE_EN_STALGOLD_UP_CRY = 0x01000652,
  NA_SE_EN_GOLON_CRY = 0x01000653,
  NA_SE_EN_LAST3_ROD_SOFT = 0x01000654,
  NA_SE_EN_LAST3_ROD_MID_OLD = 0x01000655,
  NA_SE_EN_RIVA_BIG_APPEAR = 0x01000656,
  NA_SE_EN_LAST3_ROD_HARD = 0x01000657,
  NA_SE_EN_MUSI_WALK = 0x01000658,
  NA_SE_EN_LAST3_COIL_ATTACK_OLD = 0x01000659,
  NA_SE_EN_STALWALL_LAUGH = 0x0100065a,
  NA_SE_EN_PIRANHA_EXIST = 0x0100065b,
  NA_SE_EN_PIRANHA_ATTACK = 0x0100065c,
  NA_SE_EN_PIRANHA_DEAD = 0x0100065d,
  NA_SE_EN_KINGNUTS_DAMAGE = 0x0100065e,
  NA_SE_EN_COMMON_DEADLIGHT = 0x0100065f,
  NA_SE_EN_GOLONKID_WALK = 0x01000660,
  NA_SE_EN_YMAJIN_MINI_DAMAGE = 0x01000661,
  NA_SE_EN_YMAJIN_DAMAGE = 0x01000662,
  NA_SE_EN_KOTAKE_SURPRISED = 0x01000663,
  NA_SE_EN_HANDW_GET = 0x01000664,
  NA_SE_EN_HANDW_RELEASE = 0x01000665,
  NA_SE_EN_SLIME_SURFACE = 0x01000666,
  NA_SE_EN_KOTAKE_SLEEP = 0x01000667,
  NA_SE_EN_KOTAKE_SURPRISED2 = 0x01000668,
  NA_SE_EN_NEMURI_SLEEP = 0x01000669,
  NA_SE_EN_LAST1_DEAD_OLD = 0x0100066a,
  NA_SE_EN_GOLON_SIRLOIN_ROLL = 0x0100066b,
  NA_SE_EN_GOLON_VOICE_EATFULL = 0x0100066c,
  NA_SE_EN_GOLON_SIRLOIN_EAT = 0x0100066d,
  NA_SE_EN_EYEGOLE_WALK = 0x0100066e,
  NA_SE_EN_EYEGOLE_STAND = 0x0100066f,
  NA_SE_EN_EYEGOLE_SIT = 0x01000670,
  NA_SE_EN_INVADER_DEAD = 0x01000671,
  NA_SE_EN_INVADER_FLOAT = 0x01000672,
  NA_SE_EN_FOLLOWERS_BEAM_PRE = 0x01000673,
  NA_SE_EN_FOLLOWERS_BEAM = 0x01000674,
  NA_SE_EN_FOLLOWERS_DAMAGE = 0x01000675,
  NA_SE_EN_FOLLOWERS_DEAD = 0x01000676,
  NA_SE_EN_INBOSS_DEAD_PRE2_OLD = 0x01000677,
  NA_SE_EN_IKURA_JUMP1 = 0x01000678,
  NA_SE_EN_IKURA_JUMP2 = 0x01000679,
  NA_SE_EN_IKURA_DAMAGE = 0x0100067a,
  NA_SE_EN_IKURA_DEAD = 0x0100067b,
  NA_SE_EN_ME_DAMAGE = 0x0100067c,
  NA_SE_EN_ME_DEAD = 0x0100067d,
  NA_SE_EN_ME_EXIST = 0x0100067e,
  NA_SE_EN_ME_ATTACK = 0x0100067f,
  NA_SE_EN_GOLONKID_SOB_TALK = 0x01000680,
  NA_SE_EN_GOLONKID_YAWN = 0x01000681,
  NA_SE_EN_GOLONKID_SNORE = 0x01000682,
  NA_SE_EN_GOLON_SNORE1 = 0x01000683,
  NA_SE_EN_GOLON_SNORE2 = 0x01000684,
  NA_SE_EN_BUBLEFALL_APPEAR = 0x01000685,
  NA_SE_EN_INBOSS_DEAD_OLD = 0x01000686,
  NA_SE_EN_LAST1_BEAM2_OLD = 0x01000687,
  NA_SE_EN_COMMON_EXTINCT_LEV = 0x01000688,
  NA_SE_EN_BOSU_HEAD_MID = 0x01000689,
  NA_SE_EN_BOSU_HEAD_SHORT = 0x0100068a,
  NA_SE_EN_DEBU_HEAD_MID = 0x0100068b,
  NA_SE_EN_DEBU_HEAD_SHORT = 0x0100068c,
  NA_SE_EN_YASE_HEAD_MID = 0x0100068d,
  NA_SE_EN_YASE_HEAD_SHORT = 0x0100068e,
  NA_SE_EN_BOSU_WALK = 0x0100068f,
  NA_SE_EN_DEBU_WALK = 0x01000690,
  NA_SE_EN_YASE_WALK = 0x01000691,
  NA_SE_EN_BOSU_SIT = 0x01000692,
  NA_SE_EN_BOSU_STAND = 0x01000693,
  NA_SE_EN_BOSU_HAND = 0x01000694,
  NA_SE_EN_LAST3_KOMA_OLD = 0x01000695,
  NA_SE_EN_KONB_PREATTACK_OLD = 0x01000696,
  NA_SE_EN_BOSU_SHOCK = 0x01000697,
  NA_SE_EN_BOSU_SHIT = 0x01000698,
  NA_SE_EN_BOSU_ATTACK = 0x01000699,
  NA_SE_EN_BOSU_CYNICAL = 0x0100069a,
  NA_SE_EN_BOSU_LAUGH = 0x0100069b,
  NA_SE_EN_BOSU_LAUGH_DEMO = 0x0100069c,
  NA_SE_EN_DEBU_ATTACK = 0x0100069d,
  NA_SE_EN_DEBU_LAUGH = 0x0100069e,
  NA_SE_EN_DEBU_PAUSE = 0x0100069f,
  NA_SE_EN_YASE_ATTACK = 0x010006a0,
  NA_SE_EN_YASE_LAUGH = 0x010006a1,
  NA_SE_EN_YASE_PAUSE = 0x010006a2,
  NA_SE_EN_BOSU_DAMAGE = 0x010006a3,
  NA_SE_EN_DEBU_DAMAGE = 0x010006a4,
  NA_SE_EN_YASE_DAMAGE = 0x010006a5,
  NA_SE_EN_BOSU_DEAD = 0x010006a6,
  NA_SE_EN_DEBU_DEAD = 0x010006a7,
  NA_SE_EN_YASE_DEAD = 0x010006a8,
  NA_SE_EN_DEBU_PAUSE_K = 0x010006a9,
  NA_SE_EN_DEBU_LAUGH_SHORT_K = 0x010006aa,
  NA_SE_EN_DEBU_LAUGH_K = 0x010006ab,
  NA_SE_EN_YASE_PAUSE_K = 0x010006ac,
  NA_SE_EN_YASE_LAUGH_K = 0x010006ad,
  NA_SE_EN_BOSU_LAUGH_DEMO_K = 0x010006ae,
  NA_SE_EN_DEBU_LAUGH_SHORT = 0x010006af,
  NA_SE_EN_BOSU_LAUGH_K = 0x010006b0,
  NA_SE_EN_DEBU_ATTACK_W = 0x010006b1,
  NA_SE_EN_YASE_ATTACK_W = 0x010006b2,
  NA_SE_EN_BOSU_ATTACK_W = 0x010006b3,
  NA_SE_EN_STAL_FREEZE_LIGHTS = 0x010006b4,
  NA_SE_EN_BOSU_ATTACK_K = 0x010006b5,
  NA_SE_EN_BOSU_SWORD = 0x010006b6,
  NA_SE_EN_KONB_JUMP_LEV_OLD = 0x010006b7,
  NA_SE_EN_MIBOSS_FREEZE_OLD = 0x010006b8,
  NA_SE_EN_YMAJIN_THROW = 0x010006b9,
  NA_SE_EN_BOSU_HEAD_BITE = 0x010006ba,
  NA_SE_EN_BOSU_HEAD_FLOAT = 0x010006bb,
  NA_SE_EN_LAST3_VOICE_KICK_OLD = 0x010006bc,
  NA_SE_EN_LAST3_VOICE_KOMA_OLD = 0x010006bd,
  NA_SE_EN_LAST3_VOICE_ROD_OLD = 0x010006be,
  NA_SE_EN_LAST3_VOICE_THROW_OLD = 0x010006bf,
  NA_SE_EN_LAST3_VOICE_LAUGH_OLD = 0x010006c0,
  NA_SE_EN_LAST3_VOICE_DAMAGE_OLD = 0x010006c1,
  NA_SE_EN_LAST3_VOICE_DAMAGE2_OLD = 0x010006c2,
  NA_SE_EN_LAST3_VOICE_DEAD_OLD = 0x010006c3,
  NA_SE_EN_BOSU_DEAD_VOICE = 0x010006c4,
  NA_SE_EN_DEBU_DEAD_VOICE = 0x010006c5,
  NA_SE_EN_YASE_DEAD_VOICE = 0x010006c6,
  NA_SE_EN_LAST2_BALLET_OLD = 0x010006c7,
  NA_SE_EN_LAST2_MOONWALK_OLD = 0x010006c8,
  NA_SE_EN_SHARP_FLOAT = 0x010006c9,
  NA_SE_EN_SHARP_REACTION = 0x010006ca,
  NA_SE_EN_REDEAD_WEAKENED1 = 0x010006cb,
  NA_SE_EN_REDEAD_WEAKENED_L1 = 0x010006cc,
  NA_SE_EN_REDEAD_WEAKENED2 = 0x010006cd,
  NA_SE_EN_REDEAD_WEAKENED_L2 = 0x010006ce,
  NA_SE_EN_PIRATE_ONGND = 0x010006cf,
  NA_SE_EN_FOLLOWERS_STAY = 0x010006d0,
  NA_SE_EN_LAST2_VOICE_BALLET = 0x010006d1,
  NA_SE_EN_LAST2_VOICE_UAUOO1_OLD = 0x010006d2,
  NA_SE_EN_LAST2_VOICE_UAUOO2_OLD = 0x010006d3,
  NA_SE_EN_LAST2_VOICE_SURPRISED_OLD = 0x010006d4,
  NA_SE_EN_LAST2_DAMAGE_OLD = 0x010006d5,
  NA_SE_EN_LAST2_DAMAGE2_OLD = 0x010006d6,
  NA_SE_EN_LAST2_DEAD_OLD = 0x010006d7,
  NA_SE_EN_LAST2_UAUOO_OLD = 0x010006d8,
  NA_SE_EN_LAST2_GYM_B_OLD = 0x010006d9,
  NA_SE_EN_PIRATE_COOL_LAUGH = 0x010006da,
  NA_SE_EN_PIRATE_CYNICAL = 0x010006db,
  NA_SE_EN_PIRATE_DAMM_BREATH = 0x010006dc,
  NA_SE_EN_PIRATE_SHOUT = 0x010006dd,
  NA_SE_EN_STAL01_LAUGH = 0x010006de,
  NA_SE_EN_STAL02_LAUGH_SHORT = 0x010006df,
  NA_SE_EN_STAL03_LAUGH_BIG = 0x010006e0,
  NA_SE_EN_STAL04_ANGER = 0x010006e1,
  NA_SE_EN_STAL05_CYNICAL = 0x010006e2,
  NA_SE_EN_STAL06_SURPRISED = 0x010006e3,
  NA_SE_EN_STAL07_ANTONISHED = 0x010006e4,
  NA_SE_EN_STAL08_CRY_BIG = 0x010006e5,
  NA_SE_EN_STAL09_SCREAM = 0x010006e6,
  NA_SE_EN_STAL10_LAUGH_SHY = 0x010006e7,
  NA_SE_EN_STAL11_LAUGH_SHY2 = 0x010006e8,
  NA_SE_EN_STAL12_LAUGH_KIDLY = 0x010006e9,
  NA_SE_EN_STAL20_CALL_MOON = 0x010006ea,
  NA_SE_EN_STAL20_CALL_MOON2 = 0x010006eb,
  NA_SE_EN_STAL21_PSYCHO_VOICE = 0x010006ec,
  NA_SE_EN_STALKIDS_DOWN_K = 0x010006ed,
  NA_SE_EN_AKINDO_FLY = 0x010006ee,
  NA_SE_EN_NPC_APPEAR = 0x010006ef,
  NA_SE_EN_NPC_FADEAWAY = 0x010006f0,
  NA_SE_EN_DEBU_PAUSEx2 = 0x010006f1,
  NA_SE_EN_YASE_PAUSEx2 = 0x010006f2,
  NA_SE_EN_DEBU_HEAD_UP = 0x010006f3,
  NA_SE_EN_YASE_HEAD_UP = 0x010006f4,
  NA_SE_EN_STAL22_LAUGH_KID_L = 0x010006f5,
  NA_SE_EN_EVIL_POWER = 0x010006f6,
  NA_SE_NE_STAL23_COLD = 0x010006f7,
  NA_SE_EN_STALKIDS_GASAGOSO = 0x010006f8,
  NA_SE_EN_BOSU_TALK = 0x010006f9,
  NA_SE_EN_FAMOS_REVERSE1 = 0x010006fa,
  NA_SE_EN_FAMOS_REVERSE2 = 0x010006fb,
  NA_SE_EN_FAMOS_FLOAT = 0x010006fc,
  NA_SE_EN_FAMOS_FLOAT_REVERSE = 0x010006fd,
  NA_SE_EN_KOTAKE_ROLL = 0x010006fe,
  NA_SE_EN_KOTAKE_FLY = 0x010006ff,
  NA_SE_EN_THIEFBIRD_VOICE = 0x01000700,
  NA_SE_EN_THIEFBIRD_DAMAGE = 0x01000701,
  NA_SE_EN_THIEFBIRD_DEAD = 0x01000702,
  NA_SE_EN_STALKIDS_BODY = 0x01000703,
  NA_SE_EN_STALKIDS_BODY_LEV = 0x01000704,
  NA_SE_EN_BOSU_STAND_RAPID = 0x01000705,
  NA_SE_EN_STAL24_SCREAM2 = 0x01000706,
  NA_SE_EN_STALKIDS_EARTHQUAKE = 0x01000707,
  NA_SE_EN_MASK_FLOAT = 0x01000708,
  NA_SE_EN_STALKIDS_PULLED = 0x01000709,
  NA_SE_EN_KITA_SALUTE = 0x0100070a,
  NA_SE_EN_KTIA_WALK = 0x0100070b,
  NA_SE_EN_KTIA_PAUSE_K = 0x0100070c,
  NA_SE_EN_KITA_LAUGH_K = 0x0100070d,
  NA_SE_EN_KITA_DAMAGE = 0x0100070e,
  NA_SE_EN_KITA_DEAD = 0x0100070f,
  NA_SE_EN_STALBABY_LAUGH = 0x01000710,
  NA_SE_EN_STALBABY_SURPRISED = 0x01000711,
  NA_SE_EN_KITA_BREAK = 0x01000712,
  NA_SE_EN_KITA_ATTACK_W = 0x01000713,
  NA_SE_EN_KONB_WAIT_OLD = 0x01000714,
  NA_SE_EN_DEATH_SCYTHE = 0x01000715,
  NA_SE_EN_DEATH_ROLL = 0x01000716,
  NA_SE_EN_DEATH_SCYTHE_LEV = 0x01000717,
  NA_SE_EN_DEATH_SCYTHE_ONGND = 0x01000718,
  NA_SE_EN_DEATH_VOICE = 0x01000719,
  NA_SE_EN_DEATH_DAMAGE = 0x0100071a,
  NA_SE_EN_DEATH_DEAD = 0x0100071b,
  NA_SE_EN_DEATH_ATTACK = 0x0100071c,
  NA_SE_EN_DEATH_APPEAR = 0x0100071d,
  NA_SE_EN_DEATH_HEARTBREAK = 0x0100071e,
  NA_SE_EN_KONB_MINI_DEAD = 0x0100071f,
  NA_SE_EN_HALF_REDEAD_LOOP = 0x01000720,
  NA_SE_EN_HALF_REDEAD_SURPRISE = 0x01000721,
  NA_SE_EN_HALF_REDEAD_SCREAME = 0x01000722,
  NA_SE_EN_HALF_REDEAD_TRANS = 0x01000723,
  NA_SE_EN_GOLON_VOICE_GENERAL = 0x01000724,
  NA_SE_EN_IWAIGORON_EVERYBODY = 0x01000725,
  NA_SE_EN_IWAIGORON_SOLO = 0x01000726,
  NA_SE_EN_ROMANI_WALK = 0x01000727,
  NA_SE_EN_MOON_SCREAM1 = 0x01000728,
  NA_SE_EN_MOON_SCREAM2 = 0x01000729,
  NA_SE_EN_MOON_SCREAM3 = 0x0100072a,
  NA_SE_EN_MOON_SCREAM4 = 0x0100072b,
  NA_SE_EN_STALKIDS_HEADACHE = 0x0100072c,
  NA_SE_EN_BIGNUTS_WALK = 0x0100072d,
  NA_SE_EN_KITA_PAUSE = 0x0100072e,
  NA_SE_EN_ANSATSUSYA_LAUGH = 0x0100072f,
  NA_SE_EN__copy514 = 0x01000730,
  NA_SE_EN__copy515 = 0x01000731,
  NA_SE_EN__copy516 = 0x01000732,
  NA_SE_EN__copy517 = 0x01000733,
  NA_SE_EN__copy518 = 0x01000734,
  NA_SE_EN__copy519 = 0x01000735,
  NA_SE_EN_DALMANI_A = 0x01000736,
  NA_SE_EN_DALMANI_B = 0x01000737,
  NA_SE_EN_DALMANI_C = 0x01000738,
  NA_SE_EN_DALMANI_D = 0x01000739,
  NA_SE_EN__2d1 = 0x0100073a,
  NA_SE_EN__2d2 = 0x0100073b,
  NA_SE_EN_EVIL_POWER_PREDEMO = 0x0100073c,
  NA_SE_EN_KOUME_DAMAGE = 0x0100073d,
  NA_SE_EN_KOUME_DAMAGE2 = 0x0100073e,
  NA_SE_EN_KONB_MINI_APPEAR = 0x0100073f,
  NA_SE_EN_IRONNACK_DAMAGE = 0x01000740,
  NA_SE_EN_IRONNACK_DEAD = 0x01000741,
  NA_SE_EN_ANSATSUSYA_ONGND = 0x01000742,
  NA_SE_EN_ANSATSUSYA_ROCK = 0x01000743,
  NA_SE_EN_REDEAD_REVERSE = 0x01000744,
  NA_SE_EN_STALKIDS_NOSE = 0x01000745,
  NA_SE_EN_KITA_SNORE = 0x01000746,
  NA_SE_EN_IRONNACK_DASH = 0x01000747,
  NA_SE_EN_TUBOOCK_FLY = 0x01000748,
  NA_SE_EN_MIMICK_BREATH = 0x01000749,
  NA_SE_EN_FANTOM_DEAD = 0x0100074a,
  NA_SE_EN_KAICHO_PIYORI = 0x0100074b,
  NA_SE_EN_READED_WALK = 0x0100074c,
  NA_SE_EN_LEADED_WHITE = 0x0100074d,
  NA_SE_EN_MIBOSS_APPEAR_B_OLD = 0x0100074e,
  NA_SE_EN_MIBOSS_KICK_OLD = 0x0100074f,
  NA_SE_EN_MIBOSS_HEADDOWN_OLD = 0x01000750,
  NA_SE_EN_MIBOSS_LEGDOWN_OLD = 0x01000751,
  NA_SE_EN_MIBOSS_WEAKWAIT_OLD = 0x01000752,
  NA_SE_EN_MIBOSS_THRUST1_OLD = 0x01000753,
  NA_SE_EN_MIBOSS_JUMP3_OLD = 0x01000754,
  NA_SE_EN_MIBOSS_SWORD_ROLL_OLD = 0x01000755,
  NA_SE_EN_MIBOSS_DANCE_THRUST_OLD = 0x01000756,
  NA_SE_EN_MIBOSS_DANCE_FIRE_OLD = 0x01000757,
  NA_SE_EN_B_PAMET_ROCK = 0x01000758,
  NA_SE_EN_DUMMY753 = 0x01000759,
  NA_SE_EN_DUMMY_754 = 0x0100075a,
  NA_SE_EN_FANTOM_FLOAT = 0x0100075b,
  NA_SE_EN_KONB_SUIKOMI = 0x0100075c,
  NA_SE_EN_KONB_LANDING_OLD = 0x0100075d,
  NA_SE_EN_KONB_SIBUKI_OLD = 0x0100075e,
  NA_SE_EN_KONB_PIYORI_OLD = 0x0100075f,
  NA_SE_EN_KOUME_UBAITORU = 0x01000760,
  NA_SE_EN_STALKIDS_PSYCHO2 = 0x01000761,
  NA_SE_EN_RIZA_ATTACK3 = 0x01000762,
  NA_SE_EN_YASE_LAUGH_K_HOLD = 0x01000763,
  NA_SE_EN_WIZ_DEAD_NEW = 0x01000764,
  NA_SE_EN_HIPLOOP_BURN = 0x01000765,
  NA_SE_EN_EYEGOLE_HATAKI = 0x01000766,
  NA_SE_EN_DEKNUTS_DANCE_FADE = 0x01000767,
  NA_SE_EN_NUTS_FURUERU = 0x01000768,
  NA_SE_EN_PO_APPEAR_IDO = 0x01000769,
  NA_SE_EN_FOLLOWERS_TO_KABE = 0x0100076a,
  NA_SE_EN_MUJURA_LAST_UP = 0x0100076b,
  NA_SE_SY_WIN_OPEN = 0x0100076c,
  NA_SE_SY_WIN_CLOSE = 0x0100076d,
  NA_SE_SY_CORRECT_CHIME = 0x0100076e,
  NA_SE_SY_GET_RUPY = 0x0100076f,
  NA_SE_SY_MESSAGE_WOMAN = 0x01000770,
  NA_SE_SY_MESSAGE_MAN = 0x01000771,
  NA_SE_SY_ERROR = 0x01000772,
  NA_SE_SY_TRE_BOX_APPEAR = 0x01000773,
  NA_SE_SY_DECIDE = 0x01000774,
  NA_SE_SY_CURSOR = 0x01000775,
  NA_SE_SY_CANCEL = 0x01000776,
  NA_SE_SY_HP_RECOVER = 0x01000777,
  NA_SE_SY_ATTENTION_ON = 0x01000778,
  NA_SE_SY_DUMMY_13 = 0x01000779,
  NA_SE_SY_DUMMY_14 = 0x0100077a,
  NA_SE_SY_LOCK_OFF = 0x0100077b,
  NA_SE_SY_LOCK_ON_HUMAN = 0x0100077c,
  NA_SE_SY_DUMMY_17 = 0x0100077d,
  NA_SE_SY_DUMMY_18 = 0x0100077e,
  NA_SE_SY_CAMERA_ZOOM_UP = 0x0100077f,
  NA_SE_SY_CAMERA_ZOOM_DOWN = 0x01000780,
  NA_SE_SY_DUMMY_21 = 0x01000781,
  NA_SE_SY_DUMMY_22 = 0x01000782,
  NA_SE_SY_ATTENTION_ON_OLD = 0x01000783,
  NA_SE_SY_MESSAGE_PASS = 0x01000784,
  NA_SE_SY_WARNING_COUNT_N = 0x01000785,
  NA_SE_SY_WARNING_COUNT_E = 0x01000786,
  NA_SE_SY_HITPOINT_ALARM = 0x01000787,
  NA_SE_SY_DUMMY_28 = 0x01000788,
  NA_SE_SY_DEMO_CUT = 0x01000789,
  NA_SE_SY_NAVY_CALL = 0x0100078a,
  NA_SE_SY_GAUGE_UP = 0x0100078b,
  NA_SE_SY_DUMMY_32 = 0x0100078c,
  NA_SE_SY_DUMMY_33 = 0x0100078d,
  NA_SE_SY_DUMMY_34 = 0x0100078e,
  NA_SE_SY_PIECE_OF_HEART = 0x0100078f,
  NA_SE_SY_GET_ITEM = 0x01000790,
  NA_SE_SY_WIN_SCROLL_LEFT = 0x01000791,
  NA_SE_SY_WIN_SCROLL_RIGHT = 0x01000792,
  NA_SE_SY_OCARINA_ERROR = 0x01000793,
  NA_SE_SY_CAMERA_ZOOM_UP_2 = 0x01000794,
  NA_SE_SY_CAMERA_ZOOM_DOWN_2 = 0x01000795,
  NA_SE_SY_GLASSMODE_ON = 0x01000796,
  NA_SE_SY_GLASSMODE_OFF = 0x01000797,
  NA_SE_SY_FOUND = 0x01000798,
  NA_SE_SY_HIT_SOUND = 0x01000799,
  NA_SE_SY_MESSAGE_END = 0x0100079a,
  NA_SE_SY_RUPY_COUNT = 0x0100079b,
  NA_SE_SY_LOCK_ON = 0x0100079c,
  NA_SE_SY_GET_BOXITEM = 0x0100079d,
  NA_SE_SY_WHITE_OUT_INTO_MOON = 0x0100079e,
  NA_SE_SY_WHITE_OUT_S = 0x0100079f,
  NA_SE_SY_WHITE_OUT_T = 0x010007a0,
  NA_SE_SY_START_SHOT = 0x010007a1,
  NA_SE_SY_METRONOME = 0x010007a2,
  NA_SE_SY_ATTENTION_URGENCY = 0x010007a3,
  NA_SE_SY_METRONOME_LV = 0x010007a4,
  NA_SE_SY_FSEL_CURSOR = 0x010007a5,
  NA_SE_SY_FSEL_DECIDE_S = 0x010007a6,
  NA_SE_SY_FSEL_DECIDE_L = 0x010007a7,
  NA_SE_SY_FSEL_CLOSE = 0x010007a8,
  NA_SE_SY_FSEL_ERROR = 0x010007a9,
  NA_SE_SY_SET_FIRE_ARROW = 0x010007aa,
  NA_SE_SY_SET_ICE_ARROW = 0x010007ab,
  NA_SE_SY_SET_LIGHT_ARROW = 0x010007ac,
  NA_SE_SY_SYNTH_MAGIC_ARROW = 0x010007ad,
  NA_SE_SY_METRONOME_2 = 0x010007ae,
  NA_SE_SY_KINSTA_MARK_APPEAR = 0x010007af,
  NA_SE_SY_FIVE_COUNT_LUPY = 0x010007b0,
  NA_SE_SY_CARROT_RECOVER = 0x010007b1,
  NA_SE_EV_FAIVE_LUPY_COUNT = 0x010007b2,
  NA_SE_SY_METRONOME_TEMPO = 0x010007b3,
  NA_SE_SY_COMICAL_SOUND0_0 = 0x010007b4,
  NA_SE_SY_COMICAL_SOUND0_1 = 0x010007b5,
  NA_SE_SY_COMICAL_SOUND0_LAST = 0x010007b6,
  NA_SE_SY_SOUT_DEMO = 0x010007b7,
  NA_SE_SY_TIMESIGNAL_BELL = 0x010007b8,
  NA_SE_SY_DEKUNUTS_JUMP_FAILED = 0x010007b9,
  NA_SE_SY_ATTENTION_SOUND = 0x010007ba,
  NA_SE_SY_TRANSFORM_MASK_FLASH = 0x010007bb,
  NA_SE_SY_CAMERA_SHUTTER = 0x010007bc,
  NA_SE_SY_STALKIDS_PSYCHO = 0x010007bd,
  NA_SE_SY_CHICK_JOIN_CHIME = 0x010007be,
  NA_SE_SY_HIT_SOUND_L = 0x010007bf,
  NA_SE_SY_FAIRY_MASK_SUCCESS = 0x010007c0,
  NA_SE_SY_SCHEDULE_WRITE = 0x010007c1,
  NA_SE_SY_STOPWATCH_TIMER_3 = 0x010007c2,
  NA_SE_SY_STOPWATCH_TIMER_INF = 0x010007c3,
  NA_SE_SY_EARTHQUAKE_OUTDOOR = 0x010007c4,
  NA_SE_SY_SPIRAL_DASH = 0x010007c5,
  NA_SE_SY_QUIZ_CORRECT = 0x010007c6,
  NA_SE_SY_QUIZ_INCORRECT = 0x010007c7,
  NA_SE_SY_DIZZY_EFFECT = 0x010007c8,
  NA_SE_SY_TIME_CONTROL_SLOW = 0x010007c9,
  NA_SE_SY_TIME_CONTROL_NORMAL = 0x010007ca,
  NA_SE_SY_SECOM_WARNING = 0x010007cb,
  NA_SE_SY_WIN_CHANGE = 0x010007cc,
  NA_SE_SY_TOUCH1 = 0x010007cd,
  NA_SE_SY_MENU_CHAT_MOVE = 0x010007ce,
  NA_SE_SY_YUBI_MOVE = 0x010007cf,
  NA_SE_SY_CHAT_ALLERT_IN = 0x010007d0,
  NA_SE_SY_CHAT_ALLERT = 0x010007d1,
  NA_SE_SY_CHAT_ALLERT_OUT = 0x010007d2,
  NA_SE_SY_TOUCH2 = 0x010007d3,
  NA_SE_SY_TOUCH2_OUT = 0x010007d4,
  NA_SE_SY_TOUCH3 = 0x010007d5,
  NA_SE_SY_TOUCH4 = 0x010007d6,
  NA_SE_SY_YUBI_CURSOL_KEY = 0x010007d7,
  NA_SE_SY_EVENT_INFO = 0x010007d8,
  NA_SE_SY_CLEAR1 = 0x010007d9,
  NA_SE_SY_ALARM_MOVE = 0x010007da,
  NA_SE_SY_QUEST_NEW = 0x010007db,
  NA_SE_SY_EVENT_FAIL = 0x010007dc,
  NA_SE_SY_QUEST_CLEAR = 0x010007dd,
  NA_SE_SY_CHAT_ALARM_OFF = 0x010007de,
  NA_SE_SY_CHAT_ALARM_INFO = 0x010007df,
  NA_SE_SY_ICON_MOVE = 0x010007e0,
  NA_SE_SY_ICON_MOVE_SET = 0x010007e1,
  NA_SE_SY_DIAMOND_SWITCH = 0x010007e2,
  NA_SE_SY_PREDEMO_EVIL = 0x010007e3,
  NA_SE_SY_PREDEMO_OMEN = 0x010007e4,
  NA_SE_OC_OCARINA = 0x010007e5,
  NA_SE_OC_ABYSS = 0x010007e6,
  NA_SE_OC_DOOR_OPEN = 0x010007e7,
  NA_SE_OC_SECRET_WARP_IN = 0x010007e8,
  NA_SE_OC_SECRET_WARP_OUT = 0x010007e9,
  NA_SE_OC_SECRET_HOLE_OUT = 0x010007ea,
  NA_SE_OC_REVENGE = 0x010007eb,
  NA_SE_OC_TUNAMI = 0x010007ec,
  NA_SE_OC_TELOP_IMPACT = 0x010007ed,
  NA_SE_OC_WOOD_GATE_OPEN = 0x010007ee,
  NA_SE_OC_FIREWORKS = 0x010007ef,
  NA_SE_OC_WHITE_OUT_INTO_KYOJIN = 0x010007f0,
  NA_SE_OC_12 = 0x010007f1,
  NA_SE_OC_13 = 0x010007f2,
  NA_SE_OC_14 = 0x010007f3,
  NA_SE_OC_15 = 0x010007f4,
  NA_SE_OC_HINT_MOVIE = 0x010007f5,
  NA_SE_OC_HINT_MOVIE2_WHITE = 0x010007f6,
  NA_SE_OC_HINT_MOVIE_ZOOMIN = 0x010007f7,
  NA_SE_OC_HIBIKI_ISHI = 0x010007f8,
  NA_SE_VO_LI_SWORD_N = 0x010007f9,
  NA_SE_VO_LI_SWORD_L = 0x010007fa,
  NA_SE_VO_LI_LASH = 0x010007fb,
  NA_SE_VO_LI_HANG = 0x010007fc,
  NA_SE_VO_LI_CLIMB_END = 0x010007fd,
  NA_SE_VO_LI_DAMAGE_S = 0x010007fe,
  NA_SE_VO_LI_FREEZE = 0x010007ff,
  NA_SE_VO_LI_FALL_S = 0x01000800,
  NA_SE_VO_LI_FALL_L = 0x01000801,
  NA_SE_VO_LI_BREATH_REST = 0x01000802,
  NA_SE_VO_LI_BREATH_DRINK = 0x01000803,
  NA_SE_VO_LI_DOWN = 0x01000804,
  NA_SE_VO_LI_TAKEN_AWAY = 0x01000805,
  NA_SE_VO_LI_HELD = 0x01000806,
  NA_SE_VO_LI_SNEEZE = 0x01000807,
  NA_SE_VO_LI_SWEAT = 0x01000808,
  NA_SE_VO_LI_DRINK = 0x01000809,
  NA_SE_VO_LI_RELAX = 0x0100080a,
  NA_SE_VO_LI_SWORD_PUTAWAY = 0x0100080b,
  NA_SE_VO_LI_GROAN = 0x0100080c,
  NA_SE_VO_LI_AUTO_JUMP = 0x0100080d,
  NA_SE_VO_LI_MAGIC_NALE = 0x0100080e,
  NA_SE_VO_LI_SURPRISE = 0x0100080f,
  NA_SE_VO_LI_MAGIC_FROL = 0x01000810,
  NA_SE_VO_LI_PUSH = 0x01000811,
  NA_SE_VO_LI_HOOKSHOT_HANG = 0x01000812,
  NA_SE_VO_LI_LAND_DAMAGE_S = 0x01000813,
  NA_SE_VO_LI_MAGIC_START = 0x01000814,
  NA_SE_VO_LI_MAGIC_ATTACK = 0x01000815,
  NA_SE_VO_BL_DOWN = 0x01000816,
  NA_SE_VO_LI_DEMO_DAMAGE = 0x01000817,
  NA_SE_VO_LI_SWORD_N_copy30 = 0x01000818,
  NA_SE_VO_DUMMY_32 = 0x01000819,
  NA_SE_VO_DUMMY_33 = 0x0100081a,
  NA_SE_VO_DUMMY_34 = 0x0100081b,
  NA_SE_VO_DUMMY_35 = 0x0100081c,
  NA_SE_VO_DUMMY_36 = 0x0100081d,
  NA_SE_VO_DUMMY_37 = 0x0100081e,
  NA_SE_VO_DUMMY_38 = 0x0100081f,
  NA_SE_VO_DUMMY_39 = 0x01000820,
  NA_SE_VO_NAVY_ENEMY = 0x01000821,
  NA_SE_VO_NAVY_HELLO = 0x01000822,
  NA_SE_VO_NAVY_HEAR = 0x01000823,
  NA_SE_VO_DUMMY_43 = 0x01000824,
  NA_SE_VO_DUMMY_44 = 0x01000825,
  NA_SE_VO_DUMMY_45 = 0x01000826,
  NA_SE_VO_DUMMY_46 = 0x01000827,
  NA_SE_VO_DUMMY_47 = 0x01000828,
  NA_SE_VO_DUMMY_48 = 0x01000829,
  NA_SE_VO_DUMMY_49 = 0x0100082a,
  NA_SE_VO_DUMMY_50 = 0x0100082b,
  NA_SE_VO_DUMMY_51 = 0x0100082c,
  NA_SE_VO_DUMMY_52 = 0x0100082d,
  NA_SE_VO_DUMMY_53 = 0x0100082e,
  NA_SE_VO_DUMMY_54 = 0x0100082f,
  NA_SE_VO_DUMMY_55 = 0x01000830,
  NA_SE_VO_DUMMY_56 = 0x01000831,
  NA_SE_VO_DUMMY_57 = 0x01000832,
  NA_SE_VO_DUMMY_58 = 0x01000833,
  NA_SE_VO_DUMMY_59 = 0x01000834,
  NA_SE_VO_DUMMY_60 = 0x01000835,
  NA_SE_VO_DUMMY_61 = 0x01000836,
  NA_SE_VO_DUMMY_62 = 0x01000837,
  NA_SE_VO_DUMMY_63 = 0x01000838,
  NA_SE_VO_LK_WAKE_UP = 0x01000839,
  NA_SE_VO_LK_CATCH_DEMO = 0x0100083a,
  NA_SE_VO_LK_DRAGGED_DAMAGE = 0x0100083b,
  NA_SE_VO_NAVY_CALL = 0x0100083c,
  NA_SE_VO_NA_HELLO_3 = 0x0100083d,
  NA_SE_VO_CHAT_MESSAGE_CALL = 0x0100083e,
  NA_SE_VO_BELL_MESSAGE = 0x0100083f,
  NA_SE_VO_MONDO_MESSAGE = 0x01000840,
  NA_SE_VO_LK_USING_UP_ENERGY = 0x01000841,
  NA_SE_VO_DUMMY_73 = 0x01000842,
  NA_SE_VO_GO_SLEEP = 0x01000843,
  NA_SE_VO_NP_SLEEP_OUT = 0x01000844,
  NA_SE_VO_DUMMY_76 = 0x01000845,
  NA_SE_VO_DUMMY_77 = 0x01000846,
  NA_SE_VO_NP_DRINK = 0x01000847,
  NA_SE_VO_DUMMY_79 = 0x01000848,
  NA_SE_VO_NARRATION_0 = 0x01000849,
  NA_SE_VO_TA_SURPRISE = 0x0100084a,
  NA_SE_VO_TA_CRY_0 = 0x0100084b,
  NA_SE_VO_TA_CRY_1 = 0x0100084c,
  NA_SE_VO_IN_CRY_0 = 0x0100084d,
  NA_SE_VO_IN_LOST = 0x0100084e,
  NA_SE_VO_IN_LASH_0 = 0x0100084f,
  NA_SE_VO_IN_LASH_1 = 0x01000850,
  NA_SE_VO_FR_LAUGH_0 = 0x01000851,
  NA_SE_VO_FR_SMILE_0 = 0x01000852,
  NA_SE_VO_NB_AGONY = 0x01000853,
  NA_SE_VO_NB_CRY_0 = 0x01000854,
  NA_SE_VO_NB_NOTICE = 0x01000855,
  NA_SE_VO_NA_HELLO_0 = 0x01000856,
  NA_SE_VO_NA_HELLO_1 = 0x01000857,
  NA_SE_VO_NA_HELLO_2 = 0x01000858,
  NA_SE_VO_RT_CRASH = 0x01000859,
  NA_SE_VO_RT_DISCOVER = 0x0100085a,
  NA_SE_VO_RT_FALL = 0x0100085b,
  NA_SE_VO_RT_LAUGH_0 = 0x0100085c,
  NA_SE_VO_RT_LIFT = 0x0100085d,
  NA_SE_VO_RT_THROW = 0x0100085e,
  NA_SE_VO_RT_UNBALLANCE = 0x0100085f,
  NA_SE_VO_ST_DAMAGE = 0x01000860,
  NA_SE_VO_ST_ATTACK = 0x01000861,
  NA_SE_VO_Z0_HURRY = 0x01000862,
  NA_SE_VO_Z0_MEET = 0x01000863,
  NA_SE_VO_Z0_QUESTION = 0x01000864,
  NA_SE_VO_Z0_SIGH_0 = 0x01000865,
  NA_SE_VO_Z0_SMILE_0 = 0x01000866,
  NA_SE_VO_Z0_SURPRISE = 0x01000867,
  NA_SE_VO_Z0_THROW = 0x01000868,
  NA_SE_VO_SK_CRY_0 = 0x01000869,
  NA_SE_VO_SK_CRY_1 = 0x0100086a,
  NA_SE_VO_SK_CRASH = 0x0100086b,
  NA_SE_VO_NA_LISTEN = 0x0100086c,
  NA_SE_VO_SK_SHOUT = 0x0100086d,
  NA_SE_VO_Z1_CRY_0 = 0x0100086e,
  NA_SE_VO_Z1_CRY_1 = 0x0100086f,
  NA_SE_VO_Z1_OPENDOOR = 0x01000870,
  NA_SE_VO_FR_SMILE_1 = 0x01000871,
  NA_SE_VO_FR_SMILE_2 = 0x01000872,
  NA_SE_VO_KZ_MOVE = 0x01000873,
  NA_SE_VO_NB_LAUGH = 0x01000874,
  NA_SE_VO_IN_JOY0 = 0x01000875,
  NA_SE_VO_IN_JOY1 = 0x01000876,
  NA_SE_VO_IN_JOY2 = 0x01000877,
  NA_SE_VO_DUMMY_127 = 0x01000878,
  NA_SE_VO_DUMMY_128 = 0x01000879,
  NA_SE_VO_DUMMY_129 = 0x0100087a,
  NA_SE_VO_DUMMY_130 = 0x0100087b,
  NA_SE_VO_DUMMY_131 = 0x0100087c,
  NA_SE_VO_DUMMY_132 = 0x0100087d,
  NA_SE_VO_DUMMY_133 = 0x0100087e,
  NA_SE_VO_DUMMY_134 = 0x0100087f,
  NA_SE_VO_DUMMY_135 = 0x01000880,
  NA_SE_VO_DUMMY_136 = 0x01000881,
  NA_SE_VO_DUMMY_137 = 0x01000882,
  NA_SE_VO_DUMMY_138 = 0x01000883,
  NA_SE_VO_DUMMY_139 = 0x01000884,
  NA_SE_VO_DUMMY_140 = 0x01000885,
  NA_SE_VO_DUMMY_141 = 0x01000886,
  NA_SE_VO_DUMMY_142 = 0x01000887,
  NA_SE_VO_DUMMY_143 = 0x01000888,
  NA_SE_VO_DUMMY_144 = 0x01000889,
  NA_SE_VO_DUMMY_145 = 0x0100088a,
  NA_SE_VO_DUMMY_146 = 0x0100088b,
  NA_SE_VO_DUMMY_147 = 0x0100088c,
  NA_SE_VO_DUMMY_148 = 0x0100088d,
  NA_SE_VO_DUMMY_149 = 0x0100088e,
  NA_SE_VO_DUMMY_150 = 0x0100088f,
  NA_SE_VO_DUMMY_151 = 0x01000890,
  NA_SE_VO_DUMMY_152 = 0x01000891,
  NA_SE_VO_DUMMY_153 = 0x01000892,
  NA_SE_VO_DUMMY_154 = 0x01000893,
  NA_SE_VO_DUMMY_155 = 0x01000894,
  NA_SE_VO_DUMMY_156 = 0x01000895,
  NA_SE_VO_DUMMY_157 = 0x01000896,
  NA_SE_VO_DUMMY_158 = 0x01000897,
  NA_SE_VO_DUMMY_159 = 0x01000898,
  NA_SE_VO_DUMMY_160 = 0x01000899,
  NA_SE_VO_DUMMY_161 = 0x0100089a,
  NA_SE_VO_DUMMY_162 = 0x0100089b,
  NA_SE_VO_DUMMY_163 = 0x0100089c,
  NA_SE_VO_DUMMY_164 = 0x0100089d,
  NA_SE_VO_DUMMY_165 = 0x0100089e,
  NA_SE_VO_DUMMY_166 = 0x0100089f,
  NA_SE_VO_DUMMY_167 = 0x010008a0,
  NA_SE_VO_DUMMY_168 = 0x010008a1,
  NA_SE_VO_DUMMY_169 = 0x010008a2,
  NA_SE_VO_DUMMY_170 = 0x010008a3,
  NA_SE_VO_DUMMY_171 = 0x010008a4,
  NA_SE_VO_DUMMY_172 = 0x010008a5,
  NA_SE_VO_DUMMY_173 = 0x010008a6,
  NA_SE_VO_DUMMY_174 = 0x010008a7,
  NA_SE_VO_DUMMY_175 = 0x010008a8,
  NA_SE_VO_DUMMY_176 = 0x010008a9,
  NA_SE_VO_DUMMY_177 = 0x010008aa,
  NA_SE_VO_DUMMY_178 = 0x010008ab,
  NA_SE_VO_DUMMY_179 = 0x010008ac,
  NA_SE_VO_DUMMY_180 = 0x010008ad,
  NA_SE_VO_DUMMY_181 = 0x010008ae,
  NA_SE_VO_DUMMY_182 = 0x010008af,
  NA_SE_VO_DUMMY_183 = 0x010008b0,
  NA_SE_VO_DUMMY_184 = 0x010008b1,
  NA_SE_VO_DUMMY_185 = 0x010008b2,
  NA_SE_VO_DUMMY_186 = 0x010008b3,
  NA_SE_VO_DUMMY_187 = 0x010008b4,
  NA_SE_VO_DUMMY_188 = 0x010008b5,
  NA_SE_VO_DUMMY_189 = 0x010008b6,
  NA_SE_VO_DUMMY_190 = 0x010008b7,
  NA_SE_VO_DUMMY_191 = 0x010008b8,
  NA_SE_VO_DUMMY_192 = 0x010008b9,
  NA_SE_VO_DUMMY_193 = 0x010008ba,
  NA_SE_VO_DUMMY_194 = 0x010008bb,
  NA_SE_VO_DUMMY_195 = 0x010008bc,
  NA_SE_VO_DUMMY_196 = 0x010008bd,
  NA_SE_VO_DUMMY_197 = 0x010008be,
  NA_SE_VO_DUMMY_198 = 0x010008bf,
  NA_SE_VO_DUMMY_199 = 0x010008c0,
  NA_SE_VO_DUMMY_200 = 0x010008c1,
  NA_SE_VO_DUMMY_201 = 0x010008c2,
  NA_SE_VO_DUMMY_202 = 0x010008c3,
  NA_SE_VO_DUMMY_203 = 0x010008c4,
  NA_SE_VO_DUMMY_204 = 0x010008c5,
  NA_SE_VO_DUMMY_205 = 0x010008c6,
  NA_SE_VO_DUMMY_206 = 0x010008c7,
  NA_SE_VO_DUMMY_207 = 0x010008c8,
  NA_SE_VO_DUMMY_208 = 0x010008c9,
  NA_SE_VO_DUMMY_209 = 0x010008ca,
  NA_SE_VO_DUMMY_210 = 0x010008cb,
  NA_SE_VO_DUMMY_211 = 0x010008cc,
  NA_SE_VO_DUMMY_212 = 0x010008cd,
  NA_SE_VO_DUMMY_213 = 0x010008ce,
  NA_SE_VO_DUMMY_214 = 0x010008cf,
  NA_SE_VO_DUMMY_215 = 0x010008d0,
  NA_SE_VO_DUMMY_216 = 0x010008d1,
  NA_SE_VO_DUMMY_217 = 0x010008d2,
  NA_SE_VO_DUMMY_218 = 0x010008d3,
  NA_SE_VO_DUMMY_219 = 0x010008d4,
  NA_SE_VO_DUMMY_220 = 0x010008d5,
  NA_SE_VO_DUMMY_221 = 0x010008d6,
  NA_SE_VO_DUMMY_222 = 0x010008d7,
  NA_SE_VO_DUMMY_223 = 0x010008d8,
  NA_SE_VO_LI_POO_WAIT = 0x010008d9,
  NA_SE_VO_DUMMY_225 = 0x010008da,
  NA_SE_VO_DUMMY_226 = 0x010008db,
  NA_SE_VO_DUMMY_227 = 0x010008dc,
  NA_SE_VO_DUMMY_228 = 0x010008dd,
  NA_SE_VO_DUMMY_229 = 0x010008de,
  NA_SE_VO_DUMMY_230 = 0x010008df,
  NA_SE_VO_DUMMY_231 = 0x010008e0,
  NA_SE_VO_DUMMY_232 = 0x010008e1,
  NA_SE_VO_DUMMY_233 = 0x010008e2,
  NA_SE_VO_DUMMY_234 = 0x010008e3,
  NA_SE_VO_DUMMY_235 = 0x010008e4,
  NA_SE_VO_DUMMY_236 = 0x010008e5,
  NA_SE_VO_DUMMY_237 = 0x010008e6,
  NA_SE_VO_DUMMY_238 = 0x010008e7,
  NA_SE_VO_DUMMY_239 = 0x010008e8,
  NA_SE_VO_DUMMY_240 = 0x010008e9,
  NA_SE_VO_DUMMY_241 = 0x010008ea,
  NA_SE_VO_DUMMY_242 = 0x010008eb,
  NA_SE_VO_DUMMY_243 = 0x010008ec,
  NA_SE_VO_DUMMY_244 = 0x010008ed,
  NA_SE_VO_DUMMY_245 = 0x010008ee,
  NA_SE_VO_DUMMY_246 = 0x010008ef,
  NA_SE_VO_DUMMY_247 = 0x010008f0,
  NA_SE_VO_DUMMY_248 = 0x010008f1,
  NA_SE_VO_DUMMY_249 = 0x010008f2,
  NA_SE_VO_DUMMY_250 = 0x010008f3,
  NA_SE_VO_DUMMY_251 = 0x010008f4,
  NA_SE_VO_DUMMY_252 = 0x010008f5,
  NA_SE_VO_DUMMY_253 = 0x010008f6,
  NA_SE_VO_DUMMY_254 = 0x010008f7,
  NA_SE_VO_DUMMY_255 = 0x010008f8,
  NA_SE_VO_JMVO02 = 0x010008f9,
  NA_SE_VO_JMVO04 = 0x010008fa,
  NA_SE_VO_CDVO00 = 0x010008fb,
  NA_SE_VO_CDVO01 = 0x010008fc,
  NA_SE_VO_CDVO02 = 0x010008fd,
  NA_SE_VO_CDVO03 = 0x010008fe,
  NA_SE_VO_BBVO00 = 0x010008ff,
  NA_SE_VO_BBVO01 = 0x01000900,
  NA_SE_VO_BBVO02 = 0x01000901,
  NA_SE_VO_BBVO03 = 0x01000902,
  NA_SE_VO_BBVO04 = 0x01000903,
  NA_SE_VO_BBVO05 = 0x01000904,
  NA_SE_VO_OBVO01 = 0x01000905,
  NA_SE_VO_ARVO00 = 0x01000906,
  NA_SE_VO_ARVO01 = 0x01000907,
  NA_SE_VO_MMVO00 = 0x01000908,
  NA_SE_VO_MMVO01 = 0x01000909,
  NA_SE_VO_MMVO02 = 0x0100090a,
  NA_SE_VO_MMVO03 = 0x0100090b,
  NA_SE_VO_MMVO04 = 0x0100090c,
  NA_SE_VO_MMVO05 = 0x0100090d,
  NA_SE_VO_ABVO00 = 0x0100090e,
  NA_SE_VO_ABVO01 = 0x0100090f,
  NA_SE_VO_NPVO00 = 0x01000910,
  NA_SE_VO_FPVO00 = 0x01000911,
  NA_SE_VO_FPVO01 = 0x01000912,
  NA_SE_VO_FPVO02 = 0x01000913,
  NA_SE_VO_FPVO03 = 0x01000914,
  NA_SE_VO_ROVO01 = 0x01000915,
  NA_SE_VO_ROVO02 = 0x01000916,
  NA_SE_VO_RYVO01 = 0x01000917,
  NA_SE_VO_RYVO02 = 0x01000918,
  NA_SE_VO_RYVO03 = 0x01000919,
  NA_SE_VO_RYVO04 = 0x0100091a,
  NA_SE_VO_ANVO00 = 0x0100091b,
  NA_SE_VO_ANVO01 = 0x0100091c,
  NA_SE_VO_ANVO02 = 0x0100091d,
  NA_SE_VO_ANVO03 = 0x0100091e,
  NA_SE_VO_CRVO00 = 0x0100091f,
  NA_SE_VO_CRVO01 = 0x01000920,
  NA_SE_VO_CRVO02 = 0x01000921,
  NA_SE_VO_CRVO03 = 0x01000922,
  NA_SE_VO_HNVO00 = 0x01000923,
  NA_SE_VO_HNVO01 = 0x01000924,
  NA_SE_VO_HNVO02 = 0x01000925,
  NA_SE_VO_RMVO00 = 0x01000926,
  NA_SE_VO_RMVO01 = 0x01000927,
  NA_SE_VO_RMVO02 = 0x01000928,
  NA_SE_VO_PMVO01 = 0x01000929,
  NA_SE_VO_PMVO02 = 0x0100092a,
  NA_SE_VO_PMVO03 = 0x0100092b,
  NA_SE_VO_DHVO00 = 0x0100092c,
  NA_SE_VO_DHVO01 = 0x0100092d,
  NA_SE_VO_DHVO02 = 0x0100092e,
  NA_SE_VO_DHVO03 = 0x0100092f,
  NA_SE_VO_DHVO04 = 0x01000930,
  NA_SE_VO_TFVO00 = 0x01000931,
  NA_SE_VO_ANVO04 = 0x01000932,
  NA_SE_VO_ANVO05 = 0x01000933,
  NA_SE_VO_PMVO00 = 0x01000934,
  NA_SE_VO_CHVO03 = 0x01000935,
  NA_SE_VO_CHVO04 = 0x01000936,
  NA_SE_VO_CHVO05 = 0x01000937,
  NA_SE_VO_CHVO06 = 0x01000938,
  NA_SE_VO_CHVO07 = 0x01000939,
  NA_SE_VO_CHVO08 = 0x0100093a,
  NA_SE_VO_CHVO09 = 0x0100093b,
  NA_SE_VO_DPVO00 = 0x0100093c,
  NA_SE_VO_DPVO01 = 0x0100093d,
  NA_SE_VO_DPVO02 = 0x0100093e,
  NA_SE_VO_SKVO00 = 0x0100093f,
  NA_SE_VO_SKVO01 = 0x01000940,
  NA_SE_VO_KHVO00 = 0x01000941,
  NA_SE_VO_KHVO01 = 0x01000942,
  NA_SE_VO_KHVO02 = 0x01000943,
  NA_SE_VO_SHVO00 = 0x01000944,
  NA_SE_VO_SHVO01 = 0x01000945,
  NA_SE_VO_KAVO02 = 0x01000946,
  NA_SE_VO_KAVO03 = 0x01000947,
  NA_SE_VO_MTVO00 = 0x01000948,
  NA_SE_VO_TTVO00 = 0x01000949,
  NA_SE_VO_ITVO00 = 0x0100094a,
  NA_SE_VO_ITVO01 = 0x0100094b,
  NA_SE_VO_ITVO02 = 0x0100094c,
  NA_SE_VO_KMVO00 = 0x0100094d,
  NA_SE_VO_KMVO01 = 0x0100094e,
  NA_SE_VO_JOVO00 = 0x0100094f,
  NA_SE_VO_JYVO00 = 0x01000950,
  NA_SE_VO_DTVO00 = 0x01000951,
  NA_SE_VO_GUVO00 = 0x01000952,
  NA_SE_VO_KTVO00 = 0x01000953,
  NA_SE_VO_KTVO01 = 0x01000954,
  NA_SE_VO_KTVO03 = 0x01000955,
  NA_SE_VO_ZBVO00 = 0x01000956,
  NA_SE_VO_ZBVO01 = 0x01000957,
  NA_SE_VO_DAVO01 = 0x01000958,
  NA_SE_VO_SHVO04 = 0x01000959,
  NA_SE_VO_GBVO02 = 0x0100095a,
  NA_SE_VO_GBVO03 = 0x0100095b,
  NA_SE_VO_PFVO00 = 0x0100095c,
  NA_SE_VO_PFVO01 = 0x0100095d,
  NA_SE_VO_GAVO00 = 0x0100095e,
  NA_SE_VO_GAVO01 = 0x0100095f,
  NA_SE_VO_DJVO00 = 0x01000960,
  NA_SE_VO_DJVO01 = 0x01000961,
  NA_SE_VO_MSVO00 = 0x01000962,
  NA_SE_VO_MSVO01 = 0x01000963,
  NA_SE_VO_JPVO00 = 0x01000964,
  NA_SE_VO_HYVO00 = 0x01000965,
  NA_SE_VO_HYVO01 = 0x01000966,
  NA_SE_VO_BAVO00 = 0x01000967,
  NA_SE_VO_POVO00 = 0x01000968,
  NA_SE_VO_DAVO00 = 0x01000969,
  NA_SE_VO_DAVO02 = 0x0100096a,
  NA_SE_VO_MKVO00 = 0x0100096b,
  NA_SE_VO_MKVO01 = 0x0100096c,
  NA_SE_VO_MKVO02 = 0x0100096d,
  NA_SE_VO_MKVO03 = 0x0100096e,
  NA_SE_VO_MKVO04 = 0x0100096f,
  NA_SE_VO_TIVO00 = 0x01000970,
  NA_SE_VO_TIVO01 = 0x01000971,
  NA_SE_VO_TIVO02 = 0x01000972,
  NA_SE_VO_TIVO03 = 0x01000973,
  NA_SE_VO_TIVO04 = 0x01000974,
  NA_SE_VO_TIVO05 = 0x01000975,
  NA_SE_VO_OMVO00 = 0x01000976,
  NA_SE_VO_OMVO01 = 0x01000977,
  NA_SE_VO_OMVO02 = 0x01000978,
  NA_SE_VO_OMVO03 = 0x01000979,
  NA_SE_VO_OMVO04 = 0x0100097a,
  NA_SE_VO_OMVO05 = 0x0100097b,
  NA_SE_VO_OMVO06 = 0x0100097c,
  NA_SE_VO_DEMO_FALL2 = 0x0100097d,
  NA_SE_VO_DEMO_384 = 0x0100097e,
  NA_SE_VO_DEMO_385 = 0x0100097f,
  NA_SE_VO_DEMO_386 = 0x01000980,
  NA_SE_VO_DEMO_387 = 0x01000981,
  NA_SE_VO_DEMO_388 = 0x01000982,
  NA_SE_VO_DEMO_389 = 0x01000983,
  NA_SE_VO_DEMO_390 = 0x01000984,
  NA_BGM_DEMO_SE_SEQ = 0x01000985,
  NA_BGM_DEMO_SE_SEQ_1 = 0x01000986,
  NA_BGM_DEMO_SE_SEQ_2 = 0x01000987,
  NA_BGM_DEMO_SE_SEQ_3 = 0x01000988,
  NA_BGM_DEMO_SE_SEQ_4 = 0x01000989,
  NA_BGM_DEMO_SE_SEQ_5 = 0x0100098a,
  NA_BGM_DEMO_SE_SEQ_6 = 0x0100098b,
  NA_BGM_DEMO_SE_SEQ_7 = 0x0100098c,
  NA_BGM_DEMO_SE_SEQ_8 = 0x0100098d,
  NA_BGM_DEMO_SE_SEQ_9 = 0x0100098e,
  NA_BGM_DEMO_SE_SEQ_A = 0x0100098f,
  NA_BGM_DEMO_SE_SEQ_B = 0x01000990,
  NA_BGM_DEMO_SE_SEQ_C = 0x01000991,
  NA_BGM_DEMO_SE_SEQ_D = 0x01000992,
  NA_BGM_DEMO_SE_SEQ_E = 0x01000993,
  NA_BGM_DEMO_SE_SEQ_F = 0x01000994,
  NA_SE_EN_MIBOSS_FALL = 0x01000995,
  NA_SE_EN_MIBOSS_DAMAGE = 0x01000996,
  NA_SE_EN_MIBOSS_DASH = 0x01000997,
  NA_SE_EN_MIBOSS_DEAD = 0x01000998,
  NA_SE_EN_MIBOSS_GND1 = 0x01000999,
  NA_SE_EN_MIBOSS_GND2 = 0x0100099a,
  NA_SE_EN_MIBOSS_UNARI = 0x0100099b,
  NA_SE_EN_MIBOSS_RHYTHM = 0x0100099c,
  NA_SE_EN_MIBOSS_SWORD = 0x0100099d,
  NA_SE_EN_MIBOSS_JUMP1_NOTUSE = 0x0100099e,
  NA_SE_EN_MIBOSS_JUMP2_NOTUSE = 0x0100099f,
  NA_SE_EN_MIBOSS_VOICE1 = 0x010009a0,
  NA_SE_EN_MIBOSS_VOICE2 = 0x010009a1,
  NA_SE_EN_MIBOSS_VOICE3 = 0x010009a2,
  NA_SE_EN_MIBOSS_FAINT = 0x010009a3,
  NA_SE_EN_MIBOSS_ROLLING = 0x010009a4,
  NA_SE_EN_MIBOSS_FREEZE = 0x010009a5,
  NA_SE_EN_MIBOSS_APPEAR_B = 0x010009a6,
  NA_SE_EN_MIBOSS_KICK = 0x010009a7,
  NA_SE_EN_MIBOSS_HEADDOWN = 0x010009a8,
  NA_SE_EN_MIBOSS_LEGDOWN = 0x010009a9,
  NA_SE_EN_MIBOSS_WEAKWAIT = 0x010009aa,
  NA_SE_EN_MIBOSS_THRUST1 = 0x010009ab,
  NA_SE_EN_MIBOSS_JUMP3 = 0x010009ac,
  NA_SE_EN_MIBOSS_SWORD_ROLL = 0x010009ad,
  NA_SE_EN_MIBOSS_DANCE_THRUST = 0x010009ae,
  NA_SE_EN_MIBOSS_DANCE_FIRE = 0x010009af,
  NA_SE_EN_ICEB_FOOTSTEP = 0x010009b0,
  NA_SE_EN_ICEB_CRY = 0x010009b1,
  NA_SE_EN_ICEB_STEAM_LONG = 0x010009b2,
  NA_SE_EN_ICEB_STEAMS_DEMO = 0x010009b3,
  NA_SE_EN_ICEB_STEAM_DEMO_UP = 0x010009b4,
  NA_SE_EN_ICEB_DEAD = 0x010009b5,
  NA_SE_EN_ICEB_DAMAGE = 0x010009b6,
  NA_SE_EN_ICEB_SLIDING = 0x010009b7,
  NA_SE_EN_ICEB_BACK_ATTACK2 = 0x010009b8,
  NA_SE_EN_KONB_BITE = 0x010009b9,
  NA_SE_EN_KONB_BOUND = 0x010009ba,
  NA_SE_EN_KONB_BOUND2 = 0x010009bb,
  NA_SE_EN_KONB_DAMAGE = 0x010009bc,
  NA_SE_EN_KONB_DEAD = 0x010009bd,
  NA_SE_EN_KONB_DEAD2 = 0x010009be,
  NA_SE_EN_KONB_DEAD_JUMP = 0x010009bf,
  NA_SE_EN_KONB_DEAD_JUMP2 = 0x010009c0,
  NA_SE_EN_KONB_DEMO_MOVE = 0x010009c1,
  NA_SE_EN_KONB_INIT = 0x010009c2,
  NA_SE_EN_KONB_JUMP = 0x010009c3,
  NA_SE_EN_KONB_JUMP_LEV = 0x010009c4,
  NA_SE_EN_KONB_LANDING = 0x010009c5,
  NA_SE_EN_KONB_MINI_APPEAR_NOTUSE = 0x010009c6,
  NA_SE_EN_KONB_PIYORI = 0x010009c7,
  NA_SE_EN_KONB_PREATTACK = 0x010009c8,
  NA_SE_EN_KONB_SIBUKI = 0x010009c9,
  NA_SE_EN_KONB_SINK = 0x010009ca,
  NA_SE_EN_KONB_WAIT = 0x010009cb,
  NA_SE_EN_KONB_DODAI_FALL = 0x010009cc,
  NA_SE_EN_KONB_SUIKOMU = 0x010009cd,
  NA_SE_EN_KONB_TABERU = 0x010009ce,
  NA_SE_EN_KONB_TOBIDASU = 0x010009cf,
  NA_SE_EN_KONB_TOSSIN1_KAMAE = 0x010009d0,
  NA_SE_EN_KONB_TOSSIN1_DASH = 0x010009d1,
  NA_SE_EN_KONB_TOSSIN1_TYAKUSUI = 0x010009d2,
  NA_SE_EN_KONB_BOMB1_INSIDE = 0x010009d3,
  NA_SE_EN_KONB_BOMB1_OUTSIDE = 0x010009d4,
  NA_SE_EN_KONB_MEDAMA_APPEAR = 0x010009d5,
  NA_SE_EN_KONB_BOMB_CHAIN = 0x010009d6,
  NA_SE_EN_KONB_CHIAN_SLASH = 0x010009d7,
  NA_SE_EN_KONB_INFO_SAKEBI = 0x010009d8,
  NA_SE_EN_KONB_INFO_SAKEBI_LONG = 0x010009d9,
  NA_SE_EN_KONB_DODAI_ATTACK1 = 0x010009da,
  NA_SE_EN_KONB_DODAI_ATTACK2 = 0x010009db,
  NA_SE_EN_KONB_TAORE = 0x010009dc,
  NA_SE_EN_INBOSS_SAND = 0x010009dd,
  NA_SE_EN_INBOSS_ROAR = 0x010009de,
  NA_SE_EN_INBOSS_DAMAGE = 0x010009df,
  NA_SE_EN_INBOSS_DEAD_PRE2 = 0x010009e0,
  NA_SE_EN_INBOSS_DEAD = 0x010009e1,
  NA_SE_EN_INBOSS_DOWN_PRE = 0x010009e2,
  NA_SE_EN_INBOSS_BRESS_PRE = 0x010009e3,
  NA_SE_EN_INBOSS_SANRAN = 0x010009e4,
  NA_SE_EN_INBOSS_CHIBI_WALK = 0x010009e5,
  NA_SE_EN_INBOSS_CHIBI_DAMAGE = 0x010009e6,
  NA_SE_EN_INBOSS_CHIBI_DEAD = 0x010009e7,
  NA_SE_EN_INBOSS_CHIBI_RUN = 0x010009e8,
  NA_SE_EN_INBOSS_JIMEN_MORI = 0x010009e9,
  NA_SE_EN_INBOSS_JIMEN_DERU = 0x010009ea,
  NA_SE_EN_INBOSS_UNDER_MOVE = 0x010009eb,
  NA_SE_EN_INBOSS_BREATH = 0x010009ec,
  NA_SE_EN_INBOSS_DAMAGE_MOVE = 0x010009ed,
  NA_SE_EN_INBOSS_MEDAMA_DERU = 0x010009ee,
  NA_SE_EN_INBOSS_FIREBALL_FLY = 0x010009ef,
  NA_SE_EN_INBOSS_SANRAN_SHORT = 0x010009f0,
  NA_SE_EN_INBOSS_DOWN = 0x010009f1,
  NA_SE_EN_INBOSS_DEAD_RED = 0x010009f2,
  NA_SE_EN_INBOSS_TAME = 0x010009f3,
  NA_SE_EN_LAST1_ATTACK = 0x010009f4,
  NA_SE_EN_LAST1_ATTACK_2ND = 0x010009f5,
  NA_SE_EN_LAST1_BEAM = 0x010009f6,
  NA_SE_EN_LAST1_BEAM2 = 0x010009f7,
  NA_SE_EN_LAST1_BLOW = 0x010009f8,
  NA_SE_EN_LAST1_DAMAGE1 = 0x010009f9,
  NA_SE_EN_LAST1_DAMAGE2 = 0x010009fa,
  NA_SE_EN_LAST1_DEAD = 0x010009fb,
  NA_SE_EN_LAST1_DEMO_BREAK_NOUSE = 0x010009fc,
  NA_SE_EN_LAST1_DEMO_WALL_NOUSE = 0x010009fd,
  NA_SE_EN_LAST1_FALL = 0x010009fe,
  NA_SE_EN_LAST1_FLOAT = 0x010009ff,
  NA_SE_EN_LAST1_GROW_HEAD_NOTUSE = 0x01000a00,
  NA_SE_EN_LAST1_ROLLING = 0x01000a01,
  NA_SE_EN_LAST1_TRANSFORM_NOTUSE = 0x01000a02,
  NA_SE_EN_LAST2_BALLET = 0x01000a03,
  NA_SE_EN_LAST2_BIRD = 0x01000a04,
  NA_SE_EN_LAST2_BIRD2 = 0x01000a05,
  NA_SE_EN_LAST2_DAMAGE = 0x01000a06,
  NA_SE_EN_LAST2_DAMAGE2 = 0x01000a07,
  NA_SE_EN_LAST2_DEAD = 0x01000a08,
  NA_SE_EN_LAST2_FIRE = 0x01000a09,
  NA_SE_EN_LAST2_GROW_HEAD = 0x01000a0a,
  NA_SE_EN_LAST2_VOICE_UAUOO2 = 0x01000a0b,
  NA_SE_EN_LAST2_GYM_B = 0x01000a0c,
  NA_SE_EN_LAST2_HEARTBEAT = 0x01000a0d,
  NA_SE_EN_LAST2_JUMP = 0x01000a0e,
  NA_SE_EN_LAST2_VOICE_UAUOO1 = 0x01000a0f,
  NA_SE_EN_LAST2_MOONWALK = 0x01000a10,
  NA_SE_EN_LAST2_PUMP_UP = 0x01000a11,
  NA_SE_EN_LAST2_SHOUT_NOTUSE = 0x01000a12,
  NA_SE_EN_LAST2_VOICE_SURPRISED = 0x01000a13,
  NA_SE_EN_LAST2_UAUOO = 0x01000a14,
  NA_SE_EN_LAST2_WAIT = 0x01000a15,
  NA_SE_EN_LAST2_WALK = 0x01000a16,
  NA_SE_EN_LAST2_WALK2 = 0x01000a17,
  NA_SE_EN_LAST3_COIL_ATTACK = 0x01000a18,
  NA_SE_EN_LAST3_VOICE_DAMAGE = 0x01000a19,
  NA_SE_EN_LAST3_VOICE_DAMAGE2 = 0x01000a1a,
  NA_SE_EN_LAST3_VOICE_DEAD = 0x01000a1b,
  NA_SE_EN_LAST3_DEAD_DEAD1 = 0x01000a1c,
  NA_SE_EN_LAST3_DEAD_DEAD2 = 0x01000a1d,
  NA_SE_EN_LAST3_DEAD_FLOAT_NOTUSE = 0x01000a1e,
  NA_SE_EN_LAST3_DEAD_LIGHTS = 0x01000a1f,
  NA_SE_EN_LAST3_DEAD_ROD_NOTUSE = 0x01000a20,
  NA_SE_EN_LAST3_DEAD_WIND1 = 0x01000a21,
  NA_SE_EN_LAST3_DEAD_WIND2 = 0x01000a22,
  NA_SE_EN_LAST3_DEAD_WIND3 = 0x01000a23,
  NA_SE_EN_LAST3_GET_LINK = 0x01000a24,
  NA_SE_EN_LAST3_VOICE_KICK = 0x01000a25,
  NA_SE_EN_LAST3_KOMA = 0x01000a26,
  NA_SE_EN_LAST3_ROD_DANCE = 0x01000a27,
  NA_SE_EN_LAST3_ROD_MID = 0x01000a28,
  NA_SE_EN_LAST3_ROD_FLOOR = 0x01000a29,
  NA_SE_EN_LAST3_ROD_HOP = 0x01000a2a,
  NA_SE_EN_LAST3_ROD_HOP2 = 0x01000a2b,
  NA_SE_EN_LAST3_ROD_WIND = 0x01000a2c,
  NA_SE_EN_LAST3_VOICE_KOMA = 0x01000a2d,
  NA_SE_EN_LAST3_VOICE_ROD = 0x01000a2e,
  NA_SE_EN_LAST3_VOICE_THROW = 0x01000a2f,
  NA_SE_EN_LAST3_VOICE_LAUGH = 0x01000a30,
  NA_SE_EN_LAST1_SIZZLE = 0x01000a31,
  NA_SE_EN_LAST1_LAND2 = 0x01000a32,
  NA_SE_EN_LAST3_WHIP1 = 0x01000a33,
  NA_SE_EV_LAVA_HIT = 0x01000a34,
  NA_SE_EV_LAVA_WHOOSH = 0x01000a35,
  Wind_seq1 = 0x01000a36,
  Bird_seqs = 0x01000a37,
  Rain_seq0 = 0x01000a38,
  Thun_seq0 = 0x01000a39,
  NA_BGM_OCA_EPONA_SEQ = 0x01000a3a,
  NA_BGM_OCA_TIME_SEQ = 0x01000a3b,
  NA_BGM_OCA_STORM_SEQ = 0x01000a3c,
  NA_BGM_OCA_BIGWING_SEQ = 0x01000a3d,
  NA_BGM_OCA_TIME_SPEED_SEQ = 0x01000a3e,
  NA_BGM_OCA_TIME_JUMP_SEQ = 0x01000a3f,
  NA_BGM_OCA_AWAKING_SEQ = 0x01000a40,
  NA_BGM_OCA_CURE_SEQ = 0x01000a41,
  NA_BGM_OCA_LULLABY_HALF_SEQ = 0x01000a42,
  NA_BGM_OCA_LULLABY_SEQ = 0x01000a43,
  NA_BGM_OCA_PLEDGE_SEQ = 0x01000a44,
  NA_BGM_OCA_TIDE_SEQ = 0x01000a45,
  NA_BGM_OCA_SHELL_SEQ = 0x01000a46,
  NA_BGM_GERO_SEQ = 0x01000a47,
};

bool PlayEffect(EffectId id);
bool PlayEffect(const Vec3& position, EffectId id);
bool PlayEffect(const act::Actor& actor, EffectId id);

enum class StreamPlayer : u32 {
  // Mostly used for BGMs
  DEFAULT_PLAYER = 0,
  // Used for some cutscene sounds (e.g. ISoT or SoT cutscene, heart get)
  FAN_PLAYER = 1,
  EXTRA_PLAYER = 2,
  // Used for the morning song and for the battle theme
  PLAYER_SE_EXTRA = 3,
};

enum class StreamId : u32 {
  NA_BGM_DUMMY_NO_BGM = 0x01000000,
  NA_BGM_NA_SEQUENCE = 0x01000001,
  NA_BGM_FIELD = 0x01000002,
  NA_BGM_CHASE = 0x01000003,
  NA_BGM_STALKID = 0x01000004,
  NA_BGM_CLOCK_TOWER = 0x01000005,
  NA_BGM_RUIN_DUNGEON_FRONT = 0x01000006,
  NA_BGM_RUIN_DUNGEON_REVERSE = 0x01000007,
  NA_BGM_FAILURE_0 = 0x01000008,
  NA_BGM_FAILURE_1 = 0x01000009,
  NA_BGM_OMENYA = 0x0100000a,
  NA_BGM_DEMO_CURE = 0x0100000b,
  NA_BGM_DAMP_AREA = 0x0100000c,
  NA_BGM_UFO = 0x0100000d,
  NA_BGM_JUNGLE_CREWS = 0x0100000e,
  NA_BGM_SHARP = 0x0100000f,
  NA_BGM_SEA_AREA = 0x01000010,
  NA_BGM_IKANA_AREA = 0x01000011,
  NA_BGM_DEKU_KING = 0x01000012,
  NA_BGM_SNOW_AREA = 0x01000013,
  NA_BGM_PIRATE_AREA = 0x01000014,
  NA_BGM_DUMMY_21 = 0x01000015,
  NA_BGM_DUMMY_22 = 0x01000016,
  NA_BGM_DUMMY_23 = 0x01000017,
  NA_BGM_FILE_SELECT = 0x01000018,
  NA_BGM_EVENT_CLEAR = 0x01000019,
  NA_BGM_ENEMY = 0x0100001a,
  NA_BGM_BOSS00 = 0x0100001b,
  NA_BGM_JUNGLE_DUNGEON = 0x0100001c,
  NA_BGM_MARKET = 0x0100001d,
  NA_BGM_OPENING = 0x0100001e,
  NA_BGM_LINK_HOUSE = 0x0100001f,
  NA_BGM_GAME_OVER = 0x01000020,
  NA_BGM_BOSS_CLEAR = 0x01000021,
  NA_BGM_ITEM_GET = 0x01000022,
  NA_BGM_GATE_OPEN = 0x01000023,
  NA_BGM_HEART_GET = 0x01000024,
  NA_BGM_MINI_GAME_2 = 0x01000025,
  NA_BGM_GORON_RACE = 0x01000026,
  NA_BGM_ORGEL_HOUSE = 0x01000027,
  NA_BGM_GODESS = 0x01000028,
  NA_BGM_HIME = 0x01000029,
  NA_BGM_SISTER_DANCER = 0x0100002a,
  NA_BGM_OPEN_TRE_BOX = 0x0100002b,
  NA_BGM_DRUGSTORE = 0x0100002c,
  NA_BGM_KYOJIN_ROOM = 0x0100002d,
  NA_BGM_FUSHA = 0x0100002e,
  NA_BGM_RONRON = 0x0100002f,
  NA_BGM_GORON = 0x01000030,
  NA_BGM_MEETING = 0x01000031,
  NA_BGM_OCA_EPONA = 0x01000032,
  NA_BGM_OCA_SUN = 0x01000033,
  NA_BGM_OCA_TIME_NORMAL = 0x01000034,
  NA_BGM_OCA_STORM = 0x01000035,
  NA_BGM_ZORA = 0x01000036,
  NA_BGM_MASK_GET = 0x01000037,
  NA_BGM_MIDDLE_BOSS = 0x01000038,
  NA_BGM_S_ITEM_GET = 0x01000039,
  NA_BGM_TENMONDAI = 0x0100003a,
  NA_BGM_NORMAL_DUNGEON = 0x0100003b,
  NA_BGM_MILK_BAR = 0x0100003c,
  NA_BGM_APPEAR = 0x0100003d,
  NA_BGM_MAYOIMORI = 0x0100003e,
  NA_BGM_GORON_GOAL = 0x0100003f,
  NA_BGM_HORSE = 0x01000040,
  NA_BGM_HORSE_GOAL = 0x01000041,
  NA_BGM_INGO = 0x01000042,
  NA_BGM_KOTAKE_KOUME = 0x01000043,
  NA_BGM_SHOP = 0x01000044,
  NA_BGM_OWL = 0x01000045,
  NA_BGM_MINI_GAME = 0x01000046,
  NA_BGM_OCA_BIGWING = 0x01000047,
  NA_BGM_OCA_CURE = 0x01000048,
  NA_BGM_TIME_SPEED = 0x01000049,
  NA_BGM_TIME_JUMP = 0x0100004a,
  NA_BGM_DEMO_AWAKING = 0x0100004b,
  NA_BGM_DEMO_LULLABY = 0x0100004c,
  NA_BGM_DEMO_TIDE = 0x0100004d,
  NA_BGM_DEMO_SHELL = 0x0100004e,
  NA_BGM_DEMO_PLEDGE = 0x0100004f,
  NA_BGM_EXERCISE_HALL = 0x01000050,
  NA_BGM_DEMO_LULLABY_HALF = 0x01000051,
  NA_BGM_OCA_YOUSEI = 0x01000052,
  NA_BGM_FACEMASK = 0x01000053,
  NA_BGM_QUARTET = 0x01000054,
  NA_BGM_WING_WARP = 0x01000055,
  NA_BGM_MILK_BAR_DUMMY = 0x01000056,
  NA_BGM_TIME_LIMIT = 0x01000057,
  NA_BGM_MIKAU_LIFF = 0x01000058,
  NA_BGM_MIKAU_FIN = 0x01000059,
  NA_BGM_FROG_SONG = 0x0100005a,
  NA_BGM_OCA_AWAKING = 0x0100005b,
  NA_BGM_OCA_LULLABY = 0x0100005c,
  NA_BGM_OCA_TIDE = 0x0100005d,
  NA_BGM_OCA_SHELL = 0x0100005e,
  NA_BGM_OCA_PLEDGE = 0x0100005f,
  NA_BGM_LAST_DUNGEON = 0x01000060,
  NA_BGM_OCA_LULLABY_HALF = 0x01000061,
  NA_BGM_OCA_SESSION = 0x01000062,
  NA_BGM_DEMO_SESSION = 0x01000063,
  NA_BGM_ALLPART_SESSION = 0x01000064,
  NA_BGM_SILVER_DUNGEON = 0x01000065,
  NA_BGM_DEEPBLUE_DUNGEON = 0x01000066,
  NA_BGM_DEMO_TIDE_SAX = 0x01000067,
  NA_BGM_DEMO_TIDE_VOCAL = 0x01000068,
  NA_BGM_MUJURA_1 = 0x01000069,
  NA_BGM_MUJURA_2 = 0x0100006a,
  NA_BGM_MUJURA_3 = 0x0100006b,
  NA_BGM_BASS_PLAY = 0x0100006c,
  NA_BGM_DRUMS_PLAY = 0x0100006d,
  NA_BGM_PIANO_PLAY = 0x0100006e,
  NA_BGM_IKANA_CASTLE = 0x0100006f,
  NA_BGM_GATHERING = 0x01000070,
  NA_BGM_CAMARO_DANCE = 0x01000071,
  NA_BGM_DONKEY_CART = 0x01000072,
  NA_BGM_QUIZ = 0x01000073,
  NA_BGM_END_DEMO = 0x01000074,
  NA_BGM_OPENING_LOOP = 0x01000075,
  NA_BGM_TITLE = 0x01000076,
  NA_BGM_DUNGEON_APPEAR = 0x01000077,
  NA_BGM_PURIFICATION_0 = 0x01000078,
  NA_BGM_PURIFICATION_1 = 0x01000079,
  NA_BGM_STANDBY = 0x0100007a,
  NA_BGM_INTO_THE_MOON = 0x0100007b,
  NA_BGM_GOODBYE_GIANT = 0x0100007c,
  NA_BGM_CHAT = 0x0100007d,
  NA_BGM_MOON_VANISH = 0x0100007e,
  NA_BGM_OCA_MUS = 0x0100007f,
  NA_BGM_DEMO_SE_SEQ_OLD = 0x01000080,
  NA_BGM_FISHING1 = 0x01000081,
  NA_BGM_STAFFROLL2 = 0x01000082,
  NA_BGM_M_BARQUARTET = 0x01000083,
  NA_BGM_M_BARQUARTET_ALL = 0x01000084,
  NA_BGM_ZORA_SESSION = 0x01000085,
  NA_BGM_YOAKE = 0x01000086,
  NA_SE_DEMO_KAME_APPEAR1 = 0x01000087,
  NA_SE_DEMO_KAME_START = 0x01000088,
  NA_SE_DEMO_ARASI1 = 0x01000089,
  NA_SE_DEMO_KAME_LAND = 0x0100008a,
  NA_SE_DEMO_KAME_APPEAR_SHORT = 0x0100008b,
  None = 0xffffffff,
};

bool PlayStream(StreamId id, StreamPlayer player = StreamPlayer::FAN_PLAYER);
StreamId GetCurrentStreamId(StreamPlayer player);
void ControlStream(StreamPlayer player, int a, int b);

void ControlEnv(int index);

}  // namespace game::sound
