# Contributing to MeetingBar

We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

*   Reporting a bug
*   Discussing the current state of the code
*   Submitting a fix
*   Proposing new features
*   Becoming a maintainer

## We Develop with GitHub

We use GitHub to host code, to track issues and feature requests, as well as accept pull requests.

## Report bugs using GitHub's [issues](https://github.com/leits/MeetingBar/issues)

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/leits/MeetingBar/issues/new); it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

*   A quick summary and/or background
*   Steps to reproduce
    *   Be specific!
*   What you expected would happen
*   What actually happens
*   Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People *love* thorough bug reports. I'm not even kidding.

## Building locally

To build MeetingBar on your computer, you need to configure the project to use your own Apple-supplied development team. You can do this *without making changes to the Xcode project*, by creating the plain-text file `XCConfig/DevTeamOverride.xcconfig` containing the following:

    DEVELOPMENT_TEAM = <your development team id here>"

## License

By contributing, you agree that your contributions will be licensed under its Apache License 2.0.
