# Changelog for Meetingbar

For next releases info look here: <https://github.com/leits/MeetingBar/releases>

## Version 4.0.0

> (released)

> Direct integration with Google Calendar API

*   Added integration with Pop, Livestorm, Chorus & Gong
*   Fix readability of the statusbar text in multi-screen setups (#354)
*   Detect hidden menubar icon (#429)
*   Added feature to snooze the notification
*   Fix crash due to meeting attendees without an email address (#460)

## Version 3.10.0

> (released 25 Jan 2022)

*   Added translations into Turkish
*   Integrations with Facetime, Vimeo Showcases, and oVice
*   New "Refresh source" Quick Action

## Version 3.9.0

> (released 20th Nov 2021)

*   Added translations into Hebrew
*   Advanced feature to filter out events by regex
*   Added integration with Zhumu/WeMeeting, Lark, and Feishu
    and small bug fixes

## Version 3.8.0

> (released 15th Sep 2021)

*   Added translations into Polish
*   Support MeetInOne for Google Meet links
*   Support Jitsi native app for Jitsi links
*   Open the link from the event link field if the meeting service is not recognized

## Version 3.7.0

> (released 19th Aug 2021)

*   Added copy meeting link & email attendees from event submenu
*   Round the timer up, not down
*   Made event start soon notification more specified
*   Added translations into Japanese

## Version 3.6.0

> (released 15th Jun 2021)

*   Added translations into Czech
*   Added integration with Vowel
*   Fixed zoom link detection bug from 3.5 version

## Version 3.5.0

> (released 11th Jun 2021)

*   Added translations into Croatian, German, French, and Norwegian Bokmål
*   Improve RingCentral and Zoom links Detection
*   All app notifications are now removed after all meetings are over
*   Open link from clipboard in configured browser
*   Fixed a bug with the inability to change shortcuts
*   Fixed disappearing app icon when no calendar selected
*   Fixed opening ZoomGov links in the native app

## Version 3.4.0

> (released 12th May 2021)

*   📋 New view of notes in the event submenu with selectable text and clickable links
*   🧭 Fixed a bug with opening meetings in a new browser instance

and small bug fixes

## Version 3.3.0

> (released 1st May 2021)

*   Fixed bug with timer freeze ⏱️
*   Browser management 🧰
*   Quick Actions ⚡
    *   Show/hide meeting title in status bar
    *   Open meeting from clipboard
*   Customizable appereance for events without meeting links
*   Localization (Ukrainian and Russian)
*   Create meetings in Jam
*   Open event in Fantastical from event submenu
*   Integration with subscribed calendars

## Version 3.2.1

> (released 30th Mar 2021)

*   Fixed showing the "What's New" at the first opening.

## Version 3.2.0

> (released 25th Mar 2021)

*   Added setting to only show events starting in x minutes.
*   Recognize outlook safe links
*   Added Safari as a browser option.
*   New integrations: Discord, Jam, and Blackboard Collaborate.

and small bug fixes

## Version 3.1.2

> (released 20th Feb 2021)

Fixed blurry image and text truncating in about section

## Version 3.1.1

> (released 18th Feb 2021)

Added Contact and GitHub buttons in Preferences

Fixed:

*   Facebook Workplace links redirecting to Facebook profiles
*   Trimming special symbols at the beginning of event title
*   Text alignment issue in the menu while in 12 hr time
*   Excessive notification if next meeting is changed

## Version 3.1

> (released 11th Feb 2021)

*   Add Around integration
*   Hide show time under title option for Big Sure
*   Fix issues with service icons
*   Fix URLs for Firefox and Microsoft Edge

## Version 3.0

> (released 7th Feb 2021)

*   Patronage via In‑App Purchase

#### New features

*   ⭐ Bookmarks ⭐
    *   Add meeting links as bookmarks and join them from the menu
*   Full control of the **app appearance**:
    *   Customize icon, title, and time in the status bar
    *   Show event end time and icon in the menu
    *   Limitate event title length in the menu
*   Wider settings for **displaying events**. Configure pending events, all-day events, and events without guests.
*   **Custom link** for ad hoc meeting
*   Global shortcut to open the app
*   Support new browsers as an executable for Google Meet: Chromium, Firefox, Edge, Brave, Vivaldi, and Opera.
*   Showing alerts if notification disabled for warnings
*   Pretty rendering HTML description for events

#### New integrations

Recognize links for:

*   Facetime scheme
*   Telephone scheme
*   Zoom native app
*   Youtube
*   TeamViewer Meeting
*   Google Meet Stream
*   Vonage Meetings

#### Bugfixes

*   Fixed opening links twice on click
*   Fixed regex for self-hosted skype
*   Fixed regex for zoom
*   Fixed app icon for Big Sur

## Version 2.0.5

> (released 1st Dec 2020)

#### Bugfixes

*   Fix double menu bar icons

## Version 2.0.4

> (released 1st Dec 2020)

#### Bugfixes

*   Fixed sticking status bar icon

## Version 2.0.3

> (released 1st Dec 2020)

#### Bugfixes

*   Make notification persistent

## Version 2.0.2

> (released 27th Nov 2020)

#### New features

*   Brand new App Icon by Miroslav Rajkovic.

## Version 2.0.1

> (released 25th Nov 2020)

#### Bugfixes

*   Fixed status bar icon to match dark/light appearance

## Version 2.0

> (released 25th Nov 2020)

#### New features

*   Advanced settings! Run custom AppleScript on join to event and apply custom regexes to meeting links search
*   Small language tweak for date header
*   Creating a meeting in Google Calendar and Outlook (both personal and office 365)
*   Lifesize and Facebook Workspace integrations
*   Next event visibility time extended to 15 min
*   "3 minutes before" option for join event notification
*   Open event in the calendar from the submenu
*   New status bar icon for Big Sur

For previous versions see https://github.com/leits/MeetingBar/releases
