
# Paper List

The following papers were announced on the [learn2learn Twitter account](https://twitter.com/metalearn2learn). You can submit **unannounced** and **meta-learning related** papers through the following Google Form. (It does not matter if they are old or new, but they shouldn't be already announced.)

!!! info
    Announce any paper via the [Google Form to announce papers](https://docs.google.com/forms/d/e/1FAIpQLSeKPfYEttRKN3Lk317cxcNbU454yCTRktXpxMiK_O6PgFq22A/viewform?usp=sf_link), also available below.

## Submitted Papers

    
**Grounded Language Learning Fast and Slow**
<br />
by *Hill, Felix and Tieleman, Olivier and von Glehn, Tamara and
Wong, Nathaniel and Merzic, Hamza and Clark, Stephen*
<br />
[http://arxiv.org/abs/2009.01719](http://arxiv.org/abs/2009.01719)


**Sparse Meta Networks for Sequential Adaptation and its
Application to Adaptive Language Modelling**
<br />
by *Munkhdalai, Tsendsuren*
<br />
[http://arxiv.org/abs/2009.01803](http://arxiv.org/abs/2009.01803)


**Learning with Differentiable Perturbed Optimizers**
<br />
by *Berthet, Quentin and Blondel, Mathieu and Teboul, Olivier
and Cuturi, Marco and Vert, Jean-Philippe and Bach, Francis*
<br />
[http://arxiv.org/abs/2002.08676](http://arxiv.org/abs/2002.08676)


**What is being transferred in transfer learning?**
<br />
by *Neyshabur, Behnam and Sedghi, Hanie and Zhang, Chiyuan*
<br />
[http://arxiv.org/abs/2008.11687](http://arxiv.org/abs/2008.11687)


**On modulating the gradient for meta-learning**
<br />
by *Simon, Christian and Koniusz, Piotr and Nock, Richard and
Harandi, Mehrtash*
<br />
[https://www.ecva.net/papers/eccv_2020/papers_ECCV/papers/123530545.pdf](https://www.ecva.net/papers/eccv_2020/papers_ECCV/papers/123530545.pdf)


**Meta-Learning with Shared Amortized Variational Inference**
<br />
by *Iakovleva, Ekaterina and Verbeek, Jakob and Alahari, Karteek*
<br />
[http://arxiv.org/abs/2008.12037](http://arxiv.org/abs/2008.12037)


**learn2learn: A Library for Meta-Learning Research**
<br />
by *Arnold, Sébastien M R and Mahajan, Praateek and Datta,
Debajyoti and Bunner, Ian and Zarkias, Konstantinos Saitas*
<br />
[http://arxiv.org/abs/2008.12284](http://arxiv.org/abs/2008.12284)


**A Universal Representation Transformer Layer for Few-Shot
Image Classification**
<br />
by *Liu, Lu and Hamilton, William and Long, Guodong and Jiang,
Jing and Larochelle, Hugo*
<br />
[http://arxiv.org/abs/2006.11702](http://arxiv.org/abs/2006.11702)


**Safe Model-Based Meta-Reinforcement Learning: A
Sequential Exploration-Exploitation Framework**
<br />
by *Lew, Thomas and Sharma, Apoorva and Harrison, James and
Pavone, Marco*
<br />
[http://arxiv.org/abs/2008.11700](http://arxiv.org/abs/2008.11700)


**Learning to Learn in a Semi-Supervised Fashion**
<br />
by *Chen, Yun-Chun and Chou, Chao-Te and Wang, Yu-Chiang Frank*
<br />
[http://arxiv.org/abs/2008.11203](http://arxiv.org/abs/2008.11203)


**The Advantage of Conditional Meta-Learning for Biased
Regularization and Fine-Tuning**
<br />
by *Denevi, Giulia and Pontil, Massimiliano and Ciliberto, Carlo*
<br />
[http://arxiv.org/abs/2008.10857](http://arxiv.org/abs/2008.10857)


**Adaptive Multi-level Hyper-gradient Descent**
<br />
by *Jie, Renlong and Gao, Junbin and Vasnev, Andrey and Tran,
Minh-Ngoc*
<br />
[http://arxiv.org/abs/2008.07277](http://arxiv.org/abs/2008.07277)


**Few-Shot Image Classification via Contrastive
Self-Supervised Learning**
<br />
by *Li, Jianyi and Liu, Guizhong*
<br />
[http://arxiv.org/abs/2008.09942](http://arxiv.org/abs/2008.09942)


**Does MAML really want feature reuse only?**
<br />
by *Oh, Jaehoon and Yoo, Hyungjun and Kim, Changhwan and Yun,
Se-Young*
<br />
[http://arxiv.org/abs/2008.08882](http://arxiv.org/abs/2008.08882)


**Meta Learning MPC using Finite-Dimensional Gaussian
Process Approximations**
<br />
by *Arcari, Elena and Carron, Andrea and Zeilinger, Melanie N*
<br />
[http://arxiv.org/abs/2008.05984](http://arxiv.org/abs/2008.05984)


**Offline Meta-Reinforcement Learning with Advantage
Weighting**
<br />
by *Mitchell, Eric and Rafailov, Rafael and Peng, Xue Bin and
Levine, Sergey and Finn, Chelsea*
<br />
[http://arxiv.org/abs/2008.06043](http://arxiv.org/abs/2008.06043)


**Explore then Execute: Adapting without Rewards via
Factorized Meta-Reinforcement Learning**
<br />
by *Liu, Evan Zheran and Raghunathan, Aditi and Liang, Percy and
Finn, Chelsea*
<br />
[http://arxiv.org/abs/2008.02790](http://arxiv.org/abs/2008.02790)


**Offline Meta Reinforcement Learning**
<br />
by *Dorfman, Ron and Tamar, Aviv*
<br />
[http://arxiv.org/abs/2008.02598](http://arxiv.org/abs/2008.02598)


**Few-Shot Learning via Learning the Representation,
Provably**
<br />
by *Du, Simon S and Hu, Wei and Kakade, Sham M and Lee, Jason D
and Lei, Qi*
<br />
[http://arxiv.org/abs/2002.09434](http://arxiv.org/abs/2002.09434)


**Multi-Task Reinforcement Learning as a Hidden-Parameter
Block MDP**
<br />
by *Zhang, Amy and Sodhani, Shagun and Khetarpal, Khimya and
Pineau, Joelle*
<br />
[http://arxiv.org/abs/2007.07206](http://arxiv.org/abs/2007.07206)


**CAMPs: Learning Context-Specific Abstractions for
Efficient Planning in Factored MDPs**
<br />
by *Chitnis, Rohan and Silver, Tom and Kim, Beomjoon and
Kaelbling, Leslie Pack and Lozano-Perez, Tomas*
<br />
[http://arxiv.org/abs/2007.13202](http://arxiv.org/abs/2007.13202)


**Unsupervised Learning of Visual Features by Contrasting
Cluster Assignments**
<br />
by *Caron, Mathilde and Misra, Ishan and Mairal, Julien and
Goyal, Priya and Bojanowski, Piotr and Joulin, Armand*
<br />
[http://arxiv.org/abs/2006.09882](http://arxiv.org/abs/2006.09882)


**MiCo: Mixup Co-Training for Semi-Supervised Domain
Adaptation**
<br />
by *Yang, Luyu and Wang, Yan and Gao, Mingfei and Shrivastava,
Abhinav and Weinberger, Kilian Q and Chao, Wei-Lun and Lim,
Ser-Nam*
<br />
[http://arxiv.org/abs/2007.12684](http://arxiv.org/abs/2007.12684)


**Adaptive Task Sampling for Meta-Learning**
<br />
by *Liu, Chenghao and Wang, Zhihao and Sahoo, Doyen and Fang,
Yuan and Zhang, Kun and Hoi, Steven C H*
<br />
[http://arxiv.org/abs/2007.08735](http://arxiv.org/abs/2007.08735)


**Discovering Reinforcement Learning Algorithms**
<br />
by *Oh, Junhyuk and Hessel, Matteo and Czarnecki, Wojciech M and
Xu, Zhongwen and van Hasselt, Hado and Singh, Satinder and
Silver, David*
<br />
[http://arxiv.org/abs/2007.08794](http://arxiv.org/abs/2007.08794)


**On the Outsized Importance of Learning Rates in Local Update
Methods**
<br />
by *Charles, Zachary and Kone{\v c}n{\'y}, Jakub*
<br />
[http://arxiv.org/abs/2007.00878](http://arxiv.org/abs/2007.00878)


**Global Convergence and Induced Kernels of Gradient-Based
Meta-Learning with Neural Nets**
<br />
by *Wang, Haoxiang and Sun, Ruoyu and Li, Bo*
<br />
[http://arxiv.org/abs/2006.14606](http://arxiv.org/abs/2006.14606)


**On the Iteration Complexity of Hypergradient Computation**
<br />
by *Grazzi, Riccardo and Franceschi, Luca and Pontil,
Massimiliano and Salzo, Saverio*
<br />
[http://arxiv.org/abs/2006.16218](http://arxiv.org/abs/2006.16218)


**On the Outsized Importance of Learning Rates in Local Update
Methods**
<br />
by *Charles, Zachary and Kone{\v c}n{\'y}, Jakub*
<br />
[http://arxiv.org/abs/2007.00878](http://arxiv.org/abs/2007.00878)


**Meta-SAC: Auto-tune the Entropy Temperature of Soft
Actor-Critic via Metagradient**
<br />
by *Wang, Yufei and Ni, Tianwei*
<br />
[http://arxiv.org/abs/2007.01932](http://arxiv.org/abs/2007.01932)


**Meta Learning in the Continuous Time Limit**
<br />
by *Xu, Ruitu and Chen, Lin and Karbasi, Amin*
<br />
[http://arxiv.org/abs/2006.10921](http://arxiv.org/abs/2006.10921)


**Expert Training: Task Hardness Aware Meta-Learning for
Few-Shot Classification**
<br />
by *Zhou, Yucan and Wang, Yu and Cai, Jianfei and Zhou, Yu and
Hu, Qinghua and Wang, Weiping*
<br />
[http://arxiv.org/abs/2007.06240](http://arxiv.org/abs/2007.06240)


**MTL2L: A Context Aware Neural Optimiser**
<br />
by *Kuo, Nicholas I-Hsien and Harandi, Mehrtash and Fourrier,
Nicolas and Walder, Christian and Ferraro, Gabriela and
Suominen, Hanna*
<br />
[http://arxiv.org/abs/2007.09343](http://arxiv.org/abs/2007.09343)


**Navigating the Trade-Off between Multi-Task Learning and
Learning to Multitask in Deep Neural Networks**
<br />
by *Ravi, Sachin and Musslick, Sebastian and Hamin, Maia and
Willke, Theodore L and Cohen, Jonathan D*
<br />
[http://arxiv.org/abs/2007.10527](http://arxiv.org/abs/2007.10527)


**Balanced Meta-Softmax for Long-Tailed Visual Recognition**
<br />
by *Ren, Jiawei and Yu, Cunjun and Sheng, Shunan and Ma, Xiao
and Zhao, Haiyu and Yi, Shuai and Li, Hongsheng*
<br />
[http://arxiv.org/abs/2007.10740](http://arxiv.org/abs/2007.10740)


**CrossTransformers: spatially-aware few-shot transfer**
<br />
by *Doersch, Carl and Gupta, Ankush and Zisserman, Andrew*
<br />
[http://arxiv.org/abs/2007.11498](http://arxiv.org/abs/2007.11498)


**Meta-Learning a Dynamical Language Model**
<br />
by *Wolf, Thomas and Chaumond, Julien and Delangue, Clement*
<br />
[http://arxiv.org/abs/1803.10631](http://arxiv.org/abs/1803.10631)


**Meta-Learning Requires Meta-Augmentation**
<br />
by *Rajendran, Janarthanan and Irpan, Alex and Jang, Eric*
<br />
[http://arxiv.org/abs/2007.05549](http://arxiv.org/abs/2007.05549)


**Adaptive Risk Minimization: A Meta-Learning Approach for
Tackling Group Shift**
<br />
by *Zhang, Marvin and Marklund, Henrik and Gupta, Abhishek and
Levine, Sergey and Finn, Chelsea*
<br />
[http://arxiv.org/abs/2007.02931](http://arxiv.org/abs/2007.02931)


**Meta-Learning Symmetries by Reparameterization**
<br />
by *Zhou, Allan and Knowles, Tom and Finn, Chelsea*
<br />
[http://arxiv.org/abs/2007.02933](http://arxiv.org/abs/2007.02933)


**Adaptive Risk Minimization: A Meta-Learning Approach for
Tackling Group Shift**
<br />
by *Zhang, Marvin and Marklund, Henrik and Gupta, Abhishek and
Levine, Sergey and Finn, Chelsea*
<br />
[http://arxiv.org/abs/2007.02931](http://arxiv.org/abs/2007.02931)


**A Brief Look at Generalization in Visual
Meta-Reinforcement Learning**
<br />
by *Alver, Safa and Precup, Doina*
<br />
[http://arxiv.org/abs/2006.07262](http://arxiv.org/abs/2006.07262)


**Learning Representations by Stochastic Meta-Gradient
Descent in Neural Networks**
<br />
by *Veeriah, Vivek and Zhang, Shangtong and Sutton, Richard S*
<br />
[http://arxiv.org/abs/1612.02879](http://arxiv.org/abs/1612.02879)


**PACOH: Bayes-Optimal Meta-Learning with
PAC-Guarantees**
<br />
by *Rothfuss, Jonas and Fortuin, Vincent and Krause, Andreas*
<br />
[http://arxiv.org/abs/2002.05551](http://arxiv.org/abs/2002.05551)


**Meta-Meta-Classification for One-Shot Learning**
<br />
by *Chowdhury, Arkabandhu and Chaudhari, Dipak and Chaudhuri,
Swarat and Jermaine, Chris*
<br />
[http://arxiv.org/abs/2004.08083](http://arxiv.org/abs/2004.08083)


**Relatedness Measures to Aid the Transfer of Building Blocks
among Multiple Tasks**
<br />
by *Nguyen, Trung B and Browne, Will N and Zhang, Mengjie*
<br />
[http://arxiv.org/abs/2005.03947](http://arxiv.org/abs/2005.03947)


**Information-Theoretic Generalization Bounds for
Meta-Learning and Applications**
<br />
by *Jose, Sharu Theresa and Simeone, Osvaldo*
<br />
[http://arxiv.org/abs/2005.04372](http://arxiv.org/abs/2005.04372)


**On Learning Intrinsic Rewards for Policy Gradient Methods**
<br />
by *Zheng, Zeyu and Oh, Junhyuk and Singh, Satinder*
<br />
[http://arxiv.org/abs/1804.06459](http://arxiv.org/abs/1804.06459)


**A Sample Complexity Separation between Non-Convex and
Convex Meta-Learning**
<br />
by *Saunshi, Nikunj and Zhang, Yi and Khodak, Mikhail and Arora,
Sanjeev*
<br />
[http://arxiv.org/abs/2002.11172](http://arxiv.org/abs/2002.11172)


**Bayesian Online Meta-Learning with Laplace Approximation**
<br />
by *Yap, Pau Ching and Ritter, Hippolyt and Barber, David*
<br />
[http://arxiv.org/abs/2005.00146](http://arxiv.org/abs/2005.00146)


**Meta-Reinforcement Learning for Robotic Industrial
Insertion Tasks**
<br />
by *Schoettler, Gerrit and Nair, Ashvin and Ojea, Juan Aparicio
and Levine, Sergey and Solowjow, Eugen*
<br />
[http://arxiv.org/abs/2004.14404](http://arxiv.org/abs/2004.14404)


**Continual Deep Learning by Functional Regularisation of
Memorable Past**
<br />
by *Pan, Pingbo and Swaroop, Siddharth and Immer, Alexander and
Eschenhagen, Runa and Turner, Richard E and Khan, Mohammad
Emtiyaz*
<br />
[http://arxiv.org/abs/2004.14070](http://arxiv.org/abs/2004.14070)


**Jelly Bean World: A Testbed for Never-Ending Learning**
<br />
by *Platanios, Emmanouil Antonios and Saparov, Abulhair and Mitchell,
Tom*
<br />
[https://openreview.net/pdf?id=Byx_YAVYPH](https://openreview.net/pdf?id=Byx_YAVYPH)


**Encouraging behavioral diversity in evolutionary robotics: an
empirical study**
<br />
by *Mouret, J-B and Doncieux, S*
<br />
[http://dx.doi.org/10.1162/EVCO_a_00048](http://dx.doi.org/10.1162/EVCO_a_00048)


**Defining Benchmarks for Continual Few-Shot Learning**
<br />
by *Antoniou, Antreas and Patacchiola, Massimiliano and Ochal,
Mateusz and Storkey, Amos*
<br />
[http://arxiv.org/abs/2004.11967](http://arxiv.org/abs/2004.11967)


**Emergent Real-World Robotic Skills via Unsupervised
Off-Policy Reinforcement Learning**
<br />
by *Sharma, Archit and Ahn, Michael and Levine, Sergey and
Kumar, Vikash and Hausman, Karol and Gu, Shixiang*
<br />
[http://arxiv.org/abs/2004.12974](http://arxiv.org/abs/2004.12974)


**Empirical Bayes Transductive Meta-Learning with Synthetic
Gradients**
<br />
by *Hu, Shell Xu and Moreno, Pablo G and Xiao, Yang and Shen, Xi
and Obozinski, Guillaume and Lawrence, Neil D and Damianou,
Andreas*
<br />
[http://arxiv.org/abs/2004.12696](http://arxiv.org/abs/2004.12696)


**Evolving Inborn Knowledge For Fast Adaptation in Dynamic
POMDP Problems**
<br />
by *Ben-Iwhiwhu, Eseoghene and Ladosz, Pawel and Dick, Jeffery
and Chen, Wen-Hua and Pilly, Praveen and Soltoggio, Andrea*
<br />
[http://arxiv.org/abs/2004.12846](http://arxiv.org/abs/2004.12846)


**Meta-World: A Benchmark and Evaluation for Multi-Task
and Meta Reinforcement Learning**
<br />
by *Yu, Tianhe and Quillen, Deirdre and He, Zhanpeng and Julian,
Ryan and Hausman, Karol and Finn, Chelsea and Levine, Sergey*
<br />
[http://arxiv.org/abs/1910.10897](http://arxiv.org/abs/1910.10897)


**Meta reinforcement learning as task inference**
<br />
by *Humplik, Jan and Galashov, Alexandre and Hasenclever,
Leonard and Ortega, Pedro A and Teh, Yee Whye and Heess,
Nicolas*
<br />
[http://arxiv.org/abs/1905.06424](http://arxiv.org/abs/1905.06424)


**Meta-Gradient Reinforcement Learning**
<br />
by *Xu, Zhongwen and van Hasselt, Hado and Silver, David*
<br />
[http://arxiv.org/abs/1805.09801](http://arxiv.org/abs/1805.09801)


**Self-Paced Deep Reinforcement Learning**
<br />
by *Klink, Pascal and D'Eramo, Carlo and Peters, Jan and
Pajarinen, Joni*
<br />
[http://arxiv.org/abs/2004.11812](http://arxiv.org/abs/2004.11812)


**Scheduling the Learning Rate Via Hypergradients: New Insights and
a New Algorithm**
<br />
by *Donini, Michele and Franceschi, Luca and Majumder, Orchid and
Pontil, Massimiliano and Frasconi, Paolo*
<br />
[https://openreview.net/pdf?id=Ske6qJSKPH](https://openreview.net/pdf?id=Ske6qJSKPH)


**Learning Stabilizable Nonlinear Dynamics with
Contraction-Based Regularization**
<br />
by *Singh, Sumeet and Richards, Spencer M and Sindhwani, Vikas
and Slotine, Jean-Jacques E and Pavone, Marco*
<br />
[http://arxiv.org/abs/1907.13122](http://arxiv.org/abs/1907.13122)


**A Comprehensive Overview and Survey of Recent Advances in
Meta-Learning**
<br />
by *Peng, Huimin*
<br />
[http://arxiv.org/abs/2004.11149](http://arxiv.org/abs/2004.11149)


**Learning a Formula of Interpretability to Learn
Interpretable Formulas**
<br />
by *Virgolin, Marco and De Lorenzo, Andrea and Medvet, Eric and
Randone, Francesca*
<br />
[http://arxiv.org/abs/2004.11170](http://arxiv.org/abs/2004.11170)


**Model-Based Meta-Reinforcement Learning for Flight with
Suspended Payloads**
<br />
by *Belkhale, Suneel and Li, Rachel and Kahn, Gregory and
McAllister, Rowan and Calandra, Roberto and Levine, Sergey*
<br />
[http://arxiv.org/abs/2004.11345](http://arxiv.org/abs/2004.11345)


**Frustratingly Simple Few-Shot Object Detection**
<br />
by *Wang, Xin and Huang, Thomas E and Darrell, Trevor and
Gonzalez, Joseph E and Yu, Fisher*
<br />
[http://arxiv.org/abs/2003.06957](http://arxiv.org/abs/2003.06957)


**Meta Pseudo Labels**
<br />
by *Pham, Hieu and Xie, Qizhe and Dai, Zihang and Le, Quoc V*
<br />
[http://arxiv.org/abs/2003.10580](http://arxiv.org/abs/2003.10580)


**0e56da12-a2f0-4288-b745-c15deec9183a**
<br />
by *Unknown*
<br />
[http://learn2learn.net](http://learn2learn.net)


**Finding online neural update rules by learning to remember**
<br />
by *Gregor, Karol*
<br />
[http://arxiv.org/abs/2003.03124](http://arxiv.org/abs/2003.03124)


**A New Meta-Baseline for Few-Shot Learning**
<br />
by *Chen, Yinbo and Wang, Xiaolong and Liu, Zhuang and Xu,
Huijuan and Darrell, Trevor*
<br />
[http://arxiv.org/abs/2003.04390](http://arxiv.org/abs/2003.04390)


**Learning to be Global Optimizer**
<br />
by *Zhang, Haotian and Sun, Jianyong and Xu, Zongben*
<br />
[http://arxiv.org/abs/2003.04521](http://arxiv.org/abs/2003.04521)


**Scalable Multi-Task Imitation Learning with Autonomous
Improvement**
<br />
by *Singh, Avi and Jang, Eric and Irpan, Alexander and Kappler,
Daniel and Dalal, Murtaza and Levine, Sergey and Khansari,
Mohi and Finn, Chelsea*
<br />
[http://arxiv.org/abs/2003.02636](http://arxiv.org/abs/2003.02636)


**Meta-learning for mixed linear regression**
<br />
by *Kong, Weihao and Somani, Raghav and Song, Zhao and Kakade,
Sham and Oh, Sewoong*
<br />
[http://arxiv.org/abs/2002.08936](http://arxiv.org/abs/2002.08936)


**Provable Meta-Learning of Linear Representations**
<br />
by *Tripuraneni, Nilesh and Jin, Chi and Jordan, Michael I*
<br />
[http://arxiv.org/abs/2002.11684](http://arxiv.org/abs/2002.11684)


**Learning to Continually Learn**
<br />
by *Beaulieu, Shawn and Frati, Lapo and Miconi, Thomas and
Lehman, Joel and Stanley, Kenneth O and Clune, Jeff and
Cheney, Nick*
<br />
[http://arxiv.org/abs/2002.09571](http://arxiv.org/abs/2002.09571)


**PACOH: Bayes-Optimal Meta-Learning with
PAC-Guarantees**
<br />
by *Rothfuss, Jonas and Fortuin, Vincent and Krause, Andreas*
<br />
[http://arxiv.org/abs/2002.05551](http://arxiv.org/abs/2002.05551)


**Incremental Learning for Metric-Based Meta-Learners**
<br />
by *Liu, Qing and Majumder, Orchid and Ravichandran, Avinash and
Bhotika, Rahul and Soatto, Stefano*
<br />
[http://arxiv.org/abs/2002.04162](http://arxiv.org/abs/2002.04162)


**Hyper-Meta Reinforcement Learning with Sparse Reward**
<br />
by *Hua, Yun and Wang, Xiangfeng and Jin, Bo and Li, Wenhao and
Yan, Junchi and He, Xiaofeng and Zha, Hongyuan*
<br />
[http://arxiv.org/abs/2002.04238](http://arxiv.org/abs/2002.04238)


**Meta-Learning across Meta-Tasks for Few-Shot Learning**
<br />
by *Fei, Nanyi and Lu, Zhiwu and Gao, Yizhao and Tian, Jia and
Xiang, Tao and Wen, Ji-Rong*
<br />
[http://arxiv.org/abs/2002.04274](http://arxiv.org/abs/2002.04274)


**Distribution-Agnostic Model-Agnostic Meta-Learning**
<br />
by *Collins, Liam and Mokhtari, Aryan and Shakkottai, Sanjay*
<br />
[http://arxiv.org/abs/2002.04766](http://arxiv.org/abs/2002.04766)


**Provably Convergent Policy Gradient Methods for
Model-Agnostic Meta-Reinforcement Learning**
<br />
by *Fallah, Alireza and Mokhtari, Aryan and Ozdaglar, Asuman*
<br />
[http://arxiv.org/abs/2002.05135](http://arxiv.org/abs/2002.05135)


**Meta-learning framework with applications to zero-shot
time-series forecasting**
<br />
by *Oreshkin, Boris N and Carpov, Dmitri and Chapados, Nicolas
and Bengio, Yoshua*
<br />
[http://arxiv.org/abs/2002.02887](http://arxiv.org/abs/2002.02887)


**A Loss-Function for Causal Machine-Learning**
<br />
by *Yang, I-Sheng*
<br />
[http://arxiv.org/abs/2001.00629](http://arxiv.org/abs/2001.00629)


**Self-Tuning Deep Reinforcement Learning**
<br />
by *Zahavy, Tom and Xu, Zhongwen and Veeriah, Vivek and Hessel,
Matteo and Van Hasslet, Hado and Silver, David and Singh,
Satinder*
<br />
[http://arxiv.org/abs/2002.12928](http://arxiv.org/abs/2002.12928)


**Learning Adaptive Loss for Robust Learning with Noisy Labels**
<br />
by *Shu, Jun and Zhao, Qian and Chen, Keyu and Xu, Zongben and
Meng, Deyu*
<br />
[http://arxiv.org/abs/2002.06482](http://arxiv.org/abs/2002.06482)


**A Structured Prediction Approach for Conditional
Meta-Learning**
<br />
by *Wang, Ruohan and Demiris, Yiannis and Ciliberto, Carlo*
<br />
[http://arxiv.org/abs/2002.08799](http://arxiv.org/abs/2002.08799)


**Curriculum in Gradient-Based Meta-Reinforcement Learning**
<br />
by *Mehta, Bhairav and Deleu, Tristan and Raparthy, Sharath
Chandra and Pal, Chris J and Paull, Liam*
<br />
[http://arxiv.org/abs/2002.07956](http://arxiv.org/abs/2002.07956)


**Multi-Step Model-Agnostic Meta-Learning: Convergence
and Improved Algorithms**
<br />
by *Ji, Kaiyi and Yang, Junjie and Liang, Yingbin*
<br />
[http://arxiv.org/abs/2002.07836](http://arxiv.org/abs/2002.07836)


**Local Nonparametric Meta-Learning**
<br />
by *Goo, Wonjoon and Niekum, Scott*
<br />
[http://arxiv.org/abs/2002.03272](http://arxiv.org/abs/2002.03272)


**Revisiting Meta-Learning as Supervised Learning**
<br />
by *Chao, Wei-Lun and Ye, Han-Jia and Zhan, De-Chuan and
Campbell, Mark and Weinberger, Kilian Q*
<br />
[http://arxiv.org/abs/2002.00573](http://arxiv.org/abs/2002.00573)


**SimpleShot: Revisiting Nearest-Neighbor Classification
for Few-Shot Learning**
<br />
by *Wang, Yan and Chao, Wei-Lun and Weinberger, Kilian Q and van
der Maaten, Laurens*
<br />
[http://arxiv.org/abs/1911.04623](http://arxiv.org/abs/1911.04623)


**Fast and Generalized Adaptation for Few-Shot Learning**
<br />
by *Song, Liang and Liu, Jinlu and Qin, Yongqiang*
<br />
[http://arxiv.org/abs/1911.10807](http://arxiv.org/abs/1911.10807)


**Meta-Learning without Memorization**
<br />
by *Yin, Mingzhang and Tucker, George and Zhou, Mingyuan and
Levine, Sergey and Finn, Chelsea*
<br />
[http://arxiv.org/abs/1912.03820](http://arxiv.org/abs/1912.03820)


**Your Classifier is Secretly an Energy Based Model and You
Should Treat it Like One**
<br />
by *Grathwohl, Will and Wang, Kuan-Chieh and Jacobsen,
J{\"o}rn-Henrik and Duvenaud, David and Norouzi, Mohammad
and Swersky, Kevin*
<br />
[http://arxiv.org/abs/1912.03263](http://arxiv.org/abs/1912.03263)


**MAME : Model-Agnostic Meta-Exploration**
<br />
by *Gurumurthy, Swaminathan and Kumar, Sumit and Sycara, Katia*
<br />
[http://arxiv.org/abs/1911.04024](http://arxiv.org/abs/1911.04024)


**Constructing Multiple Tasks for Augmentation: Improving
Neural Image Classification With K-means Features**
<br />
by *Gui, Tao and Qing, Lizhi and Zhang, Qi and Ye, Jiacheng and
Yan, Hang and Fei, Zichu and Huang, Xuanjing*
<br />
[http://arxiv.org/abs/1911.07518](http://arxiv.org/abs/1911.07518)


**Meta Adaptation using Importance Weighted Demonstrations**
<br />
by *Lekkala, Kiran and Abu-El-Haija, Sami and Itti, Laurent*
<br />
[http://arxiv.org/abs/1911.10322](http://arxiv.org/abs/1911.10322)


**VIABLE: Fast Adaptation via Backpropagating Learned Loss**
<br />
by *Feng, Leo and Zintgraf, Luisa and Peng, Bei and Whiteson,
Shimon*
<br />
[http://arxiv.org/abs/1911.13159](http://arxiv.org/abs/1911.13159)


**Decoupling Adaptation from Modeling with Meta-Optimizers
for Meta Learning**
<br />
by *Arnold, S{\'e}bastien M R and Iqbal, Shariq and Sha, Fei*
<br />
[http://arxiv.org/abs/1910.13603](http://arxiv.org/abs/1910.13603)


**TADAM: Task dependent adaptive metric for improved few-shot
learning**
<br />
by *Oreshkin, Boris and Rodr{\'\i}guez L{\'o}pez, Pau and Lacoste,
Alexandre*
<br />
[http://papers.nips.cc/paper/7352-tadam-task-dependent-adaptive-metric-for-improved-few-shot-learning.pdf](http://papers.nips.cc/paper/7352-tadam-task-dependent-adaptive-metric-for-improved-few-shot-learning.pdf)


**Learning to Few-Shot Learn Across Diverse Natural Language
Classification Tasks**
<br />
by *Bansal, Trapit and Jha, Rishikesh and McCallum, Andrew*
<br />
[http://arxiv.org/abs/1911.03863](http://arxiv.org/abs/1911.03863)


**Optimizing Millions of Hyperparameters by Implicit
Differentiation**
<br />
by *Lorraine, Jonathan and Vicol, Paul and Duvenaud, David*
<br />
[http://arxiv.org/abs/1911.02590](http://arxiv.org/abs/1911.02590)


**Meta-data: Characterization of Input Features for Meta-learning**
<br />
by *Castiello, Ciro and Castellano, Giovanna and Fanelli, Anna Maria*
<br />
[http://dx.doi.org/10.1007/11526018_45](http://dx.doi.org/10.1007/11526018_45)


**Meta-Learning for Low-resource Natural Language Generation
in Task-oriented Dialogue Systems**
<br />
by *Mi, Fei and Huang, Minlie and Zhang, Jiyong and Faltings,
Boi*
<br />
[http://arxiv.org/abs/1905.05644](http://arxiv.org/abs/1905.05644)


**Domain Generalization via Model-Agnostic Learning of
Semantic Features**
<br />
by *Dou, Qi and Castro, Daniel C and Kamnitsas, Konstantinos and
Glocker, Ben*
<br />
[http://arxiv.org/abs/1910.13580](http://arxiv.org/abs/1910.13580)


**Hierarchical Expert Networks for Meta-Learning**
<br />
by *Hihn, Heinke and Braun, Daniel A*
<br />
[http://arxiv.org/abs/1911.00348](http://arxiv.org/abs/1911.00348)


**Online Meta-Learning on Non-convex Setting**
<br />
by *Zhuang, Zhenxun and Wang, Yunlong and Yu, Kezi and Lu,
Songtao*
<br />
[http://arxiv.org/abs/1910.10196](http://arxiv.org/abs/1910.10196)


**Learning-to-Learn Stochastic Gradient Descent with Biased
Regularization**
<br />
by *Denevi, Giulia and Ciliberto, Carlo and Grazzi, Riccardo and
Pontil, Massimiliano*
<br />
[http://arxiv.org/abs/1903.10399](http://arxiv.org/abs/1903.10399)


**Provable Guarantees for Gradient-Based Meta-Learning**
<br />
by *Khodak, Mikhail and Balcan, Maria-Florina and Talwalkar,
Ameet*
<br />
[http://arxiv.org/abs/1902.10644](http://arxiv.org/abs/1902.10644)


**The TCGA Meta-Dataset Clinical Benchmark**
<br />
by *Samiei, Mandana and W{\"u}rfl, Tobias and Deleu, Tristan and
Weiss, Martin and Dutil, Francis and Fevens, Thomas and
Boucher, Genevi{\`e}ve and Lemieux, Sebastien and Cohen,
Joseph Paul*
<br />
[http://arxiv.org/abs/1910.08636](http://arxiv.org/abs/1910.08636)


**VariBAD: A Very Good Method for Bayes-Adaptive Deep RL
via Meta-Learning**
<br />
by *Zintgraf, Luisa and Shiarlis, Kyriacos and Igl, Maximilian
and Schulze, Sebastian and Gal, Yarin and Hofmann, Katja and
Whiteson, Shimon*
<br />
[http://arxiv.org/abs/1910.08348](http://arxiv.org/abs/1910.08348)


**Meta-Transfer Learning through Hard Tasks**
<br />
by *Sun, Qianru and Liu, Yaoyao and Chen, Zhaozheng and Chua,
Tat-Seng and Schiele, Bernt*
<br />
[http://arxiv.org/abs/1910.03648](http://arxiv.org/abs/1910.03648)


**Model-Agnostic Meta-Learning using Runge-Kutta Methods**
<br />
by *Im, Daniel Jiwoong and Jiang, Yibo and Verma, Nakul*
<br />
[http://arxiv.org/abs/1910.07368](http://arxiv.org/abs/1910.07368)


**Improving Generalization in Meta Reinforcement Learning
using Learned Objectives**
<br />
by *Kirsch, Louis and van Steenkiste, Sjoerd and Schmidhuber,
J{\"u}rgen*
<br />
[http://arxiv.org/abs/1910.04098](http://arxiv.org/abs/1910.04098)


**Generalized Inner Loop Meta-Learning**
<br />
by *Grefenstette, Edward and Amos, Brandon and Yarats, Denis and
Htut, Phu Mon and Molchanov, Artem and Meier, Franziska and
Kiela, Douwe and Cho, Kyunghyun and Chintala, Soumith*
<br />
[http://arxiv.org/abs/1910.01727](http://arxiv.org/abs/1910.01727)


**Is Fast Adaptation All You Need?**
<br />
by *Javed, Khurram and Yao, Hengshuai and White, Martha*
<br />
[http://arxiv.org/abs/1910.01705](http://arxiv.org/abs/1910.01705)


**Deep Reinforcement Learning for Single-Shot Diagnosis and
Adaptation in Damaged Robots**
<br />
by *Verma, Shresth and Nair, Haritha S and Agarwal, Gaurav and
Dhar, Joydip and Shukla, Anupam*
<br />
[http://arxiv.org/abs/1910.01240](http://arxiv.org/abs/1910.01240)


**ES-MAML: Simple Hessian-Free Meta Learning**
<br />
by *Song, Xingyou and Gao, Wenbo and Yang, Yuxiang and
Choromanski, Krzysztof and Pacchiano, Aldo and Tang, Yunhao*
<br />
[http://arxiv.org/abs/1910.01215](http://arxiv.org/abs/1910.01215)


**Meta-Q-Learning**
<br />
by *Fakoor, Rasool and Chaudhari, Pratik and Soatto, Stefano and
Smola, Alexander J*
<br />
[http://arxiv.org/abs/1910.00125](http://arxiv.org/abs/1910.00125)


**Efficient meta reinforcement learning via meta goal
generation**
<br />
by *Fu, Haotian and Tang, Hongyao and Hao, Jianye*
<br />
[http://arxiv.org/abs/1909.13607](http://arxiv.org/abs/1909.13607)


**Chameleon: Learning Model Initializations Across Tasks With
Different Schemas**
<br />
by *Brinkmeyer, Lukas and Drumond, Rafael Rego and Scholz,
Randolf and Grabocka, Josif and Schmidt-Thieme, Lars*
<br />
[http://arxiv.org/abs/1909.13576](http://arxiv.org/abs/1909.13576)


**Learning Fast Adaptation with Meta Strategy Optimization**
<br />
by *Yu, Wenhao and Tan, Jie and Bai, Yunfei and Coumans, Erwin
and Ha, Sehoon*
<br />
[http://arxiv.org/abs/1909.12995](http://arxiv.org/abs/1909.12995)


**Meta-Inverse Reinforcement Learning with Probabilistic
Context Variables**
<br />
by *Yu, Lantao and Yu, Tianhe and Finn, Chelsea and Ermon,
Stefano*
<br />
[http://arxiv.org/abs/1909.09314](http://arxiv.org/abs/1909.09314)


**Modular Meta-Learning with Shrinkage**
<br />
by *Chen, Yutian and Friesen, Abram L and Behbahani, Feryal and
Budden, David and Hoffman, Matthew W and Doucet, Arnaud and
de Freitas, Nando*
<br />
[http://arxiv.org/abs/1909.05557](http://arxiv.org/abs/1909.05557)


**Loaded DiCE: Trading off Bias and Variance in Any-Order
Score Function Estimators for Reinforcement Learning**
<br />
by *Farquhar, Gregory and Whiteson, Shimon and Foerster, Jakob*
<br />
[http://arxiv.org/abs/1909.10549](http://arxiv.org/abs/1909.10549)


**Rapid Learning or Feature Reuse? Towards Understanding the
Effectiveness of MAML**
<br />
by *Raghu, Aniruddh and Raghu, Maithra and Bengio, Samy and
Vinyals, Oriol*
<br />
[http://arxiv.org/abs/1909.09157](http://arxiv.org/abs/1909.09157)


**Meta-Learning**
<br />
by *Vanschoren, Joaquin*
<br />
[https://doi.org/10.1007/978-3-030-05318-5_2](https://doi.org/10.1007/978-3-030-05318-5_2)


**Understanding Short-Horizon Bias in Stochastic
Meta-Optimization**
<br />
by *Wu, Yuhuai and Ren, Mengye and Liao, Renjie and Grosse,
Roger*
<br />
[http://arxiv.org/abs/1803.02021](http://arxiv.org/abs/1803.02021)


**On First-Order Meta-Learning Algorithms**
<br />
by *Nichol, Alex and Achiam, Joshua and Schulman, John*
<br />
[http://arxiv.org/abs/1803.02999](http://arxiv.org/abs/1803.02999)


**Towards Understanding Generalization in Gradient-Based
Meta-Learning**
<br />
by *Guiroy, Simon and Verma, Vikas and Pal, Christopher*
<br />
[http://arxiv.org/abs/1907.07287](http://arxiv.org/abs/1907.07287)
<br />
They empirically study the landscape of fast-adaptation in
MAML. The most interesting claim is that when
meta-overfitting, the loss landscape becomes flatter on test
tasks.


**On the Convergence Theory of Gradient-Based
Model-Agnostic Meta-Learning Algorithms**
<br />
by *Fallah, Alireza and Mokhtari, Aryan and Ozdaglar, Asuman*
<br />
[http://arxiv.org/abs/1908.10400](http://arxiv.org/abs/1908.10400)


**Learning to Learn with Gradients**
<br />
by *Finn, Chelsea*
<br />
[http://learn2learn.net](http://learn2learn.net)


**Acetylcholine and memory**
<br />
by *Hasselmo, M E and Bower, J M*
<br />
[https://www.ncbi.nlm.nih.gov/pubmed/7688162](https://www.ncbi.nlm.nih.gov/pubmed/7688162)


**A THEORY OF META-LEARNING AND PRINCIPLES OF
FACILITATION: AN ORGANISMIC PERSPECTIVE**
<br />
by *Maudsley, Donald B*
<br />
[https://uosc.primo.exlibrisgroup.com/discovery/fulldisplay?docid=proquest302999651&context=PC&vid=01USC_INST:01USC&lang=en&search_scope=MyInst_and_CI&adaptor=Primo%20Central&tab=Everything&mode=Basic](https://uosc.primo.exlibrisgroup.com/discovery/fulldisplay?docid=proquest302999651&context=PC&vid=01USC_INST:01USC&lang=en&search_scope=MyInst_and_CI&adaptor=Primo%20Central&tab=Everything&mode=Basic)


**THE ROLE OF METALEARNING IN STUDY PROCESSES**
<br />
by *Biggs, J B*
<br />
[http://doi.wiley.com/10.1111/j.2044-8279.1985.tb02625.x](http://doi.wiley.com/10.1111/j.2044-8279.1985.tb02625.x)


**Understanding and correcting pathologies in the training of
learned optimizers**
<br />
by *Metz, Luke and Maheswaranathan, Niru and Nixon, Jeremy and
Daniel Freeman, C and Sohl-Dickstein, Jascha*
<br />
[http://arxiv.org/abs/1810.10180](http://arxiv.org/abs/1810.10180)
<br />
Provides many tricks (e.g. split train batch for model \&
opt, average gradient estimators) for training
differentiable optimizers online. They also have a couple of
interesting observations specific to recurrent optimizers.


**Learned Optimizers that Scale and Generalize**
<br />
by *Wichrowska, Olga and Maheswaranathan, Niru and Hoffman,
Matthew W and Colmenarejo, Sergio Gomez and Denil, Misha and
de Freitas, Nando and Sohl-Dickstein, Jascha*
<br />
[http://arxiv.org/abs/1703.04813](http://arxiv.org/abs/1703.04813)


**Using learned optimizers to make models robust to input
noise**
<br />
by *Metz, Luke and Maheswaranathan, Niru and Shlens, Jonathon
and Sohl-Dickstein, Jascha and Cubuk, Ekin D*
<br />
[http://arxiv.org/abs/1906.03367](http://arxiv.org/abs/1906.03367)


**Learning to Optimize Neural Nets**
<br />
by *Li, Ke and Malik, Jitendra*
<br />
[http://arxiv.org/abs/1703.00441](http://arxiv.org/abs/1703.00441)


**Meta-Learning Update Rules for Unsupervised Representation
Learning**
<br />
by *Metz, Luke and Maheswaranathan, Niru and Cheung, Brian and
Sohl-Dickstein, Jascha*
<br />
[http://arxiv.org/abs/1804.00222](http://arxiv.org/abs/1804.00222)


**Learning to Optimize**
<br />
by *Li, Ke and Malik, Jitendra*
<br />
[http://arxiv.org/abs/1606.01885](http://arxiv.org/abs/1606.01885)


**Learning to learn by gradient descent by gradient descent**
<br />
by *Andrychowicz, M and Denil, M and Gomez, S*
<br />
[http://learn2learn.net](http://learn2learn.net)


**Online Learning Rate Adaptation with Hypergradient Descent**
<br />
by *Baydin, Atilim Gunes and Cornish, Robert and Rubio, David
Martinez and Schmidt, Mark and Wood, Frank*
<br />
[http://arxiv.org/abs/1703.04782](http://arxiv.org/abs/1703.04782)
<br />
They adapt the learning rate of SGD by differentiating
the loss of the next parameters w.r.t. the learning
rate. They observe
that the gradient of the learning rate is simply the inner
product of the last two
gradients.


**Adapting Bias by Gradient Descent: An Incremental Version of
Delta-Bar-Delta**
<br />
by *Sutton, Richard S*
<br />
[http://dx.doi.org/](http://dx.doi.org/)
<br />
What's mostly interesting in this paper is the adaptation of
delta-bar-delta to the online scenario. The idea of representing
the learning rate as an exponential is nice. Also nice to see
that the derivation suggests a full-matrix adaptive case.


**Gain adaptation beats least squares**
<br />
by *Sutton, Richard S*
<br />
[https://pdfs.semanticscholar.org/7ec8/876f219b3b3d5c894a3f395c89c382029cc5.pdf](https://pdfs.semanticscholar.org/7ec8/876f219b3b3d5c894a3f395c89c382029cc5.pdf)
<br />
This paper extends IDBD as algorithms K1 and K2, but from my
quick read, it isn't clear what's the motivation for those
modifications. (Seems to work in a ``normalized space'', {\`a}
la natural gradient ?)They do work better.


**Local Gain Adaptation in Stochastic Gradient Descent**
<br />
by *Schraudolph, Nicol N*
<br />
[https://pdfs.semanticscholar.org/31a0/b86c3cd04e6539626f34b80db7ff79d23f40.pdf](https://pdfs.semanticscholar.org/31a0/b86c3cd04e6539626f34b80db7ff79d23f40.pdf)
<br />
This algorithm extends IDBD (Sutton) to the non-linear
setting. Interestingly, they have a few brief discussionson the
difficulties to optimize at the meta-level. (c.f. Meta-level
conditioning section.) Overall, it shines
light on the ground idea behind IDBD.


**TIDBD: Adapting Temporal-difference Step-sizes Through
Stochastic Meta-descent**
<br />
by *Kearney, Alex and Veeriah, Vivek and Travnik, Jaden B and
Sutton, Richard S and Pilarski, Patrick M*
<br />
[http://arxiv.org/abs/1804.03334](http://arxiv.org/abs/1804.03334)


**Increased rates of convergence through learning rate adaptation**
<br />
by *Jacobs, Robert A*
<br />
[http://www.sciencedirect.com/science/article/pii/0893608088900032](http://www.sciencedirect.com/science/article/pii/0893608088900032)
<br />
This paper argues that we need (at least) four ingredients
to improve optimization of connectionist
networks: 1. each parameter has its own
stepsize, 2. stepsizes vary over time, 3. if
consecutive gradients of a stepsize have the same sign, the
stepsize should be increased, 4. conversely, if the
stepsize should be decreased if its gradients have opposite
signs. It also proposes to use two
improvements: 1. Momentum (i.e. Polyak's
heavyball), 2. delta-bar-delta (i.e. learning the
stepsize). It has an interesting comment
on the difficulty of learning the stepsize, and therefore comes
up with a ``hack'' that outperforms
momentum.


**Meta-descent for Online, Continual Prediction**
<br />
by *Jacobsen, Andrew and Schlegel, Matthew and Linke, Cameron
and Degris, Thomas and White, Adam and White, Martha*
<br />
[http://arxiv.org/abs/1907.07751](http://arxiv.org/abs/1907.07751)
<br />
The idea is to learn the learning rate so as to
minimize the norm of the gradient. They argue that for the
continual learning setting, this forces the algorithm to
stay ``as stable as possible''. No
theorems, small-scale (but interesting) experiments.


**Adaptation of learning rate parameters**
<br />
by *Sutton, Rich*
<br />
[http://learn2learn.net](http://learn2learn.net)


**Gradient-Based Meta-Learning with Learned Layerwise
Metric and Subspace**
<br />
by *Lee, Yoonho and Choi, Seungjin*
<br />
[http://arxiv.org/abs/1801.05558](http://arxiv.org/abs/1801.05558)


**Meta-Learning with Warped Gradient Descent**
<br />
by *Flennerhag, Sebastian and Rusu, Andrei A and Pascanu, Razvan
and Yin, Hujun and Hadsell, Raia*
<br />
[http://arxiv.org/abs/1909.00025](http://arxiv.org/abs/1909.00025)


**Meta-Learning via Learned Loss**
<br />
by *Chebotar, Yevgen and Molchanov, Artem and Bechtle, Sarah and
Righetti, Ludovic and Meier, Franziska and Sukhatme, Gaurav*
<br />
[http://arxiv.org/abs/1906.05374](http://arxiv.org/abs/1906.05374)
<br />
They learn the loss as a NN, and that loss's objective
is to maximize the sum of rewards. It is provided a bunch of
things, including inputs, outputs,
goals.


**Meta-Curvature**
<br />
by *Park, Eunbyung and Oliva, Junier B*
<br />
[http://arxiv.org/abs/1902.03356](http://arxiv.org/abs/1902.03356)


**Alpha MAML: Adaptive Model-Agnostic Meta-Learning**
<br />
by *Behl, Harkirat Singh and Baydin, At{\i}l{\i}m G{\"u}ne{\c s}
and Torr, Philip H S*
<br />
[http://arxiv.org/abs/1905.07435](http://arxiv.org/abs/1905.07435)
<br />
They combine hypergradient and MAML: adapt all learning
rates at all times.


**Meta-SGD: Learning to Learn Quickly for Few-Shot
Learning**
<br />
by *Li, Zhenguo and Zhou, Fengwei and Chen, Fei and Li, Hang*
<br />
[http://arxiv.org/abs/1707.09835](http://arxiv.org/abs/1707.09835)


**ProMP: Proximal Meta-Policy Search**
<br />
by *Rothfuss, Jonas and Lee, Dennis and Clavera, Ignasi and Asfour,
Tamim and Abbeel, Pieter*
<br />
[http://arxiv.org/abs/1810.06784](http://arxiv.org/abs/1810.06784)


**Model-Agnostic Meta-Learning for Fast Adaptation of Deep
Networks**
<br />
by *Finn, Chelsea and Abbeel, Pieter and Levine, Sergey*
<br />
[http://learn2learn.net](http://learn2learn.net)


**Optimization as a model for few-shot learning**
<br />
by *Ravi, Sachin and Larochelle, Hugo*
<br />
[https://openreview.net/pdf?id=rJY0-Kcll](https://openreview.net/pdf?id=rJY0-Kcll)


**Fast Context Adaptation via Meta-Learning**
<br />
by *Zintgraf, Luisa M and Shiarlis, Kyriacos and Kurin, Vitaly
and Hofmann, Katja and Whiteson, Shimon*
<br />
[http://arxiv.org/abs/1810.03642](http://arxiv.org/abs/1810.03642)


**Meta-Learning with Implicit Gradients**
<br />
by *Rajeswaran, Aravind and Finn, Chelsea and Kakade, Sham and
Levine, Sergey*
<br />
[http://arxiv.org/abs/1909.04630](http://arxiv.org/abs/1909.04630)


**Natural Neural Networks**
<br />
by *Desjardins, Guillaume and Simonyan, Karen and Pascanu, Razvan
and Kavukcuoglu, Koray*
<br />
[http://dl.acm.org/citation.cfm?id=2969442.2969471](http://dl.acm.org/citation.cfm?id=2969442.2969471)


**A Baseline for Few-Shot Image Classification**
<br />
by *Dhillon, Guneet S and Chaudhari, Pratik and Ravichandran,
Avinash and Soatto, Stefano*
<br />
[http://arxiv.org/abs/1909.02729](http://arxiv.org/abs/1909.02729)


**A CLOSER LOOK AT FEW-SHOT CLASSIFICATION**
<br />
by *Chen, Wei-Yu and Liu, Yen-Cheng and Kira, Zsolt*
<br />
[https://openreview.net/pdf?id=HkxLXnAcFQ](https://openreview.net/pdf?id=HkxLXnAcFQ)
<br />
Suggests that meta-learning papers haven't been tested against
classical baselines. When considering those baselines, they perform
better than many of the recent meta-learning techniques.


**Meta-learning with differentiable closed-form solvers**
<br />
by *Bertinetto, Luca and Henriques, Joao F and Torr, Philip and
Vedaldi, Andrea*
<br />
[https://openreview.net/forum?id=HyxnZh0ct7](https://openreview.net/forum?id=HyxnZh0ct7)


**Uncertainty in Model-Agnostic Meta-Learning using
Variational Inference**
<br />
by *Nguyen, Cuong and Do, Thanh-Toan and Carneiro, Gustavo*
<br />
[http://arxiv.org/abs/1907.11864](http://arxiv.org/abs/1907.11864)


**Meta-Reinforcement Learning of Structured Exploration
Strategies**
<br />
by *Gupta, Abhishek and Mendonca, Russell and Liu, Yuxuan and
Abbeel, Pieter and Levine, Sergey*
<br />
[http://arxiv.org/abs/1802.07245](http://arxiv.org/abs/1802.07245)


**Metalearned Neural Memory**
<br />
by *Munkhdalai, Tsendsuren and Sordoni, Alessandro and Wang,
Tong and Trischler, Adam*
<br />
[http://arxiv.org/abs/1907.09720](http://arxiv.org/abs/1907.09720)


**Accelerated Stochastic Approximation**
<br />
by *Kesten, Harry*
<br />
[https://projecteuclid.org/euclid.aoms/1177706705](https://projecteuclid.org/euclid.aoms/1177706705)


**Meta-Learning for Black-box Optimization**
<br />
by *Vishnu, T V and Malhotra, Pankaj and Narwariya, Jyoti and
Vig, Lovekesh and Shroff, Gautam*
<br />
[http://arxiv.org/abs/1907.06901](http://arxiv.org/abs/1907.06901)
<br />
They essentially extend the recurrent meta-learning
framework in a few ways: 1. Use
regret instead of objective improvement as meta-learning
objective. 2. Normalize the objective so as to
make it play nice with LSTMs. 3. Incorporate
domain-constraints, so that the LSTM always outputs feasible
solutions. All are described in
page 3.


**Task Agnostic Continual Learning via Meta Learning**
<br />
by *He, Xu and Sygnowski, Jakub and Galashov, Alexandre and
Rusu, Andrei A and Teh, Yee Whye and Pascanu, Razvan*
<br />
[http://arxiv.org/abs/1906.05201](http://arxiv.org/abs/1906.05201)


**Watch, Try, Learn: Meta-Learning from Demonstrations and
Reward**
<br />
by *Zhou, Allan and Jang, Eric and Kappler, Daniel and Herzog,
Alex and Khansari, Mohi and Wohlhart, Paul and Bai, Yunfei
and Kalakrishnan, Mrinal and Levine, Sergey and Finn,
Chelsea*
<br />
[http://arxiv.org/abs/1906.03352](http://arxiv.org/abs/1906.03352)


**Meta-Learning Representations for Continual Learning**
<br />
by *Javed, Khurram and White, Martha*
<br />
[http://arxiv.org/abs/1905.12588](http://arxiv.org/abs/1905.12588)


**TapNet: Neural Network Augmented with Task-Adaptive
Projection for Few-Shot Learning**
<br />
by *Yoon, Sung Whan and Seo, Jun and Moon, Jaekyun*
<br />
[http://arxiv.org/abs/1905.06549](http://arxiv.org/abs/1905.06549)


**Meta Reinforcement Learning with Task Embedding and Shared
Policy**
<br />
by *Lan, Lin and Li, Zhenguo and Guan, Xiaohong and Wang,
Pinghui*
<br />
[http://arxiv.org/abs/1905.06527](http://arxiv.org/abs/1905.06527)


**Hierarchically Structured Meta-learning**
<br />
by *Yao, Huaxiu and Wei, Ying and Huang, Junzhou and Li, Zhenhui*
<br />
[http://arxiv.org/abs/1905.05301](http://arxiv.org/abs/1905.05301)


**Curious Meta-Controller: Adaptive Alternation between
Model-Based and Model-Free Control in Deep Reinforcement
Learning**
<br />
by *Hafez, Muhammad Burhan and Weber, Cornelius and Kerzel,
Matthias and Wermter, Stefan*
<br />
[http://arxiv.org/abs/1905.01718](http://arxiv.org/abs/1905.01718)


**Learning to Learn in Simulation**
<br />
by *Teng, Ervin and Iannucci, Bob*
<br />
[http://arxiv.org/abs/1902.01569](http://arxiv.org/abs/1902.01569)


**Meta-Learning with Differentiable Convex Optimization**
<br />
by *Lee, Kwonjoon and Maji, Subhransu and Ravichandran, Avinash
and Soatto, Stefano*
<br />
[http://arxiv.org/abs/1904.03758](http://arxiv.org/abs/1904.03758)


**Functional Regularisation for Continual Learning**
<br />
by *Titsias, Michalis K and Schwarz, Jonathan and de G.
Matthews, Alexander G and Pascanu, Razvan and Teh, Yee Whye*
<br />
[http://arxiv.org/abs/1901.11356](http://arxiv.org/abs/1901.11356)


**Learning to Forget for Meta-Learning**
<br />
by *Baik, Sungyong and Hong, Seokil and Lee, Kyoung Mu*
<br />
[http://arxiv.org/abs/1906.05895](http://arxiv.org/abs/1906.05895)


**Meta-learning of Sequential Strategies**
<br />
by *Ortega, Pedro A and Wang, Jane X and Rowland, Mark and
Genewein, Tim and Kurth-Nelson, Zeb and Pascanu, Razvan and
Heess, Nicolas and Veness, Joel and Pritzel, Alex and
Sprechmann, Pablo and Jayakumar, Siddhant M and McGrath, Tom
and Miller, Kevin and Azar, Mohammad and Osband, Ian and
Rabinowitz, Neil and Gy{\"o}rgy, Andr{\'a}s and Chiappa,
Silvia and Osindero, Simon and Teh, Yee Whye and van
Hasselt, Hado and de Freitas, Nando and Botvinick, Matthew
and Legg, Shane*
<br />
[http://arxiv.org/abs/1905.03030](http://arxiv.org/abs/1905.03030)
<br />
This paper essentially provides a theoretical framework to
ground the fact that recurrent meta-learning (RL^2, LLGD^2)
performs Bayesian inference during adaptation.


**Auto-Meta: Automated Gradient Based Meta Learner Search**
<br />
by *Kim, Jaehong and Lee, Sangyeul and Kim, Sungwan and Cha,
Moonsu and Lee, Jung Kwon and Choi, Youngduck and Choi,
Yongseok and Cho, Dong-Yeon and Kim, Jiwon*
<br />
[http://arxiv.org/abs/1806.06927](http://arxiv.org/abs/1806.06927)


**Adaptive Gradient-Based Meta-Learning Methods**
<br />
by *Khodak, Mikhail and Florina-Balcan, Maria and Talwalkar,
Ameet*
<br />
[http://arxiv.org/abs/1906.02717](http://arxiv.org/abs/1906.02717)


**Embedded Meta-Learning: Toward more flexible deep-learning
models**
<br />
by *Lampinen, Andrew K and McClelland, James L*
<br />
[http://arxiv.org/abs/1905.09950](http://arxiv.org/abs/1905.09950)


**Modular meta-learning**
<br />
by *Alet, Ferran and Lozano-P{\'e}rez, Tom{\'a}s and Kaelbling,
Leslie P*
<br />
[http://arxiv.org/abs/1806.10166](http://arxiv.org/abs/1806.10166)


**MetaPred: Meta-Learning for Clinical Risk Prediction
with Limited Patient Electronic Health Records**
<br />
by *Zhang, Xi Sheryl and Tang, Fengyi and Dodge, Hiroko and
Zhou, Jiayu and Wang, Fei*
<br />
[http://arxiv.org/abs/1905.03218](http://arxiv.org/abs/1905.03218)


**Prototypical Networks for Few-shot Learning**
<br />
by *Snell, Jake and Swersky, Kevin and Zemel, Richard S*
<br />
[http://arxiv.org/abs/1703.05175](http://arxiv.org/abs/1703.05175)


**Meta-learners' learning dynamics are unlike learners'**
<br />
by *Rabinowitz, Neil C*
<br />
[http://arxiv.org/abs/1905.01320](http://arxiv.org/abs/1905.01320)


**Backpropamine: training self-modifying neural networks with
differentiable neuromodulated plasticity**
<br />
by *Miconi, Thomas and Rawal, Aditya and Clune, Jeff and Stanley,
Kenneth O*
<br />
[https://openreview.net/forum?id=r1lrAiA5Ym](https://openreview.net/forum?id=r1lrAiA5Ym)


**Reinforcement Learning, Fast and Slow**
<br />
by *Botvinick, Matthew and Ritter, Sam and Wang, Jane X and
Kurth-Nelson, Zeb and Blundell, Charles and Hassabis, Demis*
<br />
[http://dx.doi.org/10.1016/j.tics.2019.02.006](http://dx.doi.org/10.1016/j.tics.2019.02.006)


**Been There, Done That: Meta-Learning with Episodic Recall**
<br />
by *Ritter, Samuel and Wang, Jane X and Kurth-Nelson, Zeb and
Jayakumar, Siddhant M and Blundell, Charles and Pascanu,
Razvan and Botvinick, Matthew*
<br />
[http://arxiv.org/abs/1805.09692](http://arxiv.org/abs/1805.09692)


**Guided Meta-Policy Search**
<br />
by *Mendonca, Russell and Gupta, Abhishek and Kralev, Rosen and
Abbeel, Pieter and Levine, Sergey and Finn, Chelsea*
<br />
[http://arxiv.org/abs/1904.00956](http://arxiv.org/abs/1904.00956)


**Hierarchical Meta Learning**
<br />
by *Zou, Yingtian and Feng, Jiashi*
<br />
[http://arxiv.org/abs/1904.09081](http://arxiv.org/abs/1904.09081)


**A Meta-Transfer Objective for Learning to Disentangle
Causal Mechanisms**
<br />
by *Bengio, Yoshua and Deleu, Tristan and Rahaman, Nasim and Ke,
Rosemary and Lachapelle, S{\'e}bastien and Bilaniuk, Olexa
and Goyal, Anirudh and Pal, Christopher*
<br />
[http://arxiv.org/abs/1901.10912](http://arxiv.org/abs/1901.10912)


**Generalize Across Tasks: Efficient Algorithms for Linear
Representation Learning**
<br />
by *Bullins, Brian and Hazan, Elad and Kalai, Adam and Livni, Roi*
<br />
[http://proceedings.mlr.press/v98/bullins19a.html](http://proceedings.mlr.press/v98/bullins19a.html)


**Incremental Learning-to-Learn with Statistical Guarantees**
<br />
by *Denevi, Giulia and Ciliberto, Carlo and Stamos, Dimitris and
Pontil, Massimiliano*
<br />
[http://arxiv.org/abs/1803.08089](http://arxiv.org/abs/1803.08089)


**A Model of Inductive Bias Learning**
<br />
by *Baxter, J*
<br />
[http://arxiv.org/abs/1106.0245](http://arxiv.org/abs/1106.0245)


**Efficient Off-Policy Meta-Reinforcement Learning via
Probabilistic Context Variables**
<br />
by *Rakelly, Kate and Zhou, Aurick and Quillen, Deirdre and
Finn, Chelsea and Levine, Sergey*
<br />
[http://arxiv.org/abs/1903.08254](http://arxiv.org/abs/1903.08254)


**Continual Learning with Tiny Episodic Memories**
<br />
by *Chaudhry, Arslan and Rohrbach, Marcus and Elhoseiny, Mohamed
and Ajanthan, Thalaiyasingam and Dokania, Puneet K and Torr,
Philip H S and Ranzato, Marc'aurelio*
<br />
[http://arxiv.org/abs/1902.10486](http://arxiv.org/abs/1902.10486)


**Online Meta-Learning**
<br />
by *Finn, Chelsea and Rajeswaran, Aravind and Kakade, Sham and
Levine, Sergey*
<br />
[http://arxiv.org/abs/1902.08438](http://arxiv.org/abs/1902.08438)


**Modulating transfer between tasks in gradient-based meta-learning**
<br />
by *Grant, Erin and Jerfel, Ghassen and Heller, Katherine and
Griffiths, Thomas L*
<br />
[https://openreview.net/pdf?id=HyxpNnRcFX](https://openreview.net/pdf?id=HyxpNnRcFX)


**Learning to Adapt in Dynamic, Real-World Environments
Through Meta-Reinforcement Learning**
<br />
by *Nagabandi, Anusha and Clavera, Ignasi and Liu, Simin and
Fearing, Ronald S and Abbeel, Pieter and Levine, Sergey and
Finn, Chelsea*
<br />
[http://arxiv.org/abs/1803.11347](http://arxiv.org/abs/1803.11347)


**Meta-Learning with Latent Embedding Optimization**
<br />
by *Rusu, Andrei A and Rao, Dushyant and Sygnowski, Jakub and
Vinyals, Oriol and Pascanu, Razvan and Osindero, Simon and
Hadsell, Raia*
<br />
[http://arxiv.org/abs/1807.05960](http://arxiv.org/abs/1807.05960)


**Learning to Generalize: Meta-Learning for Domain
Generalization**
<br />
by *Li, Da and Yang, Yongxin and Song, Yi-Zhe and Hospedales,
Timothy M*
<br />
[http://arxiv.org/abs/1710.03463](http://arxiv.org/abs/1710.03463)


**Some Considerations on Learning to Explore via
Meta-Reinforcement Learning**
<br />
by *Stadie, Bradly C and Yang, Ge and Houthooft, Rein and Chen,
Xi and Duan, Yan and Wu, Yuhuai and Abbeel, Pieter and
Sutskever, Ilya*
<br />
[http://arxiv.org/abs/1803.01118](http://arxiv.org/abs/1803.01118)


**How to train your MAML**
<br />
by *Antoniou, Antreas and Edwards, Harrison and Storkey, Amos*
<br />
[http://arxiv.org/abs/1810.09502](http://arxiv.org/abs/1810.09502)


**Bayesian Model-Agnostic Meta-Learning**
<br />
by *Kim, Taesup and Yoon, Jaesik and Dia, Ousmane and Kim,
Sungwoong and Bengio, Yoshua and Ahn, Sungjin*
<br />
[http://arxiv.org/abs/1806.03836](http://arxiv.org/abs/1806.03836)


**Probabilistic Model-Agnostic Meta-Learning**
<br />
by *Finn, Chelsea and Xu, Kelvin and Levine, Sergey*
<br />
[http://arxiv.org/abs/1806.02817](http://arxiv.org/abs/1806.02817)


**The effects of negative adaptation in Model-Agnostic
Meta-Learning**
<br />
by *Deleu, Tristan and Bengio, Yoshua*
<br />
[http://arxiv.org/abs/1812.02159](http://arxiv.org/abs/1812.02159)


**Memory-based Parameter Adaptation**
<br />
by *Sprechmann, Pablo and Jayakumar, Siddhant M and Rae, Jack W
and Pritzel, Alexander and Badia, Adri{\`a} Puigdom{\`e}nech
and Uria, Benigno and Vinyals, Oriol and Hassabis, Demis and
Pascanu, Razvan and Blundell, Charles*
<br />
[http://arxiv.org/abs/1802.10542](http://arxiv.org/abs/1802.10542)


**Deep Meta-Learning: Learning to Learn in the Concept Space**
<br />
by *Zhou, Fengwei and Wu, Bin and Li, Zhenguo*
<br />
[http://arxiv.org/abs/1802.03596](http://arxiv.org/abs/1802.03596)


**Deep Prior**
<br />
by *Lacoste, Alexandre and Boquet, Thomas and Rostamzadeh, Negar
and Oreshkin, Boris and Chung, Wonchang and Krueger, David*
<br />
[http://arxiv.org/abs/1712.05016](http://arxiv.org/abs/1712.05016)


**Recasting Gradient-Based Meta-Learning as Hierarchical
Bayes**
<br />
by *Grant, Erin and Finn, Chelsea and Levine, Sergey and
Darrell, Trevor and Griffiths, Thomas*
<br />
[http://arxiv.org/abs/1801.08930](http://arxiv.org/abs/1801.08930)


**WNGrad: Learn the Learning Rate in Gradient Descent**
<br />
by *Wu, Xiaoxia and Ward, Rachel and Bottou, L{\'e}on*
<br />
[http://arxiv.org/abs/1803.02865](http://arxiv.org/abs/1803.02865)


**Learning to Learn**
<br />
by *Finn, Chelsea*
<br />
[http://bair.berkeley.edu/blog/2017/07/18/learning-to-learn/](http://bair.berkeley.edu/blog/2017/07/18/learning-to-learn/)


**Continuous Adaptation via Meta-Learning in Nonstationary
and Competitive Environments**
<br />
by *Al-Shedivat, Maruan and Bansal, Trapit and Burda, Yuri and
Sutskever, Ilya and Mordatch, Igor and Abbeel, Pieter*
<br />
[http://arxiv.org/abs/1710.03641](http://arxiv.org/abs/1710.03641)




## Submission Form

<iframe src="https://docs.google.com/forms/d/e/1FAIpQLSeKPfYEttRKN3Lk317cxcNbU454yCTRktXpxMiK_O6PgFq22A/viewform?embedded=true" width="640" height="1200" frameborder="0" marginheight="0" marginwidth="0">Loading…</iframe>
    