import React, { useState, useEffect } from 'react';
import { useTheme } from 'next-themes';
import cn from 'classnames';

const LightDarkModeToggle = (): JSX.Element | null => {
  const [isMounted, setIsMounted] = useState(false);
  const { theme, setTheme } = useTheme();

  useEffect(() => {
    setIsMounted(true);
  }, []);
  if (!isMounted) return null;

  const switchTheme = (): void => {
    if (isMounted) {
      setTheme(theme === 'light' ? 'dark' : 'light');
    }
  };

  return (
    <button aria-label="Toggle Dark Mode" onClick={switchTheme} className="p-1 focus-ring">
      <svg
        fill="none"
        viewBox="0 0 24 24"
        width="24"
        height="24"
        stroke="currentColor"
        className="transition-colors text-black dark:text-white"
      >
        {theme === 'light' ? (
          <path
            strokeLinecap="round"
            strokeLinejoin="round"
            strokeWidth="1.5"
            d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"
          ></path>
        ) : (
          <path
            strokeLinecap="round"
            strokeLinejoin="round"
            strokeWidth="1.5"
            d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"
          ></path>
        )}
      </svg>
    </button>
  );
};

export default LightDarkModeToggle;
