#pragma once

#include "AppleMIDI_Namespace.h"

BEGIN_APPLEMIDI_NAMESPACE

/* used to mask the most significant bit, which flags the start of a new MIDI-command! */
#define RTP_MIDI_COMMAND_STATUS_FLAG 0x80

/* used to mask the lower 7 bits of the single octets that make up the delta-time */
#define RTP_MIDI_DELTA_TIME_OCTET_MASK 0x7f
/* used to mask the most significant bit, which flags the extension of the delta-time */
#define RTP_MIDI_DELTA_TIME_EXTENSION 0x80

#define RTP_MIDI_CS_FLAG_B 0x80
#define RTP_MIDI_CS_FLAG_J 0x40
#define RTP_MIDI_CS_FLAG_Z 0x20
#define RTP_MIDI_CS_FLAG_P 0x10
#define RTP_MIDI_CS_MASK_SHORTLEN 0x0f
#define RTP_MIDI_CS_MASK_LONGLEN 0x0fff

#define RTP_MIDI_CJ_CHAPTER_M_FLAG_J 0x80
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_K 0x40
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_L 0x20
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_M 0x10
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_N 0x08
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_T 0x04
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_V 0x02
#define RTP_MIDI_CJ_CHAPTER_M_FLAG_R 0x01

#define RTP_MIDI_JS_FLAG_S 0x80
#define RTP_MIDI_JS_FLAG_Y 0x40
#define RTP_MIDI_JS_FLAG_A 0x20
#define RTP_MIDI_JS_FLAG_H 0x10
#define RTP_MIDI_JS_MASK_TOTALCHANNELS 0x0f

#define RTP_MIDI_SJ_FLAG_S 0x8000
#define RTP_MIDI_SJ_FLAG_D 0x4000
#define RTP_MIDI_SJ_FLAG_V 0x2000
#define RTP_MIDI_SJ_FLAG_Q 0x1000
#define RTP_MIDI_SJ_FLAG_F 0x0800
#define RTP_MIDI_SJ_FLAG_X 0x0400
#define RTP_MIDI_SJ_MASK_LENGTH 0x03ff

#define RTP_MIDI_SJ_CHAPTER_D_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_B 0x40
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_G 0x20
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_H 0x10
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_J 0x08
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_K 0x04
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_Y 0x02
#define RTP_MIDI_SJ_CHAPTER_D_FLAG_Z 0x01

#define RTP_MIDI_SJ_CHAPTER_D_RESET_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_D_RESET_COUNT 0x7f
#define RTP_MIDI_SJ_CHAPTER_D_TUNE_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_D_TUNE_COUNT 0x7f
#define RTP_MIDI_SJ_CHAPTER_D_SONG_SEL_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_D_SONG_SEL_VALUE 0x7f

#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_FLAG_S 0x8000
#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_FLAG_C 0x4000
#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_FLAG_V 0x2000
#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_FLAG_L 0x1000
#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_MASK_DSZ 0x0c00
#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_MASK_LENGTH 0x03ff
#define RTP_MIDI_SJ_CHAPTER_D_SYSCOM_MASK_COUNT 0xff

#define RTP_MIDI_SJ_CHAPTER_D_SYSREAL_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_D_SYSREAL_FLAG_C 0x40
#define RTP_MIDI_SJ_CHAPTER_D_SYSREAL_FLAG_L 0x20
#define RTP_MIDI_SJ_CHAPTER_D_SYSREAL_MASK_LENGTH 0x1f
#define RTP_MIDI_SJ_CHAPTER_D_SYSREAL_MASK_COUNT 0xff

#define RTP_MIDI_SJ_CHAPTER_Q_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_Q_FLAG_N 0x40
#define RTP_MIDI_SJ_CHAPTER_Q_FLAG_D 0x20
#define RTP_MIDI_SJ_CHAPTER_Q_FLAG_C 0x10
#define RTP_MIDI_SJ_CHAPTER_Q_FLAG_T 0x80
#define RTP_MIDI_SJ_CHAPTER_Q_MASK_TOP 0x07
#define RTP_MIDI_SJ_CHAPTER_Q_MASK_CLOCK 0x07ffff
#define RTP_MIDI_SJ_CHAPTER_Q_MASK_TIMETOOLS 0xffffff

#define RTP_MIDI_SJ_CHAPTER_F_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_F_FLAG_C 0x40
#define RTP_MIDI_SJ_CHAPTER_F_FLAG_P 0x20
#define RTP_MIDI_SJ_CHAPTER_F_FLAG_Q 0x10
#define RTP_MIDI_SJ_CHAPTER_F_FLAG_D 0x08
#define RTP_MIDI_SJ_CHAPTER_F_MASK_POINT 0x07
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT0 0xf0000000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT1 0x0f000000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT2 0x00f00000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT3 0x000f0000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT4 0x0000f000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT5 0x00000f00
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT6 0x000000f0
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MT7 0x0000000f
#define RTP_MIDI_SJ_CHAPTER_F_MASK_HR 0xff000000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_MN 0x00ff0000
#define RTP_MIDI_SJ_CHAPTER_F_MASK_SC 0x0000ff00
#define RTP_MIDI_SJ_CHAPTER_F_MASK_FR 0x000000ff

#define RTP_MIDI_SJ_CHAPTER_X_FLAG_S 0x80
#define RTP_MIDI_SJ_CHAPTER_X_FLAG_T 0x40
#define RTP_MIDI_SJ_CHAPTER_X_FLAG_C 0x20
#define RTP_MIDI_SJ_CHAPTER_X_FLAG_F 0x10
#define RTP_MIDI_SJ_CHAPTER_X_FLAG_D 0x08
#define RTP_MIDI_SJ_CHAPTER_X_FLAG_L 0x04
#define RTP_MIDI_SJ_CHAPTER_X_MASK_STA 0x03
#define RTP_MIDI_SJ_CHAPTER_X_MASK_TCOUNT 0xff
#define RTP_MIDI_SJ_CHAPTER_X_MASK_COUNT 0xff

#define RTP_MIDI_CJ_FLAG_S 0x800000
#define RTP_MIDI_CJ_FLAG_H 0x040000
#define RTP_MIDI_CJ_FLAG_P 0x000080
#define RTP_MIDI_CJ_FLAG_C 0x000040
#define RTP_MIDI_CJ_FLAG_M 0x000020
#define RTP_MIDI_CJ_FLAG_W 0x000010
#define RTP_MIDI_CJ_FLAG_N 0x000008
#define RTP_MIDI_CJ_FLAG_E 0x000004
#define RTP_MIDI_CJ_FLAG_T 0x000002
#define RTP_MIDI_CJ_FLAG_A 0x000001
#define RTP_MIDI_CJ_MASK_LENGTH 0x03ff00
#define RTP_MIDI_CJ_MASK_CHANNEL 0x780000
#define RTP_MIDI_CJ_CHANNEL_SHIFT 19

#define RTP_MIDI_CJ_CHAPTER_M_MASK_LENGTH 0x3f

#define RTP_MIDI_CJ_CHAPTER_N_MASK_LENGTH 0x7f00
#define RTP_MIDI_CJ_CHAPTER_N_MASK_LOW 0x00f0
#define RTP_MIDI_CJ_CHAPTER_N_MASK_HIGH 0x000f

#define RTP_MIDI_CJ_CHAPTER_E_MASK_LENGTH 0x7f
#define RTP_MIDI_CJ_CHAPTER_A_MASK_LENGTH 0x7f

typedef struct PACKED RtpMIDI
{
	uint8_t flags;
} RtpMIDI_t;

END_APPLEMIDI_NAMESPACE
