---
name: Bug report
about: Report something that does not work as intended
title: ''
labels: bug
assignees: ''

---

<!-- 
Before opening an issue, check if your problem already has been solved by looking in:
- The existing issues: https://github.com/lathoub/Arduino-AppleMIDI-Library/issues
- The discussions: https://github.com/lathoub/Arduino-AppleMIDI-Library/discussions

Consider opening a discussion instead of an issue if you need help with your project:
https://github.com/lathoub/Arduino-AppleMIDI-Library/discussions/new
-->

## Context

Using the English language, please answer a few questions to help us understand your problem better and guide you to a solution:

<!-- Tip: place the letter x in the checkboxes to tick them:
- [ ] Unticked checkbox
- [x] Ticked checkbox

You can also tick them by clicking after you've submitted your issue.
 -->

- What board are you using ?
    - `example: Arduino Leonardo`
    - _Please list any shields or other **relevant** hardware you're using_
- What version of the Arduino IDE are you using ?
    - `example: 1.8.5`
- What Operating System are you using for the DAW
    - [ ]  Windows
    - [ ]  MacOS
    - [ ]  Linux
    - [ ]  Other (please specify)
- Is your problem related to:
    - [ ]  Setup
    - [ ]  Connecting
    - [ ]  AppleMIDI <> MIDI
    - [ ]  Dropped messages
- How comfortable are you with code ?
    - [ ]  Complete beginner
    - [ ]  I've done basic projects
    - [ ]  I know my way around C/C++
    - [ ]  Advanced / professional

## Describe your project and what you expect to happen:

<!--
Example: When I press a switch on my pedalboard, it sends a SysEx message that I'd like to receive on my Arduino.

Note: Attachments (circuit diagrams, code examples) are most welcome and will help us understand your needs better and find a suitable solution for your issue.
-->

## Describe your problem (what does not work):

<!-- 
Example: I cannot receive SysEx messages coming from my AxeFX 2
-->

## Steps to reproduce

<!--
Please list the steps you took to hit the problem, so we can try and reproduce it.
-->
