## 🌲 Stanford LastMile Challenge 

Build a project that uses AI Config (and AI workbooks). You can use Google Colab or a script. Make sure to include a README.md for your project describing what you built and how you used AIConfig.

Suggestions:

- AI-powered Apps: Example: [AI Teaching Assistant x Streamlit](https://github.com/lastmile-ai/aiconfig/tree/main/cookbooks/Basic-Prompt-Routing)
- Chatbots: Example: [WizardGPT](https://github.com/lastmile-ai/aiconfig/tree/main/cookbooks/Wizard-GPT)
- Prompt Engineering Techniques: [Example Chain-of-Verification](https://github.com/lastmile-ai/aiconfig/tree/main/cookbooks/Chain-of-Verification)

## How to Enter:

1. Fork the [AIConfig Github repo](https://github.com/lastmile-ai/aiconfig) & submit a pull request with a new folder for your project inside of this [ competition folder](https://github.com/lastmile-ai/aiconfig/tree/main/workshops/Stanford/competition). Deadline to submit the PR is November 28th 12:00 PST.
   
2. Send us an email at [team@lastmileai.dev](mailto:team@lastmileai.dev) once you've submitted your PR.
3. Have quesitons? Join our [discord](https://discord.com/invite/xBhNKTetGx) and ask the team. 

**Requirements for PR Submission** 

Colab Notebook
  1. .ipynb of the notebook (download from Colab directly)
  2. AIConfig .json file
  3. README.md with instructions

Script
  1. .py or .js files
  2. AIConfig .json file
  3. README.md with instructions


## Rubric 
**Creativity and Originality:** The project should be unique and not a copy of existing projects. It should display creativity in using AIConfig and AI workbooks.

**Functionality**: The project should work properly without bugs or errors and be reproducible for others to easily clone.

**Use of AIConfig**: The project should effectively and innovatively integrate AIConfig and AI workbooks. The degree to which AI Config is utilized will be taken into account.

**Documentation**: The README.md file should clearly explain the project, including what it does, how it works, and how AIConfig and AI workbooks are used.

**Submission before the deadline**: Submitting the project on time via a PR to the designated folder is a must before November 28, 2023 12:00 AM PST. Make sure to also send us an email at [team@lastmileai.dev](mailto:team@lastmileai.dev) once you have submitted the PR so that we can contact you if you win. 


## Additional info

How to submit a PR: https://opensource.com/article/19/7/create-pull-request-github
