# Function Calling with OpenAI & AIConfig

[![colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/drive/1RZ5s2XmD-Gkg64QlS80lgwOFT3F7J346)

This example is taken from [OpenAI's function calling demo](https://github.com/openai/openai-node/blob/v4/examples/function-call-stream.ts) and modified to show how the same functionality can be done more simply with AIConfig.

This notebook serves as a practical guide for leveraging AIConfig and function calling with OpenAI models. We start with a mock database of books and functions to list, search, and retrieve books. Function calling is enabled so the LLM can interpret a user's question, determine the appropriate function to call, and execute the function. Read more about [Function Calling with Open AI](https://openai.com/blog/function-calling-and-other-api-updates) and [AIConfig for prompt and model management](https://github.com/lastmile-ai/aiconfig).

[Google Colab notebook](https://colab.research.google.com/drive/1RZ5s2XmD-Gkg64QlS80lgwOFT3F7J346)
