# Chain-of-Verification (CoVe) Template

This template provides a structured Colab notebook designed to implement the CoVe technique, a prompt engineering method aimed at reducing hallucinations in responses from large language models (LLMs).

### Overview

The CoVe technique enhances the reliability of LLMs by generating a baseline response to a user query and then validating the information through a series of verification questions. This iterative process helps to correct any errors in the initial response, leading to more accurate and trustworthy outputs. **[ Link to Paper](https://arxiv.org/pdf/2309.11495.pdf)**

### Getting Started

To use this template, follow these simple steps:

1. **Download AIConfig File**: Download the AIConfig `cove_template_config.json` [here](https://github.com/lastmile-ai/aiconfig/blob/main/cookbooks/Chain-of-Verification/cove_template_config.json). This AIConfig contains the necessary prompt templates and model parameters to run the CoVe pipeline.
2. **Follow Colab Notebook Instructions:** Open the provided Colab notebook and follow the detailed instructions within. The notebook will guide you through the process of setting up your environment and executing the CoVe technique for your use case.

Colab Notebooks

- [CoVe GPT4 Template](https://colab.research.google.com/drive/1h_Cneit5S2wI4nVPKI8AWGzTadFHwDk3#scrollTo=k3tsITZhVFp-)

### Prerequisites

Before you begin, ensure you have the following:

1. OpenAI API Key - if you're using the GPT4 template notebook, you'll need an OpenAI API key that you'll need to load to Colab.
2. The `cove_template_config.json` file downloaded.

### Support & Questions

If you encounter any issues or have questions regarding the CoVe template, please open an issue in the AIConfig repo and we will be happy to assist you. Alternatively, ask us directly on Discord! https://discord.com/invite/xBhNKTetGx
