/**
 * Copyright (c) LastMile AI, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 */

import React from "react";
import useBaseUrl from "@docusaurus/core/lib/client/exports/useBaseUrl";

type CommandProps = {
  /**
   * Name of the Sapling subcommand to link to. Command aliases are also
   * supported.
   */
  name: string;

  /**
   * If specified, overrides `name` as the the text to use fo the link.
   */
  linkText?: string;
};

/** Creates a link to the corresponding documentation page for the command. */
export function Command({ name, linkText }: CommandProps) {
  const command = mapAliasToCommand(name);
  const label = linkText ?? name;
  return (
    <a href={useBaseUrl(`/docs/commands/${command}`)}>
      <code>{label}</code>
    </a>
  );
}

/** Shorthand for <Command> where `sl ${name}` is used as the linkText. */
export function SLCommand({ name }: CommandProps) {
  return <Command name={name} linkText={`sl ${name}`} />;
}

// TODO(mbolin): This should be autogenerated as a byproduct of running
// scripts/generate-command-markdown.py.
function mapAliasToCommand(alias: string): string {
  switch (alias) {
    case "go":
      return "goto";
    case "isl":
      return "web";
  }

  return alias;
}

export function ReviewStackScreenshot() {
  return (
    <p style={{ textAlign: "center" }}>
      <img src={useBaseUrl("/img/reviewstack-demo.gif")} width={800} />
    </p>
  );
}

export function Video({ src }) {
  return (
    <video controls>
      <source src={useBaseUrl(src)} />
    </video>
  );
}
