<p align="center">
    <img src="src/assets/preview/logo.png" width="150">
</p>

<p align="center">
    <a href="https://github.com/luciano-work/angular-tailwind/stargazers">
        <img height= "24" src="https://img.shields.io/github/stars/luciano-work/angular-tailwind?colorA=1e1e28&colorB=c9cbff&style=for-the-badge">
    </a>
    <a href="https://github.com/luciano-work/angular-tailwind/issues">
        <img height= "24" src="https://img.shields.io/github/issues/luciano-work/angular-tailwind?colorA=1e1e28&colorB=f7be95&style=for-the-badge">
    </a>
    <a href="https://github.com/luciano-work/angular-tailwind/contributors">
        <img height= "24" src="https://img.shields.io/github/contributors/luciano-work/angular-tailwind?colorA=1e1e28&colorB=b1e1a6&style=for-the-badge">
    </a>
</p>

#### Motivation

For me, the best strategy for learning new skills is to practice. I have created this project to learn more about Tailwind CSS using my favorite framework (Angular). I have to tell you, Tailwind is amazing!

<b><img src="https://cdn-icons-png.flaticon.com/512/6897/6897039.png" width="14"/> The project is not finished yet!</b>

See [Demo](https://at.lanno.dev) page.

<p>
  <img alt="Preview" src="src/assets/preview/preview.gif">
</p>

#### Versions

<a href="https://angular.io"><img height= "24" src= "https://img.shields.io/badge/Angular 18-DD0031?style=for-the-badge&logo=angular&logoColor=white"></a> <a href="https://tailwindcss.com"><img height= "24" src= "https://img.shields.io/badge/Tailwind 3-0ea5e9?style=for-the-badge&logo=tailwind-css&logoColor=white"></a>

#### Features

- [x] Sidebar
- [x] Dark Theme
- [x] Navbar
- [x] Footer
- [x] Auth Module
- [x] Dashboard Module
- [x] Standalone components
- [x] Angular Signals
- [x] Multi Theme
- [x] Tests E2E
- [ ] Guards
- [ ] Animations
- [ ] Jasmine to Jest

#### Commands

| command                   | What it does?                                 |
| ------------------------- | :-------------------------------------------- |
| `npm start`               | Starts the server in dev mode                 |
| `npm run lint`            | Runs ESLint on project                        |
| `npm run prettier`        | Runs prettier on entire src folder            |
| `npm run prettier:verify` | Runs prettier-check and throws error if fails |
| `npm run prettier:staged` | Runs prettier on only staged (changed) files  |
| `npm run test:e2e`        | Runs playwright e2e test with UI              |

#### Dependencies

| Package            | What it does?                                                                               | Link                                                   |
| ------------------ | :------------------------------------------------------------------------------------------ | :----------------------------------------------------- |
| `angular-svg-icon` | Provides a means to inline SVG files to allow for them to be easily styled by CSS and code. | [Here](https://www.npmjs.com/package/angular-svg-icon) |
| `apexcharts`       | Modern & Interactive Open-source Charts                                                     | [Here](https://www.npmjs.com/package/apexcharts)       |
| `ng-apexcharts`    | Angular wrapper for ApexCharts to build interactive visualizations in Angular.              | [Here](https://www.npmjs.com/package/ng-apexcharts)    |

#### Dev Dependencies

| Package                       | What it does?                                                                                            | Link                                                              |
| ----------------------------- | :------------------------------------------------------------------------------------------------------- | :---------------------------------------------------------------- |
| `prettier`                    | An opinionated code formatter                                                                            | [Here](https://www.npmjs.com/package/prettier)                    |
| `prettier-plugin-tailwindcss` | A Prettier plugin for Tailwind CSS that automatically sorts classes based on our recommended class order | [Here](https://www.npmjs.com/package/prettier-plugin-tailwindcss) |
| `tailwind-scrollbar`          | Tailwind plugin for styling scrollbars.                                                                  | [Here](https://www.npmjs.com/package/tailwind-scrollbar)          |
| `tailwindcss`                 | A utility-first CSS framework for rapidly building custom user interfaces.                               | [Here](https://www.npmjs.com/package/tailwindcss)                 |

#### Icons and Patterns

This project use [Hero Icons](https://heroicons.com/) , [Hero Patterns](https://heropatterns.com/) and [Popsys illustrations](https://popsy.co/)

#### Sponsors ❤️

Check out our awesome sponsors!

[<img src="https://avatars.githubusercontent.com/u/19482926?v=4" width="50">](https://github.com/jhonnygarcia)
[<img src="https://avatars.githubusercontent.com/u/44730111?v=4" width="50">](https://github.com/ramses-i)

### Repo Activity

![Alt](https://repobeats.axiom.co/api/embed/75671ffcba2d7e21fb5ceb8e32598fb8335cfa20.svg 'Repobeats analytics image')

#### Disclaimer

The Tailwind name and logos are trademarks of Tailwind Labs Inc.
The Angular name and logos are trademarks of Google.
