# Contributing Guidelines

Thank you for considering contributing to our project! We appreciate your interest in making it better. Please review the following guidelines to help streamline the process.

## Table of Contents
- [Code of Conduct](#code-of-conduct)
- [Getting Started](#getting-started)
- [How to Contribute](#how-to-contribute)
- [Commit Standards](#commit-standards)
- [Styling](#styling)
- [Pull Requests](#pull-requests)

## Code of Conduct
Please note that we have a [Code of Conduct](CODE_OF_CONDUCT.md), which we expect all contributors to follow. Respectful and constructive interactions help everyone involved.

## Getting Started
1. Fork the repository.
2. Clone your fork: `git clone https://github.com/your-username/your-forked-repo.git`
3. Create a new branch for each feature or bugfix: `git checkout -b feature/your-feature-name`
4. Make your changes and commit them following the commit standards below.

## How to Contribute
- **Report Issues:** Found a bug or have a suggestion? Feel free to [open an issue](https://github.com/lannodev/angular-tailwind).
- **Submit Enhancements:** If you have an idea for improving the project, please [open an issue](https://github.com/lannodev/angular-tailwind) to discuss it before implementing changes.
- **Help with Documentation:** Improvements to our documentation are always welcome.

## Commit Standards
This project follows [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/). Please use the following types in your commit messages:
- `feat:` for new features
- `fix:` for bug fixes
- `docs:` for documentation changes
- `style:` for formatting (non-functional)
- `refactor:` for code changes that do not fix bugs or add features
- `test:` for adding or updating tests
- `chore:` for maintenance

Example commit message:
feat: add user authentication feature

## Styling
This project uses [Tailwind CSS](https://tailwindcss.com/) for styling. Follow our existing patterns and utility classes to ensure consistency. Please avoid adding custom CSS if Tailwind provides a utility that accomplishes the same effect.

## Pull Requests
1. Ensure your changes follow the above guidelines.
2. Make sure all tests pass.
3. Submit the pull request to the `main` branch.
4. Your pull request should:
   - Reference related issues if applicable (e.g., `Closes #123`)
   - Use a descriptive title following Conventional Commits
5. Our team will review your pull request as soon as possible.

Thank you for your contribution!
