@info "running integrated transmission-distribution power flow (pfitd) for Hybrid formulations tests"

@testset "test/pfitd_hybrids.jl" begin

    @testset "solve_model (with network inputs): Unbalanced case5-case3 Without Dist. Generator ACR-FBS" begin
        pm_file = joinpath(dirname(trans_path), "case5_withload.m")
        pmd_file = joinpath(dirname(dist_path), "case3_unbalanced_withoutgen.dss")
        pmitd_file = joinpath(dirname(bound_path), "case5_case3_unbal_nogen.json")
        pmitd_type = NLBFPowerModelITD{ACRPowerModel, FBSUBFPowerModel}
        pmitd_data = parse_files(pm_file, pmd_file, pmitd_file)
        result = solve_model(pmitd_data, pmitd_type, ipopt, build_pfitd)
        @test result["termination_status"] == LOCALLY_SOLVED
    end

    @testset "solve_model (with network inputs): Unbalanced case5-case3 Without Dist. Generator ACR-FOTR" begin
        pm_file = joinpath(dirname(trans_path), "case5_withload.m")
        pmd_file = joinpath(dirname(dist_path), "case3_unbalanced_withoutgen.dss")
        pmitd_file = joinpath(dirname(bound_path), "case5_case3_unbal_nogen.json")
        pmitd_type = NLFOTPowerModelITD{ACRPowerModel, FOTRUPowerModel}
        pmitd_data = parse_files(pm_file, pmd_file, pmitd_file)
        result = solve_model(pmitd_data, pmitd_type, ipopt, build_pfitd)
        @test result["termination_status"] == LOCALLY_SOLVED
    end

    ## This unit test has been disabled due to the test failing in all CI Julia 1-latest runs due to NUMERICAL_ERROR (Windows)
    # @testset "solve_model (with network inputs): Unbalanced case5-case3 Without Dist. Generator ACR-FOTP" begin
    #     pm_file = joinpath(dirname(trans_path), "case5_withload.m")
    #     pmd_file = joinpath(dirname(dist_path), "case3_unbalanced_withoutgen.dss")
    #     pmitd_file = joinpath(dirname(bound_path), "case5_case3_unbal_nogen.json")
    #     pmitd_type = NLFOTPowerModelITD{ACPPowerModel, FOTPUPowerModel}
    #     pmitd_data = parse_files(pm_file, pmd_file, pmitd_file)
    #     result = solve_model(pmitd_data, pmitd_type, ipopt, build_pfitd)
    #     @test result["termination_status"] == LOCALLY_SOLVED
    # end

    ## This unit test has been disabled due to the test failing in all CI Julia 1 & nigthly-latest runs due to ITERATION_LIMIT
    # @testset "solve_model (with network inputs): Unbalanced case5-case3 Without Dist. Generator SOCBF-LinDist3FlowPowerModel" begin
    #     pm_file = joinpath(dirname(trans_path), "case5_withload.m")
    #     pmd_file = joinpath(dirname(dist_path), "case3_unbalanced_withoutgen.dss")
    #     pmitd_file = joinpath(dirname(bound_path), "case5_case3_unbal_nogen.json")
    #     pmitd_type = BFPowerModelITD{SOCBFPowerModel, LinDist3FlowPowerModel}
    #     pmitd_data = parse_files(pm_file, pmd_file, pmitd_file)
    #     result = solve_model(pmitd_data, pmitd_type, ipopt, build_pfitd)
    #     @test result["termination_status"] == LOCALLY_SOLVED
    # end

    @testset "solve_model (with network inputs): Unbalanced case5-case3 Without Dist. Generator BFA-LinDist3FlowPowerModel" begin
        pm_file = joinpath(dirname(trans_path), "case5_withload.m")
        pmd_file = joinpath(dirname(dist_path), "case3_unbalanced_withoutgen.dss")
        pmitd_file = joinpath(dirname(bound_path), "case5_case3_unbal_nogen.json")
        pmitd_type = BFPowerModelITD{BFAPowerModel, LinDist3FlowPowerModel}
        pmitd_data = parse_files(pm_file, pmd_file, pmitd_file)
        result = solve_model(pmitd_data, pmitd_type, ipopt, build_pfitd)
        @test result["termination_status"] == LOCALLY_SOLVED
    end
end
