%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%                                                                  %%%%%
%%%%    IEEE PES Power Grid Library - Optimal Power Flow - v21.07     %%%%%
%%%%          (https://github.com/power-grid-lib/pglib-opf)           %%%%%
%%%%               Benchmark Group - Typical Operations               %%%%%
%%%%                         29 - July - 2021                         %%%%%
%%%%                                                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   This is a synthetic 500 bus case, developed for use in ARPA-e's Grid
%   Optimization Competition, Challenge 1.
%
%   https://gocompetition.energy.gov/challenges/22/datasets
%
%   When publishing results based on this data, please cite:
%
%   [1] A.B. Birchfield, T. Xu, K.M. Gegner, K.S. Shetye, T.J. Overbye,
%       "Grid Structural Characteristics as Validation Criteria for
%       Synthetic Networks," IEEE Transactions on Power Systems, 2017.
%
%   February, 2020
%
%   Copyright (c) 2020 by A.B. Birchfield, H. Li, J. Wert, J. Yeo, T. Xu,
%   and T.J. Overbye
%   Licensed under the Creative Commons Attribution 4.0 International license,
%   http://creativecommons.org/licenses/by/4.0/
%
function mpc = pglib_opf_case500_goc
mpc.version = '2';
mpc.baseMVA = 100.0;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	 1	 35.618824	 6.5737227	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	2	 1	 98.249974	 27.511604	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	3	 1	 48.647106	 11.129965	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	4	 1	 85.907798	 3.746604	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	5	 1	 84.780273	 14.432042	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	6	 1	 62.478442	 5.521289	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	7	 1	 49.784158	 17.19519	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	8	 1	 64.701608	 7.0712876	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	9	 1	 20.503948	 8.8063929	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	10	 1	 46.413917	 14.1549	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	11	 1	 16.100847	 3.9200655	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	12	 1	 43.588438	 2.8695031	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	13	 1	 61.22114	 10.723958	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	14	 1	 130.84189	 52.410125	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	15	 1	 104.28734	 12.652581	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	16	 1	 27.228169	 9.9052567	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	17	 1	 32.011464	 13.061043	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	18	 1	 119.67057	 30.774143	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	19	 1	 65.320532	 13.431944	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	20	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	21	 1	 58.218813	 18.966129	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	22	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	23	 1	 29.018699	 6.2106536	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	24	 1	 54.279955	 33.954042	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	25	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	26	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	27	 1	 102.98049	 33.448899	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	28	 1	 61.334173	 20.664905	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	29	 1	 50.934864	 10.690247	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	30	 1	 52.921548	 2.7888621	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	31	 1	 96.443918	 21.502746	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	32	 1	 78.803641	 26.902654	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	33	 1	 173.87396	 98.108359	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	34	 1	 62.111172	 13.143542	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	35	 1	 114.97555	 12.155419	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	36	 1	 135.53799	 51.442293	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	37	 1	 163.47215	 36.679462	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	38	 1	 94.238784	 20.040841	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	39	 1	 133.70834	 50.68181	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	40	 1	 153.11126	 18.774944	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	41	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	42	 1	 98.133807	 30.734596	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	43	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	44	 1	 77.880051	 5.0373808	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	45	 1	 302.57835	 18.48031	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	46	 1	 114.29507	 24.00707	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	47	 1	 88.231203	 9.1999478	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	48	 1	 72.71207	 7.1365783	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	49	 1	 127.71185	 15.181496	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	50	 1	 86.944338	 53.880018	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	51	 1	 88.686916	 19.421573	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	52	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	53	 1	 171.6378	 44.16329	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	54	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	55	 1	 36.123908	 3.9151884	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	56	 1	 38.577879	 3.9945162	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	57	 1	 19.683228	 6.0811296	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	58	 1	 43.832014	 35.835862	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	59	 1	 42.90744	 17.471748	 0.0	 90.8493130009	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	60	 1	 22.945448	 9.1966579	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	61	 1	 44.969939	 9.759103	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	62	 1	 36.437586	 4.474327	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	63	 1	 71.680313	 17.142062	 0.0	 -0.769859349578	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	64	 1	 31.844114	 8.0677761	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	65	 1	 63.899352	 9.1908374	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	66	 1	 36.679289	 10.617765	 0.0	 25.1105326653	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	67	 1	 28.707733	 7.2100171	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	68	 1	 28.62912	 5.4703638	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	69	 1	 32.067628	 8.0925529	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	70	 1	 39.196158	 3.9775994	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	71	 1	 60.374539	 8.4751114	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	72	 1	 56.946907	 9.9333583	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	73	 1	 70.414725	 10.349797	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	74	 1	 60.758304	 25.733148	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	75	 1	 40.775379	 8.4048883	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	76	 1	 43.071256	 4.3092484	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	77	 1	 57.295706	 18.331089	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	78	 1	 54.007001	 18.028247	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	79	 1	 54.265083	 10.902562	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	80	 1	 46.069768	 21.190099	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	81	 1	 54.507951	 17.693866	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	82	 1	 111.64362	 24.13123	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	83	 1	 101.04494	 24.905649	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	84	 1	 56.110567	 11.571753	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	85	 1	 32.550342	 12.181852	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	86	 1	 59.545233	 10.884686	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	87	 1	 65.981712	 22.630096	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	88	 1	 47.343404	 10.039575	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	89	 1	 74.818328	 17.494879	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	90	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	91	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	92	 1	 106.47708	 17.937195	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	93	 1	 40.21293	 5.3027836	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	94	 1	 46.5641	 6.1192811	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	95	 1	 46.010271	 23.126542	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	96	 1	 33.93057	 6.3354304	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	97	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	98	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	99	 1	 97.74846	 38.282719	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	100	 1	 38.554521	 12.141577	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	101	 1	 45.161533	 22.880496	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	102	 1	 29.186281	 7.8144916	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	103	 1	 34.30703	 9.7968422	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	104	 1	 24.265991	 5.5635958	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	105	 1	 39.916997	 11.441166	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	106	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	107	 1	 75.513667	 1.3391346	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	108	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	109	 1	 49.64731	 13.461957	 0.0	 24.7928450645	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	110	 1	 54.65649	 8.3286733	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	111	 1	 93.172043	 20.327059	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	112	 1	 99.668833	 59.004116	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	113	 1	 52.670777	 21.324699	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	114	 1	 40.69928	 12.372287	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	115	 1	 77.71488	 14.88003	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	116	 1	 88.038082	 18.358639	 0.0	 52.8084832569	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	117	 1	 68.182582	 7.6680951	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	118	 1	 92.360117	 11.407371	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	119	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	120	 1	 85.816859	 23.336996	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	121	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	122	 1	 54.397196	 9.0923423	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	123	 1	 71.147368	 33.993187	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	124	 1	 83.926724	 7.3449827	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	125	 1	 83.155053	 31.193835	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	126	 1	 36.25305	 3.666049	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	127	 1	 29.818337	 16.407276	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	128	 1	 35.782628	 2.4228445	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	129	 1	 51.809298	 15.49727	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	130	 1	 31.251404	 13.832106	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	131	 1	 34.958927	 7.636337	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	132	 1	 52.063316	 19.148102	 0.0	 49.7024353103	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	133	 1	 19.636888	 8.9944631	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	134	 1	 38.948873	 4.3593831	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	135	 1	 0.0	 0.0	 0.0	 21.7328832732	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	136	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	137	 1	 51.54586	 9.903541	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	138	 1	 58.676665	 17.430486	 0.0	 94.7667573409	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	139	 1	 71.483796	 14.183202	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	140	 1	 72.496609	 22.65969	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	141	 1	 81.951796	 40.60647	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	142	 1	 22.847942	 4.5029059	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	143	 1	 42.563165	 21.293882	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	144	 1	 35.494926	 8.3704275	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	145	 1	 78.917738	 30.005083	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	146	 1	 44.649313	 13.401109	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	147	 1	 65.73686	 21.35948	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	148	 1	 87.010729	 41.888415	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	149	 1	 109.81274	 17.012804	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	150	 1	 169.63527	 52.74781	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	151	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	152	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	153	 1	 157.10017	 35.911907	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	154	 1	 53.456581	 10.636111	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	155	 1	 90.361803	 14.921995	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	156	 1	 73.742886	 28.154261	 0.0	 118.046712728	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	157	 1	 37.965472	 26.039832	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	158	 1	 99.232414	 16.632599	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	159	 1	 73.406892	 14.440844	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	160	 1	 36.396681	 14.792214	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	161	 1	 28.658666	 5.7080747	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	162	 1	 26.355874	 8.7299695	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	163	 1	 36.962971	 3.8905286	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	164	 1	 39.57328	 5.63349	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	165	 1	 124.00109	 13.81438	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	166	 1	 74.25287	 16.429664	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	167	 1	 40.830164	 10.040794	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	168	 1	 72.906616	 23.714286	 0.0	 34.2518507631	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	169	 1	 40.186614	 21.45574	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	170	 1	 99.319971	 23.82538	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	171	 1	 115.38626	 31.220929	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	172	 1	 63.642405	 19.895522	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	173	 1	 33.992307	 4.577169	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	174	 1	 136.21012	 69.077179	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	175	 1	 98.379266	 4.0944475	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	176	 1	 68.807669	 42.520355	 0.0	 273.909700488	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	177	 1	 165.22394	 27.018245	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	178	 1	 190.80659	 44.515712	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	179	 1	 75.32883	 20.81102	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	180	 1	 42.215803	 6.3904744	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	181	 1	 50.836476	 8.987556	 0.0	 0.000593243029123	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	182	 1	 112.80944	 14.469464	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	183	 1	 93.87775	 19.613303	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	184	 1	 76.916709	 31.744798	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	185	 1	 93.268528	 3.438134	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	186	 1	 92.221114	 21.672864	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	187	 1	 163.8891	 73.256722	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	188	 1	 53.146808	 14.762756	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	189	 1	 39.007399	 3.6469169	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	190	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	191	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	192	 1	 131.01594	 31.623052	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	193	 1	 77.65605	 23.362786	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	194	 1	 70.681819	 16.974466	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	195	 1	 80.464995	 14.654426	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	196	 1	 68.678582	 13.070455	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	197	 1	 38.369874	 7.1977718	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	198	 1	 52.283712	 19.787616	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	199	 1	 66.679247	 2.5058577	 0.0	 -17.2164488869	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	200	 1	 61.922848	 16.822065	 0.0	 22.9029846928	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	201	 1	 75.085301	 10.673837	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	202	 1	 75.445478	 7.4763981	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	203	 1	 87.311704	 47.77642	 0.0	 47.8370455544	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	204	 1	 48.883844	 13.029987	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	205	 1	 49.609832	 37.268477	 0.0	 39.9999706967	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	206	 1	 34.434987	 11.713269	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	207	 1	 73.010358	 14.02102	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	208	 1	 42.843497	 8.2248639	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	209	 1	 102.283	 14.093087	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	210	 1	 40.283257	 13.549747	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	211	 1	 55.533771	 10.478198	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	212	 1	 42.931959	 9.461712	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	213	 1	 118.43144	 25.488612	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	214	 1	 76.773486	 36.008752	 0.0	 333.007590632	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	215	 1	 52.438174	 15.214533	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	216	 1	 63.710364	 17.745517	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	217	 1	 64.320623	 24.076342	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	218	 1	 63.523476	 30.609688	 0.0	 42.6780980627	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	219	 1	 28.921845	 7.1339415	 0.0	 28.2999557637	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	220	 1	 38.550198	 13.162834	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	221	 1	 55.423356	 9.8928384	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	222	 1	 71.250819	 18.793297	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	223	 1	 98.25231	 29.000562	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	224	 1	 109.62065	 24.023945	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	225	 1	 16.260821	 0.91371576	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	226	 1	 45.486665	 6.4891222	 0.0	 50.7987857754	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	227	 1	 64.367433	 15.626112	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	228	 1	 57.160741	 9.048557	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	229	 1	 43.347966	 9.9598385	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	230	 1	 29.83468	 3.2496672	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	231	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	232	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	233	 1	 61.503415	 6.1719496	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	234	 1	 122.12821	 6.5438173	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	235	 1	 65.338161	 29.233391	 0.0	 48.3738374079	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	236	 1	 49.259233	 13.692239	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	237	 1	 23.298485	 8.5587562	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	238	 1	 77.011105	 8.6606294	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	239	 1	 108.3489	 32.451416	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	240	 1	 44.620964	 8.6824325	 0.0	 54.709696178	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	241	 1	 35.410508	 5.9169012	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	242	 1	 71.336978	 12.841235	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	243	 1	 115.31549	 18.961417	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	244	 1	 98.932188	 26.154757	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	245	 1	 33.438792	 10.558386	 0.0	 39.9339334054	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	246	 1	 132.70426	 60.798429	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	247	 1	 44.892347	 2.1095738	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	248	 1	 48.913579	 10.154008	 0.0	 106.113090811	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	249	 1	 54.281705	 11.318227	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	250	 1	 18.771027	 4.9461098	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	251	 1	 112.55859	 6.9614653	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	252	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	253	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	254	 1	 106.54204	 55.622479	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	255	 1	 52.503343	 23.154611	 0.0	 64.5214056091	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	256	 1	 83.6972	 27.02769	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	257	 1	 73.130955	 6.388942	 0.0	 -25.1892515543	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	258	 1	 83.663981	 32.082817	 0.0	 -52.538904705	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	259	 1	 65.653582	 32.51961	 0.0	 19.7586427849	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	260	 1	 73.667209	 19.883548	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	261	 1	 61.268208	 10.712222	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	262	 1	 54.981753	 7.0084739	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	263	 1	 31.246076	 7.6504414	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	264	 1	 24.58151	 13.05744	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	265	 1	 32.184137	 9.0431222	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	266	 1	 52.085655	 5.8624177	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	267	 1	 76.00083	 12.385866	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	268	 1	 96.661316	 35.385498	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	269	 1	 29.577831	 11.57261	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	270	 1	 28.806832	 3.8196797	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	271	 1	 24.518489	 11.95717	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	272	 2	 94.874123	 33.978024	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	273	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	274	 1	 19.857506	 3.2327704	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	275	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	276	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	277	 2	 21.587604	 1.4926696	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	278	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	279	 1	 65.181061	 28.309397	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	280	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	281	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	282	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	283	 1	 46.822228	 9.3032363	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	284	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	285	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	286	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	287	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	288	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	289	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	290	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	291	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	292	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	293	 1	 82.879113	 23.748622	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	294	 1	 42.326655	 7.6516767	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	295	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	296	 1	 26.437925	 12.155357	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	297	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	298	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	299	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	300	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	301	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	302	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	303	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	304	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	305	 1	 17.47165	 6.5354069	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	306	 2	 24.707977	 6.9447067	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	307	 2	 20.788554	 8.4780081	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	308	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	309	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	310	 1	 26.569575	 10.834736	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	311	 3	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	312	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	313	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	314	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	315	 1	 28.821221	 6.6251027	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	316	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	317	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	318	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	319	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	320	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	321	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	322	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	323	 1	 6.1026702	 2.0705808	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	324	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	325	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	326	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	327	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	328	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	329	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	330	 2	 28.607097	 6.9527037	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	331	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	332	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	333	 1	 65.998734	 3.4222302	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	334	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 24.0	 1	    1.10000	    0.90000;
	335	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	336	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	337	 1	 6.1773376	 1.4309847	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	338	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	339	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	340	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	341	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	342	 1	 7.3234902	 2.4741104	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	343	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	344	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	345	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	346	 2	 8.0707531	 2.1681249	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	347	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	348	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	349	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	350	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	351	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	352	 1	 14.16372	 5.0631296	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	353	 1	 4.9543315	 0.23688144	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	354	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	355	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	356	 2	 32.855296	 5.0755952	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	357	 2	 46.85709	 33.217979	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	358	 2	 22.165399	 8.5270039	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	359	 2	 54.230477	 6.9383726	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	360	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	361	 1	 43.192629	 10.249115	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	362	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	363	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	364	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	365	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	366	 1	 5.1225567	 1.2692577	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	367	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	368	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	369	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	370	 1	 17.014444	 4.4631849	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	371	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	372	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	373	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	374	 1	 0.091213132	 0.024323502	 0.0	 39.5883121729	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	375	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	376	 1	 1.618239	 0.24084968	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	377	 1	 12.908702	 5.2720275	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	378	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	379	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	380	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	381	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	382	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	383	 1	 79.315526	 17.397031	 0.0	 -5.87556561979	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	384	 2	 20.46594	 11.807237	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	385	 1	 0.0	 0.0	 0.0	 -9.49933283605	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	386	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	387	 1	 4.3260264	 0.71403963	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	388	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	389	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	390	 1	 24.399377	 4.9612335	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	391	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	392	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	393	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 24.0	 1	    1.10000	    0.90000;
	394	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	395	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	396	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	397	 1	 51.748709	 3.935921	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	398	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	399	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	400	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	401	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	402	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	403	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	404	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	405	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	406	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	407	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.2	 1	    1.10000	    0.90000;
	408	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	409	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	410	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	411	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	412	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	413	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	414	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	415	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	416	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	417	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	418	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	419	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	420	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	421	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	422	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	423	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	424	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	425	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	426	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	427	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	428	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	429	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	430	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	431	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	432	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	433	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	434	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	435	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	436	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	437	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 24.0	 1	    1.10000	    0.90000;
	438	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	439	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	440	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	441	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	442	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	443	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	444	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	445	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	446	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	447	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	448	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	449	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	450	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 24.0	 1	    1.10000	    0.90000;
	451	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	452	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	453	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	454	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	455	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	456	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	457	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	458	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 24.0	 1	    1.10000	    0.90000;
	459	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 24.0	 1	    1.10000	    0.90000;
	460	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	461	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	462	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	463	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	464	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 18.0	 1	    1.10000	    0.90000;
	465	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	466	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	467	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	468	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	469	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	470	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	471	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	472	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	473	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	474	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	475	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	476	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	477	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	478	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	479	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	480	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	481	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	482	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	483	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	484	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	485	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 22.0	 1	    1.10000	    0.90000;
	486	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	487	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	488	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	489	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	490	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	491	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	492	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	493	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	494	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.10000	    0.90000;
	495	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	496	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	497	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	498	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	499	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	500	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin
mpc.gen = [
	272	 34.463	 7.856	 18.01	 -2.298	 1.0	 46.9	 1	 46.9	 22.026;
	275	 0.0	 0.0	 326.858	 -72.832	 1.0	 888.2	 0	 888.2	 146.11;
	276	 643.217	 127.013	 326.858	 -72.832	 1.0	 888.2	 1	 888.2	 398.234;
	277	 16.691	 4.1875	 9.6	 -1.225	 1.0	 25.0	 1	 25.0	 8.382;
	277	 13.858	 4.1875	 9.6	 -1.225	 1.0	 25.0	 1	 25.0	 2.716;
	277	 17.3305	 4.1875	 9.6	 -1.225	 1.0	 25.0	 1	 25.0	 9.661;
	277	 16.8255	 4.1875	 9.6	 -1.225	 1.0	 25.0	 1	 25.0	 8.651;
	280	 118.674	 31.581	 80.778	 -17.616	 1.0	 158.7	 1	 158.7	 78.648;
	281	 0.0	 0.0	 80.778	 -17.616	 1.0	 158.7	 0	 158.7	 68.611;
	284	 135.035	 43.2495	 110.623	 -24.124	 1.0	 217.33	 1	 217.333	 52.737;
	285	 136.374	 43.2495	 110.623	 -24.124	 1.0	 217.33	 1	 217.333	 55.415;
	286	 143.288	 43.2495	 110.623	 -24.124	 1.0	 217.33	 1	 217.333	 69.243;
	287	 0.0	 0.0	 110.623	 -24.124	 1.0	 217.33	 0	 217.333	 64.598;
	288	 0.0	 0.0	 110.623	 -24.124	 1.0	 217.33	 0	 217.333	 52.424;
	289	 122.406	 43.2495	 110.623	 -24.124	 1.0	 217.33	 1	 217.333	 27.479;
	292	 0.28	 0.0835	 0.192	 -0.025	 1.0	 0.5	 1	 0.5	 0.06;
	292	 0.313	 0.0835	 0.192	 -0.025	 1.0	 0.5	 1	 0.5	 0.126;
	294	 0.0	 0.0	 9.162	 -1.998	 1.0	 18.0	 0	 18.0	 5.517;
	297	 130.6165	 35.515	 90.84	 -19.81	 1.0	 178.47	 1	 178.467	 82.766;
	298	 132.5635	 35.515	 90.84	 -19.81	 1.0	 178.47	 1	 178.467	 86.66;
	299	 0.0	 0.0	 90.84	 -19.81	 1.0	 178.47	 0	 178.467	 63.99;
	300	 121.061	 35.515	 90.84	 -19.81	 1.0	 178.47	 1	 178.467	 63.655;
	301	 0.0	 0.0	 90.84	 -19.81	 1.0	 178.47	 0	 178.467	 54.225;
	302	 121.1655	 35.515	 90.84	 -19.81	 1.0	 178.47	 1	 178.467	 63.864;
	303	 42.106	 11.306	 25.92	 -3.308	 1.0	 67.5	 1	 67.5	 16.712;
	303	 40.629	 11.306	 25.92	 -3.308	 1.0	 67.5	 1	 67.5	 13.758;
	306	 0.0	 0.0	 3.262	 -0.854	 1.0	 7.0	 0	 7.0	 1.745;
	306	 3.891	 1.204	 3.262	 -0.854	 1.0	 7.0	 1	 7.0	 0.782;
	307	 22.668	 5.645	 12.941	 -1.651	 1.0	 33.7	 1	 33.7	 11.636;
	307	 24.2095	 5.645	 12.941	 -1.651	 1.0	 33.7	 1	 33.7	 14.719;
	307	 0.0	 0.0	 12.941	 -1.651	 1.0	 33.7	 0	 33.7	 6.952;
	311	 0.0	 0.0	 428.597	 -95.503	 1.0	 1164.67	 0	 1164.667	 186.084;
	312	 809.527	 166.547	 428.597	 -95.503	 1.0	 1164.67	 1	 1164.667	 454.387;
	313	 806.4555	 166.547	 428.597	 -95.503	 1.0	 1164.67	 1	 1164.667	 448.244;
	316	 237.492	 66.191	 169.302	 -36.92	 1.0	 332.62	 1	 332.617	 142.367;
	317	 0.0	 0.0	 169.302	 -36.92	 1.0	 332.62	 0	 332.617	 38.676;
	318	 184.7845	 66.191	 169.302	 -36.92	 1.0	 332.62	 1	 332.617	 36.952;
	319	 209.1735	 66.191	 169.302	 -36.92	 1.0	 332.62	 1	 332.617	 85.73;
	320	 0.0	 0.0	 169.302	 -36.92	 1.0	 332.62	 0	 332.617	 130.581;
	321	 0.0	 0.0	 169.302	 -36.92	 1.0	 332.62	 0	 332.617	 84.68;
	324	 0.0	 0.0	 61.08	 -13.32	 1.0	 120.0	 0	 120.0	 31.702;
	325	 86.33	 23.88	 61.08	 -13.32	 1.0	 120.0	 1	 120.0	 52.66;
	326	 88.9155	 23.88	 61.08	 -13.32	 1.0	 120.0	 1	 120.0	 57.831;
	327	 0.0	 0.0	 61.08	 -13.32	 1.0	 120.0	 0	 120.0	 55.972;
	328	 84.224	 23.88	 61.08	 -13.32	 1.0	 120.0	 1	 120.0	 48.448;
	329	 70.3275	 23.88	 61.08	 -13.32	 1.0	 120.0	 1	 120.0	 20.655;
	330	 0.6295	 0.172	 0.466	 -0.122	 1.0	 1.0	 1	 1.0	 0.259;
	330	 0.5715	 0.172	 0.466	 -0.122	 1.0	 1.0	 1	 1.0	 0.143;
	330	 0.674	 0.172	 0.466	 -0.122	 1.0	 1.0	 1	 1.0	 0.348;
	330	 0.7045	 0.172	 0.466	 -0.122	 1.0	 1.0	 1	 1.0	 0.409;
	334	 42.423	 11.868	 32.154	 -8.418	 1.0	 69.0	 1	 69.0	 15.846;
	335	 0.0	 0.0	 32.154	 -8.418	 1.0	 69.0	 0	 69.0	 12.549;
	338	 174.097	 46.7355	 119.539	 -26.068	 1.0	 234.85	 1	 234.85	 113.344;
	339	 165.63	 46.7355	 119.539	 -26.068	 1.0	 234.85	 1	 234.85	 96.41;
	340	 0.0	 0.0	 119.539	 -26.068	 1.0	 234.85	 0	 234.85	 83.983;
	341	 164.3445	 46.7355	 119.539	 -26.068	 1.0	 234.85	 1	 234.85	 93.839;
	343	 0.0	 0.0	 83.569	 -21.879	 1.0	 179.33	 0	 179.333	 41.662;
	344	 108.947	 30.845	 83.569	 -21.879	 1.0	 179.33	 1	 179.333	 38.561;
	345	 0.0	 0.0	 83.569	 -21.879	 1.0	 179.33	 0	 179.333	 80.146;
	346	 33.0455	 9.6515	 24.687	 -5.384	 1.0	 48.5	 1	 48.5	 17.591;
	346	 35.5875	 9.6515	 24.687	 -5.384	 1.0	 48.5	 1	 48.5	 22.675;
	347	 0.0	 0.0	 28.8	 -3.675	 1.0	 75.0	 0	 75.0	 36.562;
	347	 54.1725	 12.5625	 28.8	 -3.675	 1.0	 75.0	 1	 75.0	 33.345;
	347	 52.459	 12.5625	 28.8	 -3.675	 1.0	 75.0	 1	 75.0	 29.918;
	350	 17.738	 4.824	 11.059	 -1.411	 1.0	 28.8	 1	 28.8	 6.676;
	351	 21.4925	 4.824	 11.059	 -1.411	 1.0	 28.8	 1	 28.8	 14.185;
	351	 19.996	 4.824	 11.059	 -1.411	 1.0	 28.8	 1	 28.8	 11.192;
	351	 19.417	 4.824	 11.059	 -1.411	 1.0	 28.8	 1	 28.8	 10.034;
	354	 71.5885	 21.89	 55.99	 -12.21	 1.0	 110.0	 1	 110.0	 33.177;
	356	 22.006	 5.081	 11.648	 -1.486	 1.0	 30.33	 1	 30.333	 13.679;
	356	 17.979	 5.081	 11.648	 -1.486	 1.0	 30.33	 1	 30.333	 5.625;
	356	 0.0	 0.0	 11.648	 -1.486	 1.0	 30.33	 0	 30.333	 12.388;
	357	 13.687	 3.6465	 9.879	 -2.586	 1.0	 21.2	 1	 21.2	 6.174;
	358	 36.4625	 8.819	 20.218	 -2.58	 1.0	 52.65	 1	 52.65	 20.275;
	358	 38.8985	 8.819	 20.218	 -2.58	 1.0	 52.65	 1	 52.65	 25.147;
	358	 36.023	 8.819	 20.218	 -2.58	 1.0	 52.65	 1	 52.65	 19.396;
	358	 0.0	 0.0	 20.218	 -2.58	 1.0	 52.65	 0	 52.65	 15.946;
	359	 0.0	 0.0	 14.048	 -3.064	 1.0	 27.6	 0	 27.6	 11.587;
	359	 20.4465	 5.492	 14.048	 -3.064	 1.0	 27.6	 1	 27.6	 13.293;
	362	 392.1035	 121.346	 328.763	 -86.071	 1.0	 705.5	 1	 705.5	 78.707;
	363	 391.8455	 121.346	 328.763	 -86.071	 1.0	 705.5	 1	 705.5	 78.191;
	364	 0.0	 0.0	 328.763	 -86.071	 1.0	 705.5	 0	 705.5	 259.966;
	365	 495.8065	 121.346	 328.763	 -86.071	 1.0	 705.5	 1	 705.5	 286.113;
	367	 11.3645	 3.4335	 7.872	 -1.005	 1.0	 20.5	 1	 20.5	 2.229;
	368	 14.7755	 3.4335	 7.872	 -1.005	 1.0	 20.5	 1	 20.5	 9.051;
	368	 0.0	 0.0	 7.872	 -1.005	 1.0	 20.5	 0	 20.5	 6.32;
	369	 0.0	 0.0	 7.872	 -1.005	 1.0	 20.5	 0	 20.5	 9.565;
	371	 178.966	 48.8825	 132.437	 -34.672	 1.0	 284.2	 1	 284.2	 73.732;
	372	 209.049	 48.8825	 132.437	 -34.672	 1.0	 284.2	 1	 284.2	 133.898;
	375	 15.8795	 4.975	 12.725	 -2.775	 1.0	 25.0	 1	 25.0	 6.759;
	378	 148.7015	 46.123	 117.973	 -25.727	 1.0	 231.77	 1	 231.775	 65.628;
	379	 149.218	 46.123	 117.973	 -25.727	 1.0	 231.77	 1	 231.775	 66.661;
	380	 131.406	 46.123	 117.973	 -25.727	 1.0	 231.77	 1	 231.775	 31.037;
	381	 172.6965	 46.123	 117.973	 -25.727	 1.0	 231.77	 1	 231.775	 113.618;
	382	 0.0	 0.0	 2.842	 -0.363	 1.0	 7.4	 0	 7.4	 3.554;
	382	 5.1625	 1.2395	 2.842	 -0.363	 1.0	 7.4	 1	 7.4	 2.925;
	382	 4.139	 1.2395	 2.842	 -0.363	 1.0	 7.4	 1	 7.4	 0.878;
	382	 4.7965	 1.2395	 2.842	 -0.363	 1.0	 7.4	 1	 7.4	 2.193;
	384	 0.0	 0.0	 5.76	 -0.735	 1.0	 15.0	 0	 15.0	 5.179;
	384	 11.1675	 2.5125	 5.76	 -0.735	 1.0	 15.0	 1	 15.0	 7.335;
	384	 9.073	 2.5125	 5.76	 -0.735	 1.0	 15.0	 1	 15.0	 3.146;
	384	 8.689	 2.5125	 5.76	 -0.735	 1.0	 15.0	 1	 15.0	 2.378;
	386	 47.404	 11.2785	 25.856	 -3.299	 1.0	 67.33	 1	 67.333	 27.475;
	386	 48.736	 11.2785	 25.856	 -3.299	 1.0	 67.33	 1	 67.333	 30.139;
	386	 39.1825	 11.2785	 25.856	 -3.299	 1.0	 67.33	 1	 67.333	 11.032;
	386	 46.2705	 11.2785	 25.856	 -3.299	 1.0	 67.33	 1	 67.333	 25.208;
	386	 39.964	 11.2785	 25.856	 -3.299	 1.0	 67.33	 1	 67.333	 12.595;
	386	 0.0	 0.0	 25.856	 -3.299	 1.0	 67.33	 0	 67.333	 7.468;
	391	 89.373	 28.158	 72.023	 -15.707	 1.0	 141.5	 1	 141.5	 37.246;
	392	 0.0	 0.0	 72.023	 -15.707	 1.0	 141.5	 0	 141.5	 45.823;
	393	 0.0	 0.0	 72.023	 -15.707	 1.0	 141.5	 0	 141.5	 59.806;
	394	 0.0	 0.0	 72.023	 -15.707	 1.0	 141.5	 0	 141.5	 46.001;
	395	 19.08	 4.9415	 11.328	 -1.445	 1.0	 29.5	 1	 29.5	 8.66;
	395	 21.751	 4.9415	 11.328	 -1.445	 1.0	 29.5	 1	 29.5	 14.002;
	396	 22.052	 4.9415	 11.328	 -1.445	 1.0	 29.5	 1	 29.5	 14.604;
	396	 18.506	 4.9415	 11.328	 -1.445	 1.0	 29.5	 1	 29.5	 7.512;
	396	 17.8405	 4.9415	 11.328	 -1.445	 1.0	 29.5	 1	 29.5	 6.181;
	396	 21.674	 4.9415	 11.328	 -1.445	 1.0	 29.5	 1	 29.5	 13.848;
	398	 53.8725	 15.7875	 40.381	 -8.806	 1.0	 79.33	 1	 79.333	 28.412;
	398	 53.118	 15.7875	 40.381	 -8.806	 1.0	 79.33	 1	 79.333	 26.903;
	398	 48.24	 15.7875	 40.381	 -8.806	 1.0	 79.33	 1	 79.333	 17.147;
	398	 48.8045	 15.7875	 40.381	 -8.806	 1.0	 79.33	 1	 79.333	 18.276;
	398	 55.47	 15.7875	 40.381	 -8.806	 1.0	 79.33	 1	 79.333	 31.607;
	398	 53.4175	 15.7875	 40.381	 -8.806	 1.0	 79.33	 1	 79.333	 27.502;
	399	 0.863	 0.251	 0.576	 -0.074	 1.0	 1.5	 1	 1.5	 0.226;
	399	 0.0	 0.0	 0.576	 -0.074	 1.0	 1.5	 0	 1.5	 0.589;
	401	 0.0	 0.0	 31.176	 -6.799	 1.0	 61.25	 0	 61.25	 22.338;
	402	 42.557	 12.1885	 31.176	 -6.799	 1.0	 61.25	 1	 61.25	 23.864;
	404	 31.01	 7.1185	 16.32	 -2.083	 1.0	 42.5	 1	 42.5	 19.52;
	404	 29.0165	 7.1185	 16.32	 -2.083	 1.0	 42.5	 1	 42.5	 15.533;
	404	 27.7565	 7.1185	 16.32	 -2.083	 1.0	 42.5	 1	 42.5	 13.013;
	404	 27.5805	 7.1185	 16.32	 -2.083	 1.0	 42.5	 1	 42.5	 12.661;
	407	 63.9935	 21.691	 55.481	 -12.099	 1.0	 109.0	 1	 109.0	 18.987;
	408	 61.8655	 21.691	 55.481	 -12.099	 1.0	 109.0	 1	 109.0	 14.731;
	409	 70.785	 21.691	 55.481	 -12.099	 1.0	 109.0	 1	 109.0	 32.57;
	410	 65.653	 21.691	 55.481	 -12.099	 1.0	 109.0	 1	 109.0	 22.306;
	411	 61.5715	 21.691	 55.481	 -12.099	 1.0	 109.0	 1	 109.0	 14.143;
	412	 66.2415	 21.691	 55.481	 -12.099	 1.0	 109.0	 1	 109.0	 23.483;
	413	 32.777	 9.0285	 20.698	 -2.641	 1.0	 53.9	 1	 53.9	 11.654;
	416	 0.0	 0.0	 165.029	 -43.205	 1.0	 354.14	 0	 354.14	 67.963;
	417	 242.657	 60.912	 165.029	 -43.205	 1.0	 354.14	 1	 354.14	 131.174;
	418	 0.0	 0.0	 165.029	 -43.205	 1.0	 354.14	 0	 354.14	 149.645;
	419	 205.3915	 60.912	 165.029	 -43.205	 1.0	 354.14	 1	 354.14	 56.643;
	420	 211.0205	 60.912	 165.029	 -43.205	 1.0	 354.14	 1	 354.14	 67.901;
	421	 0.0	 0.0	 26.213	 -5.717	 1.0	 51.5	 0	 51.5	 24.828;
	421	 37.7185	 10.248	 26.213	 -5.717	 1.0	 51.5	 1	 51.5	 23.937;
	424	 191.3985	 46.44	 125.82	 -32.94	 1.0	 270.0	 1	 270.0	 112.797;
	425	 0.0	 0.0	 125.82	 -32.94	 1.0	 270.0	 0	 270.0	 87.627;
	426	 186.408	 46.44	 125.82	 -32.94	 1.0	 270.0	 1	 270.0	 102.816;
	427	 184.922	 46.44	 125.82	 -32.94	 1.0	 270.0	 1	 270.0	 99.844;
	428	 0.0	 0.0	 125.82	 -32.94	 1.0	 270.0	 0	 270.0	 67.953;
	431	 139.595	 44.775	 114.525	 -24.975	 1.0	 225.0	 1	 225.0	 54.19;
	432	 166.877	 44.775	 114.525	 -24.975	 1.0	 225.0	 1	 225.0	 108.754;
	433	 150.335	 44.775	 114.525	 -24.975	 1.0	 225.0	 1	 225.0	 75.67;
	434	 157.032	 44.775	 114.525	 -24.975	 1.0	 225.0	 1	 225.0	 89.064;
	437	 0.0	 0.0	 114.83	 -25.042	 1.0	 225.6	 0	 225.6	 110.17;
	438	 0.0	 0.0	 114.83	 -25.042	 1.0	 225.6	 0	 225.6	 58.277;
	439	 157.882	 44.894	 114.83	 -25.042	 1.0	 225.6	 1	 225.6	 90.164;
	440	 128.7	 44.894	 114.83	 -25.042	 1.0	 225.6	 1	 225.6	 31.8;
	441	 27.017	 7.1525	 16.397	 -2.092	 1.0	 42.7	 1	 42.7	 11.334;
	441	 30.288	 7.1525	 16.397	 -2.092	 1.0	 42.7	 1	 42.7	 17.876;
	441	 29.1975	 7.1525	 16.397	 -2.092	 1.0	 42.7	 1	 42.7	 15.695;
	443	 0.0	 0.0	 1.527	 -0.333	 1.0	 3.0	 0	 3.0	 1.43;
	443	 0.0	 0.0	 1.527	 -0.333	 1.0	 3.0	 0	 3.0	 0.466;
	444	 2.0705	 0.597	 1.527	 -0.333	 1.0	 3.0	 1	 3.0	 1.141;
	444	 0.0	 0.0	 1.527	 -0.333	 1.0	 3.0	 0	 3.0	 1.295;
	448	 206.461	 48.7345	 132.036	 -34.567	 1.0	 283.34	 1	 283.34	 129.582;
	449	 210.545	 48.7345	 132.036	 -34.567	 1.0	 283.34	 1	 283.34	 137.75;
	450	 198.3295	 48.7345	 132.036	 -34.567	 1.0	 283.34	 1	 283.34	 113.319;
	451	 183.774	 48.7345	 132.036	 -34.567	 1.0	 283.34	 1	 283.34	 84.208;
	452	 174.746	 48.7345	 132.036	 -34.567	 1.0	 283.34	 1	 283.34	 66.152;
	453	 0.0	 0.0	 9.331	 -1.191	 1.0	 24.3	 0	 24.3	 11.536;
	453	 17.6065	 4.07	 9.331	 -1.191	 1.0	 24.3	 1	 24.3	 10.913;
	453	 16.7525	 4.07	 9.331	 -1.191	 1.0	 24.3	 1	 24.3	 9.205;
	456	 131.5465	 37.213	 95.183	 -20.757	 1.0	 187.0	 1	 187.0	 76.093;
	457	 116.005	 37.213	 95.183	 -20.757	 1.0	 187.0	 1	 187.0	 45.01;
	458	 108.6965	 37.213	 95.183	 -20.757	 1.0	 187.0	 1	 187.0	 30.393;
	459	 131.5655	 37.213	 95.183	 -20.757	 1.0	 187.0	 1	 187.0	 76.131;
	462	 192.012	 54.579	 139.602	 -30.444	 1.0	 274.27	 1	 274.267	 109.757;
	463	 176.318	 54.579	 139.602	 -30.444	 1.0	 274.27	 1	 274.267	 78.369;
	464	 0.0	 0.0	 139.602	 -30.444	 1.0	 274.27	 0	 274.267	 58.535;
	466	 17.9105	 4.2295	 9.696	 -1.237	 1.0	 25.25	 1	 25.25	 10.571;
	466	 15.498	 4.2295	 9.696	 -1.237	 1.0	 25.25	 1	 25.25	 5.746;
	470	 372.7975	 96.75	 262.125	 -68.625	 1.0	 562.5	 1	 562.5	 183.095;
	471	 326.623	 96.75	 262.125	 -68.625	 1.0	 562.5	 1	 562.5	 90.746;
	472	 16.1055	 4.876	 12.471	 -2.719	 1.0	 24.5	 1	 24.5	 7.711;
	472	 17.4695	 4.876	 12.471	 -2.719	 1.0	 24.5	 1	 24.5	 10.439;
	475	 0.0	 0.0	 11.213	 -1.431	 1.0	 29.2	 0	 29.2	 9.221;
	475	 16.712	 4.891	 11.213	 -1.431	 1.0	 29.2	 1	 29.2	 4.224;
	476	 21.567	 4.891	 11.213	 -1.431	 1.0	 29.2	 1	 29.2	 13.934;
	478	 34.6005	 9.811	 25.094	 -5.472	 1.0	 49.3	 1	 49.3	 19.901;
	478	 34.2015	 9.811	 25.094	 -5.472	 1.0	 49.3	 1	 49.3	 19.103;
	481	 0.0	 0.0	 187.593	 -49.112	 1.0	 402.56	 0	 402.56	 154.153;
	482	 0.0	 0.0	 187.593	 -49.112	 1.0	 402.56	 0	 402.56	 86.185;
	483	 295.8225	 69.2405	 187.593	 -49.112	 1.0	 402.56	 1	 402.56	 189.085;
	484	 258.232	 69.2405	 187.593	 -49.112	 1.0	 402.56	 1	 402.56	 113.904;
	485	 0.0	 0.0	 187.593	 -49.112	 1.0	 402.56	 0	 402.56	 56.892;
	486	 16.2365	 4.8295	 11.072	 -1.413	 1.0	 28.83	 1	 28.833	 3.64;
	486	 20.6945	 4.8295	 11.072	 -1.413	 1.0	 28.83	 1	 28.833	 12.556;
	486	 0.0	 0.0	 11.072	 -1.413	 1.0	 28.83	 0	 28.833	 13.66;
	486	 17.7785	 4.8295	 11.072	 -1.413	 1.0	 28.83	 1	 28.833	 6.724;
	486	 0.0	 0.0	 11.072	 -1.413	 1.0	 28.83	 0	 28.833	 6.272;
	486	 19.1545	 4.8295	 11.072	 -1.413	 1.0	 28.83	 1	 28.833	 9.476;
	487	 8.084	 2.4875	 6.363	 -1.388	 1.0	 12.5	 1	 12.5	 3.668;
	488	 3.6445	 1.0775	 2.47	 -0.315	 1.0	 6.43	 1	 6.433	 0.856;
	488	 4.4	 1.0775	 2.47	 -0.315	 1.0	 6.43	 1	 6.433	 2.367;
	488	 4.599	 1.0775	 2.47	 -0.315	 1.0	 6.43	 1	 6.433	 2.765;
	488	 4.58	 1.0775	 2.47	 -0.315	 1.0	 6.43	 1	 6.433	 2.727;
	488	 3.8645	 1.0775	 2.47	 -0.315	 1.0	 6.43	 1	 6.433	 1.296;
	488	 3.8525	 1.0775	 2.47	 -0.315	 1.0	 6.43	 1	 6.433	 1.272;
	489	 0.861	 0.2465	 0.668	 -0.175	 1.0	 1.43	 1	 1.433	 0.289;
	489	 0.8465	 0.2465	 0.668	 -0.175	 1.0	 1.43	 1	 1.433	 0.26;
	489	 0.957	 0.2465	 0.668	 -0.175	 1.0	 1.43	 1	 1.433	 0.481;
	489	 1.0085	 0.2465	 0.668	 -0.175	 1.0	 1.43	 1	 1.433	 0.584;
	489	 0.9595	 0.2465	 0.668	 -0.175	 1.0	 1.43	 1	 1.433	 0.486;
	489	 1.047	 0.2465	 0.668	 -0.175	 1.0	 1.43	 1	 1.433	 0.661;
	490	 0.0	 0.0	 1.731	 -0.377	 1.0	 3.4	 0	 3.4	 1.129;
	493	 90.533	 27.86	 71.26	 -15.54	 1.0	 140.0	 1	 140.0	 41.066;
	494	 89.4515	 27.86	 71.26	 -15.54	 1.0	 140.0	 1	 140.0	 38.903;
	496	 50.1505	 15.159	 34.752	 -4.434	 1.0	 90.5	 1	 90.5	 9.801;
	496	 63.005	 15.159	 34.752	 -4.434	 1.0	 90.5	 1	 90.5	 35.51;
	499	 1.1875	 0.2905	 0.666	 -0.085	 1.0	 1.73	 1	 1.733	 0.642;
	499	 1.0915	 0.2905	 0.666	 -0.085	 1.0	 1.73	 1	 1.733	 0.45;
	499	 1.2695	 0.2905	 0.666	 -0.085	 1.0	 1.73	 1	 1.733	 0.806;
];

%% generator cost data
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.001690	   8.281000	   0.000000;
	2	 0.0	 0.0	 3	   0.001098	   9.109000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.010070	  18.500000	  -1.038000;
	2	 0.0	 0.0	 3	   0.013050	  18.520000	  -1.241000;
	2	 0.0	 0.0	 3	   0.019700	  17.870000	  -1.920000;
	2	 0.0	 0.0	 3	   0.016940	  17.820000	  -1.692000;
	2	 0.0	 0.0	 3	   0.019150	  19.410000	  -2.137000;
	2	 0.0	 0.0	 3	   0.017170	  18.520000	  -1.849000;
	2	 0.0	 0.0	 3	   0.023960	  20.120000	  -2.329000;
	2	 0.0	 0.0	 3	   0.021150	  16.500000	  -1.566000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  16.970000	  -1.147000;
	2	 0.0	 0.0	 3	   0.012190	  20.990000	  -1.359000;
	2	 0.0	 0.0	 3	   0.010660	  17.090000	  -1.219000;
	2	 0.0	 0.0	 3	   0.013440	  15.740000	  -1.309000;
	2	 0.0	 0.0	 3	   0.015790	  19.370000	  -1.534000;
	2	 0.0	 0.0	 3	   0.016000	  17.230000	  -1.430000;
	2	 0.0	 0.0	 3	   0.018660	  19.150000	  -1.817000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.001698	   8.351000	   0.000000;
	2	 0.0	 0.0	 3	   0.001218	   9.206000	   0.000000;
	2	 0.0	 0.0	 3	   0.001222	   9.188000	   0.000000;
	2	 0.0	 0.0	 3	   0.014560	  22.580000	  -2.889000;
	2	 0.0	 0.0	 3	   0.019870	  18.430000	  -2.180000;
	2	 0.0	 0.0	 3	   0.025510	  19.590000	  -2.757000;
	2	 0.0	 0.0	 3	   0.021190	  19.740000	  -3.255000;
	2	 0.0	 0.0	 3	   0.013340	  19.170000	  -2.543000;
	2	 0.0	 0.0	 3	   0.016620	  18.320000	  -2.537000;
	2	 0.0	 0.0	 3	   0.017550	  17.290000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  18.680000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  18.590000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  20.010000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  17.630000	   0.000000;
	2	 0.0	 0.0	 3	   0.015310	  18.120000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  34.420000	 -36.100000;
	2	 0.0	 0.0	 3	   0.000000	  31.180000	 -42.120000;
	2	 0.0	 0.0	 3	   0.012560	  20.310000	  -1.884000;
	2	 0.0	 0.0	 3	   0.014320	  20.600000	  -1.960000;
	2	 0.0	 0.0	 3	   0.012620	  16.140000	  -1.616000;
	2	 0.0	 0.0	 3	   0.014230	  18.960000	  -1.933000;
	2	 0.0	 0.0	 3	   0.039500	  32.400000	  -3.114000;
	2	 0.0	 0.0	 3	   0.042360	  30.500000	  -3.223000;
	2	 0.0	 0.0	 3	   0.025470	  31.940000	  -2.792000;
	2	 0.0	 0.0	 3	   0.000000	  15.880000	  -7.369000;
	2	 0.0	 0.0	 3	   0.000000	  16.240000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  18.250000	 -59.220000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  16.890000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  17.240000	   0.000000;
	2	 0.0	 0.0	 3	   0.072380	  32.400000	 -16.600000;
	2	 0.0	 0.0	 3	   0.097060	  41.560000	 -22.210000;
	2	 0.0	 0.0	 3	   0.063720	  60.650000	 -24.900000;
	2	 0.0	 0.0	 3	   0.046190	  57.640000	 -18.860000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.055110	  35.080000	  -7.252000;
	2	 0.0	 0.0	 3	   0.036110	  40.510000	  -6.465000;
	2	 0.0	 0.0	 3	   0.000000	  16.810000	  -2.082000;
	2	 0.0	 0.0	 3	   0.017430	  19.430000	  -1.954000;
	2	 0.0	 0.0	 3	   0.020330	  20.520000	  -2.296000;
	2	 0.0	 0.0	 3	   0.022590	  17.810000	  -1.818000;
	2	 0.0	 0.0	 3	   0.014000	  21.090000	  -2.093000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.016320	  15.850000	  -1.077000;
	2	 0.0	 0.0	 3	   0.014350	  17.200000	  -1.051000;
	2	 0.0	 0.0	 3	   0.013150	  16.850000	  -1.112000;
	2	 0.0	 0.0	 3	   0.015430	  18.810000	  -1.131000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  18.600000	 -22.780000;
	2	 0.0	 0.0	 3	   0.000000	  16.850000	 -20.940000;
	2	 0.0	 0.0	 3	   0.000000	  17.230000	 -18.240000;
	2	 0.0	 0.0	 3	   0.000000	  18.160000	 -21.240000;
	2	 0.0	 0.0	 3	   0.000000	  17.980000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  18.590000	 -25.380000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  17.740000	 -13.650000;
	2	 0.0	 0.0	 3	   0.000000	  14.550000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  17.440000	 -39.950000;
	2	 0.0	 0.0	 3	   0.000000	  17.680000	 -39.850000;
	2	 0.0	 0.0	 3	   0.000000	  16.670000	 -51.690000;
	2	 0.0	 0.0	 3	   0.000000	  17.290000	 -40.040000;
	2	 0.0	 0.0	 3	   0.000000	  15.920000	 -38.620000;
	2	 0.0	 0.0	 3	   0.017820	  18.550000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.070060	  36.300000	  -9.988000;
	2	 0.0	 0.0	 3	   0.043610	  36.450000	  -8.580000;
	2	 0.0	 0.0	 3	   0.048840	  45.530000	 -10.240000;
	2	 0.0	 0.0	 3	   0.077230	  35.220000	 -10.190000;
	2	 0.0	 0.0	 3	   0.058280	  32.240000	  -8.310000;
	2	 0.0	 0.0	 3	   0.000000	  17.320000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  14.960000	   0.000000;
	2	 0.0	 0.0	 3	   0.032100	  35.550000	  -5.101000;
	2	 0.0	 0.0	 3	   0.045440	  32.600000	  -6.358000;
	2	 0.0	 0.0	 3	   0.049280	  38.760000	  -7.503000;
	2	 0.0	 0.0	 3	   0.041140	  33.740000	  -6.166000;
	2	 0.0	 0.0	 3	   0.055040	  35.860000	  -6.780000;
	2	 0.0	 0.0	 3	   0.023480	  19.960000	  -2.360000;
	2	 0.0	 0.0	 3	   0.010090	  18.250000	  -1.451000;
	2	 0.0	 0.0	 3	   0.016250	  16.860000	  -1.930000;
	2	 0.0	 0.0	 3	   0.015420	  20.590000	  -1.999000;
	2	 0.0	 0.0	 3	   0.011980	  20.420000	  -1.740000;
	2	 0.0	 0.0	 3	   0.024120	  21.750000	  -2.514000;
	2	 0.0	 0.0	 3	   0.017860	  20.600000	  -2.333000;
	2	 0.0	 0.0	 3	   0.026270	  19.180000	  -2.102000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  15.730000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  17.870000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  16.440000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  14.920000	   0.000000;
	2	 0.0	 0.0	 3	   0.035950	  38.030000	  -6.309000;
	2	 0.0	 0.0	 3	   0.033400	  42.340000	  -6.071000;
	2	 0.0	 0.0	 3	   0.035450	  36.390000	  -5.768000;
	2	 0.0	 0.0	 3	   0.053580	  36.260000	  -7.519000;
	2	 0.0	 0.0	 3	   0.050340	  31.340000	  -6.279000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.013290	  15.420000	  -1.455000;
	2	 0.0	 0.0	 3	   0.021090	  18.780000	  -1.762000;
	2	 0.0	 0.0	 3	   0.019650	  16.670000	  -1.379000;
	2	 0.0	 0.0	 3	   0.013650	  18.540000	  -1.494000;
	2	 0.0	 0.0	 3	   0.015310	  21.780000	  -2.414000;
	2	 0.0	 0.0	 3	   0.019080	  17.540000	  -2.541000;
	2	 0.0	 0.0	 3	   0.021910	  19.740000	  -2.536000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.058190	  47.180000	 -16.980000;
	2	 0.0	 0.0	 3	   0.080400	  36.880000	 -16.910000;
	2	 0.0	 0.0	 3	   0.000000	  14.250000	  -1.439000;
	2	 0.0	 0.0	 3	   0.000000	  14.750000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  17.320000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  14.830000	   0.000000;
	2	 0.0	 0.0	 3	   0.056050	  44.510000	 -12.760000;
	2	 0.0	 0.0	 3	   0.057670	  31.870000	  -9.818000;
	2	 0.0	 0.0	 3	   0.057900	  64.550000	 -14.660000;
	2	 0.0	 0.0	 3	   0.075150	  45.630000	 -14.620000;
	2	 0.0	 0.0	 3	   0.079380	  34.570000	 -11.340000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  14.680000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  16.550000	   0.000000;
	2	 0.0	 0.0	 3	   0.012650	  16.740000	   0.000000;
	2	 0.0	 0.0	 3	   0.011440	  14.880000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
	2	 0.0	 0.0	 3	   0.000000	  30.000000	   0.000000;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	2	 212	 0.0154525	 0.0792528	 0.0268017	 239.94	 239.94	 239.94	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 53	 0.00358046	 0.0258456	 0.0131628	 260.03	 260.03	 260.03	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 53	 0.00358046	 0.0258456	 0.0131628	 260.03	 260.03	 260.03	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 213	 0.00319977	 0.0219502	 0.0125158	 256.59	 256.59	 256.59	 0.0	 0.0	 1	 -30.0	 30.0;
	4	 5	 0.00696197	 0.0360534	 0.0111497	 218.77	 218.77	 218.77	 0.0	 0.0	 1	 -30.0	 30.0;
	4	 331	 0.00775811	 0.0380507	 0.0134745	 227.23	 227.23	 227.23	 0.0	 0.0	 1	 -30.0	 30.0;
	5	 331	 0.00487853	 0.02675	 0.00815727	 198.63	 198.63	 198.63	 0.0	 0.0	 1	 -30.0	 30.0;
	5	 351	 0.0124676	 0.0654224	 0.0163807	 269.59	 269.59	 269.59	 0.0	 0.0	 1	 -30.0	 30.0;
	6	 331	 0.0051151	 0.0236629	 0.0391647	 336.94	 336.94	 336.94	 0.0	 0.0	 1	 -30.0	 30.0;
	8	 461	 0.00268087	 0.0132507	 0.00588479	 232.73	 232.73	 232.73	 0.0	 0.0	 1	 -30.0	 30.0;
	10	 11	 0.0133436	 0.0919039	 0.0115271	 212.51	 212.51	 212.51	 0.0	 0.0	 1	 -30.0	 30.0;
	10	 406	 0.00631471	 0.0440302	 0.0307124	 216.36	 216.36	 216.36	 0.0	 0.0	 1	 -30.0	 30.0;
	11	 58	 0.0286556	 0.128792	 0.0377904	 204.21	 204.21	 204.21	 0.0	 0.0	 1	 -30.0	 30.0;
	12	 10	 0.00363287	 0.0200568	 0.0589258	 206.37	 206.37	 206.37	 0.0	 0.0	 1	 -30.0	 30.0;
	12	 406	 0.00340925	 0.0206369	 0.0061444	 233.32	 233.32	 233.32	 0.0	 0.0	 1	 -30.0	 30.0;
	13	 17	 0.0100597	 0.0575367	 0.0312509	 227.86	 227.86	 227.86	 0.0	 0.0	 1	 -30.0	 30.0;
	14	 156	 0.00832308	 0.0444584	 0.0151703	 264.27	 264.27	 264.27	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 55	 0.0113961	 0.0625895	 0.0161825	 218.52	 218.52	 218.52	 0.0	 0.0	 1	 -30.0	 30.0;
	16	 162	 0.012951	 0.0665246	 0.0176437	 224.35	 224.35	 224.35	 0.0	 0.0	 1	 -30.0	 30.0;
	16	 304	 0.00759675	 0.0410247	 0.0264718	 236.54	 236.54	 236.54	 0.0	 0.0	 1	 -30.0	 30.0;
	18	 19	 0.0106007	 0.0397642	 0.0085879	 245.27	 245.27	 245.27	 0.0	 0.0	 1	 -30.0	 30.0;
	18	 81	 0.00978753	 0.0448943	 0.023169	 223.47	 223.47	 223.47	 0.0	 0.0	 1	 -30.0	 30.0;
	18	 310	 0.004373	 0.0260086	 0.0242791	 277.5	 277.5	 277.5	 0.0	 0.0	 1	 -30.0	 30.0;
	18	 310	 0.004373	 0.0260086	 0.0242791	 277.5	 277.5	 277.5	 0.0	 0.0	 1	 -30.0	 30.0;
	19	 141	 0.00579211	 0.0290206	 0.0189553	 251.0	 251.0	 251.0	 0.0	 0.0	 1	 -30.0	 30.0;
	19	 436	 0.00397383	 0.0271653	 0.0337435	 212.6	 212.6	 212.6	 0.0	 0.0	 1	 -30.0	 30.0;
	20	 22	 0.000207968	 0.00111847	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	21	 23	 0.00250938	 0.0172465	 0.0313608	 248.08	 248.08	 248.08	 0.0	 0.0	 1	 -30.0	 30.0;
	22	 295	 0.0015308	 0.016473	 0.364525	 1075.02	 1075.02	 1075.02	 0.0	 0.0	 1	 -30.0	 30.0;
	22	 405	 0.002026	 0.028747	 1.00897	 1001.46	 1001.46	 1001.46	 0.0	 0.0	 1	 -30.0	 30.0;
	23	 179	 0.008727	 0.054891	 0.034891	 236.33	 236.33	 236.33	 0.0	 0.0	 1	 -30.0	 30.0;
	24	 4	 0.00353554	 0.0227525	 0.0272812	 241.53	 241.53	 241.53	 0.0	 0.0	 1	 -30.0	 30.0;
	24	 56	 0.00957472	 0.0499942	 0.0131242	 244.03	 244.03	 244.03	 0.0	 0.0	 1	 -30.0	 30.0;
	25	 27	 0.000257042	 0.00119754	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	25	 314	 0.00158469	 0.0214403	 0.275456	 1151.39	 1151.39	 1151.39	 0.0	 0.0	 1	 -30.0	 30.0;
	28	 29	 0.0121765	 0.0608641	 0.0130017	 207.91	 207.91	 207.91	 0.0	 0.0	 1	 -30.0	 30.0;
	28	 30	 0.00432531	 0.0200998	 0.00802657	 230.9	 230.9	 230.9	 0.0	 0.0	 1	 -30.0	 30.0;
	29	 356	 0.00799791	 0.0387782	 0.0352203	 188.9	 188.9	 188.9	 0.0	 0.0	 1	 -30.0	 30.0;
	30	 26	 0.00666488	 0.0320152	 0.0220243	 304.68	 304.68	 304.68	 0.0	 0.0	 1	 -30.0	 30.0;
	31	 228	 0.008946	 0.057044	 0.025829	 280.0	 280.0	 280.0	 0.0	 0.0	 1	 -30.0	 30.0;
	31	 296	 0.00518286	 0.0326049	 0.0584572	 358.79	 358.79	 358.79	 0.0	 0.0	 1	 -30.0	 30.0;
	31	 415	 0.0113363	 0.0554702	 0.0432148	 231.46	 231.46	 231.46	 0.0	 0.0	 1	 -30.0	 30.0;
	33	 32	 0.00681448	 0.0338755	 0.0131701	 196.59	 196.59	 196.59	 0.0	 0.0	 1	 -30.0	 30.0;
	34	 33	 0.00341126	 0.0247052	 0.0295283	 270.99	 270.99	 270.99	 0.0	 0.0	 1	 -30.0	 30.0;
	34	 33	 0.00341126	 0.0247052	 0.0295283	 270.99	 270.99	 270.99	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 40	 0.00293506	 0.0185201	 0.00990083	 228.32	 228.32	 228.32	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 42	 0.00449505	 0.0326042	 0.0129473	 276.08	 276.08	 276.08	 0.0	 0.0	 1	 -30.0	 30.0;
	36	 2	 0.00289863	 0.0167658	 0.0148842	 188.66	 188.66	 188.66	 0.0	 0.0	 1	 -30.0	 30.0;
	36	 33	 0.00284038	 0.0206656	 0.011617	 213.45	 213.45	 213.45	 0.0	 0.0	 0	 -30.0	 30.0;
	37	 35	 0.00780774	 0.0366615	 0.0156035	 218.76	 218.76	 218.76	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 44	 0.00830767	 0.0554788	 0.0311844	 200.99	 200.99	 200.99	 0.0	 0.0	 1	 -30.0	 30.0;
	38	 39	 0.00316109	 0.0157664	 0.019275	 252.83	 252.83	 252.83	 0.0	 0.0	 1	 -30.0	 30.0;
	38	 49	 0.0106902	 0.0689767	 0.0297214	 204.2	 204.2	 204.2	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 35	 0.00384653	 0.022595	 0.0115165	 259.81	 259.81	 259.81	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 35	 0.00384653	 0.022595	 0.0115165	 259.81	 259.81	 259.81	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 361	 0.00410223	 0.0323982	 0.0223687	 296.76	 296.76	 296.76	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 361	 0.00410223	 0.0323982	 0.0223687	 296.76	 296.76	 296.76	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 361	 0.00410223	 0.0323982	 0.0223687	 296.76	 296.76	 296.76	 0.0	 0.0	 0	 -30.0	 30.0;
	41	 43	 0.000233031	 0.00104503	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	42	 40	 0.00435644	 0.0248836	 0.0126137	 308.21	 308.21	 308.21	 0.0	 0.0	 1	 -30.0	 30.0;
	43	 54	 0.00111725	 0.0133249	 0.292213	 1210.87	 1210.87	 1210.87	 0.0	 0.0	 1	 -30.0	 30.0;
	43	 498	 0.00161178	 0.0198636	 0.286039	 1210.03	 1210.03	 1210.03	 0.0	 0.0	 1	 -30.0	 30.0;
	44	 42	 0.00483059	 0.022229	 0.00975406	 240.21	 240.21	 240.21	 0.0	 0.0	 1	 -30.0	 30.0;
	45	 36	 0.00469767	 0.0323288	 0.00954514	 196.67	 196.67	 196.67	 0.0	 0.0	 1	 -30.0	 30.0;
	45	 37	 0.00411194	 0.0226471	 0.0067485	 223.09	 223.09	 223.09	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 45	 0.0023403	 0.0128024	 0.0123531	 401.85	 401.85	 401.85	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 50	 0.00351582	 0.0151322	 0.0225659	 213.18	 213.18	 213.18	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 51	 0.00390017	 0.0201794	 0.0263679	 290.75	 290.75	 290.75	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 51	 0.00390017	 0.0201794	 0.0263679	 290.75	 290.75	 290.75	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 214	 0.00565635	 0.0285577	 0.0458282	 324.34	 324.34	 324.34	 0.0	 0.0	 1	 -30.0	 30.0;
	47	 40	 0.00542345	 0.0298445	 0.00973297	 209.65	 209.65	 209.65	 0.0	 0.0	 1	 -30.0	 30.0;
	48	 50	 0.00493315	 0.0197057	 0.0266381	 231.0	 231.0	 231.0	 0.0	 0.0	 1	 -30.0	 30.0;
	48	 480	 0.0141266	 0.063385	 0.013796	 270.01	 270.01	 270.01	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 47	 0.00274605	 0.0168842	 0.011861	 210.29	 210.29	 210.29	 0.0	 0.0	 1	 -30.0	 30.0;
	50	 49	 0.00420333	 0.0189576	 0.00848235	 263.28	 263.28	 263.28	 0.0	 0.0	 1	 -30.0	 30.0;
	50	 51	 0.00306979	 0.0198041	 0.0129611	 299.51	 299.51	 299.51	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 48	 0.00285314	 0.0207706	 0.0111933	 206.03	 206.03	 206.03	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 70	 0.00927047	 0.0420854	 0.0202396	 302.02	 302.02	 302.02	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 357	 0.00606199	 0.0375019	 0.0462067	 281.97	 281.97	 281.97	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 357	 0.00606199	 0.0375019	 0.0462067	 281.97	 281.97	 281.97	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 357	 0.00606199	 0.0375019	 0.0462067	 281.97	 281.97	 281.97	 0.0	 0.0	 1	 -30.0	 30.0;
	52	 54	 0.000209023	 0.00101092	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	53	 32	 0.00540244	 0.030335	 0.00829098	 226.77	 226.77	 226.77	 0.0	 0.0	 1	 -30.0	 30.0;
	53	 36	 0.00511899	 0.0318872	 0.0170703	 230.21	 230.21	 230.21	 0.0	 0.0	 1	 -30.0	 30.0;
	53	 45	 0.00448796	 0.0251172	 0.0179586	 273.78	 273.78	 273.78	 0.0	 0.0	 1	 -30.0	 30.0;
	53	 45	 0.00448796	 0.0251172	 0.0179586	 273.78	 273.78	 273.78	 0.0	 0.0	 1	 -30.0	 30.0;
	55	 72	 0.00255071	 0.0145816	 0.0529998	 202.42	 202.42	 202.42	 0.0	 0.0	 1	 -30.0	 30.0;
	57	 66	 0.012542	 0.0731735	 0.0174808	 188.33	 188.33	 188.33	 0.0	 0.0	 1	 -30.0	 30.0;
	57	 161	 0.0318774	 0.176516	 0.0907922	 198.2	 198.2	 198.2	 0.0	 0.0	 1	 -30.0	 30.0;
	57	 255	 0.00718102	 0.0390624	 0.0537424	 300.0	 300.0	 300.0	 0.0	 0.0	 1	 -30.0	 30.0;
	58	 59	 0.00838826	 0.044004	 0.0215912	 282.33	 282.33	 282.33	 0.0	 0.0	 1	 -30.0	 30.0;
	59	 179	 0.0199692	 0.12545	 0.0343653	 209.05	 209.05	 209.05	 0.0	 0.0	 1	 -30.0	 30.0;
	60	 211	 0.0107783	 0.0696549	 0.0231844	 234.89	 234.89	 234.89	 0.0	 0.0	 1	 -30.0	 30.0;
	61	 469	 0.00533577	 0.0355112	 0.0133687	 209.34	 209.34	 209.34	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 169	 0.0229231	 0.141757	 0.0331327	 284.38	 284.38	 284.38	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 245	 0.0171145	 0.104922	 0.0526062	 205.64	 205.64	 205.64	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 271	 0.0225085	 0.129199	 0.0416435	 215.63	 215.63	 215.63	 0.0	 0.0	 1	 -30.0	 30.0;
	63	 396	 0.00684768	 0.035438	 0.0555983	 276.04	 276.04	 276.04	 0.0	 0.0	 1	 -30.0	 30.0;
	63	 396	 0.00684768	 0.035438	 0.0555983	 318.9	 318.9	 318.9	 0.0	 0.0	 1	 -30.0	 30.0;
	64	 308	 0.0045429	 0.0249656	 0.0222506	 204.94	 204.94	 204.94	 0.0	 0.0	 1	 -30.0	 30.0;
	65	 118	 0.00682259	 0.0489818	 0.0291852	 187.98	 187.98	 187.98	 0.0	 0.0	 1	 -30.0	 30.0;
	65	 122	 0.0114556	 0.0789436	 0.0221672	 223.13	 223.13	 223.13	 0.0	 0.0	 1	 -30.0	 30.0;
	66	 180	 0.013631	 0.0750424	 0.0174066	 212.27	 212.27	 212.27	 0.0	 0.0	 1	 -30.0	 30.0;
	67	 415	 0.0105199	 0.0574565	 0.0373877	 237.15	 237.15	 237.15	 0.0	 0.0	 1	 -30.0	 30.0;
	68	 159	 0.00605992	 0.0375113	 0.0255276	 229.73	 229.73	 229.73	 0.0	 0.0	 1	 -30.0	 30.0;
	68	 377	 0.00417649	 0.0277901	 0.0160845	 244.32	 244.32	 244.32	 0.0	 0.0	 1	 -30.0	 30.0;
	69	 1	 0.0263485	 0.135443	 0.0504152	 230.13	 230.13	 230.13	 0.0	 0.0	 1	 -30.0	 30.0;
	69	 263	 0.0303392	 0.0797752	 0.029101	 203.37	 203.37	 203.37	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 357	 0.00846265	 0.0516422	 0.0102433	 188.28	 188.28	 188.28	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 480	 0.00434341	 0.0202377	 0.00802619	 410.92	 410.92	 410.92	 0.0	 0.0	 1	 -30.0	 30.0;
	71	 6	 0.0078159	 0.0497093	 0.0146629	 266.45	 266.45	 266.45	 0.0	 0.0	 1	 -30.0	 30.0;
	71	 236	 0.00800132	 0.0463031	 0.04138	 201.33	 201.33	 201.33	 0.0	 0.0	 1	 -30.0	 30.0;
	72	 138	 0.00444643	 0.0351083	 0.0127807	 207.55	 207.55	 207.55	 0.0	 0.0	 1	 -30.0	 30.0;
	73	 72	 0.00533244	 0.0343247	 0.0255959	 220.8	 220.8	 220.8	 0.0	 0.0	 1	 -30.0	 30.0;
	73	 147	 0.00440739	 0.0228773	 0.164518	 299.52	 299.52	 299.52	 0.0	 0.0	 1	 -30.0	 30.0;
	74	 96	 0.00818286	 0.0350286	 0.0519578	 247.19	 247.19	 247.19	 0.0	 0.0	 1	 -30.0	 30.0;
	74	 267	 0.00959142	 0.0610596	 0.0235834	 231.57	 231.57	 231.57	 0.0	 0.0	 1	 -30.0	 30.0;
	75	 8	 0.00464284	 0.0333214	 0.0209588	 200.72	 200.72	 200.72	 0.0	 0.0	 1	 -30.0	 30.0;
	75	 358	 0.0102235	 0.0653	 0.0229694	 188.8	 188.8	 188.8	 0.0	 0.0	 1	 -30.0	 30.0;
	76	 87	 0.00734959	 0.0479733	 0.0311735	 229.57	 229.57	 229.57	 0.0	 0.0	 1	 -30.0	 30.0;
	76	 98	 0.00991719	 0.0433979	 0.0140715	 204.48	 204.48	 204.48	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 79	 0.00410741	 0.0215648	 0.0277571	 211.27	 211.27	 211.27	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 107	 0.0117458	 0.0474083	 0.0162089	 218.26	 218.26	 218.26	 0.0	 0.0	 1	 -30.0	 30.0;
	78	 107	 0.0111029	 0.0647119	 0.0107653	 206.24	 206.24	 206.24	 0.0	 0.0	 1	 -30.0	 30.0;
	78	 175	 1e-07	 0.03	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	79	 78	 0.00255254	 0.0159622	 0.00899812	 203.0	 203.0	 203.0	 0.0	 0.0	 1	 -30.0	 30.0;
	79	 107	 0.00331842	 0.0132353	 0.0146141	 250.46	 250.46	 250.46	 0.0	 0.0	 1	 -30.0	 30.0;
	80	 348	 0.00704419	 0.0429071	 0.0164992	 208.58	 208.58	 208.58	 0.0	 0.0	 1	 -30.0	 30.0;
	81	 83	 0.00531978	 0.0288681	 0.0129334	 207.61	 207.61	 207.61	 0.0	 0.0	 1	 -30.0	 30.0;
	81	 166	 0.00541342	 0.0336256	 0.0795896	 293.17	 293.17	 293.17	 0.0	 0.0	 1	 -30.0	 30.0;
	81	 229	 0.00312946	 0.0211726	 0.124132	 215.36	 215.36	 215.36	 0.0	 0.0	 1	 -30.0	 30.0;
	82	 266	 0.0114333	 0.0592337	 0.0223159	 204.89	 204.89	 204.89	 0.0	 0.0	 1	 -30.0	 30.0;
	82	 310	 0.0131116	 0.0919649	 0.0333501	 257.15	 257.15	 257.15	 0.0	 0.0	 1	 -30.0	 30.0;
	83	 430	 0.0054217	 0.0345595	 0.00848049	 222.55	 222.55	 222.55	 0.0	 0.0	 1	 -30.0	 30.0;
	84	 139	 0.00435711	 0.0190405	 0.0137408	 210.32	 210.32	 210.32	 0.0	 0.0	 1	 -30.0	 30.0;
	84	 195	 0.00929083	 0.0588771	 0.0219609	 259.57	 259.57	 259.57	 0.0	 0.0	 1	 -30.0	 30.0;
	84	 195	 0.00929083	 0.0588771	 0.0219609	 259.57	 259.57	 259.57	 0.0	 0.0	 1	 -30.0	 30.0;
	84	 266	 0.00501492	 0.0413843	 0.0291757	 246.13	 246.13	 246.13	 0.0	 0.0	 1	 -30.0	 30.0;
	84	 436	 0.00700667	 0.0414708	 0.015102	 258.28	 258.28	 258.28	 0.0	 0.0	 1	 -30.0	 30.0;
	85	 161	 0.00894783	 0.0484215	 0.0154075	 177.52	 177.52	 177.52	 0.0	 0.0	 1	 -30.0	 30.0;
	86	 91	 0.00643134	 0.0345851	 0.0231473	 223.14	 223.14	 223.14	 0.0	 0.0	 1	 -30.0	 30.0;
	87	 86	 0.00619339	 0.0427095	 0.00952131	 237.28	 237.28	 237.28	 0.0	 0.0	 1	 -30.0	 30.0;
	87	 89	 0.00793475	 0.0435997	 0.0184649	 258.25	 258.25	 258.25	 0.0	 0.0	 1	 -30.0	 30.0;
	87	 274	 0.0196035	 0.0686154	 0.0349382	 292.99	 292.99	 292.99	 0.0	 0.0	 1	 -30.0	 30.0;
	87	 274	 0.0196035	 0.0686154	 0.0349382	 292.99	 292.99	 292.99	 0.0	 0.0	 1	 -30.0	 30.0;
	88	 86	 0.00619872	 0.0363008	 0.0141733	 239.42	 239.42	 239.42	 0.0	 0.0	 1	 -30.0	 30.0;
	89	 91	 0.00819369	 0.0464744	 0.00929417	 259.02	 259.02	 259.02	 0.0	 0.0	 1	 -30.0	 30.0;
	90	 92	 0.000270441	 0.00111124	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	90	 273	 0.00115634	 0.013527	 0.194866	 1462.73	 1462.73	 1462.73	 0.0	 0.0	 1	 -30.0	 30.0;
	91	 143	 0.00923127	 0.055819	 0.0278186	 236.4	 236.4	 236.4	 0.0	 0.0	 1	 -30.0	 30.0;
	94	 239	 0.00830591	 0.0293227	 0.00963458	 256.91	 256.91	 256.91	 0.0	 0.0	 1	 -30.0	 30.0;
	95	 100	 0.00486868	 0.0263368	 0.0205417	 208.4	 208.4	 208.4	 0.0	 0.0	 1	 -30.0	 30.0;
	95	 205	 0.0121886	 0.0614622	 0.0273777	 174.34	 174.34	 174.34	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 90	 0.00120165	 0.0138189	 0.259737	 1139.35	 1139.35	 1139.35	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 99	 0.000275423	 0.00105221	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 273	 0.00243082	 0.0302411	 0.519784	 1267.29	 1267.29	 1267.29	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 405	 0.00207844	 0.0243675	 0.524041	 1074.6	 1074.6	 1074.6	 0.0	 0.0	 1	 -30.0	 30.0;
	98	 101	 0.00804282	 0.0445249	 0.0172134	 306.67	 306.67	 306.67	 0.0	 0.0	 1	 -30.0	 30.0;
	100	 101	 0.00296664	 0.0146402	 0.0208753	 253.07	 253.07	 253.07	 0.0	 0.0	 1	 -30.0	 30.0;
	101	 126	 0.0135607	 0.0668913	 0.0172284	 191.2	 191.2	 191.2	 0.0	 0.0	 1	 -30.0	 30.0;
	102	 69	 0.00789353	 0.0491556	 0.052004	 227.8	 227.8	 227.8	 0.0	 0.0	 1	 -30.0	 30.0;
	102	 103	 0.00616992	 0.040555	 0.0247805	 209.35	 209.35	 209.35	 0.0	 0.0	 1	 -30.0	 30.0;
	103	 219	 0.0165793	 0.0810327	 0.0235267	 219.57	 219.57	 219.57	 0.0	 0.0	 1	 -30.0	 30.0;
	103	 376	 0.00542668	 0.0326243	 0.0184557	 224.43	 224.43	 224.43	 0.0	 0.0	 1	 -30.0	 30.0;
	104	 9	 0.0120051	 0.0621569	 0.0229572	 191.72	 191.72	 191.72	 0.0	 0.0	 1	 -30.0	 30.0;
	104	 163	 0.0181989	 0.10493	 0.0417728	 244.46	 244.46	 244.46	 0.0	 0.0	 1	 -30.0	 30.0;
	104	 226	 0.0129352	 0.086119	 0.0522159	 196.78	 196.78	 196.78	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 58	 0.0099657	 0.0594587	 0.0230392	 201.82	 201.82	 201.82	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 399	 0.028421	 0.116472	 0.031104	 224.0	 224.0	 224.0	 0.0	 0.0	 1	 -30.0	 30.0;
	106	 108	 0.000297923	 0.00115791	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	107	 206	 0.00809361	 0.0597339	 0.0473542	 238.35	 238.35	 238.35	 0.0	 0.0	 1	 -30.0	 30.0;
	108	 414	 0.00172335	 0.0206772	 0.504555	 1228.85	 1228.85	 1228.85	 0.0	 0.0	 1	 -30.0	 30.0;
	109	 200	 0.0203907	 0.118914	 0.0276247	 220.15	 220.15	 220.15	 0.0	 0.0	 1	 -30.0	 30.0;
	110	 196	 0.0042827	 0.0235603	 0.0191082	 216.49	 216.49	 216.49	 0.0	 0.0	 1	 -30.0	 30.0;
	110	 398	 0.00483279	 0.0258082	 0.0159547	 252.34	 252.34	 252.34	 0.0	 0.0	 1	 -30.0	 30.0;
	111	 196	 0.00542194	 0.0344726	 0.0102377	 214.05	 214.05	 214.05	 0.0	 0.0	 1	 -30.0	 30.0;
	112	 423	 0.00423329	 0.0285922	 0.0763694	 249.73	 249.73	 249.73	 0.0	 0.0	 1	 -30.0	 30.0;
	113	 260	 0.00834035	 0.0512955	 0.0347496	 202.53	 202.53	 202.53	 0.0	 0.0	 1	 -30.0	 30.0;
	113	 398	 0.00663848	 0.0305149	 0.0128669	 227.33	 227.33	 227.33	 0.0	 0.0	 1	 -30.0	 30.0;
	114	 111	 0.00910642	 0.0400126	 0.0159566	 208.23	 208.23	 208.23	 0.0	 0.0	 1	 -30.0	 30.0;
	114	 398	 0.0120679	 0.061943	 0.023604	 226.07	 226.07	 226.07	 0.0	 0.0	 1	 -30.0	 30.0;
	115	 77	 0.00411865	 0.0255403	 0.0178958	 230.62	 230.62	 230.62	 0.0	 0.0	 1	 -30.0	 30.0;
	115	 131	 0.00819163	 0.0553686	 0.0263614	 218.92	 218.92	 218.92	 0.0	 0.0	 1	 -30.0	 30.0;
	115	 228	 0.0126336	 0.0592473	 0.0119379	 217.39	 217.39	 217.39	 0.0	 0.0	 1	 -30.0	 30.0;
	116	 206	 0.00973095	 0.0504602	 0.019357	 222.37	 222.37	 222.37	 0.0	 0.0	 1	 -30.0	 30.0;
	117	 217	 0.00511447	 0.0253149	 0.10592	 223.26	 223.26	 223.26	 0.0	 0.0	 1	 -30.0	 30.0;
	119	 121	 0.000242957	 0.0011457	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	120	 477	 0.00424349	 0.0233087	 0.157389	 190.09	 190.09	 190.09	 0.0	 0.0	 1	 -30.0	 30.0;
	121	 151	 0.00155598	 0.0200038	 0.655713	 1248.37	 1248.37	 1248.37	 0.0	 0.0	 1	 -30.0	 30.0;
	122	 477	 0.00591039	 0.0286753	 0.0112938	 248.26	 248.26	 248.26	 0.0	 0.0	 1	 -30.0	 30.0;
	124	 24	 0.00552089	 0.0312098	 0.0117206	 322.21	 322.21	 322.21	 0.0	 0.0	 1	 -30.0	 30.0;
	124	 122	 0.00616606	 0.0403861	 0.0183176	 295.24	 295.24	 295.24	 0.0	 0.0	 1	 -30.0	 30.0;
	125	 333	 0.00816597	 0.0423005	 0.0261657	 268.04	 268.04	 268.04	 0.0	 0.0	 1	 -30.0	 30.0;
	125	 453	 0.00365157	 0.0256689	 0.0121744	 199.42	 199.42	 199.42	 0.0	 0.0	 1	 -30.0	 30.0;
	127	 9	 0.00947342	 0.0740918	 0.0278587	 162.26	 162.26	 162.26	 0.0	 0.0	 1	 -30.0	 30.0;
	128	 142	 0.0176946	 0.0991166	 0.0248442	 180.09	 180.09	 180.09	 0.0	 0.0	 1	 -30.0	 30.0;
	128	 164	 0.00911283	 0.0650041	 0.0205367	 212.74	 212.74	 212.74	 0.0	 0.0	 1	 -30.0	 30.0;
	129	 128	 0.00489014	 0.0292388	 0.0244841	 225.74	 225.74	 225.74	 0.0	 0.0	 1	 -30.0	 30.0;
	129	 399	 0.0189658	 0.0973849	 0.0559229	 249.6	 249.6	 249.6	 0.0	 0.0	 1	 -30.0	 30.0;
	130	 179	 1e-07	 0.025	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	130	 294	 0.0131769	 0.082029	 0.0245782	 185.8	 185.8	 185.8	 0.0	 0.0	 1	 -30.0	 30.0;
	131	 116	 0.00549552	 0.0341954	 0.0146232	 201.28	 201.28	 201.28	 0.0	 0.0	 1	 -30.0	 30.0;
	132	 93	 0.00992821	 0.0644466	 0.0264679	 208.47	 208.47	 208.47	 0.0	 0.0	 1	 -30.0	 30.0;
	132	 133	 0.00732507	 0.0373195	 0.0248695	 232.81	 232.81	 232.81	 0.0	 0.0	 1	 -30.0	 30.0;
	134	 136	 0.0102307	 0.0477176	 0.0187308	 207.6	 207.6	 207.6	 0.0	 0.0	 1	 -30.0	 30.0;
	135	 137	 0.000229847	 0.00116435	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	135	 422	 0.00235893	 0.024726	 0.469035	 1189.63	 1189.63	 1189.63	 0.0	 0.0	 1	 -30.0	 30.0;
	136	 241	 0.0112916	 0.0732581	 0.0317038	 214.72	 214.72	 214.72	 0.0	 0.0	 1	 -30.0	 30.0;
	136	 269	 0.0071981	 0.0545129	 0.0288407	 260.65	 260.65	 260.65	 0.0	 0.0	 1	 -30.0	 30.0;
	136	 269	 0.0071981	 0.0545129	 0.0288407	 260.65	 260.65	 260.65	 0.0	 0.0	 0	 -30.0	 30.0;
	138	 267	 0.0137642	 0.0640674	 0.014872	 191.13	 191.13	 191.13	 0.0	 0.0	 1	 -30.0	 30.0;
	139	 266	 0.00742239	 0.0413065	 0.0163907	 235.23	 235.23	 235.23	 0.0	 0.0	 1	 -30.0	 30.0;
	139	 436	 0.0061483	 0.0314653	 0.0353002	 285.59	 285.59	 285.59	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 141	 0.00437587	 0.0295663	 0.00682313	 226.66	 226.66	 226.66	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 149	 0.00858313	 0.0511386	 0.0129799	 237.21	 237.21	 237.21	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 154	 0.00987958	 0.0590507	 0.0246559	 232.93	 232.93	 232.93	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 165	 0.00346348	 0.0216104	 0.0227149	 189.3	 189.3	 189.3	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 166	 0.00092095	 0.00500518	 0.0187787	 262.31	 262.31	 262.31	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 166	 0.00092095	 0.00500518	 0.0187787	 262.31	 262.31	 262.31	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 436	 0.00495754	 0.0288767	 0.0446069	 306.09	 306.09	 306.09	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 436	 0.00495754	 0.0288767	 0.0446069	 306.09	 306.09	 306.09	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 436	 0.00495754	 0.0288767	 0.0446069	 306.09	 306.09	 306.09	 0.0	 0.0	 1	 -30.0	 30.0;
	142	 366	 0.0117749	 0.0695592	 0.0171149	 206.18	 206.18	 206.18	 0.0	 0.0	 1	 -30.0	 30.0;
	143	 89	 0.00782994	 0.0336108	 0.0263321	 214.33	 214.33	 214.33	 0.0	 0.0	 1	 -30.0	 30.0;
	144	 14	 0.00900802	 0.0615875	 0.019763	 203.73	 203.73	 203.73	 0.0	 0.0	 1	 -30.0	 30.0;
	144	 270	 0.0161384	 0.0861978	 0.0309127	 220.79	 220.79	 220.79	 0.0	 0.0	 1	 -30.0	 30.0;
	145	 3	 0.00353908	 0.0187394	 0.0133873	 213.82	 213.82	 213.82	 0.0	 0.0	 1	 -30.0	 30.0;
	145	 32	 0.00592829	 0.0364587	 0.0146815	 203.9	 203.9	 203.9	 0.0	 0.0	 1	 -30.0	 30.0;
	146	 147	 0.00508514	 0.0390637	 0.0127711	 228.21	 228.21	 228.21	 0.0	 0.0	 1	 -30.0	 30.0;
	147	 148	 0.0054055	 0.0355367	 0.00942939	 247.66	 247.66	 247.66	 0.0	 0.0	 1	 -30.0	 30.0;
	148	 146	 0.00539343	 0.0250755	 0.015923	 211.0	 211.0	 211.0	 0.0	 0.0	 1	 -30.0	 30.0;
	148	 166	 0.00477032	 0.0295611	 0.0527909	 261.82	 261.82	 261.82	 0.0	 0.0	 1	 -30.0	 30.0;
	148	 166	 0.00477032	 0.0295611	 0.0527909	 261.82	 261.82	 261.82	 0.0	 0.0	 1	 -30.0	 30.0;
	149	 146	 0.0128452	 0.0364985	 0.00708579	 176.91	 176.91	 176.91	 0.0	 0.0	 1	 -30.0	 30.0;
	150	 146	 0.00573662	 0.0370925	 0.00906798	 231.51	 231.51	 231.51	 0.0	 0.0	 1	 -30.0	 30.0;
	150	 152	 0.00272594	 0.0179578	 0.013011	 264.24	 264.24	 264.24	 0.0	 0.0	 1	 -30.0	 30.0;
	150	 152	 0.00272594	 0.0179578	 0.013011	 264.24	 264.24	 264.24	 0.0	 0.0	 1	 -30.0	 30.0;
	151	 153	 0.000216168	 0.00101369	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	151	 309	 0.00157454	 0.0168171	 0.474329	 1273.32	 1273.32	 1273.32	 0.0	 0.0	 1	 -30.0	 30.0;
	151	 429	 0.00179475	 0.0239725	 0.307853	 1129.32	 1129.32	 1129.32	 0.0	 0.0	 1	 -30.0	 30.0;
	151	 435	 0.00133646	 0.0166752	 0.333178	 1140.95	 1140.95	 1140.95	 0.0	 0.0	 1	 -30.0	 30.0;
	152	 155	 0.00812632	 0.0501842	 0.00786791	 218.33	 218.33	 218.33	 0.0	 0.0	 1	 -30.0	 30.0;
	154	 152	 0.00278017	 0.0178012	 0.00801273	 253.55	 253.55	 253.55	 0.0	 0.0	 1	 -30.0	 30.0;
	154	 198	 0.00444159	 0.0216831	 0.0136503	 230.23	 230.23	 230.23	 0.0	 0.0	 1	 -30.0	 30.0;
	155	 154	 0.00384809	 0.0206545	 0.00841861	 204.11	 204.11	 204.11	 0.0	 0.0	 1	 -30.0	 30.0;
	157	 158	 0.00833276	 0.0618383	 0.0168817	 189.98	 189.98	 189.98	 0.0	 0.0	 1	 -30.0	 30.0;
	158	 93	 0.0150498	 0.0753739	 0.0264057	 237.8	 237.8	 237.8	 0.0	 0.0	 1	 -30.0	 30.0;
	159	 404	 0.00958039	 0.0443493	 0.0256151	 189.56	 189.56	 189.56	 0.0	 0.0	 1	 -30.0	 30.0;
	160	 215	 0.00639018	 0.0378575	 0.0183732	 276.26	 276.26	 276.26	 0.0	 0.0	 1	 -30.0	 30.0;
	160	 215	 0.00639018	 0.0378575	 0.0183732	 276.26	 276.26	 276.26	 0.0	 0.0	 1	 -30.0	 30.0;
	160	 455	 0.00570318	 0.0279867	 0.0107857	 286.46	 286.46	 286.46	 0.0	 0.0	 1	 -30.0	 30.0;
	160	 455	 0.00570318	 0.0279867	 0.0107857	 286.46	 286.46	 286.46	 0.0	 0.0	 1	 -30.0	 30.0;
	160	 455	 0.00570318	 0.0279867	 0.0107857	 286.46	 286.46	 286.46	 0.0	 0.0	 1	 -30.0	 30.0;
	163	 271	 0.0114438	 0.0436005	 0.0346998	 179.05	 179.05	 179.05	 0.0	 0.0	 1	 -30.0	 30.0;
	163	 373	 0.0118044	 0.070336	 0.0200369	 297.95	 297.95	 297.95	 0.0	 0.0	 1	 -30.0	 30.0;
	164	 248	 0.0166592	 0.0789746	 0.0332218	 180.39	 180.39	 180.39	 0.0	 0.0	 1	 -30.0	 30.0;
	165	 83	 0.00626026	 0.0354394	 0.0366867	 234.49	 234.49	 234.49	 0.0	 0.0	 1	 -30.0	 30.0;
	166	 140	 0.00731424	 0.0226116	 0.00854781	 225.55	 225.55	 225.55	 0.0	 0.0	 1	 -30.0	 30.0;
	167	 57	 0.010917	 0.0509877	 0.02854	 235.27	 235.27	 235.27	 0.0	 0.0	 1	 -30.0	 30.0;
	167	 237	 0.00858763	 0.0514933	 0.0327973	 277.5	 277.5	 277.5	 0.0	 0.0	 1	 -30.0	 30.0;
	167	 308	 0.015381	 0.105892	 0.094777	 137.16	 137.16	 137.16	 0.0	 0.0	 1	 -30.0	 30.0;
	169	 294	 0.0159265	 0.106886	 0.0530111	 360.35	 360.35	 360.35	 0.0	 0.0	 1	 -30.0	 30.0;
	170	 279	 0.00303492	 0.0181342	 0.00534882	 241.25	 241.25	 241.25	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 174	 0.00224797	 0.011615	 0.0142829	 208.34	 208.34	 208.34	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 175	 0.00496535	 0.0237746	 0.00763631	 179.76	 179.76	 179.76	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 178	 0.00957175	 0.0508253	 0.010821	 280.01	 280.01	 280.01	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 178	 0.00957175	 0.0508253	 0.010821	 280.01	 280.01	 280.01	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 232	 0.00222237	 0.0159047	 0.0600656	 396.42	 396.42	 396.42	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 232	 0.00222237	 0.0159047	 0.0600656	 396.42	 396.42	 396.42	 0.0	 0.0	 1	 -30.0	 30.0;
	171	 279	 0.0109431	 0.0419533	 0.0211437	 210.57	 210.57	 210.57	 0.0	 0.0	 1	 -30.0	 30.0;
	172	 173	 0.00554268	 0.0252059	 0.011282	 208.34	 208.34	 208.34	 0.0	 0.0	 1	 -30.0	 30.0;
	174	 170	 0.00383353	 0.0223464	 0.0194664	 192.65	 192.65	 192.65	 0.0	 0.0	 1	 -30.0	 30.0;
	174	 495	 0.00535203	 0.0300593	 0.0221523	 228.14	 228.14	 228.14	 0.0	 0.0	 1	 -30.0	 30.0;
	175	 234	 0.00354887	 0.0176835	 0.0203663	 183.22	 183.22	 183.22	 0.0	 0.0	 1	 -30.0	 30.0;
	175	 495	 0.001843	 0.011985	 0.004183	 280.0	 280.0	 280.0	 0.0	 0.0	 1	 -30.0	 30.0;
	176	 177	 0.00359841	 0.0241809	 0.0123395	 202.57	 202.57	 202.57	 0.0	 0.0	 1	 -30.0	 30.0;
	176	 244	 0.00628574	 0.034737	 0.0187055	 300.0	 300.0	 300.0	 0.0	 0.0	 1	 -30.0	 30.0;
	177	 173	 0.00402863	 0.0256745	 0.0229296	 178.8	 178.8	 178.8	 0.0	 0.0	 1	 -30.0	 30.0;
	177	 491	 0.00752468	 0.0520976	 0.0339664	 216.78	 216.78	 216.78	 0.0	 0.0	 1	 -30.0	 30.0;
	178	 177	 0.00535238	 0.0363989	 0.00997157	 225.46	 225.46	 225.46	 0.0	 0.0	 1	 -30.0	 30.0;
	180	 63	 0.00890202	 0.0408484	 0.0196852	 260.07	 260.07	 260.07	 0.0	 0.0	 1	 -30.0	 30.0;
	180	 63	 0.00890202	 0.0408484	 0.0196852	 260.07	 260.07	 260.07	 0.0	 0.0	 1	 -30.0	 30.0;
	181	 168	 0.0097017	 0.0576871	 0.0204621	 222.72	 222.72	 222.72	 0.0	 0.0	 1	 -30.0	 30.0;
	181	 180	 0.00440478	 0.0242077	 0.0283171	 247.75	 247.75	 247.75	 0.0	 0.0	 1	 -30.0	 30.0;
	182	 185	 0.00171453	 0.00889045	 0.0238406	 398.72	 398.72	 398.72	 0.0	 0.0	 1	 -30.0	 30.0;
	183	 193	 0.00524827	 0.0315915	 0.0127134	 194.36	 194.36	 194.36	 0.0	 0.0	 1	 -30.0	 30.0;
	183	 348	 0.00555018	 0.0391876	 0.0158808	 245.54	 245.54	 245.54	 0.0	 0.0	 1	 -30.0	 30.0;
	184	 187	 0.00220879	 0.0126244	 0.0239407	 169.83	 169.83	 169.83	 0.0	 0.0	 1	 -30.0	 30.0;
	184	 191	 0.00478016	 0.0306107	 0.0103495	 239.33	 239.33	 239.33	 0.0	 0.0	 1	 -30.0	 30.0;
	185	 187	 0.00395185	 0.0294432	 0.00874079	 296.9	 296.9	 296.9	 0.0	 0.0	 1	 -30.0	 30.0;
	186	 184	 0.00543965	 0.035961	 0.00847875	 198.79	 198.79	 198.79	 0.0	 0.0	 1	 -30.0	 30.0;
	186	 191	 0.00711793	 0.0407855	 0.0196479	 238.6	 238.6	 238.6	 0.0	 0.0	 1	 -30.0	 30.0;
	186	 250	 0.0104701	 0.0582718	 0.048083	 207.78	 207.78	 207.78	 0.0	 0.0	 1	 -30.0	 30.0;
	187	 191	 0.00844667	 0.0413005	 0.0180251	 229.27	 229.27	 229.27	 0.0	 0.0	 1	 -30.0	 30.0;
	189	 188	 0.00571546	 0.0332658	 0.0128996	 234.79	 234.79	 234.79	 0.0	 0.0	 1	 -30.0	 30.0;
	190	 25	 0.00209646	 0.0245254	 0.404187	 990.64	 990.64	 990.64	 0.0	 0.0	 1	 -30.0	 30.0;
	190	 97	 0.00317752	 0.0363667	 1.1004	 1250.08	 1250.08	 1250.08	 0.0	 0.0	 1	 -30.0	 30.0;
	190	 192	 0.000222942	 0.00103575	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	190	 349	 0.000908512	 0.0109152	 0.338099	 1151.32	 1151.32	 1151.32	 0.0	 0.0	 1	 -30.0	 30.0;
	191	 188	 0.00296045	 0.024531	 0.0147562	 270.38	 270.38	 270.38	 0.0	 0.0	 1	 -30.0	 30.0;
	193	 189	 0.00178101	 0.01297	 0.0176216	 211.99	 211.99	 211.99	 0.0	 0.0	 1	 -30.0	 30.0;
	194	 251	 0.00320622	 0.0167087	 0.0270856	 203.61	 203.61	 203.61	 0.0	 0.0	 1	 -30.0	 30.0;
	195	 133	 0.00525408	 0.0402405	 0.015266	 243.41	 243.41	 243.41	 0.0	 0.0	 1	 -30.0	 30.0;
	196	 112	 0.00489394	 0.0289436	 0.0102925	 204.1	 204.1	 204.1	 0.0	 0.0	 1	 -30.0	 30.0;
	196	 247	 0.00697417	 0.0300478	 0.0407165	 202.16	 202.16	 202.16	 0.0	 0.0	 1	 -30.0	 30.0;
	197	 157	 0.00801611	 0.0516806	 0.012499	 215.69	 215.69	 215.69	 0.0	 0.0	 1	 -30.0	 30.0;
	198	 246	 0.00525429	 0.0413684	 0.0226617	 206.22	 206.22	 206.22	 0.0	 0.0	 1	 -30.0	 30.0;
	199	 200	 0.0105279	 0.0441567	 0.00913296	 175.31	 175.31	 175.31	 0.0	 0.0	 1	 -30.0	 30.0;
	199	 253	 0.00802037	 0.0312808	 0.0240349	 229.5	 229.5	 229.5	 0.0	 0.0	 1	 -30.0	 30.0;
	201	 251	 0.00693842	 0.039204	 0.016375	 195.17	 195.17	 195.17	 0.0	 0.0	 1	 -30.0	 30.0;
	202	 17	 0.00698383	 0.0389556	 0.0204675	 212.55	 212.55	 212.55	 0.0	 0.0	 1	 -30.0	 30.0;
	202	 56	 0.00783489	 0.0459576	 0.0268466	 225.33	 225.33	 225.33	 0.0	 0.0	 1	 -30.0	 30.0;
	202	 201	 0.00386324	 0.0244623	 0.0327491	 214.07	 214.07	 214.07	 0.0	 0.0	 1	 -30.0	 30.0;
	203	 315	 0.0103589	 0.0592801	 0.0362542	 233.29	 233.29	 233.29	 0.0	 0.0	 1	 -30.0	 30.0;
	204	 28	 0.00794312	 0.0448473	 0.0182823	 234.14	 234.14	 234.14	 0.0	 0.0	 1	 -30.0	 30.0;
	204	 315	 0.00244174	 0.0174811	 0.0619636	 285.99	 285.99	 285.99	 0.0	 0.0	 1	 -30.0	 30.0;
	205	 12	 0.00840117	 0.0498614	 0.0388297	 215.93	 215.93	 215.93	 0.0	 0.0	 1	 -30.0	 30.0;
	207	 148	 0.0053507	 0.0312066	 0.0405506	 203.6	 203.6	 203.6	 0.0	 0.0	 1	 -30.0	 30.0;
	207	 152	 0.00615042	 0.0311668	 0.0339339	 242.73	 242.73	 242.73	 0.0	 0.0	 1	 -30.0	 30.0;
	208	 162	 0.00898155	 0.0568121	 0.0134563	 212.29	 212.29	 212.29	 0.0	 0.0	 1	 -30.0	 30.0;
	208	 209	 0.00627626	 0.0374794	 0.0230329	 183.56	 183.56	 183.56	 0.0	 0.0	 1	 -30.0	 30.0;
	209	 13	 0.00943909	 0.0454807	 0.0169332	 217.38	 217.38	 217.38	 0.0	 0.0	 1	 -30.0	 30.0;
	209	 14	 0.00570445	 0.0270742	 0.030888	 317.31	 317.31	 317.31	 0.0	 0.0	 1	 -30.0	 30.0;
	209	 455	 0.00840723	 0.0448826	 0.00717159	 278.5	 278.5	 278.5	 0.0	 0.0	 1	 -30.0	 30.0;
	209	 455	 0.00840723	 0.0448826	 0.00717159	 293.27	 293.27	 293.27	 0.0	 0.0	 1	 -30.0	 30.0;
	210	 1	 0.0152392	 0.0698575	 0.0274213	 240.59	 240.59	 240.59	 0.0	 0.0	 1	 -30.0	 30.0;
	210	 89	 0.00397244	 0.0264208	 0.0601697	 281.44	 281.44	 281.44	 0.0	 0.0	 1	 -30.0	 30.0;
	210	 89	 0.00397244	 0.0264208	 0.0601697	 281.44	 281.44	 281.44	 0.0	 0.0	 1	 -30.0	 30.0;
	211	 210	 0.00758494	 0.044758	 0.0124403	 253.6	 253.6	 253.6	 0.0	 0.0	 1	 -30.0	 30.0;
	212	 447	 0.00178893	 0.0102128	 0.00484733	 258.64	 258.64	 258.64	 0.0	 0.0	 1	 -30.0	 30.0;
	213	 214	 0.0037451	 0.0228728	 0.00968813	 225.25	 225.25	 225.25	 0.0	 0.0	 1	 -30.0	 30.0;
	215	 251	 0.0117409	 0.0605448	 0.0286688	 263.99	 263.99	 263.99	 0.0	 0.0	 1	 -30.0	 30.0;
	215	 251	 0.0117409	 0.0605448	 0.0286688	 263.99	 263.99	 263.99	 0.0	 0.0	 1	 -30.0	 30.0;
	216	 194	 0.00578304	 0.0374928	 0.0192971	 210.35	 210.35	 210.35	 0.0	 0.0	 1	 -30.0	 30.0;
	216	 441	 0.00312727	 0.0208103	 0.0063307	 240.31	 240.31	 240.31	 0.0	 0.0	 1	 -30.0	 30.0;
	217	 421	 0.00241219	 0.0167	 0.00633253	 201.29	 201.29	 201.29	 0.0	 0.0	 1	 -30.0	 30.0;
	218	 219	 0.00857311	 0.0551647	 0.00894048	 230.47	 230.47	 230.47	 0.0	 0.0	 1	 -30.0	 30.0;
	218	 382	 0.0100784	 0.0375967	 0.026455	 258.56	 258.56	 258.56	 0.0	 0.0	 1	 -30.0	 30.0;
	220	 315	 0.00355893	 0.0263302	 0.0300112	 205.61	 205.61	 205.61	 0.0	 0.0	 1	 -30.0	 30.0;
	221	 123	 0.0104335	 0.060538	 0.0170116	 229.04	 229.04	 229.04	 0.0	 0.0	 1	 -30.0	 30.0;
	221	 156	 0.0117053	 0.0572478	 0.018905	 203.37	 203.37	 203.37	 0.0	 0.0	 1	 -30.0	 30.0;
	222	 42	 0.00411476	 0.0259096	 0.0187635	 249.24	 249.24	 249.24	 0.0	 0.0	 1	 -30.0	 30.0;
	223	 224	 0.00588657	 0.037647	 0.0212807	 231.09	 231.09	 231.09	 0.0	 0.0	 1	 -30.0	 30.0;
	223	 277	 0.00714704	 0.0436408	 0.0180894	 185.01	 185.01	 185.01	 0.0	 0.0	 1	 -30.0	 30.0;
	224	 377	 0.00785703	 0.0528241	 0.0173832	 282.56	 282.56	 282.56	 0.0	 0.0	 1	 -30.0	 30.0;
	225	 134	 0.0197772	 0.0945552	 0.0218207	 171.8	 171.8	 171.8	 0.0	 0.0	 1	 -30.0	 30.0;
	225	 230	 0.0136298	 0.0724565	 0.0137919	 189.22	 189.22	 189.22	 0.0	 0.0	 1	 -30.0	 30.0;
	226	 127	 0.00636651	 0.039434	 0.0364845	 228.48	 228.48	 228.48	 0.0	 0.0	 1	 -30.0	 30.0;
	227	 304	 0.0209617	 0.0768189	 0.0265371	 223.43	 223.43	 223.43	 0.0	 0.0	 1	 -30.0	 30.0;
	228	 77	 0.0100973	 0.0519099	 0.0122713	 200.25	 200.25	 200.25	 0.0	 0.0	 1	 -30.0	 30.0;
	230	 261	 0.0117979	 0.051572	 0.0271212	 208.52	 208.52	 208.52	 0.0	 0.0	 1	 -30.0	 30.0;
	231	 233	 0.000254732	 0.00110199	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	231	 278	 0.00109778	 0.0135445	 0.17031	 1115.46	 1115.46	 1115.46	 0.0	 0.0	 1	 -30.0	 30.0;
	232	 94	 0.00860686	 0.0347308	 0.0220854	 246.21	 246.21	 246.21	 0.0	 0.0	 1	 -30.0	 30.0;
	232	 234	 0.00531952	 0.0318575	 0.00762114	 235.64	 235.64	 235.64	 0.0	 0.0	 1	 -30.0	 30.0;
	232	 296	 0.00549162	 0.0301785	 0.0225615	 478.99	 478.99	 478.99	 0.0	 0.0	 1	 -30.0	 30.0;
	232	 296	 0.00549162	 0.0301785	 0.0225615	 478.99	 478.99	 478.99	 0.0	 0.0	 1	 -30.0	 30.0;
	232	 495	 0.00447264	 0.0252841	 0.0147161	 209.35	 209.35	 209.35	 0.0	 0.0	 1	 -30.0	 30.0;
	234	 94	 0.00271156	 0.0161032	 0.0160785	 230.93	 230.93	 230.93	 0.0	 0.0	 1	 -30.0	 30.0;
	235	 306	 0.00812201	 0.0472273	 0.0137623	 218.26	 218.26	 218.26	 0.0	 0.0	 1	 -30.0	 30.0;
	237	 238	 0.00606403	 0.0337143	 0.0236608	 323.04	 323.04	 323.04	 0.0	 0.0	 1	 -30.0	 30.0;
	238	 359	 0.0073114	 0.0365176	 0.0280548	 276.53	 276.53	 276.53	 0.0	 0.0	 1	 -30.0	 30.0;
	238	 359	 0.0073114	 0.0365176	 0.0280548	 276.53	 276.53	 276.53	 0.0	 0.0	 1	 -30.0	 30.0;
	239	 67	 0.0158524	 0.108623	 0.0182117	 223.35	 223.35	 223.35	 0.0	 0.0	 1	 -30.0	 30.0;
	239	 172	 0.00344576	 0.0203593	 0.00970442	 240.06	 240.06	 240.06	 0.0	 0.0	 1	 -30.0	 30.0;
	240	 88	 0.0134858	 0.0625222	 0.0111221	 216.49	 216.49	 216.49	 0.0	 0.0	 1	 -30.0	 30.0;
	240	 126	 0.0118939	 0.0722295	 0.0232966	 187.85	 187.85	 187.85	 0.0	 0.0	 1	 -30.0	 30.0;
	242	 243	 0.0138258	 0.0785427	 0.0193021	 174.9	 174.9	 174.9	 0.0	 0.0	 1	 -30.0	 30.0;
	243	 160	 0.0086236	 0.0391769	 0.0275199	 239.47	 239.47	 239.47	 0.0	 0.0	 1	 -30.0	 30.0;
	244	 279	 0.0158341	 0.0518919	 0.0125865	 249.79	 249.79	 249.79	 0.0	 0.0	 1	 -30.0	 30.0;
	244	 491	 0.00321432	 0.0232783	 0.00727573	 216.6	 216.6	 216.6	 0.0	 0.0	 1	 -30.0	 30.0;
	246	 140	 0.00621165	 0.0353944	 0.0160529	 232.44	 232.44	 232.44	 0.0	 0.0	 1	 -30.0	 30.0;
	247	 133	 1e-07	 0.059	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	247	 387	 0.0108557	 0.0767928	 0.00935552	 221.11	 221.11	 221.11	 0.0	 0.0	 1	 -30.0	 30.0;
	248	 60	 0.00948303	 0.0543826	 0.00864013	 219.42	 219.42	 219.42	 0.0	 0.0	 1	 -30.0	 30.0;
	249	 248	 0.00655432	 0.0433484	 0.0154156	 199.4	 199.4	 199.4	 0.0	 0.0	 1	 -30.0	 30.0;
	250	 249	 0.00370925	 0.0227163	 0.0361231	 191.18	 191.18	 191.18	 0.0	 0.0	 1	 -30.0	 30.0;
	251	 222	 0.00450654	 0.0273755	 0.0272315	 217.96	 217.96	 217.96	 0.0	 0.0	 1	 -30.0	 30.0;
	252	 254	 0.000254254	 0.00117123	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	252	 322	 0.00190519	 0.0220599	 0.46598	 1234.69	 1234.69	 1234.69	 0.0	 0.0	 1	 -30.0	 30.0;
	252	 360	 0.00165756	 0.0183628	 0.575877	 1049.65	 1049.65	 1049.65	 0.0	 0.0	 1	 -30.0	 30.0;
	253	 257	 0.00690278	 0.0371656	 0.00999364	 213.65	 213.65	 213.65	 0.0	 0.0	 1	 -30.0	 30.0;
	253	 258	 0.0022007	 0.0115699	 0.0118217	 337.84	 337.84	 337.84	 0.0	 0.0	 1	 -30.0	 30.0;
	255	 253	 0.00516962	 0.0285994	 0.0136688	 196.82	 196.82	 196.82	 0.0	 0.0	 1	 -30.0	 30.0;
	255	 259	 0.00467484	 0.0315177	 0.00583298	 206.03	 206.03	 206.03	 0.0	 0.0	 1	 -30.0	 30.0;
	256	 127	 0.00734213	 0.0428733	 0.0498711	 212.82	 212.82	 212.82	 0.0	 0.0	 1	 -30.0	 30.0;
	256	 199	 1e-07	 0.015	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	256	 253	 0.00747521	 0.0427513	 0.00938328	 252.48	 252.48	 252.48	 0.0	 0.0	 1	 -30.0	 30.0;
	257	 258	 0.00282706	 0.0184683	 0.00637348	 188.97	 188.97	 188.97	 0.0	 0.0	 1	 -30.0	 30.0;
	258	 272	 0.007864	 0.0492936	 0.0167299	 190.07	 190.07	 190.07	 0.0	 0.0	 1	 -30.0	 30.0;
	259	 258	 0.00148757	 0.00886864	 0.0686171	 197.62	 197.62	 197.62	 0.0	 0.0	 1	 -30.0	 30.0;
	260	 110	 0.00555265	 0.0279208	 0.0170557	 190.3	 190.3	 190.3	 0.0	 0.0	 1	 -30.0	 30.0;
	261	 260	 0.0117845	 0.048387	 0.0124691	 272.4	 272.4	 272.4	 0.0	 0.0	 1	 -30.0	 30.0;
	262	 26	 0.00797486	 0.0413554	 0.0171391	 244.94	 244.94	 244.94	 0.0	 0.0	 1	 -30.0	 30.0;
	263	 262	 0.00618428	 0.0306474	 0.0903401	 222.96	 222.96	 222.96	 0.0	 0.0	 1	 -30.0	 30.0;
	264	 323	 0.00990689	 0.0580426	 0.0280558	 196.84	 196.84	 196.84	 0.0	 0.0	 1	 -30.0	 30.0;
	265	 61	 1e-07	 0.022	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	265	 118	 0.00976468	 0.0452648	 0.0320573	 221.71	 221.71	 221.71	 0.0	 0.0	 1	 -30.0	 30.0;
	265	 120	 0.0113284	 0.0599862	 0.0119444	 237.22	 237.22	 237.22	 0.0	 0.0	 1	 -30.0	 30.0;
	266	 74	 0.00944802	 0.0474177	 0.0209204	 259.64	 259.64	 259.64	 0.0	 0.0	 1	 -30.0	 30.0;
	266	 74	 0.00944802	 0.0474177	 0.0209204	 259.64	 259.64	 259.64	 0.0	 0.0	 1	 -30.0	 30.0;
	269	 109	 0.0130023	 0.0648244	 0.022019	 244.74	 244.74	 244.74	 0.0	 0.0	 1	 -30.0	 30.0;
	269	 197	 0.00808209	 0.0541968	 0.0230938	 233.48	 233.48	 233.48	 0.0	 0.0	 1	 -30.0	 30.0;
	269	 241	 0.0151243	 0.102255	 0.038663	 190.5	 190.5	 190.5	 0.0	 0.0	 1	 -30.0	 30.0;
	270	 304	 0.0111556	 0.0838027	 0.0209195	 234.42	 234.42	 234.42	 0.0	 0.0	 1	 -30.0	 30.0;
	271	 85	 0.0112375	 0.075637	 0.0227131	 207.06	 207.06	 207.06	 0.0	 0.0	 1	 -30.0	 30.0;
	279	 445	 0.00857919	 0.038751	 0.0197652	 252.98	 252.98	 252.98	 0.0	 0.0	 1	 -30.0	 30.0;
	282	 290	 0.000238243	 0.00100208	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	283	 182	 0.00522151	 0.0291578	 0.0319451	 269.35	 269.35	 269.35	 0.0	 0.0	 1	 -30.0	 30.0;
	283	 182	 0.00522151	 0.0291578	 0.0319451	 269.35	 269.35	 269.35	 0.0	 0.0	 1	 -30.0	 30.0;
	283	 224	 0.00647754	 0.0329659	 0.0188678	 216.41	 216.41	 216.41	 0.0	 0.0	 1	 -30.0	 30.0;
	283	 346	 0.00496981	 0.033752	 0.0141005	 215.7	 215.7	 215.7	 0.0	 0.0	 1	 -30.0	 30.0;
	283	 359	 0.0112807	 0.0610502	 0.0246742	 189.35	 189.35	 189.35	 0.0	 0.0	 1	 -30.0	 30.0;
	290	 336	 0.000546967	 0.00661487	 0.319239	 1013.91	 1013.91	 1013.91	 0.0	 0.0	 1	 -30.0	 30.0;
	290	 397	 0.00156589	 0.0197034	 0.584176	 1362.72	 1362.72	 1362.72	 0.0	 0.0	 1	 -30.0	 30.0;
	291	 227	 0.0102001	 0.0550615	 0.0399772	 217.52	 217.52	 217.52	 0.0	 0.0	 1	 -30.0	 30.0;
	291	 293	 0.000277674	 0.00113775	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	291	 486	 0.00862536	 0.0467738	 0.0409467	 304.26	 304.26	 304.26	 0.0	 0.0	 1	 -30.0	 30.0;
	295	 231	 0.00041405	 0.00459194	 0.176305	 1264.39	 1264.39	 1264.39	 0.0	 0.0	 1	 -30.0	 30.0;
	295	 389	 0.000842003	 0.0109231	 0.255562	 1124.85	 1124.85	 1124.85	 0.0	 0.0	 1	 -30.0	 30.0;
	303	 305	 0.000216238	 0.00116227	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	305	 454	 0.00147007	 0.0161904	 0.455797	 1120.02	 1120.02	 1120.02	 0.0	 0.0	 1	 -30.0	 30.0;
	306	 236	 0.00909647	 0.0443105	 0.0204446	 213.5	 213.5	 213.5	 0.0	 0.0	 1	 -30.0	 30.0;
	307	 308	 0.000243783	 0.00101928	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	309	 429	 0.000524347	 0.00641311	 0.12507	 1443.34	 1443.34	 1443.34	 0.0	 0.0	 1	 -30.0	 30.0;
	309	 429	 0.000524347	 0.00641311	 0.12507	 1443.34	 1443.34	 1443.34	 0.0	 0.0	 1	 -30.0	 30.0;
	309	 435	 0.00057789	 0.00773113	 0.111558	 1749.02	 1749.02	 1749.02	 0.0	 0.0	 1	 -30.0	 30.0;
	314	 460	 0.00284337	 0.03353	 0.530692	 1090.95	 1090.95	 1090.95	 0.0	 0.0	 1	 -30.0	 30.0;
	315	 486	 0.000891366	 0.00620047	 0.00357338	 270.45	 270.45	 270.45	 0.0	 0.0	 1	 -30.0	 30.0;
	315	 488	 0.000846838	 0.00524732	 0.00176077	 273.93	 273.93	 273.93	 0.0	 0.0	 1	 -30.0	 30.0;
	322	 360	 0.00392073	 0.0457192	 0.876636	 1081.89	 1081.89	 1081.89	 0.0	 0.0	 1	 -30.0	 30.0;
	330	 331	 0.000262545	 0.00107587	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	332	 121	 0.00159428	 0.0205853	 0.327303	 1048.75	 1048.75	 1048.75	 0.0	 0.0	 1	 -30.0	 30.0;
	332	 454	 0.00146382	 0.017945	 0.410634	 1077.53	 1077.53	 1077.53	 0.0	 0.0	 1	 -30.0	 30.0;
	333	 123	 0.00408968	 0.0210445	 0.0525623	 275.7	 275.7	 275.7	 0.0	 0.0	 1	 -30.0	 30.0;
	333	 124	 0.00233389	 0.0131293	 0.00626889	 260.97	 260.97	 260.97	 0.0	 0.0	 1	 -30.0	 30.0;
	333	 124	 0.00233389	 0.0131293	 0.00626889	 260.97	 260.97	 260.97	 0.0	 0.0	 1	 -30.0	 30.0;
	336	 397	 0.00139177	 0.0169482	 0.23371	 1419.82	 1419.82	 1419.82	 0.0	 0.0	 1	 -30.0	 30.0;
	337	 359	 0.00748705	 0.0468268	 0.0433188	 243.37	 243.37	 243.37	 0.0	 0.0	 1	 -30.0	 30.0;
	342	 130	 0.0147359	 0.0812897	 0.0247527	 221.08	 221.08	 221.08	 0.0	 0.0	 1	 -30.0	 30.0;
	342	 294	 0.000364389	 0.00264717	 0.00871279	 268.04	 268.04	 268.04	 0.0	 0.0	 1	 -30.0	 30.0;
	342	 294	 0.000364389	 0.00264717	 0.00871279	 268.04	 268.04	 268.04	 0.0	 0.0	 1	 -30.0	 30.0;
	346	 182	 0.0060196	 0.0328492	 0.0116299	 210.47	 210.47	 210.47	 0.0	 0.0	 1	 -30.0	 30.0;
	347	 349	 0.000269385	 0.00117548	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	348	 277	 0.00302296	 0.0175156	 0.00468744	 191.83	 191.83	 191.83	 0.0	 0.0	 1	 -30.0	 30.0;
	349	 397	 0.00142692	 0.0184016	 0.321924	 1161.07	 1161.07	 1161.07	 0.0	 0.0	 1	 -30.0	 30.0;
	350	 332	 0.00153637	 0.019112	 0.448199	 1164.99	 1164.99	 1164.99	 0.0	 0.0	 1	 -30.0	 30.0;
	350	 352	 0.000205522	 0.00104958	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	350	 429	 0.00176299	 0.024221	 0.504029	 1225.53	 1225.53	 1225.53	 0.0	 0.0	 1	 -30.0	 30.0;
	350	 435	 0.00161779	 0.0220227	 0.472836	 1231.82	 1231.82	 1231.82	 0.0	 0.0	 1	 -30.0	 30.0;
	351	 15	 0.00570042	 0.038097	 0.0166404	 297.73	 297.73	 297.73	 0.0	 0.0	 1	 -30.0	 30.0;
	351	 331	 0.00799383	 0.0592914	 0.0117197	 265.07	 265.07	 265.07	 0.0	 0.0	 1	 -30.0	 30.0;
	351	 331	 0.00799383	 0.0592914	 0.0117197	 265.07	 265.07	 265.07	 0.0	 0.0	 1	 -30.0	 30.0;
	353	 355	 0.000218687	 0.00118004	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	355	 342	 0.00596794	 0.0411946	 0.0460902	 257.41	 257.41	 257.41	 0.0	 0.0	 1	 -30.0	 30.0;
	355	 390	 0.000438285	 0.0025026	 0.0028364	 192.83	 192.83	 192.83	 0.0	 0.0	 1	 -30.0	 30.0;
	356	 467	 0.00171289	 0.00892976	 0.00401818	 191.82	 191.82	 191.82	 0.0	 0.0	 1	 -30.0	 30.0;
	357	 480	 0.00280056	 0.0134351	 0.00332662	 291.7	 291.7	 291.7	 0.0	 0.0	 1	 -30.0	 30.0;
	357	 480	 0.00280056	 0.0134351	 0.00332662	 291.7	 291.7	 291.7	 0.0	 0.0	 1	 -30.0	 30.0;
	357	 480	 0.00280056	 0.0134351	 0.00332662	 291.7	 291.7	 291.7	 0.0	 0.0	 1	 -30.0	 30.0;
	358	 268	 0.00785076	 0.0476886	 0.0169176	 233.04	 233.04	 233.04	 0.0	 0.0	 1	 -30.0	 30.0;
	358	 467	 0.00692768	 0.0315186	 0.0129906	 181.78	 181.78	 181.78	 0.0	 0.0	 1	 -30.0	 30.0;
	359	 366	 0.0068981	 0.0402096	 0.0127396	 196.5	 196.5	 196.5	 0.0	 0.0	 1	 -30.0	 30.0;
	359	 377	 0.012625	 0.0936918	 0.0239153	 228.99	 228.99	 228.99	 0.0	 0.0	 1	 -30.0	 30.0;
	359	 473	 0.00222543	 0.0129046	 0.00606894	 247.89	 247.89	 247.89	 0.0	 0.0	 1	 -30.0	 30.0;
	360	 54	 0.00100276	 0.0120556	 0.249915	 1072.37	 1072.37	 1072.37	 0.0	 0.0	 1	 -30.0	 30.0;
	361	 34	 0.00379348	 0.0202895	 0.0219664	 316.83	 316.83	 316.83	 0.0	 0.0	 1	 -30.0	 30.0;
	361	 34	 0.00379348	 0.0202895	 0.0219664	 316.83	 316.83	 316.83	 0.0	 0.0	 1	 -30.0	 30.0;
	370	 373	 0.000225361	 0.00114438	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	373	 323	 0.000257772	 0.00169688	 0.00189708	 244.33	 244.33	 244.33	 0.0	 0.0	 1	 -30.0	 30.0;
	374	 376	 0.000205616	 0.00119869	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	376	 117	 0.00565957	 0.0367338	 0.0198822	 223.49	 223.49	 223.49	 0.0	 0.0	 1	 -30.0	 30.0;
	377	 337	 0.00166037	 0.0118851	 0.00793188	 278.49	 278.49	 278.49	 0.0	 0.0	 1	 -30.0	 30.0;
	382	 383	 0.000298548	 0.00105538	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	382	 385	 0.00189251	 0.0109271	 0.00841737	 224.14	 224.14	 224.14	 0.0	 0.0	 1	 -30.0	 30.0;
	382	 488	 0.00459748	 0.0199241	 0.0423444	 255.31	 255.31	 255.31	 0.0	 0.0	 1	 -30.0	 30.0;
	384	 385	 0.000259286	 0.00110193	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	385	 421	 0.00389512	 0.0241239	 0.00906982	 220.32	 220.32	 220.32	 0.0	 0.0	 1	 -30.0	 30.0;
	386	 388	 0.000221284	 0.00109415	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	387	 229	 0.0115492	 0.0573315	 0.0138829	 235.12	 235.12	 235.12	 0.0	 0.0	 1	 -30.0	 30.0;
	388	 309	 0.000885474	 0.00873812	 0.148563	 1045.47	 1045.47	 1045.47	 0.0	 0.0	 1	 -30.0	 30.0;
	389	 414	 0.000913429	 0.0104943	 0.16381	 1144.19	 1144.19	 1144.19	 0.0	 0.0	 1	 -30.0	 30.0;
	395	 397	 0.000264513	 0.0010891	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	397	 54	 0.001546	 0.019078	 0.340158	 1607.07	 1607.07	 1607.07	 0.0	 0.0	 1	 -30.0	 30.0;
	397	 479	 0.000739667	 0.00965056	 0.222224	 1676.94	 1676.94	 1676.94	 0.0	 0.0	 1	 -30.0	 30.0;
	398	 260	 0.00417165	 0.0304097	 0.0208194	 248.85	 248.85	 248.85	 0.0	 0.0	 1	 -30.0	 30.0;
	398	 423	 0.000966411	 0.0049338	 0.00267166	 194.66	 194.66	 194.66	 0.0	 0.0	 1	 -30.0	 30.0;
	399	 12	 0.00224359	 0.0129772	 0.00657691	 213.75	 213.75	 213.75	 0.0	 0.0	 1	 -30.0	 30.0;
	399	 500	 0.00366597	 0.0159435	 0.00462133	 200.82	 200.82	 200.82	 0.0	 0.0	 1	 -30.0	 30.0;
	400	 403	 0.00021407	 0.00105349	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	403	 390	 0.00390505	 0.016682	 0.00889956	 187.66	 187.66	 187.66	 0.0	 0.0	 1	 -30.0	 30.0;
	403	 415	 0.0108099	 0.0598869	 0.0150022	 238.84	 238.84	 238.84	 0.0	 0.0	 1	 -30.0	 30.0;
	404	 396	 0.00812376	 0.0533399	 0.0183921	 259.18	 259.18	 259.18	 0.0	 0.0	 1	 -30.0	 30.0;
	405	 190	 0.003084	 0.0385355	 0.635924	 1182.98	 1182.98	 1182.98	 0.0	 0.0	 1	 -30.0	 30.0;
	406	 399	 0.00202341	 0.00976371	 0.00208054	 268.98	 268.98	 268.98	 0.0	 0.0	 1	 -30.0	 30.0;
	406	 399	 0.00202341	 0.00976371	 0.00208054	 268.98	 268.98	 268.98	 0.0	 0.0	 1	 -30.0	 30.0;
	406	 500	 0.00468402	 0.0252229	 0.00876131	 194.96	 194.96	 194.96	 0.0	 0.0	 1	 -30.0	 30.0;
	413	 168	 0.0101345	 0.0604995	 0.0233408	 160.34	 160.34	 160.34	 0.0	 0.0	 1	 -30.0	 30.0;
	413	 272	 0.00891228	 0.053729	 0.0131931	 204.57	 204.57	 204.57	 0.0	 0.0	 1	 -30.0	 30.0;
	415	 21	 1e-07	 0.05	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	422	 388	 0.00142425	 0.0173547	 0.26896	 1073.12	 1073.12	 1073.12	 0.0	 0.0	 1	 -30.0	 30.0;
	429	 498	 0.00296972	 0.031295	 0.492416	 1280.79	 1280.79	 1280.79	 0.0	 0.0	 1	 -30.0	 30.0;
	430	 81	 0.00192456	 0.0121334	 0.00727771	 300.0	 300.0	 300.0	 0.0	 0.0	 1	 -30.0	 30.0;
	430	 84	 0.00448199	 0.0263734	 0.0203741	 279.98	 279.98	 279.98	 0.0	 0.0	 0	 -30.0	 30.0;
	430	 84	 0.00448199	 0.0263734	 0.0203741	 279.98	 279.98	 279.98	 0.0	 0.0	 1	 -30.0	 30.0;
	435	 429	 0.000293616	 0.00373016	 0.0483406	 1120.52	 1120.52	 1120.52	 0.0	 0.0	 1	 -30.0	 30.0;
	436	 83	 0.00278136	 0.0150291	 0.00518546	 226.04	 226.04	 226.04	 0.0	 0.0	 1	 -30.0	 30.0;
	436	 430	 0.00463186	 0.0213539	 0.0107223	 288.88	 288.88	 288.88	 0.0	 0.0	 1	 -30.0	 30.0;
	442	 445	 0.000221289	 0.00117614	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	445	 244	 0.00205911	 0.00975556	 0.0109951	 253.31	 253.31	 253.31	 0.0	 0.0	 1	 -30.0	 30.0;
	446	 360	 0.00041589	 0.00514463	 0.234184	 1189.37	 1189.37	 1189.37	 0.0	 0.0	 1	 -30.0	 30.0;
	453	 13	 0.00430787	 0.0243324	 0.00718999	 226.69	 226.69	 226.69	 0.0	 0.0	 1	 -30.0	 30.0;
	460	 305	 0.00130852	 0.0176285	 0.230534	 1211.08	 1211.08	 1211.08	 0.0	 0.0	 1	 -30.0	 30.0;
	461	 7	 0.00348701	 0.0233525	 0.0297729	 311.15	 311.15	 311.15	 0.0	 0.0	 1	 -30.0	 30.0;
	465	 467	 0.00028339	 0.00117069	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	467	 188	 0.00703121	 0.0532559	 0.0407168	 187.56	 187.56	 187.56	 0.0	 0.0	 1	 -30.0	 30.0;
	468	 121	 0.000955644	 0.0128413	 0.261586	 1089.73	 1089.73	 1089.73	 0.0	 0.0	 1	 -30.0	 30.0;
	469	 306	 0.00422112	 0.0229097	 0.0438245	 278.22	 278.22	 278.22	 0.0	 0.0	 1	 -30.0	 30.0;
	472	 473	 0.000234911	 0.00106703	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	473	 377	 0.00773654	 0.0559391	 0.0348232	 236.79	 236.79	 236.79	 0.0	 0.0	 1	 -30.0	 30.0;
	474	 477	 0.000293541	 0.00115735	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	478	 7	 0.0213225	 0.0914343	 0.0278942	 258.33	 258.33	 258.33	 0.0	 0.0	 1	 -30.0	 30.0;
	478	 242	 0.00771352	 0.0314984	 0.0101261	 293.25	 293.25	 293.25	 0.0	 0.0	 1	 -30.0	 30.0;
	478	 480	 0.00906359	 0.052802	 0.0266087	 244.07	 244.07	 244.07	 0.0	 0.0	 1	 -30.0	 30.0;
	479	 54	 0.00104602	 0.014046	 0.350355	 1207.95	 1207.95	 1207.95	 0.0	 0.0	 1	 -30.0	 30.0;
	487	 242	 0.00955583	 0.0567222	 0.00974044	 205.85	 205.85	 205.85	 0.0	 0.0	 1	 -30.0	 30.0;
	487	 441	 0.00861538	 0.0500581	 0.0135023	 212.47	 212.47	 212.47	 0.0	 0.0	 1	 -30.0	 30.0;
	488	 217	 0.00386786	 0.0223528	 0.0133963	 251.11	 251.11	 251.11	 0.0	 0.0	 1	 -30.0	 30.0;
	488	 486	 0.00065584	 0.00316221	 0.00147663	 240.65	 240.65	 240.65	 0.0	 0.0	 1	 -30.0	 30.0;
	489	 89	 0.0042275	 0.0202284	 0.0108331	 267.29	 267.29	 267.29	 0.0	 0.0	 1	 -30.0	 30.0;
	489	 91	 0.0040245	 0.0220514	 0.00641127	 262.37	 262.37	 262.37	 0.0	 0.0	 1	 -30.0	 30.0;
	490	 491	 0.000283352	 0.00110546	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	492	 495	 0.000223082	 0.00118991	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	495	 234	 0.00300018	 0.0163325	 0.0100254	 240.29	 240.29	 240.29	 0.0	 0.0	 1	 -30.0	 30.0;
	496	 498	 0.000260461	 0.00102313	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	497	 96	 0.00550502	 0.0392586	 0.00859406	 214.92	 214.92	 214.92	 0.0	 0.0	 1	 -30.0	 30.0;
	497	 158	 0.00972333	 0.0560053	 0.0120326	 264.27	 264.27	 264.27	 0.0	 0.0	 1	 -30.0	 30.0;
	498	 360	 0.00101516	 0.0127879	 0.280018	 1247.99	 1247.99	 1247.99	 0.0	 0.0	 1	 -30.0	 30.0;
	498	 446	 0.00106712	 0.0139619	 0.222125	 1135.38	 1135.38	 1135.38	 0.0	 0.0	 1	 -30.0	 30.0;
	499	 500	 0.000251066	 0.001098	 0.0	 99999.0	 99999.0	 99999.0	 0.0	 0.0	 1	 -30.0	 30.0;
	21	 20	 0.000536254	 0.0293108	 0.0	 390.5	 390.5	 390.5	 1.0125	 0.0	 1	 -30.0	 30.0;
	26	 25	 0.000505881	 0.0243569	 0.0	 506.92	 506.92	 506.92	 1.03125	 0.0	 1	 -30.0	 30.0;
	42	 41	 0.000541271	 0.0336934	 0.0	 461.08	 461.08	 461.08	 1.1	 0.0	 1	 -30.0	 30.0;
	42	 41	 0.000541271	 0.0336934	 0.0	 461.08	 461.08	 461.08	 1.1	 0.0	 1	 -30.0	 30.0;
	42	 41	 0.000541271	 0.0336934	 0.0	 461.08	 461.08	 461.08	 1.1	 0.0	 1	 -30.0	 30.0;
	53	 52	 0.000502968	 0.0277845	 0.0	 628.27	 628.27	 628.27	 1.0	 0.0	 1	 -30.0	 30.0;
	53	 52	 0.000502968	 0.0277845	 0.0	 628.27	 628.27	 628.27	 1.0	 0.0	 1	 -30.0	 30.0;
	53	 52	 0.000502968	 0.0277845	 0.0	 628.27	 628.27	 628.27	 1.0	 0.0	 1	 -30.0	 30.0;
	91	 90	 0.000438011	 0.0296883	 0.0	 509.59	 509.59	 509.59	 1.0	 0.0	 1	 -30.0	 30.0;
	91	 90	 0.000438011	 0.0296883	 0.0	 509.59	 509.59	 509.59	 1.0	 0.0	 0	 -30.0	 30.0;
	91	 90	 0.000438011	 0.0296883	 0.0	 509.59	 509.59	 509.59	 1.0	 0.0	 1	 -30.0	 30.0;
	98	 97	 0.000525414	 0.0325224	 0.0	 362.58	 362.58	 362.58	 1.03125	 0.0	 1	 -30.0	 30.0;
	107	 106	 0.000611845	 0.0360405	 0.0	 478.65	 478.65	 478.65	 1.03125	 0.0	 1	 -30.0	 30.0;
	107	 106	 0.000611845	 0.0360405	 0.0	 478.65	 478.65	 478.65	 1.03125	 0.0	 1	 -30.0	 30.0;
	107	 106	 0.000611845	 0.0360405	 0.0	 478.65	 478.65	 478.65	 1.03125	 0.0	 1	 -30.0	 30.0;
	120	 119	 0.000693805	 0.0308972	 0.0	 409.0	 409.0	 409.0	 1.04375	 0.0	 1	 -30.0	 30.0;
	136	 135	 0.000343226	 0.0245211	 0.0	 439.36	 439.36	 439.36	 1.0375	 0.0	 1	 -30.0	 30.0;
	136	 135	 0.000343226	 0.0245211	 0.0	 439.36	 439.36	 439.36	 1.0375	 0.0	 1	 -30.0	 30.0;
	152	 151	 0.000448214	 0.0240375	 0.0	 555.68	 555.68	 555.68	 1.03125	 0.0	 1	 -30.0	 30.0;
	152	 151	 0.000448214	 0.0240375	 0.0	 555.68	 555.68	 555.68	 1.03125	 0.0	 1	 -30.0	 30.0;
	152	 151	 0.000448214	 0.0240375	 0.0	 555.68	 555.68	 555.68	 1.03125	 0.0	 1	 -30.0	 30.0;
	191	 190	 0.000547832	 0.0347294	 0.0	 491.96	 491.96	 491.96	 1.04375	 0.0	 1	 -30.0	 30.0;
	191	 190	 0.000547832	 0.0347294	 0.0	 491.96	 491.96	 491.96	 1.04375	 0.0	 1	 -30.0	 30.0;
	191	 190	 0.000547832	 0.0347294	 0.0	 491.96	 491.96	 491.96	 1.04375	 0.0	 1	 -30.0	 30.0;
	232	 231	 0.000468765	 0.0188084	 0.0	 651.35	 651.35	 651.35	 1.0375	 0.0	 1	 -30.0	 30.0;
	253	 252	 0.000428145	 0.023393	 0.0	 496.41	 496.41	 496.41	 1.05625	 0.0	 1	 -30.0	 30.0;
	253	 252	 0.000428145	 0.023393	 0.0	 496.41	 496.41	 496.41	 1.05625	 0.0	 1	 -30.0	 30.0;
	253	 252	 0.000428145	 0.023393	 0.0	 496.41	 496.41	 496.41	 1.05625	 0.0	 1	 -30.0	 30.0;
	273	 275	 0.000202221	 0.0140924	 0.0	 1154.66	 1154.66	 1154.66	 1.05	 0.0	 1	 -30.0	 30.0;
	273	 276	 0.000217879	 0.0120592	 0.0	 1154.66	 1154.66	 1154.66	 1.05	 0.0	 1	 -30.0	 30.0;
	274	 273	 0.000420564	 0.0262256	 0.0	 620.34	 620.34	 620.34	 1.0	 0.0	 1	 -30.0	 30.0;
	278	 280	 0.000479866	 0.0306603	 0.0	 321.49	 321.49	 321.49	 1.0125	 0.0	 1	 -30.0	 30.0;
	278	 281	 0.00031103	 0.0219887	 0.0	 319.26	 319.26	 319.26	 1.00625	 0.0	 1	 -30.0	 30.0;
	279	 278	 0.000366522	 0.019924	 0.0	 522.19	 522.19	 522.19	 1.0	 0.0	 1	 -30.0	 30.0;
	279	 278	 0.000366522	 0.019924	 0.0	 522.19	 522.19	 522.19	 1.0	 0.0	 1	 -30.0	 30.0;
	279	 278	 0.000366522	 0.019924	 0.0	 522.19	 522.19	 522.19	 1.0	 0.0	 1	 -30.0	 30.0;
	282	 284	 0.000373065	 0.0260709	 0.0	 379.67	 379.67	 379.67	 1.00625	 0.0	 1	 -30.0	 30.0;
	282	 285	 0.000428104	 0.0310478	 0.0	 376.33	 376.33	 376.33	 1.00625	 0.0	 1	 -30.0	 30.0;
	282	 286	 0.000520688	 0.0282001	 0.0	 370.2	 370.2	 370.2	 1.00625	 0.0	 1	 -30.0	 30.0;
	282	 287	 0.000483108	 0.0327549	 0.0	 368.66	 368.66	 368.66	 1.00625	 0.0	 1	 -30.0	 30.0;
	282	 288	 0.000526109	 0.0331453	 0.0	 367.71	 367.71	 367.71	 1.00625	 0.0	 1	 -30.0	 30.0;
	282	 289	 0.000347274	 0.0252107	 0.0	 367.33	 367.33	 367.33	 1.00625	 0.0	 1	 -30.0	 30.0;
	283	 282	 0.000525978	 0.0318151	 0.0	 471.3	 471.3	 471.3	 1.01875	 0.0	 1	 -30.0	 30.0;
	283	 282	 0.000525978	 0.0318151	 0.0	 471.3	 471.3	 471.3	 1.01875	 0.0	 1	 -30.0	 30.0;
	283	 282	 0.000525978	 0.0318151	 0.0	 471.3	 471.3	 471.3	 1.01875	 0.0	 1	 -30.0	 30.0;
	291	 292	 0.35543	 11.2968	 0.0	 1.3	 1.3	 1.3	 1.0	 0.0	 1	 -30.0	 30.0;
	295	 297	 0.000379185	 0.0247737	 0.0	 334.88	 334.88	 334.88	 0.98125	 0.0	 1	 -30.0	 30.0;
	295	 298	 0.000716326	 0.0379339	 0.0	 334.69	 334.69	 334.69	 0.98125	 0.0	 1	 -30.0	 30.0;
	295	 299	 0.000304059	 0.0206591	 0.0	 334.28	 334.28	 334.28	 0.98125	 0.0	 1	 -30.0	 30.0;
	295	 300	 0.00155879	 0.0573822	 0.0	 332.41	 332.41	 332.41	 0.98125	 0.0	 1	 -30.0	 30.0;
	295	 301	 0.000556456	 0.0323544	 0.0	 331.98	 331.98	 331.98	 0.98125	 0.0	 1	 -30.0	 30.0;
	295	 302	 0.000745624	 0.044177	 0.0	 323.04	 323.04	 323.04	 0.98125	 0.0	 1	 -30.0	 30.0;
	296	 295	 0.000193487	 0.0143159	 0.0	 544.49	 544.49	 544.49	 1.0125	 0.0	 1	 -30.0	 30.0;
	296	 295	 0.000193487	 0.0143159	 0.0	 544.49	 544.49	 544.49	 1.0125	 0.0	 1	 -30.0	 30.0;
	296	 295	 0.000193487	 0.0143159	 0.0	 544.49	 544.49	 544.49	 1.0125	 0.0	 1	 -30.0	 30.0;
	304	 303	 0.000325823	 0.0169846	 0.0	 458.34	 458.34	 458.34	 1.0	 0.0	 1	 -30.0	 30.0;
	309	 311	 7.42139e-05	 0.00565391	 0.0	 1514.07	 1514.07	 1514.07	 1.05	 0.0	 1	 -30.0	 30.0;
	309	 312	 7.42648e-05	 0.00477232	 0.0	 1514.07	 1514.07	 1514.07	 1.05	 0.0	 1	 -30.0	 30.0;
	309	 313	 0.000116301	 0.00893914	 0.0	 1514.07	 1514.07	 1514.07	 1.05	 0.0	 1	 -30.0	 30.0;
	310	 309	 0.000378438	 0.0230997	 0.0	 510.8	 510.8	 510.8	 0.9875	 0.0	 1	 -30.0	 30.0;
	310	 309	 0.000378438	 0.0230997	 0.0	 510.8	 510.8	 510.8	 0.9875	 0.0	 1	 -30.0	 30.0;
	310	 309	 0.000378438	 0.0230997	 0.0	 510.8	 510.8	 510.8	 0.9875	 0.0	 1	 -30.0	 30.0;
	314	 316	 0.000895022	 0.0359994	 0.0	 464.18	 464.18	 464.18	 1.0	 0.0	 1	 -30.0	 30.0;
	314	 317	 0.000445532	 0.0275654	 0.0	 458.14	 458.14	 458.14	 1.0	 0.0	 1	 -30.0	 30.0;
	314	 318	 0.000625542	 0.0256149	 0.0	 455.99	 455.99	 455.99	 1.0	 0.0	 1	 -30.0	 30.0;
	314	 319	 0.000342057	 0.0201242	 0.0	 454.62	 454.62	 454.62	 1.0	 0.0	 1	 -30.0	 30.0;
	314	 320	 0.000536642	 0.0307448	 0.0	 448.95	 448.95	 448.95	 1.0	 0.0	 1	 -30.0	 30.0;
	314	 321	 0.000523068	 0.0259737	 0.0	 448.8	 448.8	 448.8	 1.0	 0.0	 1	 -30.0	 30.0;
	315	 314	 0.00074037	 0.0388174	 0.0	 542.1	 542.1	 542.1	 1.01875	 0.0	 1	 -30.0	 30.0;
	315	 314	 0.00074037	 0.0388174	 0.0	 542.1	 542.1	 542.1	 1.01875	 0.0	 1	 -30.0	 30.0;
	315	 314	 0.00074037	 0.0388174	 0.0	 542.1	 542.1	 542.1	 1.01875	 0.0	 1	 -30.0	 30.0;
	322	 324	 0.000631398	 0.0400234	 0.0	 298.76	 298.76	 298.76	 1.0	 0.0	 1	 -30.0	 30.0;
	322	 325	 0.000759541	 0.0412573	 0.0	 297.35	 297.35	 297.35	 1.0	 0.0	 1	 -30.0	 30.0;
	322	 326	 0.000829004	 0.0525703	 0.0	 295.53	 295.53	 295.53	 1.0	 0.0	 1	 -30.0	 30.0;
	322	 327	 0.000777304	 0.0484577	 0.0	 277.01	 277.01	 277.01	 1.0	 0.0	 1	 -30.0	 30.0;
	322	 328	 0.00056804	 0.03834	 0.0	 275.26	 275.26	 275.26	 1.0	 0.0	 1	 -30.0	 30.0;
	322	 329	 0.000614253	 0.0425834	 0.0	 265.86	 265.86	 265.86	 1.0	 0.0	 1	 -30.0	 30.0;
	323	 322	 0.000841043	 0.0390368	 0.0	 346.56	 346.56	 346.56	 1.025	 0.0	 1	 -30.0	 30.0;
	332	 334	 0.00167281	 0.0957987	 0.0	 170.24	 170.24	 170.24	 1.0	 0.0	 1	 -30.0	 30.0;
	332	 335	 0.00134301	 0.0787655	 0.0	 154.25	 154.25	 154.25	 1.0	 0.0	 1	 -30.0	 30.0;
	333	 332	 0.000483225	 0.0284723	 0.0	 547.14	 547.14	 547.14	 1.0	 0.0	 1	 -30.0	 30.0;
	333	 332	 0.000483225	 0.0284723	 0.0	 547.14	 547.14	 547.14	 1.0	 0.0	 1	 -30.0	 30.0;
	333	 332	 0.000483225	 0.0284723	 0.0	 547.14	 547.14	 547.14	 1.0	 0.0	 1	 -30.0	 30.0;
	336	 338	 0.0006169	 0.0300775	 0.0	 406.98	 406.98	 406.98	 1.0	 0.0	 1	 -30.0	 30.0;
	336	 339	 0.000375045	 0.0281773	 0.0	 403.31	 403.31	 403.31	 1.0	 0.0	 1	 -30.0	 30.0;
	336	 340	 0.000425368	 0.0313458	 0.0	 402.98	 402.98	 402.98	 1.0	 0.0	 1	 -30.0	 30.0;
	336	 341	 0.000585813	 0.0398156	 0.0	 398.26	 398.26	 398.26	 1.0	 0.0	 1	 -30.0	 30.0;
	337	 336	 0.00045459	 0.0246348	 0.0	 318.58	 318.58	 318.58	 1.0125	 0.0	 1	 -30.0	 30.0;
	342	 343	 0.00256944	 0.0579654	 0.0	 233.13	 233.13	 233.13	 1.0	 0.0	 1	 -30.0	 30.0;
	342	 344	 0.00212206	 0.0674639	 0.0	 233.13	 233.13	 233.13	 1.0	 0.0	 1	 -30.0	 30.0;
	342	 345	 0.00208414	 0.0517834	 0.0	 233.13	 233.13	 233.13	 1.0	 0.0	 1	 -30.0	 30.0;
	348	 347	 0.000367495	 0.0216598	 0.0	 367.28	 367.28	 367.28	 1.0375	 0.0	 1	 -30.0	 30.0;
	351	 350	 0.000655327	 0.0282606	 0.0	 497.16	 497.16	 497.16	 1.0	 0.0	 1	 -30.0	 30.0;
	351	 350	 0.000655327	 0.0282606	 0.0	 497.16	 497.16	 497.16	 1.0	 0.0	 1	 -30.0	 30.0;
	351	 350	 0.000655327	 0.0282606	 0.0	 497.16	 497.16	 497.16	 1.0	 0.0	 1	 -30.0	 30.0;
	353	 354	 0.0037841	 0.092798	 0.0	 143.0	 143.0	 143.0	 1.0	 0.0	 1	 -30.0	 30.0;
	360	 362	 0.000156351	 0.0072342	 0.0	 917.15	 917.15	 917.15	 1.0	 0.0	 1	 -30.0	 30.0;
	360	 363	 0.000259699	 0.0141725	 0.0	 917.15	 917.15	 917.15	 1.0	 0.0	 1	 -30.0	 30.0;
	360	 364	 0.000272146	 0.0198633	 0.0	 917.15	 917.15	 917.15	 1.0	 0.0	 1	 -30.0	 30.0;
	360	 365	 0.000447041	 0.0178606	 0.0	 917.15	 917.15	 917.15	 1.0	 0.0	 1	 -30.0	 30.0;
	361	 360	 0.000300251	 0.0204296	 0.0	 587.59	 587.59	 587.59	 1.0	 0.0	 1	 -30.0	 30.0;
	361	 360	 0.000300251	 0.0204296	 0.0	 587.59	 587.59	 587.59	 1.0	 0.0	 1	 -30.0	 30.0;
	361	 360	 0.000300251	 0.0204296	 0.0	 587.59	 587.59	 587.59	 1.0	 0.0	 1	 -30.0	 30.0;
	366	 367	 0.00973151	 0.278789	 0.0	 26.65	 26.65	 26.65	 1.0	 0.0	 1	 -30.0	 30.0;
	366	 368	 0.0062091	 0.220695	 0.0	 53.3	 53.3	 53.3	 1.0	 0.0	 1	 -30.0	 30.0;
	366	 369	 0.0199066	 0.670544	 0.0	 26.65	 26.65	 26.65	 1.0625	 0.0	 1	 -30.0	 30.0;
	370	 371	 0.00121619	 0.0353293	 0.0	 369.46	 369.46	 369.46	 1.0	 0.0	 1	 -30.0	 30.0;
	370	 372	 0.00136545	 0.0376173	 0.0	 369.46	 369.46	 369.46	 1.0	 0.0	 1	 -30.0	 30.0;
	374	 375	 0.00778775	 0.261743	 0.0	 38.67	 38.67	 38.67	 1.0	 0.0	 1	 -30.0	 30.0;
	377	 378	 0.000973146	 0.0271225	 0.0	 301.31	 301.31	 301.31	 1.0375	 0.0	 1	 -30.0	 30.0;
	377	 379	 0.0023813	 0.0522033	 0.0	 301.31	 301.31	 301.31	 1.0375	 0.0	 1	 -30.0	 30.0;
	377	 380	 0.00140456	 0.0427291	 0.0	 301.31	 301.31	 301.31	 1.0375	 0.0	 1	 -30.0	 30.0;
	377	 381	 0.0012163	 0.0355031	 0.0	 301.31	 301.31	 301.31	 1.0375	 0.0	 1	 -30.0	 30.0;
	387	 386	 0.00033322	 0.022031	 0.0	 389.55	 389.55	 389.55	 1.0125	 0.0	 1	 -30.0	 30.0;
	389	 391	 0.00028731	 0.0204018	 0.0	 318.16	 318.16	 318.16	 1.075	 0.0	 1	 -30.0	 30.0;
	389	 392	 0.000625859	 0.0329065	 0.0	 314.04	 314.04	 314.04	 1.08125	 0.0	 1	 -30.0	 30.0;
	389	 393	 0.000638056	 0.0360591	 0.0	 313.73	 313.73	 313.73	 1.0875	 0.0	 1	 -30.0	 30.0;
	389	 394	 0.000617364	 0.0389483	 0.0	 309.38	 309.38	 309.38	 1.0875	 0.0	 1	 -30.0	 30.0;
	390	 389	 0.000382867	 0.0282289	 0.0	 311.38	 311.38	 311.38	 1.0	 0.0	 1	 -30.0	 30.0;
	396	 395	 0.000250247	 0.0162734	 0.0	 338.87	 338.87	 338.87	 1.03125	 0.0	 1	 -30.0	 30.0;
	400	 401	 0.00320427	 0.0964919	 0.0	 81.63	 81.63	 81.63	 1.0	 0.0	 1	 -30.0	 30.0;
	400	 402	 0.00430186	 0.140434	 0.0	 79.62	 79.62	 79.62	 1.0	 0.0	 1	 -30.0	 30.0;
	405	 407	 0.00041892	 0.0308071	 0.0	 265.3	 265.3	 265.3	 1.0	 0.0	 1	 -30.0	 30.0;
	405	 408	 0.00083897	 0.0423468	 0.0	 262.28	 262.28	 262.28	 1.0	 0.0	 1	 -30.0	 30.0;
	405	 409	 0.000971538	 0.0535648	 0.0	 256.22	 256.22	 256.22	 1.0	 0.0	 1	 -30.0	 30.0;
	405	 410	 0.000860625	 0.0516558	 0.0	 250.09	 250.09	 250.09	 1.0	 0.0	 1	 -30.0	 30.0;
	405	 411	 0.000997296	 0.0638117	 0.0	 224.22	 224.22	 224.22	 1.0	 0.0	 1	 -30.0	 30.0;
	405	 412	 0.000796356	 0.0544798	 0.0	 215.78	 215.78	 215.78	 1.0	 0.0	 1	 -30.0	 30.0;
	406	 405	 0.000607729	 0.0348525	 0.0	 459.57	 459.57	 459.57	 1.0	 0.0	 1	 -30.0	 30.0;
	406	 405	 0.000607729	 0.0348525	 0.0	 459.57	 459.57	 459.57	 1.0	 0.0	 1	 -30.0	 30.0;
	406	 405	 0.000607729	 0.0348525	 0.0	 459.57	 459.57	 459.57	 1.0	 0.0	 1	 -30.0	 30.0;
	414	 416	 0.000328892	 0.0205281	 0.0	 489.82	 489.82	 489.82	 1.04375	 0.0	 1	 -30.0	 30.0;
	414	 417	 0.000187472	 0.0121387	 0.0	 489.77	 489.77	 489.77	 1.0	 0.0	 1	 -30.0	 30.0;
	414	 418	 0.000388416	 0.022286	 0.0	 485.07	 485.07	 485.07	 1.0	 0.0	 1	 -30.0	 30.0;
	414	 419	 0.000397994	 0.0246792	 0.0	 479.76	 479.76	 479.76	 1.04375	 0.0	 1	 -30.0	 30.0;
	414	 420	 0.000599327	 0.0284749	 0.0	 478.01	 478.01	 478.01	 1.04375	 0.0	 1	 -30.0	 30.0;
	415	 414	 0.000451633	 0.0315432	 0.0	 342.66	 342.66	 342.66	 1.01875	 0.0	 1	 -30.0	 30.0;
	422	 424	 0.000374656	 0.0288049	 0.0	 425.79	 425.79	 425.79	 0.9875	 0.0	 1	 -30.0	 30.0;
	422	 425	 0.000397079	 0.0297391	 0.0	 420.15	 420.15	 420.15	 0.9875	 0.0	 1	 -30.0	 30.0;
	422	 426	 0.000457733	 0.0303601	 0.0	 410.73	 410.73	 410.73	 1.0	 0.0	 1	 -30.0	 30.0;
	422	 427	 0.000372813	 0.0254212	 0.0	 408.41	 408.41	 408.41	 0.9875	 0.0	 1	 -30.0	 30.0;
	422	 428	 0.000705582	 0.034346	 0.0	 408.19	 408.19	 408.19	 0.9875	 0.0	 1	 -30.0	 30.0;
	423	 422	 0.000384533	 0.0274698	 0.0	 353.49	 353.49	 353.49	 1.0	 0.0	 1	 -30.0	 30.0;
	429	 431	 0.000636114	 0.0356112	 0.0	 387.12	 387.12	 387.12	 1.05625	 0.0	 1	 -30.0	 30.0;
	429	 432	 0.00061928	 0.0294575	 0.0	 387.07	 387.07	 387.07	 1.05625	 0.0	 1	 -30.0	 30.0;
	429	 433	 0.000360841	 0.021624	 0.0	 384.73	 384.73	 384.73	 1.05	 0.0	 1	 -30.0	 30.0;
	429	 434	 0.000390259	 0.0263657	 0.0	 380.48	 380.48	 380.48	 1.05625	 0.0	 1	 -30.0	 30.0;
	430	 429	 0.000517158	 0.0260834	 0.0	 562.02	 562.02	 562.02	 1.0	 0.0	 1	 -30.0	 30.0;
	430	 429	 0.000517158	 0.0260834	 0.0	 562.02	 562.02	 562.02	 1.0	 0.0	 1	 -30.0	 30.0;
	430	 429	 0.000517158	 0.0260834	 0.0	 562.02	 562.02	 562.02	 1.0	 0.0	 1	 -30.0	 30.0;
	435	 437	 0.000403932	 0.0317548	 0.0	 397.18	 397.18	 397.18	 1.08125	 0.0	 1	 -30.0	 30.0;
	435	 438	 0.000370298	 0.0271126	 0.0	 396.44	 396.44	 396.44	 1.08125	 0.0	 1	 -30.0	 30.0;
	435	 439	 0.000611676	 0.0328839	 0.0	 394.96	 394.96	 394.96	 1.0875	 0.0	 1	 -30.0	 30.0;
	435	 440	 0.000451306	 0.0331002	 0.0	 389.79	 389.79	 389.79	 1.0875	 0.0	 1	 -30.0	 30.0;
	436	 435	 0.000398002	 0.0225429	 0.0	 572.43	 572.43	 572.43	 1.0	 0.0	 1	 -30.0	 30.0;
	436	 435	 0.000398002	 0.0225429	 0.0	 572.43	 572.43	 572.43	 1.0	 0.0	 1	 -30.0	 30.0;
	436	 435	 0.000398002	 0.0225429	 0.0	 572.43	 572.43	 572.43	 1.0	 0.0	 1	 -30.0	 30.0;
	442	 443	 0.0867196	 2.26916	 0.0	 7.8	 7.8	 7.8	 1.0	 0.0	 1	 -30.0	 30.0;
	442	 444	 0.0591784	 2.10181	 0.0	 7.8	 7.8	 7.8	 1.01875	 0.0	 1	 -30.0	 30.0;
	446	 448	 0.000566023	 0.0321282	 0.0	 448.62	 448.62	 448.62	 1.0	 0.0	 1	 -30.0	 30.0;
	446	 449	 0.000634471	 0.0322695	 0.0	 445.75	 445.75	 445.75	 1.0	 0.0	 1	 -30.0	 30.0;
	446	 450	 0.000601573	 0.0324325	 0.0	 440.53	 440.53	 440.53	 1.075	 0.0	 1	 -30.0	 30.0;
	446	 451	 0.000550115	 0.0295676	 0.0	 440.38	 440.38	 440.38	 1.06875	 0.0	 1	 -30.0	 30.0;
	446	 452	 0.000410283	 0.0268188	 0.0	 439.43	 439.43	 439.43	 1.06875	 0.0	 1	 -30.0	 30.0;
	447	 446	 0.000473004	 0.0270653	 0.0	 367.94	 367.94	 367.94	 1.025	 0.0	 1	 -30.0	 30.0;
	454	 456	 0.000848903	 0.0505189	 0.0	 361.49	 361.49	 361.49	 1.08125	 0.0	 1	 -30.0	 30.0;
	454	 457	 0.000467442	 0.0257805	 0.0	 361.03	 361.03	 361.03	 1.0625	 0.0	 1	 -30.0	 30.0;
	454	 458	 0.000912461	 0.0433306	 0.0	 360.57	 360.57	 360.57	 1.075	 0.0	 1	 -30.0	 30.0;
	454	 459	 0.000531627	 0.0324517	 0.0	 339.59	 339.59	 339.59	 1.06875	 0.0	 1	 -30.0	 30.0;
	455	 454	 0.000367379	 0.021975	 0.0	 582.29	 582.29	 582.29	 1.0125	 0.0	 1	 -30.0	 30.0;
	455	 454	 0.000367379	 0.021975	 0.0	 582.29	 582.29	 582.29	 1.0125	 0.0	 1	 -30.0	 30.0;
	455	 454	 0.000367379	 0.021975	 0.0	 582.29	 582.29	 582.29	 1.0125	 0.0	 1	 -30.0	 30.0;
	460	 462	 0.000447913	 0.0301375	 0.0	 434.07	 434.07	 434.07	 1.04375	 0.0	 1	 -30.0	 30.0;
	460	 463	 0.000412705	 0.0269158	 0.0	 429.97	 429.97	 429.97	 1.04375	 0.0	 1	 -30.0	 30.0;
	460	 464	 0.000525174	 0.0298652	 0.0	 426.71	 426.71	 426.71	 1.04375	 0.0	 1	 -30.0	 30.0;
	461	 460	 0.000576084	 0.0326432	 0.0	 473.41	 473.41	 473.41	 1.00625	 0.0	 1	 -30.0	 30.0;
	465	 466	 0.00519083	 0.160302	 0.0	 67.87	 67.87	 67.87	 1.0	 0.0	 1	 -30.0	 30.0;
	468	 470	 0.000274786	 0.0187972	 0.0	 731.25	 731.25	 731.25	 1.0	 0.0	 1	 -30.0	 30.0;
	468	 471	 0.000254801	 0.0158162	 0.0	 731.25	 731.25	 731.25	 1.0	 0.0	 1	 -30.0	 30.0;
	469	 468	 0.000424583	 0.0249647	 0.0	 380.87	 380.87	 380.87	 1.025	 0.0	 1	 -30.0	 30.0;
	474	 475	 0.00358362	 0.119106	 0.0	 75.92	 75.92	 75.92	 1.0	 0.0	 1	 -30.0	 30.0;
	474	 476	 0.00993187	 0.305499	 0.0	 45.12	 45.12	 45.12	 1.0	 0.0	 1	 -30.0	 30.0;
	479	 481	 0.000374809	 0.023707	 0.0	 523.33	 523.33	 523.33	 1.0	 0.0	 1	 -30.0	 30.0;
	479	 482	 0.000462701	 0.0279948	 0.0	 523.33	 523.33	 523.33	 1.0	 0.0	 1	 -30.0	 30.0;
	479	 483	 0.000374996	 0.0214192	 0.0	 523.33	 523.33	 523.33	 1.0	 0.0	 1	 -30.0	 30.0;
	479	 484	 0.000462963	 0.0284119	 0.0	 523.33	 523.33	 523.33	 1.0	 0.0	 1	 -30.0	 30.0;
	479	 485	 0.000279259	 0.0206554	 0.0	 523.33	 523.33	 523.33	 1.0	 0.0	 1	 -30.0	 30.0;
	480	 479	 0.00047645	 0.0299622	 0.0	 565.77	 565.77	 565.77	 1.05625	 0.0	 1	 -30.0	 30.0;
	480	 479	 0.00047645	 0.0299622	 0.0	 565.77	 565.77	 565.77	 1.05625	 0.0	 1	 -30.0	 30.0;
	480	 479	 0.00047645	 0.0299622	 0.0	 565.77	 565.77	 565.77	 1.05625	 0.0	 1	 -30.0	 30.0;
	492	 493	 0.0022567	 0.058447	 0.0	 182.0	 182.0	 182.0	 1.0	 0.0	 1	 -30.0	 30.0;
	492	 494	 0.00107207	 0.0353021	 0.0	 182.0	 182.0	 182.0	 1.0	 0.0	 1	 -30.0	 30.0;
	497	 496	 0.000512239	 0.0372062	 0.0	 335.52	 335.52	 335.52	 1.05	 0.0	 1	 -30.0	 30.0;
];

% INFO    : === Translation Options ===
% INFO    : Phase Angle Bound:           30.0 (deg.)
% INFO    : Setting Flat Start
% INFO    :
% INFO    : === Generator Bounds Update Notes ===
% INFO    :
% INFO    : === Base KV Replacement Notes ===
% INFO    :
% INFO    : === Transformer Setting Replacement Notes ===
% INFO    :
% INFO    : === Line Capacity Monotonicity Notes ===
% INFO    :
% INFO    : === Voltage Setpoint Replacement Notes ===
% INFO    : Bus 1	: V=0.98540926462, theta=-8.36784152229 -> V=1.0, theta=0.0
% INFO    : Bus 2	: V=0.974020345007, theta=-11.1447179681 -> V=1.0, theta=0.0
% INFO    : Bus 3	: V=0.987750778993, theta=-11.2735589113 -> V=1.0, theta=0.0
% INFO    : Bus 4	: V=0.989014259342, theta=-9.79384434157 -> V=1.0, theta=0.0
% INFO    : Bus 5	: V=0.993873361964, theta=-9.09121117922 -> V=1.0, theta=0.0
% INFO    : Bus 6	: V=0.990622016789, theta=-9.34438554561 -> V=1.0, theta=0.0
% INFO    : Bus 7	: V=1.01177459986, theta=-2.2571228597 -> V=1.0, theta=0.0
% INFO    : Bus 8	: V=1.01163236257, theta=-1.49070961583 -> V=1.0, theta=0.0
% INFO    : Bus 9	: V=0.997133425513, theta=-13.5376673402 -> V=1.0, theta=0.0
% INFO    : Bus 10	: V=0.998363744607, theta=-4.73672348603 -> V=1.0, theta=0.0
% INFO    : Bus 11	: V=0.995333134762, theta=-7.04711107809 -> V=1.0, theta=0.0
% INFO    : Bus 12	: V=1.00015639626, theta=-4.37232554148 -> V=1.0, theta=0.0
% INFO    : Bus 13	: V=0.988989416822, theta=-10.1997915056 -> V=1.0, theta=0.0
% INFO    : Bus 14	: V=0.992699902775, theta=-10.9670327075 -> V=1.0, theta=0.0
% INFO    : Bus 15	: V=1.00050248524, theta=-10.02822207 -> V=1.0, theta=0.0
% INFO    : Bus 16	: V=1.00117751002, theta=-4.64261486904 -> V=1.0, theta=0.0
% INFO    : Bus 17	: V=0.977507107607, theta=-12.4237140556 -> V=1.0, theta=0.0
% INFO    : Bus 18	: V=1.00751894852, theta=-3.57094453833 -> V=1.0, theta=0.0
% INFO    : Bus 19	: V=1.00350940037, theta=-5.67688502224 -> V=1.0, theta=0.0
% INFO    : Bus 20	: V=1.00517481518, theta=-3.37490193889 -> V=1.0, theta=0.0
% INFO    : Bus 21	: V=1.01100686523, theta=-4.89731309209 -> V=1.0, theta=0.0
% INFO    : Bus 22	: V=1.00561294281, theta=-3.31959892765 -> V=1.0, theta=0.0
% INFO    : Bus 23	: V=1.00654165993, theta=-5.53577687668 -> V=1.0, theta=0.0
% INFO    : Bus 24	: V=0.985502465791, theta=-9.81072695959 -> V=1.0, theta=0.0
% INFO    : Bus 25	: V=0.985544310419, theta=-0.603530366385 -> V=1.0, theta=0.0
% INFO    : Bus 26	: V=1.00839100157, theta=-2.76652278414 -> V=1.0, theta=0.0
% INFO    : Bus 27	: V=0.984868133535, theta=-0.671252150622 -> V=1.0, theta=0.0
% INFO    : Bus 28	: V=0.996762712989, theta=-3.19343707524 -> V=1.0, theta=0.0
% INFO    : Bus 29	: V=0.997376437423, theta=-3.77735107706 -> V=1.0, theta=0.0
% INFO    : Bus 30	: V=0.999687680418, theta=-3.400648295 -> V=1.0, theta=0.0
% INFO    : Bus 31	: V=1.00199150613, theta=-7.00037785673 -> V=1.0, theta=0.0
% INFO    : Bus 32	: V=0.972359515567, theta=-10.4781598773 -> V=1.0, theta=0.0
% INFO    : Bus 33	: V=0.970146252481, theta=-8.8483559075 -> V=1.0, theta=0.0
% INFO    : Bus 34	: V=0.984464621789, theta=-7.07908563991 -> V=1.0, theta=0.0
% INFO    : Bus 35	: V=0.995009841489, theta=-11.1229658659 -> V=1.0, theta=0.0
% INFO    : Bus 36	: V=0.973170033287, theta=-11.5796122759 -> V=1.0, theta=0.0
% INFO    : Bus 37	: V=0.985015555674, theta=-12.5992564382 -> V=1.0, theta=0.0
% INFO    : Bus 38	: V=0.984655563447, theta=-10.9707943448 -> V=1.0, theta=0.0
% INFO    : Bus 39	: V=0.990330037326, theta=-9.73780092974 -> V=1.0, theta=0.0
% INFO    : Bus 40	: V=0.998178023777, theta=-11.9588247944 -> V=1.0, theta=0.0
% INFO    : Bus 41	: V=0.963849537885, theta=-6.49876165365 -> V=1.0, theta=0.0
% INFO    : Bus 42	: V=1.02130259003, theta=-10.1510654266 -> V=1.0, theta=0.0
% INFO    : Bus 43	: V=0.96848010131, theta=-6.2145567608 -> V=1.0, theta=0.0
% INFO    : Bus 44	: V=1.00711488862, theta=-11.5024832415 -> V=1.0, theta=0.0
% INFO    : Bus 45	: V=0.985068202429, theta=-11.8651360204 -> V=1.0, theta=0.0
% INFO    : Bus 46	: V=1.00070602517, theta=-11.547923809 -> V=1.0, theta=0.0
% INFO    : Bus 47	: V=0.989140344226, theta=-12.9585654649 -> V=1.0, theta=0.0
% INFO    : Bus 48	: V=1.00236592039, theta=-10.5146300962 -> V=1.0, theta=0.0
% INFO    : Bus 49	: V=0.988164035391, theta=-12.6731851621 -> V=1.0, theta=0.0
% INFO    : Bus 50	: V=0.996066801688, theta=-11.4413363406 -> V=1.0, theta=0.0
% INFO    : Bus 51	: V=1.0052604152, theta=-10.0949517554 -> V=1.0, theta=0.0
% INFO    : Bus 52	: V=0.986461485086, theta=-5.21775600073 -> V=1.0, theta=0.0
% INFO    : Bus 53	: V=0.983988934204, theta=-9.67026510695 -> V=1.0, theta=0.0
% INFO    : Bus 54	: V=0.988664592081, theta=-4.7393740651 -> V=1.0, theta=0.0
% INFO    : Bus 55	: V=0.997176233555, theta=-13.2429127167 -> V=1.0, theta=0.0
% INFO    : Bus 56	: V=0.977923913934, theta=-12.1390226895 -> V=1.0, theta=0.0
% INFO    : Bus 57	: V=1.00291125848, theta=-8.74663554669 -> V=1.0, theta=0.0
% INFO    : Bus 58	: V=0.995131101776, theta=-9.14203373484 -> V=1.0, theta=0.0
% INFO    : Bus 59	: V=1.01832041078, theta=-9.56174321442 -> V=1.0, theta=0.0
% INFO    : Bus 60	: V=1.0035433985, theta=-11.5333355588 -> V=1.0, theta=0.0
% INFO    : Bus 61	: V=0.999793050062, theta=-4.64732258362 -> V=1.0, theta=0.0
% INFO    : Bus 62	: V=0.99296354608, theta=-13.2912772355 -> V=1.0, theta=0.0
% INFO    : Bus 63	: V=1.00706435989, theta=-4.42804563731 -> V=1.0, theta=0.0
% INFO    : Bus 64	: V=0.999211030761, theta=-5.83265211897 -> V=1.0, theta=0.0
% INFO    : Bus 65	: V=0.986210868178, theta=-9.40034090894 -> V=1.0, theta=0.0
% INFO    : Bus 66	: V=1.00509895453, theta=-8.53988874346 -> V=1.0, theta=0.0
% INFO    : Bus 67	: V=0.996596610806, theta=-7.53879539671 -> V=1.0, theta=0.0
% INFO    : Bus 68	: V=1.01251149462, theta=4.37586063419 -> V=1.0, theta=0.0
% INFO    : Bus 69	: V=0.988526867612, theta=-7.44618365644 -> V=1.0, theta=0.0
% INFO    : Bus 70	: V=1.01829120454, theta=-7.71422736055 -> V=1.0, theta=0.0
% INFO    : Bus 71	: V=0.985058548111, theta=-9.08857193658 -> V=1.0, theta=0.0
% INFO    : Bus 72	: V=0.997883025416, theta=-13.6900381042 -> V=1.0, theta=0.0
% INFO    : Bus 73	: V=0.98996947503, theta=-12.7259865143 -> V=1.0, theta=0.0
% INFO    : Bus 74	: V=0.997056743099, theta=-10.0178073629 -> V=1.0, theta=0.0
% INFO    : Bus 75	: V=1.0069300648, theta=-2.25500247491 -> V=1.0, theta=0.0
% INFO    : Bus 76	: V=1.00682787028, theta=-5.3341252355 -> V=1.0, theta=0.0
% INFO    : Bus 77	: V=0.998300977553, theta=-10.6326300193 -> V=1.0, theta=0.0
% INFO    : Bus 78	: V=1.00146425359, theta=-9.89621910397 -> V=1.0, theta=0.0
% INFO    : Bus 79	: V=1.00428138244, theta=-9.77856836381 -> V=1.0, theta=0.0
% INFO    : Bus 80	: V=1.00045450249, theta=-4.30772231267 -> V=1.0, theta=0.0
% INFO    : Bus 81	: V=1.01043186298, theta=-4.8299524072 -> V=1.0, theta=0.0
% INFO    : Bus 82	: V=0.988255373244, theta=-8.06801623341 -> V=1.0, theta=0.0
% INFO    : Bus 83	: V=1.0083440785, theta=-5.45765217536 -> V=1.0, theta=0.0
% INFO    : Bus 84	: V=1.00494193924, theta=-6.63429369162 -> V=1.0, theta=0.0
% INFO    : Bus 85	: V=0.974556638465, theta=-12.6179209235 -> V=1.0, theta=0.0
% INFO    : Bus 86	: V=0.998519076966, theta=-6.12545835579 -> V=1.0, theta=0.0
% INFO    : Bus 87	: V=0.999667758796, theta=-4.84260570747 -> V=1.0, theta=0.0
% INFO    : Bus 88	: V=0.999433357814, theta=-8.06544570878 -> V=1.0, theta=0.0
% INFO    : Bus 89	: V=0.994369755609, theta=-6.19355283658 -> V=1.0, theta=0.0
% INFO    : Bus 90	: V=1.01028935037, theta=-1.55202428495 -> V=1.0, theta=0.0
% INFO    : Bus 91	: V=1.00458928079, theta=-4.17482511621 -> V=1.0, theta=0.0
% INFO    : Bus 92	: V=1.00980617448, theta=-1.6157511302 -> V=1.0, theta=0.0
% INFO    : Bus 93	: V=0.997456484407, theta=-11.6646037945 -> V=1.0, theta=0.0
% INFO    : Bus 94	: V=0.992554424976, theta=-10.5333407253 -> V=1.0, theta=0.0
% INFO    : Bus 95	: V=0.982698994181, theta=-8.31359345193 -> V=1.0, theta=0.0
% INFO    : Bus 96	: V=1.01018405019, theta=-9.07680503228 -> V=1.0, theta=0.0
% INFO    : Bus 97	: V=1.00797928867, theta=-1.8063612885 -> V=1.0, theta=0.0
% INFO    : Bus 98	: V=1.01800187586, theta=-4.76890715438 -> V=1.0, theta=0.0
% INFO    : Bus 99	: V=1.00731171385, theta=-1.85845033165 -> V=1.0, theta=0.0
% INFO    : Bus 100	: V=0.987209479171, theta=-8.25244921008 -> V=1.0, theta=0.0
% INFO    : Bus 101	: V=0.992412825072, theta=-7.90863724307 -> V=1.0, theta=0.0
% INFO    : Bus 102	: V=0.992228710791, theta=-6.88289644788 -> V=1.0, theta=0.0
% INFO    : Bus 103	: V=0.998910623869, theta=-5.75223008679 -> V=1.0, theta=0.0
% INFO    : Bus 104	: V=0.99868166719, theta=-13.1019029475 -> V=1.0, theta=0.0
% INFO    : Bus 105	: V=0.98832146155, theta=-8.22833994998 -> V=1.0, theta=0.0
% INFO    : Bus 106	: V=0.994604501263, theta=-5.79695904081 -> V=1.0, theta=0.0
% INFO    : Bus 107	: V=1.01415209433, theta=-8.79460374176 -> V=1.0, theta=0.0
% INFO    : Bus 108	: V=0.997018995005, theta=-5.52761553691 -> V=1.0, theta=0.0
% INFO    : Bus 109	: V=1.0020873875, theta=-11.1186305791 -> V=1.0, theta=0.0
% INFO    : Bus 110	: V=1.00149177458, theta=-5.19487050527 -> V=1.0, theta=0.0
% INFO    : Bus 111	: V=0.985961978971, theta=-7.1279273608 -> V=1.0, theta=0.0
% INFO    : Bus 112	: V=0.991969276111, theta=-5.20285049519 -> V=1.0, theta=0.0
% INFO    : Bus 113	: V=1.00389937299, theta=-4.54858027366 -> V=1.0, theta=0.0
% INFO    : Bus 114	: V=0.992680378859, theta=-6.13651865424 -> V=1.0, theta=0.0
% INFO    : Bus 115	: V=0.993354079483, theta=-11.9632618983 -> V=1.0, theta=0.0
% INFO    : Bus 116	: V=1.00491649351, theta=-14.2765731337 -> V=1.0, theta=0.0
% INFO    : Bus 117	: V=0.999941604896, theta=-3.35878284437 -> V=1.0, theta=0.0
% INFO    : Bus 118	: V=0.985989667679, theta=-8.85570226427 -> V=1.0, theta=0.0
% INFO    : Bus 119	: V=0.999080331783, theta=-1.22185043204 -> V=1.0, theta=0.0
% INFO    : Bus 120	: V=1.01958196835, theta=-4.80860601738 -> V=1.0, theta=0.0
% INFO    : Bus 121	: V=1.00041126039, theta=-1.1012342862 -> V=1.0, theta=0.0
% INFO    : Bus 122	: V=0.999955217548, theta=-7.38002192826 -> V=1.0, theta=0.0
% INFO    : Bus 123	: V=0.994717940895, theta=-8.56796724782 -> V=1.0, theta=0.0
% INFO    : Bus 124	: V=0.999322812855, theta=-7.52030664566 -> V=1.0, theta=0.0
% INFO    : Bus 125	: V=0.988996963306, theta=-9.07187053449 -> V=1.0, theta=0.0
% INFO    : Bus 126	: V=0.998357478668, theta=-9.54825905882 -> V=1.0, theta=0.0
% INFO    : Bus 127	: V=1.00254412886, theta=-13.218709698 -> V=1.0, theta=0.0
% INFO    : Bus 128	: V=0.988320148445, theta=-8.38755350492 -> V=1.0, theta=0.0
% INFO    : Bus 129	: V=0.985811992172, theta=-7.98088571387 -> V=1.0, theta=0.0
% INFO    : Bus 130	: V=0.992213245475, theta=-5.63269487523 -> V=1.0, theta=0.0
% INFO    : Bus 131	: V=0.998058284906, theta=-13.8101947959 -> V=1.0, theta=0.0
% INFO    : Bus 132	: V=1.00466153235, theta=-10.7427720626 -> V=1.0, theta=0.0
% INFO    : Bus 133	: V=1.00110912458, theta=-8.9701965119 -> V=1.0, theta=0.0
% INFO    : Bus 134	: V=1.00735684261, theta=-6.1113926974 -> V=1.0, theta=0.0
% INFO    : Bus 135	: V=0.986845720006, theta=-2.4108224144 -> V=1.0, theta=0.0
% INFO    : Bus 136	: V=1.01872665334, theta=-4.36003203471 -> V=1.0, theta=0.0
% INFO    : Bus 137	: V=0.986608584719, theta=-2.44480165991 -> V=1.0, theta=0.0
% INFO    : Bus 138	: V=1.01374936602, theta=-14.5624553189 -> V=1.0, theta=0.0
% INFO    : Bus 139	: V=1.00320862484, theta=-6.88673989767 -> V=1.0, theta=0.0
% INFO    : Bus 140	: V=0.985950819621, theta=-8.27179383058 -> V=1.0, theta=0.0
% INFO    : Bus 141	: V=0.998370227007, theta=-7.03550527291 -> V=1.0, theta=0.0
% INFO    : Bus 142	: V=0.991793395211, theta=-3.82132127331 -> V=1.0, theta=0.0
% INFO    : Bus 143	: V=0.992795246343, theta=-5.90269096344 -> V=1.0, theta=0.0
% INFO    : Bus 144	: V=0.989266626101, theta=-9.96769841272 -> V=1.0, theta=0.0
% INFO    : Bus 145	: V=0.977092048246, theta=-11.5453529828 -> V=1.0, theta=0.0
% INFO    : Bus 146	: V=0.991865762967, theta=-9.42342352038 -> V=1.0, theta=0.0
% INFO    : Bus 147	: V=0.988928449969, theta=-11.1227531984 -> V=1.0, theta=0.0
% INFO    : Bus 148	: V=0.992128127357, theta=-8.87970606424 -> V=1.0, theta=0.0
% INFO    : Bus 149	: V=0.985941435544, theta=-9.73655158411 -> V=1.0, theta=0.0
% INFO    : Bus 150	: V=1.00835985611, theta=-7.35860351256 -> V=1.0, theta=0.0
% INFO    : Bus 151	: V=1.00846863036, theta=-3.18390721472 -> V=1.0, theta=0.0
% INFO    : Bus 152	: V=1.01957459581, theta=-6.06178230608 -> V=1.0, theta=0.0
% INFO    : Bus 153	: V=1.00776929895, theta=-3.26931100086 -> V=1.0, theta=0.0
% INFO    : Bus 154	: V=1.00290083697, theta=-7.60014805448 -> V=1.0, theta=0.0
% INFO    : Bus 155	: V=1.00333439191, theta=-7.87801620418 -> V=1.0, theta=0.0
% INFO    : Bus 156	: V=1.01548293496, theta=-12.5094036533 -> V=1.0, theta=0.0
% INFO    : Bus 157	: V=0.983957980376, theta=-11.3091463333 -> V=1.0, theta=0.0
% INFO    : Bus 158	: V=0.996433959784, theta=-11.0137285883 -> V=1.0, theta=0.0
% INFO    : Bus 159	: V=1.00713802635, theta=2.06700541897 -> V=1.0, theta=0.0
% INFO    : Bus 160	: V=1.0169419716, theta=-6.35673440657 -> V=1.0, theta=0.0
% INFO    : Bus 161	: V=0.977970912519, theta=-12.4147134951 -> V=1.0, theta=0.0
% INFO    : Bus 162	: V=0.993313176024, theta=-7.20063888211 -> V=1.0, theta=0.0
% INFO    : Bus 163	: V=0.990374366224, theta=-9.73902711566 -> V=1.0, theta=0.0
% INFO    : Bus 164	: V=0.999628957393, theta=-10.86216218 -> V=1.0, theta=0.0
% INFO    : Bus 165	: V=0.997574724851, theta=-7.37344471679 -> V=1.0, theta=0.0
% INFO    : Bus 166	: V=0.996960039048, theta=-7.32379663349 -> V=1.0, theta=0.0
% INFO    : Bus 167	: V=0.997814970451, theta=-6.26779558197 -> V=1.0, theta=0.0
% INFO    : Bus 168	: V=0.998678349882, theta=-9.82041702544 -> V=1.0, theta=0.0
% INFO    : Bus 169	: V=0.977969944699, theta=-8.87695074746 -> V=1.0, theta=0.0
% INFO    : Bus 170	: V=0.990878899735, theta=-10.3488166304 -> V=1.0, theta=0.0
% INFO    : Bus 171	: V=0.995044105205, theta=-10.0252229589 -> V=1.0, theta=0.0
% INFO    : Bus 172	: V=0.979060286071, theta=-14.3402168889 -> V=1.0, theta=0.0
% INFO    : Bus 173	: V=0.987955350122, theta=-15.2359701119 -> V=1.0, theta=0.0
% INFO    : Bus 174	: V=0.989387525829, theta=-10.3221754281 -> V=1.0, theta=0.0
% INFO    : Bus 175	: V=0.997892340548, theta=-9.79126199883 -> V=1.0, theta=0.0
% INFO    : Bus 176	: V=1.03380783564, theta=-15.4956909109 -> V=1.0, theta=0.0
% INFO    : Bus 177	: V=1.00011343327, theta=-15.5864437201 -> V=1.0, theta=0.0
% INFO    : Bus 178	: V=0.983141871731, theta=-13.9380368559 -> V=1.0, theta=0.0
% INFO    : Bus 179	: V=0.996306150968, theta=-6.69533491057 -> V=1.0, theta=0.0
% INFO    : Bus 180	: V=1.00059139923, theta=-6.63157176241 -> V=1.0, theta=0.0
% INFO    : Bus 181	: V=0.996841798612, theta=-8.06094464066 -> V=1.0, theta=0.0
% INFO    : Bus 182	: V=1.00005274713, theta=-1.82363574927 -> V=1.0, theta=0.0
% INFO    : Bus 183	: V=0.993303950294, theta=-6.28243379479 -> V=1.0, theta=0.0
% INFO    : Bus 184	: V=0.992786443543, theta=-6.36755859396 -> V=1.0, theta=0.0
% INFO    : Bus 185	: V=0.995092581786, theta=-3.13982240284 -> V=1.0, theta=0.0
% INFO    : Bus 186	: V=0.996083996122, theta=-7.68032860159 -> V=1.0, theta=0.0
% INFO    : Bus 187	: V=0.989447741181, theta=-5.95525447948 -> V=1.0, theta=0.0
% INFO    : Bus 188	: V=1.00145927952, theta=-5.51710946051 -> V=1.0, theta=0.0
% INFO    : Bus 189	: V=0.991216430814, theta=-6.84599630244 -> V=1.0, theta=0.0
% INFO    : Bus 190	: V=0.988708446374, theta=-2.88707777132 -> V=1.0, theta=0.0
% INFO    : Bus 191	: V=1.0118821263, theta=-4.96995512384 -> V=1.0, theta=0.0
% INFO    : Bus 192	: V=0.988080489026, theta=-2.96252978078 -> V=1.0, theta=0.0
% INFO    : Bus 193	: V=0.98864390344, theta=-7.08174950969 -> V=1.0, theta=0.0
% INFO    : Bus 194	: V=0.992761115879, theta=-11.4950144056 -> V=1.0, theta=0.0
% INFO    : Bus 195	: V=0.998763977167, theta=-8.38572728427 -> V=1.0, theta=0.0
% INFO    : Bus 196	: V=0.993300937772, theta=-6.17166383303 -> V=1.0, theta=0.0
% INFO    : Bus 197	: V=0.989548143298, theta=-10.5078793199 -> V=1.0, theta=0.0
% INFO    : Bus 198	: V=0.986789076266, theta=-8.76144005089 -> V=1.0, theta=0.0
% INFO    : Bus 199	: V=1.00203040412, theta=-11.2036280613 -> V=1.0, theta=0.0
% INFO    : Bus 200	: V=1.00001778469, theta=-12.3536491175 -> V=1.0, theta=0.0
% INFO    : Bus 201	: V=0.979967028212, theta=-13.2447120939 -> V=1.0, theta=0.0
% INFO    : Bus 202	: V=0.976727321247, theta=-13.2433288774 -> V=1.0, theta=0.0
% INFO    : Bus 203	: V=0.999736127094, theta=-2.40594777612 -> V=1.0, theta=0.0
% INFO    : Bus 204	: V=1.0035887067, theta=-0.83384154108 -> V=1.0, theta=0.0
% INFO    : Bus 205	: V=0.991128269366, theta=-6.9337005613 -> V=1.0, theta=0.0
% INFO    : Bus 206	: V=1.0054879917, theta=-12.2593920546 -> V=1.0, theta=0.0
% INFO    : Bus 207	: V=1.00145605632, theta=-8.07533594042 -> V=1.0, theta=0.0
% INFO    : Bus 208	: V=0.995614774348, theta=-8.56358000402 -> V=1.0, theta=0.0
% INFO    : Bus 209	: V=1.00229480458, theta=-8.55791850405 -> V=1.0, theta=0.0
% INFO    : Bus 210	: V=0.991302696389, theta=-7.40739843364 -> V=1.0, theta=0.0
% INFO    : Bus 211	: V=0.990219309554, theta=-9.89512452877 -> V=1.0, theta=0.0
% INFO    : Bus 212	: V=1.02133319558, theta=-4.91391546753 -> V=1.0, theta=0.0
% INFO    : Bus 213	: V=1.01058435613, theta=-12.9985295017 -> V=1.0, theta=0.0
% INFO    : Bus 214	: V=1.04427750223, theta=-13.3050520266 -> V=1.0, theta=0.0
% INFO    : Bus 215	: V=1.00547027092, theta=-8.66391119648 -> V=1.0, theta=0.0
% INFO    : Bus 216	: V=0.99942106346, theta=-9.88722648196 -> V=1.0, theta=0.0
% INFO    : Bus 217	: V=1.00052326646, theta=-1.59680732684 -> V=1.0, theta=0.0
% INFO    : Bus 218	: V=0.99988684259, theta=-3.83770957986 -> V=1.0, theta=0.0
% INFO    : Bus 219	: V=1.00558172489, theta=-5.22646171333 -> V=1.0, theta=0.0
% INFO    : Bus 220	: V=1.00456123643, theta=-0.00431345898937 -> V=1.0, theta=0.0
% INFO    : Bus 221	: V=0.999712798232, theta=-11.5034665489 -> V=1.0, theta=0.0
% INFO    : Bus 222	: V=1.00436263455, theta=-11.3428733231 -> V=1.0, theta=0.0
% INFO    : Bus 223	: V=0.997539247359, theta=-2.0420820649 -> V=1.0, theta=0.0
% INFO    : Bus 224	: V=1.00163378725, theta=0.289606551488 -> V=1.0, theta=0.0
% INFO    : Bus 225	: V=0.996239299553, theta=-7.58556414959 -> V=1.0, theta=0.0
% INFO    : Bus 226	: V=1.01271086895, theta=-13.9978069819 -> V=1.0, theta=0.0
% INFO    : Bus 227	: V=0.990659970841, theta=-3.739954338 -> V=1.0, theta=0.0
% INFO    : Bus 228	: V=0.994817641384, theta=-10.4554514104 -> V=1.0, theta=0.0
% INFO    : Bus 229	: V=1.01120934344, theta=-4.411572991 -> V=1.0, theta=0.0
% INFO    : Bus 230	: V=0.990047129159, theta=-8.04845106574 -> V=1.0, theta=0.0
% INFO    : Bus 231	: V=0.993162757441, theta=-5.39492391395 -> V=1.0, theta=0.0
% INFO    : Bus 232	: V=1.00423252359, theta=-8.30997837374 -> V=1.0, theta=0.0
% INFO    : Bus 233	: V=0.992936252092, theta=-5.43338883175 -> V=1.0, theta=0.0
% INFO    : Bus 234	: V=0.996767452706, theta=-9.85728209332 -> V=1.0, theta=0.0
% INFO    : Bus 235	: V=1.00692081019, theta=-6.11011969958 -> V=1.0, theta=0.0
% INFO    : Bus 236	: V=0.988067660073, theta=-7.22567570029 -> V=1.0, theta=0.0
% INFO    : Bus 237	: V=0.995624217361, theta=-3.00459764929 -> V=1.0, theta=0.0
% INFO    : Bus 238	: V=1.00009614024, theta=-0.436556141645 -> V=1.0, theta=0.0
% INFO    : Bus 239	: V=0.977922298114, theta=-12.9005451991 -> V=1.0, theta=0.0
% INFO    : Bus 240	: V=1.01180406246, theta=-9.78335598763 -> V=1.0, theta=0.0
% INFO    : Bus 241	: V=1.00768125211, theta=-6.91449476417 -> V=1.0, theta=0.0
% INFO    : Bus 242	: V=1.00269244199, theta=-7.62239520755 -> V=1.0, theta=0.0
% INFO    : Bus 243	: V=1.00096167858, theta=-8.42412484795 -> V=1.0, theta=0.0
% INFO    : Bus 244	: V=1.00282641362, theta=-13.2555008337 -> V=1.0, theta=0.0
% INFO    : Bus 245	: V=1.02131763713, theta=-15.6013013985 -> V=1.0, theta=0.0
% INFO    : Bus 246	: V=0.970337904556, theta=-9.91253364103 -> V=1.0, theta=0.0
% INFO    : Bus 247	: V=0.99759537507, theta=-6.45799666865 -> V=1.0, theta=0.0
% INFO    : Bus 248	: V=1.02020921694, theta=-12.1318129733 -> V=1.0, theta=0.0
% INFO    : Bus 249	: V=1.00495587699, theta=-11.6735396069 -> V=1.0, theta=0.0
% INFO    : Bus 250	: V=1.00112265531, theta=-10.7391189283 -> V=1.0, theta=0.0
% INFO    : Bus 251	: V=0.994248593204, theta=-11.5551233699 -> V=1.0, theta=0.0
% INFO    : Bus 252	: V=0.978548787854, theta=-6.20735721452 -> V=1.0, theta=0.0
% INFO    : Bus 253	: V=1.01816928988, theta=-8.71026382376 -> V=1.0, theta=0.0
% INFO    : Bus 254	: V=0.977604649135, theta=-6.27362476441 -> V=1.0, theta=0.0
% INFO    : Bus 255	: V=1.01340601641, theta=-9.4758561297 -> V=1.0, theta=0.0
% INFO    : Bus 256	: V=1.00221244648, theta=-11.4939431105 -> V=1.0, theta=0.0
% INFO    : Bus 257	: V=1.00385883248, theta=-9.7914829318 -> V=1.0, theta=0.0
% INFO    : Bus 258	: V=1.0049375499, theta=-9.62786187633 -> V=1.0, theta=0.0
% INFO    : Bus 259	: V=1.00545653568, theta=-9.84733354406 -> V=1.0, theta=0.0
% INFO    : Bus 260	: V=1.00177704649, theta=-5.29964428421 -> V=1.0, theta=0.0
% INFO    : Bus 261	: V=0.989657572028, theta=-7.48142483435 -> V=1.0, theta=0.0
% INFO    : Bus 262	: V=0.99754888978, theta=-5.34655828045 -> V=1.0, theta=0.0
% INFO    : Bus 263	: V=0.99403073329, theta=-6.31746358242 -> V=1.0, theta=0.0
% INFO    : Bus 264	: V=0.997764902825, theta=-3.93101754981 -> V=1.0, theta=0.0
% INFO    : Bus 265	: V=1.00075783573, theta=-5.9728807495 -> V=1.0, theta=0.0
% INFO    : Bus 266	: V=0.998192426653, theta=-8.52001964266 -> V=1.0, theta=0.0
% INFO    : Bus 267	: V=0.997518167839, theta=-13.5532261859 -> V=1.0, theta=0.0
% INFO    : Bus 268	: V=0.980028230114, theta=-4.80871094608 -> V=1.0, theta=0.0
% INFO    : Bus 269	: V=1.00215533949, theta=-8.50523145505 -> V=1.0, theta=0.0
% INFO    : Bus 270	: V=0.99803136715, theta=-6.83591877604 -> V=1.0, theta=0.0
% INFO    : Bus 271	: V=0.981434408025, theta=-11.5379759117 -> V=1.0, theta=0.0
% INFO    : Bus 272	: V=0.997191396562, theta=-10.0271559538 -> V=1.0, theta=0.0
% INFO    : Bus 273	: V=1.02397831053, theta=1.81847442184 -> V=1.0, theta=0.0
% INFO    : Bus 274	: V=1.01927872197, theta=-1.21328710397 -> V=1.0, theta=0.0
% INFO    : Bus 275	: V=0.975217438602, theta=1.81847442184 -> V=1.0, theta=0.0
% INFO    : Bus 276	: V=0.996117401788, theta=8.12222042177 -> V=1.0, theta=0.0
% INFO    : Bus 277	: V=1.01229720178, theta=-2.39404851638 -> V=1.0, theta=0.0
% INFO    : Bus 278	: V=0.999696473233, theta=-7.67614915902 -> V=1.0, theta=0.0
% INFO    : Bus 279	: V=0.999415885898, theta=-9.3675145507 -> V=1.0, theta=0.0
% INFO    : Bus 280	: V=1.01143995471, theta=-4.90565257964 -> V=1.0, theta=0.0
% INFO    : Bus 281	: V=0.993487178368, theta=-7.67614915902 -> V=1.0, theta=0.0
% INFO    : Bus 282	: V=1.00193457615, theta=2.2149122811 -> V=1.0, theta=0.0
% INFO    : Bus 283	: V=1.01068852496, theta=0.365839085809 -> V=1.0, theta=0.0
% INFO    : Bus 284	: V=1.00225647943, theta=4.24212276247 -> V=1.0, theta=0.0
% INFO    : Bus 285	: V=1.00189478967, theta=4.27234852042 -> V=1.0, theta=0.0
% INFO    : Bus 286	: V=1.00208597039, theta=4.00487861285 -> V=1.0, theta=0.0
% INFO    : Bus 287	: V=0.995711380029, theta=2.2149122811 -> V=1.0, theta=0.0
% INFO    : Bus 288	: V=0.995711380029, theta=2.2149122811 -> V=1.0, theta=0.0
% INFO    : Bus 289	: V=1.00233348688, theta=4.27250150805 -> V=1.0, theta=0.0
% INFO    : Bus 290	: V=1.001616611, theta=2.09800623113 -> V=1.0, theta=0.0
% INFO    : Bus 291	: V=0.990600328997, theta=-2.7073090127 -> V=1.0, theta=0.0
% INFO    : Bus 292	: V=1.00007081803, theta=3.81290859624 -> V=1.0, theta=0.0
% INFO    : Bus 293	: V=0.990094593679, theta=-2.75854247928 -> V=1.0, theta=0.0
% INFO    : Bus 294	: V=0.998552117448, theta=-3.21611014286 -> V=1.0, theta=0.0
% INFO    : Bus 295	: V=0.998742792579, theta=-3.78706531543 -> V=1.0, theta=0.0
% INFO    : Bus 296	: V=1.01045254135, theta=-5.14934932003 -> V=1.0, theta=0.0
% INFO    : Bus 297	: V=1.01658221515, theta=-1.33723618029 -> V=1.0, theta=0.0
% INFO    : Bus 298	: V=1.01085038669, theta=-0.00787986008342 -> V=1.0, theta=0.0
% INFO    : Bus 299	: V=1.01782704976, theta=-3.78706531543 -> V=1.0, theta=0.0
% INFO    : Bus 300	: V=1.00720460793, theta=1.95874054504 -> V=1.0, theta=0.0
% INFO    : Bus 301	: V=1.01782704976, theta=-3.78706531543 -> V=1.0, theta=0.0
% INFO    : Bus 302	: V=1.00932482634, theta=0.620891916589 -> V=1.0, theta=0.0
% INFO    : Bus 303	: V=1.01971247702, theta=-0.421407437418 -> V=1.0, theta=0.0
% INFO    : Bus 304	: V=1.01230672745, theta=-2.49621829907 -> V=1.0, theta=0.0
% INFO    : Bus 305	: V=1.02069764794, theta=-0.305629732812 -> V=1.0, theta=0.0
% INFO    : Bus 306	: V=1.00309152433, theta=-4.26486595856 -> V=1.0, theta=0.0
% INFO    : Bus 307	: V=1.00257703257, theta=-5.36939455121 -> V=1.0, theta=0.0
% INFO    : Bus 308	: V=1.00242616269, theta=-5.39596460401 -> V=1.0, theta=0.0
% INFO    : Bus 309	: V=1.02947781803, theta=1.49653340666e-16 -> V=1.0, theta=0.0
% INFO    : Bus 310	: V=1.01341818339, theta=-1.6992666952 -> V=1.0, theta=0.0
% INFO    : Bus 311	: V=0.980455064786, theta=6.47661142675e-24 -> V=1.0, theta=0.0
% INFO    : Bus 312	: V=0.988857171275, theta=2.49172089309 -> V=1.0, theta=0.0
% INFO    : Bus 313	: V=0.994018413638, theta=6.11868510195 -> V=1.0, theta=0.0
% INFO    : Bus 314	: V=0.997958115872, theta=4.50791967604 -> V=1.0, theta=0.0
% INFO    : Bus 315	: V=1.00902668713, theta=0.546013779625 -> V=1.0, theta=0.0
% INFO    : Bus 316	: V=1.00266881157, theta=11.3679229857 -> V=1.0, theta=0.0
% INFO    : Bus 317	: V=0.997958115872, theta=4.50791967604 -> V=1.0, theta=0.0
% INFO    : Bus 318	: V=1.00373369089, theta=9.37688073481 -> V=1.0, theta=0.0
% INFO    : Bus 319	: V=1.00474109831, theta=8.32794817257 -> V=1.0, theta=0.0
% INFO    : Bus 320	: V=0.997958115872, theta=4.50791967604 -> V=1.0, theta=0.0
% INFO    : Bus 321	: V=0.997958115872, theta=4.50791967604 -> V=1.0, theta=0.0
% INFO    : Bus 322	: V=0.999280506713, theta=-3.11347633103 -> V=1.0, theta=0.0
% INFO    : Bus 323	: V=1.00707483203, theta=-3.18331141155 -> V=1.0, theta=0.0
% INFO    : Bus 324	: V=0.999280506713, theta=-3.11347633103 -> V=1.0, theta=0.0
% INFO    : Bus 325	: V=1.00344785658, theta=-1.87456885046 -> V=1.0, theta=0.0
% INFO    : Bus 326	: V=1.00270672109, theta=-1.3769626493 -> V=1.0, theta=0.0
% INFO    : Bus 327	: V=0.999280506713, theta=-3.11347633103 -> V=1.0, theta=0.0
% INFO    : Bus 328	: V=1.00370968782, theta=-1.97062114625 -> V=1.0, theta=0.0
% INFO    : Bus 329	: V=1.00334003395, theta=-1.95335586402 -> V=1.0, theta=0.0
% INFO    : Bus 330	: V=0.9970514358, theta=-8.64003005791 -> V=1.0, theta=0.0
% INFO    : Bus 331	: V=0.997171176818, theta=-8.62554300342 -> V=1.0, theta=0.0
% INFO    : Bus 332	: V=1.01175851397, theta=-3.94936729922 -> V=1.0, theta=0.0
% INFO    : Bus 333	: V=1.00370186602, theta=-6.75887606649 -> V=1.0, theta=0.0
% INFO    : Bus 334	: V=1.0027082443, theta=-0.205702814739 -> V=1.0, theta=0.0
% INFO    : Bus 335	: V=1.01175851397, theta=-3.94936729922 -> V=1.0, theta=0.0
% INFO    : Bus 336	: V=1.00149055592, theta=2.44034538334 -> V=1.0, theta=0.0
% INFO    : Bus 337	: V=1.01449461336, theta=4.67456341085 -> V=1.0, theta=0.0
% INFO    : Bus 338	: V=1.00129320663, theta=4.38945629618 -> V=1.0, theta=0.0
% INFO    : Bus 339	: V=1.00137966046, theta=3.99339873136 -> V=1.0, theta=0.0
% INFO    : Bus 340	: V=1.00149055592, theta=2.44034538334 -> V=1.0, theta=0.0
% INFO    : Bus 341	: V=1.00097688295, theta=4.57732612021 -> V=1.0, theta=0.0
% INFO    : Bus 342	: V=0.999072048316, theta=-3.07692222622 -> V=1.0, theta=0.0
% INFO    : Bus 343	: V=0.999072048316, theta=-3.07692222622 -> V=1.0, theta=0.0
% INFO    : Bus 344	: V=1.01027995003, theta=3.78086093525 -> V=1.0, theta=0.0
% INFO    : Bus 345	: V=0.999072048316, theta=-3.07692222622 -> V=1.0, theta=0.0
% INFO    : Bus 346	: V=1.00634929875, theta=0.111953398514 -> V=1.0, theta=0.0
% INFO    : Bus 347	: V=0.992265286654, theta=-2.01350207629 -> V=1.0, theta=0.0
% INFO    : Bus 348	: V=1.0125978854, theta=-3.27081891597 -> V=1.0, theta=0.0
% INFO    : Bus 349	: V=0.992321286792, theta=-2.05069422769 -> V=1.0, theta=0.0
% INFO    : Bus 350	: V=1.02040425353, theta=-4.00585756254 -> V=1.0, theta=0.0
% INFO    : Bus 351	: V=1.01515979155, theta=-5.90345943462 -> V=1.0, theta=0.0
% INFO    : Bus 352	: V=1.02032363172, theta=-4.0134658914 -> V=1.0, theta=0.0
% INFO    : Bus 353	: V=1.00829897885, theta=-1.45007116601 -> V=1.0, theta=0.0
% INFO    : Bus 354	: V=1.00115019551, theta=4.3678745984 -> V=1.0, theta=0.0
% INFO    : Bus 355	: V=1.00828446644, theta=-1.52185288624 -> V=1.0, theta=0.0
% INFO    : Bus 356	: V=1.00515042779, theta=-3.05588582164 -> V=1.0, theta=0.0
% INFO    : Bus 357	: V=1.01928034958, theta=-7.3483264058 -> V=1.0, theta=0.0
% INFO    : Bus 358	: V=1.0055697271, theta=-2.28567410619 -> V=1.0, theta=0.0
% INFO    : Bus 359	: V=1.0079336039, theta=1.72837680482 -> V=1.0, theta=0.0
% INFO    : Bus 360	: V=1.01151442694, theta=-2.14345172446 -> V=1.0, theta=0.0
% INFO    : Bus 361	: V=1.00036371377, theta=-5.3363259189 -> V=1.0, theta=0.0
% INFO    : Bus 362	: V=1.03311353855, theta=0.587593446731 -> V=1.0, theta=0.0
% INFO    : Bus 363	: V=1.01690379057, theta=0.777354956972 -> V=1.0, theta=0.0
% INFO    : Bus 364	: V=1.01151442694, theta=-2.14345172446 -> V=1.0, theta=0.0
% INFO    : Bus 365	: V=1.01341670299, theta=0.711634681276 -> V=1.0, theta=0.0
% INFO    : Bus 366	: V=1.00286341886, theta=0.233081523075 -> V=1.0, theta=0.0
% INFO    : Bus 367	: V=1.0067096235, theta=3.47127396405 -> V=1.0, theta=0.0
% INFO    : Bus 368	: V=1.0084644438, theta=2.78842048925 -> V=1.0, theta=0.0
% INFO    : Bus 369	: V=0.943871453041, theta=0.233081523075 -> V=1.0, theta=0.0
% INFO    : Bus 370	: V=1.00678711107, theta=-3.02703153539 -> V=1.0, theta=0.0
% INFO    : Bus 371	: V=1.00535189701, theta=-1.5484028034 -> V=1.0, theta=0.0
% INFO    : Bus 372	: V=1.00503534479, theta=-0.168935646594 -> V=1.0, theta=0.0
% INFO    : Bus 373	: V=1.00664692538, theta=-3.15332991658 -> V=1.0, theta=0.0
% INFO    : Bus 374	: V=1.00687076625, theta=-4.44281425627 -> V=1.0, theta=0.0
% INFO    : Bus 375	: V=1.00000097645, theta=-0.705336712682 -> V=1.0, theta=0.0
% INFO    : Bus 376	: V=1.00639255246, theta=-4.45548863695 -> V=1.0, theta=0.0
% INFO    : Bus 377	: V=1.01955706564, theta=6.49923790616 -> V=1.0, theta=0.0
% INFO    : Bus 378	: V=0.991220439574, theta=9.0693180311 -> V=1.0, theta=0.0
% INFO    : Bus 379	: V=0.995389590547, theta=13.5653676705 -> V=1.0, theta=0.0
% INFO    : Bus 380	: V=0.994394440282, theta=12.2899840847 -> V=1.0, theta=0.0
% INFO    : Bus 381	: V=0.993267239889, theta=11.3126534287 -> V=1.0, theta=0.0
% INFO    : Bus 382	: V=1.00008119908, theta=-1.3976404703 -> V=1.0, theta=0.0
% INFO    : Bus 383	: V=0.999598350986, theta=-1.44163564054 -> V=1.0, theta=0.0
% INFO    : Bus 384	: V=0.9995874603, theta=-1.18674997996 -> V=1.0, theta=0.0
% INFO    : Bus 385	: V=0.999564401086, theta=-1.20279818038 -> V=1.0, theta=0.0
% INFO    : Bus 386	: V=1.0165308901, theta=0.419529152176 -> V=1.0, theta=0.0
% INFO    : Bus 387	: V=1.02200924166, theta=-1.92924833257 -> V=1.0, theta=0.0
% INFO    : Bus 388	: V=1.01725914253, theta=0.464832026676 -> V=1.0, theta=0.0
% INFO    : Bus 389	: V=1.01491680018, theta=-1.71958560983 -> V=1.0, theta=0.0
% INFO    : Bus 390	: V=1.0088539358, theta=-1.58016053874 -> V=1.0, theta=0.0
% INFO    : Bus 391	: V=0.959375804163, theta=0.093758874872 -> V=1.0, theta=0.0
% INFO    : Bus 392	: V=0.938651375886, theta=-1.71958560983 -> V=1.0, theta=0.0
% INFO    : Bus 393	: V=0.933256827749, theta=-1.71958560983 -> V=1.0, theta=0.0
% INFO    : Bus 394	: V=0.933256827749, theta=-1.71958560983 -> V=1.0, theta=0.0
% INFO    : Bus 395	: V=0.994553038495, theta=-1.18009350018 -> V=1.0, theta=0.0
% INFO    : Bus 396	: V=1.01777253306, theta=-1.8592984237 -> V=1.0, theta=0.0
% INFO    : Bus 397	: V=0.994842671961, theta=-1.17532256379 -> V=1.0, theta=0.0
% INFO    : Bus 398	: V=1.01512922586, theta=-3.27470096794 -> V=1.0, theta=0.0
% INFO    : Bus 399	: V=1.00218217304, theta=-3.82431554597 -> V=1.0, theta=0.0
% INFO    : Bus 400	: V=1.01069950314, theta=-1.59966929135 -> V=1.0, theta=0.0
% INFO    : Bus 401	: V=1.01069950314, theta=-1.59966929135 -> V=1.0, theta=0.0
% INFO    : Bus 402	: V=1.00009604175, theta=3.29849203643 -> V=1.0, theta=0.0
% INFO    : Bus 403	: V=1.0106967851, theta=-1.63722103248 -> V=1.0, theta=0.0
% INFO    : Bus 404	: V=1.01149571639, theta=1.09515520767 -> V=1.0, theta=0.0
% INFO    : Bus 405	: V=1.00657903704, theta=-0.95470518004 -> V=1.0, theta=0.0
% INFO    : Bus 406	: V=1.00408275076, theta=-3.30422320783 -> V=1.0, theta=0.0
% INFO    : Bus 407	: V=1.00579176427, theta=0.94655959439 -> V=1.0, theta=0.0
% INFO    : Bus 408	: V=1.00421772294, theta=1.66503308764 -> V=1.0, theta=0.0
% INFO    : Bus 409	: V=1.00333704031, theta=2.36215360135 -> V=1.0, theta=0.0
% INFO    : Bus 410	: V=1.00345950377, theta=2.24318665573 -> V=1.0, theta=0.0
% INFO    : Bus 411	: V=1.0028032282, theta=2.99867619552 -> V=1.0, theta=0.0
% INFO    : Bus 412	: V=1.00328050266, theta=2.41833818938 -> V=1.0, theta=0.0
% INFO    : Bus 413	: V=1.0009533178, theta=-9.05597036296 -> V=1.0, theta=0.0
% INFO    : Bus 414	: V=1.02343730979, theta=-0.623732083826 -> V=1.0, theta=0.0
% INFO    : Bus 415	: V=1.01818396211, theta=-3.92188555568 -> V=1.0, theta=0.0
% INFO    : Bus 416	: V=0.980538739921, theta=-0.623732083826 -> V=1.0, theta=0.0
% INFO    : Bus 417	: V=1.0268568081, theta=1.71742398929 -> V=1.0, theta=0.0
% INFO    : Bus 418	: V=1.02343730979, theta=-0.623732083826 -> V=1.0, theta=0.0
% INFO    : Bus 419	: V=1.01267562016, theta=2.99365461799 -> V=1.0, theta=0.0
% INFO    : Bus 420	: V=1.01098498967, theta=2.71189593908 -> V=1.0, theta=0.0
% INFO    : Bus 421	: V=1.00036647031, theta=-1.14088349551 -> V=1.0, theta=0.0
% INFO    : Bus 422	: V=0.9993741825, theta=2.19546035252 -> V=1.0, theta=0.0
% INFO    : Bus 423	: V=1.0114008622, theta=-2.771739117 -> V=1.0, theta=0.0
% INFO    : Bus 424	: V=1.0005534483, theta=6.60748340534 -> V=1.0, theta=0.0
% INFO    : Bus 425	: V=1.01202448861, theta=2.19546035252 -> V=1.0, theta=0.0
% INFO    : Bus 426	: V=0.989817373243, theta=6.95521799462 -> V=1.0, theta=0.0
% INFO    : Bus 427	: V=1.00234700071, theta=6.08216102063 -> V=1.0, theta=0.0
% INFO    : Bus 428	: V=1.01202448861, theta=2.19546035252 -> V=1.0, theta=0.0
% INFO    : Bus 429	: V=1.02910274243, theta=-1.51206705166 -> V=1.0, theta=0.0
% INFO    : Bus 430	: V=1.01886964956, theta=-3.89316162786 -> V=1.0, theta=0.0
% INFO    : Bus 431	: V=0.999643664994, theta=-0.402418931688 -> V=1.0, theta=0.0
% INFO    : Bus 432	: V=0.999568913365, theta=0.342774715433 -> V=1.0, theta=0.0
% INFO    : Bus 433	: V=0.999409703132, theta=-0.573146327521 -> V=1.0, theta=0.0
% INFO    : Bus 434	: V=0.999518596756, theta=-0.15164339088 -> V=1.0, theta=0.0
% INFO    : Bus 435	: V=1.026566512, theta=-2.10096027641 -> V=1.0, theta=0.0
% INFO    : Bus 436	: V=1.0135233868, theta=-4.84736074347 -> V=1.0, theta=0.0
% INFO    : Bus 437	: V=0.949425675837, theta=-2.10096027641 -> V=1.0, theta=0.0
% INFO    : Bus 438	: V=0.949425675837, theta=-2.10096027641 -> V=1.0, theta=0.0
% INFO    : Bus 439	: V=0.982503598295, theta=-0.312165849227 -> V=1.0, theta=0.0
% INFO    : Bus 440	: V=0.982698896034, theta=-0.770719212736 -> V=1.0, theta=0.0
% INFO    : Bus 441	: V=1.00908898692, theta=-8.28485139176 -> V=1.0, theta=0.0
% INFO    : Bus 442	: V=1.00189498344, theta=-12.4645243837 -> V=1.0, theta=0.0
% INFO    : Bus 443	: V=1.00189498344, theta=-12.4645243837 -> V=1.0, theta=0.0
% INFO    : Bus 444	: V=1.00011033689, theta=-8.81686098525 -> V=1.0, theta=0.0
% INFO    : Bus 445	: V=1.00188132503, theta=-12.4664586312 -> V=1.0, theta=0.0
% INFO    : Bus 446	: V=1.0204638945, theta=-1.09340435985 -> V=1.0, theta=0.0
% INFO    : Bus 447	: V=1.0295740356, theta=-3.9200302161 -> V=1.0, theta=0.0
% INFO    : Bus 448	: V=1.00734927895, theta=3.71679049345 -> V=1.0, theta=0.0
% INFO    : Bus 449	: V=1.00790517203, theta=3.3253729927 -> V=1.0, theta=0.0
% INFO    : Bus 450	: V=0.992413759601, theta=1.09412364457 -> V=1.0, theta=0.0
% INFO    : Bus 451	: V=0.994242263225, theta=0.365735360937 -> V=1.0, theta=0.0
% INFO    : Bus 452	: V=0.99067969879, theta=-0.0514409405772 -> V=1.0, theta=0.0
% INFO    : Bus 453	: V=0.992542131695, theta=-9.31786483339 -> V=1.0, theta=0.0
% INFO    : Bus 454	: V=1.02922476473, theta=-1.83233720112 -> V=1.0, theta=0.0
% INFO    : Bus 455	: V=1.02958905246, theta=-4.59550046111 -> V=1.0, theta=0.0
% INFO    : Bus 456	: V=0.995126325664, theta=3.84424691915 -> V=1.0, theta=0.0
% INFO    : Bus 457	: V=0.99032531648, theta=1.02459336767 -> V=1.0, theta=0.0
% INFO    : Bus 458	: V=0.994292017566, theta=3.00163557333 -> V=1.0, theta=0.0
% INFO    : Bus 459	: V=0.992351906173, theta=1.77884194632 -> V=1.0, theta=0.0
% INFO    : Bus 460	: V=1.01989924623, theta=3.36537588491 -> V=1.0, theta=0.0
% INFO    : Bus 461	: V=1.01643615108, theta=-0.724442536821 -> V=1.0, theta=0.0
% INFO    : Bus 462	: V=0.989029937903, theta=8.25935685679 -> V=1.0, theta=0.0
% INFO    : Bus 463	: V=0.9877271436, theta=7.74091331943 -> V=1.0, theta=0.0
% INFO    : Bus 464	: V=0.977148978426, theta=3.36537588491 -> V=1.0, theta=0.0
% INFO    : Bus 465	: V=1.00474229584, theta=-2.97708773814 -> V=1.0, theta=0.0
% INFO    : Bus 466	: V=1.00012964927, theta=1.65087065098 -> V=1.0, theta=0.0
% INFO    : Bus 467	: V=1.0046769228, theta=-3.01161115532 -> V=1.0, theta=0.0
% INFO    : Bus 468	: V=0.995866746349, theta=3.52472999971 -> V=1.0, theta=0.0
% INFO    : Bus 469	: V=1.0113027984, theta=-1.64177101796 -> V=1.0, theta=0.0
% INFO    : Bus 470	: V=0.999072540758, theta=9.61827674247 -> V=1.0, theta=0.0
% INFO    : Bus 471	: V=0.998902110506, theta=7.30990075757 -> V=1.0, theta=0.0
% INFO    : Bus 472	: V=1.00996100018, theta=2.75311772649 -> V=1.0, theta=0.0
% INFO    : Bus 473	: V=1.00997624299, theta=2.74152055006 -> V=1.0, theta=0.0
% INFO    : Bus 474	: V=1.01205622852, theta=-5.69455913379 -> V=1.0, theta=0.0
% INFO    : Bus 475	: V=1.01050687337, theta=-5.4098080686 -> V=1.0, theta=0.0
% INFO    : Bus 476	: V=1.00669534334, theta=-0.663533214915 -> V=1.0, theta=0.0
% INFO    : Bus 477	: V=1.01202206373, theta=-5.7170408863 -> V=1.0, theta=0.0
% INFO    : Bus 478	: V=1.01142125264, theta=-5.90675221629 -> V=1.0, theta=0.0
% INFO    : Bus 479	: V=0.990398241277, theta=-2.2283245168 -> V=1.0, theta=0.0
% INFO    : Bus 480	: V=1.02672566843, theta=-6.30529743403 -> V=1.0, theta=0.0
% INFO    : Bus 481	: V=0.990398241277, theta=-2.2283245168 -> V=1.0, theta=0.0
% INFO    : Bus 482	: V=0.990398241277, theta=-2.2283245168 -> V=1.0, theta=0.0
% INFO    : Bus 483	: V=1.01513660413, theta=2.66423398504 -> V=1.0, theta=0.0
% INFO    : Bus 484	: V=1.01144842344, theta=4.30338940747 -> V=1.0, theta=0.0
% INFO    : Bus 485	: V=0.990398241277, theta=-2.2283245168 -> V=1.0, theta=0.0
% INFO    : Bus 486	: V=1.00853442727, theta=0.254287619194 -> V=1.0, theta=0.0
% INFO    : Bus 487	: V=1.00619182631, theta=-7.91914011616 -> V=1.0, theta=0.0
% INFO    : Bus 488	: V=1.00755469788, theta=0.109355560086 -> V=1.0, theta=0.0
% INFO    : Bus 489	: V=1.00003276471, theta=-5.17755081593 -> V=1.0, theta=0.0
% INFO    : Bus 490	: V=1.00219895699, theta=-13.976417405 -> V=1.0, theta=0.0
% INFO    : Bus 491	: V=1.00219895699, theta=-13.976417405 -> V=1.0, theta=0.0
% INFO    : Bus 492	: V=1.00181388021, theta=-8.71023781488 -> V=1.0, theta=0.0
% INFO    : Bus 493	: V=1.00872408036, theta=-4.08146413858 -> V=1.0, theta=0.0
% INFO    : Bus 494	: V=1.01438712747, theta=-5.94395588051 -> V=1.0, theta=0.0
% INFO    : Bus 495	: V=1.00085389329, theta=-8.89649533235 -> V=1.0, theta=0.0
% INFO    : Bus 496	: V=1.00839116542, theta=-2.67810728197 -> V=1.0, theta=0.0
% INFO    : Bus 497	: V=1.02673342316, theta=-7.27415905121 -> V=1.0, theta=0.0
% INFO    : Bus 498	: V=1.00866690287, theta=-2.66209509196 -> V=1.0, theta=0.0
% INFO    : Bus 499	: V=1.00340669673, theta=-3.59395611678 -> V=1.0, theta=0.0
% INFO    : Bus 500	: V=1.003371832, theta=-3.59691858681 -> V=1.0, theta=0.0
% INFO    :
% INFO    : === Generator Setpoint Replacement Notes ===
% INFO    : Gen at bus 272	: Pg=46.8993571031, Qg=18.0091132505 -> Pg=34.463, Qg=7.856
% INFO    : Gen at bus 272	: Vg=1.0343582 -> Vg=1.0
% INFO    : Gen at bus 275	: Vg=1.0028084 -> Vg=1.0
% INFO    : Gen at bus 276	: Pg=888.199419787, Qg=205.296404353 -> Pg=643.217, Qg=127.013
% INFO    : Gen at bus 276	: Vg=1.018 -> Vg=1.0
% INFO    : Gen at bus 277	: Pg=24.998766721, Qg=4.98587652889 -> Pg=16.691, Qg=4.1875
% INFO    : Gen at bus 277	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 277	: Pg=24.9987667568, Qg=4.98587652889 -> Pg=13.858, Qg=4.1875
% INFO    : Gen at bus 277	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 277	: Pg=24.9987667093, Qg=4.98587652889 -> Pg=17.3305, Qg=4.1875
% INFO    : Gen at bus 277	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 277	: Pg=24.9987667187, Qg=4.98587652889 -> Pg=16.8255, Qg=4.1875
% INFO    : Gen at bus 277	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 280	: Pg=158.699718358, Qg=80.7776373283 -> Pg=118.674, Qg=31.581
% INFO    : Gen at bus 280	: Vg=1.0424647 -> Vg=1.0
% INFO    : Gen at bus 281	: Vg=1.0253582 -> Vg=1.0
% INFO    : Gen at bus 284	: Pg=135.773782684, Qg=25.6144810313 -> Pg=135.035, Qg=43.2495
% INFO    : Gen at bus 284	: Vg=1.0405 -> Vg=1.0
% INFO    : Gen at bus 285	: Pg=115.636373046, Qg=20.4304127522 -> Pg=136.374, Qg=43.2495
% INFO    : Gen at bus 285	: Vg=1.0405 -> Vg=1.0
% INFO    : Gen at bus 286	: Pg=110.931927954, Qg=22.3302519584 -> Pg=143.288, Qg=43.2495
% INFO    : Gen at bus 286	: Vg=1.0405 -> Vg=1.0
% INFO    : Gen at bus 287	: Vg=1.0325943 -> Vg=1.0
% INFO    : Gen at bus 288	: Vg=1.0325943 -> Vg=1.0
% INFO    : Gen at bus 289	: Pg=142.506595639, Qg=26.9177764427 -> Pg=122.406, Qg=43.2495
% INFO    : Gen at bus 289	: Vg=1.0405 -> Vg=1.0
% INFO    : Gen at bus 292	: Pg=0.499620377583, Qg=0.0545612945229 -> Pg=0.28, Qg=0.0835
% INFO    : Gen at bus 292	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 292	: Pg=0.499620600142, Qg=0.0545612945229 -> Pg=0.313, Qg=0.0835
% INFO    : Gen at bus 292	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 294	: Vg=1.0327294 -> Vg=1.0
% INFO    : Gen at bus 297	: Pg=178.46647644, Qg=-4.02244916343 -> Pg=130.6165, Qg=35.515
% INFO    : Gen at bus 297	: Vg=1.063 -> Vg=1.0
% INFO    : Gen at bus 298	: Pg=178.466400535, Qg=-16.0633682835 -> Pg=132.5635, Qg=35.515
% INFO    : Gen at bus 298	: Vg=1.063 -> Vg=1.0
% INFO    : Gen at bus 299	: Vg=1.0556074 -> Vg=1.0
% INFO    : Gen at bus 300	: Pg=178.46621951, Qg=-14.5172672778 -> Pg=121.061, Qg=35.515
% INFO    : Gen at bus 300	: Vg=1.063 -> Vg=1.0
% INFO    : Gen at bus 301	: Vg=1.0556074 -> Vg=1.0
% INFO    : Gen at bus 302	: Pg=178.466370105, Qg=-15.5589482803 -> Pg=121.1655, Qg=35.515
% INFO    : Gen at bus 302	: Vg=1.063 -> Vg=1.0
% INFO    : Gen at bus 303	: Pg=16.7141829692, Qg=-3.30791343727 -> Pg=42.106, Qg=11.306
% INFO    : Gen at bus 303	: Vg=1.0491189 -> Vg=1.0
% INFO    : Gen at bus 303	: Pg=13.7601829614, Qg=-3.30791343727 -> Pg=40.629, Qg=11.306
% INFO    : Gen at bus 303	: Vg=1.0491189 -> Vg=1.0
% INFO    : Gen at bus 306	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 306	: Pg=6.99868198325, Qg=3.26186218235 -> Pg=3.891, Qg=1.204
% INFO    : Gen at bus 306	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 307	: Pg=33.6991727653, Qg=6.09031040229 -> Pg=22.668, Qg=5.645
% INFO    : Gen at bus 307	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 307	: Pg=33.6991727575, Qg=6.09031040229 -> Pg=24.2095, Qg=5.645
% INFO    : Gen at bus 307	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 307	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 311	: Vg=0.99811928 -> Vg=1.0
% INFO    : Gen at bus 312	: Pg=886.019003906, Qg=179.517718998 -> Pg=809.527, Qg=166.547
% INFO    : Gen at bus 312	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 313	: Pg=1164.65326919, Qg=197.778821902 -> Pg=806.4555, Qg=166.547
% INFO    : Gen at bus 313	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 316	: Pg=332.615374837, Qg=24.7497781494 -> Pg=237.492, Qg=66.191
% INFO    : Gen at bus 316	: Vg=1.0495 -> Vg=1.0
% INFO    : Gen at bus 317	: Vg=1.038534 -> Vg=1.0
% INFO    : Gen at bus 318	: Pg=332.615553678, Qg=28.6206220009 -> Pg=184.7845, Qg=66.191
% INFO    : Gen at bus 318	: Vg=1.0495 -> Vg=1.0
% INFO    : Gen at bus 319	: Pg=332.615661797, Qg=39.2817659831 -> Pg=209.1735, Qg=66.191
% INFO    : Gen at bus 319	: Vg=1.0495 -> Vg=1.0
% INFO    : Gen at bus 320	: Vg=1.038534 -> Vg=1.0
% INFO    : Gen at bus 321	: Vg=1.038534 -> Vg=1.0
% INFO    : Gen at bus 324	: Vg=1.0408311 -> Vg=1.0
% INFO    : Gen at bus 325	: Pg=52.7281090061, Qg=9.73313488359 -> Pg=86.33, Qg=23.88
% INFO    : Gen at bus 325	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 326	: Pg=57.8601797654, Qg=6.49793633318 -> Pg=88.9155, Qg=23.88
% INFO    : Gen at bus 326	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 327	: Vg=1.0408311 -> Vg=1.0
% INFO    : Gen at bus 328	: Pg=52.3455044462, Qg=11.3400703006 -> Pg=84.224, Qg=23.88
% INFO    : Gen at bus 328	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 329	: Pg=47.8050803235, Qg=9.35799075436 -> Pg=70.3275, Qg=23.88
% INFO    : Gen at bus 329	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 330	: Pg=0.999807861828, Qg=0.465962475895 -> Pg=0.6295, Qg=0.172
% INFO    : Gen at bus 330	: Vg=1.0218474 -> Vg=1.0
% INFO    : Gen at bus 330	: Pg=0.999807871546, Qg=0.465962475895 -> Pg=0.5715, Qg=0.172
% INFO    : Gen at bus 330	: Vg=1.0218474 -> Vg=1.0
% INFO    : Gen at bus 330	: Pg=0.999807852089, Qg=0.465962475895 -> Pg=0.674, Qg=0.172
% INFO    : Gen at bus 330	: Vg=1.0218474 -> Vg=1.0
% INFO    : Gen at bus 330	: Pg=0.999807843774, Qg=0.465962475895 -> Pg=0.7045, Qg=0.172
% INFO    : Gen at bus 330	: Vg=1.0218474 -> Vg=1.0
% INFO    : Gen at bus 334	: Pg=68.9974181944, Qg=-8.41784596474 -> Pg=42.423, Qg=11.868
% INFO    : Gen at bus 334	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 335	: Vg=1.0404095 -> Vg=1.0
% INFO    : Gen at bus 338	: Pg=113.374084244, Qg=-1.05337078734 -> Pg=174.097, Qg=46.7355
% INFO    : Gen at bus 338	: Vg=1.0585 -> Vg=1.0
% INFO    : Gen at bus 339	: Pg=96.4571890478, Qg=-0.370544118174 -> Pg=165.63, Qg=46.7355
% INFO    : Gen at bus 339	: Vg=1.0585 -> Vg=1.0
% INFO    : Gen at bus 340	: Vg=1.0416488 -> Vg=1.0
% INFO    : Gen at bus 341	: Pg=93.871162996, Qg=-0.921503128523 -> Pg=164.3445, Qg=46.7355
% INFO    : Gen at bus 341	: Vg=1.0585 -> Vg=1.0
% INFO    : Gen at bus 343	: Vg=1.0333121 -> Vg=1.0
% INFO    : Gen at bus 344	: Pg=179.33215471, Qg=21.8469881266 -> Pg=108.947, Qg=30.845
% INFO    : Gen at bus 344	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 345	: Vg=1.0333121 -> Vg=1.0
% INFO    : Gen at bus 346	: Pg=48.4941312947, Qg=-3.91842796865 -> Pg=33.0455, Qg=9.6515
% INFO    : Gen at bus 346	: Vg=1.0400638 -> Vg=1.0
% INFO    : Gen at bus 346	: Pg=48.4941310657, Qg=-3.91842796865 -> Pg=35.5875, Qg=9.6515
% INFO    : Gen at bus 346	: Vg=1.0400638 -> Vg=1.0
% INFO    : Gen at bus 347	: Vg=1.0251549 -> Vg=1.0
% INFO    : Gen at bus 347	: Pg=74.9994386254, Qg=28.7998964507 -> Pg=54.1725, Qg=12.5625
% INFO    : Gen at bus 347	: Vg=1.0251549 -> Vg=1.0
% INFO    : Gen at bus 347	: Pg=74.9994386263, Qg=28.7998964507 -> Pg=52.459, Qg=12.5625
% INFO    : Gen at bus 347	: Vg=1.0251549 -> Vg=1.0
% INFO    : Gen at bus 350	: Pg=28.7854134194, Qg=-1.40941534047 -> Pg=17.738, Qg=4.824
% INFO    : Gen at bus 350	: Vg=1.0416163 -> Vg=1.0
% INFO    : Gen at bus 351	: Pg=28.7979256911, Qg=11.0588309048 -> Pg=21.4925, Qg=4.824
% INFO    : Gen at bus 351	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 351	: Pg=28.7979257661, Qg=11.0588309048 -> Pg=19.996, Qg=4.824
% INFO    : Gen at bus 351	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 351	: Pg=28.7979257887, Qg=11.0588309048 -> Pg=19.417, Qg=4.824
% INFO    : Gen at bus 351	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 354	: Pg=109.999311338, Qg=-6.5947282373 -> Pg=71.5885, Qg=21.89
% INFO    : Gen at bus 354	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 356	: Pg=30.3322890682, Qg=11.4695952504 -> Pg=22.006, Qg=5.081
% INFO    : Gen at bus 356	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 356	: Pg=30.3322890891, Qg=11.4695952504 -> Pg=17.979, Qg=5.081
% INFO    : Gen at bus 356	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 356	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 357	: Pg=21.1994996501, Qg=9.85671557176 -> Pg=13.687, Qg=3.6465
% INFO    : Gen at bus 357	: Vg=1.0410601 -> Vg=1.0
% INFO    : Gen at bus 358	: Pg=52.6492798123, Qg=12.7298675881 -> Pg=36.4625, Qg=8.819
% INFO    : Gen at bus 358	: Vg=1.036 -> Vg=1.0
% INFO    : Gen at bus 358	: Pg=52.6492798088, Qg=12.7298675881 -> Pg=38.8985, Qg=8.819
% INFO    : Gen at bus 358	: Vg=1.036 -> Vg=1.0
% INFO    : Gen at bus 358	: Pg=52.6492798128, Qg=12.7298675881 -> Pg=36.023, Qg=8.819
% INFO    : Gen at bus 358	: Vg=1.036 -> Vg=1.0
% INFO    : Gen at bus 358	: Vg=1.036 -> Vg=1.0
% INFO    : Gen at bus 359	: Vg=1.0387779 -> Vg=1.0
% INFO    : Gen at bus 359	: Pg=27.5966801127, Qg=14.0477679804 -> Pg=20.4465, Qg=5.492
% INFO    : Gen at bus 359	: Vg=1.0387779 -> Vg=1.0
% INFO    : Gen at bus 362	: Pg=694.986470484, Qg=309.842588205 -> Pg=392.1035, Qg=121.346
% INFO    : Gen at bus 362	: Vg=1.0611672 -> Vg=1.0
% INFO    : Gen at bus 363	: Pg=370.583014696, Qg=41.3075690756 -> Pg=391.8455, Qg=121.346
% INFO    : Gen at bus 363	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 364	: Vg=1.0386502 -> Vg=1.0
% INFO    : Gen at bus 365	: Pg=286.147364658, Qg=10.7556920094 -> Pg=495.8065, Qg=121.346
% INFO    : Gen at bus 365	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 367	: Pg=20.4996129341, Qg=1.25151004174 -> Pg=11.3645, Qg=3.4335
% INFO    : Gen at bus 367	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 368	: Pg=20.4997022326, Qg=2.43831975647 -> Pg=14.7755, Qg=3.4335
% INFO    : Gen at bus 368	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 368	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 369	: Vg=0.97293172 -> Vg=1.0
% INFO    : Gen at bus 371	: Pg=73.7328802486, Qg=-5.66836126997 -> Pg=178.966, Qg=48.8825
% INFO    : Gen at bus 371	: Vg=1.0279419 -> Vg=1.0
% INFO    : Gen at bus 372	: Pg=133.898805162, Qg=-6.19462766866 -> Pg=209.049, Qg=48.8825
% INFO    : Gen at bus 372	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 375	: Pg=24.9994691729, Qg=-2.55031522711 -> Pg=15.8795, Qg=4.975
% INFO    : Gen at bus 375	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 378	: Pg=162.080660034, Qg=28.9154739295 -> Pg=148.7015, Qg=46.123
% INFO    : Gen at bus 378	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 379	: Pg=231.77288129, Qg=27.8444138241 -> Pg=149.218, Qg=46.123
% INFO    : Gen at bus 379	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 380	: Pg=231.771488017, Qg=31.2540212406 -> Pg=131.406, Qg=46.123
% INFO    : Gen at bus 380	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 381	: Pg=231.770017691, Qg=31.3041402506 -> Pg=172.6965, Qg=46.123
% INFO    : Gen at bus 381	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 382	: Vg=1.0403632 -> Vg=1.0
% INFO    : Gen at bus 382	: Pg=7.39920486051, Qg=-0.350265271072 -> Pg=5.1625, Qg=1.2395
% INFO    : Gen at bus 382	: Vg=1.0403632 -> Vg=1.0
% INFO    : Gen at bus 382	: Pg=7.39920491806, Qg=-0.350265271072 -> Pg=4.139, Qg=1.2395
% INFO    : Gen at bus 382	: Vg=1.0403632 -> Vg=1.0
% INFO    : Gen at bus 382	: Pg=7.39920488623, Qg=-0.350265271072 -> Pg=4.7965, Qg=1.2395
% INFO    : Gen at bus 382	: Vg=1.0403632 -> Vg=1.0
% INFO    : Gen at bus 384	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 384	: Pg=14.9992197186, Qg=2.71006274604 -> Pg=11.1675, Qg=2.5125
% INFO    : Gen at bus 384	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 384	: Pg=14.9992197594, Qg=2.71006274604 -> Pg=9.073, Qg=2.5125
% INFO    : Gen at bus 384	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 384	: Pg=14.9992197639, Qg=2.71006274604 -> Pg=8.689, Qg=2.5125
% INFO    : Gen at bus 384	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 386	: Pg=27.4762859958, Qg=-3.29889128061 -> Pg=47.404, Qg=11.2785
% INFO    : Gen at bus 386	: Vg=1.046 -> Vg=1.0
% INFO    : Gen at bus 386	: Pg=30.1402860001, Qg=-3.29889128061 -> Pg=48.736, Qg=11.2785
% INFO    : Gen at bus 386	: Vg=1.046 -> Vg=1.0
% INFO    : Gen at bus 386	: Pg=11.0332859784, Qg=-3.29889128061 -> Pg=39.1825, Qg=11.2785
% INFO    : Gen at bus 386	: Vg=1.046 -> Vg=1.0
% INFO    : Gen at bus 386	: Pg=25.2092859926, Qg=-3.29889128061 -> Pg=46.2705, Qg=11.2785
% INFO    : Gen at bus 386	: Vg=1.046 -> Vg=1.0
% INFO    : Gen at bus 386	: Pg=12.5962859796, Qg=-3.29889128061 -> Pg=39.964, Qg=11.2785
% INFO    : Gen at bus 386	: Vg=1.046 -> Vg=1.0
% INFO    : Gen at bus 386	: Vg=1.046 -> Vg=1.0
% INFO    : Gen at bus 391	: Pg=141.498452971, Qg=72.0229786078 -> Pg=89.373, Qg=28.158
% INFO    : Gen at bus 391	: Vg=0.98427844 -> Vg=1.0
% INFO    : Gen at bus 392	: Vg=0.96377086 -> Vg=1.0
% INFO    : Gen at bus 393	: Vg=0.95823194 -> Vg=1.0
% INFO    : Gen at bus 394	: Vg=0.95823194 -> Vg=1.0
% INFO    : Gen at bus 395	: Pg=29.498127192, Qg=11.3277972046 -> Pg=19.08, Qg=4.9415
% INFO    : Gen at bus 395	: Vg=1.0247654 -> Vg=1.0
% INFO    : Gen at bus 395	: Pg=29.4981270965, Qg=11.3277972046 -> Pg=21.751, Qg=4.9415
% INFO    : Gen at bus 395	: Vg=1.0247654 -> Vg=1.0
% INFO    : Gen at bus 396	: Pg=24.4766017037, Qg=-1.4448507768 -> Pg=22.052, Qg=4.9415
% INFO    : Gen at bus 396	: Vg=1.0507471 -> Vg=1.0
% INFO    : Gen at bus 396	: Pg=23.2931369724, Qg=-1.4448507768 -> Pg=18.506, Qg=4.9415
% INFO    : Gen at bus 396	: Vg=1.0507471 -> Vg=1.0
% INFO    : Gen at bus 396	: Pg=23.1213310242, Qg=-1.4448507768 -> Pg=17.8405, Qg=4.9415
% INFO    : Gen at bus 396	: Vg=1.0507471 -> Vg=1.0
% INFO    : Gen at bus 396	: Pg=24.324646307, Qg=-1.4448507768 -> Pg=21.674, Qg=4.9415
% INFO    : Gen at bus 396	: Vg=1.0507471 -> Vg=1.0
% INFO    : Gen at bus 398	: Pg=46.5303273904, Qg=34.7258067999 -> Pg=53.8725, Qg=15.7875
% INFO    : Gen at bus 398	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 398	: Pg=45.3698496572, Qg=34.7258067999 -> Pg=53.118, Qg=15.7875
% INFO    : Gen at bus 398	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 398	: Pg=37.675524463, Qg=34.7258067999 -> Pg=48.24, Qg=15.7875
% INFO    : Gen at bus 398	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 398	: Pg=38.5819475294, Qg=34.7258067999 -> Pg=48.8045, Qg=15.7875
% INFO    : Gen at bus 398	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 398	: Pg=48.9589859197, Qg=34.7258067999 -> Pg=55.47, Qg=15.7875
% INFO    : Gen at bus 398	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 398	: Pg=45.8315104379, Qg=34.7258067999 -> Pg=53.4175, Qg=15.7875
% INFO    : Gen at bus 398	: Vg=1.037 -> Vg=1.0
% INFO    : Gen at bus 399	: Pg=1.49967303005, Qg=0.575924522155 -> Pg=0.863, Qg=0.251
% INFO    : Gen at bus 399	: Vg=1.0380655 -> Vg=1.0
% INFO    : Gen at bus 399	: Vg=1.0380655 -> Vg=1.0
% INFO    : Gen at bus 401	: Vg=1.0411894 -> Vg=1.0
% INFO    : Gen at bus 402	: Pg=61.2489398755, Qg=-6.79887457045 -> Pg=42.557, Qg=12.1885
% INFO    : Gen at bus 402	: Vg=1.0365 -> Vg=1.0
% INFO    : Gen at bus 404	: Pg=19.5204064304, Qg=-2.08295375599 -> Pg=31.01, Qg=7.1185
% INFO    : Gen at bus 404	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 404	: Pg=15.5334064289, Qg=-2.08295375599 -> Pg=29.0165, Qg=7.1185
% INFO    : Gen at bus 404	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 404	: Pg=13.0134064282, Qg=-2.08295375599 -> Pg=27.7565, Qg=7.1185
% INFO    : Gen at bus 404	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 404	: Pg=12.6614064281, Qg=-2.08295375599 -> Pg=27.5805, Qg=7.1185
% INFO    : Gen at bus 404	: Vg=1.042 -> Vg=1.0
% INFO    : Gen at bus 407	: Pg=108.999341741, Qg=-2.2433303673 -> Pg=63.9935, Qg=21.691
% INFO    : Gen at bus 407	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 408	: Pg=108.999307666, Qg=-5.26442411969 -> Pg=61.8655, Qg=21.691
% INFO    : Gen at bus 408	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 409	: Pg=108.999287161, Qg=-4.89122102238 -> Pg=70.785, Qg=21.691
% INFO    : Gen at bus 409	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 410	: Pg=108.999294342, Qg=-4.83111408438 -> Pg=65.653, Qg=21.691
% INFO    : Gen at bus 410	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 411	: Pg=108.999269551, Qg=-3.87318744881 -> Pg=61.5715, Qg=21.691
% INFO    : Gen at bus 411	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 412	: Pg=108.99929246, Qg=-4.45647708119 -> Pg=66.2415, Qg=21.691
% INFO    : Gen at bus 412	: Vg=1.054 -> Vg=1.0
% INFO    : Gen at bus 413	: Pg=53.8991026011, Qg=0.379293605757 -> Pg=32.777, Qg=9.0285
% INFO    : Gen at bus 413	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 416	: Vg=0.99628211 -> Vg=1.0
% INFO    : Gen at bus 417	: Pg=354.133796468, Qg=30.6839156727 -> Pg=242.657, Qg=60.912
% INFO    : Gen at bus 417	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 418	: Vg=1.0398694 -> Vg=1.0
% INFO    : Gen at bus 419	: Pg=256.045502476, Qg=135.756223867 -> Pg=205.3915, Qg=60.912
% INFO    : Gen at bus 419	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 420	: Pg=204.870063328, Qg=109.683646429 -> Pg=211.0205, Qg=60.912
% INFO    : Gen at bus 420	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 421	: Vg=1.041 -> Vg=1.0
% INFO    : Gen at bus 421	: Pg=51.499204294, Qg=-5.71363768506 -> Pg=37.7185, Qg=10.248
% INFO    : Gen at bus 421	: Vg=1.041 -> Vg=1.0
% INFO    : Gen at bus 424	: Pg=269.999025455, Qg=-32.9398647987 -> Pg=191.3985, Qg=46.44
% INFO    : Gen at bus 424	: Vg=1.0585 -> Vg=1.0
% INFO    : Gen at bus 425	: Vg=1.0572204 -> Vg=1.0
% INFO    : Gen at bus 426	: Pg=269.998357842, Qg=-23.9920328366 -> Pg=186.408, Qg=46.44
% INFO    : Gen at bus 426	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 427	: Pg=269.99894135, Qg=-32.9398801986 -> Pg=184.922, Qg=46.44
% INFO    : Gen at bus 427	: Vg=1.0585 -> Vg=1.0
% INFO    : Gen at bus 428	: Vg=1.0572204 -> Vg=1.0
% INFO    : Gen at bus 431	: Pg=54.2273860731, Qg=70.6909082525 -> Pg=139.595, Qg=44.775
% INFO    : Gen at bus 431	: Vg=1.0135 -> Vg=1.0
% INFO    : Gen at bus 432	: Pg=108.799267414, Qg=85.194157933 -> Pg=166.877, Qg=44.775
% INFO    : Gen at bus 432	: Vg=1.0135 -> Vg=1.0
% INFO    : Gen at bus 433	: Pg=75.7057949605, Qg=88.5996765118 -> Pg=150.335, Qg=44.775
% INFO    : Gen at bus 433	: Vg=1.0135 -> Vg=1.0
% INFO    : Gen at bus 434	: Pg=89.1019307754, Qg=95.3313153434 -> Pg=157.032, Qg=44.775
% INFO    : Gen at bus 434	: Vg=1.0135 -> Vg=1.0
% INFO    : Gen at bus 437	: Vg=0.96670012 -> Vg=1.0
% INFO    : Gen at bus 438	: Vg=0.96670012 -> Vg=1.0
% INFO    : Gen at bus 439	: Pg=90.1751235671, Qg=114.829936372 -> Pg=157.882, Qg=44.894
% INFO    : Gen at bus 439	: Vg=0.99755385 -> Vg=1.0
% INFO    : Gen at bus 440	: Pg=66.6260007599, Qg=114.829936067 -> Pg=128.7, Qg=44.894
% INFO    : Gen at bus 440	: Vg=0.99739349 -> Vg=1.0
% INFO    : Gen at bus 441	: Pg=42.6994662681, Qg=11.5498426775 -> Pg=27.017, Qg=7.1525
% INFO    : Gen at bus 441	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 441	: Pg=42.6994662645, Qg=11.5498426775 -> Pg=30.288, Qg=7.1525
% INFO    : Gen at bus 441	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 441	: Pg=42.6994662659, Qg=11.5498426775 -> Pg=29.1975, Qg=7.1525
% INFO    : Gen at bus 441	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 443	: Vg=1.0248367 -> Vg=1.0
% INFO    : Gen at bus 443	: Vg=1.0248367 -> Vg=1.0
% INFO    : Gen at bus 444	: Pg=2.99980311301, Qg=0.802845851465 -> Pg=2.0705, Qg=0.597
% INFO    : Gen at bus 444	: Vg=1.0368534 -> Vg=1.0
% INFO    : Gen at bus 444	: Vg=1.0368534 -> Vg=1.0
% INFO    : Gen at bus 448	: Pg=267.691271221, Qg=-34.5667203455 -> Pg=206.461, Qg=48.7345
% INFO    : Gen at bus 448	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 449	: Pg=244.889607811, Qg=-34.5667509744 -> Pg=210.545, Qg=48.7345
% INFO    : Gen at bus 449	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 450	: Pg=113.322369441, Qg=132.035852574 -> Pg=198.3295, Qg=48.7345
% INFO    : Gen at bus 450	: Vg=1.0166678 -> Vg=1.0
% INFO    : Gen at bus 451	: Pg=84.2135731209, Qg=132.035806173 -> Pg=183.774, Qg=48.7345
% INFO    : Gen at bus 451	: Vg=1.0187082 -> Vg=1.0
% INFO    : Gen at bus 452	: Pg=66.1588039159, Qg=132.035855691 -> Pg=174.746, Qg=48.7345
% INFO    : Gen at bus 452	: Vg=1.0152183 -> Vg=1.0
% INFO    : Gen at bus 453	: Vg=1.0212174 -> Vg=1.0
% INFO    : Gen at bus 453	: Pg=24.2998757183, Qg=9.33097479038 -> Pg=17.6065, Qg=4.07
% INFO    : Gen at bus 453	: Vg=1.0212174 -> Vg=1.0
% INFO    : Gen at bus 453	: Pg=24.2998757185, Qg=9.33097479038 -> Pg=16.7525, Qg=4.07
% INFO    : Gen at bus 453	: Vg=1.0212174 -> Vg=1.0
% INFO    : Gen at bus 456	: Pg=186.998106212, Qg=91.2315703401 -> Pg=131.5465, Qg=37.213
% INFO    : Gen at bus 456	: Vg=1.018 -> Vg=1.0
% INFO    : Gen at bus 457	: Pg=186.996092353, Qg=84.3739144426 -> Pg=116.005, Qg=37.213
% INFO    : Gen at bus 457	: Vg=1.013 -> Vg=1.0
% INFO    : Gen at bus 458	: Pg=186.997864146, Qg=88.4892165598 -> Pg=108.6965, Qg=37.213
% INFO    : Gen at bus 458	: Vg=1.018 -> Vg=1.0
% INFO    : Gen at bus 459	: Pg=186.996881616, Qg=92.486957692 -> Pg=131.5655, Qg=37.213
% INFO    : Gen at bus 459	: Vg=1.018 -> Vg=1.0
% INFO    : Gen at bus 462	: Pg=274.266399862, Qg=46.6047184105 -> Pg=192.012, Qg=54.579
% INFO    : Gen at bus 462	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 463	: Pg=274.266375811, Qg=45.0644566681 -> Pg=176.318, Qg=54.579
% INFO    : Gen at bus 463	: Vg=1.0045 -> Vg=1.0
% INFO    : Gen at bus 464	: Vg=1.0030963 -> Vg=1.0
% INFO    : Gen at bus 466	: Pg=25.2493036856, Qg=-1.23463239894 -> Pg=17.9105, Qg=4.2295
% INFO    : Gen at bus 466	: Vg=1.0691907 -> Vg=1.0
% INFO    : Gen at bus 466	: Pg=25.2493037011, Qg=-1.23463239894 -> Pg=15.498, Qg=4.2295
% INFO    : Gen at bus 466	: Vg=1.0691907 -> Vg=1.0
% INFO    : Gen at bus 470	: Pg=562.433155757, Qg=38.7230820301 -> Pg=372.7975, Qg=96.75
% INFO    : Gen at bus 470	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 471	: Pg=415.633051675, Qg=26.1946942874 -> Pg=326.623, Qg=96.75
% INFO    : Gen at bus 471	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 472	: Pg=7.71222443699, Qg=-2.71856690374 -> Pg=16.1055, Qg=4.876
% INFO    : Gen at bus 472	: Vg=1.041 -> Vg=1.0
% INFO    : Gen at bus 472	: Pg=10.4402244627, Qg=-2.71856690374 -> Pg=17.4695, Qg=4.876
% INFO    : Gen at bus 472	: Vg=1.041 -> Vg=1.0
% INFO    : Gen at bus 475	: Vg=1.0664757 -> Vg=1.0
% INFO    : Gen at bus 475	: Pg=4.22422583428, Qg=-1.43098111794 -> Pg=16.712, Qg=4.891
% INFO    : Gen at bus 475	: Vg=1.0664757 -> Vg=1.0
% INFO    : Gen at bus 476	: Pg=29.1996213538, Qg=-1.43098645032 -> Pg=21.567, Qg=4.891
% INFO    : Gen at bus 476	: Vg=1.0695 -> Vg=1.0
% INFO    : Gen at bus 478	: Pg=19.9016850283, Qg=-5.47194055021 -> Pg=34.6005, Qg=9.811
% INFO    : Gen at bus 478	: Vg=1.0412183 -> Vg=1.0
% INFO    : Gen at bus 478	: Pg=19.1036850277, Qg=-5.47194055021 -> Pg=34.2015, Qg=9.811
% INFO    : Gen at bus 478	: Vg=1.0412183 -> Vg=1.0
% INFO    : Gen at bus 481	: Vg=1.016367 -> Vg=1.0
% INFO    : Gen at bus 482	: Vg=1.016367 -> Vg=1.0
% INFO    : Gen at bus 483	: Pg=402.557255084, Qg=127.299337605 -> Pg=295.8225, Qg=69.2405
% INFO    : Gen at bus 483	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 484	: Pg=402.553954951, Qg=91.2636137768 -> Pg=258.232, Qg=69.2405
% INFO    : Gen at bus 484	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 485	: Vg=1.016367 -> Vg=1.0
% INFO    : Gen at bus 486	: Pg=28.8321301601, Qg=9.04085021737 -> Pg=16.2365, Qg=4.8295
% INFO    : Gen at bus 486	: Vg=1.0455 -> Vg=1.0
% INFO    : Gen at bus 486	: Pg=28.8321301356, Qg=9.04085021737 -> Pg=20.6945, Qg=4.8295
% INFO    : Gen at bus 486	: Vg=1.0455 -> Vg=1.0
% INFO    : Gen at bus 486	: Vg=1.0455 -> Vg=1.0
% INFO    : Gen at bus 486	: Pg=28.8321301538, Qg=9.04085021737 -> Pg=17.7785, Qg=4.8295
% INFO    : Gen at bus 486	: Vg=1.0455 -> Vg=1.0
% INFO    : Gen at bus 486	: Vg=1.0455 -> Vg=1.0
% INFO    : Gen at bus 486	: Pg=28.8321301466, Qg=9.04085021737 -> Pg=19.1545, Qg=4.8295
% INFO    : Gen at bus 486	: Vg=1.0455 -> Vg=1.0
% INFO    : Gen at bus 487	: Pg=3.67046039639, Qg=-1.38790226206 -> Pg=8.084, Qg=2.4875
% INFO    : Gen at bus 487	: Vg=1.0395302 -> Vg=1.0
% INFO    : Gen at bus 488	: Pg=6.43207959446, Qg=-0.312602717221 -> Pg=3.6445, Qg=1.0775
% INFO    : Gen at bus 488	: Vg=1.0453684 -> Vg=1.0
% INFO    : Gen at bus 488	: Pg=6.43207951227, Qg=-0.312602717221 -> Pg=4.4, Qg=1.0775
% INFO    : Gen at bus 488	: Vg=1.0453684 -> Vg=1.0
% INFO    : Gen at bus 488	: Pg=6.43207947959, Qg=-0.312602717221 -> Pg=4.599, Qg=1.0775
% INFO    : Gen at bus 488	: Vg=1.0453684 -> Vg=1.0
% INFO    : Gen at bus 488	: Pg=6.43207948301, Qg=-0.312602717221 -> Pg=4.58, Qg=1.0775
% INFO    : Gen at bus 488	: Vg=1.0453684 -> Vg=1.0
% INFO    : Gen at bus 488	: Pg=6.43207957544, Qg=-0.312602717221 -> Pg=3.8645, Qg=1.0775
% INFO    : Gen at bus 488	: Vg=1.0453684 -> Vg=1.0
% INFO    : Gen at bus 488	: Pg=6.43207957656, Qg=-0.312602717221 -> Pg=3.8525, Qg=1.0775
% INFO    : Gen at bus 488	: Vg=1.0453684 -> Vg=1.0
% INFO    : Gen at bus 489	: Pg=1.4327186583, Qg=0.667901816686 -> Pg=0.861, Qg=0.2465
% INFO    : Gen at bus 489	: Vg=1.0310698 -> Vg=1.0
% INFO    : Gen at bus 489	: Pg=1.43271866081, Qg=0.667901816686 -> Pg=0.8465, Qg=0.2465
% INFO    : Gen at bus 489	: Vg=1.0310698 -> Vg=1.0
% INFO    : Gen at bus 489	: Pg=1.43271863791, Qg=0.667901816686 -> Pg=0.957, Qg=0.2465
% INFO    : Gen at bus 489	: Vg=1.0310698 -> Vg=1.0
% INFO    : Gen at bus 489	: Pg=1.4327186233, Qg=0.667901816686 -> Pg=1.0085, Qg=0.2465
% INFO    : Gen at bus 489	: Vg=1.0310698 -> Vg=1.0
% INFO    : Gen at bus 489	: Pg=1.43271863727, Qg=0.667901816686 -> Pg=0.9595, Qg=0.2465
% INFO    : Gen at bus 489	: Vg=1.0310698 -> Vg=1.0
% INFO    : Gen at bus 489	: Pg=1.43271860992, Qg=0.667901816686 -> Pg=1.047, Qg=0.2465
% INFO    : Gen at bus 489	: Vg=1.0310698 -> Vg=1.0
% INFO    : Gen at bus 490	: Vg=1.0223568 -> Vg=1.0
% INFO    : Gen at bus 493	: Pg=139.999637266, Qg=12.1598331009 -> Pg=90.533, Qg=27.86
% INFO    : Gen at bus 493	: Vg=1.0495 -> Vg=1.0
% INFO    : Gen at bus 494	: Pg=139.999690052, Qg=35.2314528087 -> Pg=89.4515, Qg=27.86
% INFO    : Gen at bus 494	: Vg=1.0495 -> Vg=1.0
% INFO    : Gen at bus 496	: Pg=90.4957420596, Qg=34.751716439 -> Pg=50.1505, Qg=15.159
% INFO    : Gen at bus 496	: Vg=1.0321537 -> Vg=1.0
% INFO    : Gen at bus 496	: Pg=90.4957418855, Qg=34.751716439 -> Pg=63.005, Qg=15.159
% INFO    : Gen at bus 496	: Vg=1.0321537 -> Vg=1.0
% INFO    : Gen at bus 499	: Pg=1.7325907299, Qg=0.665908015041 -> Pg=1.1875, Qg=0.2905
% INFO    : Gen at bus 499	: Vg=1.039689 -> Vg=1.0
% INFO    : Gen at bus 499	: Pg=1.73259076306, Qg=0.665908015041 -> Pg=1.0915, Qg=0.2905
% INFO    : Gen at bus 499	: Vg=1.039689 -> Vg=1.0
% INFO    : Gen at bus 499	: Pg=1.73259069124, Qg=0.665908015041 -> Pg=1.2695, Qg=0.2905
% INFO    : Gen at bus 499	: Vg=1.039689 -> Vg=1.0
% INFO    :
% INFO    : === Writing Matpower Case File Notes ===
