# Ingress Metrics

| Metric name                            | Metric type | Description                                                                                                               | Labels/tags                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Status       |
| -------------------------------------- | ----------- | ------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------ |
| kube_ingress_annotations               | Gauge       | Kubernetes annotations converted to Prometheus labels controlled via [--metric-annotations-allowlist](../../developer/cli-arguments.md) | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt; <br> `annotation_INGRESS_ANNOTATION`=&lt;ANNOTATION_LABEL&gt;                                                                                                                                                                                                                                                                                                                                                                               | EXPERIMENTAL |
| kube_ingress_info                      | Gauge       |                                                                                                                           | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt; <br> `ingressclass`=&lt;ingress-class&gt; or `_default` if not set                                                                                                                                                                                                                                                                                                                                                                          | STABLE       |
| kube_ingress_labels                    | Gauge       | Kubernetes labels converted to Prometheus labels controlled via [--metric-labels-allowlist](../../developer/cli-arguments.md)           | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt; <br> `label_INGRESS_LABEL`=&lt;INGRESS_LABEL&gt;                                                                                                                                                                                                                                                                                                                                                                                            | STABLE       |
| kube_ingress_created                   | Gauge       |                                                                                                                           | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt;                                                                                                                                                                                                                                                                                                                                                                                                                                             | STABLE       |
| kube_ingress_metadata_resource_version | Gauge       |                                                                                                                           | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt;                                                                                                                                                                                                                                                                                                                                                                                                                                             | EXPERIMENTAL |
| kube_ingress_path                      | Gauge       |                                                                                                                           | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt; <br> `host`=&lt;ingress-host&gt; <br> `path`=&lt;ingress-path&gt; <br><i> If path served by Service Backend</i> <br> `service_name`=&lt;service name for the path&gt; <br> `service_port`=&lt;service port for the path&gt;<br><i> If path served by Resource Backend</i><br> `resource_api_group`=&lt;resource backend api group&gt; <br> `resource_kind`=&lt;resource backend kind&gt; <br> `resource_name`=&lt;resource backend name&gt; | STABLE       |
| kube_ingress_tls                       | Gauge       |                                                                                                                           | `ingress`=&lt;ingress-name&gt; <br> `namespace`=&lt;ingress-namespace&gt; <br> `tls_host`=&lt;tls hostname&gt; <br> `secret`=&lt;tls secret name&gt;                                                                                                                                                                                                                                                                                                                                                                  | STABLE       |
