// Copyright 2023 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/kubeflow/training-operator/test_job/apis/test_job/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TestJobLister helps list TestJobs.
// All objects returned here must be treated as read-only.
type TestJobLister interface {
	// List lists all TestJobs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.TestJob, err error)
	// TestJobs returns an object that can list and get TestJobs.
	TestJobs(namespace string) TestJobNamespaceLister
	TestJobListerExpansion
}

// testJobLister implements the TestJobLister interface.
type testJobLister struct {
	indexer cache.Indexer
}

// NewTestJobLister returns a new TestJobLister.
func NewTestJobLister(indexer cache.Indexer) TestJobLister {
	return &testJobLister{indexer: indexer}
}

// List lists all TestJobs in the indexer.
func (s *testJobLister) List(selector labels.Selector) (ret []*v1.TestJob, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.TestJob))
	})
	return ret, err
}

// TestJobs returns an object that can list and get TestJobs.
func (s *testJobLister) TestJobs(namespace string) TestJobNamespaceLister {
	return testJobNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TestJobNamespaceLister helps list and get TestJobs.
// All objects returned here must be treated as read-only.
type TestJobNamespaceLister interface {
	// List lists all TestJobs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.TestJob, err error)
	// Get retrieves the TestJob from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.TestJob, error)
	TestJobNamespaceListerExpansion
}

// testJobNamespaceLister implements the TestJobNamespaceLister
// interface.
type testJobNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all TestJobs in the indexer for a given namespace.
func (s testJobNamespaceLister) List(selector labels.Selector) (ret []*v1.TestJob, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.TestJob))
	})
	return ret, err
}

// Get retrieves the TestJob from the indexer for a given namespace and name.
func (s testJobNamespaceLister) Get(name string) (*v1.TestJob, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("testjob"), name)
	}
	return obj.(*v1.TestJob), nil
}
