//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// Copyright 2023 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1

import (
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJob":     schema_test_job_apis_test_job_v1_TestJob(ref),
		"github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJobList": schema_test_job_apis_test_job_v1_TestJobList(ref),
		"github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJobSpec": schema_test_job_apis_test_job_v1_TestJobSpec(ref),
	}
}

func schema_test_job_apis_test_job_v1_TestJob(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A generic job used for unit tests.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the TestJob.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the TestJob. This data may not be up to date. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1.JobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1.JobStatus", "github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJobSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_test_job_apis_test_job_v1_TestJobList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TestJobList is a list of TestJobs.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of TestJobs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJob"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/training-operator/test_job/apis/test_job/v1.TestJob", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_test_job_apis_test_job_v1_TestJobSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TestJobSpec is a desired state description of the TestJob.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"runPolicy": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1.RunPolicy"),
						},
					},
					"testReplicaSpecs": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1.ReplicaSpec"),
									},
								},
							},
						},
					},
				},
				Required: []string{"testReplicaSpecs"},
			},
		},
		Dependencies: []string{
			"github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1.ReplicaSpec", "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1.RunPolicy"},
	}
}
