// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v2alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TrainJobLister helps list TrainJobs.
// All objects returned here must be treated as read-only.
type TrainJobLister interface {
	// List lists all TrainJobs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.TrainJob, err error)
	// TrainJobs returns an object that can list and get TrainJobs.
	TrainJobs(namespace string) TrainJobNamespaceLister
	TrainJobListerExpansion
}

// trainJobLister implements the TrainJobLister interface.
type trainJobLister struct {
	indexer cache.Indexer
}

// NewTrainJobLister returns a new TrainJobLister.
func NewTrainJobLister(indexer cache.Indexer) TrainJobLister {
	return &trainJobLister{indexer: indexer}
}

// List lists all TrainJobs in the indexer.
func (s *trainJobLister) List(selector labels.Selector) (ret []*v2alpha1.TrainJob, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.TrainJob))
	})
	return ret, err
}

// TrainJobs returns an object that can list and get TrainJobs.
func (s *trainJobLister) TrainJobs(namespace string) TrainJobNamespaceLister {
	return trainJobNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TrainJobNamespaceLister helps list and get TrainJobs.
// All objects returned here must be treated as read-only.
type TrainJobNamespaceLister interface {
	// List lists all TrainJobs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.TrainJob, err error)
	// Get retrieves the TrainJob from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.TrainJob, error)
	TrainJobNamespaceListerExpansion
}

// trainJobNamespaceLister implements the TrainJobNamespaceLister
// interface.
type trainJobNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all TrainJobs in the indexer for a given namespace.
func (s trainJobNamespaceLister) List(selector labels.Selector) (ret []*v2alpha1.TrainJob, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.TrainJob))
	})
	return ret, err
}

// Get retrieves the TrainJob from the indexer for a given namespace and name.
func (s trainJobNamespaceLister) Get(name string) (*v2alpha1.TrainJob, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v2alpha1.Resource("trainjob"), name)
	}
	return obj.(*v2alpha1.TrainJob), nil
}
