// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v2alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TrainingRuntimeLister helps list TrainingRuntimes.
// All objects returned here must be treated as read-only.
type TrainingRuntimeLister interface {
	// List lists all TrainingRuntimes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.TrainingRuntime, err error)
	// TrainingRuntimes returns an object that can list and get TrainingRuntimes.
	TrainingRuntimes(namespace string) TrainingRuntimeNamespaceLister
	TrainingRuntimeListerExpansion
}

// trainingRuntimeLister implements the TrainingRuntimeLister interface.
type trainingRuntimeLister struct {
	indexer cache.Indexer
}

// NewTrainingRuntimeLister returns a new TrainingRuntimeLister.
func NewTrainingRuntimeLister(indexer cache.Indexer) TrainingRuntimeLister {
	return &trainingRuntimeLister{indexer: indexer}
}

// List lists all TrainingRuntimes in the indexer.
func (s *trainingRuntimeLister) List(selector labels.Selector) (ret []*v2alpha1.TrainingRuntime, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.TrainingRuntime))
	})
	return ret, err
}

// TrainingRuntimes returns an object that can list and get TrainingRuntimes.
func (s *trainingRuntimeLister) TrainingRuntimes(namespace string) TrainingRuntimeNamespaceLister {
	return trainingRuntimeNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TrainingRuntimeNamespaceLister helps list and get TrainingRuntimes.
// All objects returned here must be treated as read-only.
type TrainingRuntimeNamespaceLister interface {
	// List lists all TrainingRuntimes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.TrainingRuntime, err error)
	// Get retrieves the TrainingRuntime from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.TrainingRuntime, error)
	TrainingRuntimeNamespaceListerExpansion
}

// trainingRuntimeNamespaceLister implements the TrainingRuntimeNamespaceLister
// interface.
type trainingRuntimeNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all TrainingRuntimes in the indexer for a given namespace.
func (s trainingRuntimeNamespaceLister) List(selector labels.Selector) (ret []*v2alpha1.TrainingRuntime, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.TrainingRuntime))
	})
	return ret, err
}

// Get retrieves the TrainingRuntime from the indexer for a given namespace and name.
func (s trainingRuntimeNamespaceLister) Get(name string) (*v2alpha1.TrainingRuntime, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v2alpha1.Resource("trainingruntime"), name)
	}
	return obj.(*v2alpha1.TrainingRuntime), nil
}
