// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v2alpha1

import (
	v2alpha1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v2alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterTrainingRuntimeLister helps list ClusterTrainingRuntimes.
// All objects returned here must be treated as read-only.
type ClusterTrainingRuntimeLister interface {
	// List lists all ClusterTrainingRuntimes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2alpha1.ClusterTrainingRuntime, err error)
	// Get retrieves the ClusterTrainingRuntime from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2alpha1.ClusterTrainingRuntime, error)
	ClusterTrainingRuntimeListerExpansion
}

// clusterTrainingRuntimeLister implements the ClusterTrainingRuntimeLister interface.
type clusterTrainingRuntimeLister struct {
	indexer cache.Indexer
}

// NewClusterTrainingRuntimeLister returns a new ClusterTrainingRuntimeLister.
func NewClusterTrainingRuntimeLister(indexer cache.Indexer) ClusterTrainingRuntimeLister {
	return &clusterTrainingRuntimeLister{indexer: indexer}
}

// List lists all ClusterTrainingRuntimes in the indexer.
func (s *clusterTrainingRuntimeLister) List(selector labels.Selector) (ret []*v2alpha1.ClusterTrainingRuntime, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v2alpha1.ClusterTrainingRuntime))
	})
	return ret, err
}

// Get retrieves the ClusterTrainingRuntime from the index for a given name.
func (s *clusterTrainingRuntimeLister) Get(name string) (*v2alpha1.ClusterTrainingRuntime, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v2alpha1.Resource("clustertrainingruntime"), name)
	}
	return obj.(*v2alpha1.ClusterTrainingRuntime), nil
}
