// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/client/applyconfiguration/kubeflow.org/v1"
	scheme "github.com/kubeflow/training-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// XGBoostJobsGetter has a method to return a XGBoostJobInterface.
// A group's client should implement this interface.
type XGBoostJobsGetter interface {
	XGBoostJobs(namespace string) XGBoostJobInterface
}

// XGBoostJobInterface has methods to work with XGBoostJob resources.
type XGBoostJobInterface interface {
	Create(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.CreateOptions) (*v1.XGBoostJob, error)
	Update(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.UpdateOptions) (*v1.XGBoostJob, error)
	UpdateStatus(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.UpdateOptions) (*v1.XGBoostJob, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.XGBoostJob, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.XGBoostJobList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.XGBoostJob, err error)
	Apply(ctx context.Context, xGBoostJob *kubefloworgv1.XGBoostJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.XGBoostJob, err error)
	ApplyStatus(ctx context.Context, xGBoostJob *kubefloworgv1.XGBoostJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.XGBoostJob, err error)
	XGBoostJobExpansion
}

// xGBoostJobs implements XGBoostJobInterface
type xGBoostJobs struct {
	client rest.Interface
	ns     string
}

// newXGBoostJobs returns a XGBoostJobs
func newXGBoostJobs(c *KubeflowV1Client, namespace string) *xGBoostJobs {
	return &xGBoostJobs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the xGBoostJob, and returns the corresponding xGBoostJob object, and an error if there is any.
func (c *xGBoostJobs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.XGBoostJob, err error) {
	result = &v1.XGBoostJob{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of XGBoostJobs that match those selectors.
func (c *xGBoostJobs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.XGBoostJobList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.XGBoostJobList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("xgboostjobs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested xGBoostJobs.
func (c *xGBoostJobs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("xgboostjobs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a xGBoostJob and creates it.  Returns the server's representation of the xGBoostJob, and an error, if there is any.
func (c *xGBoostJobs) Create(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.CreateOptions) (result *v1.XGBoostJob, err error) {
	result = &v1.XGBoostJob{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("xgboostjobs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(xGBoostJob).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a xGBoostJob and updates it. Returns the server's representation of the xGBoostJob, and an error, if there is any.
func (c *xGBoostJobs) Update(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.UpdateOptions) (result *v1.XGBoostJob, err error) {
	result = &v1.XGBoostJob{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(xGBoostJob.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(xGBoostJob).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *xGBoostJobs) UpdateStatus(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.UpdateOptions) (result *v1.XGBoostJob, err error) {
	result = &v1.XGBoostJob{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(xGBoostJob.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(xGBoostJob).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the xGBoostJob and deletes it. Returns an error if one occurs.
func (c *xGBoostJobs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *xGBoostJobs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("xgboostjobs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched xGBoostJob.
func (c *xGBoostJobs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.XGBoostJob, err error) {
	result = &v1.XGBoostJob{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied xGBoostJob.
func (c *xGBoostJobs) Apply(ctx context.Context, xGBoostJob *kubefloworgv1.XGBoostJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.XGBoostJob, err error) {
	if xGBoostJob == nil {
		return nil, fmt.Errorf("xGBoostJob provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(xGBoostJob)
	if err != nil {
		return nil, err
	}
	name := xGBoostJob.Name
	if name == nil {
		return nil, fmt.Errorf("xGBoostJob.Name must be provided to Apply")
	}
	result = &v1.XGBoostJob{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *xGBoostJobs) ApplyStatus(ctx context.Context, xGBoostJob *kubefloworgv1.XGBoostJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.XGBoostJob, err error) {
	if xGBoostJob == nil {
		return nil, fmt.Errorf("xGBoostJob provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(xGBoostJob)
	if err != nil {
		return nil, err
	}

	name := xGBoostJob.Name
	if name == nil {
		return nil, fmt.Errorf("xGBoostJob.Name must be provided to Apply")
	}

	result = &v1.XGBoostJob{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("xgboostjobs").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
