// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/client/applyconfiguration/kubeflow.org/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeXGBoostJobs implements XGBoostJobInterface
type FakeXGBoostJobs struct {
	Fake *FakeKubeflowV1
	ns   string
}

var xgboostjobsResource = v1.SchemeGroupVersion.WithResource("xgboostjobs")

var xgboostjobsKind = v1.SchemeGroupVersion.WithKind("XGBoostJob")

// Get takes name of the xGBoostJob, and returns the corresponding xGBoostJob object, and an error if there is any.
func (c *FakeXGBoostJobs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.XGBoostJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(xgboostjobsResource, c.ns, name), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}

// List takes label and field selectors, and returns the list of XGBoostJobs that match those selectors.
func (c *FakeXGBoostJobs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.XGBoostJobList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(xgboostjobsResource, xgboostjobsKind, c.ns, opts), &v1.XGBoostJobList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.XGBoostJobList{ListMeta: obj.(*v1.XGBoostJobList).ListMeta}
	for _, item := range obj.(*v1.XGBoostJobList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested xGBoostJobs.
func (c *FakeXGBoostJobs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(xgboostjobsResource, c.ns, opts))

}

// Create takes the representation of a xGBoostJob and creates it.  Returns the server's representation of the xGBoostJob, and an error, if there is any.
func (c *FakeXGBoostJobs) Create(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.CreateOptions) (result *v1.XGBoostJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(xgboostjobsResource, c.ns, xGBoostJob), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}

// Update takes the representation of a xGBoostJob and updates it. Returns the server's representation of the xGBoostJob, and an error, if there is any.
func (c *FakeXGBoostJobs) Update(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.UpdateOptions) (result *v1.XGBoostJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(xgboostjobsResource, c.ns, xGBoostJob), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeXGBoostJobs) UpdateStatus(ctx context.Context, xGBoostJob *v1.XGBoostJob, opts metav1.UpdateOptions) (*v1.XGBoostJob, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(xgboostjobsResource, "status", c.ns, xGBoostJob), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}

// Delete takes name of the xGBoostJob and deletes it. Returns an error if one occurs.
func (c *FakeXGBoostJobs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(xgboostjobsResource, c.ns, name, opts), &v1.XGBoostJob{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeXGBoostJobs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(xgboostjobsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.XGBoostJobList{})
	return err
}

// Patch applies the patch and returns the patched xGBoostJob.
func (c *FakeXGBoostJobs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.XGBoostJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(xgboostjobsResource, c.ns, name, pt, data, subresources...), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied xGBoostJob.
func (c *FakeXGBoostJobs) Apply(ctx context.Context, xGBoostJob *kubefloworgv1.XGBoostJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.XGBoostJob, err error) {
	if xGBoostJob == nil {
		return nil, fmt.Errorf("xGBoostJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(xGBoostJob)
	if err != nil {
		return nil, err
	}
	name := xGBoostJob.Name
	if name == nil {
		return nil, fmt.Errorf("xGBoostJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(xgboostjobsResource, c.ns, *name, types.ApplyPatchType, data), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeXGBoostJobs) ApplyStatus(ctx context.Context, xGBoostJob *kubefloworgv1.XGBoostJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.XGBoostJob, err error) {
	if xGBoostJob == nil {
		return nil, fmt.Errorf("xGBoostJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(xGBoostJob)
	if err != nil {
		return nil, err
	}
	name := xGBoostJob.Name
	if name == nil {
		return nil, fmt.Errorf("xGBoostJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(xgboostjobsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1.XGBoostJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.XGBoostJob), err
}
