// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/client/applyconfiguration/kubeflow.org/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePyTorchJobs implements PyTorchJobInterface
type FakePyTorchJobs struct {
	Fake *FakeKubeflowV1
	ns   string
}

var pytorchjobsResource = v1.SchemeGroupVersion.WithResource("pytorchjobs")

var pytorchjobsKind = v1.SchemeGroupVersion.WithKind("PyTorchJob")

// Get takes name of the pyTorchJob, and returns the corresponding pyTorchJob object, and an error if there is any.
func (c *FakePyTorchJobs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.PyTorchJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(pytorchjobsResource, c.ns, name), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}

// List takes label and field selectors, and returns the list of PyTorchJobs that match those selectors.
func (c *FakePyTorchJobs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PyTorchJobList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(pytorchjobsResource, pytorchjobsKind, c.ns, opts), &v1.PyTorchJobList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.PyTorchJobList{ListMeta: obj.(*v1.PyTorchJobList).ListMeta}
	for _, item := range obj.(*v1.PyTorchJobList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested pyTorchJobs.
func (c *FakePyTorchJobs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(pytorchjobsResource, c.ns, opts))

}

// Create takes the representation of a pyTorchJob and creates it.  Returns the server's representation of the pyTorchJob, and an error, if there is any.
func (c *FakePyTorchJobs) Create(ctx context.Context, pyTorchJob *v1.PyTorchJob, opts metav1.CreateOptions) (result *v1.PyTorchJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(pytorchjobsResource, c.ns, pyTorchJob), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}

// Update takes the representation of a pyTorchJob and updates it. Returns the server's representation of the pyTorchJob, and an error, if there is any.
func (c *FakePyTorchJobs) Update(ctx context.Context, pyTorchJob *v1.PyTorchJob, opts metav1.UpdateOptions) (result *v1.PyTorchJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(pytorchjobsResource, c.ns, pyTorchJob), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePyTorchJobs) UpdateStatus(ctx context.Context, pyTorchJob *v1.PyTorchJob, opts metav1.UpdateOptions) (*v1.PyTorchJob, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(pytorchjobsResource, "status", c.ns, pyTorchJob), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}

// Delete takes name of the pyTorchJob and deletes it. Returns an error if one occurs.
func (c *FakePyTorchJobs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(pytorchjobsResource, c.ns, name, opts), &v1.PyTorchJob{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePyTorchJobs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(pytorchjobsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.PyTorchJobList{})
	return err
}

// Patch applies the patch and returns the patched pyTorchJob.
func (c *FakePyTorchJobs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PyTorchJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(pytorchjobsResource, c.ns, name, pt, data, subresources...), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied pyTorchJob.
func (c *FakePyTorchJobs) Apply(ctx context.Context, pyTorchJob *kubefloworgv1.PyTorchJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.PyTorchJob, err error) {
	if pyTorchJob == nil {
		return nil, fmt.Errorf("pyTorchJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(pyTorchJob)
	if err != nil {
		return nil, err
	}
	name := pyTorchJob.Name
	if name == nil {
		return nil, fmt.Errorf("pyTorchJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(pytorchjobsResource, c.ns, *name, types.ApplyPatchType, data), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakePyTorchJobs) ApplyStatus(ctx context.Context, pyTorchJob *kubefloworgv1.PyTorchJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.PyTorchJob, err error) {
	if pyTorchJob == nil {
		return nil, fmt.Errorf("pyTorchJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(pyTorchJob)
	if err != nil {
		return nil, err
	}
	name := pyTorchJob.Name
	if name == nil {
		return nil, fmt.Errorf("pyTorchJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(pytorchjobsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1.PyTorchJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PyTorchJob), err
}
