// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/client/applyconfiguration/kubeflow.org/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePaddleJobs implements PaddleJobInterface
type FakePaddleJobs struct {
	Fake *FakeKubeflowV1
	ns   string
}

var paddlejobsResource = v1.SchemeGroupVersion.WithResource("paddlejobs")

var paddlejobsKind = v1.SchemeGroupVersion.WithKind("PaddleJob")

// Get takes name of the paddleJob, and returns the corresponding paddleJob object, and an error if there is any.
func (c *FakePaddleJobs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.PaddleJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(paddlejobsResource, c.ns, name), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}

// List takes label and field selectors, and returns the list of PaddleJobs that match those selectors.
func (c *FakePaddleJobs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PaddleJobList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(paddlejobsResource, paddlejobsKind, c.ns, opts), &v1.PaddleJobList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.PaddleJobList{ListMeta: obj.(*v1.PaddleJobList).ListMeta}
	for _, item := range obj.(*v1.PaddleJobList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested paddleJobs.
func (c *FakePaddleJobs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(paddlejobsResource, c.ns, opts))

}

// Create takes the representation of a paddleJob and creates it.  Returns the server's representation of the paddleJob, and an error, if there is any.
func (c *FakePaddleJobs) Create(ctx context.Context, paddleJob *v1.PaddleJob, opts metav1.CreateOptions) (result *v1.PaddleJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(paddlejobsResource, c.ns, paddleJob), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}

// Update takes the representation of a paddleJob and updates it. Returns the server's representation of the paddleJob, and an error, if there is any.
func (c *FakePaddleJobs) Update(ctx context.Context, paddleJob *v1.PaddleJob, opts metav1.UpdateOptions) (result *v1.PaddleJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(paddlejobsResource, c.ns, paddleJob), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePaddleJobs) UpdateStatus(ctx context.Context, paddleJob *v1.PaddleJob, opts metav1.UpdateOptions) (*v1.PaddleJob, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(paddlejobsResource, "status", c.ns, paddleJob), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}

// Delete takes name of the paddleJob and deletes it. Returns an error if one occurs.
func (c *FakePaddleJobs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(paddlejobsResource, c.ns, name, opts), &v1.PaddleJob{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePaddleJobs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(paddlejobsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.PaddleJobList{})
	return err
}

// Patch applies the patch and returns the patched paddleJob.
func (c *FakePaddleJobs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PaddleJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(paddlejobsResource, c.ns, name, pt, data, subresources...), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied paddleJob.
func (c *FakePaddleJobs) Apply(ctx context.Context, paddleJob *kubefloworgv1.PaddleJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.PaddleJob, err error) {
	if paddleJob == nil {
		return nil, fmt.Errorf("paddleJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(paddleJob)
	if err != nil {
		return nil, err
	}
	name := paddleJob.Name
	if name == nil {
		return nil, fmt.Errorf("paddleJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(paddlejobsResource, c.ns, *name, types.ApplyPatchType, data), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakePaddleJobs) ApplyStatus(ctx context.Context, paddleJob *kubefloworgv1.PaddleJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.PaddleJob, err error) {
	if paddleJob == nil {
		return nil, fmt.Errorf("paddleJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(paddleJob)
	if err != nil {
		return nil, err
	}
	name := paddleJob.Name
	if name == nil {
		return nil, fmt.Errorf("paddleJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(paddlejobsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1.PaddleJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.PaddleJob), err
}
