// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/client/applyconfiguration/kubeflow.org/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeJAXJobs implements JAXJobInterface
type FakeJAXJobs struct {
	Fake *FakeKubeflowV1
	ns   string
}

var jaxjobsResource = v1.SchemeGroupVersion.WithResource("jaxjobs")

var jaxjobsKind = v1.SchemeGroupVersion.WithKind("JAXJob")

// Get takes name of the jAXJob, and returns the corresponding jAXJob object, and an error if there is any.
func (c *FakeJAXJobs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.JAXJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(jaxjobsResource, c.ns, name), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}

// List takes label and field selectors, and returns the list of JAXJobs that match those selectors.
func (c *FakeJAXJobs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.JAXJobList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(jaxjobsResource, jaxjobsKind, c.ns, opts), &v1.JAXJobList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.JAXJobList{ListMeta: obj.(*v1.JAXJobList).ListMeta}
	for _, item := range obj.(*v1.JAXJobList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested jAXJobs.
func (c *FakeJAXJobs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(jaxjobsResource, c.ns, opts))

}

// Create takes the representation of a jAXJob and creates it.  Returns the server's representation of the jAXJob, and an error, if there is any.
func (c *FakeJAXJobs) Create(ctx context.Context, jAXJob *v1.JAXJob, opts metav1.CreateOptions) (result *v1.JAXJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(jaxjobsResource, c.ns, jAXJob), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}

// Update takes the representation of a jAXJob and updates it. Returns the server's representation of the jAXJob, and an error, if there is any.
func (c *FakeJAXJobs) Update(ctx context.Context, jAXJob *v1.JAXJob, opts metav1.UpdateOptions) (result *v1.JAXJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(jaxjobsResource, c.ns, jAXJob), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeJAXJobs) UpdateStatus(ctx context.Context, jAXJob *v1.JAXJob, opts metav1.UpdateOptions) (*v1.JAXJob, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(jaxjobsResource, "status", c.ns, jAXJob), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}

// Delete takes name of the jAXJob and deletes it. Returns an error if one occurs.
func (c *FakeJAXJobs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(jaxjobsResource, c.ns, name, opts), &v1.JAXJob{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeJAXJobs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(jaxjobsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.JAXJobList{})
	return err
}

// Patch applies the patch and returns the patched jAXJob.
func (c *FakeJAXJobs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.JAXJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(jaxjobsResource, c.ns, name, pt, data, subresources...), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied jAXJob.
func (c *FakeJAXJobs) Apply(ctx context.Context, jAXJob *kubefloworgv1.JAXJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.JAXJob, err error) {
	if jAXJob == nil {
		return nil, fmt.Errorf("jAXJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(jAXJob)
	if err != nil {
		return nil, err
	}
	name := jAXJob.Name
	if name == nil {
		return nil, fmt.Errorf("jAXJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(jaxjobsResource, c.ns, *name, types.ApplyPatchType, data), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeJAXJobs) ApplyStatus(ctx context.Context, jAXJob *kubefloworgv1.JAXJobApplyConfiguration, opts metav1.ApplyOptions) (result *v1.JAXJob, err error) {
	if jAXJob == nil {
		return nil, fmt.Errorf("jAXJob provided to Apply must not be nil")
	}
	data, err := json.Marshal(jAXJob)
	if err != nil {
		return nil, err
	}
	name := jAXJob.Name
	if name == nil {
		return nil, fmt.Errorf("jAXJob.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(jaxjobsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &v1.JAXJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.JAXJob), err
}
