// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v2alpha1

// TorchMLPolicySourceApplyConfiguration represents an declarative configuration of the TorchMLPolicySource type for use
// with apply.
type TorchMLPolicySourceApplyConfiguration struct {
	NumProcPerNode *string                               `json:"numProcPerNode,omitempty"`
	ElasticPolicy  *TorchElasticPolicyApplyConfiguration `json:"elasticPolicy,omitempty"`
}

// TorchMLPolicySourceApplyConfiguration constructs an declarative configuration of the TorchMLPolicySource type for use with
// apply.
func TorchMLPolicySource() *TorchMLPolicySourceApplyConfiguration {
	return &TorchMLPolicySourceApplyConfiguration{}
}

// WithNumProcPerNode sets the NumProcPerNode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NumProcPerNode field is set to the value of the last call.
func (b *TorchMLPolicySourceApplyConfiguration) WithNumProcPerNode(value string) *TorchMLPolicySourceApplyConfiguration {
	b.NumProcPerNode = &value
	return b
}

// WithElasticPolicy sets the ElasticPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ElasticPolicy field is set to the value of the last call.
func (b *TorchMLPolicySourceApplyConfiguration) WithElasticPolicy(value *TorchElasticPolicyApplyConfiguration) *TorchMLPolicySourceApplyConfiguration {
	b.ElasticPolicy = value
	return b
}
