// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v2alpha1

import (
	v1 "k8s.io/api/core/v1"
)

// ContainerOverrideApplyConfiguration represents an declarative configuration of the ContainerOverride type for use
// with apply.
type ContainerOverrideApplyConfiguration struct {
	Name         *string            `json:"name,omitempty"`
	Command      []string           `json:"command,omitempty"`
	Args         []string           `json:"args,omitempty"`
	Env          []v1.EnvVar        `json:"env,omitempty"`
	EnvFrom      []v1.EnvFromSource `json:"envFrom,omitempty"`
	VolumeMounts []v1.VolumeMount   `json:"volumeMounts,omitempty"`
}

// ContainerOverrideApplyConfiguration constructs an declarative configuration of the ContainerOverride type for use with
// apply.
func ContainerOverride() *ContainerOverrideApplyConfiguration {
	return &ContainerOverrideApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ContainerOverrideApplyConfiguration) WithName(value string) *ContainerOverrideApplyConfiguration {
	b.Name = &value
	return b
}

// WithCommand adds the given value to the Command field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Command field.
func (b *ContainerOverrideApplyConfiguration) WithCommand(values ...string) *ContainerOverrideApplyConfiguration {
	for i := range values {
		b.Command = append(b.Command, values[i])
	}
	return b
}

// WithArgs adds the given value to the Args field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Args field.
func (b *ContainerOverrideApplyConfiguration) WithArgs(values ...string) *ContainerOverrideApplyConfiguration {
	for i := range values {
		b.Args = append(b.Args, values[i])
	}
	return b
}

// WithEnv adds the given value to the Env field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Env field.
func (b *ContainerOverrideApplyConfiguration) WithEnv(values ...v1.EnvVar) *ContainerOverrideApplyConfiguration {
	for i := range values {
		b.Env = append(b.Env, values[i])
	}
	return b
}

// WithEnvFrom adds the given value to the EnvFrom field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EnvFrom field.
func (b *ContainerOverrideApplyConfiguration) WithEnvFrom(values ...v1.EnvFromSource) *ContainerOverrideApplyConfiguration {
	for i := range values {
		b.EnvFrom = append(b.EnvFrom, values[i])
	}
	return b
}

// WithVolumeMounts adds the given value to the VolumeMounts field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumeMounts field.
func (b *ContainerOverrideApplyConfiguration) WithVolumeMounts(values ...v1.VolumeMount) *ContainerOverrideApplyConfiguration {
	for i := range values {
		b.VolumeMounts = append(b.VolumeMounts, values[i])
	}
	return b
}
