// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
)

// TFJobSpecApplyConfiguration represents an declarative configuration of the TFJobSpec type for use
// with apply.
type TFJobSpecApplyConfiguration struct {
	RunPolicy           *RunPolicyApplyConfiguration                             `json:"runPolicy,omitempty"`
	SuccessPolicy       *kubefloworgv1.SuccessPolicy                             `json:"successPolicy,omitempty"`
	TFReplicaSpecs      map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec `json:"tfReplicaSpecs,omitempty"`
	EnableDynamicWorker *bool                                                    `json:"enableDynamicWorker,omitempty"`
}

// TFJobSpecApplyConfiguration constructs an declarative configuration of the TFJobSpec type for use with
// apply.
func TFJobSpec() *TFJobSpecApplyConfiguration {
	return &TFJobSpecApplyConfiguration{}
}

// WithRunPolicy sets the RunPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RunPolicy field is set to the value of the last call.
func (b *TFJobSpecApplyConfiguration) WithRunPolicy(value *RunPolicyApplyConfiguration) *TFJobSpecApplyConfiguration {
	b.RunPolicy = value
	return b
}

// WithSuccessPolicy sets the SuccessPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SuccessPolicy field is set to the value of the last call.
func (b *TFJobSpecApplyConfiguration) WithSuccessPolicy(value kubefloworgv1.SuccessPolicy) *TFJobSpecApplyConfiguration {
	b.SuccessPolicy = &value
	return b
}

// WithTFReplicaSpecs puts the entries into the TFReplicaSpecs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the TFReplicaSpecs field,
// overwriting an existing map entries in TFReplicaSpecs field with the same key.
func (b *TFJobSpecApplyConfiguration) WithTFReplicaSpecs(entries map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec) *TFJobSpecApplyConfiguration {
	if b.TFReplicaSpecs == nil && len(entries) > 0 {
		b.TFReplicaSpecs = make(map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec, len(entries))
	}
	for k, v := range entries {
		b.TFReplicaSpecs[k] = v
	}
	return b
}

// WithEnableDynamicWorker sets the EnableDynamicWorker field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EnableDynamicWorker field is set to the value of the last call.
func (b *TFJobSpecApplyConfiguration) WithEnableDynamicWorker(value bool) *TFJobSpecApplyConfiguration {
	b.EnableDynamicWorker = &value
	return b
}
