// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
)

// PaddleJobSpecApplyConfiguration represents an declarative configuration of the PaddleJobSpec type for use
// with apply.
type PaddleJobSpecApplyConfiguration struct {
	RunPolicy          *RunPolicyApplyConfiguration                             `json:"runPolicy,omitempty"`
	ElasticPolicy      *PaddleElasticPolicyApplyConfiguration                   `json:"elasticPolicy,omitempty"`
	PaddleReplicaSpecs map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec `json:"paddleReplicaSpecs,omitempty"`
}

// PaddleJobSpecApplyConfiguration constructs an declarative configuration of the PaddleJobSpec type for use with
// apply.
func PaddleJobSpec() *PaddleJobSpecApplyConfiguration {
	return &PaddleJobSpecApplyConfiguration{}
}

// WithRunPolicy sets the RunPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RunPolicy field is set to the value of the last call.
func (b *PaddleJobSpecApplyConfiguration) WithRunPolicy(value *RunPolicyApplyConfiguration) *PaddleJobSpecApplyConfiguration {
	b.RunPolicy = value
	return b
}

// WithElasticPolicy sets the ElasticPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ElasticPolicy field is set to the value of the last call.
func (b *PaddleJobSpecApplyConfiguration) WithElasticPolicy(value *PaddleElasticPolicyApplyConfiguration) *PaddleJobSpecApplyConfiguration {
	b.ElasticPolicy = value
	return b
}

// WithPaddleReplicaSpecs puts the entries into the PaddleReplicaSpecs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the PaddleReplicaSpecs field,
// overwriting an existing map entries in PaddleReplicaSpecs field with the same key.
func (b *PaddleJobSpecApplyConfiguration) WithPaddleReplicaSpecs(entries map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec) *PaddleJobSpecApplyConfiguration {
	if b.PaddleReplicaSpecs == nil && len(entries) > 0 {
		b.PaddleReplicaSpecs = make(map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec, len(entries))
	}
	for k, v := range entries {
		b.PaddleReplicaSpecs[k] = v
	}
	return b
}
