// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v2 "k8s.io/api/autoscaling/v2"
)

// PaddleElasticPolicyApplyConfiguration represents an declarative configuration of the PaddleElasticPolicy type for use
// with apply.
type PaddleElasticPolicyApplyConfiguration struct {
	MinReplicas *int32          `json:"minReplicas,omitempty"`
	MaxReplicas *int32          `json:"maxReplicas,omitempty"`
	MaxRestarts *int32          `json:"maxRestarts,omitempty"`
	Metrics     []v2.MetricSpec `json:"metrics,omitempty"`
}

// PaddleElasticPolicyApplyConfiguration constructs an declarative configuration of the PaddleElasticPolicy type for use with
// apply.
func PaddleElasticPolicy() *PaddleElasticPolicyApplyConfiguration {
	return &PaddleElasticPolicyApplyConfiguration{}
}

// WithMinReplicas sets the MinReplicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinReplicas field is set to the value of the last call.
func (b *PaddleElasticPolicyApplyConfiguration) WithMinReplicas(value int32) *PaddleElasticPolicyApplyConfiguration {
	b.MinReplicas = &value
	return b
}

// WithMaxReplicas sets the MaxReplicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxReplicas field is set to the value of the last call.
func (b *PaddleElasticPolicyApplyConfiguration) WithMaxReplicas(value int32) *PaddleElasticPolicyApplyConfiguration {
	b.MaxReplicas = &value
	return b
}

// WithMaxRestarts sets the MaxRestarts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxRestarts field is set to the value of the last call.
func (b *PaddleElasticPolicyApplyConfiguration) WithMaxRestarts(value int32) *PaddleElasticPolicyApplyConfiguration {
	b.MaxRestarts = &value
	return b
}

// WithMetrics adds the given value to the Metrics field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Metrics field.
func (b *PaddleElasticPolicyApplyConfiguration) WithMetrics(values ...v2.MetricSpec) *PaddleElasticPolicyApplyConfiguration {
	for i := range values {
		b.Metrics = append(b.Metrics, values[i])
	}
	return b
}
