// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
)

// MPIJobSpecApplyConfiguration represents an declarative configuration of the MPIJobSpec type for use
// with apply.
type MPIJobSpecApplyConfiguration struct {
	SlotsPerWorker  *int32                             `json:"slotsPerWorker,omitempty"`
	CleanPodPolicy  *v1.CleanPodPolicy                 `json:"cleanPodPolicy,omitempty"`
	MPIReplicaSpecs map[v1.ReplicaType]*v1.ReplicaSpec `json:"mpiReplicaSpecs,omitempty"`
	MainContainer   *string                            `json:"mainContainer,omitempty"`
	RunPolicy       *RunPolicyApplyConfiguration       `json:"runPolicy,omitempty"`
}

// MPIJobSpecApplyConfiguration constructs an declarative configuration of the MPIJobSpec type for use with
// apply.
func MPIJobSpec() *MPIJobSpecApplyConfiguration {
	return &MPIJobSpecApplyConfiguration{}
}

// WithSlotsPerWorker sets the SlotsPerWorker field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SlotsPerWorker field is set to the value of the last call.
func (b *MPIJobSpecApplyConfiguration) WithSlotsPerWorker(value int32) *MPIJobSpecApplyConfiguration {
	b.SlotsPerWorker = &value
	return b
}

// WithCleanPodPolicy sets the CleanPodPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CleanPodPolicy field is set to the value of the last call.
func (b *MPIJobSpecApplyConfiguration) WithCleanPodPolicy(value v1.CleanPodPolicy) *MPIJobSpecApplyConfiguration {
	b.CleanPodPolicy = &value
	return b
}

// WithMPIReplicaSpecs puts the entries into the MPIReplicaSpecs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the MPIReplicaSpecs field,
// overwriting an existing map entries in MPIReplicaSpecs field with the same key.
func (b *MPIJobSpecApplyConfiguration) WithMPIReplicaSpecs(entries map[v1.ReplicaType]*v1.ReplicaSpec) *MPIJobSpecApplyConfiguration {
	if b.MPIReplicaSpecs == nil && len(entries) > 0 {
		b.MPIReplicaSpecs = make(map[v1.ReplicaType]*v1.ReplicaSpec, len(entries))
	}
	for k, v := range entries {
		b.MPIReplicaSpecs[k] = v
	}
	return b
}

// WithMainContainer sets the MainContainer field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MainContainer field is set to the value of the last call.
func (b *MPIJobSpecApplyConfiguration) WithMainContainer(value string) *MPIJobSpecApplyConfiguration {
	b.MainContainer = &value
	return b
}

// WithRunPolicy sets the RunPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RunPolicy field is set to the value of the last call.
func (b *MPIJobSpecApplyConfiguration) WithRunPolicy(value *RunPolicyApplyConfiguration) *MPIJobSpecApplyConfiguration {
	b.RunPolicy = value
	return b
}
