// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	kubefloworgv1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
)

// JAXJobSpecApplyConfiguration represents an declarative configuration of the JAXJobSpec type for use
// with apply.
type JAXJobSpecApplyConfiguration struct {
	RunPolicy       *RunPolicyApplyConfiguration                             `json:"runPolicy,omitempty"`
	JAXReplicaSpecs map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec `json:"jaxReplicaSpecs,omitempty"`
}

// JAXJobSpecApplyConfiguration constructs an declarative configuration of the JAXJobSpec type for use with
// apply.
func JAXJobSpec() *JAXJobSpecApplyConfiguration {
	return &JAXJobSpecApplyConfiguration{}
}

// WithRunPolicy sets the RunPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RunPolicy field is set to the value of the last call.
func (b *JAXJobSpecApplyConfiguration) WithRunPolicy(value *RunPolicyApplyConfiguration) *JAXJobSpecApplyConfiguration {
	b.RunPolicy = value
	return b
}

// WithJAXReplicaSpecs puts the entries into the JAXReplicaSpecs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the JAXReplicaSpecs field,
// overwriting an existing map entries in JAXReplicaSpecs field with the same key.
func (b *JAXJobSpecApplyConfiguration) WithJAXReplicaSpecs(entries map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec) *JAXJobSpecApplyConfiguration {
	if b.JAXReplicaSpecs == nil && len(entries) > 0 {
		b.JAXReplicaSpecs = make(map[kubefloworgv1.ReplicaType]*kubefloworgv1.ReplicaSpec, len(entries))
	}
	for k, v := range entries {
		b.JAXReplicaSpecs[k] = v
	}
	return b
}
