// Copyright 2024 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/kubeflow/training-operator/pkg/apis/kubeflow.org/v1"
	v2 "k8s.io/api/autoscaling/v2"
)

// ElasticPolicyApplyConfiguration represents an declarative configuration of the ElasticPolicy type for use
// with apply.
type ElasticPolicyApplyConfiguration struct {
	MinReplicas  *int32                       `json:"minReplicas,omitempty"`
	MaxReplicas  *int32                       `json:"maxReplicas,omitempty"`
	RDZVBackend  *v1.RDZVBackend              `json:"rdzvBackend,omitempty"`
	RDZVPort     *int32                       `json:"rdzvPort,omitempty"`
	RDZVHost     *string                      `json:"rdzvHost,omitempty"`
	RDZVID       *string                      `json:"rdzvId,omitempty"`
	RDZVConf     []RDZVConfApplyConfiguration `json:"rdzvConf,omitempty"`
	Standalone   *bool                        `json:"standalone,omitempty"`
	NProcPerNode *int32                       `json:"nProcPerNode,omitempty"`
	MaxRestarts  *int32                       `json:"maxRestarts,omitempty"`
	Metrics      []v2.MetricSpec              `json:"metrics,omitempty"`
}

// ElasticPolicyApplyConfiguration constructs an declarative configuration of the ElasticPolicy type for use with
// apply.
func ElasticPolicy() *ElasticPolicyApplyConfiguration {
	return &ElasticPolicyApplyConfiguration{}
}

// WithMinReplicas sets the MinReplicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinReplicas field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithMinReplicas(value int32) *ElasticPolicyApplyConfiguration {
	b.MinReplicas = &value
	return b
}

// WithMaxReplicas sets the MaxReplicas field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxReplicas field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithMaxReplicas(value int32) *ElasticPolicyApplyConfiguration {
	b.MaxReplicas = &value
	return b
}

// WithRDZVBackend sets the RDZVBackend field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RDZVBackend field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithRDZVBackend(value v1.RDZVBackend) *ElasticPolicyApplyConfiguration {
	b.RDZVBackend = &value
	return b
}

// WithRDZVPort sets the RDZVPort field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RDZVPort field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithRDZVPort(value int32) *ElasticPolicyApplyConfiguration {
	b.RDZVPort = &value
	return b
}

// WithRDZVHost sets the RDZVHost field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RDZVHost field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithRDZVHost(value string) *ElasticPolicyApplyConfiguration {
	b.RDZVHost = &value
	return b
}

// WithRDZVID sets the RDZVID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RDZVID field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithRDZVID(value string) *ElasticPolicyApplyConfiguration {
	b.RDZVID = &value
	return b
}

// WithRDZVConf adds the given value to the RDZVConf field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RDZVConf field.
func (b *ElasticPolicyApplyConfiguration) WithRDZVConf(values ...*RDZVConfApplyConfiguration) *ElasticPolicyApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRDZVConf")
		}
		b.RDZVConf = append(b.RDZVConf, *values[i])
	}
	return b
}

// WithStandalone sets the Standalone field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Standalone field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithStandalone(value bool) *ElasticPolicyApplyConfiguration {
	b.Standalone = &value
	return b
}

// WithNProcPerNode sets the NProcPerNode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NProcPerNode field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithNProcPerNode(value int32) *ElasticPolicyApplyConfiguration {
	b.NProcPerNode = &value
	return b
}

// WithMaxRestarts sets the MaxRestarts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxRestarts field is set to the value of the last call.
func (b *ElasticPolicyApplyConfiguration) WithMaxRestarts(value int32) *ElasticPolicyApplyConfiguration {
	b.MaxRestarts = &value
	return b
}

// WithMetrics adds the given value to the Metrics field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Metrics field.
func (b *ElasticPolicyApplyConfiguration) WithMetrics(values ...v2.MetricSpec) *ElasticPolicyApplyConfiguration {
	for i := range values {
		b.Metrics = append(b.Metrics, values[i])
	}
	return b
}
